"use strict";

(() => {
    
    var forms = document.getElementsByClassName('mauticform_wrapper');
    var processedForms = [];

    const observer = new MutationObserver(() => {
        for (let form of forms) {
            if (processedForms.includes(form.id)) {
                continue;
            }

            updateForm(form);
            processedForms.push(form)
        }
    });

    observer.observe(document.body, {
        childList: true,
        subtree: true,
    });

    function updateForm(form) {    
        const breakRows = form.querySelectorAll('[class*="mf-col-"].mf-break');
        breakRows.forEach(row => {
            console.log(row);
            row.classList.remove('mf-break');
            row.insertAdjacentHTML('beforebegin', '<div class="mf-break"></div>');
        });
    }

})();
