<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Tests/Functional/Entity/CommonRepositoryUpsertTest.php */
class __TwigTemplate_7b65f8b74df6ca488094897c06986a7c extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\CoreBundle\\Tests\\Functional\\Entity;

use Mautic\\CoreBundle\\Entity\\IpAddress;
use Mautic\\CoreBundle\\Entity\\IpAddressRepository;
use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;

class CommonRepositoryUpsertTest extends MauticMysqlTestCase
{
    protected function beforeBeginTransaction(): void
    {
        \$this->connection->executeStatement('ALTER TABLE '.MAUTIC_TABLE_PREFIX.'ip_addresses ADD UNIQUE INDEX idx_ip_address (ip_address)');
    }

    protected function afterRollback(): void
    {
        \$this->connection->executeStatement('ALTER TABLE '.MAUTIC_TABLE_PREFIX.'ip_addresses DROP INDEX idx_ip_address');
    }

    public function testUpsert(): void
    {
        // Insert twice, to get two insert IDs, and then insert the first one again to trigger update, and check insert ID
        /** @var IpAddressRepository \$ipAddressRepository */
        \$ipAddressRepository = \$this->getContainer()->get(IpAddressRepository::class);
        \$ipAddress1          = new IpAddress('10.10.10.10');
        \$ipAddressRepository->upsert(\$ipAddress1);
        \$this->assertNotEmpty(\$ipAddress1->getId());
        \$ipAddress2 = new IpAddress('10.10.10.11');
        \$ipAddressRepository->upsert(\$ipAddress2);
        \$this->assertNotEmpty(\$ipAddress2->getId());
        \$ipAddress3 = new IpAddress('10.10.10.10');
        \$ipAddressRepository->upsert(\$ipAddress3);
        \$this->assertEquals(\$ipAddress1->getId(), \$ipAddress3->getId());
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Tests/Functional/Entity/CommonRepositoryUpsertTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Tests/Functional/Entity/CommonRepositoryUpsertTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/CoreBundle/Tests/Functional/Entity/CommonRepositoryUpsertTest.php");
    }
}
