<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/PointBundle/Tests/Controller/TriggerControllerTest.php */
class __TwigTemplate_c22a794092b74b547975014761ffa17a extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\PointBundle\\Tests\\Controller;

use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use Mautic\\PointBundle\\Model\\TriggerModel;
use Mautic\\PointBundle\\Tests\\Functional\\TriggerTrait;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\HttpFoundation\\Response;

final class TriggerControllerTest extends MauticMysqlTestCase
{
    use TriggerTrait;

    public function testIndexActionWithoutPage(): void
    {
        \$this->client->request(Request::METHOD_GET, '/s/points/triggers');

        \$this->assertEquals(Response::HTTP_OK, \$this->client->getResponse()->getStatusCode());
    }

    public function testIndexActionWithPage(): void
    {
        \$this->client->request(Request::METHOD_GET, '/s/points/triggers/1');

        \$this->assertEquals(Response::HTTP_OK, \$this->client->getResponse()->getStatusCode());
    }

    public function testCloneAction(): void
    {
        /** @var TriggerModel \$triggerModel */
        \$triggerModel = self::getContainer()->get('mautic.point.model.trigger');

        \$triggerRepo      = \$triggerModel->getRepository();
        \$triggerEventRepo = \$triggerModel->getEventRepository();

        \$trigger = \$this->createTrigger('Trigger', 5);
        \$this->createAddTagEvent('tag1', \$trigger);
        \$this->createAddTagEvent('tag2', \$trigger);

        \$this->em->flush();
        \$this->em->clear();

        \$this->assertCount(1, \$triggerRepo->findAll());
        \$this->assertCount(2, \$triggerEventRepo->findAll());

        \$crawler = \$this->client->request(Request::METHOD_GET, '/s/points/triggers/clone/'.\$trigger->getId());
        \$this->assertTrue(\$this->client->getResponse()->isOk(), \$this->client->getResponse()->getContent());

        \$form    = \$crawler->selectButton('Save')->form();
        \$this->client->submit(\$form);

        \$this->assertCount(2, \$triggerRepo->findAll());
        \$this->assertCount(4, \$triggerEventRepo->findAll());
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/PointBundle/Tests/Controller/TriggerControllerTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/PointBundle/Tests/Controller/TriggerControllerTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/PointBundle/Tests/Controller/TriggerControllerTest.php");
    }
}
