<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Tests/Unit/Controller/AbstractFormControllerTest.php */
class __TwigTemplate_a4cc71e78d97f29d7834905998f931bb extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\CoreBundle\\Tests\\Unit\\Controller;

use Doctrine\\Persistence\\ManagerRegistry;
use Mautic\\CoreBundle\\Controller\\AbstractFormController;
use Mautic\\CoreBundle\\Factory\\MauticFactory;
use Mautic\\CoreBundle\\Factory\\ModelFactory;
use Mautic\\CoreBundle\\Helper\\CoreParametersHelper;
use Mautic\\CoreBundle\\Helper\\UserHelper;
use Mautic\\CoreBundle\\Security\\Permissions\\CorePermissions;
use Mautic\\CoreBundle\\Service\\FlashBag;
use Mautic\\CoreBundle\\Translation\\Translator;
use Symfony\\Component\\EventDispatcher\\EventDispatcherInterface;
use Symfony\\Component\\Form\\Form;
use Symfony\\Component\\HttpFoundation\\InputBag;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\HttpFoundation\\RequestStack;

class AbstractFormControllerTest extends \\PHPUnit\\Framework\\TestCase
{
    /**
     * @var \\PHPUnit\\Framework\\MockObject\\MockObject|AbstractFormController
     */
    private AbstractFormController \$classFromAbstractFormController;

    /**
     * @var \\PHPUnit\\Framework\\MockObject\\MockObject|Form
     */
    private \\PHPUnit\\Framework\\MockObject\\MockObject \$formMock;

    private RequestStack \$requestStack;

    /**
     * Create a new instance from the AbstractFormController Class and creates mocks.
     */
    protected function setUp(): void
    {
        \$doctrine             = \$this->createMock(ManagerRegistry::class);
        \$factory              = \$this->createMock(MauticFactory::class);
        \$modelFactory         = \$this->createMock(ModelFactory::class);
        \$userHelper           = \$this->createMock(UserHelper::class);
        \$coreParametersHelper = \$this->createMock(CoreParametersHelper::class);
        \$dispatcher           = \$this->createMock(EventDispatcherInterface::class);
        \$translator           = \$this->createMock(Translator::class);
        \$flashBag             = \$this->createMock(FlashBag::class);
        \$this->requestStack   = new RequestStack();
        \$security             = \$this->createMock(CorePermissions::class);

        \$this->classFromAbstractFormController = new class(\$doctrine, \$factory, \$modelFactory, \$userHelper, \$coreParametersHelper, \$dispatcher, \$translator, \$flashBag, \$this->requestStack, \$security) extends AbstractFormController {
            public function returnIsFormCancelled(Form \$form): bool
            {
                return \$this->isFormCancelled(\$form);
            }
        };
        \$this->formMock             = \$this->createMock(Form::class);
    }

    /**
     * Test to send a Form that does not have an array representation in request.
     */
    public function testIsFormCancelledWhenFormArrayNull(): void
    {
        \$this->prepareRequestStack(['company' => null]);

        \$this->formMock->method('getName')
            ->willReturn('company');
        \$isFormCancelled = \$this->classFromAbstractFormController->returnIsFormCancelled(\$this->formMock);
        \$this->assertFalse(\$isFormCancelled);
    }

    /**
     * Test to send a Form that has an array representation in request. And the cancel button was clicked.
     */
    public function testIsFormCancelledWhenCancelled(): void
    {
        \$this->prepareRequestStack(['company_merge' => ['buttons' => ['cancel' => null]]]);

        \$this->formMock->method('getName')
            ->willReturn('company_merge');
        \$isFormCancelled = \$this->classFromAbstractFormController->returnIsFormCancelled(\$this->formMock);
        \$this->assertTrue(\$isFormCancelled);
    }

    /**
     * Test to send a Form that has an array representation in request. And the submit button was clicked.
     */
    public function testIsFormCancelledWhenNotCancelled(): void
    {
        \$this->prepareRequestStack(['company_merge' => ['buttons' => ['submit' => null]]]);

        \$this->formMock->method('getName')
            ->willReturn('company_merge');
        \$isFormCancelled = \$this->classFromAbstractFormController->returnIsFormCancelled(\$this->formMock);
        \$this->assertFalse(\$isFormCancelled);
    }

    private function prepareRequestStack(mixed \$inputBagParameters): void
    {
        \$requestMock          = \$this->createMock(Request::class);
        \$requestMock->request = new InputBag(\$inputBagParameters);
        \$this->requestStack->push(\$requestMock);
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Tests/Unit/Controller/AbstractFormControllerTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Tests/Unit/Controller/AbstractFormControllerTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/CoreBundle/Tests/Unit/Controller/AbstractFormControllerTest.php");
    }
}
