<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/EmailBundle/Tests/Model/EmailActionModelTest.php */
class __TwigTemplate_cdbfedd32cbe03bdb032ab88afff003d extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\EmailBundle\\Tests\\Model;

use Mautic\\CategoryBundle\\Entity\\Category;
use Mautic\\CoreBundle\\Security\\Permissions\\CorePermissions;
use Mautic\\EmailBundle\\Entity\\Email;
use Mautic\\EmailBundle\\Entity\\EmailRepository;
use Mautic\\EmailBundle\\Model\\EmailActionModel;
use Mautic\\EmailBundle\\Model\\EmailModel;
use PHPUnit\\Framework\\MockObject\\MockObject;
use PHPUnit\\Framework\\TestCase;

class EmailActionModelTest extends TestCase
{
    public const NEW_CATEGORY_TITLE = 'New category';
    public const OLD_CATEGORY_TITLE = 'Old category';

    /**
     * @var MockObject&EmailModel
     */
    private MockObject \$emailModelMock;

    /**
     * @var MockObject&EmailRepository
     */
    private MockObject \$emailRepositoryMock;

    /**
     * @var MockObject&CorePermissions
     */
    private MockObject \$corePermissionsMock;

    private EmailActionModel \$emailActionModel;

    protected function setUp(): void
    {
        parent::setUp();

        \$this->emailModelMock      = \$this->createMock(EmailModel::class);
        \$this->emailRepositoryMock = \$this->createMock(EmailRepository::class);
        \$this->corePermissionsMock = \$this->createMock(CorePermissions::class);
        \$this->emailActionModel    = new EmailActionModel(
            \$this->emailModelMock,
            \$this->emailRepositoryMock,
            \$this->corePermissionsMock
        );
    }

    public function testSetsNewCategoryForEditableEmails(): void
    {
        \$oldCategory = new Category();
        \$oldCategory->setTitle(self::OLD_CATEGORY_TITLE);

        \$newCategory = new Category();
        \$newCategory->setTitle(self::NEW_CATEGORY_TITLE);

        \$emails = \$this->buildEmailsWithCategory(\$oldCategory, 3);
        \$this->configureRepositoryToReturn(\$emails);
        \$this->configurePermissionToAllowEdition(true);
        \$this->configureModelToSave(\$emails);

        \$this->tryToSetCategory(\$emails, \$newCategory);

        foreach (\$emails as \$email) {
            \$this->assertEquals(\$email->getCategory(), \$newCategory);
        }
    }

    public function testDoesntSetNewCategoryForNonEditableEmails(): void
    {
        \$oldCategory = new Category();
        \$oldCategory->setTitle(self::OLD_CATEGORY_TITLE);

        \$newCategory = new Category();
        \$newCategory->setTitle(self::NEW_CATEGORY_TITLE);

        \$emails = \$this->buildEmailsWithCategory(\$oldCategory, 5);
        \$this->configureRepositoryToReturn(\$emails);
        \$this->configurePermissionToAllowEdition(false);
        \$this->tryToSetCategory(\$emails, \$newCategory);

        foreach (\$emails as \$email) {
            \$this->assertEquals(\$email->getCategory(), \$oldCategory);
        }
    }

    /**
     * @return array<Email>
     */
    private function buildEmailsWithCategory(Category \$category, int \$quantity): array
    {
        \$emails = [];

        for (\$i = 0; \$i < \$quantity; ++\$i) {
            \$email = new Email();
            \$email->setId(\$i);
            \$email->setCategory(\$category);
            \$emails[] = \$email;
        }

        return \$emails;
    }

    private function configurePermissionToAllowEdition(bool \$allow): void
    {
        \$this->corePermissionsMock
            ->method('hasEntityAccess')
            ->willReturn(\$allow);
    }

    /**
     * @param array<Email> \$emails
     */
    protected function configureRepositoryToReturn(array \$emails): void
    {
        \$this->emailRepositoryMock
            ->method('findBy')
            ->with(
                ['id' => array_map(fn (Email \$email) => \$email->getId(), \$emails)]
            )
            ->willReturn(\$emails);
    }

    /**
     * @param array<Email> \$emails
     */
    protected function configureModelToSave(array \$emails): void
    {
        \$this->emailModelMock
            ->expects(\$this->once())
            ->method('saveEntities')
            ->with(\$emails);
    }

    /**
     * @param array<Email> \$emails
     */
    protected function tryToSetCategory(array \$emails, Category \$newCategory): void
    {
        \$this->emailActionModel
            ->setCategory(
                array_map(fn (Email \$email) => \$email->getId(), \$emails),
                \$newCategory
            );
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/EmailBundle/Tests/Model/EmailActionModelTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/EmailBundle/Tests/Model/EmailActionModelTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/EmailBundle/Tests/Model/EmailActionModelTest.php");
    }
}
