<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/ChannelBundle/Tests/Command/ProcessMarketingMessagesQueueCommandFunctionalTest.php */
class __TwigTemplate_2ddc025c4c0abb158b801fd8b10d2d9e extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\ChannelBundle\\Tests\\Command;

use Mautic\\ChannelBundle\\Entity\\MessageQueue;
use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use Mautic\\CoreBundle\\Tests\\Functional\\CreateTestEntitiesTrait;
use Mautic\\EmailBundle\\Entity\\Email;
use Mautic\\EmailBundle\\Entity\\Stat;
use Mautic\\EmailBundle\\Entity\\StatRepository;
use Mautic\\LeadBundle\\Entity\\Lead;
use PHPUnit\\Framework\\Assert;

final class ProcessMarketingMessagesQueueCommandFunctionalTest extends MauticMysqlTestCase
{
    use CreateTestEntitiesTrait;

    public function testIdleCommand(): void
    {
        \$commandTester = \$this->testSymfonyCommand('mautic:messages:send');
        Assert::assertSame(0, \$commandTester->getStatusCode());
    }

    public function testCommandWithEmailQueue(): void
    {
        \$lead   = \$this->createLead('John', 'Doe', 'jd@example.com');
        \$email1 = \$this->createEmail('Test Email 1');
        \$email2 = \$this->createEmail('Test Email 2');
        \$this->em->flush();

        \$scheduledDate = new \\DateTime('-10 minutes');
        \$datePublished = new \\DateTime('-1 day');

        \$messages = [
            \$this->createMessageQueue(\$email1, \$lead, \$scheduledDate, \$datePublished),
            \$this->createMessageQueue(\$email2, \$lead, \$scheduledDate, \$datePublished),
        ];

        foreach (\$messages as \$message) {
            \$this->em->persist(\$message);
        }
        \$this->em->flush();

        \$commandTester = \$this->testSymfonyCommand('mautic:messages:send');
        Assert::assertSame(0, \$commandTester->getStatusCode());

        // Check if email stats are created for each email sent
        \$this->assertEmailStatCreated(\$email1, \$lead);
        \$this->assertEmailStatCreated(\$email2, \$lead);
    }

    private function createMessageQueue(Email \$email, Lead \$lead, \\DateTime \$scheduledDate, \\DateTime \$datePublished): MessageQueue
    {
        \$message = new MessageQueue();
        \$message->setScheduledDate(\$scheduledDate);
        \$message->setDatePublished(\$datePublished);
        \$message->setChannel('email');
        \$message->setChannelId(\$email->getId());
        \$message->setLead(\$lead);
        \$message->setPriority(MessageQueue::PRIORITY_NORMAL);
        \$message->setMaxAttempts(3);
        \$message->setAttempts(0);
        \$message->setStatus(MessageQueue::STATUS_PENDING);

        return \$message;
    }

    private function assertEmailStatCreated(Email \$email, Lead \$lead): void
    {
        /** @var StatRepository \$emailStatRepository */
        \$emailStatRepository = \$this->em->getRepository(Stat::class);

        /** @var Stat|null \$emailStat */
        \$emailStat = \$emailStatRepository->findOneBy([
            'email' => \$email->getId(),
            'lead'  => \$lead->getId(),
        ]);

        Assert::assertNotNull(\$emailStat, \"Email stat not created for email ID {\$email->getId()} and lead ID {\$lead->getId()}\");
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/ChannelBundle/Tests/Command/ProcessMarketingMessagesQueueCommandFunctionalTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/ChannelBundle/Tests/Command/ProcessMarketingMessagesQueueCommandFunctionalTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/ChannelBundle/Tests/Command/ProcessMarketingMessagesQueueCommandFunctionalTest.php");
    }
}
