<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/LeadBundle/Tests/Segment/Decorator/Date/TimezoneResolverTest.php */
class __TwigTemplate_7727d0b8c190c472989ee168ce853e78 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\LeadBundle\\Tests\\Segment\\Decorator\\Date;

use Mautic\\CoreBundle\\Helper\\CoreParametersHelper;
use Mautic\\LeadBundle\\Segment\\Decorator\\Date\\TimezoneResolver;
use PHPUnit\\Framework\\Assert;
use PHPUnit\\Framework\\TestCase;

final class TimezoneResolverTest extends TestCase
{
    /**
     * @dataProvider dataTimezones
     */
    public function testTimezones(?string \$configuredTimezone, string \$expectedTimezone): void
    {
        \$coreParametersHelper = new class(\$configuredTimezone) extends CoreParametersHelper {
            public function __construct(private ?string \$configuredTimezone)
            {
            }

            public function get(\$name, \$default = null)
            {
                Assert::assertSame('default_timezone', \$name);

                return \$this->configuredTimezone;
            }
        };

        \$timezoneResolver = new TimezoneResolver(\$coreParametersHelper);
        Assert::assertSame(
            \$expectedTimezone,
            \$timezoneResolver->getDefaultDate(false)->getDateTime()->getTimezone()->getName()
        );
    }

    /**
     * @return iterable<string, array<?string>>
     */
    public function dataTimezones(): iterable
    {
        yield 'Default timezone' => [null, 'UTC'];
        yield 'UTC timezone'     => ['UTC', 'UTC'];
        yield 'Prague timezone'  => ['Europe/Prague', 'Europe/Prague'];
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/LeadBundle/Tests/Segment/Decorator/Date/TimezoneResolverTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/LeadBundle/Tests/Segment/Decorator/Date/TimezoneResolverTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/LeadBundle/Tests/Segment/Decorator/Date/TimezoneResolverTest.php");
    }
}
