<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/PluginBundle/Tests/Helper/oAuthHelperTest.php */
class __TwigTemplate_1f964c5ec2ef9cdd6d4940cec2a492c5 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\PluginBundle\\Tests\\Helper;

use Mautic\\PluginBundle\\Helper\\oAuthHelper;
use PHPUnit\\Framework\\TestCase;

final class oAuthHelperTest extends TestCase
{
    /**
     * @param array<int, string> \$headers
     *
     * @dataProvider dataForHashSensitiveHeaderData
     */
    public function testHashSensitiveHeaderData(string \$authorization, array \$headers): void
    {
        \$hashedHeaders = oAuthHelper::sanitizeHeaderData(\$headers);

        \$this->assertStringContainsString(sprintf('Authorization: %s [REDACTED]', \$authorization), \$hashedHeaders[0]);
    }

    /**
     * @return \\Generator<string, array<int, string|array<int, string>>>
     */
    public function dataForHashSensitiveHeaderData(): \\Generator
    {
        yield 'For Bearer' => [
            'Bearer',
            [
                'Authorization: Bearer SME-ASA',
            ],
        ];

        yield 'For Basic' => [
            'Basic',
            [
                'Authorization: Basic YWxhZGRpbjpvcGVuc2VzYW1l',
            ],
        ];
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/PluginBundle/Tests/Helper/oAuthHelperTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/PluginBundle/Tests/Helper/oAuthHelperTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/PluginBundle/Tests/Helper/oAuthHelperTest.php");
    }
}
