<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @themes/mautic-template-doi.zip */
class __TwigTemplate_cfe979c5cd3fd1c2a8d128030aeac9a5 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "PK
\000\000\000\000\000e8[\000\000\000\000\000\000\000/config.json{
  \"name\": \"Cause.Buzz DOI Bestätigung\",
  \"author\": \"Cause.Buzz\",
  \"authorUrl\": \"https://cause.buzz\",
  \"description\": \"Professionelles Double Opt-In E-Mail-Template für Cause.Buzz mit Glasmorphismus-Design und blauen Akzentfarben. DSGVO-konform mit allen erforderlichen Datenschutzhinweisen.\",
  \"version\": \"1.0.0\",
  \"features\": [
    \"responsive\",
    \"glassmorphism\",
    \"dark-theme\",
    \"gdpr-compliant\"
  ],
  \"slots\": [
    {
      \"type\": \"text\",
      \"placeholder\": \"slotText\"
    },
    {
      \"type\": \"image\", 
      \"placeholder\": \"slotImage\"
    },
    {
      \"type\": \"button\",
      \"placeholder\": \"slotButton\"
    },
    {
      \"type\": \"separator\",
      \"placeholder\": \"slotSeparator\"
    }
  ]
}PK
\000\000\000\000\000e8[A<2\000\000<2\000\000\000\000\000html/message.html.twig<!DOCTYPE html>
<html lang=\"de\" xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\">
<head>
    <meta charset=\"utf-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">
    <title>E-Mail-Adresse bestätigen - Cause.Buzz</title>
    <!--[if mso]>
    <noscript>
        <xml>
            <o:OfficeDocumentSettings>
                <o:AllowPNG/>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
    </noscript>
    <![endif]-->
    <style type=\"text/css\">
        /* Reset für E-Mail-Clients */
        #outlook a { padding: 0; }
        body { margin: 0; padding: 0; width: 100% !important; min-width: 100%; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; }
        table, td { mso-table-lspace: 0pt; mso-table-rspace: 0pt; }
        img { -ms-interpolation-mode: bicubic; border: 0; height: auto; line-height: 100%; outline: none; text-decoration: none; }
        
        /* Base Styles */
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif;
            background-color: #0f172a;
            line-height: 1.6;
        }
        
        /* Container */
        .email-wrapper {
            width: 100%;
            background-color: #0f172a;
            padding: 20px 0;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #1e293b;
            border-radius: 12px;
            overflow: hidden;
            border: 1px solid #334155;
        }
        
        /* Header */
        .header {
            background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
            padding: 40px 30px;
            text-align: center;
        }
        
        .header h1 {
            margin: 0;
            color: #ffffff;
            font-size: 28px;
            font-weight: 600;
            line-height: 1.2;
        }
        
        .header .tagline {
            margin: 8px 0 0 0;
            color: rgba(255, 255, 255, 0.9);
            font-size: 16px;
        }
        
        /* Content */
        .content {
            padding: 40px 30px;
            color: #ffffff;
        }
        
        .content h2 {
            color: #60a5fa;
            font-size: 22px;
            margin: 0 0 20px 0;
            text-align: center;
        }
        
        .content p {
            color: rgba(255, 255, 255, 0.9);
            font-size: 16px;
            line-height: 1.7;
            margin: 0 0 20px 0;
        }
        
        /* Alert Box */
        .alert-box {
            background: rgba(239, 68, 68, 0.1);
            border: 2px solid #ef4444;
            border-radius: 10px;
            padding: 20px;
            margin: 25px 0;
            text-align: center;
        }
        
        .alert-icon {
            font-size: 32px;
            margin-bottom: 12px;
            display: block;
        }
        
        .alert-title {
            color: #fca5a5;
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .alert-text {
            color: rgba(255, 255, 255, 0.9);
            font-size: 14px;
            line-height: 1.5;
            margin: 0;
        }
        
        /* Confirmation Section */
        .confirmation-section {
            background: rgba(59, 130, 246, 0.1);
            border: 2px solid #3b82f6;
            border-radius: 12px;
            padding: 30px;
            margin: 30px 0;
            text-align: center;
        }
        
        .confirmation-icon {
            font-size: 48px;
            margin-bottom: 15px;
            display: block;
        }
        
        .confirmation-title {
            color: #60a5fa;
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .confirmation-text {
            color: rgba(255, 255, 255, 0.9);
            font-size: 14px;
            margin-bottom: 25px;
            line-height: 1.5;
        }
        
        .confirm-btn {
            display: inline-block;
            background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
            color: #ffffff;
            padding: 16px 40px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            font-size: 16px;
            border: 2px solid #1d4ed8;
            box-shadow: 0 4px 15px rgba(59, 130, 246, 0.3);
        }
        
        /* Info Section */
        .info-section {
            background: rgba(139, 92, 246, 0.1);
            border: 1px solid #8b5cf6;
            border-radius: 10px;
            padding: 20px;
            margin: 25px 0;
        }
        
        .info-title {
            color: #a78bfa;
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 12px;
            text-align: center;
        }
        
        .info-list {
            color: rgba(255, 255, 255, 0.8);
            font-size: 14px;
            line-height: 1.6;
            margin: 0;
            padding-left: 20px;
        }
        
        .info-list li {
            margin-bottom: 8px;
        }
        
        /* Link Box */
        .link-box {
            word-break: break-all;
            color: #60a5fa;
            font-size: 14px;
            background: rgba(59, 130, 246, 0.1);
            padding: 10px;
            border-radius: 6px;
            font-family: monospace;
        }
        
        /* Security Notice */
        .security-notice {
            background: rgba(34, 197, 94, 0.1);
            border: 1px solid #22c55e;
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            font-size: 12px;
            color: rgba(255, 255, 255, 0.8);
            text-align: center;
        }
        
        /* Footer */
        .footer {
            background-color: #0f172a;
            color: rgba(255, 255, 255, 0.7);
            padding: 30px;
            text-align: center;
            font-size: 13px;
            border-top: 1px solid #334155;
        }
        
        .footer-title {
            color: #ffffff;
            font-weight: 600;
            font-size: 16px;
            margin-bottom: 10px;
        }
        
        .footer a {
            color: #60a5fa;
            text-decoration: none;
        }
        
        .footer-legal {
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            font-size: 11px;
            line-height: 1.4;
            color: rgba(255, 255, 255, 0.6);
        }
        
        /* Mobile Responsive */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100%;
                margin: 0;
                border-radius: 0;
            }
            
            .header, .content, .footer {
                padding: 20px;
            }
            
            .header h1 {
                font-size: 24px;
            }
            
            .confirmation-section {
                padding: 20px;
            }
            
            .confirm-btn {
                display: block;
                width: 100%;
                box-sizing: border-box;
                padding: 16px 20px;
            }
        }
    </style>
</head>
<body>
    <div class=\"email-wrapper\">
        <div class=\"email-container\">
            <!-- Header -->
            <div class=\"header\">
                <h1>🚀 Cause.Buzz</h1>
                <p class=\"tagline\">E-Mail-Adresse bestätigen</p>
            </div>
            
            <!-- Content -->
            <div class=\"content\">
                <h2>🔐 Bestätigung Ihrer E-Mail-Adresse erforderlich</h2>
                
                <p><strong>Hallo ";
        // line 320
        if (CoreExtension::getAttribute($this->env, $this->source, ($context["contact"] ?? null), "firstname", [], "any", true, true, false, 320)) {
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["contact"]) || array_key_exists("contact", $context) ? $context["contact"] : (function () { throw new RuntimeError('Variable "contact" does not exist.', 320, $this->source); })()), "firstname", [], "any", false, false, false, 320), "html", null, true);
        }
        yield " ";
        if (CoreExtension::getAttribute($this->env, $this->source, ($context["contact"] ?? null), "lastname", [], "any", true, true, false, 320)) {
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["contact"]) || array_key_exists("contact", $context) ? $context["contact"] : (function () { throw new RuntimeError('Variable "contact" does not exist.', 320, $this->source); })()), "lastname", [], "any", false, false, false, 320), "html", null, true);
        }
        yield ",</strong></p>
                
                <p>vielen Dank für Ihr Interesse an Cause.Buzz! Um Ihre Anfrage bearbeiten zu können und sicherzustellen, dass Sie unsere Kommunikation erhalten möchten, müssen Sie zunächst Ihre E-Mail-Adresse bestätigen.</p>
                
                <!-- Alert Section -->
                <div class=\"alert-box\">
                    <span class=\"alert-icon\">⏰</span>
                    <div class=\"alert-title\">Wichtig: Bestätigung erforderlich</div>
                    <p class=\"alert-text\">Ohne Bestätigung können wir Ihre Anfrage nicht bearbeiten und Sie erhalten keine weiteren Informationen von uns.</p>
                </div>
                
                <!-- Confirmation Section -->
                <div class=\"confirmation-section\">
                    <span class=\"confirmation-icon\">✉️</span>
                    <div class=\"confirmation-title\">E-Mail-Adresse jetzt bestätigen</div>
                    <p class=\"confirmation-text\">Klicken Sie auf den Button unten, um Ihre E-Mail-Adresse <strong>";
        // line 335
        if (CoreExtension::getAttribute($this->env, $this->source, ($context["contact"] ?? null), "email", [], "any", true, true, false, 335)) {
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["contact"]) || array_key_exists("contact", $context) ? $context["contact"] : (function () { throw new RuntimeError('Variable "contact" does not exist.', 335, $this->source); })()), "email", [], "any", false, false, false, 335), "html", null, true);
        }
        yield "</strong> zu bestätigen und Ihre Anfrage zu aktivieren.</p>
                    
                    <a href=\"";
        // line 337
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("unsubscribe_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["unsubscribe_url"]) || array_key_exists("unsubscribe_url", $context) ? $context["unsubscribe_url"] : (function () { throw new RuntimeError('Variable "unsubscribe_url" does not exist.', 337, $this->source); })()), "https://cause.buzz/confirm")) : ("https://cause.buzz/confirm")), "html", null, true);
        yield "\" class=\"confirm-btn\">
                        ✅ E-Mail-Adresse bestätigen
                    </a>
                </div>
                
                <!-- Info Section -->
                <div class=\"info-section\">
                    <div class=\"info-title\">📋 Was passiert nach der Bestätigung?</div>
                    <ul class=\"info-list\">
                        <li>✅ Ihre Anfrage wird aktiviert und bearbeitet</li>
                        <li>📧 Sie erhalten eine Bestätigungs-E-Mail mit allen Details</li>
                        <li>🚀 Unser Team meldet sich innerhalb von 24 Stunden bei Ihnen</li>
                        <li>🔒 Ihre Daten werden DSGVO-konform auf EU-Servern verarbeitet</li>
                    </ul>
                </div>
                
                <p><strong>Alternative:</strong> Falls der Button nicht funktioniert, kopieren Sie bitte folgenden Link in Ihren Browser:</p>
                <p class=\"link-box\">
                    ";
        // line 355
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("unsubscribe_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["unsubscribe_url"]) || array_key_exists("unsubscribe_url", $context) ? $context["unsubscribe_url"] : (function () { throw new RuntimeError('Variable "unsubscribe_url" does not exist.', 355, $this->source); })()), "https://cause.buzz/confirm")) : ("https://cause.buzz/confirm")), "html", null, true);
        yield "
                </p>
                
                <!-- Security Notice -->
                <div class=\"security-notice\">
                    🔒 <strong>Datenschutz:</strong> Diese E-Mail wurde im Rahmen Ihrer Anfrage versendet. Ihre Daten werden ausschließlich zur Bearbeitung Ihrer Anfrage verwendet und nicht an Dritte weitergegeben.
                </div>
                
                <p style=\"margin-top: 30px; text-align: center; font-size: 14px;\">
                    <strong>Mit freundlichen Grüßen,<br>
                    Ihr Cause.Buzz Team</strong>
                </p>
            </div>
            
            <!-- Footer -->
            <div class=\"footer\">
                <div class=\"footer-title\">Cause.Buzz</div>
                <p>Newsletter-Tools • Marketing Automation • Meinungs-Kampagnen</p>
                
                <p style=\"margin-top: 15px; line-height: 1.4;\">
                    40 Im alten Riet, 9494 Schaan, Liechtenstein<br>
                    <a href=\"mailto:hello@cause.buzz\">hello@cause.buzz</a> • 
                    <a href=\"https://cause.buzz\">cause.buzz</a>
                </p>
                
                <div class=\"footer-legal\">
                    <strong>DSGVO-Hinweis:</strong> Diese E-Mail wurde aufgrund Ihrer Anfrage versendet. 
                    Durch die Bestätigung Ihrer E-Mail-Adresse stimmen Sie der Verarbeitung Ihrer Daten zur Bearbeitung Ihrer Anfrage zu. 
                    Sie können diese Einwilligung jederzeit widerrufen. Weitere Informationen finden Sie in unserer 
                    <a href=\"https://cause.buzz/privacy\">Datenschutzerklärung</a>.
                </div>
                
                <!-- Mautic tracking pixel -->
                ";
        // line 388
        if (array_key_exists("tracking_pixel", $context)) {
            // line 389
            yield "                    ";
            yield (isset($context["tracking_pixel"]) || array_key_exists("tracking_pixel", $context) ? $context["tracking_pixel"] : (function () { throw new RuntimeError('Variable "tracking_pixel" does not exist.', 389, $this->source); })());
            yield "
                ";
        }
        // line 391
        yield "                
                <!-- Unsubscribe link -->
                <p style=\"margin-top: 15px; font-size: 11px; color: rgba(255, 255, 255, 0.5);\">
                    Sie möchten keine E-Mails mehr erhalten? 
                    <a href=\"";
        // line 395
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["unsubscribe_url"]) || array_key_exists("unsubscribe_url", $context) ? $context["unsubscribe_url"] : (function () { throw new RuntimeError('Variable "unsubscribe_url" does not exist.', 395, $this->source); })()), "html", null, true);
        yield "\" style=\"color: #60a5fa;\">Hier abmelden</a>
                </p>
            </div>
        </div>
    </div>
</body>
</html>PK
\000\000\000\000\000e8[&\000\000&\000\000\000\000\000/thumbnail.pngdata:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASwAAAEsCAYAAAB5fY51AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAApgAAAKYB3X3/OAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAANCSURBVHic7dYxAQAACAMgtX+KPpJWqQCtZABAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFoAgWACCYAEIggUgCBaAIFgAgmABCIIFIAgWgCBYAIJgAQiCBSAIFgAAAP//AwBhZvS7cCbLXAAAAABJRU5ErkJggg==PK
\000\000\000\000\000e8[OK\000\000\000\000
\000\000\000/README.md# Cause.Buzz DOI E-Mail-Template für Mautic

## 📧 **Double Opt-In Template**

Professionelles DSGVO-konformes DOI-E-Mail-Template für Mautic mit Cause.Buzz Branding.

## 🎨 **Design Features**

- ✨ **Glasmorphismus-Effekte** mit blauen Akzentfarben
- 📱 **Vollständig responsive** für alle Geräte
- 🎯 **Cause.Buzz Branding** mit Corporate Design
- 🔒 **DSGVO-konforme Datenschutzhinweise**
- ⚠️ **Prominente Call-to-Action** für E-Mail-Bestätigung

## 📋 **Enthaltene Dateien**

- `config.json` - Template-Konfiguration für Mautic
- `html/message.html.twig` - Haupttemplate mit Twig-Syntax
- `thumbnail.png` - Vorschaubild für Mautic
- `README.md` - Diese Dokumentation

## 🚀 **Installation in Mautic**

### **Schritt 1: Template-Paket erstellen**
1. Alle Dateien in einen Ordner `causebuzz-doi-template` packen
2. Als ZIP-Archiv komprimieren: `causebuzz-doi-template.zip`

### **Schritt 2: Upload in Mautic**
1. Mautic Admin → **Themes** → **Install Theme**
2. ZIP-Datei auswählen und hochladen
3. Template aktivieren

### **Schritt 3: DOI-Kampagne einrichten**
1. **Kampagne erstellen** → DOI-Prozess konfigurieren
2. **E-Mail erstellen** → Template \"Cause.Buzz DOI\" auswählen
3. **Bestätigungs-Link** in Kampagne einrichten
4. **Testing** durchführen

## 🔧 **Mautic-Platzhalter**

Das Template nutzt diese Mautic-spezifischen Variablen:

```twig
";
        // line 447
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["contact"]) || array_key_exists("contact", $context) ? $context["contact"] : (function () { throw new RuntimeError('Variable "contact" does not exist.', 447, $this->source); })()), "firstname", [], "any", false, false, false, 447), "html", null, true);
        yield "     # Vorname des Kontakts
";
        // line 448
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["contact"]) || array_key_exists("contact", $context) ? $context["contact"] : (function () { throw new RuntimeError('Variable "contact" does not exist.', 448, $this->source); })()), "lastname", [], "any", false, false, false, 448), "html", null, true);
        yield "      # Nachname des Kontakts  
";
        // line 449
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["contact"]) || array_key_exists("contact", $context) ? $context["contact"] : (function () { throw new RuntimeError('Variable "contact" does not exist.', 449, $this->source); })()), "email", [], "any", false, false, false, 449), "html", null, true);
        yield "         # E-Mail-Adresse
";
        // line 450
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["unsubscribe_url"]) || array_key_exists("unsubscribe_url", $context) ? $context["unsubscribe_url"] : (function () { throw new RuntimeError('Variable "unsubscribe_url" does not exist.', 450, $this->source); })()), "html", null, true);
        yield "       # DOI-Bestätigungslink
";
        // line 451
        yield (isset($context["tracking_pixel"]) || array_key_exists("tracking_pixel", $context) ? $context["tracking_pixel"] : (function () { throw new RuntimeError('Variable "tracking_pixel" does not exist.', 451, $this->source); })());
        yield "    # Mautic Tracking-Pixel
```

## ⚙️ **Konfiguration**

### **DOI-Link anpassen:**
Der Bestätigungslink wird automatisch von Mautic generiert. Falls Sie einen eigenen Link verwenden möchten, ersetzen Sie:

```twig
";
        // line 460
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("unsubscribe_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["unsubscribe_url"]) || array_key_exists("unsubscribe_url", $context) ? $context["unsubscribe_url"] : (function () { throw new RuntimeError('Variable "unsubscribe_url" does not exist.', 460, $this->source); })()), "https://cause.buzz/confirm")) : ("https://cause.buzz/confirm")), "html", null, true);
        yield "
```

### **Tracking aktivieren:**
Das Template enthält bereits Mautic-Tracking:
- Tracking-Pixel für Öffnungsraten
- Klick-Tracking für den Bestätigungsbutton
- Abmelde-Link

## 📱 **Responsive Design**

Das Template ist für alle Geräte optimiert:
- **Desktop**: Vollständige Glasmorphismus-Effekte
- **Tablet**: Angepasste Paddings und Schriftgrößen
- **Mobile**: Touch-optimierte Buttons und Layout

## 🔒 **DSGVO-Konformität**

- ✅ **Rechtssichere Formulierungen** für DOI-Prozess
- 🇪🇺 **EU-Server Hinweise** für Datenverarbeitung
- 📜 **Link zur Datenschutzerklärung**
- 🚫 **Widerrufsrecht** klar kommuniziert

## 🎯 **Best Practices**

### **Betreffzeile:**
```
✉️ Bitte bestätigen Sie Ihre E-Mail-Adresse - Cause.Buzz
```

### **Absender:**
```
Cause.Buzz Team <hello@cause.buzz>
```

### **Kampagnen-Setup:**
1. **Trigger**: Formular-Submission
2. **Warten**: 2 Minuten nach Anmeldung
3. **DOI-E-Mail** senden
4. **Bei Bestätigung**: Willkommens-E-Mail + Segmentierung
5. **Ohne Bestätigung**: Follow-up nach 24h (optional)

## 📊 **Analytics & Tracking**

Das Template tracked automatisch:
- **Öffnungsraten** via Tracking-Pixel
- **Klickraten** auf Bestätigungsbutton
- **Conversion** bei DOI-Bestätigung
- **Absprungrate** bei Abmeldung

## 🛠️ **Anpassungen**

### **Farben ändern:**
```css
/* Primärfarbe */
background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);

/* Akzentfarbe */
color: #60a5fa;

/* Hintergrund */
background-color: #0f172a;
```

### **Logos einbinden:**
```html
<img src=\"https://cause.buzz/logo.png\" alt=\"Cause.Buzz Logo\" width=\"120\" height=\"40\">
```

## 📞 **Support**

Bei Fragen zum Template:
- **E-Mail**: hello@cause.buzz  
- **Website**: https://cause.buzz
- **Adresse**: 40 Im alten Riet, 9494 Schaan, Liechtenstein

---

**Version**: 1.0.0  
**Erstellt**: 2024 für Cause.Buzz  
**Kompatibilität**: Mautic 4.x / 5.xPK\000
\000\000\000\000\000e8[\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000/config.jsonPK\000
\000\000\000\000\000e8[A<2\000\000<2\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000html/message.html.twigPK\000
\000\000\000\000\000e8[&\000\000&\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000m5\000\000/thumbnail.pngPK\000
\000\000\000\000\000e8[OK\000\000\000\000
\000\000\000\000\000\000\000\000\000\000\000\000\000:\000\000/README.mdPK\000\000\000\000\000\000\000\000\000I\000\000\000\000";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@themes/mautic-template-doi.zip";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  548 => 460,  536 => 451,  532 => 450,  528 => 449,  524 => 448,  520 => 447,  465 => 395,  459 => 391,  453 => 389,  451 => 388,  415 => 355,  394 => 337,  387 => 335,  363 => 320,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@themes/mautic-template-doi.zip", "/var/www/mautic-upgrade/docroot/themes/mautic-template-doi.zip");
    }
}
