<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/AssetBundle/Tests/Controller/UploadControllerFunctionalTest.php */
class __TwigTemplate_e8bd53d2d2c4e5050868c0584a0bdea6 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\AssetBundle\\Tests\\Controller;

use Mautic\\AssetBundle\\Tests\\Asset\\AbstractAssetTest;
use Symfony\\Component\\HttpFoundation\\File\\UploadedFile;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\HttpFoundation\\Response;

class UploadControllerFunctionalTest extends AbstractAssetTest
{
    public function testUploadWithWrongMimetype(): void
    {
        // Create a php file with the content of phpinfo
        \$assetsPath = \$this->client->getKernel()->getContainer()->getParameter('mautic.upload_dir');

        \$fileName = 'image2.png';
        \$filePath = \$assetsPath.'/'.\$fileName;

        if (file_exists(\$filePath)) {
            unlink(\$filePath);
        }

        copy('index.php', \$filePath);

        \$binaryFile = new UploadedFile(\$filePath, \$fileName, 'application/x-httpd-php', null, true);

        \$tmpId = 'tempId_'.time();
        // Upload the file
        \$this->client->request(
            Request::METHOD_POST,
            '/s/_uploader/asset/upload',
            [
                'tempId' => \$tmpId,
            ],
            [
                'file' => \$binaryFile,
            ]
        );

        \$response = \$this->client->getResponse();
        \$this->assertStringContainsString('Upload failed as the file mimetype', \$response->getContent());
        \$this->assertStringContainsString('text\\/x-php is not allowed', \$response->getContent());
        unlink(\$filePath);
    }

    public function testSuccessUploadWithPng(): void
    {
        // Create a temporary PNG file
        // Create a php file with the content of phpinfo
        \$assetsPath     = \$this->client->getKernel()->getContainer()->getParameter('mautic.upload_dir');
        \$assetsPathFrom = \$this->client->getKernel()->getContainer()->getParameter('mautic.application_dir').'/app/assets/images/mautic_logo_db64.png';

        \$fileName = 'image3.png';
        \$filePath = \$assetsPath.'/'.\$fileName;

        copy(\$assetsPathFrom, \$filePath);
        // Create an UploadedFile instance with the correct MIME type
        \$uploadedFile = new UploadedFile(\$filePath, \$fileName, 'image/png', null, true);

        \$tmpId = 'tempId_'.time();
        // Perform the request with the file
        \$this->client->request(
            'POST',
            '/s/_uploader/asset/upload',
            ['tempId' => \$tmpId],
            ['file'   => \$uploadedFile]
        );
        \$this->assertResponseStatusCodeSame(Response::HTTP_OK);
        \$this->assertStringContainsString('state\":1', \$this->client->getResponse()->getContent());
        if (file_exists(\$filePath)) {
            unlink(\$filePath);
        }
        \$data = json_decode(\$this->client->getResponse()->getContent(), true);
        unlink(\$assetsPath.'/tmp/'.\$tmpId.'/'.\$data['tmpFileName']);
        rmdir(\$assetsPath.'/tmp/'.\$tmpId);
    }

    public function testUploadWithWrongExtension(): void
    {
        // Create a php file with the content of phpinfo
        \$assetsPath     = \$this->client->getKernel()->getContainer()->getParameter('mautic.upload_dir');
        \$assetsPathFrom = \$this->client->getKernel()->getContainer()->getParameter('mautic.application_dir').'/app/assets/images/mautic_logo_db64.png';

        \$fileName = 'image2.php';
        \$filePath = \$assetsPath.'/'.\$fileName;

        if (file_exists(\$filePath)) {
            unlink(\$filePath);
        }

        copy(\$assetsPathFrom, \$filePath);

        \$binaryFile = new UploadedFile(\$filePath, \$fileName, 'image/png', null, true);

        \$tmpId = 'tempId_'.time();
        // Upload the file
        \$this->client->request(
            Request::METHOD_POST,
            '/s/_uploader/asset/upload',
            [
                'tempId' => \$tmpId,
            ],
            [
                'file' => \$binaryFile,
            ]
        );

        \$response = \$this->client->getResponse();
        \$this->assertStringContainsString('Upload failed as the file extension', \$response->getContent());
        \$this->assertStringContainsString('Upload failed as the file extension, php,', \$response->getContent());
        unlink(\$filePath);
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/AssetBundle/Tests/Controller/UploadControllerFunctionalTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/AssetBundle/Tests/Controller/UploadControllerFunctionalTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/AssetBundle/Tests/Controller/UploadControllerFunctionalTest.php");
    }
}
