<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @themes/causebuzz-grapejs-suite/html/message.html.twig */
class __TwigTemplate_0bfa46f026d5fb4b7ad768965df34336 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<!DOCTYPE html>
<html lang=\"";
        // line 2
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("language", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["language"]) || array_key_exists("language", $context) ? $context["language"] : (function () { throw new RuntimeError('Variable "language" does not exist.', 2, $this->source); })()), "de")) : ("de")), "html", null, true);
        yield "\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">
    <title>";
        // line 7
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 7, $this->source); })()), "Cause.Buzz Nachricht")) : ("Cause.Buzz Nachricht")), "html", null, true);
        yield "</title>
    
    <!-- Mobile Optimization -->
    <meta name=\"format-detection\" content=\"telephone=no\">
    <meta name=\"format-detection\" content=\"date=no\">
    <meta name=\"format-detection\" content=\"address=no\">
    <meta name=\"format-detection\" content=\"email=no\">
    
    <!-- Email Client Support -->
    <!--[if mso]>
    <noscript>
        <xml>
            <o:OfficeDocumentSettings>
                <o:AllowPNG/>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
    </noscript>
    <![endif]-->
    
    <style>
        /* Reset und Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #ffffff;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
            margin: 0;
            padding: 0;
            width: 100% !important;
            min-width: 100%;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        
        table {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
            width: 100%;
        }
        
        td {
            border-collapse: collapse;
            mso-line-height-rule: exactly;
        }
        
        img {
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
            -ms-interpolation-mode: bicubic;
            max-width: 100%;
            display: block;
        }
        
        /* Container */
        .email-wrapper {
            width: 100%;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
            padding: 20px 0;
            min-height: 100vh;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
        }
        
        /* Compact Header */
        .compact-header {
            background: linear-gradient(135deg, #334155 0%, #475569 100%);
            padding: 20px;
            text-align: center;
            border-bottom: 2px solid #2563eb;
        }
        
        .compact-logo {
            max-width: 120px;
            height: auto;
            margin: 0 auto;
        }
        
        /* Content Section */
        .message-content {
            padding: 40px 30px;
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
        }
        
        .message-title {
            font-size: 24px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .message-text {
            font-size: 16px;
            color: #cbd5e1;
            line-height: 1.6;
            margin-bottom: 20px;
        }
        
        .message-highlight {
            background: rgba(37, 99, 235, 0.1);
            border: 1px solid rgba(37, 99, 235, 0.2);
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .message-highlight h3 {
            color: #60a5fa;
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .message-highlight p {
            color: #cbd5e1;
            font-size: 14px;
            margin: 0;
        }
        
        /* Buttons */
        .btn {
            display: inline-block;
            padding: 14px 28px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            font-size: 16px;
            border: none;
            transition: all 0.3s ease;
            margin: 10px;
            text-align: center;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: #ffffff !important;
            box-shadow: 0 8px 25px rgba(37, 99, 235, 0.4);
        }
        
        .btn-secondary {
            background: transparent;
            color: #60a5fa !important;
            border: 2px solid #3b82f6;
        }
        
        .action-buttons {
            text-align: center;
            margin: 30px 0;
        }
        
        /* Compact Footer */
        .compact-footer {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
            padding: 20px;
            text-align: center;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .footer-text {
            font-size: 12px;
            color: #64748b;
            margin-bottom: 10px;
            line-height: 1.4;
        }
        
        .footer-links a {
            color: #60a5fa;
            text-decoration: none;
            margin: 0 10px;
            font-size: 12px;
        }
        
        /* Status Messages */
        .status-success {
            background: rgba(5, 150, 105, 0.1);
            border: 1px solid rgba(5, 150, 105, 0.3);
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            color: #10b981;
        }
        
        .status-warning {
            background: rgba(245, 158, 11, 0.1);
            border: 1px solid rgba(245, 158, 11, 0.3);
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            color: #f59e0b;
        }
        
        .status-error {
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.3);
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            color: #ef4444;
        }
        
        .status-info {
            background: rgba(37, 99, 235, 0.1);
            border: 1px solid rgba(37, 99, 235, 0.3);
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            color: #3b82f6;
        }
        
        /* Responsive Design */
        @media only screen and (max-width: 600px) {
            .email-wrapper {
                padding: 10px !important;
            }
            
            .email-container {
                border-radius: 8px !important;
            }
            
            .message-content {
                padding: 20px !important;
            }
            
            .message-title {
                font-size: 20px !important;
            }
            
            .btn {
                display: block !important;
                width: 100% !important;
                margin: 10px 0 !important;
            }
            
            .footer-links a {
                display: block !important;
                margin: 5px 0 !important;
            }
        }
        
        /* Print Styles */
        @media print {
            .email-wrapper {
                background: #ffffff !important;
            }
            
            .email-container {
                background: #ffffff !important;
                color: #000000 !important;
                box-shadow: none !important;
            }
            
            .message-text,
            .message-title {
                color: #000000 !important;
            }
        }
        
        /* High Contrast Support */
        @media (prefers-contrast: high) {
            .btn-primary {
                border: 2px solid #ffffff !important;
            }
        }
    </style>
</head>
<body>
    <div class=\"email-wrapper\">
        <div class=\"email-container\">
            
            <!-- Compact Header -->
            <div class=\"compact-header\">
                <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz\" class=\"compact-logo\" />
            </div>
            
            <!-- Message Content -->
            <div class=\"message-content\">
                ";
        // line 301
        if ((($tmp = (isset($context["messageType"]) || array_key_exists("messageType", $context) ? $context["messageType"] : (function () { throw new RuntimeError('Variable "messageType" does not exist.', 301, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 302
            yield "                    ";
            if (((isset($context["messageType"]) || array_key_exists("messageType", $context) ? $context["messageType"] : (function () { throw new RuntimeError('Variable "messageType" does not exist.', 302, $this->source); })()) == "welcome")) {
                // line 303
                yield "                        <h1 class=\"message-title\">👋 ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 303, $this->source); })()), "Willkommen bei Cause.Buzz!")) : ("Willkommen bei Cause.Buzz!")), "html", null, true);
                yield "</h1>
                        <div class=\"status-success\">
                            <p><strong>✅ Erfolgreich angemeldet!</strong><br>
                            Ihre Registrierung war erfolgreich.</p>
                        </div>
                    ";
            } elseif ((            // line 308
(isset($context["messageType"]) || array_key_exists("messageType", $context) ? $context["messageType"] : (function () { throw new RuntimeError('Variable "messageType" does not exist.', 308, $this->source); })()) == "confirmation")) {
                // line 309
                yield "                        <h1 class=\"message-title\">📧 ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 309, $this->source); })()), "Bestätigung erforderlich")) : ("Bestätigung erforderlich")), "html", null, true);
                yield "</h1>
                        <div class=\"status-info\">
                            <p><strong>🔔 Bestätigung erforderlich</strong><br>
                            Bitte bestätigen Sie Ihre E-Mail-Adresse.</p>
                        </div>
                    ";
            } elseif ((            // line 314
(isset($context["messageType"]) || array_key_exists("messageType", $context) ? $context["messageType"] : (function () { throw new RuntimeError('Variable "messageType" does not exist.', 314, $this->source); })()) == "reset")) {
                // line 315
                yield "                        <h1 class=\"message-title\">🔒 ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 315, $this->source); })()), "Passwort zurücksetzen")) : ("Passwort zurücksetzen")), "html", null, true);
                yield "</h1>
                        <div class=\"status-warning\">
                            <p><strong>⚠️ Passwort-Reset angefordert</strong><br>
                            Klicken Sie auf den Link unten, um Ihr Passwort zurückzusetzen.</p>
                        </div>
                    ";
            } elseif ((            // line 320
(isset($context["messageType"]) || array_key_exists("messageType", $context) ? $context["messageType"] : (function () { throw new RuntimeError('Variable "messageType" does not exist.', 320, $this->source); })()) == "notification")) {
                // line 321
                yield "                        <h1 class=\"message-title\">🔔 ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 321, $this->source); })()), "Neue Benachrichtigung")) : ("Neue Benachrichtigung")), "html", null, true);
                yield "</h1>
                        <div class=\"status-info\">
                            <p><strong>📬 Neue Nachricht</strong><br>
                            Sie haben eine neue Benachrichtigung erhalten.</p>
                        </div>
                    ";
            } else {
                // line 327
                yield "                        <h1 class=\"message-title\">";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 327, $this->source); })()), "Wichtige Mitteilung")) : ("Wichtige Mitteilung")), "html", null, true);
                yield "</h1>
                    ";
            }
            // line 329
            yield "                ";
        } else {
            // line 330
            yield "                    <h1 class=\"message-title\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 330, $this->source); })()), "Nachricht von Cause.Buzz")) : ("Nachricht von Cause.Buzz")), "html", null, true);
            yield "</h1>
                ";
        }
        // line 332
        yield "                
                ";
        // line 333
        if ((($tmp = (isset($context["greeting"]) || array_key_exists("greeting", $context) ? $context["greeting"] : (function () { throw new RuntimeError('Variable "greeting" does not exist.', 333, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 334
            yield "                    <p class=\"message-text\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["greeting"]) || array_key_exists("greeting", $context) ? $context["greeting"] : (function () { throw new RuntimeError('Variable "greeting" does not exist.', 334, $this->source); })()), "html", null, true);
            yield "</p>
                ";
        } else {
            // line 336
            yield "                    <p class=\"message-text\">Liebe/r ";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, ($context["contact"] ?? null), "firstname", [], "any", true, true, false, 336)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, (isset($context["contact"]) || array_key_exists("contact", $context) ? $context["contact"] : (function () { throw new RuntimeError('Variable "contact" does not exist.', 336, $this->source); })()), "firstname", [], "any", false, false, false, 336), "Kunde/in")) : ("Kunde/in")), "html", null, true);
            yield ",</p>
                ";
        }
        // line 338
        yield "                
                ";
        // line 339
        if ((($tmp = (isset($context["content"]) || array_key_exists("content", $context) ? $context["content"] : (function () { throw new RuntimeError('Variable "content" does not exist.', 339, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 340
            yield "                    <div class=\"message-text\">
                        ";
            // line 341
            yield (isset($context["content"]) || array_key_exists("content", $context) ? $context["content"] : (function () { throw new RuntimeError('Variable "content" does not exist.', 341, $this->source); })());
            yield "
                    </div>
                ";
        } else {
            // line 344
            yield "                    <p class=\"message-text\">
                        hier ist Ihre angeforderte Information. Diese E-Mail wurde automatisch generiert 
                        und enthält wichtige Details zu Ihrem Cause.Buzz Account oder Service.
                    </p>
                    
                    <div class=\"message-highlight\">
                        <h3>💡 Wichtiger Hinweis</h3>
                        <p>Falls Sie Fragen haben, antworten Sie einfach auf diese E-Mail oder kontaktieren Sie unser Support-Team unter hello@cause.buzz</p>
                    </div>
                ";
        }
        // line 354
        yield "                
                ";
        // line 355
        if ((($tmp = (isset($context["actionUrl"]) || array_key_exists("actionUrl", $context) ? $context["actionUrl"] : (function () { throw new RuntimeError('Variable "actionUrl" does not exist.', 355, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 356
            yield "                <div class=\"action-buttons\">
                    <a href=\"";
            // line 357
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["actionUrl"]) || array_key_exists("actionUrl", $context) ? $context["actionUrl"] : (function () { throw new RuntimeError('Variable "actionUrl" does not exist.', 357, $this->source); })()), "html", null, true);
            yield "\" class=\"btn btn-primary\">
                        ";
            // line 358
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("actionText", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["actionText"]) || array_key_exists("actionText", $context) ? $context["actionText"] : (function () { throw new RuntimeError('Variable "actionText" does not exist.', 358, $this->source); })()), "🎯 Jetzt fortfahren")) : ("🎯 Jetzt fortfahren")), "html", null, true);
            yield "
                    </a>
                    ";
            // line 360
            if ((($tmp = (isset($context["secondaryActionUrl"]) || array_key_exists("secondaryActionUrl", $context) ? $context["secondaryActionUrl"] : (function () { throw new RuntimeError('Variable "secondaryActionUrl" does not exist.', 360, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                // line 361
                yield "                    <a href=\"";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["secondaryActionUrl"]) || array_key_exists("secondaryActionUrl", $context) ? $context["secondaryActionUrl"] : (function () { throw new RuntimeError('Variable "secondaryActionUrl" does not exist.', 361, $this->source); })()), "html", null, true);
                yield "\" class=\"btn btn-secondary\">
                        ";
                // line 362
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("secondaryActionText", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["secondaryActionText"]) || array_key_exists("secondaryActionText", $context) ? $context["secondaryActionText"] : (function () { throw new RuntimeError('Variable "secondaryActionText" does not exist.', 362, $this->source); })()), "ℹ️ Weitere Informationen")) : ("ℹ️ Weitere Informationen")), "html", null, true);
                yield "
                    </a>
                    ";
            }
            // line 365
            yield "                </div>
                ";
        }
        // line 367
        yield "                
                ";
        // line 368
        if ((($tmp = (isset($context["showDefaultActions"]) || array_key_exists("showDefaultActions", $context) ? $context["showDefaultActions"] : (function () { throw new RuntimeError('Variable "showDefaultActions" does not exist.', 368, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 369
            yield "                <div class=\"action-buttons\">
                    <a href=\"https://cause.buzz\" class=\"btn btn-primary\">🏠 Zur Website</a>
                    <a href=\"mailto:hello@cause.buzz\" class=\"btn btn-secondary\">📧 Support kontaktieren</a>
                </div>
                ";
        }
        // line 374
        yield "                
                ";
        // line 375
        if ((($tmp = (isset($context["additionalInfo"]) || array_key_exists("additionalInfo", $context) ? $context["additionalInfo"] : (function () { throw new RuntimeError('Variable "additionalInfo" does not exist.', 375, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 376
            yield "                <div class=\"message-highlight\">
                    <h3>📋 Zusätzliche Informationen</h3>
                    <div>";
            // line 378
            yield (isset($context["additionalInfo"]) || array_key_exists("additionalInfo", $context) ? $context["additionalInfo"] : (function () { throw new RuntimeError('Variable "additionalInfo" does not exist.', 378, $this->source); })());
            yield "</div>
                </div>
                ";
        }
        // line 381
        yield "                
                <p class=\"message-text\">
                    Mit freundlichen Grüßen,<br>
                    <strong>Ihr Cause.Buzz Team</strong>
                </p>
            </div>
            
            <!-- Compact Footer -->
            <div class=\"compact-footer\">
                <p class=\"footer-text\">
                    <strong>Cause.Buzz</strong> - Die professionelle Marketing-Plattform<br>
                    40 Im alten Riet, 9494 Schaan, Liechtenstein
                </p>
                
                <div class=\"footer-links\">
                    <a href=\"https://cause.buzz/privacy\">Datenschutz</a>
                    <a href=\"https://cause.buzz/imprint\">Impressum</a>
                    ";
        // line 398
        if ((($tmp = (isset($context["unsubscribeUrl"]) || array_key_exists("unsubscribeUrl", $context) ? $context["unsubscribeUrl"] : (function () { throw new RuntimeError('Variable "unsubscribeUrl" does not exist.', 398, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 399
            yield "                    <a href=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["unsubscribeUrl"]) || array_key_exists("unsubscribeUrl", $context) ? $context["unsubscribeUrl"] : (function () { throw new RuntimeError('Variable "unsubscribeUrl" does not exist.', 399, $this->source); })()), "html", null, true);
            yield "\">Abmelden</a>
                    ";
        } else {
            // line 401
            yield "                    <a href=\"{unsubscribe_url}\">Abmelden</a>
                    ";
        }
        // line 403
        yield "                </div>
                
                <p class=\"footer-text\" style=\"margin-top: 15px;\">
                    © 2024 Cause.Buzz. Diese E-Mail wurde an ";
        // line 406
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, ($context["contact"] ?? null), "email", [], "any", true, true, false, 406)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, (isset($context["contact"]) || array_key_exists("contact", $context) ? $context["contact"] : (function () { throw new RuntimeError('Variable "contact" does not exist.', 406, $this->source); })()), "email", [], "any", false, false, false, 406), "{email}")) : ("{email}")), "html", null, true);
        yield " gesendet.
                </p>
            </div>
            
        </div>
    </div>
</body>
</html>";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@themes/causebuzz-grapejs-suite/html/message.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  553 => 406,  548 => 403,  544 => 401,  538 => 399,  536 => 398,  517 => 381,  511 => 378,  507 => 376,  505 => 375,  502 => 374,  495 => 369,  493 => 368,  490 => 367,  486 => 365,  480 => 362,  475 => 361,  473 => 360,  468 => 358,  464 => 357,  461 => 356,  459 => 355,  456 => 354,  444 => 344,  438 => 341,  435 => 340,  433 => 339,  430 => 338,  424 => 336,  418 => 334,  416 => 333,  413 => 332,  407 => 330,  404 => 329,  398 => 327,  388 => 321,  386 => 320,  377 => 315,  375 => 314,  366 => 309,  364 => 308,  355 => 303,  352 => 302,  350 => 301,  53 => 7,  45 => 2,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@themes/causebuzz-grapejs-suite/html/message.html.twig", "/var/www/mautic-upgrade/docroot/themes/causebuzz-grapejs-suite/html/message.html.twig");
    }
}
