<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/ReportBundle/Tests/Controller/Api/ReportApiControllerTest.php */
class __TwigTemplate_8b08d4cd82f68991012d6d805810b095 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\ReportBundle\\Tests\\Controller\\Api;

use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use Mautic\\ReportBundle\\Entity\\Report;
use Mautic\\UserBundle\\Entity\\Permission;
use Mautic\\UserBundle\\Entity\\Role;
use Mautic\\UserBundle\\Entity\\User;
use Mautic\\UserBundle\\Model\\RoleModel;
use Symfony\\Component\\HttpFoundation\\Response;

class ReportApiControllerTest extends MauticMysqlTestCase
{
    protected \$useCleanupRollback = false;

    public function testGetReportFailByNoCorrectAccessRoleEmpty(): void
    {
        \$reportId = \$this->createReportStructure('Maut1cR0cks!!!!!', []);
        \$this->client->request('GET', '/api/reports/'.\$reportId);
        \$this->assertSame(Response::HTTP_FORBIDDEN, \$this->client->getResponse()->getStatusCode());
    }

    public function testGetReportSuccessByCorrectAccessIsAdmin(): void
    {
        \$reportId = \$this->createReportStructure('Maut1cR0cks!!!!!', [], false, true);
        \$this->client->request('GET', '/api/reports/'.\$reportId);
        \$this->assertSame(Response::HTTP_OK, \$this->client->getResponse()->getStatusCode());
    }

    public function testGetReportSuccessByNoCorrectAccessToViewOther(): void
    {
        \$reportId = \$this->createReportStructure('Maut1cR0cks!!!!!', ['report:reports'=>['viewother']]);
        \$this->client->request('GET', '/api/reports/'.\$reportId);
        \$this->assertSame(Response::HTTP_OK, \$this->client->getResponse()->getStatusCode());
    }

    public function testReportFailByNoCorrectAccessToViewOwn(): void
    {
        \$reportId = \$this->createReportStructure('Maut1cR0cks!!!!!', ['report:reports'=>['viewown']]);
        \$this->client->request('GET', '/api/reports/'.\$reportId);
        \$this->assertSame(Response::HTTP_FORBIDDEN, \$this->client->getResponse()->getStatusCode());
    }

    public function testReportSuccessViewOwnBySameUser(): void
    {
        \$reportId = \$this->createReportStructure('Maut1cR0cks!!!!!', ['report:reports'=>['viewown']], true);
        \$this->client->request('GET', '/api/reports/'.\$reportId);
        \$this->assertSame(Response::HTTP_OK, \$this->client->getResponse()->getStatusCode());
    }

    /**
     * @param array<array<string>> \$permissions
     */
    private function createReportStructure(string \$password, array \$permissions, bool \$createBy = false, bool \$userIsAdmin = false): int
    {
        \$role           = \$this->createRole(\$userIsAdmin);
        \$user           = \$this->createUser(\$role, \$password);
        \$createByIdUser = 0;
        if (!empty(\$createBy)) {
            \$createByIdUser = \$user->getId();
        }
        \$report   = \$this->createReportData(\$createByIdUser);

        if (\$permissions) {
            \$this->setPermission(\$user, \$permissions);
        }
        // Disable the default logging in via username and password.
        \$this->clientServer = [];
        \$this->setUpSymfony(\$this->configParams);
        \$this->loginUser(\$user->getUserIdentifier());
        \$this->client->setServerParameter('PHP_AUTH_USER', \$user->getUserIdentifier());
        \$this->client->setServerParameter('PHP_AUTH_PW', \$password);

        return \$report->getId();
    }

    /**
     * @param array<array<string>> \$permissions
     */
    private function setPermission(User \$user, array \$permissions): Role
    {
        \$role = \$user->getRole();
        // Delete previous permissions
        \$this->em->createQueryBuilder()
            ->delete(Permission::class, 'p')
            ->where('p.bundle = :bundle')
            ->andWhere('p.role = :role_id')
            ->setParameters(['bundle' => 'report', 'role_id' => \$role->getId()])
            ->getQuery()
            ->execute();

        // Set new permissions
        \$role->setIsAdmin(false);
        \$roleModel = static::getContainer()->get('mautic.user.model.role');
        \\assert(\$roleModel instanceof RoleModel);
        \$roleModel->setRolePermissions(\$role, \$permissions);
        \$this->em->persist(\$role);
        \$this->em->flush();

        return \$role;
    }

    private function createUser(Role \$role, string \$password='mautic'): User
    {
        \$user = new User();
        \$user->setFirstName('John');
        \$user->setLastName('Doe');
        \$user->setUsername('john.doe');
        \$user->setEmail('john.doe@email.com');
        \$encoder = static::getContainer()->get('security.encoder_factory')->getEncoder(\$user);
        \$user->setPassword(\$encoder->encodePassword(\$password, null));
        \$user->setRole(\$role);

        \$this->em->persist(\$user);
        \$this->em->flush();

        return \$user;
    }

    private function createRole(bool \$isAdmin = false): Role
    {
        \$role = new Role();
        \$role->setName('Role');
        \$role->setIsAdmin(\$isAdmin);

        \$this->em->persist(\$role);
        \$this->em->flush();

        return \$role;
    }

    private function createReportData(int \$createBy = 0): Report
    {
        \$report = new Report();
        \$report->setName('Contact report');
        \$report->setDescription('<b>This is allowed HTML</b>');
        \$report->setSource('leads');
        \$coulmns = [
            'l.firstname',
            'l.lastname',
            'l.email',
            'l.date_added',
        ];
        \$report->setColumns(\$coulmns);
        if (!empty(\$createBy)) {
            \$report->setCreatedBy(\$createBy);
            \$report->setCreatedByUser(\$createBy);
        }

        \$this->getContainer()->get('mautic.report.model.report')->saveEntity(\$report);

        return \$report;
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/ReportBundle/Tests/Controller/Api/ReportApiControllerTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/ReportBundle/Tests/Controller/Api/ReportApiControllerTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/ReportBundle/Tests/Controller/Api/ReportApiControllerTest.php");
    }
}
