<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/UserBundle/Tests/Security/SAML/Store/Request/RequestStateStoreTest.php */
class __TwigTemplate_da4769d6883849c00c5d7cf0caa1ca8c extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\UserBundle\\Tests\\Security\\SAML\\Store\\Request;

use LightSaml\\State\\Request\\RequestState;
use Mautic\\CacheBundle\\Cache\\CacheProviderInterface;
use Mautic\\UserBundle\\Security\\SAML\\Store\\Request\\RequestStateStore;
use PHPUnit\\Framework\\MockObject\\MockObject;
use PHPUnit\\Framework\\TestCase;
use Psr\\Cache\\CacheItemInterface;

class RequestStateStoreTest extends TestCase
{
    /**
     * @var CacheProviderInterface&MockObject
     */
    private MockObject \$cacheProvider;

    /**
     * @var MockObject&CacheItemInterface
     */
    private MockObject \$cacheItem;

    private RequestStateStore \$requestStateStore;
    private string \$cachePrefix = 'prefix_suffix';
    private string \$stateId     = 'state_id';

    protected function setUp(): void
    {
        parent::setUp();

        \$this->cacheItem = \$this->createMock(CacheItemInterface::class);

        \$this->cacheProvider = \$this->createMock(CacheProviderInterface::class);
        \$this->cacheProvider->method('getItem')
            ->with(\$this->cachePrefix.\$this->stateId)
            ->willReturn(\$this->cacheItem);

        \$this->requestStateStore = new RequestStateStore(\$this->cacheProvider, 'prefix', '_suffix');
    }

    public function testSet(): void
    {
        \$state = \$this->createMock(RequestState::class);
        \$state->expects(self::once())
            ->method('getId')
            ->willReturn(\$this->stateId);

        \$this->cacheItem->expects(self::once())
            ->method('expiresAfter')
            ->with(2 * 60);
        \$this->cacheItem->expects(self::once())
            ->method('set')
            ->with(\$state);

        \$this->cacheProvider->expects(self::once())
            ->method('save')
            ->with(\$this->cacheItem);

        \$this->requestStateStore->set(\$state);
    }

    public function testGetNotHit(): void
    {
        \$this->cacheItem->expects(self::once())
            ->method('isHit')
            ->willReturn(false);
        \$this->cacheItem->expects(self::never())
            ->method('get');

        self::assertNull(\$this->requestStateStore->get(\$this->stateId));
    }

    public function testGetIsHitButNotRequestState(): void
    {
        \$this->cacheItem->expects(self::once())
            ->method('isHit')
            ->willReturn(true);
        \$this->cacheItem->expects(self::once())
            ->method('get')
            ->willReturn('string');

        self::assertNull(\$this->requestStateStore->get(\$this->stateId));
    }

    public function testGetIsHitRequestState(): void
    {
        \$state = \$this->createMock(RequestState::class);
        \$this->cacheItem->expects(self::once())
            ->method('isHit')
            ->willReturn(true);
        \$this->cacheItem->expects(self::once())
            ->method('get')
            ->willReturn(\$state);

        self::assertSame(\$state, \$this->requestStateStore->get(\$this->stateId));
    }

    public function testRemove(): void
    {
        \$id = 'whatever';
        \$this->cacheProvider->expects(self::once())
            ->method('deleteItem')
            ->with(\$this->cachePrefix.\$id)
            ->willReturn(true);

        self::assertTrue(\$this->requestStateStore->remove(\$id));
    }

    public function testClear(): void
    {
        \$this->cacheProvider->expects(self::once())
            ->method('clear')
            ->with(\$this->cachePrefix);

        \$this->requestStateStore->clear();
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/UserBundle/Tests/Security/SAML/Store/Request/RequestStateStoreTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/UserBundle/Tests/Security/SAML/Store/Request/RequestStateStoreTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/UserBundle/Tests/Security/SAML/Store/Request/RequestStateStoreTest.php");
    }
}
