<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/EmailBundle/Tests/Helper/EmailValidatorTest.php */
class __TwigTemplate_322f0dd9e55b7b598f1e7555b47d3d9e extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\EmailBundle\\Tests\\Helper;

use Mautic\\EmailBundle\\EmailEvents;
use Mautic\\EmailBundle\\Event\\EmailValidationEvent;
use Mautic\\EmailBundle\\Exception\\InvalidEmailException;
use Mautic\\EmailBundle\\Helper\\EmailValidator;
use Mautic\\EmailBundle\\Tests\\Helper\\EventListener\\EmailValidationSubscriber;
use PHPUnit\\Framework\\MockObject\\MockObject;
use Symfony\\Component\\EventDispatcher\\EventDispatcher;
use Symfony\\Component\\EventDispatcher\\EventDispatcherInterface;
use Symfony\\Component\\Validator\\Exception\\UnexpectedValueException;
use Symfony\\Contracts\\Translation\\TranslatorInterface;

class EmailValidatorTest extends \\PHPUnit\\Framework\\TestCase
{
    /**
     * @var MockObject&TranslatorInterface
     */
    private MockObject \$translator;

    /**
     * @var MockObject&EventDispatcherInterface
     */
    private MockObject \$dispatcher;

    /**
     * @var MockObject&EmailValidationEvent
     */
    private MockObject \$event;

    private EmailValidator \$emailValidator;

    protected function setUp(): void
    {
        parent::setUp();

        \$this->translator = \$this->createMock(TranslatorInterface::class);
        \$this->dispatcher = \$this->createMock(EventDispatcherInterface::class);
        \$this->event      = \$this->createMock(EmailValidationEvent::class);

        \$this->translator->method('trans')->willReturn('some translation');

        \$this->emailValidator = new EmailValidator(\$this->translator, \$this->dispatcher);
    }

    public function testValidGmailEmail(): void
    {
        \$this->dispatcher->expects(\$this->once())
            ->method('dispatch')
            ->with(\$this->isInstanceOf(EmailValidationEvent::class), EmailEvents::ON_EMAIL_VALIDATION)
            ->willReturn(\$this->event);

        \$this->event->expects(\$this->once())
            ->method('isValid')
            ->willReturn(true);

        \$this->emailValidator->validate('john@gmail.com');
    }

    public function testValidGmailEmailWithPeriod(): void
    {
        \$this->dispatcher->expects(\$this->once())
            ->method('dispatch')
            ->with(\$this->isInstanceOf(EmailValidationEvent::class), EmailEvents::ON_EMAIL_VALIDATION)
            ->willReturn(\$this->event);

        \$this->event->expects(\$this->once())
            ->method('isValid')
            ->willReturn(true);

        \$this->emailValidator->validate('john.doe@gmail.com');
    }

    public function testValidGmailEmailWithPlus(): void
    {
        \$this->dispatcher->expects(\$this->once())
            ->method('dispatch')
            ->with(\$this->isInstanceOf(EmailValidationEvent::class), EmailEvents::ON_EMAIL_VALIDATION)
            ->willReturn(\$this->event);

        \$this->event->expects(\$this->once())
            ->method('isValid')
            ->willReturn(true);

        \$this->emailValidator->validate('john+doe@gmail.com');
    }

    public function testValidGmailEmailWithNonStandardTld(): void
    {
        \$this->dispatcher->expects(\$this->once())
        ->method('dispatch')
        ->with(\$this->isInstanceOf(EmailValidationEvent::class), EmailEvents::ON_EMAIL_VALIDATION)
        ->willReturn(\$this->event);

        \$this->event->expects(\$this->once())
        ->method('isValid')
        ->willReturn(true);

        // hopefully this domain remains intact
        \$this->emailValidator->validate('john@mail.email');
    }

    public function testValidateNull(): void
    {
        \$this->expectException(UnexpectedValueException::class);
        \$this->emailValidator->validate(null);
    }

    public function testValidateEmailWithoutTld(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('john@doe');
    }

    public function testValidateEmailWithSpaceInIt(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('jo hn@gmail.com');
    }

    public function testValidateEmailWithCaretInIt(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('jo^hn@gmail.com');
    }

    public function testValidateEmailWithApostropheInTheDomainPortion(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('john@gm\\'ail.com');
    }

    public function testValidateEmailWithSemicolonInIt(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('jo;hn@gmail.com');
    }

    public function testValidateEmailWithAmpersandInIt(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('jo&hn@gmail.com');
    }

    public function testValidateEmailWithStarInIt(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('jo*hn@gmail.com');
    }

    public function testValidateEmailWithPercentInIt(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('jo%hn@gmail.com');
    }

    public function testValidateEmailWithDoublePeriodInIt(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('jo..hn@gmail.com');
    }

    public function testValidateEmailWithBadDNS(): void
    {
        \$this->expectException(InvalidEmailException::class);
        \$this->emailValidator->validate('john@doe.shouldneverexist', true);
    }

    public function testIntegrationInvalidatesEmail(): void
    {
        \$dispatcher = new EventDispatcher();
        \$dispatcher->addSubscriber(new EmailValidationSubscriber());

        \$emailValidator = new EmailValidator(\$this->translator, \$dispatcher);

        \$this->expectException(InvalidEmailException::class);
        \$this->expectExceptionMessage('bad email');

        \$emailValidator->doPluginValidation('bad@gmail.com');
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/EmailBundle/Tests/Helper/EmailValidatorTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/EmailBundle/Tests/Helper/EmailValidatorTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/EmailBundle/Tests/Helper/EmailValidatorTest.php");
    }
}
