<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Tests/Functional/Security/Permissions/CorePermissionsTest.php */
class __TwigTemplate_4b04844b913359779f835880fdf73810 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\CoreBundle\\Tests\\Functional\\Security\\Permissions;

use Mautic\\CoreBundle\\Security\\Permissions\\AbstractPermissions;
use Mautic\\CoreBundle\\Security\\Permissions\\VirtualPermissions;
use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use PHPUnit\\Framework\\Assert;

class CorePermissionsTest extends MauticMysqlTestCase
{
    /**
     * @return iterable<array{bool}>
     */
    public function dataVirtualPermission(): iterable
    {
        yield 'Permission granted' => [true];
        yield 'Permission declined' => [false];
    }

    /**
     * @dataProvider dataVirtualPermission
     */
    public function testVirtualPermission(bool \$grant): void
    {
        \$user        = \$this->loginUser('sales');
        \$permissions = self::getContainer()->get('mautic.security');
        \$permissions->setPermissionObject(\$this->createVirtualPermission(\$grant));

        Assert::assertSame(\$grant, \$permissions->isGranted('test:group:action', 'MATCH_ALL', \$user));
    }

    private function createVirtualPermission(bool \$grant): AbstractPermissions
    {
        \$permission = new class([]) extends AbstractPermissions implements VirtualPermissions {
            public bool \$grant;

            public function getName(): string
            {
                return 'test';
            }

            public function isSupported(\$name, \$level = ''): bool
            {
                Assert::assertSame('group', \$name);
                Assert::assertSame('action', \$level);

                return true;
            }

            /**
             * @param mixed[] \$userPermissions
             */
            public function isGranted(\$userPermissions, \$name, \$level): bool
            {
                Assert::fail('This method should not be invoked.');
            }

            public function isEnabled(): bool
            {
                return false;
            }

            public function isVirtuallyGranted(string \$name, string \$level): bool
            {
                Assert::assertSame('group', \$name);
                Assert::assertSame('action', \$level);

                return \$this->grant;
            }
        };

        \$permission->grant = \$grant;

        return \$permission;
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Tests/Functional/Security/Permissions/CorePermissionsTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Tests/Functional/Security/Permissions/CorePermissionsTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/CoreBundle/Tests/Functional/Security/Permissions/CorePermissionsTest.php");
    }
}
