<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @themes/causebuzz-mautic-theme.zip */
class __TwigTemplate_5c81ea5f397b65ea8ac1171df4d058ce extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "PK
\000\000\000\000\000Y>[zm\000\000m\000\000\000\000\000/config.json{
  \"name\": \"Cause.Buzz Professional\",
  \"author\": \"Cause.Buzz\",
  \"authorUrl\": \"https://cause.buzz\",
  \"builder\": [
    \"grapesjsbuilder\",
    \"legacy\"
  ],
  \"features\": [
    \"page\",
    \"email\"
  ],
  \"slots\": {
    \"header\": {
      \"name\": \"mautic.email.header\",
      \"config\": {
        \"allowedContent\": [
          \"logo\",
          \"navigation\",
          \"social\"
        ]
      }
    },
    \"body\": {
      \"name\": \"mautic.email.body\",
      \"config\": {
        \"allowedContent\": [
          \"text\",
          \"button\",
          \"image\", 
          \"separator\",
          \"columns\",
          \"feature_box\"
        ]
      }
    },
    \"footer\": {
      \"name\": \"mautic.email.footer\",
      \"config\": {
        \"allowedContent\": [
          \"text\",
          \"social\",
          \"unsubscribe\"
        ]
      }
    }
  },
  \"thumbnail\": \"thumbnail.png\",
  \"description\": \"Professional email template package for Cause.Buzz marketing platform with dark theme and modern design. Fully responsive and GDPR compliant. Perfect for newsletters, welcome emails, and marketing campaigns.\",
  \"version\": \"1.0.0\",
  \"requirements\": {
    \"php\": \">=7.4\",
    \"mautic\": \">=4.0\"
  },
  \"tags\": [
    \"newsletter\",
    \"marketing\",
    \"professional\",
    \"dark-theme\",
    \"responsive\",
    \"gdpr\",
    \"automation\"
  ],
  \"colors\": {
    \"primary\": \"#2563eb\",
    \"secondary\": \"#60a5fa\", 
    \"background\": \"#0f172a\",
    \"surface\": \"#1e293b\",
    \"text\": \"#ffffff\",
    \"muted\": \"#cbd5e1\"
  },
  \"fonts\": [
    \"-apple-system\",
    \"BlinkMacSystemFont\",
    \"Segoe UI\",
    \"Roboto\",
    \"Helvetica Neue\",
    \"Arial\",
    \"sans-serif\"
  ]
}PK
\000\000\000\000\000Y>[?G\000\000G\000\000\000\000\000html/email.html.twig<!DOCTYPE html>
<html lang=\"";
        // line 84
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("language", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["language"]) || array_key_exists("language", $context) ? $context["language"] : (function () { throw new RuntimeError('Variable "language" does not exist.', 84, $this->source); })()), "de")) : ("de")), "html", null, true);
        yield "\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>";
        // line 88
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 88, $this->source); })()), "Cause.Buzz Newsletter")) : ("Cause.Buzz Newsletter")), "html", null, true);
        yield "</title>
    <!--[if mso]>
    <noscript>
        <xml>
            <o:OfficeDocumentSettings>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
    </noscript>
    <![endif]-->
    <style>
        /* Reset and base styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #ffffff;
            background-color: #0f172a;
            margin: 0;
            padding: 0;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        
        table {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }
        
        img {
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
            -ms-interpolation-mode: bicubic;
            max-width: 100%;
        }
        
        /* Main container */
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
        }
        
        /* Header styles */
        .email-header {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            padding: 30px 20px;
            text-align: center;
            border-bottom: 2px solid #3b82f6;
        }
        
        .logo {
            max-width: 180px;
            height: auto;
            margin-bottom: 15px;
        }
        
        .header-badges {
            margin-top: 15px;
        }
        
        .badge {
            display: inline-block;
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            color: #ffffff;
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 500;
            margin: 0 5px;
        }
        
        .badge.gdpr {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        }
        
        /* Content sections */
        .content-section {
            padding: 40px 30px;
            background-color: #1e293b;
        }
        
        .content-section.alternate {
            background-color: #0f172a;
        }
        
        .content-section.hero {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            position: relative;
            text-align: center;
        }
        
        .content-section.hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"60\" height=\"60\" viewBox=\"0 0 60 60\"><g fill-opacity=\"0.05\" fill=\"%23ffffff\"><rect width=\"1\" height=\"1\"/></g></svg>');
            background-size: 60px 60px;
        }
        
        .hero-content {
            position: relative;
            z-index: 1;
        }
        
        /* Typography */
        .headline {
            font-size: 28px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 20px;
            line-height: 1.3;
        }
        
        .hero-headline {
            font-size: 32px;
            font-weight: 700;
            color: #ffffff;
            margin-bottom: 15px;
            line-height: 1.2;
        }
        
        .subheading {
            font-size: 20px;
            font-weight: 500;
            color: #60a5fa;
            margin-bottom: 15px;
            line-height: 1.4;
        }
        
        .body-text {
            font-size: 16px;
            color: #cbd5e1;
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .section-heading {
            font-size: 24px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 20px;
            text-align: center;
        }
        
        /* Buttons */
        .btn-primary {
            display: inline-block;
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: #ffffff !important;
            padding: 14px 28px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            font-size: 16px;
            border: none;
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3);
            transition: all 0.3s ease;
            margin: 10px;
        }
        
        .btn-secondary {
            display: inline-block;
            background: transparent;
            color: #60a5fa !important;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            font-size: 16px;
            border: 2px solid #3b82f6;
            transition: all 0.3s ease;
            margin: 10px;
        }
        
        .btn-large {
            padding: 16px 32px;
            font-size: 18px;
            font-weight: 600;
            border-radius: 10px;
            box-shadow: 0 8px 25px rgba(37, 99, 235, 0.4);
        }
        
        /* Feature boxes */
        .feature-box {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border: 1px solid #475569;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .feature-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 50%;
            margin: 0 auto 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        
        .feature-box h3 {
            color: #ffffff;
            margin-bottom: 10px;
            font-size: 18px;
            font-weight: 600;
        }
        
        /* Steps/Process */
        .step-item {
            background: linear-gradient(135deg, #334155 0%, #475569 100%);
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            border-left: 4px solid #3b82f6;
        }
        
        .step-number {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            color: #ffffff;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 18px;
            margin-right: 20px;
            flex-shrink: 0;
        }
        
        .step-content h3 {
            color: #ffffff;
            font-size: 18px;
            margin-bottom: 8px;
            font-weight: 600;
        }
        
        .step-content p {
            color: #cbd5e1;
            font-size: 15px;
            margin: 0;
        }
        
        /* Grid layouts */
        .features-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin: 30px 0;
        }
        
        .feature-card {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border: 1px solid #475569;
            border-radius: 12px;
            padding: 25px;
            text-align: center;
        }
        
        .feature-card .feature-icon {
            font-size: 32px;
            margin-bottom: 15px;
            display: block;
            width: auto;
            height: auto;
            background: none;
        }
        
        .feature-card h4 {
            color: #ffffff;
            font-size: 16px;
            margin-bottom: 10px;
            font-weight: 600;
        }
        
        .feature-card p {
            color: #94a3b8;
            font-size: 14px;
            margin: 0;
        }
        
        /* Social media */
        .social-links {
            text-align: center;
            padding: 20px 0;
        }
        
        .social-links a {
            display: inline-block;
            margin: 0 10px;
            padding: 12px;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 8px;
            text-decoration: none;
            color: #ffffff;
            font-size: 18px;
        }
        
        /* Footer */
        .email-footer {
            background-color: #0f172a;
            padding: 30px 20px;
            text-align: center;
            border-top: 1px solid #334155;
        }
        
        .footer-text {
            font-size: 14px;
            color: #64748b;
            margin-bottom: 15px;
        }
        
        .footer-links {
            margin: 20px 0;
        }
        
        .footer-links a {
            color: #60a5fa;
            text-decoration: none;
            margin: 0 15px;
            font-size: 14px;
        }
        
        /* Mautic specific styles */
        .mautic-slot {
            display: block;
        }
        
        .mautic-content {
            margin: 0;
            padding: 0;
        }
        
        /* Responsive styles */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
            }
            
            .content-section {
                padding: 25px 20px !important;
            }
            
            .headline {
                font-size: 24px !important;
            }
            
            .hero-headline {
                font-size: 28px !important;
            }
            
            .subheading {
                font-size: 18px !important;
            }
            
            .btn-primary,
            .btn-secondary {
                display: block !important;
                width: 100% !important;
                text-align: center !important;
                margin: 10px 0 !important;
            }
            
            .features-grid {
                grid-template-columns: 1fr !important;
                gap: 15px !important;
            }
            
            .step-item {
                flex-direction: column !important;
                text-align: center !important;
            }
            
            .step-number {
                margin-right: 0 !important;
                margin-bottom: 15px !important;
            }
            
            .social-links a {
                margin: 0 5px !important;
            }
        }
        
        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            .body-text {
                color: #e2e8f0 !important;
            }
        }
        
        /* Print styles */
        @media print {
            .social-links,
            .footer-links {
                display: none !important;
            }
        }
    </style>
</head>
<body>
    <div class=\"email-container\">
        <!-- Header -->
        <div class=\"email-header\">
            <div data-slot=\"header\">
                <img src=\"";
        // line 512
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("logo_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["logo_url"]) || array_key_exists("logo_url", $context) ? $context["logo_url"] : (function () { throw new RuntimeError('Variable "logo_url" does not exist.', 512, $this->source); })()), "https://demo.cause.buzz/assets/causebuzz-logo.png")) : ("https://demo.cause.buzz/assets/causebuzz-logo.png")), "html", null, true);
        yield "\" alt=\"Cause.Buzz Logo\" class=\"logo\" />
                <div class=\"header-badges\">
                    <span class=\"badge\">🔒 DSGVO</span>
                    <span class=\"badge gdpr\">🇪🇺 EU-Server</span>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div data-slot=\"body\">
            <!-- Hero Section -->
            ";
        // line 523
        if (((isset($context["template_type"]) || array_key_exists("template_type", $context) ? $context["template_type"] : (function () { throw new RuntimeError('Variable "template_type" does not exist.', 523, $this->source); })()) == "welcome")) {
            // line 524
            yield "            <div class=\"content-section hero\">
                <div class=\"hero-content\">
                    <h1 class=\"hero-headline\">";
            // line 526
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("welcome_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["welcome_headline"]) || array_key_exists("welcome_headline", $context) ? $context["welcome_headline"] : (function () { throw new RuntimeError('Variable "welcome_headline" does not exist.', 526, $this->source); })()), "Willkommen bei Cause.Buzz!")) : ("Willkommen bei Cause.Buzz!")), "html", null, true);
            yield "</h1>
                    <p class=\"subheading\">";
            // line 527
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("welcome_subheading", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["welcome_subheading"]) || array_key_exists("welcome_subheading", $context) ? $context["welcome_subheading"] : (function () { throw new RuntimeError('Variable "welcome_subheading" does not exist.', 527, $this->source); })()), "Schön, dass Sie sich für die professionelle Marketing-Plattform entschieden haben.")) : ("Schön, dass Sie sich für die professionelle Marketing-Plattform entschieden haben.")), "html", null, true);
            yield "</p>
                    <p class=\"body-text\">";
            // line 528
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("welcome_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["welcome_text"]) || array_key_exists("welcome_text", $context) ? $context["welcome_text"] : (function () { throw new RuntimeError('Variable "welcome_text" does not exist.', 528, $this->source); })()), "Sie haben den ersten Schritt zu erfolgreichem Marketing gemacht. Lassen Sie uns gemeinsam Ihre Marketing-Ziele erreichen.")) : ("Sie haben den ersten Schritt zu erfolgreichem Marketing gemacht. Lassen Sie uns gemeinsam Ihre Marketing-Ziele erreichen.")), "html", null, true);
            yield "</p>
                    <div style=\"margin: 30px 0;\">
                        <a href=\"";
            // line 530
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["cta_url"]) || array_key_exists("cta_url", $context) ? $context["cta_url"] : (function () { throw new RuntimeError('Variable "cta_url" does not exist.', 530, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" class=\"btn-primary btn-large\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["cta_text"]) || array_key_exists("cta_text", $context) ? $context["cta_text"] : (function () { throw new RuntimeError('Variable "cta_text" does not exist.', 530, $this->source); })()), "Jetzt loslegen")) : ("Jetzt loslegen")), "html", null, true);
            yield "</a>
                    </div>
                </div>
            </div>
            ";
        } else {
            // line 535
            yield "            <!-- Standard Newsletter Hero -->
            <div class=\"content-section\">
                <h1 class=\"headline\">";
            // line 537
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["headline"]) || array_key_exists("headline", $context) ? $context["headline"] : (function () { throw new RuntimeError('Variable "headline" does not exist.', 537, $this->source); })()), "Marketing-Power vereint")) : ("Marketing-Power vereint")), "html", null, true);
            yield "</h1>
                <p class=\"body-text\">";
            // line 538
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("intro_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["intro_text"]) || array_key_exists("intro_text", $context) ? $context["intro_text"] : (function () { throw new RuntimeError('Variable "intro_text" does not exist.', 538, $this->source); })()), "Willkommen zu unserem Newsletter! Hier erhalten Sie die neuesten Updates, Marketing-Tipps und Einblicke in die Welt der professionellen Newsletter-Tools und Marketing Automation.")) : ("Willkommen zu unserem Newsletter! Hier erhalten Sie die neuesten Updates, Marketing-Tipps und Einblicke in die Welt der professionellen Newsletter-Tools und Marketing Automation.")), "html", null, true);
            yield "</p>
                <div style=\"text-align: center; margin: 30px 0;\">
                    <a href=\"";
            // line 540
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("main_cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["main_cta_url"]) || array_key_exists("main_cta_url", $context) ? $context["main_cta_url"] : (function () { throw new RuntimeError('Variable "main_cta_url" does not exist.', 540, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" class=\"btn-primary\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("main_cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["main_cta_text"]) || array_key_exists("main_cta_text", $context) ? $context["main_cta_text"] : (function () { throw new RuntimeError('Variable "main_cta_text" does not exist.', 540, $this->source); })()), "Jetzt entdecken")) : ("Jetzt entdecken")), "html", null, true);
            yield "</a>
                </div>
            </div>
            ";
        }
        // line 544
        yield "            
            ";
        // line 545
        if ((($tmp = (isset($context["features_section"]) || array_key_exists("features_section", $context) ? $context["features_section"] : (function () { throw new RuntimeError('Variable "features_section" does not exist.', 545, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 546
            yield "            <!-- Features Section -->
            <div class=\"content-section alternate\">
                <h2 class=\"section-heading\">";
            // line 548
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("features_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["features_headline"]) || array_key_exists("features_headline", $context) ? $context["features_headline"] : (function () { throw new RuntimeError('Variable "features_headline" does not exist.', 548, $this->source); })()), "Neue Features diese Woche")) : ("Neue Features diese Woche")), "html", null, true);
            yield "</h2>
                
                ";
            // line 550
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["features"]) || array_key_exists("features", $context) ? $context["features"] : (function () { throw new RuntimeError('Variable "features" does not exist.', 550, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["feature"]) {
                // line 551
                yield "                <div class=\"feature-box\">
                    <div class=\"feature-icon\">";
                // line 552
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "icon", [], "any", true, true, false, 552)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "icon", [], "any", false, false, false, 552), "📊")) : ("📊")), "html", null, true);
                yield "</div>
                    <h3>";
                // line 553
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "title", [], "any", true, true, false, 553)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "title", [], "any", false, false, false, 553), "Feature Title")) : ("Feature Title")), "html", null, true);
                yield "</h3>
                    <p class=\"body-text\">";
                // line 554
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "description", [], "any", true, true, false, 554)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "description", [], "any", false, false, false, 554), "Feature description goes here.")) : ("Feature description goes here.")), "html", null, true);
                yield "</p>
                </div>
                ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['feature'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 557
            yield "            </div>
            ";
        }
        // line 559
        yield "            
            ";
        // line 560
        if ((($tmp = (isset($context["steps_section"]) || array_key_exists("steps_section", $context) ? $context["steps_section"] : (function () { throw new RuntimeError('Variable "steps_section" does not exist.', 560, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 561
            yield "            <!-- Steps Section -->
            <div class=\"content-section\">
                <h2 class=\"section-heading\">";
            // line 563
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("steps_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["steps_headline"]) || array_key_exists("steps_headline", $context) ? $context["steps_headline"] : (function () { throw new RuntimeError('Variable "steps_headline" does not exist.', 563, $this->source); })()), "Ihre ersten Schritte")) : ("Ihre ersten Schritte")), "html", null, true);
            yield "</h2>
                
                <div class=\"steps-container\">
                    ";
            // line 566
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["steps"]) || array_key_exists("steps", $context) ? $context["steps"] : (function () { throw new RuntimeError('Variable "steps" does not exist.', 566, $this->source); })()));
            $context['loop'] = [
              'parent' => $context['_parent'],
              'index0' => 0,
              'index'  => 1,
              'first'  => true,
            ];
            if (is_array($context['_seq']) || (is_object($context['_seq']) && $context['_seq'] instanceof \Countable)) {
                $length = count($context['_seq']);
                $context['loop']['revindex0'] = $length - 1;
                $context['loop']['revindex'] = $length;
                $context['loop']['length'] = $length;
                $context['loop']['last'] = 1 === $length;
            }
            foreach ($context['_seq'] as $context["_key"] => $context["step"]) {
                // line 567
                yield "                    <div class=\"step-item\">
                        <div class=\"step-number\">";
                // line 568
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["loop"], "index", [], "any", false, false, false, 568), "html", null, true);
                yield "</div>
                        <div class=\"step-content\">
                            <h3>";
                // line 570
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["step"], "title", [], "any", true, true, false, 570)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["step"], "title", [], "any", false, false, false, 570), "Step Title")) : ("Step Title")), "html", null, true);
                yield "</h3>
                            <p>";
                // line 571
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["step"], "description", [], "any", true, true, false, 571)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["step"], "description", [], "any", false, false, false, 571), "Step description goes here.")) : ("Step description goes here.")), "html", null, true);
                yield "</p>
                        </div>
                    </div>
                    ";
                ++$context['loop']['index0'];
                ++$context['loop']['index'];
                $context['loop']['first'] = false;
                if (isset($context['loop']['revindex0'], $context['loop']['revindex'])) {
                    --$context['loop']['revindex0'];
                    --$context['loop']['revindex'];
                    $context['loop']['last'] = 0 === $context['loop']['revindex0'];
                }
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['step'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 575
            yield "                </div>
                
                <div style=\"text-align: center; margin: 30px 0;\">
                    <a href=\"";
            // line 578
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("steps_cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["steps_cta_url"]) || array_key_exists("steps_cta_url", $context) ? $context["steps_cta_url"] : (function () { throw new RuntimeError('Variable "steps_cta_url" does not exist.', 578, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" class=\"btn-secondary\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("steps_cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["steps_cta_text"]) || array_key_exists("steps_cta_text", $context) ? $context["steps_cta_text"] : (function () { throw new RuntimeError('Variable "steps_cta_text" does not exist.', 578, $this->source); })()), "Anleitung ansehen")) : ("Anleitung ansehen")), "html", null, true);
            yield "</a>
                </div>
            </div>
            ";
        }
        // line 582
        yield "            
            ";
        // line 583
        if ((($tmp = (isset($context["content_section"]) || array_key_exists("content_section", $context) ? $context["content_section"] : (function () { throw new RuntimeError('Variable "content_section" does not exist.', 583, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 584
            yield "            <!-- Custom Content Section -->
            <div class=\"content-section\">
                <h2 class=\"subheading\">";
            // line 586
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("content_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["content_headline"]) || array_key_exists("content_headline", $context) ? $context["content_headline"] : (function () { throw new RuntimeError('Variable "content_headline" does not exist.', 586, $this->source); })()), "Marketing-Tipp der Woche")) : ("Marketing-Tipp der Woche")), "html", null, true);
            yield "</h2>
                <p class=\"body-text\">";
            // line 587
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("content_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["content_text"]) || array_key_exists("content_text", $context) ? $context["content_text"] : (function () { throw new RuntimeError('Variable "content_text" does not exist.', 587, $this->source); })()), "Hier steht Ihr individueller Content...")) : ("Hier steht Ihr individueller Content...")), "html", null, true);
            yield "</p>
                <div style=\"text-align: center; margin: 25px 0;\">
                    <a href=\"";
            // line 589
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("content_cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["content_cta_url"]) || array_key_exists("content_cta_url", $context) ? $context["content_cta_url"] : (function () { throw new RuntimeError('Variable "content_cta_url" does not exist.', 589, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" class=\"btn-secondary\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("content_cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["content_cta_text"]) || array_key_exists("content_cta_text", $context) ? $context["content_cta_text"] : (function () { throw new RuntimeError('Variable "content_cta_text" does not exist.', 589, $this->source); })()), "Mehr erfahren")) : ("Mehr erfahren")), "html", null, true);
            yield "</a>
                </div>
            </div>
            ";
        }
        // line 593
        yield "            
            <!-- Call to Action Section -->
            <div class=\"content-section alternate\" style=\"text-align: center;\">
                <h2 class=\"subheading\">";
        // line 596
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("final_cta_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["final_cta_headline"]) || array_key_exists("final_cta_headline", $context) ? $context["final_cta_headline"] : (function () { throw new RuntimeError('Variable "final_cta_headline" does not exist.', 596, $this->source); })()), "Bereit für den nächsten Schritt?")) : ("Bereit für den nächsten Schritt?")), "html", null, true);
        yield "</h2>
                <p class=\"body-text\">";
        // line 597
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("final_cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["final_cta_text"]) || array_key_exists("final_cta_text", $context) ? $context["final_cta_text"] : (function () { throw new RuntimeError('Variable "final_cta_text" does not exist.', 597, $this->source); })()), "Vereinbaren Sie noch heute Ihre kostenlose Demo und entdecken Sie, wie Cause.Buzz Ihr Marketing revolutionieren kann.")) : ("Vereinbaren Sie noch heute Ihre kostenlose Demo und entdecken Sie, wie Cause.Buzz Ihr Marketing revolutionieren kann.")), "html", null, true);
        yield "</p>
                <div style=\"margin: 30px 0;\">
                    <a href=\"";
        // line 599
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("final_cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["final_cta_url"]) || array_key_exists("final_cta_url", $context) ? $context["final_cta_url"] : (function () { throw new RuntimeError('Variable "final_cta_url" does not exist.', 599, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\" class=\"btn-primary\">";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("final_cta_button_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["final_cta_button_text"]) || array_key_exists("final_cta_button_text", $context) ? $context["final_cta_button_text"] : (function () { throw new RuntimeError('Variable "final_cta_button_text" does not exist.', 599, $this->source); })()), "Kostenlose Demo")) : ("Kostenlose Demo")), "html", null, true);
        yield "</a>
                </div>
            </div>
        </div>
        
        <!-- Social Media -->
        <div class=\"social-links\">
            <a href=\"";
        // line 606
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("social_linkedin", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["social_linkedin"]) || array_key_exists("social_linkedin", $context) ? $context["social_linkedin"] : (function () { throw new RuntimeError('Variable "social_linkedin" does not exist.', 606, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\" aria-label=\"LinkedIn\">📱</a>
            <a href=\"";
        // line 607
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("social_twitter", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["social_twitter"]) || array_key_exists("social_twitter", $context) ? $context["social_twitter"] : (function () { throw new RuntimeError('Variable "social_twitter" does not exist.', 607, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\" aria-label=\"Twitter\">🐦</a>
            <a href=\"";
        // line 608
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("social_youtube", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["social_youtube"]) || array_key_exists("social_youtube", $context) ? $context["social_youtube"] : (function () { throw new RuntimeError('Variable "social_youtube" does not exist.', 608, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\" aria-label=\"YouTube\">📺</a>
        </div>
        
        <!-- Footer -->
        <div class=\"email-footer\">
            <div data-slot=\"footer\">
                <p class=\"footer-text\">
                    ";
        // line 615
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("company_name", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["company_name"]) || array_key_exists("company_name", $context) ? $context["company_name"] : (function () { throw new RuntimeError('Variable "company_name" does not exist.', 615, $this->source); })()), "Cause.Buzz")) : ("Cause.Buzz")), "html", null, true);
        yield " - ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("company_tagline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["company_tagline"]) || array_key_exists("company_tagline", $context) ? $context["company_tagline"] : (function () { throw new RuntimeError('Variable "company_tagline" does not exist.', 615, $this->source); })()), "Die professionelle Marketing-Plattform")) : ("Die professionelle Marketing-Plattform")), "html", null, true);
        yield "<br>
                    ";
        // line 616
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("company_address", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["company_address"]) || array_key_exists("company_address", $context) ? $context["company_address"] : (function () { throw new RuntimeError('Variable "company_address" does not exist.', 616, $this->source); })()), "40 Im alten Riet, 9494 Schaan, Liechtenstein")) : ("40 Im alten Riet, 9494 Schaan, Liechtenstein")), "html", null, true);
        yield "
                </p>
                
                <div class=\"footer-links\">
                    <a href=\"";
        // line 620
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("privacy_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["privacy_url"]) || array_key_exists("privacy_url", $context) ? $context["privacy_url"] : (function () { throw new RuntimeError('Variable "privacy_url" does not exist.', 620, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\">";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("privacy_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["privacy_text"]) || array_key_exists("privacy_text", $context) ? $context["privacy_text"] : (function () { throw new RuntimeError('Variable "privacy_text" does not exist.', 620, $this->source); })()), "Datenschutz")) : ("Datenschutz")), "html", null, true);
        yield "</a>
                    <a href=\"";
        // line 621
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("imprint_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["imprint_url"]) || array_key_exists("imprint_url", $context) ? $context["imprint_url"] : (function () { throw new RuntimeError('Variable "imprint_url" does not exist.', 621, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\">";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("imprint_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["imprint_text"]) || array_key_exists("imprint_text", $context) ? $context["imprint_text"] : (function () { throw new RuntimeError('Variable "imprint_text" does not exist.', 621, $this->source); })()), "Impressum")) : ("Impressum")), "html", null, true);
        yield "</a>
                    <a href=\"";
        // line 622
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("unsubscribe_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["unsubscribe_url"]) || array_key_exists("unsubscribe_url", $context) ? $context["unsubscribe_url"] : (function () { throw new RuntimeError('Variable "unsubscribe_url" does not exist.', 622, $this->source); })()), "{unsubscribe_url}")) : ("{unsubscribe_url}")), "html", null, true);
        yield "\">";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("unsubscribe_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["unsubscribe_text"]) || array_key_exists("unsubscribe_text", $context) ? $context["unsubscribe_text"] : (function () { throw new RuntimeError('Variable "unsubscribe_text" does not exist.', 622, $this->source); })()), "Abmelden")) : ("Abmelden")), "html", null, true);
        yield "</a>
                </div>
                
                <p class=\"footer-text\">
                    © ";
        // line 626
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate("now", "Y"), "html", null, true);
        yield " ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("company_name", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["company_name"]) || array_key_exists("company_name", $context) ? $context["company_name"] : (function () { throw new RuntimeError('Variable "company_name" does not exist.', 626, $this->source); })()), "Cause.Buzz")) : ("Cause.Buzz")), "html", null, true);
        yield ". ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("copyright_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["copyright_text"]) || array_key_exists("copyright_text", $context) ? $context["copyright_text"] : (function () { throw new RuntimeError('Variable "copyright_text" does not exist.', 626, $this->source); })()), "Alle Rechte vorbehalten.")) : ("Alle Rechte vorbehalten.")), "html", null, true);
        yield "
                </p>
            </div>
        </div>
    </div>
    
    <!-- Mautic tracking pixel -->
    ";
        // line 633
        if ((($tmp = (isset($context["tracking_pixel"]) || array_key_exists("tracking_pixel", $context) ? $context["tracking_pixel"] : (function () { throw new RuntimeError('Variable "tracking_pixel" does not exist.', 633, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 634
            yield "    <img src=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["tracking_pixel"]) || array_key_exists("tracking_pixel", $context) ? $context["tracking_pixel"] : (function () { throw new RuntimeError('Variable "tracking_pixel" does not exist.', 634, $this->source); })()), "html", null, true);
            yield "\" style=\"display:none;\" alt=\"\" />
    ";
        }
        // line 636
        yield "</body>
</html>PK
\000\000\000\000\000Y>[?G\000\000G\000\000\000\000\000html/message.html.twig<!DOCTYPE html>
<html lang=\"";
        // line 639
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("language", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["language"]) || array_key_exists("language", $context) ? $context["language"] : (function () { throw new RuntimeError('Variable "language" does not exist.', 639, $this->source); })()), "de")) : ("de")), "html", null, true);
        yield "\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>";
        // line 643
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 643, $this->source); })()), "Cause.Buzz Newsletter")) : ("Cause.Buzz Newsletter")), "html", null, true);
        yield "</title>
    <!--[if mso]>
    <noscript>
        <xml>
            <o:OfficeDocumentSettings>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
    </noscript>
    <![endif]-->
    <style>
        /* Reset and base styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #ffffff;
            background-color: #0f172a;
            margin: 0;
            padding: 0;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        
        table {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }
        
        img {
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
            -ms-interpolation-mode: bicubic;
            max-width: 100%;
        }
        
        /* Main container */
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
        }
        
        /* Header styles */
        .email-header {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            padding: 30px 20px;
            text-align: center;
            border-bottom: 2px solid #3b82f6;
        }
        
        .logo {
            max-width: 180px;
            height: auto;
            margin-bottom: 15px;
        }
        
        .header-badges {
            margin-top: 15px;
        }
        
        .badge {
            display: inline-block;
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            color: #ffffff;
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 500;
            margin: 0 5px;
        }
        
        .badge.gdpr {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        }
        
        /* Content sections */
        .content-section {
            padding: 40px 30px;
            background-color: #1e293b;
        }
        
        .content-section.alternate {
            background-color: #0f172a;
        }
        
        .content-section.hero {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            position: relative;
            text-align: center;
        }
        
        .content-section.hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"60\" height=\"60\" viewBox=\"0 0 60 60\"><g fill-opacity=\"0.05\" fill=\"%23ffffff\"><rect width=\"1\" height=\"1\"/></g></svg>');
            background-size: 60px 60px;
        }
        
        .hero-content {
            position: relative;
            z-index: 1;
        }
        
        /* Typography */
        .headline {
            font-size: 28px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 20px;
            line-height: 1.3;
        }
        
        .hero-headline {
            font-size: 32px;
            font-weight: 700;
            color: #ffffff;
            margin-bottom: 15px;
            line-height: 1.2;
        }
        
        .subheading {
            font-size: 20px;
            font-weight: 500;
            color: #60a5fa;
            margin-bottom: 15px;
            line-height: 1.4;
        }
        
        .body-text {
            font-size: 16px;
            color: #cbd5e1;
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .section-heading {
            font-size: 24px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 20px;
            text-align: center;
        }
        
        /* Buttons */
        .btn-primary {
            display: inline-block;
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: #ffffff !important;
            padding: 14px 28px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            font-size: 16px;
            border: none;
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3);
            transition: all 0.3s ease;
            margin: 10px;
        }
        
        .btn-secondary {
            display: inline-block;
            background: transparent;
            color: #60a5fa !important;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            font-size: 16px;
            border: 2px solid #3b82f6;
            transition: all 0.3s ease;
            margin: 10px;
        }
        
        .btn-large {
            padding: 16px 32px;
            font-size: 18px;
            font-weight: 600;
            border-radius: 10px;
            box-shadow: 0 8px 25px rgba(37, 99, 235, 0.4);
        }
        
        /* Feature boxes */
        .feature-box {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border: 1px solid #475569;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .feature-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 50%;
            margin: 0 auto 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        
        .feature-box h3 {
            color: #ffffff;
            margin-bottom: 10px;
            font-size: 18px;
            font-weight: 600;
        }
        
        /* Steps/Process */
        .step-item {
            background: linear-gradient(135deg, #334155 0%, #475569 100%);
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            border-left: 4px solid #3b82f6;
        }
        
        .step-number {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            color: #ffffff;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 18px;
            margin-right: 20px;
            flex-shrink: 0;
        }
        
        .step-content h3 {
            color: #ffffff;
            font-size: 18px;
            margin-bottom: 8px;
            font-weight: 600;
        }
        
        .step-content p {
            color: #cbd5e1;
            font-size: 15px;
            margin: 0;
        }
        
        /* Grid layouts */
        .features-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin: 30px 0;
        }
        
        .feature-card {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border: 1px solid #475569;
            border-radius: 12px;
            padding: 25px;
            text-align: center;
        }
        
        .feature-card .feature-icon {
            font-size: 32px;
            margin-bottom: 15px;
            display: block;
            width: auto;
            height: auto;
            background: none;
        }
        
        .feature-card h4 {
            color: #ffffff;
            font-size: 16px;
            margin-bottom: 10px;
            font-weight: 600;
        }
        
        .feature-card p {
            color: #94a3b8;
            font-size: 14px;
            margin: 0;
        }
        
        /* Social media */
        .social-links {
            text-align: center;
            padding: 20px 0;
        }
        
        .social-links a {
            display: inline-block;
            margin: 0 10px;
            padding: 12px;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 8px;
            text-decoration: none;
            color: #ffffff;
            font-size: 18px;
        }
        
        /* Footer */
        .email-footer {
            background-color: #0f172a;
            padding: 30px 20px;
            text-align: center;
            border-top: 1px solid #334155;
        }
        
        .footer-text {
            font-size: 14px;
            color: #64748b;
            margin-bottom: 15px;
        }
        
        .footer-links {
            margin: 20px 0;
        }
        
        .footer-links a {
            color: #60a5fa;
            text-decoration: none;
            margin: 0 15px;
            font-size: 14px;
        }
        
        /* Mautic specific styles */
        .mautic-slot {
            display: block;
        }
        
        .mautic-content {
            margin: 0;
            padding: 0;
        }
        
        /* Responsive styles */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
            }
            
            .content-section {
                padding: 25px 20px !important;
            }
            
            .headline {
                font-size: 24px !important;
            }
            
            .hero-headline {
                font-size: 28px !important;
            }
            
            .subheading {
                font-size: 18px !important;
            }
            
            .btn-primary,
            .btn-secondary {
                display: block !important;
                width: 100% !important;
                text-align: center !important;
                margin: 10px 0 !important;
            }
            
            .features-grid {
                grid-template-columns: 1fr !important;
                gap: 15px !important;
            }
            
            .step-item {
                flex-direction: column !important;
                text-align: center !important;
            }
            
            .step-number {
                margin-right: 0 !important;
                margin-bottom: 15px !important;
            }
            
            .social-links a {
                margin: 0 5px !important;
            }
        }
        
        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            .body-text {
                color: #e2e8f0 !important;
            }
        }
        
        /* Print styles */
        @media print {
            .social-links,
            .footer-links {
                display: none !important;
            }
        }
    </style>
</head>
<body>
    <div class=\"email-container\">
        <!-- Header -->
        <div class=\"email-header\">
            <div data-slot=\"header\">
                <img src=\"";
        // line 1067
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("logo_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["logo_url"]) || array_key_exists("logo_url", $context) ? $context["logo_url"] : (function () { throw new RuntimeError('Variable "logo_url" does not exist.', 1067, $this->source); })()), "https://demo.cause.buzz/assets/causebuzz-logo.png")) : ("https://demo.cause.buzz/assets/causebuzz-logo.png")), "html", null, true);
        yield "\" alt=\"Cause.Buzz Logo\" class=\"logo\" />
                <div class=\"header-badges\">
                    <span class=\"badge\">🔒 DSGVO</span>
                    <span class=\"badge gdpr\">🇪🇺 EU-Server</span>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div data-slot=\"body\">
            <!-- Hero Section -->
            ";
        // line 1078
        if (((isset($context["template_type"]) || array_key_exists("template_type", $context) ? $context["template_type"] : (function () { throw new RuntimeError('Variable "template_type" does not exist.', 1078, $this->source); })()) == "welcome")) {
            // line 1079
            yield "            <div class=\"content-section hero\">
                <div class=\"hero-content\">
                    <h1 class=\"hero-headline\">";
            // line 1081
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("welcome_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["welcome_headline"]) || array_key_exists("welcome_headline", $context) ? $context["welcome_headline"] : (function () { throw new RuntimeError('Variable "welcome_headline" does not exist.', 1081, $this->source); })()), "Willkommen bei Cause.Buzz!")) : ("Willkommen bei Cause.Buzz!")), "html", null, true);
            yield "</h1>
                    <p class=\"subheading\">";
            // line 1082
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("welcome_subheading", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["welcome_subheading"]) || array_key_exists("welcome_subheading", $context) ? $context["welcome_subheading"] : (function () { throw new RuntimeError('Variable "welcome_subheading" does not exist.', 1082, $this->source); })()), "Schön, dass Sie sich für die professionelle Marketing-Plattform entschieden haben.")) : ("Schön, dass Sie sich für die professionelle Marketing-Plattform entschieden haben.")), "html", null, true);
            yield "</p>
                    <p class=\"body-text\">";
            // line 1083
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("welcome_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["welcome_text"]) || array_key_exists("welcome_text", $context) ? $context["welcome_text"] : (function () { throw new RuntimeError('Variable "welcome_text" does not exist.', 1083, $this->source); })()), "Sie haben den ersten Schritt zu erfolgreichem Marketing gemacht. Lassen Sie uns gemeinsam Ihre Marketing-Ziele erreichen.")) : ("Sie haben den ersten Schritt zu erfolgreichem Marketing gemacht. Lassen Sie uns gemeinsam Ihre Marketing-Ziele erreichen.")), "html", null, true);
            yield "</p>
                    <div style=\"margin: 30px 0;\">
                        <a href=\"";
            // line 1085
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["cta_url"]) || array_key_exists("cta_url", $context) ? $context["cta_url"] : (function () { throw new RuntimeError('Variable "cta_url" does not exist.', 1085, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" class=\"btn-primary btn-large\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["cta_text"]) || array_key_exists("cta_text", $context) ? $context["cta_text"] : (function () { throw new RuntimeError('Variable "cta_text" does not exist.', 1085, $this->source); })()), "Jetzt loslegen")) : ("Jetzt loslegen")), "html", null, true);
            yield "</a>
                    </div>
                </div>
            </div>
            ";
        } else {
            // line 1090
            yield "            <!-- Standard Newsletter Hero -->
            <div class=\"content-section\">
                <h1 class=\"headline\">";
            // line 1092
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["headline"]) || array_key_exists("headline", $context) ? $context["headline"] : (function () { throw new RuntimeError('Variable "headline" does not exist.', 1092, $this->source); })()), "Marketing-Power vereint")) : ("Marketing-Power vereint")), "html", null, true);
            yield "</h1>
                <p class=\"body-text\">";
            // line 1093
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("intro_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["intro_text"]) || array_key_exists("intro_text", $context) ? $context["intro_text"] : (function () { throw new RuntimeError('Variable "intro_text" does not exist.', 1093, $this->source); })()), "Willkommen zu unserem Newsletter! Hier erhalten Sie die neuesten Updates, Marketing-Tipps und Einblicke in die Welt der professionellen Newsletter-Tools und Marketing Automation.")) : ("Willkommen zu unserem Newsletter! Hier erhalten Sie die neuesten Updates, Marketing-Tipps und Einblicke in die Welt der professionellen Newsletter-Tools und Marketing Automation.")), "html", null, true);
            yield "</p>
                <div style=\"text-align: center; margin: 30px 0;\">
                    <a href=\"";
            // line 1095
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("main_cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["main_cta_url"]) || array_key_exists("main_cta_url", $context) ? $context["main_cta_url"] : (function () { throw new RuntimeError('Variable "main_cta_url" does not exist.', 1095, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" class=\"btn-primary\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("main_cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["main_cta_text"]) || array_key_exists("main_cta_text", $context) ? $context["main_cta_text"] : (function () { throw new RuntimeError('Variable "main_cta_text" does not exist.', 1095, $this->source); })()), "Jetzt entdecken")) : ("Jetzt entdecken")), "html", null, true);
            yield "</a>
                </div>
            </div>
            ";
        }
        // line 1099
        yield "            
            ";
        // line 1100
        if ((($tmp = (isset($context["features_section"]) || array_key_exists("features_section", $context) ? $context["features_section"] : (function () { throw new RuntimeError('Variable "features_section" does not exist.', 1100, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 1101
            yield "            <!-- Features Section -->
            <div class=\"content-section alternate\">
                <h2 class=\"section-heading\">";
            // line 1103
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("features_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["features_headline"]) || array_key_exists("features_headline", $context) ? $context["features_headline"] : (function () { throw new RuntimeError('Variable "features_headline" does not exist.', 1103, $this->source); })()), "Neue Features diese Woche")) : ("Neue Features diese Woche")), "html", null, true);
            yield "</h2>
                
                ";
            // line 1105
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["features"]) || array_key_exists("features", $context) ? $context["features"] : (function () { throw new RuntimeError('Variable "features" does not exist.', 1105, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["feature"]) {
                // line 1106
                yield "                <div class=\"feature-box\">
                    <div class=\"feature-icon\">";
                // line 1107
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "icon", [], "any", true, true, false, 1107)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "icon", [], "any", false, false, false, 1107), "📊")) : ("📊")), "html", null, true);
                yield "</div>
                    <h3>";
                // line 1108
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "title", [], "any", true, true, false, 1108)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "title", [], "any", false, false, false, 1108), "Feature Title")) : ("Feature Title")), "html", null, true);
                yield "</h3>
                    <p class=\"body-text\">";
                // line 1109
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "description", [], "any", true, true, false, 1109)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["feature"], "description", [], "any", false, false, false, 1109), "Feature description goes here.")) : ("Feature description goes here.")), "html", null, true);
                yield "</p>
                </div>
                ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['feature'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 1112
            yield "            </div>
            ";
        }
        // line 1114
        yield "            
            ";
        // line 1115
        if ((($tmp = (isset($context["steps_section"]) || array_key_exists("steps_section", $context) ? $context["steps_section"] : (function () { throw new RuntimeError('Variable "steps_section" does not exist.', 1115, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 1116
            yield "            <!-- Steps Section -->
            <div class=\"content-section\">
                <h2 class=\"section-heading\">";
            // line 1118
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("steps_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["steps_headline"]) || array_key_exists("steps_headline", $context) ? $context["steps_headline"] : (function () { throw new RuntimeError('Variable "steps_headline" does not exist.', 1118, $this->source); })()), "Ihre ersten Schritte")) : ("Ihre ersten Schritte")), "html", null, true);
            yield "</h2>
                
                <div class=\"steps-container\">
                    ";
            // line 1121
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["steps"]) || array_key_exists("steps", $context) ? $context["steps"] : (function () { throw new RuntimeError('Variable "steps" does not exist.', 1121, $this->source); })()));
            $context['loop'] = [
              'parent' => $context['_parent'],
              'index0' => 0,
              'index'  => 1,
              'first'  => true,
            ];
            if (is_array($context['_seq']) || (is_object($context['_seq']) && $context['_seq'] instanceof \Countable)) {
                $length = count($context['_seq']);
                $context['loop']['revindex0'] = $length - 1;
                $context['loop']['revindex'] = $length;
                $context['loop']['length'] = $length;
                $context['loop']['last'] = 1 === $length;
            }
            foreach ($context['_seq'] as $context["_key"] => $context["step"]) {
                // line 1122
                yield "                    <div class=\"step-item\">
                        <div class=\"step-number\">";
                // line 1123
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["loop"], "index", [], "any", false, false, false, 1123), "html", null, true);
                yield "</div>
                        <div class=\"step-content\">
                            <h3>";
                // line 1125
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["step"], "title", [], "any", true, true, false, 1125)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["step"], "title", [], "any", false, false, false, 1125), "Step Title")) : ("Step Title")), "html", null, true);
                yield "</h3>
                            <p>";
                // line 1126
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, $context["step"], "description", [], "any", true, true, false, 1126)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, $context["step"], "description", [], "any", false, false, false, 1126), "Step description goes here.")) : ("Step description goes here.")), "html", null, true);
                yield "</p>
                        </div>
                    </div>
                    ";
                ++$context['loop']['index0'];
                ++$context['loop']['index'];
                $context['loop']['first'] = false;
                if (isset($context['loop']['revindex0'], $context['loop']['revindex'])) {
                    --$context['loop']['revindex0'];
                    --$context['loop']['revindex'];
                    $context['loop']['last'] = 0 === $context['loop']['revindex0'];
                }
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['step'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 1130
            yield "                </div>
                
                <div style=\"text-align: center; margin: 30px 0;\">
                    <a href=\"";
            // line 1133
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("steps_cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["steps_cta_url"]) || array_key_exists("steps_cta_url", $context) ? $context["steps_cta_url"] : (function () { throw new RuntimeError('Variable "steps_cta_url" does not exist.', 1133, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" class=\"btn-secondary\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("steps_cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["steps_cta_text"]) || array_key_exists("steps_cta_text", $context) ? $context["steps_cta_text"] : (function () { throw new RuntimeError('Variable "steps_cta_text" does not exist.', 1133, $this->source); })()), "Anleitung ansehen")) : ("Anleitung ansehen")), "html", null, true);
            yield "</a>
                </div>
            </div>
            ";
        }
        // line 1137
        yield "            
            ";
        // line 1138
        if ((($tmp = (isset($context["content_section"]) || array_key_exists("content_section", $context) ? $context["content_section"] : (function () { throw new RuntimeError('Variable "content_section" does not exist.', 1138, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 1139
            yield "            <!-- Custom Content Section -->
            <div class=\"content-section\">
                <h2 class=\"subheading\">";
            // line 1141
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("content_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["content_headline"]) || array_key_exists("content_headline", $context) ? $context["content_headline"] : (function () { throw new RuntimeError('Variable "content_headline" does not exist.', 1141, $this->source); })()), "Marketing-Tipp der Woche")) : ("Marketing-Tipp der Woche")), "html", null, true);
            yield "</h2>
                <p class=\"body-text\">";
            // line 1142
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("content_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["content_text"]) || array_key_exists("content_text", $context) ? $context["content_text"] : (function () { throw new RuntimeError('Variable "content_text" does not exist.', 1142, $this->source); })()), "Hier steht Ihr individueller Content...")) : ("Hier steht Ihr individueller Content...")), "html", null, true);
            yield "</p>
                <div style=\"text-align: center; margin: 25px 0;\">
                    <a href=\"";
            // line 1144
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("content_cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["content_cta_url"]) || array_key_exists("content_cta_url", $context) ? $context["content_cta_url"] : (function () { throw new RuntimeError('Variable "content_cta_url" does not exist.', 1144, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" class=\"btn-secondary\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("content_cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["content_cta_text"]) || array_key_exists("content_cta_text", $context) ? $context["content_cta_text"] : (function () { throw new RuntimeError('Variable "content_cta_text" does not exist.', 1144, $this->source); })()), "Mehr erfahren")) : ("Mehr erfahren")), "html", null, true);
            yield "</a>
                </div>
            </div>
            ";
        }
        // line 1148
        yield "            
            <!-- Call to Action Section -->
            <div class=\"content-section alternate\" style=\"text-align: center;\">
                <h2 class=\"subheading\">";
        // line 1151
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("final_cta_headline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["final_cta_headline"]) || array_key_exists("final_cta_headline", $context) ? $context["final_cta_headline"] : (function () { throw new RuntimeError('Variable "final_cta_headline" does not exist.', 1151, $this->source); })()), "Bereit für den nächsten Schritt?")) : ("Bereit für den nächsten Schritt?")), "html", null, true);
        yield "</h2>
                <p class=\"body-text\">";
        // line 1152
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("final_cta_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["final_cta_text"]) || array_key_exists("final_cta_text", $context) ? $context["final_cta_text"] : (function () { throw new RuntimeError('Variable "final_cta_text" does not exist.', 1152, $this->source); })()), "Vereinbaren Sie noch heute Ihre kostenlose Demo und entdecken Sie, wie Cause.Buzz Ihr Marketing revolutionieren kann.")) : ("Vereinbaren Sie noch heute Ihre kostenlose Demo und entdecken Sie, wie Cause.Buzz Ihr Marketing revolutionieren kann.")), "html", null, true);
        yield "</p>
                <div style=\"margin: 30px 0;\">
                    <a href=\"";
        // line 1154
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("final_cta_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["final_cta_url"]) || array_key_exists("final_cta_url", $context) ? $context["final_cta_url"] : (function () { throw new RuntimeError('Variable "final_cta_url" does not exist.', 1154, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\" class=\"btn-primary\">";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("final_cta_button_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["final_cta_button_text"]) || array_key_exists("final_cta_button_text", $context) ? $context["final_cta_button_text"] : (function () { throw new RuntimeError('Variable "final_cta_button_text" does not exist.', 1154, $this->source); })()), "Kostenlose Demo")) : ("Kostenlose Demo")), "html", null, true);
        yield "</a>
                </div>
            </div>
        </div>
        
        <!-- Social Media -->
        <div class=\"social-links\">
            <a href=\"";
        // line 1161
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("social_linkedin", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["social_linkedin"]) || array_key_exists("social_linkedin", $context) ? $context["social_linkedin"] : (function () { throw new RuntimeError('Variable "social_linkedin" does not exist.', 1161, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\" aria-label=\"LinkedIn\">📱</a>
            <a href=\"";
        // line 1162
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("social_twitter", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["social_twitter"]) || array_key_exists("social_twitter", $context) ? $context["social_twitter"] : (function () { throw new RuntimeError('Variable "social_twitter" does not exist.', 1162, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\" aria-label=\"Twitter\">🐦</a>
            <a href=\"";
        // line 1163
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("social_youtube", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["social_youtube"]) || array_key_exists("social_youtube", $context) ? $context["social_youtube"] : (function () { throw new RuntimeError('Variable "social_youtube" does not exist.', 1163, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\" aria-label=\"YouTube\">📺</a>
        </div>
        
        <!-- Footer -->
        <div class=\"email-footer\">
            <div data-slot=\"footer\">
                <p class=\"footer-text\">
                    ";
        // line 1170
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("company_name", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["company_name"]) || array_key_exists("company_name", $context) ? $context["company_name"] : (function () { throw new RuntimeError('Variable "company_name" does not exist.', 1170, $this->source); })()), "Cause.Buzz")) : ("Cause.Buzz")), "html", null, true);
        yield " - ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("company_tagline", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["company_tagline"]) || array_key_exists("company_tagline", $context) ? $context["company_tagline"] : (function () { throw new RuntimeError('Variable "company_tagline" does not exist.', 1170, $this->source); })()), "Die professionelle Marketing-Plattform")) : ("Die professionelle Marketing-Plattform")), "html", null, true);
        yield "<br>
                    ";
        // line 1171
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("company_address", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["company_address"]) || array_key_exists("company_address", $context) ? $context["company_address"] : (function () { throw new RuntimeError('Variable "company_address" does not exist.', 1171, $this->source); })()), "40 Im alten Riet, 9494 Schaan, Liechtenstein")) : ("40 Im alten Riet, 9494 Schaan, Liechtenstein")), "html", null, true);
        yield "
                </p>
                
                <div class=\"footer-links\">
                    <a href=\"";
        // line 1175
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("privacy_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["privacy_url"]) || array_key_exists("privacy_url", $context) ? $context["privacy_url"] : (function () { throw new RuntimeError('Variable "privacy_url" does not exist.', 1175, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\">";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("privacy_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["privacy_text"]) || array_key_exists("privacy_text", $context) ? $context["privacy_text"] : (function () { throw new RuntimeError('Variable "privacy_text" does not exist.', 1175, $this->source); })()), "Datenschutz")) : ("Datenschutz")), "html", null, true);
        yield "</a>
                    <a href=\"";
        // line 1176
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("imprint_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["imprint_url"]) || array_key_exists("imprint_url", $context) ? $context["imprint_url"] : (function () { throw new RuntimeError('Variable "imprint_url" does not exist.', 1176, $this->source); })()), "#")) : ("#")), "html", null, true);
        yield "\">";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("imprint_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["imprint_text"]) || array_key_exists("imprint_text", $context) ? $context["imprint_text"] : (function () { throw new RuntimeError('Variable "imprint_text" does not exist.', 1176, $this->source); })()), "Impressum")) : ("Impressum")), "html", null, true);
        yield "</a>
                    <a href=\"";
        // line 1177
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("unsubscribe_url", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["unsubscribe_url"]) || array_key_exists("unsubscribe_url", $context) ? $context["unsubscribe_url"] : (function () { throw new RuntimeError('Variable "unsubscribe_url" does not exist.', 1177, $this->source); })()), "{unsubscribe_url}")) : ("{unsubscribe_url}")), "html", null, true);
        yield "\">";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("unsubscribe_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["unsubscribe_text"]) || array_key_exists("unsubscribe_text", $context) ? $context["unsubscribe_text"] : (function () { throw new RuntimeError('Variable "unsubscribe_text" does not exist.', 1177, $this->source); })()), "Abmelden")) : ("Abmelden")), "html", null, true);
        yield "</a>
                </div>
                
                <p class=\"footer-text\">
                    © ";
        // line 1181
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate("now", "Y"), "html", null, true);
        yield " ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("company_name", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["company_name"]) || array_key_exists("company_name", $context) ? $context["company_name"] : (function () { throw new RuntimeError('Variable "company_name" does not exist.', 1181, $this->source); })()), "Cause.Buzz")) : ("Cause.Buzz")), "html", null, true);
        yield ". ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("copyright_text", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["copyright_text"]) || array_key_exists("copyright_text", $context) ? $context["copyright_text"] : (function () { throw new RuntimeError('Variable "copyright_text" does not exist.', 1181, $this->source); })()), "Alle Rechte vorbehalten.")) : ("Alle Rechte vorbehalten.")), "html", null, true);
        yield "
                </p>
            </div>
        </div>
    </div>
    
    <!-- Mautic tracking pixel -->
    ";
        // line 1188
        if ((($tmp = (isset($context["tracking_pixel"]) || array_key_exists("tracking_pixel", $context) ? $context["tracking_pixel"] : (function () { throw new RuntimeError('Variable "tracking_pixel" does not exist.', 1188, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 1189
            yield "    <img src=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["tracking_pixel"]) || array_key_exists("tracking_pixel", $context) ? $context["tracking_pixel"] : (function () { throw new RuntimeError('Variable "tracking_pixel" does not exist.', 1189, $this->source); })()), "html", null, true);
            yield "\" style=\"display:none;\" alt=\"\" />
    ";
        }
        // line 1191
        yield "</body>
</html>PK
\000\000\000\000\000Y>[_]\000\000\000\000
\000\000\000/README.md# Cause.Buzz Professional - Mautic Theme

Ein modernes, responsives E-Mail-Template-Theme für Mautic im professionellen Cause.Buzz Design.

## 🚀 Installation

### 1. Theme hochladen
1. Laden Sie die ZIP-Datei in Mautic hoch:
   - Gehen Sie zu **Settings > Themes**
   - Klicken Sie auf \"Upload Theme\"
   - Wählen Sie die ZIP-Datei aus
   - Bestätigen Sie den Upload

### 2. Theme aktivieren
1. Nach dem Upload in **Settings > Themes**:
   - Finden Sie \"Cause.Buzz Professional\"
   - Klicken Sie auf \"Activate\"
   - Speichern Sie die Änderungen

### 3. Template verwenden
1. Beim Erstellen einer neuen E-Mail:
   - Gehen Sie zu **Emails > New**
   - Wählen Sie \"Template Email\"
   - Wählen Sie \"Cause.Buzz Professional\" als Theme
   - Passen Sie den Inhalt über den Builder an

## 🎨 Design-Features

### Moderne Dark Theme Ästhetik
- Dunkler Hintergrund mit blauen Akzentfarben
- Gradiente und moderne Schatten-Effekte
- Professionelle Typography mit optimaler Lesbarkeit

### Vollständig Responsiv
- Mobile-first Design-Ansatz
- Optimiert für alle E-Mail-Clients
- Touch-freundliche Button-Größen
- Automatische Anpassung an Bildschirmgrößen

### DSGVO-Konformität
- EU-Server und DSGVO-Badges im Header
- Integrierte Abmelde-Links
- Datenschutz-konforme Footer-Links
- Transparente Datenverarbeitung

## 🛠 Template-Variablen

### Allgemeine Einstellungen
```twig
";
        // line 1243
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 1243, $this->source); })()), "html", null, true);
        yield "                    // E-Mail Betreff
";
        // line 1244
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["language"]) || array_key_exists("language", $context) ? $context["language"] : (function () { throw new RuntimeError('Variable "language" does not exist.', 1244, $this->source); })()), "html", null, true);
        yield "                   // Sprache (de/en)
";
        // line 1245
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["logo_url"]) || array_key_exists("logo_url", $context) ? $context["logo_url"] : (function () { throw new RuntimeError('Variable "logo_url" does not exist.', 1245, $this->source); })()), "html", null, true);
        yield "                   // Logo URL
";
        // line 1246
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["company_name"]) || array_key_exists("company_name", $context) ? $context["company_name"] : (function () { throw new RuntimeError('Variable "company_name" does not exist.', 1246, $this->source); })()), "html", null, true);
        yield "               // Firmenname
";
        // line 1247
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["company_tagline"]) || array_key_exists("company_tagline", $context) ? $context["company_tagline"] : (function () { throw new RuntimeError('Variable "company_tagline" does not exist.', 1247, $this->source); })()), "html", null, true);
        yield "            // Firmen-Slogan
";
        // line 1248
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["company_address"]) || array_key_exists("company_address", $context) ? $context["company_address"] : (function () { throw new RuntimeError('Variable "company_address" does not exist.', 1248, $this->source); })()), "html", null, true);
        yield "            // Firmenadresse
```

### Content-Variablen
```twig
";
        // line 1253
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["headline"]) || array_key_exists("headline", $context) ? $context["headline"] : (function () { throw new RuntimeError('Variable "headline" does not exist.', 1253, $this->source); })()), "html", null, true);
        yield "                   // Hauptüberschrift
";
        // line 1254
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["intro_text"]) || array_key_exists("intro_text", $context) ? $context["intro_text"] : (function () { throw new RuntimeError('Variable "intro_text" does not exist.', 1254, $this->source); })()), "html", null, true);
        yield "                 // Einleitungstext
";
        // line 1255
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["main_cta_text"]) || array_key_exists("main_cta_text", $context) ? $context["main_cta_text"] : (function () { throw new RuntimeError('Variable "main_cta_text" does not exist.', 1255, $this->source); })()), "html", null, true);
        yield "             // Haupt-CTA Text
";
        // line 1256
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["main_cta_url"]) || array_key_exists("main_cta_url", $context) ? $context["main_cta_url"] : (function () { throw new RuntimeError('Variable "main_cta_url" does not exist.', 1256, $this->source); })()), "html", null, true);
        yield "              // Haupt-CTA URL
```

### Template-Typen
```twig
";
        // line 1261
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["template_type"]) || array_key_exists("template_type", $context) ? $context["template_type"] : (function () { throw new RuntimeError('Variable "template_type" does not exist.', 1261, $this->source); })()), "html", null, true);
        yield "             // 'newsletter' oder 'welcome'
";
        // line 1262
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["features_section"]) || array_key_exists("features_section", $context) ? $context["features_section"] : (function () { throw new RuntimeError('Variable "features_section" does not exist.', 1262, $this->source); })()), "html", null, true);
        yield "          // true/false - Features anzeigen
";
        // line 1263
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["steps_section"]) || array_key_exists("steps_section", $context) ? $context["steps_section"] : (function () { throw new RuntimeError('Variable "steps_section" does not exist.', 1263, $this->source); })()), "html", null, true);
        yield "             // true/false - Schritte anzeigen
";
        // line 1264
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["content_section"]) || array_key_exists("content_section", $context) ? $context["content_section"] : (function () { throw new RuntimeError('Variable "content_section" does not exist.', 1264, $this->source); })()), "html", null, true);
        yield "           // true/false - Content-Bereich anzeigen
```

### Welcome Template Variablen
```twig
";
        // line 1269
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["welcome_headline"]) || array_key_exists("welcome_headline", $context) ? $context["welcome_headline"] : (function () { throw new RuntimeError('Variable "welcome_headline" does not exist.', 1269, $this->source); })()), "html", null, true);
        yield "          // Welcome Überschrift
";
        // line 1270
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["welcome_subheading"]) || array_key_exists("welcome_subheading", $context) ? $context["welcome_subheading"] : (function () { throw new RuntimeError('Variable "welcome_subheading" does not exist.', 1270, $this->source); })()), "html", null, true);
        yield "        // Welcome Untertitel
";
        // line 1271
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["welcome_text"]) || array_key_exists("welcome_text", $context) ? $context["welcome_text"] : (function () { throw new RuntimeError('Variable "welcome_text" does not exist.', 1271, $this->source); })()), "html", null, true);
        yield "              // Welcome Text
";
        // line 1272
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["cta_url"]) || array_key_exists("cta_url", $context) ? $context["cta_url"] : (function () { throw new RuntimeError('Variable "cta_url" does not exist.', 1272, $this->source); })()), "html", null, true);
        yield "                   // Welcome CTA URL
";
        // line 1273
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["cta_text"]) || array_key_exists("cta_text", $context) ? $context["cta_text"] : (function () { throw new RuntimeError('Variable "cta_text" does not exist.', 1273, $this->source); })()), "html", null, true);
        yield "                  // Welcome CTA Text
```

### Features Sektion
```twig
";
        // line 1278
        $context["features"] = [["icon" => "📊", "title" => "Analytics", "description" => "Detaillierte Einblicke..."], ["icon" => "🚀", "title" => "Automation", "description" => "Automatisierte Workflows..."]];
        // line 1290
        yield "```

### Steps/Onboarding Sektion
```twig
";
        // line 1294
        $context["steps"] = [["title" => "Profil vervollständigen", "description" => "Vervollständigen Sie Ihr Profil..."], ["title" => "Erste Kampagne", "description" => "Erstellen Sie Ihre erste Kampagne..."]];
        // line 1304
        yield "```

### Social Media Links
```twig
";
        // line 1308
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["social_linkedin"]) || array_key_exists("social_linkedin", $context) ? $context["social_linkedin"] : (function () { throw new RuntimeError('Variable "social_linkedin" does not exist.', 1308, $this->source); })()), "html", null, true);
        yield "           // LinkedIn URL
";
        // line 1309
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["social_twitter"]) || array_key_exists("social_twitter", $context) ? $context["social_twitter"] : (function () { throw new RuntimeError('Variable "social_twitter" does not exist.', 1309, $this->source); })()), "html", null, true);
        yield "            // Twitter URL  
";
        // line 1310
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["social_youtube"]) || array_key_exists("social_youtube", $context) ? $context["social_youtube"] : (function () { throw new RuntimeError('Variable "social_youtube" does not exist.', 1310, $this->source); })()), "html", null, true);
        yield "           // YouTube URL
```

### Footer-Konfiguration
```twig
";
        // line 1315
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["privacy_url"]) || array_key_exists("privacy_url", $context) ? $context["privacy_url"] : (function () { throw new RuntimeError('Variable "privacy_url" does not exist.', 1315, $this->source); })()), "html", null, true);
        yield "              // Datenschutz URL
";
        // line 1316
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["imprint_url"]) || array_key_exists("imprint_url", $context) ? $context["imprint_url"] : (function () { throw new RuntimeError('Variable "imprint_url" does not exist.', 1316, $this->source); })()), "html", null, true);
        yield "              // Impressum URL
";
        // line 1317
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["unsubscribe_url"]) || array_key_exists("unsubscribe_url", $context) ? $context["unsubscribe_url"] : (function () { throw new RuntimeError('Variable "unsubscribe_url" does not exist.', 1317, $this->source); })()), "html", null, true);
        yield "          // Abmelde URL
";
        // line 1318
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["copyright_text"]) || array_key_exists("copyright_text", $context) ? $context["copyright_text"] : (function () { throw new RuntimeError('Variable "copyright_text" does not exist.', 1318, $this->source); })()), "html", null, true);
        yield "           // Copyright Text
```

## 📧 Verwendungsbeispiele

### 1. Standard Newsletter
```twig
";
        // line 1325
        $context["template_type"] = "newsletter";
        // line 1326
        $context["headline"] = "Ihr monatlicher Marketing-Update";
        // line 1327
        $context["intro_text"] = "Die neuesten Trends und Tipps...";
        // line 1328
        $context["main_cta_text"] = "Jetzt lesen";
        // line 1329
        $context["main_cta_url"] = "https://cause.buzz/blog";
        // line 1330
        $context["features_section"] = true;
        // line 1331
        yield "```

### 2. Welcome E-Mail
```twig
";
        // line 1335
        $context["template_type"] = "welcome";
        // line 1336
        $context["welcome_headline"] = "Willkommen bei Cause.Buzz!";
        // line 1337
        $context["welcome_subheading"] = "Schön, dass Sie dabei sind";
        // line 1338
        $context["cta_text"] = "Loslegen";
        // line 1339
        $context["cta_url"] = "https://demo.cause.buzz";
        // line 1340
        $context["steps_section"] = true;
        // line 1341
        yield "```

### 3. Feature-Update
```twig
";
        // line 1345
        $context["headline"] = "Neue Features verfügbar";
        // line 1346
        $context["features_section"] = true;
        // line 1347
        $context["features"] = [["icon" => "📈", "title" => "Erweiterte Analytics", "description" => "Noch detailliertere Einblicke in Ihre Kampagnen-Performance"]];
        // line 1354
        yield "```

## 🎛 Anpassungen

### Farben ändern
Die Hauptfarben können in der CSS-Sektion angepasst werden:
```css
/* Primärfarben */
#2563eb  /* Primary Blue */
#60a5fa  /* Secondary Blue */
#0f172a  /* Dark Background */
#1e293b  /* Surface Color */
```

### Logo ersetzen
```twig
";
        // line 1370
        $context["logo_url"] = "https://ihre-domain.de/logo.png";
        // line 1371
        yield "```

### Firmeninformationen
```twig
";
        // line 1375
        $context["company_name"] = "Ihr Firmenname";
        // line 1376
        $context["company_tagline"] = "Ihr Slogan";
        // line 1377
        $context["company_address"] = "Ihre Adresse";
        // line 1378
        yield "```

## 📱 E-Mail Client Kompatibilität

### ✅ Vollständig unterstützt
- Gmail (Web, iOS, Android)
- Outlook (2016+, Web, Mobile)
- Apple Mail (macOS, iOS)
- Yahoo Mail
- Thunderbird

### ⚠️ Eingeschränkt unterstützt
- Outlook 2010-2013 (begrenzte CSS-Unterstützung)
- Alte Android Mail Clients

## 🔧 Troubleshooting

### Theme wird nicht angezeigt
1. Überprüfen Sie, ob das Theme aktiviert ist
2. Leeren Sie den Mautic-Cache: `app/console cache:clear`
3. Stellen Sie sicher, dass die Dateirechte korrekt sind

### Bilder werden nicht angezeigt
1. Überprüfen Sie die Logo-URL
2. Stellen Sie sicher, dass Bilder öffentlich zugänglich sind
3. Prüfen Sie die Firewall-Einstellungen

### Styling-Probleme
1. Überprüfen Sie die CSS-Syntax
2. Testen Sie das Template in verschiedenen E-Mail-Clients
3. Nutzen Sie E-Mail-Testing-Tools wie Litmus oder Email on Acid

## 📞 Support

Bei Fragen oder Problemen:
- **E-Mail**: hello@cause.buzz
- **Website**: https://cause.buzz
- **Dokumentation**: Diese README-Datei

## 📄 Lizenz

© 2024 Cause.Buzz. Alle Rechte vorbehalten.

Dieses Theme ist für die Verwendung mit der Cause.Buzz Marketing-Plattform lizenziert.

## 🔄 Changelog

### Version 1.0.0 (2024-12-19)
- Initiale Veröffentlichung
- Newsletter und Welcome Templates
- Vollständige Responsivität
- DSGVO-Konformität
- Mautic 4.0+ Kompatibilität
- Dark Theme Design
- Umfassende DokumentationPK
\000\000\000\000\000Y>[\000\000\000\000
\000\000\000css/email.css/* Cause.Buzz Professional Theme - Additional CSS */
/* This file contains additional styling that can be customized */

/* Brand Colors - Customize these to match your brand */
:root {
  --cb-primary: #2563eb;
  --cb-secondary: #60a5fa;
  --cb-background: #0f172a;
  --cb-surface: #1e293b;
  --cb-dark: #334155;
  --cb-text: #ffffff;
  --cb-muted: #cbd5e1;
  --cb-success: #059669;
  --cb-border: #475569;
}

/* Custom utilities for advanced users */
.cb-gradient-primary {
  background: linear-gradient(135deg, var(--cb-primary) 0%, #1d4ed8 100%);
}

.cb-gradient-surface {
  background: linear-gradient(135deg, var(--cb-surface) 0%, var(--cb-dark) 100%);
}

.cb-text-glow {
  text-shadow: 0 0 10px rgba(96, 165, 250, 0.3);
}

.cb-box-shadow {
  box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3);
}

.cb-box-shadow-large {
  box-shadow: 0 8px 25px rgba(37, 99, 235, 0.4);
}

/* Animation utilities */
.cb-fade-in {
  opacity: 0;
  animation: fadeIn 0.6s ease-in-out forwards;
}

@keyframes fadeIn {
  to {
    opacity: 1;
  }
}

.cb-slide-up {
  transform: translateY(20px);
  opacity: 0;
  animation: slideUp 0.6s ease-out forwards;
}

@keyframes slideUp {
  to {
    transform: translateY(0);
    opacity: 1;
  }
}

/* Custom component styles */
.cb-notification-bar {
  background: linear-gradient(135deg, var(--cb-success) 0%, #047857 100%);
  padding: 10px 20px;
  text-align: center;
  font-size: 14px;
  font-weight: 500;
  color: var(--cb-text);
}

.cb-divider {
  height: 2px;
  background: linear-gradient(135deg, transparent 0%, var(--cb-primary) 50%, transparent 100%);
  margin: 30px 0;
}

.cb-icon-wrapper {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  width: 60px;
  height: 60px;
  background: var(--cb-gradient-primary);
  border-radius: 50%;
  font-size: 28px;
  margin-bottom: 20px;
}

/* Typography extensions */
.cb-text-large {
  font-size: 18px;
  line-height: 1.6;
}

.cb-text-small {
  font-size: 14px;
  line-height: 1.5;
}

.cb-text-xs {
  font-size: 12px;
  line-height: 1.4;
}

/* Layout utilities */
.cb-container-narrow {
  max-width: 500px;
  margin: 0 auto;
}

.cb-container-wide {
  max-width: 700px;
  margin: 0 auto;
}

.cb-spacing-sm {
  padding: 20px;
}

.cb-spacing-md {
  padding: 30px;
}

.cb-spacing-lg {
  padding: 40px;
}

.cb-spacing-xl {
  padding: 50px;
}

/* Button variations */
.cb-btn-outline {
  background: transparent;
  border: 2px solid var(--cb-primary);
  color: var(--cb-primary);
  padding: 12px 24px;
  border-radius: 8px;
  text-decoration: none;
  font-weight: 500;
  transition: all 0.3s ease;
}

.cb-btn-outline:hover {
  background: var(--cb-primary);
  color: var(--cb-text);
}

.cb-btn-ghost {
  background: rgba(37, 99, 235, 0.1);
  border: 1px solid rgba(37, 99, 235, 0.3);
  color: var(--cb-secondary);
  padding: 12px 24px;
  border-radius: 8px;
  text-decoration: none;
  font-weight: 500;
}

.cb-btn-pill {
  border-radius: 25px;
}

.cb-btn-block {
  display: block;
  width: 100%;
  text-align: center;
}

/* Card variations */
.cb-card-elevated {
  background: var(--cb-gradient-surface);
  border: 1px solid var(--cb-border);
  border-radius: 16px;
  padding: 30px;
  box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
}

.cb-card-glass {
  background: rgba(30, 41, 59, 0.8);
  backdrop-filter: blur(10px);
  border: 1px solid rgba(255, 255, 255, 0.1);
  border-radius: 12px;
  padding: 25px;
}

/* Status indicators */
.cb-status-new {
  background: linear-gradient(135deg, #059669 0%, #047857 100%);
  color: var(--cb-text);
  padding: 4px 8px;
  border-radius: 4px;
  font-size: 10px;
  font-weight: 600;
  text-transform: uppercase;
}

.cb-status-hot {
  background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
  color: var(--cb-text);
  padding: 4px 8px;
  border-radius: 4px;
  font-size: 10px;
  font-weight: 600;
  text-transform: uppercase;
}

.cb-status-featured {
  background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
  color: var(--cb-text);
  padding: 4px 8px;
  border-radius: 4px;
  font-size: 10px;
  font-weight: 600;
  text-transform: uppercase;
}

/* List styles */
.cb-list-clean {
  list-style: none;
  padding: 0;
  margin: 0;
}

.cb-list-clean li {
  padding: 10px 0;
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.cb-list-clean li:last-child {
  border-bottom: none;
}

.cb-list-checkmark li::before {
  content: \"✓\";
  color: var(--cb-success);
  margin-right: 10px;
  font-weight: bold;
}

/* Progress indicators */
.cb-progress-bar {
  background: rgba(255, 255, 255, 0.1);
  border-radius: 10px;
  height: 8px;
  overflow: hidden;
}

.cb-progress-fill {
  background: var(--cb-gradient-primary);
  height: 100%;
  border-radius: 10px;
  transition: width 0.3s ease;
}

/* Responsive utilities */
@media only screen and (max-width: 600px) {
  .cb-hide-mobile {
    display: none !important;
  }
  
  .cb-text-center-mobile {
    text-align: center !important;
  }
  
  .cb-stack-mobile {
    display: block !important;
    width: 100% !important;
    margin-bottom: 15px !important;
  }
}

@media only screen and (min-width: 601px) {
  .cb-hide-desktop {
    display: none !important;
  }
}

/* Accessibility improvements */
.cb-screen-reader-only {
  position: absolute;
  width: 1px;
  height: 1px;
  padding: 0;
  margin: -1px;
  overflow: hidden;
  clip: rect(0, 0, 0, 0);
  white-space: nowrap;
  border: 0;
}

/* High contrast mode support */
@media (prefers-contrast: high) {
  .email-container {
    background: #000000 !important;
  }
  
  .content-section {
    background: #000000 !important;
    border: 2px solid #ffffff !important;
  }
  
  .btn-primary,
  .btn-secondary {
    border: 2px solid #ffffff !important;
  }
}

/* Reduced motion support */
@media (prefers-reduced-motion: reduce) {
  .cb-fade-in,
  .cb-slide-up {
    animation: none !important;
  }
  
  * {
    transition: none !important;
  }
}PK
\000\000\000\000\000Y>[r\000\000\000\000\000\000\000\000\000/thumbnail.pngdata:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASwAAAEsCAYAAAB5fY51AAAAaklEQVR4nO3BMQEAAADCoPVPbQsvoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABg4AC8AAABJKcNFwAAAABJRU5ErkJggg==PK
\000\000\000\000\000Y>[\000\000\000\000\000\000\000/INSTALLATION.md# 🚀 Schnell-Installation für Mautic

## Schritt-für-Schritt Anleitung

### 1. Theme hochladen (2 Minuten)

1. **Mautic öffnen** und als Administrator anmelden
2. **Settings (Einstellungen)** → **Themes** aufrufen
3. **\"Upload Theme\"** oder **\"Theme hochladen\"** klicken
4. **ZIP-Datei auswählen** (`causebuzz-mautic-theme.zip`)
5. **Upload bestätigen** und warten bis Vorgang abgeschlossen

### 2. Theme aktivieren (1 Minute)

1. In der **Theme-Liste** nach **\"Cause.Buzz Professional\"** suchen
2. **\"Activate\"** oder **\"Aktivieren\"** klicken
3. **Änderungen speichern**

### 3. Erste E-Mail erstellen (3 Minuten)

1. **Emails** → **\"New Email\"** → **\"Template Email\"**
2. **Theme auswählen**: \"Cause.Buzz Professional\"
3. **Builder öffnen** (GrapeJS oder Legacy)
4. **Inhalte anpassen** über die verfügbaren Slots
5. **Vorschau testen** und **speichern**

## ⚡ Schnell-Setup für verschiedene E-Mail-Typen

### Newsletter Template
```twig
Template Type: newsletter
Headline: \"Ihr monatlicher Marketing-Update\"
Features Section: aktiviert
Content Section: aktiviert
```

### Welcome E-Mail
```twig
Template Type: welcome
Welcome Headline: \"Willkommen bei [Ihr Unternehmen]!\"
Steps Section: aktiviert
CTA: \"Jetzt loslegen\"
```

### Produkt-Update
```twig
Template Type: newsletter
Headline: \"Neue Features verfügbar\"
Features Section: aktiviert
Main CTA: \"Features entdecken\"
```

## 🎨 Sofort verwendbare Vorlagen

### 1. Standard Newsletter
- ✅ Logo und Branding
- ✅ Hero-Bereich mit CTA
- ✅ Feature-Boxen (bis zu 4)
- ✅ Social Media Links
- ✅ DSGVO-konforme Footer

### 2. Willkommens-E-Mail  
- ✅ Persönliche Begrüßung
- ✅ Schritt-für-Schritt Anleitung
- ✅ Wichtige Links
- ✅ Support-Kontakt

### 3. Promotion E-Mail
- ✅ Auffälliger Hero-Bereich
- ✅ Produkt-Features
- ✅ Starke Call-to-Actions
- ✅ Zeitlich begrenzte Angebote

## 🛠 Wichtige Einstellungen

### Grundkonfiguration
1. **Logo URL**: `https://ihre-domain.de/logo.png`
2. **Firmenname**: Ihr Unternehmensname
3. **Firmenadresse**: Vollständige Adresse für Footer
4. **Social Media**: LinkedIn, Twitter, YouTube Links

### DSGVO-Links (Pflicht!)
1. **Datenschutz URL**: Link zu Ihrer Datenschutzerklärung
2. **Impressum URL**: Link zu Ihrem Impressum
3. **Abmelde-Link**: Automatisch von Mautic generiert

### Marketing-Links
1. **Website**: Ihre Hauptwebsite
2. **Demo/Trial**: Link zu Produktdemo
3. **Support**: Kontakt oder Help Center
4. **Blog**: Content Marketing Hub

## 🔧 Fehlerbehebung

### Theme wird nicht angezeigt
- **Cache leeren**: `php bin/console cache:clear`
- **Dateiberechtigungen prüfen**: 755 für Ordner, 644 für Dateien
- **Theme-Status**: Muss auf \"aktiv\" stehen

### Bilder werden nicht geladen
- **HTTPS verwenden**: Alle Bild-URLs müssen HTTPS sein
- **Öffentlich zugänglich**: Bilder dürfen nicht passwortgeschützt sein
- **Korrekte Dateigröße**: Max. 1MB pro Bild empfohlen

### E-Mail sieht anders aus
- **Client-Test**: Verschiedene E-Mail-Clients testen
- **Spam-Test**: Tools wie Mail-Tester verwenden
- **Mobile Test**: Auf verschiedenen Smartphones prüfen

## 📱 Mobile Optimierung

### Automatische Anpassungen
- ✅ Responsive Design
- ✅ Touch-freundliche Buttons
- ✅ Optimierte Schriftgrößen
- ✅ Vereinfachte Navigation

### Mobile-spezifische Tipps
1. **Kurze Betreffzeilen** (max. 40 Zeichen)
2. **Große Buttons** (min. 44px Höhe)
3. **Scanbare Inhalte** (kurze Absätze)
4. **Wichtige Infos oben** (above the fold)

## 📈 Best Practices

### Content-Struktur
1. **Header**: Logo + Navigation
2. **Hero**: Hauptbotschaft + CTA
3. **Content**: Features/News/Tipps
4. **CTA**: Finale Handlungsaufforderung
5. **Footer**: Kontakt + rechtliche Links

### E-Mail Performance
1. **Betreffzeile**: Neugierig aber ehrlich
2. **Preheader**: Ergänzt Betreffzeile
3. **Personalisierung**: Name, Standort, Interessen
4. **A/B Testing**: CTA-Texte, Bilder, Zeiten
5. **Mobile-first**: Primär für Smartphones optimieren

## 📞 Support & Hilfe

### Sofort-Hilfe
- **Template-Dokumentation**: README.md lesen
- **Mautic-Dokumentation**: https://mautic.org/docs
- **Community-Forum**: https://forum.mautic.org

### Professioneller Support
- **E-Mail**: hello@cause.buzz
- **Website**: https://cause.buzz
- **Response-Zeit**: 24-48 Stunden

### Weiterführende Ressourcen
- **E-Mail Marketing Guide**: https://cause.buzz/guide
- **Mautic Tutorial**: https://cause.buzz/mautic
- **Design-Inspiration**: https://cause.buzz/examples

---

**Viel Erfolg mit Ihrem neuen E-Mail-Template!** 🎉

Bei Fragen stehen wir gerne zur Verfügung.PK
\000\000\000\000\000Y>[G,\000\000,\000\000 \000\000\000examples/newsletter-example.html<!-- Beispiel: Newsletter Template mit Cause.Buzz Theme -->
<!-- Dieses HTML zeigt, wie das Template mit Beispieldaten aussieht -->

<!DOCTYPE html>
<html lang=\"de\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>Cause.Buzz Newsletter - Marketing Insights</title>
    
    <!-- Hier würde normalerweise der Twig-Template CSS eingebunden -->
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #ffffff;
            background-color: #0f172a;
            margin: 0;
            padding: 0;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
        }
        
        .email-header {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            padding: 30px 20px;
            text-align: center;
            border-bottom: 2px solid #3b82f6;
        }
        
        .content-section {
            padding: 40px 30px;
            background-color: #1e293b;
        }
        
        .content-section.alternate {
            background-color: #0f172a;
        }
        
        .headline {
            font-size: 28px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 20px;
            line-height: 1.3;
            text-align: center;
        }
        
        .subheading {
            font-size: 20px;
            font-weight: 500;
            color: #60a5fa;
            margin-bottom: 15px;
            line-height: 1.4;
        }
        
        .body-text {
            font-size: 16px;
            color: #cbd5e1;
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .btn-primary {
            display: inline-block;
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: #ffffff;
            padding: 14px 28px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            font-size: 16px;
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3);
        }
        
        .feature-box {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border: 1px solid #475569;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .feature-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 50%;
            margin: 0 auto 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        
        .badge {
            display: inline-block;
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            color: #ffffff;
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 500;
            margin: 0 5px;
        }
        
        .badge.gdpr {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        }
        
        .email-footer {
            background-color: #0f172a;
            padding: 30px 20px;
            text-align: center;
            border-top: 1px solid #334155;
        }
        
        .footer-text {
            font-size: 14px;
            color: #64748b;
            margin-bottom: 15px;
        }
        
        .social-links {
            text-align: center;
            padding: 20px 0;
        }
        
        .social-links a {
            display: inline-block;
            margin: 0 10px;
            padding: 12px;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 8px;
            text-decoration: none;
            color: #ffffff;
            font-size: 18px;
        }
    </style>
</head>
<body>
    <div class=\"email-container\">
        <!-- Header -->
        <div class=\"email-header\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz Logo\" style=\"max-width: 180px; height: auto; margin-bottom: 15px;\" />
            <div>
                <span class=\"badge\">🔒 DSGVO</span>
                <span class=\"badge gdpr\">🇪🇺 EU-Server</span>
            </div>
        </div>
        
        <!-- Hero Section -->
        <div class=\"content-section\">
            <h1 class=\"headline\">Marketing-Insights Januar 2024</h1>
            <p class=\"body-text\">
                Willkommen zu unserem monatlichen Newsletter! Diesen Monat haben wir spannende 
                Updates, neue Features und wertvolle Marketing-Tipps für Sie zusammengestellt.
            </p>
            <div style=\"text-align: center; margin: 30px 0;\">
                <a href=\"https://cause.buzz/newsletter\" class=\"btn-primary\">Newsletter lesen</a>
            </div>
        </div>
        
        <!-- Features Section -->
        <div class=\"content-section alternate\">
            <h2 style=\"font-size: 24px; font-weight: 600; color: #ffffff; margin-bottom: 20px; text-align: center;\">
                Neue Features diese Woche
            </h2>
            
            <div class=\"feature-box\">
                <div class=\"feature-icon\">📊</div>
                <h3 style=\"color: #ffffff; margin-bottom: 10px; font-size: 18px; font-weight: 600;\">
                    Erweiterte Analytics
                </h3>
                <p class=\"body-text\">
                    Neue Dashboard-Funktionen für noch detailliertere Einblicke in Ihre Kampagnen-Performance 
                    mit Real-time Metriken und erweiterten Segmentierungsoptionen.
                </p>
            </div>
            
            <div class=\"feature-box\">
                <div class=\"feature-icon\">🚀</div>
                <h3 style=\"color: #ffffff; margin-bottom: 10px; font-size: 18px; font-weight: 600;\">
                    Automation-Workflows
                </h3>
                <p class=\"body-text\">
                    Automatisieren Sie Ihre Marketing-Prozesse mit unseren neuen intelligenten 
                    Workflow-Tools. Trigger-basierte Kampagnen und Lead-Nurturing Sequenzen.
                </p>
            </div>
            
            <div class=\"feature-box\">
                <div class=\"feature-icon\">🎯</div>
                <h3 style=\"color: #ffffff; margin-bottom: 10px; font-size: 18px; font-weight: 600;\">
                    Smart Segmentierung
                </h3>
                <p class=\"body-text\">
                    KI-gestützte Zielgruppenanalyse für präzisere Kampagnen. Automatische 
                    Segmentierung basierend auf Verhalten und Engagement-Mustern.
                </p>
            </div>
        </div>
        
        <!-- Content Section -->
        <div class=\"content-section\">
            <h2 class=\"subheading\">💡 Marketing-Tipp der Woche</h2>
            <p class=\"body-text\">
                <strong>Personalisierung ist der Schlüssel zum Erfolg.</strong> Nutzen Sie Dynamic Content, 
                um jede E-Mail individuell auf Ihre Zielgruppe zuzuschneiden. Studien zeigen, 
                dass personalisierte E-Mails 29% höhere Öffnungsraten und 41% höhere Klickraten erzielen.
            </p>
            <div style=\"background: linear-gradient(135deg, #1e293b 0%, #334155 100%); border-left: 4px solid #3b82f6; padding: 20px; border-radius: 8px; margin: 20px 0;\">
                <h4 style=\"color: #60a5fa; margin-bottom: 10px;\">📈 Quick Wins für diese Woche:</h4>
                <ul style=\"color: #cbd5e1; margin: 0; padding-left: 20px;\">
                    <li>Betreffzeilen mit Vornamen personalisieren</li>
                    <li>Standort-basierte Inhalte testen</li>
                    <li>Kaufhistorie für Produktempfehlungen nutzen</li>
                    <li>A/B Tests für verschiedene Zielgruppen durchführen</li>
                </ul>
            </div>
            <div style=\"text-align: center; margin: 25px 0;\">
                <a href=\"https://cause.buzz/blog/personalisierung\" style=\"display: inline-block; background: transparent; color: #60a5fa; padding: 12px 24px; text-decoration: none; border-radius: 8px; font-weight: 500; font-size: 16px; border: 2px solid #3b82f6;\">
                    Vollständigen Guide lesen
                </a>
            </div>
        </div>
        
        <!-- Call to Action Section -->
        <div class=\"content-section alternate\" style=\"text-align: center;\">
            <h2 class=\"subheading\">🎯 Bereit für den nächsten Schritt?</h2>
            <p class=\"body-text\">
                Vereinbaren Sie noch heute Ihre kostenlose Demo und entdecken Sie, 
                wie Cause.Buzz Ihr Marketing revolutionieren kann. Exklusiv für Newsletter-Abonnenten: 
                30% Rabatt auf den ersten Monat!
            </p>
            <div style=\"margin: 30px 0;\">
                <a href=\"https://demo.cause.buzz?utm_source=newsletter&utm_campaign=january2024\" class=\"btn-primary\">
                    🎁 Kostenlose Demo buchen
                </a>
            </div>
            <p style=\"font-size: 14px; color: #94a3b8; margin-top: 15px;\">
                Angebot gültig bis 31. Januar 2024 | Code: NEWSLETTER30
            </p>
        </div>
        
        <!-- Social Media -->
        <div class=\"social-links\">
            <a href=\"https://linkedin.com/company/causebuzz\" aria-label=\"LinkedIn\">📱</a>
            <a href=\"https://twitter.com/causebuzz\" aria-label=\"Twitter\">🐦</a>
            <a href=\"https://youtube.com/causebuzz\" aria-label=\"YouTube\">📺</a>
        </div>
        
        <!-- Footer -->
        <div class=\"email-footer\">
            <p class=\"footer-text\">
                Cause.Buzz - Die professionelle Marketing-Plattform<br>
                40 Im alten Riet, 9494 Schaan, Liechtenstein
            </p>
            
            <div style=\"margin: 20px 0;\">
                <a href=\"https://cause.buzz/privacy\" style=\"color: #60a5fa; text-decoration: none; margin: 0 15px; font-size: 14px;\">Datenschutz</a>
                <a href=\"https://cause.buzz/imprint\" style=\"color: #60a5fa; text-decoration: none; margin: 0 15px; font-size: 14px;\">Impressum</a>
                <a href=\"{unsubscribe_url}\" style=\"color: #60a5fa; text-decoration: none; margin: 0 15px; font-size: 14px;\">Abmelden</a>
            </div>
            
            <p class=\"footer-text\">
                © 2024 Cause.Buzz. Alle Rechte vorbehalten.
            </p>
            
            <div style=\"margin-top: 20px; padding-top: 20px; border-top: 1px solid #334155;\">
                <p style=\"font-size: 12px; color: #64748b;\">
                    Sie erhalten diese E-Mail, weil Sie sich für unseren Newsletter angemeldet haben.<br>
                    Cause.Buzz Newsletter | 40 Im alten Riet, Schaan 9494, Liechtenstein
                </p>
            </div>
        </div>
    </div>
</body>
</html>PK
\000\000\000\000\000Y>[J\000\000J\000\000\000\000\000examples/welcome-example.html<!-- Beispiel: Welcome Template mit Cause.Buzz Theme -->
<!-- Dieses HTML zeigt, wie das Welcome-Template mit Beispieldaten aussieht -->

<!DOCTYPE html>
<html lang=\"de\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>Willkommen bei Cause.Buzz!</title>
    
    <!-- Hier würde normalerweise der Twig-Template CSS eingebunden -->
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #ffffff;
            background-color: #0f172a;
            margin: 0;
            padding: 0;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
        }
        
        .email-header {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            padding: 40px 20px;
            text-align: center;
            border-bottom: 3px solid #3b82f6;
        }
        
        .welcome-badge {
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            color: #ffffff;
            padding: 8px 20px;
            border-radius: 25px;
            font-size: 14px;
            font-weight: 500;
            display: inline-block;
        }
        
        .hero-section {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            padding: 50px 30px;
            text-align: center;
            position: relative;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"60\" height=\"60\" viewBox=\"0 0 60 60\"><g fill-opacity=\"0.05\" fill=\"%23ffffff\"><rect width=\"1\" height=\"1\"/></g></svg>');
            background-size: 60px 60px;
        }
        
        .hero-content {
            position: relative;
            z-index: 1;
        }
        
        .content-section {
            padding: 40px 30px;
            background-color: #1e293b;
        }
        
        .content-section.alternate {
            background-color: #0f172a;
        }
        
        .hero-headline {
            font-size: 32px;
            font-weight: 700;
            color: #ffffff;
            margin-bottom: 15px;
            line-height: 1.2;
        }
        
        .hero-subheading {
            font-size: 20px;
            font-weight: 500;
            color: #60a5fa;
            margin-bottom: 25px;
            line-height: 1.4;
        }
        
        .body-text {
            font-size: 16px;
            color: #cbd5e1;
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .section-heading {
            font-size: 24px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .btn-primary {
            display: inline-block;
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: #ffffff;
            padding: 16px 32px;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            font-size: 18px;
            box-shadow: 0 8px 25px rgba(37, 99, 235, 0.4);
            margin: 10px;
        }
        
        .btn-secondary {
            display: inline-block;
            background: transparent;
            color: #60a5fa;
            padding: 14px 28px;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 500;
            font-size: 16px;
            border: 2px solid #3b82f6;
            margin: 10px;
        }
        
        .step-item {
            background: linear-gradient(135deg, #334155 0%, #475569 100%);
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            border-left: 4px solid #3b82f6;
        }
        
        .step-number {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            color: #ffffff;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 18px;
            margin-right: 20px;
            flex-shrink: 0;
        }
        
        .features-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin: 30px 0;
        }
        
        .feature-card {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border: 1px solid #475569;
            border-radius: 12px;
            padding: 25px;
            text-align: center;
        }
        
        .badge {
            display: inline-block;
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            color: #ffffff;
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 500;
            margin: 0 5px;
        }
        
        .badge.gdpr {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        }
        
        .email-footer {
            background-color: #0f172a;
            padding: 40px 20px;
            text-align: center;
            border-top: 1px solid #334155;
        }
        
        .footer-text {
            font-size: 14px;
            color: #64748b;
            margin-bottom: 15px;
        }
        
        .social-links {
            text-align: center;
            padding: 20px 0;
        }
        
        .social-links a {
            display: inline-block;
            margin: 0 10px;
            padding: 12px;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 8px;
            text-decoration: none;
            color: #ffffff;
            font-size: 18px;
        }
        
        @media only screen and (max-width: 600px) {
            .features-grid {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .step-item {
                flex-direction: column;
                text-align: center;
            }
            
            .step-number {
                margin-right: 0;
                margin-bottom: 15px;
            }
        }
    </style>
</head>
<body>
    <div class=\"email-container\">
        <!-- Header -->
        <div class=\"email-header\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz Logo\" style=\"max-width: 200px; height: auto; margin-bottom: 20px;\" />
            <div class=\"welcome-badge\">🎉 Willkommen im Team!</div>
        </div>
        
        <!-- Hero Section -->
        <div class=\"hero-section\">
            <div class=\"hero-content\">
                <h1 class=\"hero-headline\">Willkommen bei Cause.Buzz!</h1>
                <p class=\"hero-subheading\">
                    Schön, dass Sie sich für die professionelle Marketing-Plattform entschieden haben.
                </p>
                <p class=\"body-text\">
                    Sie haben den ersten Schritt zu erfolgreichem Marketing gemacht. 
                    Lassen Sie uns gemeinsam Ihre Marketing-Ziele erreichen und Ihre Reichweite maximieren.
                </p>
                <div style=\"margin: 30px 0;\">
                    <a href=\"https://demo.cause.buzz/dashboard?welcome=1\" class=\"btn-primary\">🚀 Jetzt loslegen</a>
                </div>
            </div>
        </div>
        
        <!-- Getting Started Steps -->
        <div class=\"content-section\">
            <h2 class=\"section-heading\">Ihre ersten Schritte</h2>
            
            <div class=\"steps-container\">
                <div class=\"step-item\">
                    <div class=\"step-number\">1</div>
                    <div class=\"step-content\">
                        <h3 style=\"color: #ffffff; font-size: 18px; margin-bottom: 8px; font-weight: 600;\">
                            Profil vervollständigen
                        </h3>
                        <p style=\"color: #cbd5e1; font-size: 15px; margin: 0;\">
                            Vervollständigen Sie Ihr Unternehmensprofil für personalisierte Empfehlungen 
                            und optimale Ergebnisse. Dies dauert nur 3 Minuten.
                        </p>
                    </div>
                </div>
                
                <div class=\"step-item\">
                    <div class=\"step-number\">2</div>
                    <div class=\"step-content\">
                        <h3 style=\"color: #ffffff; font-size: 18px; margin-bottom: 8px; font-weight: 600;\">
                            Erste Kampagne erstellen
                        </h3>
                        <p style=\"color: #cbd5e1; font-size: 15px; margin: 0;\">
                            Nutzen Sie unsere professionellen Vorlagen, um schnell und einfach 
                            Ihre erste Newsletter-Kampagne zu starten.
                        </p>
                    </div>
                </div>
                
                <div class=\"step-item\">
                    <div class=\"step-number\">3</div>
                    <div class=\"step-content\">
                        <h3 style=\"color: #ffffff; font-size: 18px; margin-bottom: 8px; font-weight: 600;\">
                            Kontakte importieren
                        </h3>
                        <p style=\"color: #cbd5e1; font-size: 15px; margin: 0;\">
                            Importieren Sie Ihre bestehenden Kontakte sicher und DSGVO-konform 
                            in wenigen Klicks aus CSV, Excel oder anderen Tools.
                        </p>
                    </div>
                </div>
                
                <div class=\"step-item\">
                    <div class=\"step-number\">4</div>
                    <div class=\"step-content\">
                        <h3 style=\"color: #ffffff; font-size: 18px; margin-bottom: 8px; font-weight: 600;\">
                            Analytics einrichten
                        </h3>
                        <p style=\"color: #cbd5e1; font-size: 15px; margin: 0;\">
                            Konfigurieren Sie Ihr Tracking und Analytics-Dashboard für 
                            detaillierte Einblicke in Ihre Marketing-Performance.
                        </p>
                    </div>
                </div>
            </div>
            
            <div style=\"text-align: center; margin: 30px 0;\">
                <a href=\"https://demo.cause.buzz/setup-guide\" class=\"btn-secondary\">📖 Detaillierte Anleitung ansehen</a>
            </div>
        </div>
        
        <!-- Features Highlight -->
        <div class=\"content-section alternate\">
            <h2 class=\"section-heading\">Was Sie erwartet</h2>
            
            <div class=\"features-grid\">
                <div class=\"feature-card\">
                    <span style=\"font-size: 32px; margin-bottom: 15px; display: block;\">📊</span>
                    <h4 style=\"color: #ffffff; font-size: 16px; margin-bottom: 10px; font-weight: 600;\">
                        Analytics & Reporting
                    </h4>
                    <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">
                        Detaillierte Einblicke in die Performance Ihrer Kampagnen mit Real-time Dashboards
                    </p>
                </div>
                
                <div class=\"feature-card\">
                    <span style=\"font-size: 32px; margin-bottom: 15px; display: block;\">🤖</span>
                    <h4 style=\"color: #ffffff; font-size: 16px; margin-bottom: 10px; font-weight: 600;\">
                        Marketing Automation
                    </h4>
                    <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">
                        Automatisierte Workflows für effizienteres Marketing und Lead-Nurturing
                    </p>
                </div>
                
                <div class=\"feature-card\">
                    <span style=\"font-size: 32px; margin-bottom: 15px; display: block;\">🎯</span>
                    <h4 style=\"color: #ffffff; font-size: 16px; margin-bottom: 10px; font-weight: 600;\">
                        Zielgruppen-Segmentierung
                    </h4>
                    <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">
                        Präzise Ansprache Ihrer verschiedenen Kundengruppen mit Smart Targeting
                    </p>
                </div>
                
                <div class=\"feature-card\">
                    <span style=\"font-size: 32px; margin-bottom: 15px; display: block;\">🔒</span>
                    <h4 style=\"color: #ffffff; font-size: 16px; margin-bottom: 10px; font-weight: 600;\">
                        DSGVO-Konformität
                    </h4>
                    <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">
                        Sicher und rechtskonform auf EU-Servern gehostet mit vollständiger Datenhoheit
                    </p>
                </div>
            </div>
            
            <div style=\"background: linear-gradient(135deg, #1e293b 0%, #334155 100%); border: 1px solid #475569; border-radius: 12px; padding: 25px; margin: 30px 0; text-align: center;\">
                <h3 style=\"color: #60a5fa; margin-bottom: 15px; font-size: 18px;\">🎁 Exklusiv für Sie</h3>
                <p style=\"color: #cbd5e1; margin-bottom: 20px;\">
                    Als neuer Kunde erhalten Sie kostenlosen Zugang zu:
                </p>
                <ul style=\"color: #cbd5e1; text-align: left; max-width: 300px; margin: 0 auto;\">
                    <li>30-minütige persönliche Onboarding-Session</li>
                    <li>Premium-Template Bibliothek (Wert: €99)</li>
                    <li>Priority Support für 30 Tage</li>
                    <li>Kostenlose Kampagnen-Optimierung</li>
                </ul>
            </div>
        </div>
        
        <!-- Quick Start Guide -->
        <div class=\"content-section\">
            <h2 class=\"section-heading\">🚀 Quick Start Guide</h2>
            <p class=\"body-text\" style=\"text-align: center;\">
                Nutzen Sie diese Ressourcen, um schnell durchzustarten:
            </p>
            
            <div style=\"display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin: 30px 0;\">
                <div style=\"background: linear-gradient(135deg, #334155 0%, #475569 100%); border-radius: 12px; padding: 20px; text-align: center;\">
                    <h4 style=\"color: #60a5fa; margin-bottom: 10px;\">📚 Wissensbasis</h4>
                    <p style=\"color: #cbd5e1; font-size: 14px; margin-bottom: 15px;\">
                        Tutorials, Best Practices und Erfolgsstrategien
                    </p>
                    <a href=\"https://cause.buzz/knowledge\" style=\"color: #60a5fa; text-decoration: none; font-size: 14px;\">
                        Jetzt erkunden →
                    </a>
                </div>
                
                <div style=\"background: linear-gradient(135deg, #334155 0%, #475569 100%); border-radius: 12px; padding: 20px; text-align: center;\">
                    <h4 style=\"color: #60a5fa; margin-bottom: 10px;\">🎥 Video-Tutorials</h4>
                    <p style=\"color: #cbd5e1; font-size: 14px; margin-bottom: 15px;\">
                        Schritt-für-Schritt Anleitungen für alle Features
                    </p>
                    <a href=\"https://cause.buzz/tutorials\" style=\"color: #60a5fa; text-decoration: none; font-size: 14px;\">
                        Videos ansehen →
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Call to Action -->
        <div class=\"content-section alternate\" style=\"text-align: center;\">
            <h2 class=\"section-heading\">🎯 Bereit für Ihren Marketing-Erfolg?</h2>
            <p class=\"body-text\">
                Unser Support-Team steht Ihnen bei Fragen jederzeit zur Verfügung. 
                Starten Sie noch heute und erleben Sie die Kraft professioneller Marketing-Tools.
            </p>
            <div style=\"margin: 30px 0;\">
                <a href=\"https://demo.cause.buzz/dashboard\" class=\"btn-primary\">📊 Dashboard öffnen</a>
                <a href=\"https://cause.buzz/support\" class=\"btn-secondary\">💬 Support kontaktieren</a>
            </div>
            
            <div style=\"background: rgba(37, 99, 235, 0.1); border: 1px solid rgba(37, 99, 235, 0.3); border-radius: 8px; padding: 20px; margin: 30px 0;\">
                <p style=\"color: #60a5fa; font-size: 14px; margin: 0;\">
                    <strong>💡 Tipp:</strong> Buchen Sie Ihr kostenloses Onboarding-Gespräch in den ersten 7 Tagen 
                    und erhalten Sie zusätzlich eine individuelle Kampagnen-Strategie im Wert von €150!
                </p>
            </div>
        </div>
        
        <!-- Social Media -->
        <div class=\"social-links\">
            <a href=\"https://linkedin.com/company/causebuzz\" aria-label=\"LinkedIn\">📱</a>
            <a href=\"https://twitter.com/causebuzz\" aria-label=\"Twitter\">🐦</a>
            <a href=\"https://youtube.com/causebuzz\" aria-label=\"YouTube\">📺</a>
        </div>
        
        <!-- Footer -->
        <div class=\"email-footer\">
            <p class=\"footer-text\">
                Cause.Buzz - Die professionelle Marketing-Plattform<br>
                40 Im alten Riet, 9494 Schaan, Liechtenstein
            </p>
            
            <div style=\"margin: 20px 0;\">
                <a href=\"https://cause.buzz/privacy\" style=\"color: #60a5fa; text-decoration: none; margin: 0 15px; font-size: 14px;\">Datenschutz</a>
                <a href=\"https://cause.buzz/support\" style=\"color: #60a5fa; text-decoration: none; margin: 0 15px; font-size: 14px;\">Support</a>
                <a href=\"https://cause.buzz/docs\" style=\"color: #60a5fa; text-decoration: none; margin: 0 15px; font-size: 14px;\">Dokumentation</a>
            </div>
            
            <p class=\"footer-text\">
                © 2024 Cause.Buzz. Alle Rechte vorbehalten.
            </p>
            
            <div style=\"margin-top: 20px; padding-top: 20px; border-top: 1px solid #334155;\">
                <p style=\"font-size: 12px; color: #64748b;\">
                    Diese Willkommens-E-Mail wurde automatisch versendet.<br>
                    Bei Fragen wenden Sie sich an: hello@cause.buzz
                </p>
            </div>
        </div>
    </div>
</body>
</html>PK
\000\000\000\000\000Y>[~!\000\000!\000\000\000\000\000/PACKAGE_INFO.md# 📦 Cause.Buzz Mautic Theme Package - Vollständige Übersicht

## 📋 Package-Inhalt

```
causebuzz-mautic-theme/
├── config.json                     # Theme-Konfiguration für Mautic
├── README.md                       # Ausführliche Dokumentation
├── INSTALLATION.md                 # Schnell-Installationsanleitung
├── PACKAGE_INFO.md                 # Diese Datei - Vollständige Übersicht
├── thumbnail.png                   # Theme-Vorschaubild
├── html/
│   └── email.html.twig            # Haupt-Template mit Twig-Variablen
├── css/
│   └── email.css                  # Zusätzliche CSS-Stile
└── examples/
    ├── newsletter-example.html     # Newsletter-Beispiel
    └── welcome-example.html       # Welcome-E-Mail Beispiel
```

## 🎯 Kern-Features

### ✅ Template-Funktionen
- **Responsive Design** - Automatische Anpassung an alle Bildschirmgrößen
- **Dark Theme** - Modernes dunkles Design mit blauen Akzentfarben
- **Multi-Builder** - Kompatibel mit GrapeJS und Legacy Builder
- **Twig-Integration** - Vollständige Mautic-Integration mit Variablen
- **DSGVO-konform** - EU-Server Badges und Compliance-Features

### 🎨 Design-System
- **Farben**: Professionelle Blau-Töne (#2563eb, #60a5fa)
- **Typography**: System-Fonts für optimale Performance
- **Gradiente**: Moderne Gradient-Effekte
- **Icons**: Emoji-basierte Icons für universelle Kompatibilität
- **Spacing**: Konsistente Abstände und Proportionen

### 📱 E-Mail Client Kompatibilität
- ✅ Gmail (alle Versionen)
- ✅ Outlook 2016+ (Desktop & Web)
- ✅ Apple Mail (macOS & iOS)
- ✅ Yahoo Mail
- ✅ Thunderbird
- ✅ Mobile Clients (iOS, Android)

## 🛠 Installation & Setup

### Mautic-Installation
1. **ZIP hochladen** in Mautic Settings > Themes
2. **Theme aktivieren** in der Theme-Liste
3. **Template verwenden** beim Erstellen neuer E-Mails

### Theme-Anpassungen
- **Logo**: Über `logo_url` Variable
- **Farben**: In CSS-Sektion anpassbar
- **Inhalte**: Über Twig-Variablen steuerbar
- **Layout**: Modularer Aufbau für Flexibilität

## 📧 Template-Varianten

### 1. Newsletter Template
**Verwendung**: Regelmäßige Newsletter, Updates, Promotions
```twig
";
        // line 2729
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["template_type"]) || array_key_exists("template_type", $context) ? $context["template_type"] : (function () { throw new RuntimeError('Variable "template_type" does not exist.', 2729, $this->source); })()), "html", null, true);
        yield " = 'newsletter'
";
        // line 2730
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["features_section"]) || array_key_exists("features_section", $context) ? $context["features_section"] : (function () { throw new RuntimeError('Variable "features_section" does not exist.', 2730, $this->source); })()), "html", null, true);
        yield " = true
";
        // line 2731
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["content_section"]) || array_key_exists("content_section", $context) ? $context["content_section"] : (function () { throw new RuntimeError('Variable "content_section" does not exist.', 2731, $this->source); })()), "html", null, true);
        yield " = true
```

**Enthält**:
- Hero-Bereich mit Hauptbotschaft
- Feature-Boxen für Updates
- Content-Sektion für Artikel/Tipps
- Social Media Integration
- CTA-Bereiche

### 2. Welcome Template
**Verwendung**: Onboarding neuer Kunden, Willkommens-E-Mails
```twig
";
        // line 2744
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["template_type"]) || array_key_exists("template_type", $context) ? $context["template_type"] : (function () { throw new RuntimeError('Variable "template_type" does not exist.', 2744, $this->source); })()), "html", null, true);
        yield " = 'welcome'
";
        // line 2745
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["steps_section"]) || array_key_exists("steps_section", $context) ? $context["steps_section"] : (function () { throw new RuntimeError('Variable "steps_section" does not exist.', 2745, $this->source); })()), "html", null, true);
        yield " = true
";
        // line 2746
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["features_section"]) || array_key_exists("features_section", $context) ? $context["features_section"] : (function () { throw new RuntimeError('Variable "features_section" does not exist.', 2746, $this->source); })()), "html", null, true);
        yield " = true
```

**Enthält**:
- Persönliche Begrüßung
- Schritt-für-Schritt Anleitung
- Feature-Highlights
- Erste Schritte Guide
- Support-Informationen

## 🎛 Konfigurationsmöglichkeiten

### Template-Variablen
```twig
# Basis-Einstellungen
";
        // line 2761
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 2761, $this->source); })()), "html", null, true);
        yield "                    # E-Mail Betreff
";
        // line 2762
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["language"]) || array_key_exists("language", $context) ? $context["language"] : (function () { throw new RuntimeError('Variable "language" does not exist.', 2762, $this->source); })()), "html", null, true);
        yield "                   # Sprache (de/en)
";
        // line 2763
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["logo_url"]) || array_key_exists("logo_url", $context) ? $context["logo_url"] : (function () { throw new RuntimeError('Variable "logo_url" does not exist.', 2763, $this->source); })()), "html", null, true);
        yield "                   # Logo URL
";
        // line 2764
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["company_name"]) || array_key_exists("company_name", $context) ? $context["company_name"] : (function () { throw new RuntimeError('Variable "company_name" does not exist.', 2764, $this->source); })()), "html", null, true);
        yield "               # Firmenname

# Content-Variablen
";
        // line 2767
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["headline"]) || array_key_exists("headline", $context) ? $context["headline"] : (function () { throw new RuntimeError('Variable "headline" does not exist.', 2767, $this->source); })()), "html", null, true);
        yield "                   # Hauptüberschrift
";
        // line 2768
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["intro_text"]) || array_key_exists("intro_text", $context) ? $context["intro_text"] : (function () { throw new RuntimeError('Variable "intro_text" does not exist.', 2768, $this->source); })()), "html", null, true);
        yield "                 # Einleitungstext
";
        // line 2769
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["main_cta_text"]) || array_key_exists("main_cta_text", $context) ? $context["main_cta_text"] : (function () { throw new RuntimeError('Variable "main_cta_text" does not exist.', 2769, $this->source); })()), "html", null, true);
        yield "             # CTA Button Text
";
        // line 2770
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["main_cta_url"]) || array_key_exists("main_cta_url", $context) ? $context["main_cta_url"] : (function () { throw new RuntimeError('Variable "main_cta_url" does not exist.', 2770, $this->source); })()), "html", null, true);
        yield "              # CTA Button URL

# Sektionen aktivieren/deaktivieren
";
        // line 2773
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["features_section"]) || array_key_exists("features_section", $context) ? $context["features_section"] : (function () { throw new RuntimeError('Variable "features_section" does not exist.', 2773, $this->source); })()), "html", null, true);
        yield "          # true/false
";
        // line 2774
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["steps_section"]) || array_key_exists("steps_section", $context) ? $context["steps_section"] : (function () { throw new RuntimeError('Variable "steps_section" does not exist.', 2774, $this->source); })()), "html", null, true);
        yield "             # true/false
";
        // line 2775
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["content_section"]) || array_key_exists("content_section", $context) ? $context["content_section"] : (function () { throw new RuntimeError('Variable "content_section" does not exist.', 2775, $this->source); })()), "html", null, true);
        yield "           # true/false

# Social Media
";
        // line 2778
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["social_linkedin"]) || array_key_exists("social_linkedin", $context) ? $context["social_linkedin"] : (function () { throw new RuntimeError('Variable "social_linkedin" does not exist.', 2778, $this->source); })()), "html", null, true);
        yield "           # LinkedIn URL
";
        // line 2779
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["social_twitter"]) || array_key_exists("social_twitter", $context) ? $context["social_twitter"] : (function () { throw new RuntimeError('Variable "social_twitter" does not exist.', 2779, $this->source); })()), "html", null, true);
        yield "            # Twitter URL
";
        // line 2780
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["social_youtube"]) || array_key_exists("social_youtube", $context) ? $context["social_youtube"] : (function () { throw new RuntimeError('Variable "social_youtube" does not exist.', 2780, $this->source); })()), "html", null, true);
        yield "           # YouTube URL

# Footer
";
        // line 2783
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["company_address"]) || array_key_exists("company_address", $context) ? $context["company_address"] : (function () { throw new RuntimeError('Variable "company_address" does not exist.', 2783, $this->source); })()), "html", null, true);
        yield "           # Firmenadresse
";
        // line 2784
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["privacy_url"]) || array_key_exists("privacy_url", $context) ? $context["privacy_url"] : (function () { throw new RuntimeError('Variable "privacy_url" does not exist.', 2784, $this->source); })()), "html", null, true);
        yield "              # Datenschutz URL
";
        // line 2785
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["imprint_url"]) || array_key_exists("imprint_url", $context) ? $context["imprint_url"] : (function () { throw new RuntimeError('Variable "imprint_url" does not exist.', 2785, $this->source); })()), "html", null, true);
        yield "              # Impressum URL
";
        // line 2786
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["unsubscribe_url"]) || array_key_exists("unsubscribe_url", $context) ? $context["unsubscribe_url"] : (function () { throw new RuntimeError('Variable "unsubscribe_url" does not exist.', 2786, $this->source); })()), "html", null, true);
        yield "          # Abmelde URL
```

### Erweiterte Konfiguration
```twig
# Features-Array
";
        // line 2792
        $context["features"] = [["icon" => "📊", "title" => "Analytics", "description" => "Detaillierte Einblicke..."]];
        // line 2799
        yield "
# Steps-Array für Onboarding
";
        // line 2801
        $context["steps"] = [["title" => "Profil vervollständigen", "description" => "Vervollständigen Sie..."]];
        // line 2807
        yield "```

## 🎨 Anpassungsoptionen

### CSS-Anpassungen
```css
/* Hauptfarben anpassen */
:root {
  --cb-primary: #2563eb;        /* Primärfarbe */
  --cb-secondary: #60a5fa;      /* Sekundärfarbe */
  --cb-background: #0f172a;     /* Hintergrund */
  --cb-surface: #1e293b;        /* Oberflächen */
}

/* Button-Stile anpassen */
.btn-primary {
  background: var(--cb-primary);
  padding: 14px 28px;
  border-radius: 8px;
}
```

### Logo & Branding
```twig
# Logo ersetzen
";
        // line 2832
        $context["logo_url"] = "https://ihre-domain.de/logo.png";
        // line 2833
        yield "
# Firmeninformationen
";
        // line 2835
        $context["company_name"] = "Ihr Firmenname";
        // line 2836
        $context["company_tagline"] = "Ihr Slogan";
        // line 2837
        $context["company_address"] = "Ihre Adresse";
        // line 2838
        yield "```

## 📊 Performance & Optimierung

### Technische Spezifikationen
- **Template-Größe**: ~25KB (komprimiert)
- **CSS-Größe**: ~15KB (inline)
- **Ladezeit**: <2 Sekunden (typisch)
- **Bilder**: Extern geladen, optimiert

### Best Practices
- **Betreffzeilen**: 30-50 Zeichen optimal
- **Preheader**: 85-100 Zeichen
- **CTA-Buttons**: Maximal 2-3 pro E-Mail
- **Bilder**: Alt-Text für Accessibility
- **Links**: Tracking-Parameter für Analytics

## 🔒 DSGVO & Compliance

### Datenschutz-Features
- **EU-Server Badges** im Header
- **DSGVO-Hinweise** prominent platziert
- **Abmelde-Links** in Footer
- **Impressum/Datenschutz** Links
- **Cookie-freie** Template-Struktur

### Rechtliche Anforderungen
- ✅ Vollständige Firmenadresse
- ✅ Impressum-Link
- ✅ Datenschutzerklärung-Link
- ✅ Ein-Klick Abmeldung
- ✅ Transparente Datenverarbeitung

## 📱 Mobile Optimierung

### Responsive Features
- **Fluid Grid**: Automatische Anpassung
- **Touch Targets**: Min. 44px Button-Größe
- **Readable Text**: Min. 16px Schriftgröße
- **Optimized Images**: Automatische Skalierung
- **Single Column**: Mobile Layout

### Mobile-spezifische Anpassungen
```css
@media only screen and (max-width: 600px) {
  .btn-primary { 
    display: block !important;
    width: 100% !important;
  }
  .features-grid {
    grid-template-columns: 1fr !important;
  }
}
```

## 🧪 Testing & QA

### E-Mail Client Tests
- **Desktop**: Outlook, Thunderbird, Apple Mail
- **Webmail**: Gmail, Yahoo, Outlook.com
- **Mobile**: iOS Mail, Android Gmail, Samsung Mail
- **Preview Tools**: Litmus, Email on Acid

### Empfohlene Test-Prozesse
1. **Spam-Filter Test** mit Mail-Tester.com
2. **Rendering Test** in verschiedenen Clients
3. **Link-Funktionalität** prüfen
4. **Mobile Darstellung** auf echten Geräten
5. **Analytics Tracking** validieren

## 📞 Support & Wartung

### Technischer Support
- **E-Mail**: hello@cause.buzz
- **Response Zeit**: 24-48 Stunden
- **Verfügbarkeit**: Mo-Fr, 9-17 Uhr CET
- **Sprachen**: Deutsch, Englisch

### Update-Policy
- **Bug Fixes**: Kostenlos
- **Feature Updates**: Im Rahmen der Lizenz
- **Mautic Updates**: Kompatibilität gewährleistet
- **Security Patches**: Priorität

### Community Resources
- **GitHub**: Template-Repository
- **Forum**: Mautic Community
- **Dokumentation**: Umfassende Guides
- **Tutorials**: Video-Anleitungen

## 📈 Analytics & Tracking

### Integrierte Tracking-Features
- **Mautic Pixel**: Automatisch eingefügt
- **UTM Parameter**: Für Campaign Tracking
- **Click Tracking**: Alle Links verfolgbar
- **Open Tracking**: Pixel-basiert
- **Custom Events**: Für erweiterte Analytics

### Empfohlene Metriken
- **Open Rate**: Ziel >25%
- **Click Rate**: Ziel >3%
- **Conversion Rate**: Ziel >1%
- **Unsubscribe Rate**: <0.5%
- **Spam Rate**: <0.1%

## 🔄 Version & Updates

### Aktuelle Version: 1.0.0
- **Release Date**: 19. Dezember 2024
- **Mautic Compatibility**: 4.0+
- **PHP Requirements**: 7.4+
- **Browser Support**: Moderne Browser

### Roadmap
- **v1.1**: Erweiterte Personalisierung
- **v1.2**: A/B Testing Integration
- **v1.3**: Advanced Analytics Dashboard
- **v2.0**: AI-powered Content Suggestions

---

## 🎉 Fazit

Dieses Theme-Package bietet eine vollständige, professionelle E-Mail-Marketing-Lösung für Mautic mit:

✅ **Sofort einsatzbereit** - Plug & Play Installation  
✅ **Hochwertig gestaltet** - Professionelles Dark Theme  
✅ **Vollständig responsiv** - Optimiert für alle Geräte  
✅ **DSGVO-konform** - Rechtssicher in der EU  
✅ **Flexibel anpassbar** - Umfangreiche Konfigurationsmöglichkeiten  
✅ **Support inklusive** - Professioneller technischer Support  

**Starten Sie noch heute mit professionellem E-Mail-Marketing!** 🚀PK\000
\000\000\000\000\000Y>[zm\000\000m\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000/config.jsonPK\000
\000\000\000\000\000Y>[?G\000\000G\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000html/email.html.twigPK\000
\000\000\000\000\000Y>[?G\000\000G\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000N\000\000html/message.html.twigPK\000
\000\000\000\000\000Y>[_]\000\000\000\000
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000/README.mdPK\000
\000\000\000\000\000Y>[\000\000\000\000
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000css/email.cssPK\000
\000\000\000\000\000Y>[r\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000/thumbnail.pngPK\000
\000\000\000\000\000Y>[\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000/INSTALLATION.mdPK\000
\000\000\000\000\000Y>[G,\000\000,\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000M\000\000examples/newsletter-example.htmlPK\000
\000\000\000\000\000Y>[J\000\000J\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000examples/welcome-example.htmlPK\000
\000\000\000\000\000Y>[~!\000\000!\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000dQ\000/PACKAGE_INFO.mdPK\000\000\000\000
\000
\000\000\000es\000\000\000";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@themes/causebuzz-mautic-theme.zip";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  3429 => 2838,  3427 => 2837,  3425 => 2836,  3423 => 2835,  3419 => 2833,  3417 => 2832,  3390 => 2807,  3388 => 2801,  3384 => 2799,  3382 => 2792,  3373 => 2786,  3369 => 2785,  3365 => 2784,  3361 => 2783,  3355 => 2780,  3351 => 2779,  3347 => 2778,  3341 => 2775,  3337 => 2774,  3333 => 2773,  3327 => 2770,  3323 => 2769,  3319 => 2768,  3315 => 2767,  3309 => 2764,  3305 => 2763,  3301 => 2762,  3297 => 2761,  3279 => 2746,  3275 => 2745,  3271 => 2744,  3255 => 2731,  3251 => 2730,  3247 => 2729,  1894 => 1378,  1892 => 1377,  1890 => 1376,  1888 => 1375,  1882 => 1371,  1880 => 1370,  1862 => 1354,  1860 => 1347,  1858 => 1346,  1856 => 1345,  1850 => 1341,  1848 => 1340,  1846 => 1339,  1844 => 1338,  1842 => 1337,  1840 => 1336,  1838 => 1335,  1832 => 1331,  1830 => 1330,  1828 => 1329,  1826 => 1328,  1824 => 1327,  1822 => 1326,  1820 => 1325,  1810 => 1318,  1806 => 1317,  1802 => 1316,  1798 => 1315,  1790 => 1310,  1786 => 1309,  1782 => 1308,  1776 => 1304,  1774 => 1294,  1768 => 1290,  1766 => 1278,  1758 => 1273,  1754 => 1272,  1750 => 1271,  1746 => 1270,  1742 => 1269,  1734 => 1264,  1730 => 1263,  1726 => 1262,  1722 => 1261,  1714 => 1256,  1710 => 1255,  1706 => 1254,  1702 => 1253,  1694 => 1248,  1690 => 1247,  1686 => 1246,  1682 => 1245,  1678 => 1244,  1674 => 1243,  1620 => 1191,  1614 => 1189,  1612 => 1188,  1598 => 1181,  1589 => 1177,  1583 => 1176,  1577 => 1175,  1570 => 1171,  1564 => 1170,  1554 => 1163,  1550 => 1162,  1546 => 1161,  1534 => 1154,  1529 => 1152,  1525 => 1151,  1520 => 1148,  1511 => 1144,  1506 => 1142,  1502 => 1141,  1498 => 1139,  1496 => 1138,  1493 => 1137,  1484 => 1133,  1479 => 1130,  1461 => 1126,  1457 => 1125,  1452 => 1123,  1449 => 1122,  1432 => 1121,  1426 => 1118,  1422 => 1116,  1420 => 1115,  1417 => 1114,  1413 => 1112,  1404 => 1109,  1400 => 1108,  1396 => 1107,  1393 => 1106,  1389 => 1105,  1384 => 1103,  1380 => 1101,  1378 => 1100,  1375 => 1099,  1366 => 1095,  1361 => 1093,  1357 => 1092,  1353 => 1090,  1343 => 1085,  1338 => 1083,  1334 => 1082,  1330 => 1081,  1326 => 1079,  1324 => 1078,  1310 => 1067,  883 => 643,  876 => 639,  871 => 636,  865 => 634,  863 => 633,  849 => 626,  840 => 622,  834 => 621,  828 => 620,  821 => 616,  815 => 615,  805 => 608,  801 => 607,  797 => 606,  785 => 599,  780 => 597,  776 => 596,  771 => 593,  762 => 589,  757 => 587,  753 => 586,  749 => 584,  747 => 583,  744 => 582,  735 => 578,  730 => 575,  712 => 571,  708 => 570,  703 => 568,  700 => 567,  683 => 566,  677 => 563,  673 => 561,  671 => 560,  668 => 559,  664 => 557,  655 => 554,  651 => 553,  647 => 552,  644 => 551,  640 => 550,  635 => 548,  631 => 546,  629 => 545,  626 => 544,  617 => 540,  612 => 538,  608 => 537,  604 => 535,  594 => 530,  589 => 528,  585 => 527,  581 => 526,  577 => 524,  575 => 523,  561 => 512,  134 => 88,  127 => 84,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@themes/causebuzz-mautic-theme.zip", "/var/www/mautic-upgrade/docroot/themes/causebuzz-mautic-theme.zip");
    }
}
