<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Tests/Functional/UserEntityTrait.php */
class __TwigTemplate_aa64402e4b33b79743065b6f2dffbddb extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\CoreBundle\\Tests\\Functional;

use Mautic\\UserBundle\\Entity\\Permission;
use Mautic\\UserBundle\\Entity\\Role;
use Mautic\\UserBundle\\Entity\\User;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\PasswordHasher\\PasswordHasherInterface;

trait UserEntityTrait
{
    private function loginOtherUser(string \$name): void
    {
        \$this->client->request(Request::METHOD_GET, '/s/logout');
        \$this->loginUser(\$name);
        \$this->client->setServerParameter('PHP_AUTH_USER', \$name);
        \$this->client->setServerParameter('PHP_AUTH_PW', 'mautic');
    }

    /**
     * @param array<string, mixed> \$userDetails
     */
    private function createUserWithPermission(array \$userDetails): User
    {
        \$role = \$this->createRole(\$userDetails['role']['name']);

        foreach (\$userDetails['role']['permissions'] as \$permission => \$bitwise) {
            \$this->createPermission(\$role, \$permission, \$bitwise);
        }

        return \$this->createUser(\$userDetails['email'], \$userDetails['user-name'], \$userDetails['first-name'], \$userDetails['last-name'], \$role);
    }

    private function createRole(string \$name, bool \$isAdmin = false): Role
    {
        \$role = new Role();
        \$role->setName(\$name);
        \$role->setIsAdmin(\$isAdmin);

        \$this->em->persist(\$role);

        return \$role;
    }

    private function createUser(
        string \$email,
        string \$username,
        string \$firstName,
        string \$lastName,
        ?Role \$role,
    ): User {
        \$user = new User();
        \$user->setEmail(\$email);
        \$user->setUsername(\$username);
        \$user->setFirstName(\$firstName);
        \$user->setLastName(\$lastName);

        if (\$role) {
            \$user->setRole(\$role);
        }

        /** @var PasswordHasherInterface \$encoder */
        \$encoder = self::getContainer()->get('security.password_hasher_factory')->getPasswordHasher(\$user);
        \$user->setPassword(\$encoder->hash('mautic'));

        \$this->em->persist(\$user);

        return \$user;
    }

    private function createPermission(Role \$role, string \$rawPermission, int \$bitwise): void
    {
        \$parts      = explode(':', \$rawPermission);
        \$permission = new Permission();
        \$permission->setBundle(\$parts[0]);
        \$permission->setName(\$parts[1]);
        \$permission->setRole(\$role);
        \$permission->setBitwise(\$bitwise);
        \$this->em->persist(\$permission);
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Tests/Functional/UserEntityTrait.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Tests/Functional/UserEntityTrait.php", "/var/www/mautic-upgrade/docroot/app/bundles/CoreBundle/Tests/Functional/UserEntityTrait.php");
    }
}
