<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/PageBundle/Tests/Controller/NotFoundFunctionalTest.php */
class __TwigTemplate_0af7b841eb3978591b90b9557f29e961 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\PageBundle\\Tests\\Controller;

use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use Mautic\\PageBundle\\Entity\\Page;
use PHPUnit\\Framework\\Assert;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\HttpFoundation\\Response;

final class NotFoundFunctionalTest extends MauticMysqlTestCase
{
    protected \$useCleanupRollback = false;

    public function testCustom404Page(): void
    {
        // Create a custom 404 page:
        \$notFoundPage = new Page();
        \$notFoundPage->setTitle('404 Not Found');
        \$notFoundPage->setAlias('404-not-found');
        \$notFoundPage->setCustomHtml('<html><body>Custom 404 Not Found Page</body></html>');

        \$this->em->persist(\$notFoundPage);
        \$this->em->flush();

        // Configure the 404 page:
        \$this->configParams['404_page'] = \$notFoundPage->getId();
        parent::setUpSymfony(\$this->configParams);

        // Test the custom 404 page:
        \$crawler = \$this->client->request(Request::METHOD_GET, '/page-that-does-not-exist');
        Assert::assertSame(Response::HTTP_NOT_FOUND, \$this->client->getResponse()->getStatusCode());
        Assert::assertStringContainsString('Custom 404 Not Found Page', \$crawler->text());
        Assert::assertFalse(\$this->client->getResponse()->isRedirection(), 'The response should not be a redirect.');
        Assert::assertSame('/page-that-does-not-exist', \$this->client->getRequest()->getRequestUri(), 'The request URI should be the same as the original URI.');
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/PageBundle/Tests/Controller/NotFoundFunctionalTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/PageBundle/Tests/Controller/NotFoundFunctionalTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/PageBundle/Tests/Controller/NotFoundFunctionalTest.php");
    }
}
