<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/EmailBundle/Tests/Controller/EmailDraftFunctionalTest.php */
class __TwigTemplate_54271deae78ffbd570e055b711ee0b0c extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\EmailBundle\\Tests\\Controller;

use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use Mautic\\EmailBundle\\Entity\\Email;
use Mautic\\EmailBundle\\Entity\\EmailDraft;
use PHPUnit\\Framework\\Assert;
use Symfony\\Component\\HttpFoundation\\Request;

final class EmailDraftFunctionalTest extends MauticMysqlTestCase
{
    protected function setUp(): void
    {
        \$this->configParams['email_draft_enabled'] = 'testEmailDraftNotConfigured' !== \$this->getName();

        parent::setUp();
    }

    public function testEmailDraftNotConfigured(): void
    {
        \$email   = \$this->createNewEmail();
        \$crawler = \$this->client->request(Request::METHOD_GET, \"/s/emails/edit/{\$email->getId()}\");
        Assert::assertEquals(0, \$crawler->selectButton('Save as Draft')->count());
        Assert::assertEquals(0, \$crawler->selectButton('Apply Draft')->count());
        Assert::assertEquals(0, \$crawler->selectButton('Discard Draft')->count());
    }

    public function testEmailDraftConfigured(): void
    {
        \$email   = \$this->createNewEmail();
        \$crawler = \$this->client->request(Request::METHOD_GET, \"/s/emails/edit/{\$email->getId()}\");

        Assert::assertEquals(1, \$crawler->selectButton('Save as Draft')->count());
        Assert::assertEquals(0, \$crawler->selectButton('Apply Draft')->count());
        Assert::assertEquals(0, \$crawler->selectButton('Discard Draft')->count());
    }

    public function testCheckDraftInList(): void
    {
        \$email   = \$this->createNewEmail();
        \$crawler = \$this->client->request(Request::METHOD_GET, '/s/emails');
        \$this->assertStringNotContainsString('Has Draft', \$crawler->filter('#app-content a[href=\"/s/emails/view/'.\$email->getId().'\"]')->html());
        \$this->saveDraft(\$email);
        \$crawler = \$this->client->request(Request::METHOD_GET, '/s/emails');
        \$this->assertStringContainsString('Has Draft', \$crawler->filter('#app-content a[href=\"/s/emails/view/'.\$email->getId().'\"]')->html());
    }

    public function testPreviewDraft(): void
    {
        \$email = \$this->createNewEmail();
        \$this->saveDraft(\$email);
        \$crawler = \$this->client->request(Request::METHOD_GET, \"/email/preview/{\$email->getId()}\");
        \$this->assertEquals('Test html', \$crawler->text());

        \$crawler = \$this->client->request(Request::METHOD_GET, \"/email/preview/{\$email->getId()}/draft\");
        \$this->assertEquals('Test html Draft', \$crawler->text());
    }

    public function testSaveDraftAndApplyDraftForLegacy(): void
    {
        \$email = \$this->createNewEmail();
        \$this->applyDraft(\$email);
    }

    public function testDiscardDraftForLegacy(): void
    {
        \$email = \$this->createNewEmail();
        \$this->discardDraft(\$email);
    }

    public function testEmailDeleteCascade(): void
    {
        \$email = \$this->createNewEmail();
        \$this->saveDraft(\$email);
        \$this->client->request(Request::METHOD_POST, \"/s/emails/delete/{\$email->getId()}\");
        \$emailDraft = \$this->em->getRepository(EmailDraft::class)->findOneBy(['email' => \$email]);
        Assert::assertNull(\$emailDraft);
    }

    private function applyDraft(Email \$email): void
    {
        \$this->saveDraft(\$email);
        \$crawler = \$this->client->request(Request::METHOD_GET, \"/s/emails/edit/{\$email->getId()}\");
        \$form    = \$crawler->selectButton('Apply Draft')->form();
        \$this->client->submit(\$form);
        Assert::assertTrue(\$this->client->getResponse()->isOk());

        \$emailDraft = \$this->em->getRepository(EmailDraft::class)->findOneBy(['email' => \$email]);

        Assert::assertNull(\$emailDraft);
        Assert::assertSame('Test html Draft', \$email->getCustomHtml());
    }

    private function discardDraft(Email \$email): void
    {
        \$this->saveDraft(\$email);
        \$crawler = \$this->client->request(Request::METHOD_GET, \"/s/emails/edit/{\$email->getId()}\");
        \$form    = \$crawler->selectButton('Discard Draft')->form();
        \$this->client->submit(\$form);
        Assert::assertTrue(\$this->client->getResponse()->isOk());

        \$emailDraft = \$this->em->getRepository(EmailDraft::class)->findOneBy(['email' => \$email]);

        Assert::assertNull(\$emailDraft);
        Assert::assertSame('Test html', \$email->getCustomHtml());
    }

    private function saveDraft(Email \$email): void
    {
        \$crawler = \$this->client->request(Request::METHOD_GET, \"/s/emails/edit/{\$email->getId()}\");

        \$form                          = \$crawler->selectButton('Save as Draft')->form();
        \$form['emailform[customHtml]'] = 'Test html Draft';
        \$this->client->submit(\$form);
        Assert::assertTrue(\$this->client->getResponse()->isOk());

        \$emailDraft = \$this->em->getRepository(EmailDraft::class)->findOneBy(['email' => \$email]);
        Assert::assertEquals('Test html Draft', \$emailDraft->getHtml());
        Assert::assertSame('Test html', \$email->getCustomHtml());
    }

    private function createNewEmail(string \$templateName = 'blank', string \$templateContent = 'Test html'): Email
    {
        \$email = new Email();
        \$email->setName('Email A');
        \$email->setSubject('Email A Subject');
        \$email->setEmailType('template');
        \$email->setTemplate(\$templateName);
        \$email->setCustomHtml(\$templateContent);
        \$this->em->persist(\$email);
        \$this->em->flush();

        return \$email;
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/EmailBundle/Tests/Controller/EmailDraftFunctionalTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/EmailBundle/Tests/Controller/EmailDraftFunctionalTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/EmailBundle/Tests/Controller/EmailDraftFunctionalTest.php");
    }
}
