<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/PointBundle/Tests/Unit/Helper/EventHelperTest.php */
class __TwigTemplate_bcdd7a24e070f1a5246a5b1c6883bba1 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\PointBundle\\Tests\\Unit\\Helper;

use Mautic\\LeadBundle\\Entity\\Lead;
use Mautic\\PointBundle\\Helper\\EventHelper;
use PHPUnit\\Framework\\TestCase;

class EventHelperTest extends TestCase
{
    public function testEngagePointAction(): void
    {
        \$lead = new Lead();

        // Define the action array
        \$action = ['id' => 1, 'type' => 'helloworld.action.custom_action', 'name' => 'My custom point action', 'properties' => [], 'points' => 50];

        \$points = EventHelper::engagePointAction(\$lead, \$action);
        \$this->assertEquals(50, \$points);

        \$points = EventHelper::engagePointAction(\$lead, \$action);
        \$this->assertEquals(0, \$points, 'Second call should return 0 points because the action is already initiated for this lead and type and session.');
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/PointBundle/Tests/Unit/Helper/EventHelperTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/PointBundle/Tests/Unit/Helper/EventHelperTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/PointBundle/Tests/Unit/Helper/EventHelperTest.php");
    }
}
