<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Tests/Helper/Chart/PieChartTest.php */
class __TwigTemplate_a0c2f753dd5c7a0e80a9a3a06eb4a69e extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\CoreBundle\\Tests\\Helper\\Chart;

use Mautic\\CoreBundle\\Helper\\Chart\\PieChart;
use PHPUnit\\Framework\\TestCase;

class PieChartTest extends TestCase
{
    /**
     * @var PieChart
     */
    private \$pieChart;

    protected function setUp(): void
    {
        \$this->pieChart = new PieChart();
    }

    public function testSetDatasetIncreasesTotalCount(): void
    {
        \$this->pieChart->setDataset('Label 1', 10);
        \$this->pieChart->setDataset('Label 2', 20);

        \$reflection         = new \\ReflectionClass(\$this->pieChart);
        \$totalCountProperty = \$reflection->getProperty('totalCount');
        \$totalCountProperty->setAccessible(true);

        \$totalCount = \$totalCountProperty->getValue(\$this->pieChart);

        \$this->assertEquals(30, \$totalCount);
    }

    public function testSetDatasetStoresDataCorrectly(): void
    {
        \$this->pieChart->setDataset('Label 1', 10);
        \$this->pieChart->setDataset('Label 2', 20);

        \$renderedChart  = \$this->pieChart->render(false);
        \$renderedChart2 = \$this->pieChart->render();

        \$this->assertCount(2, \$renderedChart['labels']);
        \$this->assertCount(2, \$renderedChart['datasets'][0]['data']);

        \$this->assertSame(['Label 1', 'Label 2'], \$renderedChart['labels']);
        \$this->assertSame(['Label 1; 10x, 33.33%', 'Label 2; 20x, 66.67%'], \$renderedChart2['labels']);
        \$this->assertSame([10, 20], \$renderedChart['datasets'][0]['data']);
    }

    public function testRenderWithCounts(): void
    {
        \$this->pieChart->setDataset('Label 1', 10);
        \$this->pieChart->setDataset('Label 2', 20);

        \$renderedChart = \$this->pieChart->render(true);

        \$this->assertSame('Label 1; 10x, 33.33%', \$renderedChart['labels'][0]);
        \$this->assertSame('Label 2; 20x, 66.67%', \$renderedChart['labels'][1]);
    }

    public function testRenderWithoutCounts(): void
    {
        \$this->pieChart->setDataset('Label 1', 10);
        \$this->pieChart->setDataset('Label 2', 20);

        \$renderedChart = \$this->pieChart->render(false);

        \$this->assertSame('Label 1', \$renderedChart['labels'][0]);
        \$this->assertSame('Label 2', \$renderedChart['labels'][1]);
    }

    public function testBuildFullLabel(): void
    {
        \$this->pieChart->setDataset('Label 1', 10);
        \$this->pieChart->setDataset('Label 2', 20);

        \$fullLabel = \$this->pieChart->buildFullLabel('Label 1', 10);

        \$this->assertSame('Label 1; 10x, 33.33%', \$fullLabel);
    }

    public function testBuildFullLabelWithoutTotalCount(): void
    {
        \$emptyPieChart = new PieChart();
        \$fullLabel     = \$emptyPieChart->buildFullLabel('Label 1', 10);

        \$this->assertSame('Label 1', \$fullLabel);
    }

    public function testGenerateColors(): void
    {
        \$colors = \$this->pieChart->render()['datasets'][0];

        \$this->assertArrayHasKey('backgroundColor', \$colors);
        \$this->assertArrayHasKey('hoverBackgroundColor', \$colors);
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Tests/Helper/Chart/PieChartTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Tests/Helper/Chart/PieChartTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/CoreBundle/Tests/Helper/Chart/PieChartTest.php");
    }
}
