<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/LeadBundle/Tests/Functional/EventListener/SegmentSubscriberTest.php */
class __TwigTemplate_ae9e527b2dbcafb4a1c8ca576c762146 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\LeadBundle\\Tests\\Functional\\EventListener;

use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use Mautic\\LeadBundle\\Entity\\LeadList;
use Mautic\\LeadBundle\\Entity\\LeadListRepository;
use PHPUnit\\Framework\\Assert;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Contracts\\Translation\\TranslatorInterface;

class SegmentSubscriberTest extends MauticMysqlTestCase
{
    /**
     * @dataProvider filterProvider
     *
     * @param mixed[]  \$filters
     * @param string[] \$expectedTranslations
     */
    public function testSegmentFilterAlertMessages(array \$filters, array \$expectedTranslations): void
    {
        \$segment   = \$this->saveSegment('Segment D', 'segment-d', \$filters);
        \$crawler   = \$this->client->request(Request::METHOD_GET, '/s/segments/edit/'.\$segment->getId());
        Assert::assertTrue(\$this->client->getResponse()->isOk());
        /** @var TranslatorInterface \$translator */
        \$translator = \$this->getContainer()->get('translator');

        \$expectedTranslationString = implode(' ', array_map(fn (\$trans) => \$translator->trans(\$trans), \$expectedTranslations));

        \$crawlerText = \$crawler->filter('#leadlist_filters_0_properties')->filter('.alert')->text();
        \$this->assertStringContainsString(\$expectedTranslationString, \$crawlerText);
    }

    /**
     * @return \\Generator<array<mixed>>
     */
    public function filterProvider(): \\Generator
    {
        yield [[
            [
                'glue'     => 'and',
                'field'    => 'email',
                'object'   => 'lead',
                'type'     => 'email',
                'operator' => 'like',
            ],
        ], ['mautic.lead_list.filter.alert.like', 'mautic.lead_list.filter.alert.email']];
        yield [[
            [
                'glue'     => 'and',
                'field'    => 'firstname',
                'object'   => 'lead',
                'type'     => 'text',
                'operator' => 'contains',
            ],
        ], ['mautic.lead_list.filter.alert.contain']];
        yield [[
            [
                'glue'     => 'and',
                'field'    => 'firstname',
                'object'   => 'lead',
                'type'     => 'text',
                'operator' => 'like',
            ],
        ], ['mautic.lead_list.filter.alert.like']];
        yield [[
            [
                'glue'     => 'and',
                'field'    => 'firstname',
                'object'   => 'lead',
                'type'     => 'text',
                'operator' => 'endsWith',
            ],
        ], ['mautic.lead_list.filter.alert.endwith']];
    }

    /**
     * @param array<mixed> \$filters
     */
    private function saveSegment(string \$name, string \$alias, array \$filters): LeadList
    {
        \$segmentRepo = \$this->em->getRepository(LeadList::class);
        \\assert(\$segmentRepo instanceof LeadListRepository);
        \$segment     = new LeadList();
        \$segment->setName(\$name)
            ->setPublicName(\$name)
            ->setFilters(\$filters)
            ->setAlias(\$alias);
        \$segmentRepo->saveEntity(\$segment);

        return \$segment;
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/LeadBundle/Tests/Functional/EventListener/SegmentSubscriberTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/LeadBundle/Tests/Functional/EventListener/SegmentSubscriberTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/LeadBundle/Tests/Functional/EventListener/SegmentSubscriberTest.php");
    }
}
