<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CampaignBundle/Tests/Controller/AjaxControllerFunctionalTest.php */
class __TwigTemplate_98ecdfa0636c2391d5fdaeb9571cb5f9 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\CampaignBundle\\Tests\\Controller;

use Mautic\\CampaignBundle\\Entity\\LeadEventLog;
use Mautic\\CampaignBundle\\Entity\\LeadEventLogRepository;
use Mautic\\CampaignBundle\\Tests\\Functional\\Fixtures\\FixtureHelper;
use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use PHPUnit\\Framework\\Assert;
use Symfony\\Component\\HttpFoundation\\Request;

class AjaxControllerFunctionalTest extends MauticMysqlTestCase
{
    public function testCancelScheduledCampaignEventAction(): void
    {
        \$fixtureHelper = new FixtureHelper(\$this->em);
        \$contact       = \$fixtureHelper->createContact('some@contact.email');
        \$campaign      = \$fixtureHelper->createCampaign('Scheduled event test');
        \$fixtureHelper->addContactToCampaign(\$contact, \$campaign);
        \$fixtureHelper->createCampaignWithScheduledEvent(\$campaign);
        \$this->em->flush();

        \$commandResult = \$this->testSymfonyCommand('mautic:campaigns:trigger', ['--campaign-id' => \$campaign->getId()]);

        Assert::assertStringContainsString('1 total event was scheduled', \$commandResult->getDisplay());

        \$payload = [
            'action'    => 'campaign:cancelScheduledCampaignEvent',
            'eventId'   => \$campaign->getEvents()[0]->getId(),
            'contactId' => \$contact->getId(),
        ];

        \$this->client->request(Request::METHOD_POST, '/s/ajax', \$payload, [], \$this->createAjaxHeaders());

        // Ensure we'll fetch fresh data from the database and not from entity manager.
        \$this->em->detach(\$contact);
        \$this->em->detach(\$campaign);

        /** @var LeadEventLogRepository \$leadEventLogRepository */
        \$leadEventLogRepository = \$this->em->getRepository(LeadEventLog::class);

        /** @var LeadEventLog \$log */
        \$log = \$leadEventLogRepository->findOneBy(['lead' => \$contact, 'campaign' => \$campaign]);

        Assert::assertTrue(\$this->client->getResponse()->isOk());
        Assert::assertSame('{\"success\":1}', \$this->client->getResponse()->getContent());
        Assert::assertFalse(\$log->getIsScheduled());
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CampaignBundle/Tests/Controller/AjaxControllerFunctionalTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CampaignBundle/Tests/Controller/AjaxControllerFunctionalTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/CampaignBundle/Tests/Controller/AjaxControllerFunctionalTest.php");
    }
}
