<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/PluginBundle/Tests/EventListener/IntegrationSubscriberTest.php */
class __TwigTemplate_17e1bd5f1e5fe763d31d01f23f8049dc extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\PluginBundle\\Tests\\EventListener;

use Mautic\\PluginBundle\\Event\\PluginIntegrationRequestEvent;
use Mautic\\PluginBundle\\EventListener\\IntegrationSubscriber;
use PHPUnit\\Framework\\TestCase;
use Psr\\Log\\LoggerInterface;

final class IntegrationSubscriberTest extends TestCase
{
    public function testOnRequestLogging(): void
    {
        \$event = \$this->createMock(PluginIntegrationRequestEvent::class);
        \$event->method('getIntegrationName')->willReturn('Integration');
        \$event->method('getHeaders')->willReturn(['Authorization: Bearer some_token']);
        \$event->method('getMethod')->willReturn('POST');
        \$event->method('getUrl')->willReturn('https://mautic.org');
        \$event->method('getParameters')->willReturn(['key' => 'value']);
        \$event->method('getSettings')->willReturn(['setting' => 'value']);

        \$authorization = ['Authorization: Bearer [REDACTED]'];
        \$authorization = var_export(\$authorization, true);

        \$logger = \$this->createMock(LoggerInterface::class);
        \$logger->expects(\$this->exactly(4))
            ->method('debug')
            ->withConsecutive(
                ['INTEGRATION REQUEST URL: POST https://mautic.org'],
                [\"INTEGRATION REQUEST HEADERS: \\n\".\$authorization.PHP_EOL],
            );

        \$subscriber = new IntegrationSubscriber(\$logger);
        \$subscriber->onRequest(\$event);
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/PluginBundle/Tests/EventListener/IntegrationSubscriberTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/PluginBundle/Tests/EventListener/IntegrationSubscriberTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/PluginBundle/Tests/EventListener/IntegrationSubscriberTest.php");
    }
}
