<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/EmailBundle/Tests/EventListener/TokenSubscriberTest.php */
class __TwigTemplate_504ab9e1360e47951b7efc28891dc266 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\EmailBundle\\Tests\\EventListener;

use Mautic\\CoreBundle\\Factory\\MauticFactory;
use Mautic\\CoreBundle\\Helper\\CoreParametersHelper;
use Mautic\\EmailBundle\\Entity\\Email;
use Mautic\\EmailBundle\\Event\\EmailSendEvent;
use Mautic\\EmailBundle\\EventListener\\TokenSubscriber;
use Mautic\\EmailBundle\\Helper\\FromEmailHelper;
use Mautic\\EmailBundle\\Helper\\MailHashHelper;
use Mautic\\EmailBundle\\Helper\\MailHelper;
use Mautic\\EmailBundle\\MonitoredEmail\\Mailbox;
use Mautic\\EmailBundle\\Tests\\Helper\\Transport\\SmtpTransport;
use Mautic\\LeadBundle\\Entity\\Lead;
use Mautic\\LeadBundle\\Entity\\LeadListRepository;
use Mautic\\LeadBundle\\Helper\\PrimaryCompanyHelper;
use PHPUnit\\Framework\\MockObject\\MockObject;
use Psr\\Log\\LoggerInterface;
use Symfony\\Component\\EventDispatcher\\EventDispatcher;
use Symfony\\Component\\Mailer\\Mailer;
use Symfony\\Component\\Routing\\RouterInterface;

class TokenSubscriberTest extends \\PHPUnit\\Framework\\TestCase
{
    public function testDynamicContentCustomTokens(): void
    {
        /** @var MockObject&MauticFactory \$mockFactory */
        \$mockFactory = \$this->createMock(MauticFactory::class);

        /** @var MockObject&FromEmailHelper \$fromEmailHelper */
        \$fromEmailHelper = \$this->createMock(FromEmailHelper::class);

        /** @var MockObject&CoreParametersHelper \$coreParametersHelper */
        \$coreParametersHelper = \$this->createMock(CoreParametersHelper::class);

        /** @var MockObject&Mailbox \$mailbox */
        \$mailbox = \$this->createMock(Mailbox::class);

        /** @var MockObject&LoggerInterface \$logger */
        \$logger = \$this->createMock(LoggerInterface::class);

        /** @var MockObject&RouterInterface \$router */
        \$router = \$this->createMock(RouterInterface::class);

        \$mailHashHelper = new MailHashHelper(\$coreParametersHelper);

        \$coreParametersHelper->method('get')
            ->willReturnMap(
                [
                    ['mailer_from_email', null, 'nobody@nowhere.com'],
                    ['mailer_from_name', null, 'No Body'],
                ]
            );

        \$tokens = ['{test}' => 'value'];

        \$mailHelper = new MailHelper(\$mockFactory, new Mailer(new SmtpTransport()), \$fromEmailHelper, \$coreParametersHelper, \$mailbox, \$logger, \$mailHashHelper, \$router);
        \$mailHelper->setTokens(\$tokens);

        \$email = new Email();
        \$email->setSubject('Test subject');
        \$email->setCustomHtml(
            <<<'CONTENT'
<html xmlns=\"http://www.w3.org/1999/xhtml\">
    <body style=\"margin: 0px; cursor: auto;\" class=\"ui-sortable\">
        <div data-section-wrapper=\"1\">
            <center>
                <table data-section=\"1\" style=\"width: 600;\" width=\"600\" cellpadding=\"0\" cellspacing=\"0\">
                    <tbody>
                        <tr>
                            <td>
                                <div data-slot-container=\"1\" style=\"min-height: 30px\">
                                    <div data-slot=\"text\"><br /><h2>Hello there!</h2><br />{test} test We haven't heard from you for a while...<a href=\"https://google.com\">check this link</a><br /><br />{unsubscribe_text} | {webview_text}</div>{dynamiccontent=\"Dynamic Content 2\"}<div data-slot=\"codemode\">
                                    <div id=\"codemodeHtmlContainer\">
    <p>Place your content here {test}</p></div>

                                </div>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </center>
        </div>
</body></html>
CONTENT
        )
            ->setDynamicContent(
                [
                    [
                        'tokenName' => 'Dynamic Content 1',
                        'content'   => 'Default Dynamic Content',
                        'filters'   => [
                            [
                                'content' => null,
                                'filters' => [
                                ],
                            ],
                        ],
                    ],
                    [
                        'tokenName' => 'Dynamic Content 2',
                        'content'   => 'DEC {test}',
                        'filters'   => [
                        ],
                    ],
                ]
            );
        \$mailHelper->setEmail(\$email);

        \$lead = new Lead();
        \$lead->setEmail('hello@someone.com');
        \$mailHelper->setLead(\$lead);

        \$dispatcher           = new EventDispatcher();
        \$primaryCompanyHelper = \$this->createMock(PrimaryCompanyHelper::class);
        \$primaryCompanyHelper->method('getProfileFieldsWithPrimaryCompany')
            ->willReturn(['email' => 'hello@someone.com']);
        \$segmentRepository    = \$this->createMock(LeadListRepository::class);

        /** @var TokenSubscriber \$subscriber */
        \$subscriber = \$this->getMockBuilder(TokenSubscriber::class)
            ->setConstructorArgs([\$dispatcher, \$primaryCompanyHelper, \$segmentRepository])
            ->onlyMethods([])
            ->getMock();

        \$dispatcher->addSubscriber(\$subscriber);

        \$event = new EmailSendEvent(\$mailHelper);

        \$subscriber->decodeTokens(\$event);

        \$eventTokens = \$event->getTokens(false);
        \$this->assertEquals(
            \$eventTokens,
            [
                '{dynamiccontent=\"Dynamic Content 1\"}' => 'Default Dynamic Content',
                '{dynamiccontent=\"Dynamic Content 2\"}' => 'DEC value',
            ]
        );
        \$mailHelper->addTokens(\$eventTokens);
        \$mailerTokens = \$mailHelper->getTokens();
        \$mailHelper->message->html(\$email->getCustomHtml());
        \$mailHelper->message->subject(\$email->getSubject());

        MailHelper::searchReplaceTokens(array_keys(\$mailerTokens), \$mailerTokens, \$mailHelper->message);
        \$parsedBody = \$mailHelper->message->getHtmlBody();

        \$this->assertNotFalse(strpos(\$parsedBody, 'DEC value'));
        \$this->assertNotFalse(strpos(\$parsedBody, 'value test We'));
        \$this->assertNotFalse(strpos(\$parsedBody, 'Place your content here value'));
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/EmailBundle/Tests/EventListener/TokenSubscriberTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/EmailBundle/Tests/EventListener/TokenSubscriberTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/EmailBundle/Tests/EventListener/TokenSubscriberTest.php");
    }
}
