<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/ApiBundle/Tests/Functional/Controller/ClientControllerTest.php */
class __TwigTemplate_b6c143785c76ea36a24f3a4ffe1dfd86 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\ApiBundle\\Tests\\Functional\\Controller;

use Mautic\\ApiBundle\\Entity\\oAuth2\\Client;
use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\HttpFoundation\\Response;

class ClientControllerTest extends MauticMysqlTestCase
{
    private const TOTAL_COUNT = 6;

    /**
     * @runInSeparateProcess
     */
    public function testIndexActionForPager(): void
    {
        \$this->createApiClients();

        // Test the first page without limits
        \$this->requestCredentialsPage();
        \$this->assertPaginationDetails(1);

        // Test pagination with varying limits
        \$this->requestCredentialsPage(5);
        \$this->assertPaginationDetails(2);
    }

    private function createApiClients(): void
    {
        foreach (range(1, self::TOTAL_COUNT) as \$i) {
            \$client = new Client();
            \$client->setName('client'.\$i);
            \$client->setRedirectUris(['https://example.com/'.\$i]);

            \$this->em->persist(\$client);
        }

        \$this->em->flush();
        \$this->em->clear();
    }

    /**
     * Make a request to the credentials page with pagination.
     */
    private function requestCredentialsPage(?int \$limit = null): void
    {
        \$url = '/s/credentials?tmpl=list&name=client';
        if (\$limit) {
            \$url .= '&limit='.\$limit;
        }

        \$this->client->request(Request::METHOD_GET, \$url);
    }

    /**
     * Assert the pagination details on the response.
     *
     * @param int \$pageCount The expected number of pages
     */
    private function assertPaginationDetails(int \$pageCount): void
    {
        \$content = \$this->client->getResponse()->getContent();
        \$this->assertSame(Response::HTTP_OK, \$this->client->getResponse()->getStatusCode());

        \$translator = static::getContainer()->get('translator');

        // Check for total item count in pagination
        \$this->assertStringContainsString(
            \$translator->trans('mautic.core.pagination.items', ['%count%' => self::TOTAL_COUNT]),
            \$content
        );

        // Check for total page count in pagination
        \$this->assertStringContainsString(
            \$translator->trans('mautic.core.pagination.pages', ['%count%' => \$pageCount]),
            \$content
        );
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/ApiBundle/Tests/Functional/Controller/ClientControllerTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/ApiBundle/Tests/Functional/Controller/ClientControllerTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/ApiBundle/Tests/Functional/Controller/ClientControllerTest.php");
    }
}
