<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/LeadBundle/Tests/Controller/AuditLogControllerTest.php */
class __TwigTemplate_cd266eb669058b89b6ef70273a94917c extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\LeadBundle\\Tests\\Controller;

use Doctrine\\ORM\\Exception\\ORMException;
use Doctrine\\ORM\\OptimisticLockException;
use Mautic\\CoreBundle\\Test\\MauticMysqlTestCase;
use Mautic\\CoreBundle\\Tests\\Functional\\CreateTestEntitiesTrait;

final class AuditLogControllerTest extends MauticMysqlTestCase
{
    use CreateTestEntitiesTrait;
    private const SALES_USER = 'sales';

    /**
     * @throws OptimisticLockException
     * @throws ORMException
     */
    public function testBatchExportActionAsAdmin(): void
    {
        \$contact = \$this->createLead('TestFirstName');
        \$this->em->persist(\$contact);
        \$this->em->flush();

        \$this->client->request('GET', '/s/contacts/auditlog/batchExport/'.\$contact->getId());
        \$this->assertResponseIsSuccessful();

        \$response = \$this->client->getResponse();
        \$this->assertEquals(200, \$response->getStatusCode());
    }

    public function testBatchExportActionAsUserNotPermission(): void
    {
        \$contact = \$this->createLead('TestFirstName');
        \$this->em->persist(\$contact);
        \$this->em->flush();

        \$this->loginUser(self::SALES_USER);
        \$this->client->setServerParameter('PHP_AUTH_USER', self::SALES_USER);
        \$this->client->request('GET', '/s/contacts/auditlog/batchExport/'.\$contact->getId());

        \$response = \$this->client->getResponse();
        \$this->assertEquals(403, \$response->getStatusCode());
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/LeadBundle/Tests/Controller/AuditLogControllerTest.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/LeadBundle/Tests/Controller/AuditLogControllerTest.php", "/var/www/mautic-upgrade/docroot/app/bundles/LeadBundle/Tests/Controller/AuditLogControllerTest.php");
    }
}
