/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * @module image/imagetextalternative/imagetextalternativeediting
 */
import { Plugin } from 'ckeditor5/src/core.js';
import ImageTextAlternativeCommand from './imagetextalternativecommand.js';
import ImageUtils from '../imageutils.js';
/**
 * The image text alternative editing plugin.
 *
 * Registers the `'imageTextAlternative'` command.
 */
export default class ImageTextAlternativeEditing extends Plugin {
    /**
     * @inheritDoc
     */
    static get requires() {
        return [ImageUtils];
    }
    /**
     * @inheritDoc
     */
    static get pluginName() {
        return 'ImageTextAlternativeEditing';
    }
    /**
     * @inheritDoc
     */
    init() {
        this.editor.commands.add('imageTextAlternative', new ImageTextAlternativeCommand(this.editor));
    }
}
