"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveRelativeFileDependencies = void 0;
const path_1 = require("./path");
function transformVersionString(version, appRootPath) {
    if (version.startsWith("file:") && version[5] !== "/") {
        return "file:" + path_1.resolve(appRootPath, version.slice(5));
    }
    else {
        return version;
    }
}
function resolveRelativeFileDependencies(appRootPath, resolutions) {
    const result = {};
    for (const packageName of Object.keys(resolutions)) {
        result[packageName] = transformVersionString(resolutions[packageName], appRootPath);
    }
    return result;
}
exports.resolveRelativeFileDependencies = resolveRelativeFileDependencies;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzb2x2ZVJlbGF0aXZlRmlsZURlcGVuZGVuY2llcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9yZXNvbHZlUmVsYXRpdmVGaWxlRGVwZW5kZW5jaWVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGlDQUFnQztBQUVoQyxTQUFTLHNCQUFzQixDQUFDLE9BQWUsRUFBRSxXQUFtQjtJQUNsRSxJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLElBQUksT0FBTyxDQUFDLENBQUMsQ0FBQyxLQUFLLEdBQUcsRUFBRTtRQUNyRCxPQUFPLE9BQU8sR0FBRyxjQUFPLENBQUMsV0FBVyxFQUFFLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQTtLQUN4RDtTQUFNO1FBQ0wsT0FBTyxPQUFPLENBQUE7S0FDZjtBQUNILENBQUM7QUFFRCxTQUFnQiwrQkFBK0IsQ0FDN0MsV0FBbUIsRUFDbkIsV0FBOEM7SUFFOUMsTUFBTSxNQUFNLEdBQUcsRUFBdUMsQ0FBQTtJQUN0RCxLQUFLLE1BQU0sV0FBVyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLEVBQUU7UUFDbEQsTUFBTSxDQUFDLFdBQVcsQ0FBQyxHQUFHLHNCQUFzQixDQUMxQyxXQUFXLENBQUMsV0FBVyxDQUFDLEVBQ3hCLFdBQVcsQ0FDWixDQUFBO0tBQ0Y7SUFDRCxPQUFPLE1BQU0sQ0FBQTtBQUNmLENBQUM7QUFaRCwwRUFZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHJlc29sdmUgfSBmcm9tIFwiLi9wYXRoXCJcblxuZnVuY3Rpb24gdHJhbnNmb3JtVmVyc2lvblN0cmluZyh2ZXJzaW9uOiBzdHJpbmcsIGFwcFJvb3RQYXRoOiBzdHJpbmcpIHtcbiAgaWYgKHZlcnNpb24uc3RhcnRzV2l0aChcImZpbGU6XCIpICYmIHZlcnNpb25bNV0gIT09IFwiL1wiKSB7XG4gICAgcmV0dXJuIFwiZmlsZTpcIiArIHJlc29sdmUoYXBwUm9vdFBhdGgsIHZlcnNpb24uc2xpY2UoNSkpXG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuIHZlcnNpb25cbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gcmVzb2x2ZVJlbGF0aXZlRmlsZURlcGVuZGVuY2llcyhcbiAgYXBwUm9vdFBhdGg6IHN0cmluZyxcbiAgcmVzb2x1dGlvbnM6IHsgW3BhY2thZ2VOYW1lOiBzdHJpbmddOiBzdHJpbmcgfSxcbikge1xuICBjb25zdCByZXN1bHQgPSB7fSBhcyB7IFtwYWNrYWdlTmFtZTogc3RyaW5nXTogc3RyaW5nIH1cbiAgZm9yIChjb25zdCBwYWNrYWdlTmFtZSBvZiBPYmplY3Qua2V5cyhyZXNvbHV0aW9ucykpIHtcbiAgICByZXN1bHRbcGFja2FnZU5hbWVdID0gdHJhbnNmb3JtVmVyc2lvblN0cmluZyhcbiAgICAgIHJlc29sdXRpb25zW3BhY2thZ2VOYW1lXSxcbiAgICAgIGFwcFJvb3RQYXRoLFxuICAgIClcbiAgfVxuICByZXR1cm4gcmVzdWx0XG59XG4iXX0=