<?php

use MauticPlugin\JotaworksDoiBundle\EventListener\FormSubscriber;

return [
    'name' => 'Jotaworks Doi',
    'description' => 'Plugin which provides form doi actions',
    'version' => '1.0',
    'author' => 'Jotaworks',
    'routes' => [
        'public' => [
            'jotaworks_doiauth_index' => [
                'path' => '/doi/{enc}',
                'controller' => 'mautic.jotaworksdoi.controller.doi:indexAction',
            ],
            'jotaworks_doiauth_nothuman' => [
                'path' => '/nothuman/{hash}',
                'controller' => 'mautic.jotaworksdoi.controller.doi:nothumanAction',
            ]
        ]
    ],
    'services' => [
        'events' => [
            'myplugin.form.subscriber' => [
                'class' => FormSubscriber::class,
                'arguments' => [
                    'router',
                    'event_dispatcher',
                    'mautic.helper.encryption',
                    'mautic.email.model.email',
                    'mautic.lead.model.lead',
                    'mautic.tracker.contact',
                ],
            ],
            'jw.doi.webhook.subscriber' => [
                'class' => MauticPlugin\JotaworksDoiBundle\EventListener\WebhookSubscriber::class,
                'arguments' => [
                    'mautic.webhook.model.webhook',
                ],
                'tags' => [
                    'kernel.event_subscriber',
                ],
            ]
        ],
        'forms' => [
            'jotaworks.form.type.email_send' => [
                'class'     => MauticPlugin\JotaworksDoiBundle\Form\Type\EmailSendType::class,
                'arguments' => [
                    'mautic.factory',
                    'translator',
                ],
            ],
        ],
        'controllers' => [
            'mautic.jotaworksdoi.controller.doi' => [
                'class' => \MauticPlugin\JotaworksDoiBundle\Controller\DoiController::class,
                'arguments' => [
                    'service_container',
                    'form.factory',
                    'mautic.helper.form.field_helper',
                    'doctrine',
                    'mautic.factory',
                    'mautic.model.factory',
                    'mautic.helper.user',
                    'mautic.helper.core_parameters',
                    'event_dispatcher',
                    'translator',
                    'mautic.core.service.flashbag',
                    'request_stack',
                    'mautic.security',
                ],
            ],
        ],
        'helpers' => [
            'jw.doi.actionhelper' => [
                'class' => MauticPlugin\JotaworksDoiBundle\Helper\DoiActionHelper::class,
                'arguments' => [
                    'messenger.bus.default',
                    'mautic.helper.ip_lookup',
                    'mautic.page.model.page',
                    'mautic.email.model.email',
                    'mautic.core.model.auditlog',
                    'mautic.lead.model.lead',
                    'request_stack',
                    'event_dispatcher'
                ],
            ],
            'jw.doi.not_human_click_helper' => [
                'class' => MauticPlugin\JotaworksDoiBundle\Helper\NotHumanClickHelper::class,
                'arguments' => [
                    'mautic.helper.paths',
                ],
            ],
        ],
    ],
];
