<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/NotificationBundle/Entity/NotificationRepository.php */
class __TwigTemplate_093c28e285975a07acd91c9a0f8f1b8e extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\NotificationBundle\\Entity;

use Doctrine\\ORM\\Query;
use Doctrine\\ORM\\Tools\\Pagination\\Paginator;
use Mautic\\CoreBundle\\Entity\\CommonRepository;

/**
 * @extends CommonRepository<Notification>
 */
class NotificationRepository extends CommonRepository
{
    /**
     * Get a list of entities.
     *
     * @return Paginator
     */
    public function getEntities(array \$args = [])
    {
        \$q = \$this->_em
            ->createQueryBuilder()
            ->select('e')
            ->from(Notification::class, 'e', 'e.id');
        if (empty(\$args['iterator_mode']) && empty(\$args['iterable_mode'])) {
            \$q->leftJoin('e.category', 'c');
        }

        \$args['qb'] = \$q;

        return parent::getEntities(\$args);
    }

    /**
     * Get amounts of sent and read notifications.
     *
     * @return array
     */
    public function getSentReadCount()
    {
        \$q = \$this->_em->createQueryBuilder();
        \$q->select('SUM(e.sentCount) as sent_count, SUM(e.readCount) as read_count')
            ->from(Notification::class, 'e');
        \$results = \$q->getQuery()->getSingleResult(Query::HYDRATE_ARRAY);

        if (!isset(\$results['sent_count'])) {
            \$results['sent_count'] = 0;
        }
        if (!isset(\$results['read_count'])) {
            \$results['read_count'] = 0;
        }

        return \$results;
    }

    /**
     * @param \\Doctrine\\ORM\\QueryBuilder|\\Doctrine\\DBAL\\Query\\QueryBuilder \$q
     */
    protected function addSearchCommandWhereClause(\$q, \$filter): array
    {
        [\$expr, \$parameters] = \$this->addStandardSearchCommandWhereClause(\$q, \$filter);
        if (\$expr) {
            return [\$expr, \$parameters];
        }

        \$command         = \$filter->command;
        \$unique          = \$this->generateRandomParameterName();
        \$returnParameter = false; // returning a parameter that is not used will lead to a Doctrine error

        switch (\$command) {
            case \$this->translator->trans('mautic.core.searchcommand.lang'):
            case \$this->translator->trans('mautic.core.searchcommand.lang', [], null, 'en_US'):
                \$langUnique      = \$this->generateRandomParameterName();
                \$langValue       = \$filter->string.'_%';
                \$forceParameters = [
                    \$langUnique => \$langValue,
                    \$unique     => \$filter->string,
                ];
                \$expr = \$q->expr()->orX(
                    \$q->expr()->eq('e.language', \":\$unique\"),
                    \$q->expr()->like('e.language', \":\$langUnique\")
                );
                \$returnParameter = true;
                break;
        }

        if (\$expr && \$filter->not) {
            \$expr = \$q->expr()->not(\$expr);
        }

        if (!empty(\$forceParameters)) {
            \$parameters = \$forceParameters;
        } elseif (\$returnParameter) {
            \$string     = (\$filter->strict) ? \$filter->string : \"%{\$filter->string}%\";
            \$parameters = [\"\$unique\" => \$string];
        }

        return [\$expr, \$parameters];
    }

    /**
     * @return string[]
     */
    public function getSearchCommands(): array
    {
        \$commands = [
            'mautic.core.searchcommand.ispublished',
            'mautic.core.searchcommand.isunpublished',
            'mautic.core.searchcommand.isuncategorized',
            'mautic.core.searchcommand.ismine',
            'mautic.core.searchcommand.category',
            'mautic.core.searchcommand.lang',
        ];

        return array_merge(\$commands, parent::getSearchCommands());
    }

    /**
     * @return array<array<string>>
     */
    protected function getDefaultOrder(): array
    {
        return [
            ['e.name', 'ASC'],
        ];
    }

    public function getTableAlias(): string
    {
        return 'e';
    }

    /**
     * Up the click/sent counts.
     *
     * @param string \$type
     * @param int    \$increaseBy
     */
    public function upCount(\$id, \$type = 'sent', \$increaseBy = 1): void
    {
        try {
            \$q = \$this->_em->getConnection()->createQueryBuilder();

            \$q->update(MAUTIC_TABLE_PREFIX.'push_notifications')
                ->set(\$type.'_count', \$type.'_count + '.(int) \$increaseBy)
                ->where('id = '.(int) \$id);

            \$q->executeStatement();
        } catch (\\Exception) {
            // not important
        }
    }

    /**
     * @param string \$search
     * @param int    \$limit
     * @param int    \$start
     * @param bool   \$viewOther
     * @param string \$notificationType
     *
     * @return array
     */
    public function getNotificationList(\$search = '', \$limit = 10, \$start = 0, \$viewOther = false, \$notificationType = null)
    {
        \$q = \$this->createQueryBuilder('e');
        \$q->select('partial e.{id, name, language}');

        if (!empty(\$search)) {
            if (is_array(\$search)) {
                \$search = array_map('intval', \$search);
                \$q->andWhere(\$q->expr()->in('e.id', ':search'))
                    ->setParameter('search', \$search);
            } else {
                \$q->andWhere(\$q->expr()->like('e.name', ':search'))
                    ->setParameter('search', \"%{\$search}%\");
            }
        }

        if (!\$viewOther) {
            \$q->andWhere(\$q->expr()->eq('e.createdBy', ':id'))
                ->setParameter('id', \$this->currentUser->getId());
        }

        if (!empty(\$notificationType)) {
            \$q->andWhere(
                \$q->expr()->eq('e.notificationType', \$q->expr()->literal(\$notificationType))
            );
        }

        \$q->andWhere('e.mobile != 1');

        \$q->orderBy('e.name');

        if (!empty(\$limit)) {
            \$q->setFirstResult(\$start)
                ->setMaxResults(\$limit);
        }

        return \$q->getQuery()->getArrayResult();
    }

    /**
     * @param string \$search
     * @param int    \$limit
     * @param int    \$start
     * @param bool   \$viewOther
     * @param string \$notificationType
     *
     * @return array
     */
    public function getMobileNotificationList(\$search = '', \$limit = 10, \$start = 0, \$viewOther = false, \$notificationType = null)
    {
        \$q = \$this->createQueryBuilder('e');
        \$q->select('partial e.{id, name, language}');

        if (!empty(\$search)) {
            if (is_array(\$search)) {
                \$search = array_map('intval', \$search);
                \$q->andWhere(\$q->expr()->in('e.id', ':search'))
                    ->setParameter('search', \$search);
            } else {
                \$q->andWhere(\$q->expr()->like('e.name', ':search'))
                    ->setParameter('search', \"%{\$search}%\");
            }
        }

        if (!\$viewOther) {
            \$q->andWhere(\$q->expr()->eq('e.createdBy', ':id'))
                ->setParameter('id', \$this->currentUser->getId());
        }

        if (!empty(\$notificationType)) {
            \$q->andWhere(
                \$q->expr()->eq('e.notificationType', \$q->expr()->literal(\$notificationType))
            );
        }

        \$q->andWhere('e.mobile = 1');

        \$q->orderBy('e.name');

        if (!empty(\$limit)) {
            \$q->setFirstResult(\$start)
                ->setMaxResults(\$limit);
        }

        return \$q->getQuery()->getArrayResult();
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/NotificationBundle/Entity/NotificationRepository.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/NotificationBundle/Entity/NotificationRepository.php", "/var/www/html/mauticGIT-Test/app/bundles/NotificationBundle/Entity/NotificationRepository.php");
    }
}
