<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Assets/css/app/less/components/type.less */
class __TwigTemplate_18937e5146ce9f81f5453118372452d0 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "//
// Typography
// --------------------------------------------------

// Headings
// -------------------------
h1, h2, h3, h4, h5, h6,
.h1, .h2, .h3, .h4, .h5, .h6 {
  margin-top: 0;
  margin-bottom: 0;
  color: inherit;
}

// Ellipsis
// -------------------------
.ellipsis {
  display: block;
  .text-overflow();
}

::selection {
  background-color: rgb(from var(--background-brand) r g b / 25%);
  color: var(--link-primary);
}

// font size
// -------------------------
.fs-base { font-size: @font-size-base; }
.fs-2 { font-size: 2px !important; }
.fs-4 { font-size: 4px !important; }
.fs-6 { font-size: 6px !important; }
.fs-8 { font-size: 8px !important; }
.fs-10 { font-size: 10px !important; }
.fs-11 { font-size: 11px !important; }
.fs-12 { font-size: 12px !important; }
.fs-14 { font-size: 14px !important; }
.fs-16 { font-size: 16px !important; }
.fs-18 { font-size: 18px !important; }
.fs-20 { font-size: 20px !important; }
.fs-22 { font-size: 22px !important; }
.fs-24 { font-size: 24px !important; }
.fs-26 { font-size: 26px !important; }
.fs-28 { font-size: 28px !important; }
.fs-30 { font-size: 30px !important; }
.fs-32 { font-size: 32px !important; }
.fs-34 { font-size: 34px !important; }
.fs-36 { font-size: 36px !important; }
.fs-38 { font-size: 38px !important; }
.fs-40 { font-size: 40px !important; }
.fs-42 { font-size: 42px !important; }
.fs-44 { font-size: 44px !important; }
.fs-46 { font-size: 46px !important; }
.fs-48 { font-size: 48px !important; }
.fs-50 { font-size: 50px !important; }
.fs-52 { font-size: 52px !important; }
.fs-54 { font-size: 54px !important; }
.fs-56 { font-size: 56px !important; }
.fs-b-e { font-size: var(--typography-body-expressive); }
.fs-b-p { font-size: var(--typography-body-productive); }
.fs-u-e { font-size: var(--typography-utility-expressive); }
.fs-u-p { font-size: var(--typography-utility-productive); }

// Page Header
// -------------------------
.page-header {
  padding: 15px;
  margin: 16px 0 0 0;
  border-bottom: 0;

  // breadcrumb
  .breadcrumb {
    padding: 5px 0;
    background-color: inherit;
    border-radius: 0;
  }
}
// page header inside container reset
.container {
  .page-header {
    margin: -15px -15px 15px -15px;
  }
  &.container-xs {
    .page-header { margin: -5px -5px 5px -5px; }
  }
  &.container-sm {
    .page-header { margin: -10px -10px 10px -10px; }
  }
  &.container-md {
    .page-header { margin: -15px -15px 15px -15px; }
  }
  &.container-lg {
    .page-header { margin: -20px -20px 20px -20px; }
  }
}

// Font weight
// -------------------------
.fw-b { font-weight: 700; }
.fw-sb { font-weight: 600; }
.fw-n { font-weight: 400; }
.fw-t { font-weight: 300; }

.tt-u { text-transform: uppercase; }

.lh-1 { line-height: 1; }

// Contextual colors
// -------------------------
.text-muted, .text-secondary { color: var(--text-secondary); }
.text-placeholder { color: var(--text-placeholder); }
.text-white { .text-emphasis-variants(#fff); }
.text-primary { color: var(--interactive) }
.text-success { .text-emphasis-variants(@brand-success); }
.text-warning { .text-emphasis-variant(@brand-warning); }
.text-danger { .text-emphasis-variant(@brand-danger); }
.text-info { color: var(--support-info); }
.text-twitter { .text-emphasis-variant(@brand-twitter); }
.text-facebook { .text-emphasis-variant(@brand-facebook); }
.text-google { .text-emphasis-variant(@brand-google); }
.text-disabled { color: var(--text-disabled); }
.text-helper { color: var(--text-helper);}

.text-help {
  color: var(--text-helper);
  font-size: var(--typography-utility-productive);
}

// Blockquote
// -------------------------
blockquote {
  padding-left: 40px;
  border-width: 0px;

  > p {
    position: relative;
    font-style: italic;
    font-size: 18px !important;
  }

  > p:before {
    position: absolute;
    top: -1px;
    margin-left: -25px;
    font-family: \"FontAwesome\";
    font-size: 18px;
    content: \"\\f10d\";
    color: @gray-lighter;
  }

  > p:after {
    position: absolute;
    bottom: -1px;
    margin-left: 5px;
    font-family: \"FontAwesome\";
    font-size: 18px;
    content: \"\\f10e\";
    color: @gray-lighter;
  }
}
.blockquote-reverse {
  padding-left: 20px;
  padding-right: 40px;
  border-width: 0px;
}

.help-block {
  font-size: 12px;
  color: var(--text-helper);
}
code {
  padding: var(--spacing-01) var(--spacing-03);
  cursor: pointer;
  overflow: hidden;
  border-radius: clamp(1px, var(--border-radius-sm), 4px);
}

kbd {
  min-width: 20px;
  text-align: center;
  box-shadow: inset 0 -1px 0 #afb8c133;
  border: 1px solid #afb8c133;
  border-radius: 5px;
}

.tooltip-inner { padding: 12px; }
.popover {
  border-radius: 10px;
  padding: 0;
  border: 0;
}
.popover-title {
  padding: 16px 16px 12px;
  border-bottom: 1px solid var(--border-subtle);
  font-weight: 600;
  line-height: 1em;
  font-size: calc(1em + 1px);
  border-radius: 8px 8px 0 0;
  .background-blur()
}

.popover-content {
  padding: 12px 16px 16px;
  border-radius: var(--border-radius-md);
  background-color: var(--layer-02);
}

@media (min-width: 768px) {
  .popover:has([class^=\"col-\"]) {
    max-width: 450px;
    width: 450px;
  }
}";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Assets/css/app/less/components/type.less";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Assets/css/app/less/components/type.less", "/var/www/html/mauticGIT-Test/app/bundles/CoreBundle/Assets/css/app/less/components/type.less");
    }
}
