<?php
declare(strict_types=1);

namespace MauticPlugin\JotaworksDoiBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\PhpFileLoader;

/**
 * Class JotaworksExternalLandingpage.
 */
final class JotaworksDoiBundleExtension extends Extension implements PrependExtensionInterface
{
    public function prepend(ContainerBuilder $container): void
    {
        $container->loadFromExtension('twig', [
            'paths' => [
                '%kernel.project_dir%/plugins/JotaworksDoiBundle/Views' => 'JotaworksDoi',
            ],
        ]);
    }

    /**
     * @param  mixed[]  $configs
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new PhpFileLoader($container, new FileLocator(__DIR__.'/../Config'));
        $loader->load('services.php');
    }
}
