<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/DashboardBundle/Assets/js/dashboard.js */
class __TwigTemplate_146ddd93f365127c12d20b44d209e58b extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "// DashboardBundle
// Use absolute path to keep dashboard working when app is in subdir
Mautic.widgetUrl = mauticBasePath + '/s/dashboard/widget/';

/**
 * @type jQuery DOM element to be replaced with spinner
 */
Mautic.dashboardSubmitButton = false; // Button text, to be get and shown instead of spinner

/**
 * Init dashboard events
 * @param container
 */
Mautic.dashboardOnLoad = function (container) {
    Mautic.loadWidgets();
};

/**
 * Load all widgets on initial page render
 */
Mautic.loadWidgets = function () {
    Mautic.dashboardFilterPreventSubmit();

    jQuery('.widget').each(function() {
        let widgetId = jQuery(this).attr('data-widget-id');
        let container = jQuery('.widget[data-widget-id=\"'+widgetId+'\"]');
        jQuery.ajax({
            url: Mautic.widgetUrl+widgetId+'?ignoreAjax=true',
        }).done(function(response) {
            Mautic.widgetOnLoad(container, response);
        });
    });

    jQuery(document).ajaxComplete(function(){
        Mautic.initDashboardFilter();
    });
};

/**
 * Init dashboard filter events after widget load
 */
Mautic.initDashboardFilter = function () {
    let form = jQuery('form[name=\"daterange\"]');
    form.find('button')
        .replaceWith(Mautic.dashboardSubmitButton);
    form
        .unbind('submit')
        .on('submit', function(e){
            e.preventDefault();
            Mautic.dashboardFilterPreventSubmit();
            jQuery('.widget').each(function() {
                let widgetId = jQuery(this).attr('data-widget-id');
                let element = jQuery('.widget[data-widget-id=\"' + widgetId + '\"]');
                jQuery.ajax({
                    type: 'POST',
                    url: Mautic.widgetUrl + widgetId + '?ignoreAjax=true',
                    data: form.serializeArray(),
                    success: function (response) {
                        Mautic.widgetOnLoad(element, response);
                    }
                });
            });
        });
};

/**
 * Prevent filter from submit, show spinner instead of send button
 */
Mautic.dashboardFilterPreventSubmit = function() {
    let form = jQuery('form[name=\"daterange\"]');
    let button = form.find('button:first');
    Mautic.dashboardSubmitButton = button.clone();
    button.width(button.width()+'px'); // Keep button width
    button.html('<i class=\"ri-loader-3-line ri-spin\"></i>');
    jQuery('.widget').find('.card-body').html('<div class=\"spinner\"><i class=\"ri-loader-3-line ri-spin\"></i></div>');
    form
        .unbind('submit')
        .on('submit', function(e){
            e.preventDefault();
        });
};

Mautic.dashboardOnUnload = function(id) {
    // Trash initialized dashboard vars on app content change.
    mQuery('.jvectormap-tip').remove();
};

/**
 * Render widget from XHR to DOM
 *
 * @param container
 * @param response
 */
Mautic.widgetOnLoad = function(container, response) {
    if (!response.widgetId) return;
    // target in DOM
    var widget = mQuery('.widget[data-widget-id=\"' + response.widgetId + '\"]');
    // source from response
    var widgetHtml = mQuery(response.widgetHtml);

    // initialize edit button modal again
    widgetHtml.find(\"*[data-toggle='ajaxmodal']\").on('click.ajaxmodal', function (event) {
        event.preventDefault();
        Mautic.ajaxifyModal(this, event);
    });

    // Create the new widget wrapper and add it to the 0 position if doesn't exist (probably a new one)
    if (!widget.length) {
        widget = mQuery('<div/>')
            .addClass('widget')
            .attr('data-widget-id', response.widgetId);
        mQuery('#dashboard-widgets').prepend(widget);
    }

    widget.html(widgetHtml)
        .css('width', response.widgetWidth + '%')
        .css('height', response.widgetHeight + '%');
    Mautic.renderCharts(widgetHtml);

    const map = widgetHtml.find('.vector-map').first();
    if (map.length && !map.hasClass('map-rendered')) {
        Mautic.initMap(widgetHtml, 'regions');
    }

    Mautic.initWidgetRemoveEvents();
    Mautic.initWidgetSorting();
    Mautic.initDashboardFilter();
};

Mautic.initWidgetRemoveEvents = function () {
    jQuery('.remove-widget')
        .unbind('click')
        .on('click', function(e) {
            e.preventDefault();
            element = jQuery(this);
            let url = element.attr('href');
            element.closest('.widget').remove();
            jQuery.ajax({
                url: url,
            });
        });
};

Mautic.initWidgetSorting = function () {
    var widgetsWrapper = mQuery('#dashboard-widgets');
    var bodyOverflow = {};

    widgetsWrapper.sortable({
        handle: '.card-header h4',
        placeholder: 'sortable-placeholder',
        items: '.widget',
        opacity: 0.9,
        scroll: true,
        scrollSpeed: 10,
        tolerance: \"pointer\",
        cursor: 'move',
        appendTo: '#dashboard-widgets',

        helper: function(e, ui) {
            // Ensure the draggable retains it's original size and that the margin doesn't cause things to bounce around
            ui.children().each(function() {
                mQuery(this).width(mQuery(this).width());
                mQuery(this).height(mQuery(this).height());
            });

            // Fix body overflow that messes sortable up
            bodyOverflow.overflowX = mQuery('body').css('overflow-x');
            bodyOverflow.overflowY = mQuery('body').css('overflow-y');
            mQuery('body').css({
                overflowX: 'visible',
                overflowY: 'visible'
            });

            mQuery(\"#dashboard-widgets .widget\").each(function(i) {
                var item = mQuery(this);
                var item_clone = item.clone();

                var canvas = item.find('canvas').first();
                if (canvas.length) {
                    // Copy the canvas
                    var destCanvas = item_clone.find('canvas').first();
                    var destCtx = destCanvas[0].getContext('2d');
                    destCtx.drawImage(canvas[0], 0, 0);
                }

                item.data(\"clone\", item_clone);
                var position = item.position();
                item_clone
                    .css({
                        left: position.left,
                        top: position.top,
                        width: item.width(),
                        visibility: \"visible\",
                        position: \"absolute\",
                        zIndex: 1
                    });

                item.css('visibility', 'hidden');
                mQuery(\"#cloned-widgets\").append(item_clone);
            });

            return ui;
        },
        start: function(e, ui) {
            ui.helper.css('visibility', 'visible');
            ui.helper.data(\"clone\").hide();
        },
        sort: function(e, ui) {
            var tile = ui.item.find('.tile').first();
            // Prevent margin from pushing the elements out of the way
            ui.placeholder.css({
                marginTop: \"5px\",
                marginBottom: \"5px\",
                marginLeft: 0,
                marginRight: 0
            });
        },
        stop: function() {
            // Restore original overflow
            mQuery('body').css(bodyOverflow);

            mQuery(\"#dashboard-widgets .widget.exclude-me\").each(function() {
                var item = mQuery(this);
                var clone = item.data(\"clone\");
                var position = item.position();

                clone.css(\"left\", position.left);
                clone.css(\"top\", position.top);
                clone.show();
                item.removeClass(\"exclude-me\");
            });

            mQuery(\"#dashboard-widgets .widget\").css(\"visibility\", \"visible\");
            mQuery(\"#cloned-widgets .widget\").remove();

            Mautic.saveWidgetSorting();
        },
        change: function(e, ui) {
            mQuery(\"#dashboard-widgets .widget:not(.exclude-me)\").each(function() {
                var item = mQuery(this);
                var clone = item.data(\"clone\");
                clone.stop(true, false);
                var position = item.position();
                clone.animate({
                    left: position.left,
                    top: position.top
                }, 200);
            });
        }
    }).disableSelection();
}

Mautic.saveWidgetSorting = function () {
    var widgetsWrapper = mQuery('#dashboard-widgets');
    var widgets = widgetsWrapper.children();
    var ordering = [];
    widgets.each(function(index, value) {
        ordering.push(mQuery(this).attr('data-widget-id'));
    });

    Mautic.ajaxActionRequest('dashboard:updateWidgetOrdering', {'ordering': ordering}, function(response) {
        // @todo handle errors
    });
}

Mautic.updateWidgetForm = function (element) {
    Mautic.activateLabelLoadingIndicator('widget_type');
    var formWrapper = mQuery(element).closest('form');
    var WidgetFormValues = formWrapper.serializeArray();
    Mautic.ajaxActionRequest('dashboard:updateWidgetForm', WidgetFormValues, function(response) {
        if (response.formHtml) {
            var formHtml = mQuery(response.formHtml);
            formHtml.find('#widget_buttons').addClass('hide hidden');
            formWrapper.html(formHtml.children());
            Mautic.onPageLoad('#widget_params');
        }
        Mautic.removeLabelLoadingIndicator();
    });
};

Mautic.exportDashboardLayout = function(text, baseUrl) {
    var name = prompt(text, \"\");

    if (name !== null) {
        if (name) {
            baseUrl = baseUrl + \"?name=\" + encodeURIComponent(name);
        }

        window.location = baseUrl;
    }
};

Mautic.saveDashboardLayout = function(text) {
    var name = prompt(text, \"\");

    if (name) {
        mQuery.ajax({
            type: 'POST',
            url: mauticBaseUrl+'s/dashboard/save',
            data: {name: name}
        });
    }
};

Mautic.setDateRange = function(option) {
    var today = new Date();
    var fromDate, toDate;

    switch(option) {
      case 'today':
        fromDate = today;
        toDate = today;
        break;
      case 'yesterday':
        fromDate = new Date(today.getTime() - (24 * 60 * 60 * 1000));
        toDate = fromDate;
        break;
      default:
        if (typeof option === 'number') {
          fromDate = new Date(today.getTime() - (option * 24 * 60 * 60 * 1000));
          toDate = today;
        } else {
          console.error('Invalid option');
          return;
        }
    }

    document.getElementById('daterange_date_from').value = Mautic.formatDate(fromDate);
    document.getElementById('daterange_date_to').value = Mautic.formatDate(toDate);
    document.getElementById('daterange_apply').click();
};

Mautic.formatDate = function(date) {
    var monthNames = [\"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",
      \"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\"
    ];

    return monthNames[date.getMonth()] + \" \" + date.getDate() + \", \" + date.getFullYear();
};
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/DashboardBundle/Assets/js/dashboard.js";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/DashboardBundle/Assets/js/dashboard.js", "/var/www/html/mauticGIT-Test/app/bundles/DashboardBundle/Assets/js/dashboard.js");
    }
}
