<?php
namespace MauticPlugin\JotaworksDoiBundle\Messenger;

use MauticPlugin\JotaworksDoiBundle\Helper\DoiActionHelper;
use Psr\Log\LoggerInterface;
use Symfony\Component\Messenger\Handler\MessageHandlerInterface;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Messenger\Stamp\DelayStamp;
use Symfony\Component\Messenger\Exception\UnrecoverableMessageHandlingException;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;

final class DoiSuccessfulHandler implements MessageHandlerInterface
{
    private int $secondsToWait = 60;

    public function __construct(
        private LoggerInterface $logger,
        private DoiActionHelper $doiActionHelper,
        private $notHumanClickHelper,
        protected EventDispatcherInterface $dispatcher
    ) {}

    public function __invoke(DoiSuccessfulMessage $message): void
    {
        $config = $message->getConfig();
        $hash   = $message->getHash();
        $ts     = $message->getDoiActivationTime();

        // (1) Defer until "activation time + wait"
//        $now = time();
//        $readyAt = $ts + $this->secondsToWait;
//        if ($now < $readyAt) {
//            $delayMs = max(0, ($readyAt - $now) * 1000);
//            // Re-dispatch the same message with a delay, and ACK this one
//            $this->bus->dispatch($message, [new DelayStamp($delayMs)]);
//            $this->logger->info('[DOI] Deferred until ready', ['delay_ms' => $delayMs]);
//            return;
//        }

        // (2) Cancel condition (your “click bait” race check)
        if ($hash && $this->notHumanClickHelper->isRunning($hash)) {
            $this->notHumanClickHelper->reset($hash);
            $this->logger->info('[DOI] Cancelled by notHumanClick marker', ['hash' => $hash]);
            return; // ACK by returning
        }

        // (3) Do the work
        try {
            // You previously passed a Request—avoid that. If needed, inject what you need into $config earlier.
            $this->doiActionHelper->applyDoiActions($config);
            $this->logger->info('[DOI] Actions applied', ['hash' => $hash]);
        } catch (\Throwable $e) {
            // Decide: retryable or not?
            // For permanent failures:
            $this->logger->error('[DOI] Unrecoverable error', ['ex' => $e]);
            throw new UnrecoverableMessageHandlingException($e->getMessage(), 0, $e);

            // For transient failures (network/db blips), alternatively:
            // throw new RecoverableMessageHandlingException($e->getMessage(), 0, $e);
        }
    }
}
