<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Assets/css/app/less/components/forms.less */
class __TwigTemplate_41d7dd611388c71f78bad7ab58ff6cd3 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "//
// Forms
// --------------------------------------------------

// Normalize non-controls
//
// Restyle and baseline non-control form elements.

label {
  font-weight: normal;
  font-size: var(--utility-01);
}

.label-tag {
  white-space: normal;
  text-align: left;
}

// control label
// -------------------------
.control-label {
  color: var(--text-secondary);
  white-space: nowrap;

  &.text-left {
    text-align: left;
  }
}

// form control
// -------------------------
input[style] {
  background-color: var(--field) !important;
  &:hover {background-color: var(--field-hover) !important;}
}

.btn-datepicker + input {
  &,
  &:hover {
    background-color: transparent;
    border-color: transparent;
    padding-left: 6px;
    color: var(--text-secondary);
    cursor: default;
    font-size: 92%;
  }
}

.form-control, .chosen-container .chosen-single, .form-control.search.tt-input {
  background-color: var(--field);
  border-width: var(--border-bottom);
  border-color: var(--border-strong);
  transition: var(--transition-all-productive);
  border-radius: var(--border-radius-sm);
  .outline();
  .box-shadow(none);

  // Rounded
  // -------------------------
  &.form-control-rounded {
    border-radius: @input-height-base;
  }

  &:hover {background-color: var(--field-hover);}

  &:focus {
    box-shadow: none;
  }
}

.form-control {
  &:not(select) {
    padding: var(--spacing-04) var(--spacing-05);
  }
  color: var(--text-primary);

  +.help-text,
  +p {
    margin-top: 5px;
    font-size: var(--utility-01);
  }

  &.not-chosen {
    padding: var(--spacing-01) var(--spacing-04);
  }
}

.form-control[disabled], .form-control[readonly], fieldset[disabled] .form-control {
  color: var(--text-disabled);
}

.form-control[disabled] {
  cursor: not-allowed;
  border-bottom-color: transparent;
}

// stacked form
.form-stack {
  .form-control {
    position: relative;
    border-radius: 0;

    // focus state
    &:focus {
      z-index: 1;
    }

    +.form-control {
      margin-top: -1px;
    }

    // reset radius
    &:first-child {
      border-radius: @border-radius-base @border-radius-base 0 0;
    }

    &:last-child {
      border-radius: 0 0 @border-radius-base @border-radius-base;
    }

    // input-lg reset radius
    &.input-lg {
      &:first-child {
        border-radius: @border-radius-large @border-radius-large 0 0;
      }

      &:last-child {
        border-radius: 0 0 @border-radius-large @border-radius-large;
      }
    }

    // input-sm reset radius
    &.input-sm {
      &:first-child {
        border-radius: @border-radius-small @border-radius-small 0 0;
      }

      &:last-child {
        border-radius: 0 0 @border-radius-small @border-radius-small;
      }
    }
  }

  .form-control-icon {
    &:first-child {
      >.form-control {
        border-radius: @border-radius-base @border-radius-base 0 0;

        // input-lg reset radius
        &.input-lg {
          border-radius: @border-radius-large @border-radius-large 0 0;
        }

        // input-sm reset radius
        &.input-sm {
          border-radius: @border-radius-small @border-radius-small 0 0;
        }
      }
    }

    &:last-child {
      >.form-control {
        border-radius: 0 0 @border-radius-base @border-radius-base;

        // input-lg reset radius
        &.input-lg {
          border-radius: 0 0 @border-radius-large @border-radius-large;
        }

        // input-lg reset radius
        &.input-sm {
          border-radius: 0 0 @border-radius-small @border-radius-small;
        }
      }
    }

    +.form-control-icon {
      margin-top: -1px;
    }
  }
}

// Form with icon
// -------------------------
.form-control-icon {
  position: relative;

  .form-control {
    padding-left: @input-height-base;

    &.input-lg {
      padding-left: @input-height-large;

      +.the-icon {
        font-size: @font-size-large;
        line-height: @input-height-large;
        width: @input-height-large;
      }
    }

    &.input-sm {
      padding-left: @input-height-small;

      +.the-icon {
        font-size: @font-size-small;
        line-height: @input-height-small;
        width: @input-height-small;
      }
    }
  }

  .the-icon {
    position: absolute;
    z-index: 2;
    top: 50%;
    transform: translate(-50%, -50%);
    left: @input-height-base;
    line-height: @input-height-base - 1;
    width: @input-height-base;
    text-align: center;
  }

  &.form-control-icon-right {
    .the-icon {
      right: 0;
      left: auto;
    }

    .form-control {
      padding-left: @padding-base-horizontal;
      padding-right: @input-height-base;

      &.input-lg {
        padding-left: @padding-large-horizontal;
        padding-right: @input-height-large;
      }

      &.input-sm {
        padding-left: @padding-small-horizontal;
        padding-right: @input-height-small;
      }
    }
  }
}

input[type=file].form-control {
  padding: 6px;
}

input[type=file] {.outline();}

// Custom file input
// -------------------------
.btn-file {
  position: relative;
  overflow: hidden;
}

.btn-file input[type=file] {
  position: absolute;
  top: 0px;
  right: 0px;
  min-width: 100%;
  min-height: 100%;
  font-size: 999px;
  text-align: right;
  opacity: 0;
  background: red;
  cursor: inherit;
  display: block;
}

// Custom radio & checkbox
// -------------------------
.checkbox,
.radio,
.checkbox-inline,
.radio-inline {
  label {
    font-weight: normal;
  }

  &[class*=\" custom\"],
  &[class^=\"custom\"] {
    position: relative;

    label {
      padding-left: 24px;

      input {
        position: absolute;
        opacity: 0;

        +span {
          display: inline-block;
          vertical-align: top;
          position: relative;
          width: 16px;
          height: 16px;
          margin-left: -25px;
          margin-right: 4px;
          margin-top: 1px;
          background-color: transparent;
          border-radius: @border-radius-base;
          border: 1px solid var(--text-primary);

          &:after {
            content: \"\";
            display: block;
            position: absolute;
            top: 2px;
            left: 2px;
            background-color: @gray-dark;
            height: 10px;
            width: 10px;
            border-radius: @border-radius-base - 1;
            .scale(0);
            .transition(all .1s ease);
          }
        }

        // disabled state
        &:disabled {
          +span {
            opacity: 0.4;

            &:hover {
              cursor: not-allowed;
            }
          }
        }

        // checked state
        &:checked {
          +span {
            border: 1px solid var(--text-primary);

            &:after {
              .scale(1);
              .transition(all .1s ease);
            }
          }
        }
      }

      // hover state
      &:hover {
        input {
          +span {
            border: 1px solid var(--text-primary);
          }

          &:checked {
            +span {
              border: 1px solid @gray-dark;
            }
          }
        }
      }
    }
  }

  // checkbox & radio color
  &.custom-primary {
    .checkbox-radio-color(@brand-primary);
  }

  &.custom-info {
    .checkbox-radio-color(@brand-info);
  }

  &.custom-success {
    .checkbox-radio-color(@brand-success);
  }

  &.custom-warning {
    .checkbox-radio-color(@brand-warning);
  }

  &.custom-danger {
    .checkbox-radio-color(@brand-danger);
  }
}

.radio-group {
  .radio-option {
    margin-bottom: var(--spacing-02);
  }
  label {align-self: stretch;}

  input[type=\"radio\"] {
    height: 18px;
    width: 18px;
    flex-shrink: 0;
    vertical-align: top;
    margin-right: 4px;
    appearance: none;
    -webkit-appearance: none;
    background-color: transparent;
    margin: 0;
    border-radius: 50%;
    border: 1px solid var(--icon-primary, #161616);
    outline-offset: -1px;
    margin-right: 4px;
    .transition(var(--transition-all-productive));
    .outline-noff();

    &:checked {
      &:before {
        position: relative;
        display: inline-block;
        border-radius: 50%;
        background-color: var(--icon-primary, #161616);
        block-size: 100%;
        content: \"\";
        inline-size: 100%;
        -webkit-transform: scale(.5);
        transform: scale(.5);
      }
    }
  }

  input[type=\"radio\"]:hover {
    cursor: pointer;
    opacity: 0.7;
  }
}

.radio-cards {
  svg,
  img {
    width: 100%;
    border-radius: 4px;
  }
}

// radio radius reset
.radio-inline,
.radio {

  &[class*=\" custom\"],
  &[class^=\"custom\"] {
    label {
      input {

        +span,
        +span:after {
          border-radius: 50%;
        }
      }
    }
  }
}

// label reset
.checkbox-inline,
.radio-inline {

  &[class*=\" custom\"],
  &[class^=\"custom\"] {
    label {
      padding-left: 4px;
    }
  }
}

input[type=\"checkbox\"] {
  --mtc-checkbox-size: 14px;
  aspect-ratio: 1 / 1;
  height: var(--mtc-checkbox-size);
  vertical-align: -3px;
  background-color: transparent;
  appearance: none;
  border: 1px solid var(--interactive);
  border-radius: 4px;
  margin: 0;
  align-items: center;
  display: flex;
  justify-content: center;
  .transition(var(--transition-all-productive));
  .outline-noff();

  &:after {
    content: \"\";
    height: calc(var(--mtc-checkbox-size) - 6px);
    aspect-ratio: 1/1;
    border-radius: 3px;
    -webkit-transform: scale(.5);
    -ms-transform: scale(.5);
    -o-transform: scale(.5);
    transform: scale(.5);
    .transition(var(--transition-all-productive));
  }

  &:checked {
    &:after {
      background-color: var(--interactive);
      -webkit-transform: scale(1);
      -ms-transform: scale(1);
      -o-transform: scale(1);
      transform: scale(1);
      .transition(var(--transition-all-productive));
    }
  }
}

// time input (3 select boxes hh:mm:ss)
.time-input {
  select {
    margin: 0 3px 0 3px;
  }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Assets/css/app/less/components/forms.less";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Assets/css/app/less/components/forms.less", "/var/www/html/mauticGIT-Test/app/bundles/CoreBundle/Assets/css/app/less/components/forms.less");
    }
}
