<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @themes/causebuzz-grapejs-suite/html/page.html.twig */
class __TwigTemplate_0fd24e9057cc7de210ddf6abe76aab1d extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<!DOCTYPE html>
<html lang=\"";
        // line 2
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("language", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["language"]) || array_key_exists("language", $context) ? $context["language"] : (function () { throw new RuntimeError('Variable "language" does not exist.', 2, $this->source); })()), "de")) : ("de")), "html", null, true);
        yield "\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">
    <title>";
        // line 7
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageTitle", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageTitle"]) || array_key_exists("pageTitle", $context) ? $context["pageTitle"] : (function () { throw new RuntimeError('Variable "pageTitle" does not exist.', 7, $this->source); })()), "Cause.Buzz Landing Page")) : ("Cause.Buzz Landing Page")), "html", null, true);
        yield "</title>
    
    <!-- SEO Meta Tags -->
    <meta name=\"description\" content=\"";
        // line 10
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageDescription", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageDescription"]) || array_key_exists("pageDescription", $context) ? $context["pageDescription"] : (function () { throw new RuntimeError('Variable "pageDescription" does not exist.', 10, $this->source); })()), "Professionelle Marketing-Plattform für Newsletter-Tools, Marketing Automation und Meinungs-Kampagnen")) : ("Professionelle Marketing-Plattform für Newsletter-Tools, Marketing Automation und Meinungs-Kampagnen")), "html", null, true);
        yield "\">
    <meta name=\"keywords\" content=\"";
        // line 11
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageKeywords", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageKeywords"]) || array_key_exists("pageKeywords", $context) ? $context["pageKeywords"] : (function () { throw new RuntimeError('Variable "pageKeywords" does not exist.', 11, $this->source); })()), "Newsletter, Marketing Automation, Meinungs-Kampagnen, DSGVO, EU-Server")) : ("Newsletter, Marketing Automation, Meinungs-Kampagnen, DSGVO, EU-Server")), "html", null, true);
        yield "\">
    <meta name=\"author\" content=\"Cause.Buzz Team\">
    
    <!-- Open Graph -->
    <meta property=\"og:title\" content=\"";
        // line 15
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageTitle", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageTitle"]) || array_key_exists("pageTitle", $context) ? $context["pageTitle"] : (function () { throw new RuntimeError('Variable "pageTitle" does not exist.', 15, $this->source); })()), "Cause.Buzz Landing Page")) : ("Cause.Buzz Landing Page")), "html", null, true);
        yield "\">
    <meta property=\"og:description\" content=\"";
        // line 16
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageDescription", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageDescription"]) || array_key_exists("pageDescription", $context) ? $context["pageDescription"] : (function () { throw new RuntimeError('Variable "pageDescription" does not exist.', 16, $this->source); })()), "Marketing-Power vereint")) : ("Marketing-Power vereint")), "html", null, true);
        yield "\">
    <meta property=\"og:type\" content=\"website\">
    <meta property=\"og:url\" content=\"";
        // line 18
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageUrl", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageUrl"]) || array_key_exists("pageUrl", $context) ? $context["pageUrl"] : (function () { throw new RuntimeError('Variable "pageUrl" does not exist.', 18, $this->source); })()), "https://cause.buzz")) : ("https://cause.buzz")), "html", null, true);
        yield "\">
    <meta property=\"og:image\" content=\"";
        // line 19
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageImage", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageImage"]) || array_key_exists("pageImage", $context) ? $context["pageImage"] : (function () { throw new RuntimeError('Variable "pageImage" does not exist.', 19, $this->source); })()), "https://demo.cause.buzz/assets/causebuzz-og-image.png")) : ("https://demo.cause.buzz/assets/causebuzz-og-image.png")), "html", null, true);
        yield "\">
    
    <!-- Twitter Card -->
    <meta name=\"twitter:card\" content=\"summary_large_image\">
    <meta name=\"twitter:title\" content=\"";
        // line 23
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageTitle", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageTitle"]) || array_key_exists("pageTitle", $context) ? $context["pageTitle"] : (function () { throw new RuntimeError('Variable "pageTitle" does not exist.', 23, $this->source); })()), "Cause.Buzz Landing Page")) : ("Cause.Buzz Landing Page")), "html", null, true);
        yield "\">
    <meta name=\"twitter:description\" content=\"";
        // line 24
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageDescription", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageDescription"]) || array_key_exists("pageDescription", $context) ? $context["pageDescription"] : (function () { throw new RuntimeError('Variable "pageDescription" does not exist.', 24, $this->source); })()), "Marketing-Power vereint")) : ("Marketing-Power vereint")), "html", null, true);
        yield "\">
    <meta name=\"twitter:image\" content=\"";
        // line 25
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("pageImage", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["pageImage"]) || array_key_exists("pageImage", $context) ? $context["pageImage"] : (function () { throw new RuntimeError('Variable "pageImage" does not exist.', 25, $this->source); })()), "https://demo.cause.buzz/assets/causebuzz-og-image.png")) : ("https://demo.cause.buzz/assets/causebuzz-og-image.png")), "html", null, true);
        yield "\">
    
    <!-- Mobile Optimization -->
    <meta name=\"format-detection\" content=\"telephone=no\">
    <meta name=\"format-detection\" content=\"date=no\">
    <meta name=\"format-detection\" content=\"address=no\">
    <meta name=\"format-detection\" content=\"email=no\">
    
    <!-- Favicon -->
    <link rel=\"icon\" href=\"/favicon.ico\">
    <link rel=\"icon\" href=\"/icon-192x192.png\" sizes=\"192x192\" type=\"image/png\">
    <link rel=\"apple-touch-icon\" href=\"/apple-touch-icon.png\">
    
    <style>
        /* ========================================
           CAUSE.BUZZ LANDING PAGE STYLES
           ======================================== */
        
        /* Reset und Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #ffffff;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
            margin: 0;
            padding: 0;
            overflow-x: hidden;
        }
        
        /* Container System */
        .page-wrapper {
            min-height: 100vh;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
        }
        
        .page-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        /* ========================================
           LAYOUT COMPONENTS
           ======================================== */
        
        /* Header */
        .page-header {
            background: linear-gradient(135deg, #334155 0%, #475569 100%);
            padding: 20px 0;
            border-bottom: 2px solid #2563eb;
            position: sticky;
            top: 0;
            z-index: 100;
            backdrop-filter: blur(10px);
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            max-width: 180px;
            height: auto;
        }
        
        .header-badges {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        /* Navigation */
        .page-nav {
            display: flex;
            gap: 30px;
            align-items: center;
        }
        
        .nav-link {
            color: #cbd5e1;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
        }
        
        .nav-link:hover {
            color: #60a5fa;
        }
        
        /* Hero Section */
        .hero-section {
            padding: 80px 0;
            text-align: center;
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            position: relative;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: radial-gradient(circle at 25% 25%, rgba(59, 130, 246, 0.1) 0%, transparent 50%),
                            radial-gradient(circle at 75% 75%, rgba(37, 99, 235, 0.1) 0%, transparent 50%);
            pointer-events: none;
        }
        
        .hero-content {
            position: relative;
            z-index: 1;
        }
        
        /* Content Sections */
        .content-section {
            padding: 60px 0;
        }
        
        .section-alt {
            background: #0f172a;
        }
        
        .section-highlight {
            background: rgba(37, 99, 235, 0.1);
            border-top: 1px solid rgba(37, 99, 235, 0.2);
            border-bottom: 1px solid rgba(37, 99, 235, 0.2);
        }
        
        /* Typography */
        .page-headline {
            font-size: 48px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 20px;
            line-height: 1.2;
        }
        
        .page-subheading {
            font-size: 32px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 20px;
            line-height: 1.3;
        }
        
        .page-subtitle {
            font-size: 24px;
            color: #60a5fa;
            font-weight: 500;
            margin-bottom: 20px;
        }
        
        .page-text {
            font-size: 18px;
            color: #cbd5e1;
            line-height: 1.6;
            margin-bottom: 20px;
        }
        
        .page-text-large {
            font-size: 20px;
            color: #e2e8f0;
            line-height: 1.6;
            margin-bottom: 30px;
        }
        
        /* Buttons */
        .btn {
            display: inline-block;
            padding: 18px 36px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            font-size: 18px;
            border: none;
            transition: all 0.3s ease;
            margin: 10px;
            text-align: center;
            cursor: pointer;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: #ffffff !important;
            box-shadow: 0 8px 25px rgba(37, 99, 235, 0.4);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 35px rgba(37, 99, 235, 0.5);
        }
        
        .btn-secondary {
            background: transparent;
            color: #60a5fa !important;
            border: 2px solid #3b82f6;
        }
        
        .btn-secondary:hover {
            background: rgba(59, 130, 246, 0.1);
            border-color: #60a5fa;
        }
        
        .btn-large {
            padding: 20px 40px;
            font-size: 20px;
        }
        
        /* Grid Layouts */
        .grid-2 {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
        }
        
        .grid-3 {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
        }
        
        .grid-4 {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
        }
        
        /* Feature Boxes */
        .feature-box {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border: 1px solid #475569;
            border-radius: 12px;
            padding: 30px;
            text-align: center;
            transition: transform 0.3s ease;
        }
        
        .feature-box:hover {
            transform: translateY(-5px);
        }
        
        .feature-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 50%;
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 32px;
            color: #ffffff;
        }
        
        /* Stats Box */
        .stats-box {
            background: rgba(37, 99, 235, 0.1);
            border: 1px solid rgba(37, 99, 235, 0.2);
            border-radius: 12px;
            padding: 40px;
            text-align: center;
        }
        
        .stat-number {
            font-size: 48px;
            font-weight: 700;
            color: #60a5fa;
            display: block;
            margin-bottom: 10px;
        }
        
        .stat-label {
            font-size: 16px;
            color: #94a3b8;
        }
        
        /* Badges */
        .badge {
            display: inline-block;
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            color: #ffffff;
            padding: 8px 16px;
            border-radius: 8px;
            font-size: 12px;
            font-weight: 500;
            margin: 0 6px 8px;
        }
        
        .badge-primary {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
        }
        
        .badge-accent {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        }
        
        /* Form Styles */
        .form-container {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border-radius: 12px;
            padding: 40px;
            border: 1px solid #475569;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            color: #ffffff;
            font-weight: 500;
            margin-bottom: 8px;
        }
        
        .form-input {
            width: 100%;
            padding: 12px 16px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            color: #ffffff;
            font-size: 16px;
        }
        
        .form-input::placeholder {
            color: #94a3b8;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }
        
        /* Footer */
        .page-footer {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
            padding: 60px 0 40px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            text-align: center;
        }
        
        .footer-links {
            display: flex;
            justify-content: center;
            gap: 30px;
            margin: 30px 0;
            flex-wrap: wrap;
        }
        
        .footer-link {
            color: #60a5fa;
            text-decoration: none;
            font-size: 14px;
        }
        
        .footer-link:hover {
            color: #93c5fd;
        }
        
        .footer-text {
            color: #64748b;
            font-size: 14px;
            margin-bottom: 10px;
        }
        
        /* Utility Classes */
        .text-center { text-align: center; }
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        
        .mt-0 { margin-top: 0; }
        .mt-20 { margin-top: 20px; }
        .mt-40 { margin-top: 40px; }
        .mb-0 { margin-bottom: 0; }
        .mb-20 { margin-bottom: 20px; }
        .mb-40 { margin-bottom: 40px; }
        
        .p-0 { padding: 0; }
        .p-20 { padding: 20px; }
        .p-40 { padding: 40px; }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .page-container {
                padding: 0 15px;
            }
            
            .page-headline {
                font-size: 36px;
            }
            
            .page-subheading {
                font-size: 28px;
            }
            
            .page-subtitle {
                font-size: 20px;
            }
            
            .hero-section {
                padding: 60px 0;
            }
            
            .content-section {
                padding: 40px 0;
            }
            
            .grid-2,
            .grid-3,
            .grid-4 {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .header-content {
                flex-direction: column;
                gap: 20px;
            }
            
            .page-nav {
                justify-content: center;
                flex-wrap: wrap;
                gap: 20px;
            }
            
            .btn {
                display: block;
                width: 100%;
                margin: 10px 0;
            }
            
            .footer-links {
                flex-direction: column;
                gap: 15px;
            }
        }
        
        /* Accessibility */
        @media (prefers-reduced-motion: reduce) {
            * {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }
        
        :focus-visible {
            outline: 2px solid #3b82f6;
            outline-offset: 2px;
        }
        
        /* Print Styles */
        @media print {
            .page-wrapper {
                background: #ffffff !important;
                color: #000000 !important;
            }
            
            .page-header,
            .page-footer {
                background: #ffffff !important;
                color: #000000 !important;
            }
            
            .btn {
                display: none !important;
            }
        }
    </style>
    
    <!-- Mautic Tracking -->
    {mauticheader}
</head>
<body>
    <div class=\"page-wrapper\">
        
        <!-- Header -->
        <header class=\"page-header\">
            <div class=\"page-container\">
                <div class=\"header-content\">
                    <div>
                        <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz Logo\" class=\"logo\" />
                    </div>
                    <nav class=\"page-nav\">
                        <a href=\"https://cause.buzz\" class=\"nav-link\">Home</a>
                        <a href=\"https://cause.buzz/preise\" class=\"nav-link\">Preise</a>
                        <a href=\"mailto:hello@cause.buzz\" class=\"nav-link\">Kontakt</a>
                    </nav>
                    <div class=\"header-badges\">
                        <span class=\"badge\">🚀 Marketing-Plattform</span>
                        <span class=\"badge badge-primary\">🇪🇺 EU-Server</span>
                        <span class=\"badge\">🔒 DSGVO-konform</span>
                    </div>
                </div>
            </div>
        </header>
        
        <!-- Hero Section -->
        <section class=\"hero-section\">
            <div class=\"page-container\">
                <div class=\"hero-content\">
                    ";
        // line 537
        if ((isset($context["pageTitle"]) || array_key_exists("pageTitle", $context) ? $context["pageTitle"] : (function () { throw new RuntimeError('Variable "pageTitle" does not exist.', 537, $this->source); })())) {
            // line 538
            yield "                    <h1 class=\"page-headline\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["pageTitle"]) || array_key_exists("pageTitle", $context) ? $context["pageTitle"] : (function () { throw new RuntimeError('Variable "pageTitle" does not exist.', 538, $this->source); })()), "html", null, true);
            yield "</h1>
                    ";
        } else {
            // line 540
            yield "                    <h1 class=\"page-headline\">Marketing-Power vereint</h1>
                    ";
        }
        // line 542
        yield "                    
                    ";
        // line 543
        if ((isset($context["pageSubtitle"]) || array_key_exists("pageSubtitle", $context) ? $context["pageSubtitle"] : (function () { throw new RuntimeError('Variable "pageSubtitle" does not exist.', 543, $this->source); })())) {
            // line 544
            yield "                    <p class=\"page-subtitle\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["pageSubtitle"]) || array_key_exists("pageSubtitle", $context) ? $context["pageSubtitle"] : (function () { throw new RuntimeError('Variable "pageSubtitle" does not exist.', 544, $this->source); })()), "html", null, true);
            yield "</p>
                    ";
        } else {
            // line 546
            yield "                    <p class=\"page-subtitle\">Newsletter-Tools, Marketing Automation & Meinungs-Kampagnen</p>
                    ";
        }
        // line 548
        yield "                    
                    ";
        // line 549
        if ((isset($context["pageDescription"]) || array_key_exists("pageDescription", $context) ? $context["pageDescription"] : (function () { throw new RuntimeError('Variable "pageDescription" does not exist.', 549, $this->source); })())) {
            // line 550
            yield "                    <p class=\"page-text-large\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["pageDescription"]) || array_key_exists("pageDescription", $context) ? $context["pageDescription"] : (function () { throw new RuntimeError('Variable "pageDescription" does not exist.', 550, $this->source); })()), "html", null, true);
            yield "</p>
                    ";
        } else {
            // line 552
            yield "                    <p class=\"page-text-large\">
                        Cause.Buzz vereint die Funktionalitäten von Newsletter-Tools, Marketing Automation Software 
                        und Dienstleistungen für erfolgreiche Meinungs-Kampagnen und Zielgruppenansprachen.
                    </p>
                    ";
        }
        // line 557
        yield "                    
                    <div style=\"margin-top: 40px;\">
                        <a href=\"";
        // line 559
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("primaryCTAUrl", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["primaryCTAUrl"]) || array_key_exists("primaryCTAUrl", $context) ? $context["primaryCTAUrl"] : (function () { throw new RuntimeError('Variable "primaryCTAUrl" does not exist.', 559, $this->source); })()), "https://demo.cause.buzz")) : ("https://demo.cause.buzz")), "html", null, true);
        yield "\" class=\"btn btn-primary btn-large\">
                            ";
        // line 560
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("primaryCTAText", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["primaryCTAText"]) || array_key_exists("primaryCTAText", $context) ? $context["primaryCTAText"] : (function () { throw new RuntimeError('Variable "primaryCTAText" does not exist.', 560, $this->source); })()), "✨ Kostenlose Demo anfordern")) : ("✨ Kostenlose Demo anfordern")), "html", null, true);
        yield "
                        </a>
                        ";
        // line 562
        if ((isset($context["secondaryCTAUrl"]) || array_key_exists("secondaryCTAUrl", $context) ? $context["secondaryCTAUrl"] : (function () { throw new RuntimeError('Variable "secondaryCTAUrl" does not exist.', 562, $this->source); })())) {
            // line 563
            yield "                        <a href=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["secondaryCTAUrl"]) || array_key_exists("secondaryCTAUrl", $context) ? $context["secondaryCTAUrl"] : (function () { throw new RuntimeError('Variable "secondaryCTAUrl" does not exist.', 563, $this->source); })()), "html", null, true);
            yield "\" class=\"btn btn-secondary btn-large\">
                            ";
            // line 564
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("secondaryCTAText", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["secondaryCTAText"]) || array_key_exists("secondaryCTAText", $context) ? $context["secondaryCTAText"] : (function () { throw new RuntimeError('Variable "secondaryCTAText" does not exist.', 564, $this->source); })()), "Mehr erfahren")) : ("Mehr erfahren")), "html", null, true);
            yield "
                        </a>
                        ";
        }
        // line 567
        yield "                    </div>
                </div>
            </div>
        </section>
        
        <!-- Main Content -->
        <section class=\"content-section\">
            <div class=\"page-container\">
                ";
        // line 575
        if ((isset($context["content"]) || array_key_exists("content", $context) ? $context["content"] : (function () { throw new RuntimeError('Variable "content" does not exist.', 575, $this->source); })())) {
            // line 576
            yield "                    ";
            yield (isset($context["content"]) || array_key_exists("content", $context) ? $context["content"] : (function () { throw new RuntimeError('Variable "content" does not exist.', 576, $this->source); })());
            yield "
                ";
        } else {
            // line 578
            yield "                    <!-- Default Content -->
                    <div class=\"text-center\">
                        <h2 class=\"page-subheading\">🎯 Ihre Vorteile mit Cause.Buzz</h2>
                        <p class=\"page-text mb-40\">Entdecken Sie die Möglichkeiten unserer ganzheitlichen Marketing-Plattform</p>
                    </div>
                    
                    <div class=\"grid-3\">
                        <div class=\"feature-box\">
                            <div class=\"feature-icon\">📊</div>
                            <h3 style=\"color: #ffffff; font-size: 20px; margin-bottom: 15px; font-weight: 600;\">Newsletter-Tools</h3>
                            <p style=\"color: #94a3b8; font-size: 16px; line-height: 1.5; margin: 0;\">Professionelle E-Mail-Kampagnen mit maximaler Zustellbarkeit</p>
                        </div>
                        <div class=\"feature-box\">
                            <div class=\"feature-icon\">⚡</div>
                            <h3 style=\"color: #ffffff; font-size: 20px; margin-bottom: 15px; font-weight: 600;\">Marketing Automation</h3>
                            <p style=\"color: #94a3b8; font-size: 16px; line-height: 1.5; margin: 0;\">Automatisierte Workflows für effizientes Marketing</p>
                        </div>
                        <div class=\"feature-box\">
                            <div class=\"feature-icon\">🎯</div>
                            <h3 style=\"color: #ffffff; font-size: 20px; margin-bottom: 15px; font-weight: 600;\">Meinungs-Kampagnen</h3>
                            <p style=\"color: #94a3b8; font-size: 16px; line-height: 1.5; margin: 0;\">Gezielte Kampagnen für Meinungsbildung und Aktivierung</p>
                        </div>
                    </div>
                ";
        }
        // line 602
        yield "            </div>
        </section>
        
        <!-- Stats Section -->
        ";
        // line 606
        if ((isset($context["showStats"]) || array_key_exists("showStats", $context) ? $context["showStats"] : (function () { throw new RuntimeError('Variable "showStats" does not exist.', 606, $this->source); })())) {
            // line 607
            yield "        <section class=\"content-section section-highlight\">
            <div class=\"page-container\">
                <div class=\"stats-box\">
                    <h3 style=\"color: #ffffff; font-size: 32px; font-weight: 600; margin-bottom: 40px;\">🚀 Vertrauen Sie auf Erfahrung</h3>
                    <div class=\"grid-3\">
                        <div>
                            <span class=\"stat-number\">15+</span>
                            <div class=\"stat-label\">Jahre Erfahrung</div>
                        </div>
                        <div>
                            <span class=\"stat-number\">500+</span>
                            <div class=\"stat-label\">Erfolgreiche Projekte</div>
                        </div>
                        <div>
                            <span class=\"stat-number\">99.9%</span>
                            <div class=\"stat-label\">Verfügbarkeit</div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        ";
        }
        // line 629
        yield "        
        <!-- Contact Form Section -->
        ";
        // line 631
        if ((isset($context["includeForm"]) || array_key_exists("includeForm", $context) ? $context["includeForm"] : (function () { throw new RuntimeError('Variable "includeForm" does not exist.', 631, $this->source); })())) {
            // line 632
            yield "        <section class=\"content-section section-alt\">
            <div class=\"page-container\">
                <div class=\"text-center mb-40\">
                    <h2 class=\"page-subheading\">📬 Jetzt Kontakt aufnehmen</h2>
                    <p class=\"page-text\">Vereinbaren Sie Ihre kostenlose Demo oder stellen Sie uns Ihre Fragen</p>
                </div>
                
                <div style=\"max-width: 600px; margin: 0 auto;\">
                    <div class=\"form-container\">
                        <!-- Mautic Form Integration -->
                        ";
            // line 642
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("mauticForm", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["mauticForm"]) || array_key_exists("mauticForm", $context) ? $context["mauticForm"] : (function () { throw new RuntimeError('Variable "mauticForm" does not exist.', 642, $this->source); })()), "{mauticform=1}")) : ("{mauticform=1}")), "html", null, true);
            yield "
                    </div>
                </div>
            </div>
        </section>
        ";
        }
        // line 648
        yield "        
        <!-- Custom Content Section -->
        ";
        // line 650
        if ((isset($context["customContent"]) || array_key_exists("customContent", $context) ? $context["customContent"] : (function () { throw new RuntimeError('Variable "customContent" does not exist.', 650, $this->source); })())) {
            // line 651
            yield "        <section class=\"content-section ";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("customContentClass", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["customContentClass"]) || array_key_exists("customContentClass", $context) ? $context["customContentClass"] : (function () { throw new RuntimeError('Variable "customContentClass" does not exist.', 651, $this->source); })()), "")) : ("")), "html", null, true);
            yield "\">
            <div class=\"page-container\">
                ";
            // line 653
            yield (isset($context["customContent"]) || array_key_exists("customContent", $context) ? $context["customContent"] : (function () { throw new RuntimeError('Variable "customContent" does not exist.', 653, $this->source); })());
            yield "
            </div>
        </section>
        ";
        }
        // line 657
        yield "        
        <!-- Footer -->
        <footer class=\"page-footer\">
            <div class=\"page-container\">
                <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz\" style=\"max-width: 150px; opacity: 0.8; margin-bottom: 30px;\" />
                <p class=\"footer-text\">
                    <strong>Cause.Buzz</strong> - Die professionelle Marketing-Plattform<br>
                    40 Im alten Riet, 9494 Schaan, Liechtenstein
                </p>
                
                <div class=\"footer-links\">
                    <a href=\"https://cause.buzz/privacy\" class=\"footer-link\">Datenschutz</a>
                    <a href=\"https://cause.buzz/imprint\" class=\"footer-link\">Impressum</a>
                    <a href=\"mailto:hello@cause.buzz\" class=\"footer-link\">Kontakt</a>
                </div>
                
                <p class=\"footer-text\">
                    © 2024 Cause.Buzz. Alle Rechte vorbehalten.
                </p>
            </div>
        </footer>
        
    </div>
    
    <!-- Mautic Tracking -->
    {mauticfooter}
</body>
</html>";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@themes/causebuzz-grapejs-suite/html/page.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  806 => 657,  799 => 653,  793 => 651,  791 => 650,  787 => 648,  778 => 642,  766 => 632,  764 => 631,  760 => 629,  736 => 607,  734 => 606,  728 => 602,  702 => 578,  696 => 576,  694 => 575,  684 => 567,  678 => 564,  673 => 563,  671 => 562,  666 => 560,  662 => 559,  658 => 557,  651 => 552,  645 => 550,  643 => 549,  640 => 548,  636 => 546,  630 => 544,  628 => 543,  625 => 542,  621 => 540,  615 => 538,  613 => 537,  98 => 25,  94 => 24,  90 => 23,  83 => 19,  79 => 18,  74 => 16,  70 => 15,  63 => 11,  59 => 10,  53 => 7,  45 => 2,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@themes/causebuzz-grapejs-suite/html/page.html.twig", "/var/www/html/mauticGIT-Test/themes/causebuzz-grapejs-suite/html/page.html.twig");
    }
}
