<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @themes/causebuzz-grapejs-suite/html/email.mjml.twig */
class __TwigTemplate_170cf9edf84aca1755f561ef9a298eec extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<mjml>
  <mj-head>
    <mj-title>";
        // line 3
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("subject", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["subject"]) || array_key_exists("subject", $context) ? $context["subject"] : (function () { throw new RuntimeError('Variable "subject" does not exist.', 3, $this->source); })()), "Cause.Buzz Newsletter")) : ("Cause.Buzz Newsletter")), "html", null, true);
        yield "</mj-title>
    <mj-preview>";
        // line 4
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("preview", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["preview"]) || array_key_exists("preview", $context) ? $context["preview"] : (function () { throw new RuntimeError('Variable "preview" does not exist.', 4, $this->source); })()), "Marketing-Power vereint - Newsletter-Tools, Marketing Automation & Meinungs-Kampagnen")) : ("Marketing-Power vereint - Newsletter-Tools, Marketing Automation & Meinungs-Kampagnen")), "html", null, true);
        yield "</mj-preview>
    <mj-attributes>
      <mj-all font-family=\"-apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica Neue, Arial, sans-serif\" />
      <mj-text font-size=\"16px\" color=\"#cbd5e1\" line-height=\"1.6\" />
      <mj-section background-color=\"#1e293b\" padding=\"0\" />
    </mj-attributes>
    <mj-style>
      .gradient-bg {
        background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
      }
      .gradient-dark {
        background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
      }
      .gradient-light {
        background: linear-gradient(135deg, #334155 0%, #1e293b 100%);
      }
      .gradient-header {
        background: linear-gradient(135deg, #334155 0%, #475569 100%);
      }
      .gradient-footer {
        background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
      }
      .btn-primary {
        background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%) !important;
        color: #ffffff !important;
        font-weight: 500 !important;
        border-radius: 8px !important;
        text-decoration: none !important;
        padding: 16px 32px !important;
        display: inline-block !important;
      }
      .btn-secondary {
        background: transparent !important;
        color: #60a5fa !important;
        font-weight: 500 !important;
        border: 2px solid #3b82f6 !important;
        border-radius: 8px !important;
        text-decoration: none !important;
        padding: 14px 28px !important;
        display: inline-block !important;
      }
      .badge {
        background: linear-gradient(135deg, #059669 0%, #047857 100%) !important;
        color: #ffffff !important;
        padding: 8px 16px !important;
        border-radius: 8px !important;
        font-size: 12px !important;
        font-weight: 500 !important;
        margin: 0 6px 8px !important;
        display: inline-block !important;
      }
      .badge-blue {
        background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%) !important;
      }
      .feature-box {
        background: rgba(255, 255, 255, 0.05) !important;
        border: 1px solid rgba(255, 255, 255, 0.1) !important;
        border-radius: 12px !important;
        padding: 20px !important;
        text-align: center !important;
      }
      .stats-box {
        background: rgba(37, 99, 235, 0.1) !important;
        border: 1px solid rgba(37, 99, 235, 0.2) !important;
        border-radius: 12px !important;
        padding: 30px !important;
      }
      @media only screen and (max-width: 600px) {
        .mobile-stack { 
          width: 100% !important; 
          display: block !important; 
        }
        .mobile-center { 
          text-align: center !important; 
        }
        .mobile-btn {
          width: 100% !important;
          display: block !important;
          margin: 10px 0 !important;
        }
      }
    </mj-style>
  </mj-head>
  
  <mj-body background-color=\"#0f172a\">
    
    <!-- Header Section -->
    <mj-section css-class=\"gradient-header\" padding=\"40px 30px 30px\" border-bottom=\"2px solid #2563eb\">
      <mj-column>
        <mj-image 
          src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" 
          alt=\"Cause.Buzz Logo\" 
          width=\"180px\" 
          align=\"center\"
          padding-bottom=\"20px\"
        />
        <mj-text align=\"center\" padding=\"0\">
          <span class=\"badge\">🚀 Ganzheitliche Marketing-Plattform</span>
          <span class=\"badge badge-blue\">🇪🇺 EU-Server</span>
          <span class=\"badge\">🔒 DSGVO-konform</span>
        </mj-text>
      </mj-column>
    </mj-section>

    <!-- Hero Section -->
    <mj-section css-class=\"gradient-dark\" padding=\"50px 30px\">
      <mj-column>
        ";
        // line 111
        if ((isset($context["emailTitle"]) || array_key_exists("emailTitle", $context) ? $context["emailTitle"] : (function () { throw new RuntimeError('Variable "emailTitle" does not exist.', 111, $this->source); })())) {
            // line 112
            yield "        <mj-text align=\"center\" font-size=\"32px\" font-weight=\"600\" color=\"#ffffff\" line-height=\"1.2\" padding-bottom=\"20px\">
          ";
            // line 113
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["emailTitle"]) || array_key_exists("emailTitle", $context) ? $context["emailTitle"] : (function () { throw new RuntimeError('Variable "emailTitle" does not exist.', 113, $this->source); })()), "html", null, true);
            yield "
        </mj-text>
        ";
        } else {
            // line 116
            yield "        <mj-text align=\"center\" font-size=\"32px\" font-weight=\"600\" color=\"#ffffff\" line-height=\"1.2\" padding-bottom=\"20px\">
          Marketing-Power vereint
        </mj-text>
        ";
        }
        // line 120
        yield "        
        ";
        // line 121
        if ((isset($context["emailSubtitle"]) || array_key_exists("emailSubtitle", $context) ? $context["emailSubtitle"] : (function () { throw new RuntimeError('Variable "emailSubtitle" does not exist.', 121, $this->source); })())) {
            // line 122
            yield "        <mj-text align=\"center\" font-size=\"20px\" color=\"#60a5fa\" font-weight=\"500\" padding-bottom=\"15px\">
          ";
            // line 123
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["emailSubtitle"]) || array_key_exists("emailSubtitle", $context) ? $context["emailSubtitle"] : (function () { throw new RuntimeError('Variable "emailSubtitle" does not exist.', 123, $this->source); })()), "html", null, true);
            yield "
        </mj-text>
        ";
        } else {
            // line 126
            yield "        <mj-text align=\"center\" font-size=\"20px\" color=\"#60a5fa\" font-weight=\"500\" padding-bottom=\"15px\">
          Newsletter-Tools, Marketing Automation & Meinungs-Kampagnen
        </mj-text>
        ";
        }
        // line 130
        yield "        
        ";
        // line 131
        if ((isset($context["emailDescription"]) || array_key_exists("emailDescription", $context) ? $context["emailDescription"] : (function () { throw new RuntimeError('Variable "emailDescription" does not exist.', 131, $this->source); })())) {
            // line 132
            yield "        <mj-text align=\"center\" color=\"#cbd5e1\" padding-bottom=\"30px\">
          ";
            // line 133
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["emailDescription"]) || array_key_exists("emailDescription", $context) ? $context["emailDescription"] : (function () { throw new RuntimeError('Variable "emailDescription" does not exist.', 133, $this->source); })()), "html", null, true);
            yield "
        </mj-text>
        ";
        } else {
            // line 136
            yield "        <mj-text align=\"center\" color=\"#cbd5e1\" padding-bottom=\"30px\">
          Cause.Buzz vereint die Funktionalitäten von Newsletter-Tools, Marketing Automation Software 
          und Dienstleistungen für erfolgreiche Meinungs-Kampagnen und Zielgruppenansprachen.
        </mj-text>
        ";
        }
        // line 141
        yield "        
        ";
        // line 142
        if ((isset($context["showPrimaryCTA"]) || array_key_exists("showPrimaryCTA", $context) ? $context["showPrimaryCTA"] : (function () { throw new RuntimeError('Variable "showPrimaryCTA" does not exist.', 142, $this->source); })())) {
            // line 143
            yield "        <mj-button 
          href=\"";
            // line 144
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("primaryCTAUrl", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["primaryCTAUrl"]) || array_key_exists("primaryCTAUrl", $context) ? $context["primaryCTAUrl"] : (function () { throw new RuntimeError('Variable "primaryCTAUrl" does not exist.', 144, $this->source); })()), "https://demo.cause.buzz")) : ("https://demo.cause.buzz")), "html", null, true);
            yield "\" 
          css-class=\"btn-primary\"
          align=\"center\"
        >
          ";
            // line 148
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("primaryCTAText", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["primaryCTAText"]) || array_key_exists("primaryCTAText", $context) ? $context["primaryCTAText"] : (function () { throw new RuntimeError('Variable "primaryCTAText" does not exist.', 148, $this->source); })()), "✨ Kostenlose Demo anfordern")) : ("✨ Kostenlose Demo anfordern")), "html", null, true);
            yield "
        </mj-button>
        ";
        }
        // line 151
        yield "      </mj-column>
    </mj-section>

    <!-- Main Content Section -->
    <mj-section css-class=\"gradient-light\" padding=\"40px 30px\">
      <mj-column>
        ";
        // line 157
        if ((isset($context["contentTitle"]) || array_key_exists("contentTitle", $context) ? $context["contentTitle"] : (function () { throw new RuntimeError('Variable "contentTitle" does not exist.', 157, $this->source); })())) {
            // line 158
            yield "        <mj-text align=\"center\" font-size=\"24px\" font-weight=\"600\" color=\"#ffffff\" padding-bottom=\"20px\">
          ";
            // line 159
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["contentTitle"]) || array_key_exists("contentTitle", $context) ? $context["contentTitle"] : (function () { throw new RuntimeError('Variable "contentTitle" does not exist.', 159, $this->source); })()), "html", null, true);
            yield "
        </mj-text>
        ";
        }
        // line 162
        yield "        
        <mj-text color=\"#cbd5e1\">
          ";
        // line 164
        if ((isset($context["content"]) || array_key_exists("content", $context) ? $context["content"] : (function () { throw new RuntimeError('Variable "content" does not exist.', 164, $this->source); })())) {
            // line 165
            yield "            ";
            yield (isset($context["content"]) || array_key_exists("content", $context) ? $context["content"] : (function () { throw new RuntimeError('Variable "content" does not exist.', 165, $this->source); })());
            yield "
          ";
        } else {
            // line 167
            yield "            <p>Hier ist der Hauptinhalt Ihrer E-Mail. Sie können diesen Text über die Mautic-Oberfläche anpassen und eigene Inhalte einfügen.</p>
            
            <p>Nutzen Sie die Kraft von Cause.Buzz für:</p>
            <ul style=\"margin: 20px 0; padding-left: 20px;\">
              <li>Professionelle Newsletter-Kampagnen</li>
              <li>Automatisierte Marketing-Workflows</li>
              <li>Gezielte Meinungs-Kampagnen</li>
              <li>DSGVO-konforme Datenverarbeitung</li>
            </ul>
          ";
        }
        // line 177
        yield "        </mj-text>
      </mj-column>
    </mj-section>

    <!-- Features Section -->
    ";
        // line 182
        if ((isset($context["showFeatures"]) || array_key_exists("showFeatures", $context) ? $context["showFeatures"] : (function () { throw new RuntimeError('Variable "showFeatures" does not exist.', 182, $this->source); })())) {
            // line 183
            yield "    <mj-section css-class=\"gradient-dark\" padding=\"40px 30px\">
      <mj-column>
        <mj-text align=\"center\" font-size=\"24px\" font-weight=\"600\" color=\"#ffffff\" padding-bottom=\"30px\">
          🎯 Ihre Vorteile mit Cause.Buzz
        </mj-text>
      </mj-column>
    </mj-section>
    
    <mj-section css-class=\"gradient-dark\" padding=\"0 30px 40px\">
      <mj-column width=\"50%\" css-class=\"mobile-stack\">
        <mj-text css-class=\"feature-box\" align=\"center\">
          <div style=\"font-size: 32px; margin-bottom: 12px;\">📊</div>
          <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Newsletter-Tools</h3>
          <p style=\"color: #94a3b8; font-size: 14px; line-height: 1.4; margin: 0;\">Professionelle E-Mail-Kampagnen mit maximaler Zustellbarkeit</p>
        </mj-text>
      </mj-column>
      <mj-column width=\"50%\" css-class=\"mobile-stack\">
        <mj-text css-class=\"feature-box\" align=\"center\">
          <div style=\"font-size: 32px; margin-bottom: 12px;\">⚡</div>
          <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Marketing Automation</h3>
          <p style=\"color: #94a3b8; font-size: 14px; line-height: 1.4; margin: 0;\">Automatisierte Workflows für effizientes Marketing</p>
        </mj-text>
      </mj-column>
    </mj-section>
    
    <mj-section css-class=\"gradient-dark\" padding=\"0 30px 40px\">
      <mj-column width=\"50%\" css-class=\"mobile-stack\">
        <mj-text css-class=\"feature-box\" align=\"center\">
          <div style=\"font-size: 32px; margin-bottom: 12px;\">🎯</div>
          <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Meinungs-Kampagnen</h3>
          <p style=\"color: #94a3b8; font-size: 14px; line-height: 1.4; margin: 0;\">Gezielte Kampagnen für Meinungsbildung und Aktivierung</p>
        </mj-text>
      </mj-column>
      <mj-column width=\"50%\" css-class=\"mobile-stack\">
        <mj-text css-class=\"feature-box\" align=\"center\">
          <div style=\"font-size: 32px; margin-bottom: 12px;\">🛡️</div>
          <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">DSGVO-konform</h3>
          <p style=\"color: #94a3b8; font-size: 14px; line-height: 1.4; margin: 0;\">100% DSGVO-konform auf EU-Servern gehostet</p>
        </mj-text>
      </mj-column>
    </mj-section>
    ";
        }
        // line 225
        yield "
    <!-- Statistics Section -->
    ";
        // line 227
        if ((isset($context["showStats"]) || array_key_exists("showStats", $context) ? $context["showStats"] : (function () { throw new RuntimeError('Variable "showStats" does not exist.', 227, $this->source); })())) {
            // line 228
            yield "    <mj-section css-class=\"gradient-light\" padding=\"40px 30px\">
      <mj-column>
        <mj-text css-class=\"stats-box\" align=\"center\">
          <h3 style=\"color: #ffffff; font-size: 24px; font-weight: 600; margin-bottom: 20px;\">🚀 Vertrauen Sie auf Erfahrung</h3>
          <table width=\"100%\" style=\"margin-top: 20px;\">
            <tr>
              <td width=\"33.33%\" align=\"center\" style=\"padding: 10px;\">
                <span style=\"font-size: 28px; font-weight: 700; color: #60a5fa; display: block;\">15+</span>
                <div style=\"color: #94a3b8; font-size: 14px; margin-top: 5px;\">Jahre Erfahrung</div>
              </td>
              <td width=\"33.33%\" align=\"center\" style=\"padding: 10px;\">
                <span style=\"font-size: 28px; font-weight: 700; color: #60a5fa; display: block;\">500+</span>
                <div style=\"color: #94a3b8; font-size: 14px; margin-top: 5px;\">Erfolgreiche Projekte</div>
              </td>
              <td width=\"33.33%\" align=\"center\" style=\"padding: 10px;\">
                <span style=\"font-size: 28px; font-weight: 700; color: #60a5fa; display: block;\">99.9%</span>
                <div style=\"color: #94a3b8; font-size: 14px; margin-top: 5px;\">Verfügbarkeit</div>
              </td>
            </tr>
          </table>
        </mj-text>
      </mj-column>
    </mj-section>
    ";
        }
        // line 252
        yield "
    <!-- Call-to-Action Section -->
    ";
        // line 254
        if ((isset($context["showCTA"]) || array_key_exists("showCTA", $context) ? $context["showCTA"] : (function () { throw new RuntimeError('Variable "showCTA" does not exist.', 254, $this->source); })())) {
            // line 255
            yield "    <mj-section css-class=\"gradient-dark\" padding=\"40px 30px\">
      <mj-column>
        ";
            // line 257
            if ((isset($context["ctaTitle"]) || array_key_exists("ctaTitle", $context) ? $context["ctaTitle"] : (function () { throw new RuntimeError('Variable "ctaTitle" does not exist.', 257, $this->source); })())) {
                // line 258
                yield "        <mj-text align=\"center\" font-size=\"24px\" font-weight=\"600\" color=\"#ffffff\" padding-bottom=\"15px\">
          ";
                // line 259
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["ctaTitle"]) || array_key_exists("ctaTitle", $context) ? $context["ctaTitle"] : (function () { throw new RuntimeError('Variable "ctaTitle" does not exist.', 259, $this->source); })()), "html", null, true);
                yield "
        </mj-text>
        ";
            } else {
                // line 262
                yield "        <mj-text align=\"center\" font-size=\"24px\" font-weight=\"600\" color=\"#ffffff\" padding-bottom=\"15px\">
          Bereit für den nächsten Schritt?
        </mj-text>
        ";
            }
            // line 266
            yield "        
        ";
            // line 267
            if ((isset($context["ctaDescription"]) || array_key_exists("ctaDescription", $context) ? $context["ctaDescription"] : (function () { throw new RuntimeError('Variable "ctaDescription" does not exist.', 267, $this->source); })())) {
                // line 268
                yield "        <mj-text align=\"center\" color=\"#cbd5e1\" padding-bottom=\"30px\">
          ";
                // line 269
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["ctaDescription"]) || array_key_exists("ctaDescription", $context) ? $context["ctaDescription"] : (function () { throw new RuntimeError('Variable "ctaDescription" does not exist.', 269, $this->source); })()), "html", null, true);
                yield "
        </mj-text>
        ";
            } else {
                // line 272
                yield "        <mj-text align=\"center\" color=\"#cbd5e1\" padding-bottom=\"30px\">
          Vereinbaren Sie noch heute Ihre kostenlose Demo und entdecken Sie die Möglichkeiten von Cause.Buzz!
        </mj-text>
        ";
            }
            // line 276
            yield "        
        <mj-button 
          href=\"";
            // line 278
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("primaryCTAUrl", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["primaryCTAUrl"]) || array_key_exists("primaryCTAUrl", $context) ? $context["primaryCTAUrl"] : (function () { throw new RuntimeError('Variable "primaryCTAUrl" does not exist.', 278, $this->source); })()), "https://demo.cause.buzz")) : ("https://demo.cause.buzz")), "html", null, true);
            yield "\" 
          css-class=\"btn-primary mobile-btn\"
          align=\"center\"
        >
          ";
            // line 282
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("primaryCTAText", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["primaryCTAText"]) || array_key_exists("primaryCTAText", $context) ? $context["primaryCTAText"] : (function () { throw new RuntimeError('Variable "primaryCTAText" does not exist.', 282, $this->source); })()), "🎯 Jetzt Demo buchen")) : ("🎯 Jetzt Demo buchen")), "html", null, true);
            yield "
        </mj-button>
        
        ";
            // line 285
            if ((isset($context["showSecondaryCTA"]) || array_key_exists("showSecondaryCTA", $context) ? $context["showSecondaryCTA"] : (function () { throw new RuntimeError('Variable "showSecondaryCTA" does not exist.', 285, $this->source); })())) {
                // line 286
                yield "        <mj-button 
          href=\"";
                // line 287
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("secondaryCTAUrl", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["secondaryCTAUrl"]) || array_key_exists("secondaryCTAUrl", $context) ? $context["secondaryCTAUrl"] : (function () { throw new RuntimeError('Variable "secondaryCTAUrl" does not exist.', 287, $this->source); })()), "https://cause.buzz/preise")) : ("https://cause.buzz/preise")), "html", null, true);
                yield "\" 
          css-class=\"btn-secondary mobile-btn\"
          align=\"center\"
        >
          ";
                // line 291
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("secondaryCTAText", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["secondaryCTAText"]) || array_key_exists("secondaryCTAText", $context) ? $context["secondaryCTAText"] : (function () { throw new RuntimeError('Variable "secondaryCTAText" does not exist.', 291, $this->source); })()), "💰 Preise ansehen")) : ("💰 Preise ansehen")), "html", null, true);
                yield "
        </mj-button>
        ";
            }
            // line 294
            yield "      </mj-column>
    </mj-section>
    ";
        }
        // line 297
        yield "
    <!-- Social Media Section -->
    ";
        // line 299
        if ((isset($context["showSocial"]) || array_key_exists("showSocial", $context) ? $context["showSocial"] : (function () { throw new RuntimeError('Variable "showSocial" does not exist.', 299, $this->source); })())) {
            // line 300
            yield "    <mj-section css-class=\"gradient-light\" padding=\"30px\">
      <mj-column>
        <mj-text align=\"center\" color=\"#94a3b8\" font-size=\"14px\" padding-bottom=\"20px\">
          Folgen Sie uns für Marketing-Tipps und Updates:
        </mj-text>
        <mj-social font-size=\"18px\" icon-size=\"45px\" mode=\"horizontal\" padding=\"0\" align=\"center\">
          <mj-social-element name=\"linkedin\" href=\"";
            // line 306
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("linkedinUrl", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["linkedinUrl"]) || array_key_exists("linkedinUrl", $context) ? $context["linkedinUrl"] : (function () { throw new RuntimeError('Variable "linkedinUrl" does not exist.', 306, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" background-color=\"#3b82f6\">
            💼
          </mj-social-element>
          <mj-social-element name=\"twitter\" href=\"";
            // line 309
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("twitterUrl", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["twitterUrl"]) || array_key_exists("twitterUrl", $context) ? $context["twitterUrl"] : (function () { throw new RuntimeError('Variable "twitterUrl" does not exist.', 309, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" background-color=\"#3b82f6\">
            🐦
          </mj-social-element>
          <mj-social-element name=\"youtube\" href=\"";
            // line 312
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("youtubeUrl", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["youtubeUrl"]) || array_key_exists("youtubeUrl", $context) ? $context["youtubeUrl"] : (function () { throw new RuntimeError('Variable "youtubeUrl" does not exist.', 312, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" background-color=\"#3b82f6\">
            📺
          </mj-social-element>
          <mj-social-element name=\"web\" href=\"";
            // line 315
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("newsletterUrl", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["newsletterUrl"]) || array_key_exists("newsletterUrl", $context) ? $context["newsletterUrl"] : (function () { throw new RuntimeError('Variable "newsletterUrl" does not exist.', 315, $this->source); })()), "#")) : ("#")), "html", null, true);
            yield "\" background-color=\"#3b82f6\">
            📧
          </mj-social-element>
        </mj-social>
      </mj-column>
    </mj-section>
    ";
        }
        // line 322
        yield "
    <!-- Custom Content Section -->
    ";
        // line 324
        if ((isset($context["customContent"]) || array_key_exists("customContent", $context) ? $context["customContent"] : (function () { throw new RuntimeError('Variable "customContent" does not exist.', 324, $this->source); })())) {
            // line 325
            yield "    <mj-section css-class=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((array_key_exists("customContentClass", $context)) ? (Twig\Extension\CoreExtension::default((isset($context["customContentClass"]) || array_key_exists("customContentClass", $context) ? $context["customContentClass"] : (function () { throw new RuntimeError('Variable "customContentClass" does not exist.', 325, $this->source); })()), "gradient-light")) : ("gradient-light")), "html", null, true);
            yield "\" padding=\"40px 30px\">
      <mj-column>
        <mj-text color=\"#cbd5e1\">
          ";
            // line 328
            yield (isset($context["customContent"]) || array_key_exists("customContent", $context) ? $context["customContent"] : (function () { throw new RuntimeError('Variable "customContent" does not exist.', 328, $this->source); })());
            yield "
        </mj-text>
      </mj-column>
    </mj-section>
    ";
        }
        // line 333
        yield "
    <!-- Footer Section -->
    <mj-section css-class=\"gradient-footer\" padding=\"40px 30px 30px\" border-top=\"1px solid rgba(255, 255, 255, 0.1)\">
      <mj-column>
        <mj-image 
          src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" 
          alt=\"Cause.Buzz\" 
          width=\"120px\" 
          align=\"center\"
          padding-bottom=\"20px\"
          css-class=\"opacity: 0.8;\"
        />
        <mj-text align=\"center\" color=\"#64748b\" font-size=\"14px\" line-height=\"1.5\" padding-bottom=\"20px\">
          <strong>Cause.Buzz</strong> - Die professionelle Marketing-Plattform<br>
          40 Im alten Riet, 9494 Schaan, Liechtenstein<br>
          E-Mail: hello@cause.buzz | Web: cause.buzz
        </mj-text>
        
        <mj-text align=\"center\" padding=\"0\">
          <a href=\"https://cause.buzz/privacy\" style=\"color: #60a5fa; text-decoration: none; margin: 0 15px; font-size: 14px;\">Datenschutz</a>
          <a href=\"https://cause.buzz/imprint\" style=\"color: #60a5fa; text-decoration: none; margin: 0 15px; font-size: 14px;\">Impressum</a>
          <a href=\"{unsubscribe_url}\" style=\"color: #60a5fa; text-decoration: none; margin: 0 15px; font-size: 14px;\">Abmelden</a>
        </mj-text>
        
        <mj-divider border-color=\"rgba(255, 255, 255, 0.1)\" border-width=\"1px\" padding=\"25px 0\" />
        
        <mj-text align=\"center\" color=\"#64748b\" font-size=\"14px\">
          © 2024 Cause.Buzz. Alle Rechte vorbehalten.<br>
          <small>Diese E-Mail wurde an {email} gesendet.</small>
        </mj-text>
      </mj-column>
    </mj-section>

  </mj-body>
</mjml>";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@themes/causebuzz-grapejs-suite/html/email.mjml.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  517 => 333,  509 => 328,  502 => 325,  500 => 324,  496 => 322,  486 => 315,  480 => 312,  474 => 309,  468 => 306,  460 => 300,  458 => 299,  454 => 297,  449 => 294,  443 => 291,  436 => 287,  433 => 286,  431 => 285,  425 => 282,  418 => 278,  414 => 276,  408 => 272,  402 => 269,  399 => 268,  397 => 267,  394 => 266,  388 => 262,  382 => 259,  379 => 258,  377 => 257,  373 => 255,  371 => 254,  367 => 252,  341 => 228,  339 => 227,  335 => 225,  291 => 183,  289 => 182,  282 => 177,  270 => 167,  264 => 165,  262 => 164,  258 => 162,  252 => 159,  249 => 158,  247 => 157,  239 => 151,  233 => 148,  226 => 144,  223 => 143,  221 => 142,  218 => 141,  211 => 136,  205 => 133,  202 => 132,  200 => 131,  197 => 130,  191 => 126,  185 => 123,  182 => 122,  180 => 121,  177 => 120,  171 => 116,  165 => 113,  162 => 112,  160 => 111,  50 => 4,  46 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@themes/causebuzz-grapejs-suite/html/email.mjml.twig", "/var/www/html/mauticGIT-Test/themes/causebuzz-grapejs-suite/html/email.mjml.twig");
    }
}
