<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Assets/css/app/less/mixins.less */
class __TwigTemplate_00ba06b00b8f063ea71e4e16a6470eae extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "//
// Mixins
// --------------------------------------------------

// Background color
// ------------------------

.background-blur() {
  backdrop-filter: blur(6px);
  background-color: var(--layer-translucent);
}

.bg-color(@bg-color; @color) {
  background-color: @bg-color !important;
  border-color: @bg-color !important;
  color: @color !important;
}

// Text emphasis
// ------------------------
.text-emphasis-variants(@color) {
  color: @color;
  a&:hover {
    color: darken(@color, 10%);
  }
  &.light-xs {
    color: lighten(@color, 15%);
    a&:hover {
      color: lighten(@color, 10%);
    }
  }
  &.dark-xs {
    color: darken(@color, 15%);
    a&:hover {
      color: darken(@color, 20%);
    }
  }
  &.dark-sm {
    color: darken(@color, 30%);
    a&:hover {
      color: darken(@color, 35%);
    }
  }
  &.dark-md {
    color: darken(@color, 45%);
    a&:hover {
      color: darken(@color, 50%);
    }
  }
  &.dark-lg {
    color: darken(@color, 60%);
    a&:hover {
      color: darken(@color, 65%);
    }
  }
}

// Switch size
// ------------------------
.switch-size(@height) {
  input {
    ~ .text {
      line-height: @height;
    }

    ~ .switch {
      font-size: @height;
      height: @height;
      width: (@height * 1.6);
      border-radius: @height;

      &:after {
        border-radius: @height;
        height: @height;
        width: @height;
      }
    }
  }
}

// Switch color
// ------------------------
.switch-color(@color) {
  input {
    &:checked {
      + .switch {
        border-color: @color;
        box-shadow: inset 0 0 0 0.6em @color;
        &:after { border-color: @color; }
      }
    }
  }
}

// Custom checkbox & radio color
// ------------------------
.checkbox-radio-color(@color) {
  label {
    input {
      + span {
        &:after {
          background-color: @color;
        }
      }
      // checked state
      &:checked {
        + span {
          border: 1px solid @color;
        }
      }
    }
    // hover state
    &:hover {
      input {
        + span {
          border: 1px solid var(--text-primary);
          opacity: .8;
          .transition(var(--transition-all-productive));
        }
        &:checked {
          + span {
            border: 1px solid @color;
          }
        }
      }
    }
  }
}

// sidebar nav variant
// ------------------------
.nav-sidebar-variants(@bgcolor) {
  > li {
    // nav-group line
    &.nav-group {
      &:after {
        content: '';
        position: absolute;
        right: 0;
        left: 50px;
        bottom: 0;
        border-bottom: none;
      }
    }

    > a {
      color: var(--text-secondary);
      &:hover,
      &:focus {
        background-color: var(--layer-hover);
        color: var(--text-primary);
      }
    }

    // Active and open state
    &.active,
    &.open {
      > a {
        background-color: var(--layer-selected);
        color: var(--text-primary);
      }

      // `nav-submenu`
      > .nav-submenu {
        background-color: var(--layer-accent);
      }
    }

    // nav-submenu style
    > .nav-submenu {
      background-color: var(--layer-accent);
      &:after {
        background-color: var(--layer-accent-alt);
      }
      > li {
        // the dot
        &:after {
          background-color: var(--layer);
          box-shadow: none;
        }
        > a {
          color: var(--text-secondary);
          &:hover,
          &:focus {
            color: var(--text-primary);
          }
        }

        // Active and open state
        &.active,
        &.open {
          > a {
            color: var(--text-primary);
          }
        }
      }
    }
  }

  // nav-heading
  .nav-heading {
    color: fade(contrast(@bgcolor), 25%);
  }

  // nav-divider
  .nav-divider {
    background-color: fade(contrast(@bgcolor), 6%);
  }
}

// loading bar variant
// ------------------------
.loading-bar-variant(@bgcolor) {
  background-color: lighten(@bgcolor, 45%);
  &:after,
  &:before {
    background-color: @bgcolor;
  }
}

.outline() {
  outline: 2px var(--outline-style) transparent;
  outline-offset: -2px;
  &:hover { outline: 2px var(--outline-style) transparent; }
  &:focus, &.focus, &:focus-visible { outline: 2px var(--outline-style) var(--focus); }
}

.outline-noff() {
  outline: 2px solid transparent;
  outline-offset: 1px;
  &:hover { outline: 2px solid transparent; }
  &:focus, &.focus {
    outline: 2px solid var(--focus);
    outline-offset: 1px;
  }
}

// Alerts

.alert-variant(@background; @border; @text-color) {
  color: var(--text-primary);
  background-color: var(--layer);
  border-color: @border;

  hr {
    border-top-color: var(--border-subtle);
  }

  .alert-link {
    color: var(--text-primary);
  }
}

.button-variant(@background, @text-color, @border-color, @hover-background, @hover-text-color, @active-background, @disabled-background, @disabled-text-color) {
  background-color: @background;
  color: @text-color;
  border: 1px solid @border-color;
  .outline();

  i { color: @text-color; }

  &:hover {
    color: @hover-text-color;
    background-color: @hover-background;
    border: 1px solid @hover-background;
    i { color: @hover-text-color; }
  }

  &:active,
  &.active,
  .open > .dropdown-toggle& {
    color: @hover-text-color;
    background-color: @active-background;
    border: 1px solid transparent;
    i { color: @hover-text-color; }

    &:hover,
    &:focus,
    &.focus {
      color: @hover-text-color;
      background-color: @active-background;
      border-color: @active-background;
      i { color: @hover-text-color; }
    }
  }

  &:focus,
  &.focus {
    color: @hover-text-color;
    background-color: @active-background;
    border: 1px solid @active-background;
    box-shadow: inset 0 0 0 1px var(--focus), inset 0 0 0 2px var(--background,#ffffff);
    i { color: @hover-text-color; }
  }

  &[disabled],
  &.disabled,
  fieldset[disabled] & {
    &,
    &:hover,
    &:focus,
    &.focus {
      background-color: @disabled-background;
      color: @disabled-text-color;
      border: 1px solid @disabled-background;
      i { color: @disabled-text-color; }
    }
  }
}";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Assets/css/app/less/mixins.less";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Assets/css/app/less/mixins.less", "/var/www/html/mauticGIT-Test/app/bundles/CoreBundle/Assets/css/app/less/mixins.less");
    }
}
