<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Assets/css/app/less/components/navs.less */
class __TwigTemplate_c402c4630c71715d0937bb5bcc63b5a8 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "//
// Navs
// --------------------------------------------------

// Base class
// --------------------------------------------------

.nav {
  > li {
    > a {
      font-weight: normal;
      //color: @text-color;
      // nav anchor `text` and `icon` behavior
      .text,
      .icon,
      .arrow {
        line-height: @line-height-computed;
      }
    }
  }

  .open {
    > a, > a:hover, > a:focus {
      background-color: transparent;
    }
  }

  // nav divider
  .nav-divider {
    background-color: rgba(0,0,0,0.05);
  }

  // nav-heading
  .nav-heading {
    font-size: 12px;
    font-weight: 600;
    padding: @nav-link-padding;
    padding-bottom: 5px;
    color: @gray-light;
  }
}

// Tabs
// -------------------------
.nav-tabs {
  //background-color: @body-bg;
  display: flex;
  flex-wrap: nowrap;
  overflow: hidden;
  position: relative;
  text-wrap: nowrap;
  scroll-behavior: smooth;

  > li {
    > a {
      line-height: 20px;
      color: var(--text-secondary);
      .outline();

      &:hover { color: var(--text-primary); }

      &:after {
          content: '';
          position: absolute;
          top: 0;
          left: 0;
          right: 0;
          height: 2px;
          background-color: transparent;
        }
    }

    // Active state
    &.active > a {
      overflow: hidden;
      border-top-color: transparent;
      font-weight: bold;

      &:after { background-color: @nav-pills-active-link-hover-bg; }
    }
  }

  &.nav-tabs-line {
    > li {
      > a {
        background-color: transparent;
        padding: 6px 16px;
        margin-right: -2px;
        border-radius: 0;

        &:after {
          top: unset;
          bottom: 0;
          background-color: var(--layer-accent);
          transition: var(--transition-all-productive);
        }

        &:hover {
          background-color: transparent;
          color: var(--text-primary);

          &:after { background-color: var(--layer-accent-hover); }
        }
      }

      &.active {
        > a {
          background-color: transparent;

          &:after {
              background-color: var(--border-interactive);
            }
        }
      }
    }
  }

  &.nav-tabs-contained {
    > li {
      > a {
        background-color: var(--layer-accent);
        border-radius: var(--border-radius-sm) var(--border-radius-sm) 0 0;

        &:hover { background-color: var(--layer-accent-hover);}
      }

      &.active { > a { background-color: var(--layer); } }
      &.disabled {
        cursor: not-allowed;
        color: var(--text-disabled);
        > a {
          background-color: var(--button-disabled);
          pointer-events: none;

        }
      }
    }
  }
}

@media (min-width: @screen-lg-min) {
  .nav-tabs {
    flex-wrap: nowrap;
  }
}

// Tabs content
// -------------------------
/*
.tab-content {
  > .tab-pane {
    border: 1px solid @nav-tabs-active-link-hover-border-color;
    border-top-width: 0;
    border-bottom-right-radius: @nav-pills-border-radius;
    border-bottom-left-radius: @nav-pills-border-radius;
  }
}
*/

.stats-menu__content.tab-content {
  display: flex;
  justify-content: center;
  align-items: center;
}

.stats-menu__content.tab-content > .tab-pane {
  width: 100%;
}

//
// Pills
// -------------------------
.nav-pills {
  > li {
    + li {
      margin-left: 5px;
    }
  }
}

.stats-menu {
  display: flex;
  justify-content: space-between;
  flex-wrap: nowrap;

  && .date-range {
    padding: 5px;
    border-top-left-radius: 3px;
  }

  && + div {
    min-height: 410px;
  }
}

/* nav-tabs-wrapper styles */
.nav-tabs-wrapper {
  position: relative;
  overflow: hidden;
  margin-bottom: -1px;
}

.scroll-btn {
  position: absolute;
  top: 50%;
  transform: translateY(-50%);
  border: none;
  background-color: var(--layer-accent);
  cursor: pointer;
  z-index: 10;
  display: none;
  align-items: center;
  justify-content: center;
  font-size: 18px;
  padding: 0;
  inline-size: 40px;
  aspect-ratio: 1 / 1;

  &:before {
    position: absolute;
    z-index: 1;
    background: linear-gradient(to right, rgba(255, 255, 255, 0), var(--background, #ffffff));
    block-size: 100%;
    content: \"\";
    inline-size: .5rem;
    inset-inline-end: -.5rem;
  background-image: linear-gradient(to right,rgba(255,255,255,0),var(--layer-accent));
  }
}

.left-btn {inset-inline-start: 0;}
.left-btn:before {transform: scaleX(-1);}
.right-btn {inset-inline-end: 0;}
.nav-tabs-wrapper.show-scroll-buttons .scroll-btn:disabled {display: none;}
.nav-tabs-wrapper.show-scroll-buttons .scroll-btn {display: flex;}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Assets/css/app/less/components/navs.less";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Assets/css/app/less/components/navs.less", "/var/www/html/mauticGIT-Test/app/bundles/CoreBundle/Assets/css/app/less/components/navs.less");
    }
}
