<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/FormBundle/Form/Type/FormFieldFileType.php */
class __TwigTemplate_fa385c11fd29f2a29deb51dbc2a69106 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\FormBundle\\Form\\Type;

use Mautic\\CoreBundle\\Form\\DataTransformer\\ArrayStringTransformer;
use Mautic\\CoreBundle\\Form\\Type\\YesNoButtonGroupType;
use Mautic\\CoreBundle\\Helper\\CoreParametersHelper;
use Mautic\\CoreBundle\\Helper\\FileHelper;
use Mautic\\FormBundle\\Validator\\Constraint\\FileExtensionConstraint;
use Symfony\\Component\\Form\\AbstractType;
use Symfony\\Component\\Form\\Extension\\Core\\Type\\TextareaType;
use Symfony\\Component\\Form\\Extension\\Core\\Type\\TextType;
use Symfony\\Component\\Form\\FormBuilderInterface;
use Symfony\\Component\\Validator\\Constraints\\LessThanOrEqual;
use Symfony\\Contracts\\Translation\\TranslatorInterface;

/**
 * @extends AbstractType<mixed>
 */
class FormFieldFileType extends AbstractType
{
    public const PROPERTY_ALLOWED_FILE_EXTENSIONS = 'allowed_file_extensions';

    public const PROPERTY_ALLOWED_FILE_SIZE       = 'allowed_file_size';

    public const PROPERTY_PREFERED_PROFILE_IMAGE  = 'profile_image';

    public function __construct(
        private CoreParametersHelper \$coreParametersHelper,
        private TranslatorInterface \$translator
    ) {
    }

    public function buildForm(FormBuilderInterface \$builder, array \$options): void
    {
        if (empty(\$options['data'][self::PROPERTY_ALLOWED_FILE_EXTENSIONS])) {
            \$options['data'][self::PROPERTY_ALLOWED_FILE_EXTENSIONS] = \$this->coreParametersHelper->get('allowed_extensions');
        }
        if (empty(\$options['data'][self::PROPERTY_ALLOWED_FILE_SIZE])) {
            \$options['data'][self::PROPERTY_ALLOWED_FILE_SIZE] = \$this->coreParametersHelper->get('max_size');
        }

        \$arrayStringTransformer = new ArrayStringTransformer();
        \$builder->add(
            \$builder->create(
                self::PROPERTY_ALLOWED_FILE_EXTENSIONS,
                TextareaType::class,
                [
                    'label'      => 'mautic.form.field.file.allowed_extensions',
                    'label_attr' => ['class' => 'control-label'],
                    'required'   => false,
                    'attr'       => [
                        'class'   => 'form-control',
                        'tooltip' => 'mautic.form.field.file.tooltip.allowed_extensions',
                    ],
                    'data'        => \$options['data'][self::PROPERTY_ALLOWED_FILE_EXTENSIONS],
                    'constraints' => [new FileExtensionConstraint()],
                ]
            )->addViewTransformer(\$arrayStringTransformer)
        );

        \$maxUploadSize = FileHelper::getMaxUploadSizeInMegabytes();
        \$builder->add(
            self::PROPERTY_ALLOWED_FILE_SIZE,
            TextType::class,
            [
                'label'      => 'mautic.form.field.file.allowed_size',
                'label_attr' => ['class' => 'control-label'],
                'required'   => false,
                'attr'       => [
                    'class'   => 'form-control',
                    'tooltip' => \$this->translator->trans('mautic.form.field.file.tooltip.allowed_size', ['%uploadSize%' => \$maxUploadSize]),
                ],
                'data'        => \$options['data'][self::PROPERTY_ALLOWED_FILE_SIZE],
                'constraints' => [new LessThanOrEqual(['value' => \$maxUploadSize])],
            ]
        );

        \$builder->add(
            'public',
            YesNoButtonGroupType::class,
            [
                'label' => 'mautic.form.field.file.public',
            ]
        );

        \$builder->add(
            self::PROPERTY_PREFERED_PROFILE_IMAGE,
            YesNoButtonGroupType::class,
            [
                'label'       => 'mautic.form.field.file.set_as_profile_image',
                'data'        => \$options['data'][self::PROPERTY_PREFERED_PROFILE_IMAGE] ?? false,
            ]
        );
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/FormBundle/Form/Type/FormFieldFileType.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/FormBundle/Form/Type/FormFieldFileType.php", "/var/www/html/production-demo/app/bundles/FormBundle/Form/Type/FormFieldFileType.php");
    }
}
