<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('de', array (
  'validators' => 
  array (
    'This value should be false.' => 'Dieser Wert sollte false sein.',
    'This value should be true.' => 'Dieser Wert sollte true sein.',
    'This value should be of type {{ type }}.' => 'Dieser Wert sollte vom Typ {{ type }} sein.',
    'This value should be blank.' => 'Dieser Wert sollte leer sein.',
    'The value you selected is not a valid choice.' => 'Sie haben einen ungültigen Wert ausgewählt.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Sie müssen mindestens {{ limit }} Möglichkeit wählen.|Sie müssen mindestens {{ limit }} Möglichkeiten wählen.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Sie dürfen höchstens {{ limit }} Möglichkeit wählen.|Sie dürfen höchstens {{ limit }} Möglichkeiten wählen.',
    'One or more of the given values is invalid.' => 'Einer oder mehrere der angegebenen Werte sind ungültig.',
    'This field was not expected.' => 'Dieses Feld wurde nicht erwartet.',
    'This field is missing.' => 'Dieses Feld fehlt.',
    'This value is not a valid date.' => 'Dieser Wert entspricht keiner gültigen Datumsangabe.',
    'This value is not a valid datetime.' => 'Dieser Wert entspricht keiner gültigen Datums- und Zeitangabe.',
    'This value is not a valid email address.' => 'Dieser Wert ist keine gültige E-Mail-Adresse.',
    'The file could not be found.' => 'Die Datei wurde nicht gefunden.',
    'The file is not readable.' => 'Die Datei ist nicht lesbar.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Die Datei ist zu groß ({{ size }} {{ suffix }}). Die maximal zulässige Größe beträgt {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Der Dateityp ist ungültig ({{ type }}). Erlaubte Dateitypen sind {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Dieser Wert sollte kleiner oder gleich {{ limit }} sein.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Diese Zeichenkette ist zu lang. Sie sollte höchstens {{ limit }} Zeichen haben.|Diese Zeichenkette ist zu lang. Sie sollte höchstens {{ limit }} Zeichen haben.',
    'This value should be {{ limit }} or more.' => 'Dieser Wert sollte größer oder gleich {{ limit }} sein.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Diese Zeichenkette ist zu kurz. Sie sollte mindestens {{ limit }} Zeichen haben.|Diese Zeichenkette ist zu kurz. Sie sollte mindestens {{ limit }} Zeichen haben.',
    'This value should not be blank.' => 'Dieser Wert sollte nicht leer sein.',
    'This value should not be null.' => 'Dieser Wert sollte nicht null sein.',
    'This value should be null.' => 'Dieser Wert sollte null sein.',
    'This value is not valid.' => 'Dieser Wert ist nicht gültig.',
    'This value is not a valid time.' => 'Dieser Wert entspricht keiner gültigen Zeitangabe.',
    'This value is not a valid URL.' => 'Dieser Wert ist keine gültige URL.',
    'The two values should be equal.' => 'Die beiden Werte sollten identisch sein.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Die Datei ist zu groß. Die maximal zulässige Größe beträgt {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Die Datei ist zu groß.',
    'The file could not be uploaded.' => 'Die Datei konnte nicht hochgeladen werden.',
    'This value should be a valid number.' => 'Dieser Wert sollte eine gültige Zahl sein.',
    'This file is not a valid image.' => 'Diese Datei ist kein gültiges Bild.',
    'This is not a valid IP address.' => 'Dieser Wert ist keine gültige IP-Adresse.',
    'This value is not a valid language.' => 'Dieser Wert entspricht keiner gültigen Sprache.',
    'This value is not a valid locale.' => 'Dieser Wert entspricht keinem gültigen Gebietsschema.',
    'This value is not a valid country.' => 'Dieser Wert entspricht keinem gültigen Land.',
    'This value is already used.' => 'Dieser Wert wird bereits verwendet.',
    'The size of the image could not be detected.' => 'Die Größe des Bildes konnte nicht ermittelt werden.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'Die Bildbreite ist zu groß ({{ width }}px). Die maximal zulässige Breite beträgt {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'Die Bildbreite ist zu gering ({{ width }}px). Die erwartete Mindestbreite beträgt {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'Die Bildhöhe ist zu groß ({{ height }}px). Die maximal zulässige Höhe beträgt {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'Die Bildhöhe ist zu gering ({{ height }}px). Die erwartete Mindesthöhe beträgt {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Dieser Wert sollte dem aktuellen Benutzerpasswort entsprechen.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Dieser Wert sollte genau {{ limit }} Zeichen lang sein.|Dieser Wert sollte genau {{ limit }} Zeichen lang sein.',
    'The file was only partially uploaded.' => 'Die Datei wurde nur teilweise hochgeladen.',
    'No file was uploaded.' => 'Es wurde keine Datei hochgeladen.',
    'No temporary folder was configured in php.ini.' => 'Es wurde kein temporärer Ordner in der php.ini konfiguriert oder der temporäre Ordner existiert nicht.',
    'Cannot write temporary file to disk.' => 'Kann die temporäre Datei nicht speichern.',
    'A PHP extension caused the upload to fail.' => 'Eine PHP-Erweiterung verhinderte den Upload.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Diese Sammlung sollte {{ limit }} oder mehr Elemente beinhalten.|Diese Sammlung sollte {{ limit }} oder mehr Elemente beinhalten.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Diese Sammlung sollte {{ limit }} oder weniger Elemente beinhalten.|Diese Sammlung sollte {{ limit }} oder weniger Elemente beinhalten.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Diese Sammlung sollte genau {{ limit }} Element beinhalten.|Diese Sammlung sollte genau {{ limit }} Elemente beinhalten.',
    'Invalid card number.' => 'Ungültige Kartennummer.',
    'Unsupported card type or invalid card number.' => 'Nicht unterstützter Kartentyp oder ungültige Kartennummer.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Dieser Wert ist keine gültige Internationale Bankkontonummer (IBAN).',
    'This value is not a valid ISBN-10.' => 'Dieser Wert entspricht keiner gültigen ISBN-10.',
    'This value is not a valid ISBN-13.' => 'Dieser Wert entspricht keiner gültigen ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Dieser Wert ist weder eine gültige ISBN-10 noch eine gültige ISBN-13.',
    'This value is not a valid ISSN.' => 'Dieser Wert ist keine gültige ISSN.',
    'This value is not a valid currency.' => 'Dieser Wert ist keine gültige Währung.',
    'This value should be equal to {{ compared_value }}.' => 'Dieser Wert sollte gleich {{ compared_value }} sein.',
    'This value should be greater than {{ compared_value }}.' => 'Dieser Wert sollte größer als {{ compared_value }} sein.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Dieser Wert sollte größer oder gleich {{ compared_value }} sein.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Dieser Wert sollte identisch sein mit {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Dieser Wert sollte kleiner als {{ compared_value }} sein.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Dieser Wert sollte kleiner oder gleich {{ compared_value }} sein.',
    'This value should not be equal to {{ compared_value }}.' => 'Dieser Wert sollte nicht {{ compared_value }} sein.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Dieser Wert sollte nicht identisch sein mit {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Das Seitenverhältnis des Bildes ist zu groß ({{ ratio }}). Der erlaubte Maximalwert ist {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Das Seitenverhältnis des Bildes ist zu klein ({{ ratio }}). Der erwartete Minimalwert ist {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'Das Bild ist quadratisch ({{ width }}x{{ height }}px). Quadratische Bilder sind nicht erlaubt.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'Das Bild ist im Querformat ({{ width }}x{{ height }}px). Bilder im Querformat sind nicht erlaubt.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'Das Bild ist im Hochformat ({{ width }}x{{ height }}px). Bilder im Hochformat sind nicht erlaubt.',
    'An empty file is not allowed.' => 'Eine leere Datei ist nicht erlaubt.',
    'The host could not be resolved.' => 'Der Hostname konnte nicht aufgelöst werden.',
    'This value does not match the expected {{ charset }} charset.' => 'Dieser Wert entspricht nicht dem erwarteten Zeichensatz {{ charset }}.',
    'This is not a valid Business Identifier Code (BIC).' => 'Dieser Wert ist keine gültige internationale Bankleitzahl (BIC).',
    'Error' => 'Fehler',
    'This is not a valid UUID.' => 'Dieser Wert ist keine gültige UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'Dieser Wert sollte ein Vielfaches von {{ compared_value }} sein.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Diese internationale Bankleitzahl (BIC) ist nicht mit der IBAN {{ iban }} assoziiert.',
    'This value should be valid JSON.' => 'Dieser Wert sollte gültiges JSON sein.',
    'This collection should contain only unique elements.' => 'Diese Sammlung darf keine doppelten Elemente enthalten.',
    'This value should be positive.' => 'Diese Zahl sollte positiv sein.',
    'This value should be either positive or zero.' => 'Diese Zahl sollte entweder positiv oder 0 sein.',
    'This value should be negative.' => 'Diese Zahl sollte negativ sein.',
    'This value should be either negative or zero.' => 'Diese Zahl sollte entweder negativ oder 0 sein.',
    'This value is not a valid timezone.' => 'Dieser Wert ist keine gültige Zeitzone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Dieses Passwort ist Teil eines Datenlecks, es darf nicht verwendet werden.',
    'This value should be between {{ min }} and {{ max }}.' => 'Dieser Wert sollte zwischen {{ min }} und {{ max }} sein.',
    'This value is not a valid hostname.' => 'Dieser Wert ist kein gültiger Hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Die Anzahl an Elementen in dieser Sammlung sollte ein Vielfaches von {{ compared_value }} sein.',
    'This value should satisfy at least one of the following constraints:' => 'Dieser Wert sollte eine der folgenden Bedingungen erfüllen:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Jedes Element dieser Sammlung sollte seine eigene Menge an Bedingungen erfüllen.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Dieser Wert ist keine gültige Internationale Wertpapierkennnummer (ISIN).',
    'This value should be a valid expression.' => 'Dieser Wert sollte eine gültige Expression sein.',
    'This value is not a valid CSS color.' => 'Dieser Wert ist keine gültige CSS-Farbe.',
    'This value is not a valid CIDR notation.' => 'Dieser Wert entspricht nicht der CIDR-Notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'Der Wert der Subnetzmaske sollte zwischen {{ min }} und {{ max }} liegen.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'Der Dateiname ist zu lang. Er sollte nicht länger als {{ filename_max_length }} Zeichen sein.|Der Dateiname ist zu lang. Er sollte nicht länger als {{ filename_max_length }} Zeichen sein.',
    'The password strength is too low. Please use a stronger password.' => 'Das Passwort ist zu schwach.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'Der Wert enthält Zeichen, die auf der aktuellen Einschränkungsstufe nicht erlaubt sind.',
    'Using invisible characters is not allowed.' => 'Unsichtbare Zeichen sind nicht erlaubt.',
    'Mixing numbers from different scripts is not allowed.' => 'Das Mischen von Zahlen aus verschiedenen Skripten ist nicht erlaubt.',
    'Using hidden overlay characters is not allowed.' => 'Verstecke Overlay-Zeichen sind nicht erlaubt.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'Die Dateiendung ist ungültig ({{ extension }}). Gültige Dateiendungen sind {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'Der erkannte Zeichensatz ist nicht gültig ({{ detected }}). Gültige Zeichensätze sind {{ encodings }}.',
    'This value is not a valid MAC address.' => 'Dieser Wert ist keine gültige MAC-Adresse.',
    'This URL is missing a top-level domain.' => 'Dieser URL fehlt eine Top-Level-Domain.',
    'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.' => 'Dieser Wert ist zu kurz. Er muss aus mindestens einem Wort bestehen.|Dieser Wert ist zu kurz. Er muss mindestens {{ min }} Wörter enthalten.',
    'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.' => 'Dieser Wert ist zu lang. Er darf maximal aus einem Wort bestehen.|Dieser Wert ist zu lang. Er darf maximal {{ max }} Wörter enthalten.',
    'This value does not represent a valid week in the ISO 8601 format.' => 'Dieser Wert ist keine Wochenangabe im ISO 8601-Format.',
    'This value is not a valid week.' => 'Dieser Wert ist keine gültige Woche.',
    'This value should not be before week "{{ min }}".' => 'Dieser Wert darf nicht vor der Woche "{{ min }}" sein.',
    'This value should not be after week "{{ max }}".' => 'Dieser Wert darf nicht nach der Woche "{{ max }}" sein.',
    'This form should not contain extra fields.' => 'Dieses Formular sollte keine zusätzlichen Felder enthalten.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Die hochgeladene Datei ist zu groß. Versuchen Sie bitte eine kleinere Datei hochzuladen.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'Der CSRF-Token ist ungültig. Versuchen Sie bitte, das Formular erneut zu senden.',
    'This value is not a valid HTML5 color.' => 'Dieser Wert ist keine gültige HTML5 Farbe.',
    'Please enter a valid birthdate.' => 'Bitte geben Sie ein gültiges Geburtsdatum ein.',
    'The selected choice is invalid.' => 'Die Auswahl ist ungültig.',
    'The collection is invalid.' => 'Diese Gruppe von Feldern ist ungültig.',
    'Please select a valid color.' => 'Bitte geben Sie eine gültige Farbe ein.',
    'Please select a valid country.' => 'Bitte wählen Sie ein gültiges Land aus.',
    'Please select a valid currency.' => 'Bitte wählen Sie eine gültige Währung aus.',
    'Please choose a valid date interval.' => 'Bitte wählen Sie ein gültiges Datumsintervall.',
    'Please enter a valid date and time.' => 'Bitte geben Sie ein gültiges Datum samt Uhrzeit ein.',
    'Please enter a valid date.' => 'Bitte geben Sie ein gültiges Datum ein.',
    'Please select a valid file.' => 'Bitte wählen Sie eine gültige Datei.',
    'The hidden field is invalid.' => 'Das versteckte Feld ist ungültig.',
    'Please enter an integer.' => 'Bitte geben Sie eine ganze Zahl ein.',
    'Please select a valid language.' => 'Bitte wählen Sie eine gültige Sprache.',
    'Please select a valid locale.' => 'Bitte wählen Sie eine gültige Locale-Einstellung aus.',
    'Please enter a valid money amount.' => 'Bitte geben Sie einen gültigen Geldbetrag ein.',
    'Please enter a number.' => 'Bitte geben Sie eine gültige Zahl ein.',
    'The password is invalid.' => 'Das Kennwort ist ungültig.',
    'Please enter a percentage value.' => 'Bitte geben Sie einen gültigen Prozentwert ein.',
    'The values do not match.' => 'Die Werte stimmen nicht überein.',
    'Please enter a valid time.' => 'Bitte geben Sie eine gültige Uhrzeit ein.',
    'Please select a valid timezone.' => 'Bitte wählen Sie eine gültige Zeitzone.',
    'Please enter a valid URL.' => 'Bitte geben Sie eine gültige URL ein.',
    'Please enter a valid search term.' => 'Bitte geben Sie einen gültigen Suchbegriff ein.',
    'Please provide a valid phone number.' => 'Bitte geben Sie eine gültige Telefonnummer ein.',
    'The checkbox has an invalid value.' => 'Das Kontrollkästchen hat einen ungültigen Wert.',
    'Please enter a valid email address.' => 'Bitte geben Sie eine gültige E-Mail-Adresse ein.',
    'Please select a valid option.' => 'Bitte wählen Sie eine gültige Option.',
    'Please select a valid range.' => 'Bitte wählen Sie einen gültigen Bereich.',
    'Please enter a valid week.' => 'Bitte geben Sie eine gültige Woche ein.',
    'mautic.stage.form.actions.notempty' => 'Mindestens eine Aktion ist erforderlich.',
    'mautic.stage.type.notblank' => 'Es muss eine Phasen-Aktion ausgewähl werden.',
    'mautic.chat.channel.name.notblank' => 'Name ist Pflichtfeld',
    'mautic.chat.channel.name.unique' => 'Der Name wird schon verwendet',
    'mautic.sparkpost.plugin.region.empty' => 'Die Sparkpost-Region ist leer. Füge „Region“ als Option hinzu.',
    'mautic.sparkpost.plugin.region.invalid' => 'Die Sparkpost-Region ist ungültig. Füge „us“ oder „eu“ als geeignete Region hinzu.',
    'mautic.sms.choosesms.notblank' => 'Bitte wählen Sie eine SMS',
    'mautic.user.user.email.unique' => 'Die E-Mail Adresse wird bereits genutzt. Bitte wählen Sie eine Alternative.',
    'mautic.user.user.email.valid' => 'Die E-Mail Adresse ist ungültig',
    'mautic.user.user.firstname.notblank' => 'Ein Dateiname ist erforderlich.',
    'mautic.user.user.lastname.notblank' => 'Nachname ist erforderlich',
    'mautic.user.user.password.minlength' => 'Das Passwort muss mindestens 6 Zeichen enthalten.',
    'mautic.user.user.password.mismatch' => 'Die Passworte stimmen nicht überein.',
    'mautic.user.user.password.notblank' => 'Das Passwort kann nicht leer sein.',
    'mautic.user.user.passwordreset.notblank' => 'Um das Passwort zurückzusetzen, ist ein Benutzername oder eine E-Mail-Adresse erforderlich.',
    'mautic.user.user.password.weak' => 'Bitte ein sichereres Passwort eingeben. Das Passwort muss eine Kombination aus Groß- und Kleinbuchstaben, Sonderzeichen und Zahlen enthalten.',
    'mautic.user.user.role.notblank' => 'Für diesen Benutzer muss eine Rolle ausgewählt werden.',
    'mautic.user.user.username.notblank' => 'Benutzername ist erforderlich.',
    'mautic.user.user.username.unique' => 'Der Nutzername wird bereits genutzt. Bitte wählen Sie eine Alternative.',
    'mautic.user.saml.certificate.invalid' => 'Das Zertifikat ist ungültig. Es sollte mit <pre>-----BEGIN CERTIFICATE-----</pre> beginnen.',
    'mautic.user.saml.private_key.invalid' => 'Privater Schlüssel ist ungültig. Er sollte mit <pre>-----BEGIN RSA PRIVATE KEY-----</pre> oder <pre>-----BEGIN ENCRYPTED PRIVATE KEY-----</pre> beginnen.',
    'mautic.user.saml.private_key.password_needed' => 'Der bereitgestellte private Schlüssel ist verschlüsselt und erfordert daher zur Entschlüsselung ein Kennwort.',
    'mautic.user.saml.private_key.password_invalid' => 'Das Passwort konnte den privaten Schlüssel nicht entschlüsseln.',
    'mautic.user.saml.metadata.invalid' => 'Die Metadatendatei scheint ungültig zu sein.',
    'mautic.dashboard.upload.filenotfound' => 'Die Datei wurde nicht gefunden',
    'mautic.category.title.notblank' => 'Ein Titel ist erforderlich',
    'mautic.focus.error.select_type' => 'Nutze den Builder, um den Focus auszuwählen.',
    'mautic.focus.error.select_style' => 'Nutze den Builder, um den Style auszuwählen.',
    'mautic.focus.choosefocus.notblank' => 'Ein Fokus-Element ist erforderlich.',
    'mautic.channel.choosemessage.notblank' => 'Eine Nachricht ist erforderlich.',
    'mautic.report.schedule.notValid' => 'Einstellungen sind nicht gültig. Bitte alle notwendigen Felder ausfüllen',
    'mautic.report.schedule.to_address_required' => 'Adresse ist für die Planung des Berichts erforderlich',
    'mautic.report.schedule.invalidScheduler' => 'Scheduler ist nicht gültig',
    'mautic.report.schedule.notSupportedType' => 'Dieser Scheduler wird nicht unterstützt',
    'mautic.messenger.dsn.invalid_dsn' => 'Ungültiger DSN. Bitte stelle sicher, dass alle erforderlichen Felder ausgefüllt sind. Normalerweise sind die Felder „Schema“ und „Host“ erforderlich.',
    'mautic.messenger.dsn.unsupported_scheme' => 'Nicht unterstütztes Schema. Bitte stelle sicher, dass das eingegebene Schema einem der unterstützten Schemata entspricht. Möglicherweise muss zuerst ein Paket installiert werden, dass das Schema unterstützt. Weitere Einzelheiten sind unter https://symfony.com/doc/5.4/messenger.html#transport-configuration zu finden.',
    'mautic.social.network.type' => 'Es ist eine Überwachungsmethode erforderlich.',
    'mautic.integration.Twitter.send.selecttweet.notblank' => 'Tweet Liste darf nicht leer sein. Auswahl treffen',
    'mautic.install.database.driver.invalid' => 'Ungültiger Datenbanktreiber angegeben. Muss einer von %drivers% sein.',
    'mautic.install.database.path.invalid' => 'Das Pfad ist ungültig oder nicht beschreibbar.',
    'mautic.install.database.path.warning' => 'VORSICHT! Der Pfad befindet sich innerhalb des öffentlichen Web-Verzeichnisses. Davon wird aus Sicherheitsgründen abgeraten. Bitte ziehen Sie in Betracht, einen Pfad außerhalb von %root% zu verwenden.',
    'mautic.install.database.port.invalid' => 'Die Port-Nummer muss eine ganze Zahl größer 0 sein.',
    'mautic.install.password.minlength' => 'Das Passwort muss mindestens 6 Zeichen enthalten.',
    'mautic.campaign.form.events.notempty' => 'Mindestens ein Ereignis ist erforderlich. Klicken Sie auf den "Kampagnen-Builder starten" Button, um ein Ereignis hinzuzufügen. ',
    'mautic.campaign.form.sources.notempty' => 'Mindestens eine Kontakt-Quelle ist erforderlich. Starten Sie den Kampagnen-Builder, um eine hinzuzufügen.',
    'mautic.page.variant.weight.notblank' => 'Geben Sie wieviel Prozent eindeutige Besuche angezeigt werden sollen',
    'mautic.asset.asset.error.missing.file' => 'Es muss eine Datei vom lokalen Speicherort hochgeladen werden, bevor das Asset gespeichert werden kann.',
    'mautic.asset.asset.error.missing.title' => 'Asset Titel erforderlich.',
    'mautic.asset.asset.error.missing.remote.path' => 'Es muss eine Remote URL angegeben werden, wenn die Remote Speicherung ausgewählt ist.',
    'mautic.asset.asset.error.file.size' => 'Upload fehlgeschlagen, weil die Datei %fileSize% MB groß ist und damit die zulässige Dateigröße von %maxSize% MB überschreitet. Dieses Limit kann in den Einstellungen geändert werden.',
    'mautic.asset.asset.error.file.extension' => 'Upload fehlgeschlagen, weil das Dateiformat %fileExtension% nicht zu den zulässigen Formaten (%extensions%) gehört. Dies kann in den Einstellungen geändert werden.',
    'mautic.asset.asset.error.file.extension.js' => 'Upload fehlgeschlagen, weil das Dateiformat nicht zu den zulässigen Formaten (%extensions%) gehört. Dies kann in den Einstellungen geändert werden.',
    'mautic.asset.validation.error.url' => 'Es sollte eine gültige URL sein.',
    'mautic.form.field.fields.count' => 'Dieses Formular erfordert mindestens ein Feld',
    'mautic.form.field.generic.required' => 'Erforderlich',
    'mautic.form.field.generic.validationfailed' => '\'%label%\' ist erforderlich.',
    'mautic.form.field.label.notblank' => 'Label ist erforderlich.',
    'mautic.form.field.alias.unique' => 'Ein anderes Feld verwendet bereits diesen Alias: %alias%. Wählen Sie einen anderen aus oder lassen Sie das Feld leer, damit es automatisch generiert wird.',
    'mautic.form.form.fields.notempty' => 'Mindestens ein Feld ist erforderlich. Verwenden Sie den Reiter "Felder" um Felder zur Form hinzuzufügen.',
    'mautic.form.form.postactionproperty_message.notblank' => 'Geben Sie die Nachricht ein, die angezeigt werden soll',
    'mautic.form.form.postactionproperty_redirect.notblank' => 'Geben Sie eine gültige URL an.',
    'mautic.form.schema.failed' => 'Beim Anlegen der Tabelle für die Einreichungsergebnisse ist ein Fehler aufgetreten. Nutzen Sie einen anderen Namen.',
    'mautic.form.submission.captcha.invalid' => 'Die Antwort für %label% ist falsch. Bitte versuchen Sie es erneut.',
    'mautic.form.submission.email.invalid' => 'Die E-Mail ist ungültig.',
    'mautic.form.submission.url.invalid' => 'Die URL ist ungültig.',
    'mautic.form.submission.phone.invalid' => 'Bitte folgendes internationale Telefonnummernformat nutzen [+][Ländercode][Telefonnummer] (z.B.: ‪+14028650000).',
    'mautic.form.submission.email.donotsubmit.invalid' => 'Kann nicht mit dieser E-Mail gesendet werden',
    'mautic.form.submission.error.file.extension' => 'Upload fehlgeschlagen, da die Dateierweiterung, %fileExtension%, nicht in der Liste der zulässigen Erweiterungen (%extensions%) enthalten ist.',
    'mautic.form.submission.error.file.size' => 'Der Upload ist fehlgeschlagen, da die Datei %fileSize% MB hat und die maximal zulässige Dateigröße von %maxSize% MB überschreitet.',
    'mautic.form.submission.error.file.uploadFailed' => 'Hochladen fehlgeschlagen.',
    'mautic.form.form.progressive_profiling_limit.error' => 'Dieser Wert sollte leer oder größer als 0 sein',
    'mautic.api.client.callback.notblank' => 'Callback-URI ist ein Pflichtfeld',
    'mautic.api.client.redirecturis.notblank' => 'Redirect-URI ist ein Pflichtfeld',
    'mautic.api.client.redirecturl.invalid' => '%url% ist keine URI.',
    'mautic.integration.sync.missing_mautic_field_mappings' => 'Die folgenden Mautic-Felder werden benötigt und müssen zuegordnet werden: %fields%',
    'mautic.notification.choosenotification.notblank' => 'Bitte wählen Sie eine Benachrichtigung',
    'mautic.dynamicContent.name.notblank' => 'Bitte geben Sie einen Namen ein.',
    'mautic.dynamicContent.slot_name.notblank' => 'Bitte geben Sie einen Slot-Namen ein.',
    'mautic.dynamicContent.filter.options.empty' => 'Mindestens ein Filter ist erforderlich.',
    'mautic.point.form.actions.notempty' => 'Mindestens eine Aktion ist erforderlich.',
    'mautic.point.type.notblank' => 'Eine Punkt-Aktion muss ausgewählt sein.',
    'mautic.point.delta.notblank' => 'Es muss eine Punktänderung (Delta) ausgewählt werden.',
    'mautic.email.chooseemail.notblank' => 'Wählen Sie bitte die E-Mail aus, die verschickt werden soll.',
    'mautic.email.list.noaccess' => 'Es wurde keine Liste ausgewählt oder Sie haben keine Berechtigung für die ausgewählte Liste.',
    'mautic.email.subject.notblank' => 'Der Betreff ist erforderlich',
    'mautic.email.variant.weight.notblank' => 'Geben Sie an, wieviel Prozent der Empfänger die E-Mail erhalten sollen',
    'mautic.email.api_key_required' => 'Ein API-Schlüssel wird benötigt.',
    'mautic.email.multiple_emails.not_valid' => 'Bereitgestellte E-mails sind nicht gültig: %email%',
    'mautic.email.email_or_token.not_valid' => 'Der angegebene Wert „%value%“ ist weder eine E-Mail-Adresse noch ein auf einem E-Mail-Feldtyp basierendes Token. %details%',
    'mautic.email.dsn.invalid_dsn' => 'Ungültiger DSN. Bitte stellen Sie sicher, dass Sie alle erforderlichen Felder ausgefüllt haben.',
    'mautic.email.dsn.unsupported_scheme' => 'Nicht unterstütztes Schema.',
    'mautic.core.ab_test.winner_criteria.not_blank' => 'Wählen Sie das \'winning\' Kriterium aus-',
    'mautic.core.email.required' => 'Eine gültige E-Mail ist erforderlich.',
    'mautic.core.segment.circular_dependency_exists' => 'Das Update kann nicht abgeschlossen werden, da die aktuellen Filter mit den Filtern eines anderen Segments in Konflikt stehen. Stellen Sie sicher, dass Ihre Segmentfilter keine unmöglichen oder widersprüchlichen Bedingungen erzeugen (z. B. muss Segment A Mitglied von Segment B sein, während Segment B Mitglied von Segment A sein muss).',
    'mautic.core.name.required' => 'Ein Name ist erforderlich.',
    'mautic.core.title.required' => 'Ein Titel ist erforderlich.',
    'mautic.core.type.required' => 'Ein Typ ist erforderlich',
    'mautic.core.value.required' => 'Ein Wert ist erforderlich.',
    'mautic.core.subject.required' => 'Der Betreff ist erforderlich',
    'mautic.core.variant_weights_invalid' => 'Die Summe der Gewichte zwischen allen Kategorien kann nicht mehr als 100 % betragen.',
    'mautic.form.lists.count' => 'Mindestens ein Listenwert ist erforderlich.',
    'mautic.form.lists.notblank' => 'Die Werte in der Liste können nicht leer sein.',
    'mautic.core.theme.missing.files' => 'Der Vorlage, die Sie zu installieren versucht haben, fehlen die folgenden erforderlichen Dateien und sie konnte daher nicht installiert werden: %files%',
    'mautic.core.theme.default.cannot.overwrite' => '%name% ist die Standard Vorlage und kann deshalb nicht überschrieben werden.',
    'mautic.core.valid_url_required' => 'Eine gültige URL wird benötigt.',
    'mautic.core.theme.upload.empty' => 'Die Datei wurde nicht ausgewählt. Wähle eine Zip Date aus, um diese hochzuladen.',
    'mautic.core.invalid_file_type' => 'Ungültiger Dateityp {{ type }}. Zulässige Dateitypen: {{ types }}.',
    'mautic.core.invalid_file_encoding' => 'Die Datei ist nicht korrekt in UTF-8 codiert.',
    'mautic.core.not.allowed.file.extension' => '%extension% ist keine zulässige Dateierweiterung',
    'mautic.core.regex.invalid' => 'Die Regex-Syntax ist ungültig.',
    'mautic.plugin.field.required_mapping_missing' => 'Mindestens ein Pflichtfeld ist nicht zugeordnet',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Es ist ein Fehler bei der Authentifikation aufgetreten.',
    'Authentication credentials could not be found.' => 'Es konnten keine Zugangsdaten gefunden werden.',
    'Authentication request could not be processed due to a system problem.' => 'Die Authentifikation konnte wegen eines Systemproblems nicht bearbeitet werden.',
    'Invalid credentials.' => 'Fehlerhafte Zugangsdaten.',
    'Cookie has already been used by someone else.' => 'Cookie wurde bereits von jemand anderem verwendet.',
    'Not privileged to request the resource.' => 'Keine Rechte, um die Ressource anzufragen.',
    'Invalid CSRF token.' => 'Ungültiges CSRF-Token.',
    'No authentication provider found to support the authentication token.' => 'Es wurde kein Authentifizierungs-Provider gefunden, der das Authentifizierungs-Token unterstützt.',
    'No session available, it either timed out or cookies are not enabled.' => 'Keine Session verfügbar, entweder ist diese abgelaufen oder Cookies sind nicht aktiviert.',
    'No token could be found.' => 'Es wurde kein Token gefunden.',
    'Username could not be found.' => 'Der Benutzername wurde nicht gefunden.',
    'Account has expired.' => 'Der Account ist abgelaufen.',
    'Credentials have expired.' => 'Die Zugangsdaten sind abgelaufen.',
    'Account is disabled.' => 'Der Account ist deaktiviert.',
    'Account is locked.' => 'Der Account ist gesperrt.',
    'Too many failed login attempts, please try again later.' => 'Zu viele fehlgeschlagene Anmeldeversuche, bitte versuchen Sie es später noch einmal.',
    'Invalid or expired login link.' => 'Ungültiger oder abgelaufener Anmelde-Link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Zu viele fehlgeschlagene Anmeldeversuche, bitte versuchen Sie es in einer Minute noch einmal.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Zu viele fehlgeschlagene Anmeldeversuche, bitte versuchen Sie es in %minutes% Minuten noch einmal.',
  ),
  'FOSOAuthServerBundle' => 
  array (
    'authorize.accept' => 'Erlauben',
    'authorize.reject' => 'Verweigern',
  ),
  'javascript' => 
  array (
    'grapesjsbuilder.sourceEditBtnLabel' => 'Speichern',
    'grapesjsbuilder.sourceCancelBtnLabel' => 'Abbrechen',
    'grapesjsbuilder.sourceEditModalTitle' => 'Code bearbeiten',
    'grapesjsbuilder.sourceSyntaxError' => 'Bitte behebe den folgenden Fehler:',
    'grapesjsbuilder.deleteAssetConfirmText' => 'Möchten Sie diese Datei wirklich löschen? ',
    'grapesjsbuilder.categorySectionLabel' => 'Bereiche',
    'grapesjsbuilder.categoryBlockLabel' => 'Blöcke',
    'grapesjsbuilder.dynamicContentBlockLabel' => 'Dynamischer Inhalt',
    'grapesjsbuilder.dynamicContentBtnLabel' => 'Speichern',
    'grapesjsbuilder.dynamicContentModalTitle' => 'Dynamischen Inhalt editieren',
    'grapesjsbuilder.assetManager.noAssets' => 'Keine <b>Assets</b> hier, zum Hochladen ziehen',
    'grapesjsbuilder.buttonBlockLabel' => 'Button',
    'grapesjsbuilder.components.names.twoColumnThirdSevens' => '2 Spalten 3/7',
    'grapesjsbuilder.components.names.textSectionBlkLabel' => 'Textabschnitt',
    'grapesjsbuilder.components.names.gridItemsBlkLabel' => 'Rasterelemente',
    'grapesjsbuilder.components.names.listItemsBlkLabel' => 'Listenelemente',
    'mautic.message.queue.status.cancelled' => 'abgebrochen',
    'mautic.message.queue.status.rescheduled' => 'Neu geplant',
    'mautic.message.queue.status.pending' => 'Ausstehend',
    'mautic.message.queue.status.Sent' => 'Gesendet',
    'mautic.core.builder.code_mode_warning' => 'Sie können im Code-Modus den Inhalt ausschließlich in HTML bearbeiten. Wenn Sie auf eine Vorlage zurückschalten, geht Ihr Inhalt verloren.',
    'mautic.core.builder.theme_change_warning' => 'Sie werden den aktuellen Inhalt verlieren, wenn Sie auf eine Vorlage umschalten.',
    'mautic.core.builder.section_delete_warning' => 'Sind Sie sicher, dass Sie den gesamten Bereich und den dazugehörigen Inhalt löschen möchten?',
    'mautic.core.builder.storage.restore.message' => 'Sie haben eine Kopie dieser Vorlage am <b>%date%</b> gespeichert.',
    'mautic.core.builder.storage.restore.button' => 'Wiederherstellen der Sicherung',
    'mautic.core.builder.storage.dismiss.button' => 'Ablehnen',
    'mautic.core.lookup.keep_typing' => 'Schreibt gerade...',
    'mautic.core.lookup.looking_for' => 'Suche nach',
    'mautic.core.lookup.search_options' => 'Suche Optionen...',
    'mautic.core.lookup.loading_data' => 'Daten werden geladen...',
    'mautic.core.dynamicContent' => 'Dynamischer Inhalt',
    'mautic.core.dynamicContent.new' => 'Dynamische Inhalte %number%',
    'mautic.core.dynamicContent.token_name' => 'Name',
    'mautic.core.dynamicContent.tab' => 'Variation %number%',
    'mautic.core.dynamicContent.default_content' => 'Standard-Inhalt',
    'mautic.core.dynamicContent.alt_content' => 'Inhalt',
    'mautic.core.tabs.more' => 'mehr',
    'mautic.core.request.error' => 'Die Anfrage konnte nicht bearbeitet werden. Bitte versuche es erneut.',
    'mautic.campaign.event.clone.success' => 'Das Ereignis wurde geklont. Wählen einen Knoten in dieser oder einer anderen Kampagne aus, um ihn anzuhängen.',
    'grapesjsbuilder.builder.warning.code_mode' => 'Durch Öffnen des Builders verlassen Sie den Code-Modus. Der Builder kann Ihren HTML-Code auf unerwartete Weise ändern. Fahre nur fort, wenn du weisst, was du tust.',
    'grapesjsbuilder.components.names.oneColumn' => '1 Spalte',
    'grapesjsbuilder.components.names.twoColumn' => '2 Spalten',
    'grapesjsbuilder.components.names.threeColumn' => '3 Spalten',
    'grapesjsbuilder.panelsViewsCommandModalTitleError' => 'Die Aktion konnte nicht angefordert werden',
    'grapesjsbuilder.panelsViewsButtonsApplyTitle' => 'Änderungen übernehmen',
    'grapesjsbuilder.buttons.buttonPreview.title' => 'Vorschau',
    'grapesjsbuilder.buttons.buttonPreview.titleDisabled' => 'Wende Änderungen auf die Vorschau an',
  ),
  'messages' => 
  array (
    'mautic.integration.fullcontact.apikey' => 'FullContact API-Schlüssel',
    'mautic.plugin.fullcontact.button.caption' => 'Nachschlagen mit FullContact',
    'mautic.plugin.fullcontact.lookup.header' => 'FullContact - Nachschlagen von Informationen für%item%',
    'mautic.plugin.fullcontact.test_api' => 'Teste API und erzeuge Statistiken',
    'mautic.plugin.fullcontact.stats' => 'Testergebnisse',
    'mautic.plugin.fullcontact.toomany' => 'Es können höchstens 20 Kontakte gleichzeitig nachgeschlagen werden.',
    'mautic.plugin.fullcontact.comptoomany' => 'Es können höchstens 20 Unternehmen gleichzeitig nachschlagen werden.',
    'mautic.plugin.fullcontact.empty' => 'Keine Kontakte zum Nachschlagen!',
    'mautic.plugin.fullcontact.compempty' => 'Es gibt keine Unternehmensseiten zum Nachschlagen!<br/>(Firmenwebsite ist leer?)',
    'mautic.plugin.fullcontact.forbidden' => 'Sie haben nicht die nötigen Rechte, um diesen Kontakt zu aktualisieren.',
    'mautic.plugin.fullcontact.compforbidden' => 'Sie haben nicht die nötigen Rechte, um die Daten dieses Unternehmens zu aktualisieren.',
    'mautic.plugin.fullcontact.auto_update' => 'Beim Speichern automatisch aktualisieren?',
    'mautic.plugin.fullcontact.auto_update.tooltip' => 'WARNUNG: Dadurch kann Ihre Quote an API-Aufrufen pro Monat möglicherweise erschöpft werden.',
    'mautic.plugin.fullcontact.notify' => 'Zeigt eine Benachrichtigung an, wenn die Informationen empfangen wurden',
    'mautic.plugin.fullcontact.webhook' => 'Das Plugin verwendet Folgendes als Webhook-URL für FullContact:',
    'mautic.plugin.fullcontact.public_info' => '<strong>Warnung!</strong> Dies muss eine öffentlich zugängliche URL sein, damit der Webhook funktionieren kann.',
    'mautic.plugin.fullcontact.submit' => 'Klicke auf "Senden", um nach Informationen zu suchen:',
    'mautic.plugin.fullcontact.submit_items' => 'Klicken Sie auf "Senden", um Informationen für die ausgewählten Elemente zu suchen.',
    'mautic.plugin.fullcontact.company_retrieved' => 'Die Unternehmens-Informationen für %s wurden abgerufen',
    'mautic.plugin.fullcontact.contact_retrieved' => 'Die Kontaktinformationen für %s wurden abgerufen',
    'mautic.plugin.fullcontact.unable' => 'Speichern der Informationen nicht möglich%s: %s',
    'mautic.stage.stage' => 'Phase',
    'mautic.stage.action.noresults.tip' => 'Verwenden Sie Phasen-Aktionen, um den Punktestand eines Kontakts auf Basis vordefinierter Aktionen zu anzupassen. Geben Sie einem Kontakt z.B. 10 Phasen, falls er/sie eine Kampagnen-E-Mail öffnet.',
    'mautic.stage.actions.header.index' => 'Phasen-Aktionen',
    'mautic.stage.campaign.event.change' => 'Kontakt-Phase ändern',
    'mautic.stage.campaign.event.change.descr' => 'Diese Kampagne wird die Phase eines Kontakts ändern, sofern ein Kontakt auf einer Stufe mit einem geringeren Gewicht ist.',
    'mautic.stage.campaign.event.stage_missing' => 'Phase fehlt oder ist unveröffentlicht',
    'mautic.stage.campaign.event.stage_invalid' => 'Der Kontakt konnte nicht in diese Phase übergehen.',
    'mautic.stage.campaign.event.already_in_stage' => 'Der Kontakt befindet sich bereits in dieser Phase.',
    'mautic.stage.event.changed' => 'Phase geändert',
    'mautic.stage.event.added.batch' => 'Manuel hinzugefügt',
    'mautic.stage.event.removed.batch' => 'Manuel entfernt',
    'mautic.stage.import.action.name' => 'Importiert von %name%',
    'mautic.stage.form.addaction' => 'Verwenden Sie die Liste rechts um Aktionen hinzuzufügen',
    'mautic.stage.form.confirmbatchdelete' => 'Sollen die ausgewählten Phasen-Aktionen gelöscht werden?',
    'mautic.stage.form.confirmdelete' => 'Sollen die Phasen-Aktion %name% gelöscht werden?',
    'mautic.stage.form.type' => 'Wenn ein Kontakt...',
    'mautic.stage.menu.edit' => 'Phasen-Aktion editieren',
    'mautic.stage.menu.new' => 'Neue Phasen-Aktion',
    'mautic.stages.menu.root' => 'Phasen',
    'mautic.stage.permissions.header' => 'Phasen-Berechtigungen',
    'mautic.stage.permissions.stages' => 'Phasen-Aktion - Zugriff durch den Benutzer',
    'mautic.stage.permissions.triggers' => 'Triggers - zu denen der User Zugriff hat',
    'mautic.stage.thead.action' => 'Aktion',
    'mautic.stage.timeline.event.stage.change' => '<strong>Phase geändert zu:</strong> <strong class=\'text-primary\'>%name%</strong>',
    'mautic.stages.menu.index' => 'Phasen',
    'mautic.stage.dashboard.widgets' => 'Phasen-Widgets',
    'mautic.widget.stages.in.time' => 'Phasen im Zeitverlauf',
    'mautic.stage.changes' => 'Phasen-Änderungen',
    'mautic.stage.action.weight' => 'Gewicht',
    'mautic.stage.action.weight.help' => 'Dies hilft Ihnen dabei, zu ermitteln, ob ein Kontakt zu einer Phase wechseln wird. Ein Kontakt kann nicht zu einer Phase mit einem geringeren Gewicht wechseln.',
    'mautic.asset.stage.action.assets' => 'Diese Assets',
    'mautic.asset.stage.action.assets.descr' => 'Wenn ein Kontakt das ausgewählte Asset herunterlädt',
    'mautic.form.stage.action.forms' => 'Formular auswählen',
    'mautic.form.stage.action.forms.descr' => 'When ein Kontakt dieses Formular auswählt',
    'mautic.page.stage.action.form.pages' => 'Seite auswählen',
    'mautic.page.stage.action.form.pages.descr' => 'Wenn ein Kontakt diese Seite besucht',
    'mautic.page.stage.action.form.page.url' => 'URL',
    'mautic.page.stage.action.form.page.url.descr' => 'Wenn ein Kontakt diese URL besucht',
    'mautic.page.stage.action.form.accumulative.time' => 'Anzahl an Besuchen',
    'mautic.page.stage.action.form.accumulative.time.descr' => 'Wenn ein Kontakt diese Anzahl an Besuchen erreicht',
    'mautic.page.stage.action.form.returns.within' => 'Anzahl an Tagen',
    'mautic.page.stage.action.form.returns.within.descr' => 'Wenn ein Kontakt innerhalb dieser Anzahl an Tagen wiederkehrt',
    'mautic.page.stage.action.form.returns.after' => 'Rückkehr nach',
    'mautic.page.stage.action.form.returns.after.descr' => 'Kehrt nach dieser Anzahl an Tagen wieder',
    'mautic.stage.selectstage' => 'Phase auswählen',
    'mautic.stage.choose.stage_descr' => 'Wählen Sie die Phase, die den Kontakten in dieser Kampagne zugeordnet werden soll.',
    'mautic.campaign.stage.change' => 'Kontakt-Phase ändern',
    'mautic.chat.channel.form.name' => 'Channel Handle',
    'mautic.chat.channel.form.description' => 'Kurzbeschreibung',
    'mautic.chat.channel.form.isprivate' => 'Privat?',
    'mautic.chat.channel.new' => 'Hinzufügen',
    'mautic.chat.channel.header.new' => 'Neuer Channel',
    'mautic.chat.chat.channels' => 'Channels',
    'mautic.chat.chat.users' => 'User',
    'mautic.chat.chat.status.online' => 'Online',
    'mautic.chat.chat.status.away' => 'Away',
    'mautic.chat.chat.status.offline' => 'Offline',
    'mautic.chat.chat.status.dnd' => 'Bitte nicht stören',
    'mautic.chat.chat.input.placeholder' => 'Geben Sie hier \'away\' ein',
    'mautic.chat.chat.new.messages' => '--------',
    'mautic.chat.permissions.header' => 'Chat Channels',
    'mautic.chat.permissions.channels' => 'Channels, auf die der User Zugriff hat',
    'mautic.chat.permissions.archiveother' => 'Andere Archivieren',
    'mautic.calendar.menu.index' => 'Kalender',
    'mautic.citrix.form.clientid' => 'Client-ID',
    'mautic.citrix.form.clientsecret' => 'Client-Secret',
    'mautic.citrix.form.appname' => 'Name der Applikation',
    'plugin.citrix.form.header' => 'Citrix Aktionen',
    'plugin.citrix.form.header.webinar' => 'Für die ausgewählten Webinare eintragen',
    'plugin.citrix.form.header.meeting' => 'Link an eine GoToMeeting-Sitzung senden',
    'plugin.citrix.form.header.training' => 'Registrieren Sie sich für die ausgewählten Trainingseinheiten',
    'plugin.citrix.form.header.start.training' => 'Link an eine GoToTraning-Sitzung senden',
    'plugin.citrix.form.header.assist' => 'Link senden, um den Remote-Support von GoToAssist anzufordern',
    'plugin.citrix.action.register.webinar' => 'Für GoToWebinar eintragen',
    'plugin.citrix.action.start.meeting' => 'GoToMeeting starten (Link senden)',
    'plugin.citrix.action.register.training' => 'Für GoToTraining eintragen',
    'plugin.citrix.action.start.training' => 'GoToTraining starten (Link senden)',
    'plugin.citrix.action.screensharing.assist' => 'GoToAssist-Sitzung anfordern (Link senden)',
    'plugin.citrix.webinar.listfield' => 'GoToWebinar - Bevorstehende Webinare',
    'plugin.citrix.meeting.listfield' => 'GoToMeeting- Bevorstehende Meetings',
    'plugin.citrix.training.listfield' => 'GoToTraining - Bevorstehende Sitzungen',
    'plugin.citrix.assist.listfield' => 'GoToAssist - Verfügbare Sitzungen',
    'mautic.form.field.type.plugin.citrix.select.webinar' => 'GoToWebinar - Bevorstehende Webinare',
    'mautic.form.field.type.plugin.citrix.select.meeting' => 'GoToWebinar - Bevorstehende Meetings',
    'mautic.form.field.type.plugin.citrix.select.training' => 'GoToTraining - Bevorstehende Sitzungen',
    'mautic.form.field.type.plugin.citrix.select.assist' => 'GoToAssist - Vergangene Sitzungen',
    'plugin.citrix.webinar.nolongeravailable' => 'Dieses Webinar ist nicht mehr verfügbar',
    'plugin.citrix.meeting.nolongeravailable' => 'Das Meeting ist nicht mehr verfügbar',
    'plugin.citrix.training.nolongeravailable' => 'Diese Schulung ist nicht mehr verfügbar',
    'plugin.citrix.assist.nolongeravailable' => 'Diese Sitzung ist nicht mehr verfügbar',
    'plugin.citrix.decision.criteria' => 'Kontakt Aktion',
    'plugin.citrix.action.criteria' => 'Aktion auswählen',
    'plugin.citrix.campaign.event.webinar.label' => 'GoToWebinar Zustand',
    'plugin.citrix.campaign.event.meeting.label' => 'GoToMeeting Zustand',
    'plugin.citrix.campaign.event.training.label' => 'GoToTraining Zustand',
    'plugin.citrix.campaign.event.assist.label' => 'GoToAssist Zustand',
    'plugin.citrix.campaign.action.webinar.label' => 'GoToWebinar Aktion',
    'plugin.citrix.campaign.action.meeting.label' => 'GoToMeeting Aktion',
    'plugin.citrix.campaign.action.training.label' => 'GoToTraining Aktion',
    'plugin.citrix.campaign.action.assist.label' => 'GoToAssist Aktion',
    'plugin.citrix.event.webinar.registration' => 'Webinar (eingetragen)',
    'plugin.citrix.event.training.registration' => 'Training (eingetragen)',
    'plugin.citrix.event.assist.registration' => 'Assist (eingetragen)',
    'plugin.citrix.event.webinar.attendance' => 'Webinar (teilgenommen)',
    'plugin.citrix.event.meeting.attendance' => 'Meeting (teilgenommen)',
    'plugin.citrix.event.training.attendance' => 'Training (teilgenommen)',
    'plugin.citrix.event.assist.attendance' => 'Assist (teilgenommen)',
    'plugin.citrix.event.webinar.no.attendance' => 'Webinar (nicht teilgenommen)',
    'plugin.citrix.event.meeting.no.attendance' => 'Meeting (nicht teilgenommen)',
    'plugin.citrix.event.training.no.attendance' => 'Training (nicht teilgenommen)',
    'plugin.citrix.event.assist.no.attendance' => 'Assist (nicht teilgenommen)',
    'plugin.citrix.event.webinar.any' => 'Beliebiges Webinar',
    'plugin.citrix.event.meeting.any' => 'Beliebiges Meeting',
    'plugin.citrix.event.training.any' => 'Beliebiges Training',
    'plugin.citrix.event.assist.any' => 'Beliebige Session',
    'plugin.citrix.decision.webinar.list' => 'Webinar Liste',
    'plugin.citrix.decision.meeting.list' => 'Meeting Liste',
    'plugin.citrix.decision.training.list' => 'Training Liste',
    'plugin.citrix.decision.assist.list' => 'Session Liste',
    'plugin.citrix.criteria.webinar.registered' => 'In mindestens einem der folgenden Webinare registriert',
    'plugin.citrix.criteria.training.registered' => 'In mindestens einem der folgenden Trainings registriert',
    'plugin.citrix.criteria.assist.registered' => 'In mindestens einem der folgenden Sessions registriert',
    'plugin.citrix.criteria.webinar.attended' => 'Teilnahme an mindestens einem der folgenden Webinare',
    'plugin.citrix.criteria.meeting.attended' => 'Teilnahme an mindestens einem der folgenden Meetings',
    'plugin.citrix.criteria.training.attended' => 'Teilnahme an mindestens einem der folgenden Trainings',
    'plugin.citrix.criteria.assist.attended' => 'Teilnahme an mindestens einem der folgenden Sessions',
    'plugin.citrix.timeline.webinar.registered' => 'Anmeldung zum Webinar',
    'plugin.citrix.timeline.training.registered' => 'Anmeldung zum Training',
    'plugin.citrix.timeline.assist.registered' => 'Anmeldung zum Assist',
    'plugin.citrix.timeline.webinar.attended' => 'Teilnahme Webinar',
    'plugin.citrix.timeline.meeting.attended' => 'Teilnahme Meeting',
    'plugin.citrix.timeline.training.attended' => 'Teilnahme Training',
    'plugin.citrix.timeline.assist.attended' => 'Teilnahme Assist',
    'plugin.citrix.timeline.meeting.registered' => 'Anmeldung zum Meeting',
    'plugin.citrix.timeline.event.webinar.registered' => 'Registrierung Webinar',
    'plugin.citrix.timeline.event.training.registered' => 'Registrierung Training',
    'plugin.citrix.timeline.event.assist.registered' => 'Registrierung Assist',
    'plugin.citrix.timeline.event.webinar.attended' => 'Anwesenheit Webinar',
    'plugin.citrix.timeline.event.meeting.attended' => 'Anwesenheit Meeting',
    'plugin.citrix.timeline.event.training.attended' => 'Anwesenheit Training',
    'plugin.citrix.timeline.event.assist.attended' => 'Anwesenheit Assist',
    'plugin.citrix.formaction.validator.leadfieldnotfound' => 'Kein Feld stimmt mit dem Kontaktfeld überein \'%s\'. Bitte fügen Sie ein Feld über "Felder" hinzu.',
    'plugin.citrix.formaction.validator.fieldnotfound' => 'Das erforderliche Feld\'%s\' fehlt. Bitte fügen Sie ein Feld über "Felder" hinzu.',
    'plugin.citrix.formaction.validator.fieldshouldberequired' => 'Das Feld  \'%s\' sollte nach Bedarf festgelegt werden. Stellen Sie auf der Registerkarte "Validierung des Felds Erforderlich" "Ja" ein.',
    'mautic.campaign.citrix.event.webinar' => 'GoToWebinar Zustand',
    'mautic.campaign.citrix.event.meeting' => 'GoToMeeting Zustand',
    'mautic.campaign.citrix.event.training' => 'GoToTraining Zustand',
    'mautic.campaign.citrix.event.assist' => 'GoToAssist Zustand',
    'mautic.campaign.citrix.action.webinar' => 'GoToWebinar Aktion',
    'mautic.campaign.citrix.action.meeting' => 'GoToMeeting Aktion',
    'mautic.campaign.citrix.action.training' => 'GoToTraining Aktion',
    'mautic.campaign.citrix.action.assist' => 'GoToAssist Aktion',
    'plugin.citrix.selectproduct.tooltip' => 'Wählen Sie das Ereignis aus, für das dieses Formular gilt',
    'plugin.citrix.selectidentifier' => 'Kontaktfeld E-Mail',
    'plugin.citrix.selectidentifier.tooltip' => 'Wählen Sie das Formularfeld aus, das der E-Mail-Adresse des Kontakts entspricht',
    'plugin.citrix.first_name' => 'Kontaktfeld Vorname',
    'plugin.citrix.first_name.tooltip' => 'Wählen Sie das Formularfeld aus, das dem Vornamen des Kontakts entspricht',
    'plugin.citrix.last_name' => 'Kontaktfeld Nachname',
    'plugin.citrix.last_name.tooltip' => 'Wählen Sie das Formularfeld aus, das dem Nachnamen des Kontakts entspricht',
    'plugin.citrix.token.meeting_button' => 'GoToMeeting Start Button',
    'plugin.citrix.token.training_button' => 'GoToTraining Start Button',
    'plugin.citrix.token.assist_button' => 'GoToAssist Request Session Button',
    'plugin.citrix.token.webinar_button' => 'GoToWebinar Join Button',
    'plugin.citrix.token.webinar_link' => 'GoToWebinar Join URL',
    'plugin.citrix.token.join_webinar' => 'Webinar beitreten',
    'plugin.citrix.emailtemplate' => ' E-Mail-Vorlage senden',
    'plugin.citrix.emailtemplate_descr' => 'Dies ist die E-Mail-Vorlage mit dem Token im Hauptteil, um den Link einzufügen.',
    'plugin.citrix.start.producttext' => 'Klicken Sie hier, um Ihr %s zu starten.',
    'plugin.citrix.webinar.token_error' => 'FEHLER: Ein Token "Join Webinar" ist im E-Mail-Text enthalten, aber in den E-Mail-Segmenten ist kein GotoWebinar-Filter vorhanden',
    'mautic.queue.config.beanstalkd.timeout' => 'Zeitüberschreitung',
    'mautic.queue.config.beanstalkd.timeout.tooltip' => 'Wie lange beanstalkd auf den Server warten soll, bevor das Zeitlimit überschritten wird',
    'mautic.queue.config.host' => 'Host',
    'mautic.queue.config.host.tooltip' => 'Der Hostname des Servers',
    'mautic.queue.config.port' => 'Port',
    'mautic.queue.config.port.tooltip' => 'Der Port, den der Server überwacht',
    'mautic.queue.config.protocol.disabled' => 'deaktiviert',
    'mautic.queue.config.protocol.rabbitmq' => 'RabbitMQ',
    'mautic.queue.config.protocol.beanstalkd' => 'Beanstalkd',
    'mautic.queue.config.protocol' => 'Warteschlangen Protokoll',
    'mautic.queue.config.protocol.tooltip' => 'Dies ist ein erweitertes Setup, welches einem Arbeitswarteschlangen- / Nachrichtenbroker ermöglicht, Seitentreffer und E-Mail-Token außerhalb der Webanforderung zu verarbeiten. Die Arbeitswarteschlange / der Nachrichtenbroker muss konfiguriert sein und außerhalb von Mautic ausgeführt werden, damit dies funktioniert.',
    'mautic.queue.config.rabbitmq.password' => 'Passwort',
    'mautic.queue.config.rabbitmq.password.tooltip' => 'Das Passwort für den RabbitMQ Server',
    'mautic.queue.config.rabbitmq.user' => 'Benutzer',
    'mautic.queue.config.rabbitmq.user.tooltip' => 'Der Benutzername für den RabbitMQ Server',
    'mautic.queue.config.rabbitmq.vhost' => 'virtueller Host',
    'mautic.queue.config.rabbitmq.vhost.tooltip' => 'Der virtuelle Host des RabbitMQ Servers',
    'mautic.config.tab.queueconfig' => 'Warteschlangen Einstelllungen',
    'mautic.config.tab.queue_settings' => 'Warteschlangen Einstelllungen',
    'mautic.campaign.sms.reply' => 'Sendet eine Textnachricht',
    'mautic.campaign.sms.reply.tooltip' => 'Der Kontakt hat eine Textnachricht gesendet oder darauf geantwortet',
    'mautic.campaign.sms.send_text_sms' => 'Textnachricht senden',
    'mautic.sms.timeline.event.custom_sms' => 'Benutzerdefinierte Textnachricht',
    'mautic.campaign.sms.send_text_sms.tooltip' => 'Sendet eine Textnachricht/SMS an den Nutzer.',
    'mautic.lead.list.filter.dnc_bounced_sms' => 'Gebounced - SMS',
    'mautic.lead.list.filter.dnc_unsubscribed_sms' => 'Abgemeldet - SMS',
    'mautic.lead.timeline.sms.sms.reply' => 'Textnachricht vom Kontakt erhalten',
    'mautic.sms.timeline.reply' => 'Textnachricht erhalten',
    'mautic.sms.text' => 'Textnachricht Inhalt',
    'mautic.sms.placeholder' => 'Inhalt Ihrer Nachricht...',
    'mautic.config.tab.smsconfig' => 'Textnachricht Einstellungen',
    'mautic.sms.config.form.sms.enabled' => 'Textnachricht aktiviert?',
    'mautic.sms.config.form.sms.enabled.tooltip' => 'Textnachrichten in Ihren Kampagnen aktivieren?',
    'mautic.sms.config.form.sms.username' => 'Kontodetails',
    'mautic.sms.config.form.sms.username.tooltip' => 'Twilio Account SID',
    'mautic.sms.config.form.sms.password' => 'Twilio Auth Token',
    'mautic.sms.config.form.sms.password.tooltip' => 'Twilio Auth Token',
    'mautic.sms.config.form.sms.messaging_service_sid' => 'Messagingdienst-SID',
    'mautic.sms.config.form.sms.messaging_service_sid.tooltip' => 'Die von Ihrem Anbieter bereitgestellte Nachrichtendienst-ID, die Sie zum Senden und Empfangen von Textnachrichten verwenden.',
    'mautic.sms.config.form.sms.disable_trackable_urls' => 'Klickverfolgung deaktivieren',
    'mautic.sms.config.form.sms.disable_trackable_urls.tooltip' => 'Diese Option deaktiviert die Klickverfolgung für URLs in der Textnachricht.',
    'mautic.sms.sms' => 'Textnachricht',
    'mautic.sms.smses' => 'Textnachrichten',
    'mautic.sms.campaign.send_sms' => 'Push-Textnachricht senden',
    'mautic.sms.campaign.send_sms.tooltip' => 'Sendet eine Push-SMS an den Nutzer.',
    'mautic.sms.choose.smss' => 'Wählen Sie eine SMS zum Senden aus.',
    'mautic.sms.form.action.sendsms.admin' => 'SMS an Nutzer senden',
    'mautic.sms.form.action.sendsms.admin.descr' => 'Sendet die SMS an die ausgewählten Nutzer, nachdem das Formular abgeschickt wurde.',
    'mautic.sms.form.action.sendsms.lead' => 'SMS an Kontakt senden',
    'mautic.sms.form.action.sendsms.lead.descr' => 'Senden Sie die ausgewählte SMS nach dem Senden des Formulars an den Kontakt.',
    'mautic.sms.form.body' => 'Body',
    'mautic.sms.form.confirmbatchdelete' => 'Ausgewählte SMSen löschen?',
    'mautic.sms.form.confirmdelete' => 'SMS %name% löschen?',
    'mautic.sms.form.confirmsend' => 'Queue, %name%, senden?',
    'mautic.sms.form.internal.name' => 'Interner Name',
    'mautic.sms.form.list' => 'Kontaktliste',
    'mautic.sms.form.nbcharacter.counter' => 'Zeichenanzahl:',
    'mautic.sms.form.nbcharacter.infobox' => 'Eine SMS besteht aus 160 Zeichen. Wenn Sie diese Anzahl an Zeichen überschreiten, berechnet Ihnen Ihr SMS-Router in der Regel 2 oder mehr SMS.',
    'mautic.sms.header.edit' => 'Textnachricht bearbeiten - %n',
    'mautic.sms.header.new' => 'Neue Textnachricht',
    'mautic.sms.text.tooltip' => 'Inhalt Ihrer SMS',
    'mautic.sms.headings' => 'Textnachricht Titel',
    'mautic.sms.headings.tooltip' => 'Titel Ihrer SMS',
    'mautic.sms.link' => 'Link',
    'mautic.sms.link.placeholder' => 'http://',
    'mautic.sms.link.tooltip' => 'Wohin soll der Nutzer weitergeleitet werden, wenn er auf die SMS klickt?',
    'mautic.sms.reply_pattern' => 'Muster, dem die Antwort entsprechen sollte',
    'mautic.sms.reply_pattern.tooltip' => 'Gebe das Muster ein, dem die Antwort entsprechen muss, damit diese Entscheidung bestätigt wird. Lasse das Feld leer, um eine Übereinstimmung mit jeder beliebigen Nachricht zu erzielen. Es kann ein Sternchen * als Platzhalter für Zeichenfolgenübereinstimmungen oder ? für ein einzelnes Zeichen verwendet werden. Um die Sternchen oder Fragezeichen selbst zu vergleichen, setze sie in Klammern wie [?].',
    'mautic.sms.stats' => 'Textnachricht Statistiken',
    'mautic.sms.stats.report.table' => 'Gesendete Textnachrichten',
    'mautic.sms.stat.leadcount' => '%count% ausstehend',
    'mautic.sms.stat.readcount' => '%count% gelesen',
    'mautic.sms.stat.sentcount' => '%count% gesendet',
    'mautic.sms.type.header' => 'Welche Art von SMS möchten Sie erstellen?',
    'mautic.sms.type.list' => 'Textnachrichten auflisten',
    'mautic.sms.type.list.header' => 'Segment Textnachricht',
    'mautic.sms.icon_tooltip.list_sms' => 'Ist ein Segment (Broadcast) SMS',
    'mautic.sms.type.list.description' => 'Eine Listen-Textnachricht kann manuell an ausgewählte Lead-Listen gesendet werden. Wenn die SMS versendet worden ist, kann sie nicht mehr bearbeitet werden. Sie kann aber an neue Leads gesendet werden, die zu der verbundenen Liste hinzugefügt werden.',
    'mautic.sms.type.template' => 'Vorlagen-Textnachrichten',
    'mautic.sms.type.template.header' => 'Template Textnachricht',
    'mautic.sms.type.template.description' => 'Eine Vorlagen-SMS wird von Kampagnen, Formularen, Punkt-Triggern, usw. automatisch verschickt. Sie kann bearbeitet, aber nicht an eine Kontakt-Liste geschickt werden.',
    'mautic.sms.form.internal.description' => 'Beschreibung',
    'mautic.sms.form.heading' => 'Überschrift',
    'mautic.sms.form.url' => 'Link',
    'mautic.sms.form.url.tooltip' => 'Das Ziel, zu dem der Nutzer geschickt wird, wenn er auf die SMS klickt.',
    'mautic.sms.form.message' => 'Textnachricht',
    'mautic.sms.send.selectsmses' => 'Textnachricht auswählen',
    'mautic.sms.choose.smses' => 'Wählen Sie die SMS, die Sie an den Nutzer senden möchten.',
    'mautic.sms.send.new.sms' => 'Neue Textnachricht',
    'mautic.sms.send.edit.sms' => 'Textnachricht bearbeiten',
    'mautic.sms.send.preview.sms' => 'Vorschau Textnachricht',
    'mautic.sms.send.selectsmss' => 'Nachricht auswählen',
    'mautic.sms.no.smses.note' => 'Bitte erstellen Sie eine neue Textnachricht zur Auswahl.',
    'mautic.sms.smses.header.preview' => 'Vorschau Textnachricht',
    'mautic.sms.preview' => 'Vorschau',
    'mautic.sms.timeline.status' => 'Status',
    'mautic.sms.timeline.type' => 'Typ',
    'mautic.sms.timeline.status.delivered' => 'Zugestellt',
    'mautic.sms.timeline.status.sent' => 'Gesendet',
    'mautic.sms.timeline.status.failed' => 'Fehlgeschlagen',
    'mautic.sms.timeline.status.scheduled' => 'Geplant',
    'mautic.sms.timeline.content.heading' => 'Inhalt der Nachricht',
    'mautic.sms.timeline.event.list' => 'An diesen Kontakt wurde eine Textnachricht gesendet, da er zum Segment „%list%“ gehört.',
    'mautic.sms.timeline.event.failed' => 'Senden der Textnachricht fehlgeschlagen',
    'mautic.sms.disabled' => 'Textnachrichten sind momentan deaktiviert',
    'mautic.sms.enable.in.configuration' => 'Aktivieren und konfigurieren Sie Textnachrichten in der Mautic Konfiguration.',
    'mautic.sms.create.in.campaign.builder' => 'Keine Ergebnisse! Passen Sie den Filter an (wenn vorhanden) oder erstellen Sie im Kampagnen-Builder einen neuen.',
    'mautic.sms.campaign.failed.not_contactable' => 'Der Kontakt ist nicht per SMS erreichbar.',
    'mautic.sms.campaign.failed.missing_number' => 'Fehlende Telefonnummer für den Kontakt.',
    'mautic.sms.campaign.failed.missing_entity' => 'Die angegebene SMS-Objekt existiert nicht.',
    'mautic.sms.campaign.failed.unpublished' => 'Die angegebene SMS ist nicht mehr veröffentlicht.',
    'mautic.sms.show.total.sent' => 'Gesamt gesendet',
    'mautic.sms.show.failed' => 'Fehlgeschlagen',
    'mautic.sms.permissions.header' => 'Berechtigungen für Textnachrichten',
    'mautic.sms.permissions.smses' => 'Textnachrichten, auf die der User zugreifen darf',
    'mautic.sms.list.frequency.number' => 'Nicht öfter Textnachricht senden als',
    'mautic.sms.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (kommagetrennte IDs, ohne Leerstellen)',
    'mautic.sms.config.select_default_transport' => 'Wählen Sie den zu verwendenden Standardtransport aus',
    'mautic.sms.config.no_transport' => 'Kein Transport wurde aktiviert',
    'mautic.sms.config.choose_transport' => 'Transport wählen',
    'mautic.sms.config.smsconfig' => 'Bitte erst den Nachrichten-Transport installieren.',
    'mautic.sms.transport.twilio' => 'Twilio',
    'mautic.sms.transport.twilio.not_configured' => 'Twilio ist nicht konfiguriert.',
    'mautic.sms.webhook.event.send' => 'Textnachricht gesendet Ereignis',
    'mautic.sms.token.dropdown.hint' => 'Hinweis: Wenn man im Textnachrichtenbereich { eingibt, wird ein Token-Dropdown-Menü angezeigt.',
    'mautic.user.account.header.authorizedclients' => 'Autorisierte Anwendungen',
    'mautic.user.account.header.details' => 'Account Details',
    'mautic.user.account.permissions.editall' => 'Alle',
    'mautic.user.account.permissions.editemail' => 'E-Mail',
    'mautic.user.account.permissions.editname' => 'Name',
    'mautic.user.account.permissions.editposition' => 'Position',
    'mautic.user.account.permissions.editusername' => 'Benutzername',
    'mautic.user.account.settings' => 'Account',
    'mautic.user.auth.error.invalidlogin' => 'Falsches Login. Bitte überprüfen Sie Ihre Eingabe.',
    'mautic.user.auth.expired.header' => 'Session abgelaufen - bitte anmelden',
    'mautic.user.auth.form.loginbtn' => 'Login',
    'mautic.user.auth.form.loginusername' => 'Benutzername oder E-Mail',
    'mautic.user.auth.form.rememberme' => 'eingeloggt bleiben',
    'mautic.user.auth.form.rolename' => 'Name der Rolle',
    'mautic.user.auth.header' => 'Bitte anmelden',
    'mautic.user.auth.logout' => 'Abmelden',
    'mautic.user.permissions.header' => 'User-Berechtigungen',
    'mautic.user.permissions.profile' => 'Profil - User kann ändern',
    'mautic.user.permissions.roles' => 'Rollen - auf die der User Zugriff hat',
    'mautic.user.permissions.users' => 'User - auf die der User Zugriff hat',
    'mautic.user.role' => 'Rolle',
    'mautic.user.role.form.confirmbatchdelete' => 'Ausgewählte Rolle löschen?',
    'mautic.user.role.form.confirmdelete' => 'Die Rolle %name% löschen?',
    'mautic.user.role.form.isadmin' => 'Hat Vollzugriff?',
    'mautic.user.role.form.isadmin.tooltip' => 'Wenn \'Ja\', dann hat jeder User mit dieser Rolle Vollzugriff auf das System. Wenn \'Nein\', dann legen Sie die Berechtigungen im Reiter \'Berechtigungen\' fest.',
    'mautic.user.role.header.edit' => 'Rollen - %name% ändern',
    'mautic.user.role.header.new' => 'Rollen - Neue Rolle',
    'mautic.user.role.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (kommagetrennte IDs, ohne Leerstellen)<br />is:admin<br />name:*',
    'mautic.user.role.permission.isadmin.header' => 'Vollzugriff',
    'mautic.user.role.permission.isadmin.message' => 'Diese Rolle hat Vollzugriff. Um individuelle Berechtigungen zu vergeben deaktivieren Sie den Vollzugriff im Reiter \'Details\'',
    'mautic.user.role.permissions' => 'Berechtigungen',
    'mautic.user.role.usercount' => 'Anzahl User mit dieser Rolle',
    'mautic.user.roles' => 'Rollen',
    'mautic.user_management' => 'Benutzerverwaltung',
    'mautic.user.role.list.viewusers_count' => '{0} Keine Benutzer|{1} Ansicht 1 Benutzer|]1,Inf[ Ansicht %count% Benutzer',
    'mautic.user.role.list.thead.usercount' => 'Nutzeranzahl',
    'mautic.user.user.contact.locked' => '%entityName% erfordert einen Unlock',
    'mautic.user.user.contact.message' => 'Nachricht',
    'mautic.user.user.contact.regarding' => 'in Bezug auf %entityName%',
    'mautic.user.user.contact.send' => 'Senden',
    'mautic.user.user.filter.email' => 'Nach E-Mail',
    'mautic.user.user.filter.name' => 'Nach Name',
    'mautic.user.user.filter.role' => 'Nach Rolle',
    'mautic.user.user.filter.username' => 'Nach User-Name',
    'mautic.user.user.form.confirmbatchdelete' => 'Die ausgewählten Nutzer löschen?',
    'mautic.user.user.form.confirmdelete' => 'Den Account %name% löschen?',
    'mautic.user.user.form.defaultlocale' => 'Standard-System-Locale',
    'mautic.user.user.form.defaulttimezone' => 'Standardzeitzone des Systems',
    'mautic.user.user.form.help.passwordrequirements' => 'Das Passwort muss mindestens 6 Zeichen lang sein und sollte eine Kombination aus Groß- und Kleinbuchstaben, Sonderzeichen und Zahlen enthalten.',
    'mautic.user.user.form.passwordconfirm' => 'Passwort bestätigen',
    'mautic.user.user.form.passwordplaceholder' => 'Bei keinen Änderungen leer lassen',
    'mautic.user.user.header.contact' => 'Sende Nachricht an %name%',
    'mautic.user.user.header.edit' => 'User - %name% ändern',
    'mautic.user.user.header.new' => 'User - Neuer User',
    'mautic.user.user.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (Kommagetrennte IDs, keine Leerzeichen)<br />is:admin<br />is:active<br />is:inactive<br />email:*<br />name:*<br />position:*<br />role:*<br />username:*',
    'mautic.user.user.passwordreset.back' => 'zurück zum Login',
    'mautic.user.user.passwordreset.body' => 'Hallo %name%,\\n\\nIhr neues Passwort lautet \\n%password%\\n\\nEs wird empfohlen, dass Sie nach dem Einloggen Ihr Passwort sofort ändern.',
    'mautic.user.user.passwordreset.email.body' => 'Hallo %name%,\\n\\nSie haben ein neues Passwort angefordert. Klicken Sie auf den folgenden Link, um Ihr Passwort zurückzusetzen.\\n\\n%resetlink%',
    'mautic.user.user.passwordreset.info' => 'Geben Sie Ihren Benutzernamen oder Ihre E-Mail-Adresse an, um Ihr Passwort zurückzusetzen. Sie erhalten dann weitere Anweisungen per E-Mail.',
    'mautic.user.user.passwordresetconfirm.info' => 'Geben Sie Ihren Benutzernamen oder Ihre E-Mail-Adresse und ein neues Passwort an, um den Vorgang abzuschließen.',
    'mautic.user.user.passwordreset.link' => 'Haben Sie Ihr Passwort vergessen?',
    'mautic.user.user.passwordreset.reset' => 'Passwort zurücksetzen',
    'mautic.user.user.passwordreset.subject' => 'Mautic Passwort zurücksetzen',
    'mautic.user.user.passwordreset.password.placeholder' => 'Passwort',
    'mautic.user.user.passwordreset.confirm.placeholder' => 'Passwort bestätigen',
    'mautic.user.user.searchcommand.isadmin' => 'is:admin',
    'mautic.user.user.searchcommand.position' => 'Position',
    'mautic.user.user.searchcommand.role' => 'Rolle',
    'mautic.user.user.searchcommand.username' => 'Benutzername',
    'mautic.user.users' => 'User',
    'mautic.config.tab.userconfig' => 'Benutzer-/Autentifizierungs-Einstellungen',
    'mautic.user.config.form.saml.idp_attributes' => 'Geben Sie die Namen der Attribute ein, die der konfigurierte IDP für die folgenden Mautic-Benutzerfelder verwendet.',
    'mautic.user.config.form.saml.idp.attribute_email' => 'E-Mail',
    'mautic.user.config.form.saml.idp.attribute_username' => 'Benutzername (optional)',
    'mautic.user.config.form.saml.idp.attribute_firstname' => 'Vorname',
    'mautic.user.config.form.saml.idp.attribute_lastname' => 'Nachname',
    'mautic.user.config.form.saml.idp_entity_id_label' => 'Entity ID für den IDP',
    'mautic.user.config.form.saml.idp.default_role' => 'Standardrolle für neu angelegte benutzer',
    'mautic.user.config.form.saml.idp.default_role.tooltip' => 'Wählen Sie die Standardrolle, um neu erstellte Benutzer zuzuweisen. Um das Erstellen von Benutzern zu deaktivieren, löschen Sie die ausgewählte Rolle und lassen Sie das Feld leer.',
    'mautic.user.config.form.saml.idp.disable_creation' => 'Leer lassen, um die Benutzererstellung zu deaktivieren',
    'mautic.user.config.form.saml.idp.metadata' => 'Metadaten-Datei des Identitätsanbieters',
    'mautic.user.config.form.saml.idp.metadata.tooltip' => 'Laden Sie die XML-Datei für Identity Provider-Metadaten hoch.',
    'mautic.user.config.form.saml.idp.own_certificate.description' => 'Verwenden Sie ein benutzerdefiniertes X.509-Zertifikat und einen privaten Schlüssel, um die Kommunikation zwischen Mautic und dem IDP zu sichern.',
    'mautic.user.config.form.saml.idp.own_certificate' => 'X.509-Zertifikat',
    'mautic.user.config.form.saml.idp.own_certificate.tooltip' => 'Laden Sie ein benutzerdefiniertes X.509-Zertifikat hoch, um die Kommunikation zwischen IDP und Mautic zu sichern.',
    'mautic.user.config.form.saml.idp.own_entity_id' => 'Entitäts-ID',
    'mautic.user.config.form.saml.idp.own_private_key' => 'Privater Schlüssel',
    'mautic.user.config.form.saml.idp.own_private_key.tooltip' => 'Laden Sie den privaten Schlüssel für das Zertifikat hoch, um die Kommunikation zwischen IDP und Mautic zu sichern.',
    'mautic.user.config.form.saml.idp.own_password' => 'Privates verschlüsseltes Passwort',
    'mautic.user.config.form.saml.idp.own_password.tooltip' => 'Falls der private Schlüssel mit einem Passwort verschlüsselt ist, geben Sie es hier an.',
    'mautic.user.config.header.saml' => 'SAML SSO Einstellungen',
    'mautic.user.config.title.get_to_know_you' => 'Lernen wir dich kennen',
    'mautic.user.config.title.account_data_security' => 'Kontodaten und Sicherheit',
    'mautic.user.config.title.locale' => 'Ort',
    'mautic.user.config.title.personal_information' => 'Persönliche Informationen',
    'mautic.user.config.personalize.interface.helper' => 'Verwalten Sie Details, die zur Personalisierung Ihrer Interface Expirience verwendet werden.',
    'mautic.user.config.account.security.helper' => 'Passen die Anmeldeinformationen an, um die Sicherheit des Kontos zu gewährleisten.',
    'mautic.user.config.region.preferences.helper' => 'Lege Einstellungen für die Region fest.',
    'mautic.user.config.signature.helper' => 'Sie können die Variable |FROM_NAME| in Ihrer Signatur verwenden, um den Namen des Absenders automatisch einzufügen.',
    'mautic.user.config.signature.admin.helper' => 'Verwende |FROM_NAME| in der Signatur, um den Namen des Benutzers automatisch einzufügen.',
    'mautic.user.user.form.user' => 'Benutzer',
    'mautic.user.user.form.created_by' => 'wurde erstellt durch',
    'mautic.user.user.form.updated_by' => 'Aktualisiert von',
    'mautic.user.user.form.login_by' => 'eingeloggt',
    'mautic.user.lastlogin' => 'Letzte Anmeldung',
    'mautic.user.user.form.update_user_status' => 'Informationen durch',
    'mautic.user.user.form.update_update' => 'Aktualisiert',
    'mautic.core.form.active' => 'Aktiv',
    'mautic.core.form.inactive' => 'Inaktiv',
    'mautic.role.role' => 'Rolle',
    'mautic.user.role.form.updated_by' => 'wurde aktualisiert durch',
    'mautic.dashboard.confirmation_layout_name' => 'Geben Sie einen Namen für dieses Dashboard an:',
    'mautic.dashboard.create.past.tense' => 'erzeugt',
    'mautic.dashboard.delete_layout' => 'Dieses Layout löschen?',
    'mautic.dashboard.delete.past.tense' => 'gelöscht',
    'mautic.dashboard.generated_by' => 'Erstellt von %name% am %date%',
    'mautic.dashboard.header.index' => 'Dashboard',
    'mautic.dashboard.identified.past.tense' => 'erkannt',
    'mautic.dashboard.ipadded.past.tense' => 'IP hinzugefügt',
    'mautic.dashboard.label.downloads' => 'Downloads',
    'mautic.dashboard.label.hits' => 'Treffer',
    'mautic.dashboard.label.lang' => 'Sprache',
    'mautic.dashboard.label.title' => 'Titel',
    'mautic.dashboard.menu.index' => 'Dashboard',
    'mautic.dashboard.update.past.tense' => 'aktualisiert',
    'mautic.note.no.upcoming.emails' => 'Es sind keine E-Mails zu versenden',
    'mautic.dashboard.label.created.leads' => 'Erstellte Kontakte',
    'mautic.dashboard.label.url' => 'URL',
    'mautic.dashboard.label.unique.hit.count' => 'Eindeutige Zugriffe',
    'mautic.dashboard.label.total.hit.count' => 'Gesamtzahl der Treffer',
    'mautic.dashboard.label.email.id' => 'E-Mail ID',
    'mautic.dashboard.label.email.name' => 'E-Mail',
    'mautic.dashboard.label.contact.id' => 'Kontakt-ID',
    'mautic.dashboard.label.contact.email.address' => 'Kontakt E-Mail',
    'mautic.dashboard.label.contact.open' => 'Kontakt offen',
    'mautic.dashboard.label.contact.click' => 'Klicks',
    'mautic.dashboard.label.contact.links.clicked' => 'Klicks auf Links',
    'mautic.dashboard.label.segment.id' => 'Segment ID',
    'mautic.dashboard.label.segment.name' => 'Segment-Name',
    'mautic.dashboard.label.company.id' => 'Unternehmens-ID',
    'mautic.dashboard.label.company.name' => 'Firmenname',
    'mautic.dashboard.label.campaign.id' => 'Unternehmens-ID',
    'mautic.dashboard.label.campaign.name' => 'Kampagnen-Name',
    'mautic.dashboard.widget.add' => 'Widget hinzufügen',
    'mautic.dashboard.export.widgets' => 'Export',
    'mautic.dashboard.save_as_predefined' => 'Als vordefiniert speichern',
    'mautic.dashboard.widget.import' => 'Importieren oder auswählen von vordefinierten',
    'mautic.dashboard.widget.form.name' => 'Name',
    'mautic.dashboard.widget.form.type' => 'Typ',
    'mautic.dashboard.widget.form.width' => 'Breite',
    'mautic.dashboard.widget.form.height' => 'Höhe',
    'mautic.dashboard.widget.form.ordering' => 'Platzieren vor',
    'mautic.dashboard.widget.ordering.last' => 'Letztes',
    'mautic.dashboard.widget.header.edit' => 'Widget ändern',
    'mautic.dashboard.widget.header.new' => 'Neues Widget',
    'mautic.dashboard.widget.header.delete' => 'Widget löschen',
    'mautic.dashboard.widget.load.time' => 'Daten in %time% ms geladen',
    'mautic.dashboard.widget.data.loaded.from.cache' => 'aus Cache',
    'mautic.dashboard.widget.data.loaded.from.database' => 'aus Datenbank',
    'mautic.dashboard.widget.size.extra_small' => 'Extra klein (215px)',
    'mautic.dashboard.widget.size.small' => 'Klein (330px)',
    'mautic.dashboard.widget.size.medium' => 'Mittel (445px)',
    'mautic.dashboard.widget.size.large' => 'Gross (560px)',
    'mautic.dashboard.widget.size.extra_large' => 'Extra Gross (675px)',
    'mautic.dashboard.import' => 'Vordefiniertes Dashboard importieren',
    'mautic.dashboard.predefined' => 'Vordefinierte Dashboards',
    'mautic.dashboard.import.start.instructions' => 'Vordefiniertes Dashboard hochladen',
    'mautic.dashboard.widgets.preview' => 'Vorschau des ausgewählten vordefinierten Dashboards',
    'mautic.dashboard.date.from' => 'Von',
    'mautic.dashboard.date.to' => 'bis',
    'mautic.dashboard.nowidgets.tip.header' => 'Hallo!',
    'mautic.dashboard.nowidgets.tip' => 'Es befinden sich noch keine Widgets in Ihrem Dashboard. Aber keine Sorge, Sie können Widgets über den "Widget hinzufügen"-Button einfügen, einen "Import" starten oder',
    'mautic.dashboard.missing.permission' => 'Sie haben nicht die nötigen Rechte, um die Daten des %section%-Bereichs zu sehen.',
    'mautic.dashboard.preview' => 'Vorschau',
    'mautic.dashboard.phpversionwarning.title' => 'Bitte aktualisiere die PHP-Version',
    'mautic.dashboard.phpversionwarning.body' => 'Sie verwenden derzeit PHP %phpversion%, eine veraltete und unsichere Version von PHP. Zukünftige Versionen von Mautic werden diese Version nicht mehr unterstützen.<br>Eine Übersicht über die unterstützten PHP-Versionen pro Mautic-Version finden Sie auf <a target="_blank" href="https://www.mautic.org/download/requirements">der Mautic-Website</a>.',
    'mautic.sqlConditions' => 'SQL-Bedingungen',
    'mautic.sqlConditions.manage' => 'SQL-Bedingungen verwalten',
    'mautic.sqlConditions.sql' => 'SQL',
    'mautic.crontester.form.path_to_mautic_console' => 'Pfad zur Mautic Konsole',
    'mautic.crontester.rebuild.segment' => 'Segment aktualisieren',
    'mautic.crontester.rebuild.campaign' => 'Kampagne aktualisieren',
    'mautic.crontester.trigger.campaign' => 'Kampagne anstossen',
    'mautic.category.createnew' => 'Eine neue Kategorie anlegen...',
    'mautic.category.form.alias.help' => 'Buchstaben und Zahlen (Bindestriche zulässig), die zur URL-Generierung dieser Kategorie verwendet werden. Wenn das Feld leer gelassen wird, wird automatisch ein eindeutiger Alias ​​basierend auf dem Titel generiert.',
    'mautic.category.form.confirmbatchdelete' => 'Möchten Sie die ausgewählten Kategorien löschen? Verknüpfte Elemente werden NICHT gelöscht sondern als \'nicht kategorisiert\' markiert.',
    'mautic.category.form.confirmdelete' => 'Möchten Sie die Kategorie %name% löschen? Verknüpfte Elemente werden NICHT gelöscht sondern als \'nicht kategorisiert\' markiert.',
    'mautic.category.global' => 'global',
    'mautic.category.header.edit' => '%type% Kategorie bearbeiten - %name%',
    'mautic.category.header.index' => 'Kategorien',
    'mautic.category.header.new' => 'Neue Kategorie',
    'mautic.category.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (Komma-getrennte IDs, keine Leerzeichen)<br />is:published (Verfügbar zur Nutzung)<br />is:unpublished (Nicht verfügbar)',
    'mautic.category.menu.index' => 'Kategorien',
    'mautic.category.noresults.tip' => 'Kategorien helfen, Elemente zu organisieren und zu gruppieren. In vielen Filtern können Sie Kategorie:{alias} eingeben (Ersetzen Sie {alias} mit dem richtigen Namen), um alle Elemente in dieser Kategorie anzuzeigen.',
    'mautic.category.permissions.categories' => 'Kategorien, auf die der User Zugriff hat',
    'mautic.category.permissions.header' => 'Kategorie-Berechtigungen',
    'mautic.global.global' => 'global',
    'mautic.focus.permissions.items' => 'Focus Items, auf die der User Zugriff hat',
    'mautic.focus.permissions.header' => 'Fokus Berechtigungen',
    'mautic.focus.form.confirmbatchdelete' => 'Löschen der ausgewählten Focus Items?',
    'mautic.focus' => 'Focus Items',
    'mautic.focus.edit' => '%name% ändern',
    'mautic.focus.fetch_snapshot' => 'Erzeugen',
    'mautic.focus.focus_items' => 'Focus Items',
    'mautic.focus.details.views' => 'Aufrufe',
    'mautic.focus.details.unique_views' => 'Eindeutige Aufrufe',
    'mautic.focus.form.activate_for_links' => 'Link-Klicks aktivieren?',
    'mautic.focus.form.animate' => 'Animieren?',
    'mautic.focus.form.bar.allow_hide' => 'Verbergen zulassen?',
    'mautic.focus.form.bar.push_page.tooltip' => 'Wenn Nein eingestellt ist, überschneidet der Balken sich mit dem Seiteninhalt.',
    'mautic.focus.form.bar.push_page' => 'Seite nach unten pushen?',
    'mautic.focus.form.bar.size.large' => 'Groß; 50px Höhe und 17pt Schrift',
    'mautic.focus.form.bar.size.regular' => 'Regulär; 30px Höhe und 14pt Schrift',
    'mautic.focus.form.bar.size' => 'Höhe',
    'mautic.focus.form.bar.sticky.tooltip' => 'Wenn ja, ist der Balken beim Scrollen immer vorhanden.',
    'mautic.focus.form.bar.sticky' => 'Soll Haften bleiben?',
    'mautic.focus.form.button_color' => 'Buttonfarbe',
    'mautic.focus.form.button_text_color' => 'Button Textfarbe',
    'mautic.focus.form.choose_form' => 'Einzufügendes Formular auswählen',
    'mautic.focus.form.engage_after_conversion.tooltip' => 'Wenn Ja eingestellt ist und der Besucher das Formular übermittelt oder auf den Link klickt, wird der Fokus nicht länger für angezeigt, bis der Besucher seine Cookies löscht.',
    'mautic.focus.form.engage_after_conversion' => 'Interaktionen nach Konvertierung stoppen?',
    'mautic.focus.form.stop_after_close.tooltip' => 'Wenn die Einstellung auf „Ja“ gesetzt ist und der Besucher den Fokus direkt schließt, wird der Fokus erst wieder angezeigt, wenn der Besucher seine Cookies löscht.',
    'mautic.focus.form.stop_after_close' => 'Interaktionen nach Schliessen vom Fokus stoppen?',
    'mautic.focus.form.font' => 'Font',
    'mautic.focus.form_token.instructions' => 'Füge <strong>{focus_form}</strong> in den obigen Content ein, um das ausgewählte Formular einzufügen.',
    'mautic.focus.form.frequency.daily' => 'Einmal täglich',
    'mautic.focus.form.frequency.everypage' => 'Jede Seite',
    'mautic.focus.form.frequency.hourly' => 'Einmal stündlich',
    'mautic.focus.form.frequency.once' => 'Einmal pro Session',
    'mautic.focus.form.frequency.q15m' => 'Alle 15 Minuten',
    'mautic.focus.form.frequency.q2m' => 'Alle 2 Minuten',
    'mautic.focus.form.frequency.help' => 'Wenn „Einmal pro Sitzung“ ausgewählt ist, wird das Fokuselement einmal für jede aktive Browsersitzung angezeigt, die endet, wenn ein Besucher Ihre Website verlässt.',
    'mautic.focus.form.frequency' => 'Wie oft interagieren?',
    'mautic.focus.form.custom.css' => 'Benutzerdefiniertes CSS',
    'mautic.focus.form.custom.css.help' => 'Geben Sie Ihre benutzerdefinierten Stile ein, ohne <&#8239;style&#8239;> Tags',
    'mautic.focus.form.headline' => 'Überschrift',
    'mautic.focus.form.link_new_window' => 'Link in neuem Fenster öffnen?',
    'mautic.focus.form.link_text' => 'Linktext',
    'mautic.focus.form.link_url' => 'Link-URL',
    'mautic.focus.form.placement.bottom_left' => 'Unten Links',
    'mautic.focus.form.placement.bottom_right' => 'Unten Rechts',
    'mautic.focus.form.placement.bottom' => 'Unten',
    'mautic.focus.form.placement.middle' => 'Mitte',
    'mautic.focus.form.placement.top_left' => 'Oben Links',
    'mautic.focus.form.placement.top_right' => 'Oben Rechts',
    'mautic.focus.form.placement.top' => 'Oben',
    'mautic.focus.form.placement.help' => 'Aktiviere „Sticky“, um die Leiste am unteren Rand des Ansichtsfensters zu fixieren, oder deaktiviere es, um sie am Ende der Seite zu platzieren.',
    'mautic.focus.form.placement' => 'Platzierung',
    'mautic.focus.form.primary_color' => 'Primärfarbe',
    'mautic.focus.form.style' => 'Welcher Style soll verwendet werden?',
    'mautic.focus.form.tagline' => 'Tagline',
    'mautic.focus.form.text_color' => 'Textfarbe',
    'mautic.focus.form.type.form_description' => 'Verwenden Sie ein Mautic-Formular, um Daten vom Besucher zu sammeln.',
    'mautic.focus.form.type.form' => 'Daten sammeln',
    'mautic.focus.form.type.link_description' => 'Bitten Sie Besucher, auf eine bestimmte URL zu klicken.',
    'mautic.focus.form.type.link' => 'Einen Link hervorheben',
    'mautic.focus.form.type.notice_description' => 'Mitteilung für Besucher anzeigen',
    'mautic.focus.form.type.notice' => 'Mitteilung anzeigen',
    'mautic.focus.form.type.tooltip' => 'Wählen Sie aus, welche Art von Fokus gewünscht wird.',
    'mautic.focus.form.type' => 'Was soll der Fokus sein?',
    'mautic.focus.form.html_mode.tooltip' => 'Im HTML-Modus können Sie Ihren benutzerdefinierten HTML-Code zu Focus hinzufügen.',
    'mautic.focus.form.html_mode' => 'Inhaltsmodus',
    'mautic.focus.form.basic' => 'Basic',
    'mautic.focus.form.editor' => 'Bearbeiter',
    'mautic.focus.form.html' => 'HTML',
    'mautic.focus.form.website.tooltip' => 'Geben Sie Ihre Website ein, damit Mautic einen Screenshot erstellen und ein Beispiel anzeigen kann.',
    'mautic.focus.form.website' => 'Webseite',
    'mautic.focus.form.when.5seconds' => '5 Sekunden Verzögerung',
    'mautic.focus.form.when.immediately' => 'Bei Ankunft',
    'mautic.focus.form.when.leave' => 'Besucher beabsichtigt zu gehen',
    'mautic.focus.form.when.minute' => 'Eine Minute Verspätung',
    'mautic.focus.form.when.scroll_bottom' => 'Nach dem Scrollen nach unten',
    'mautic.focus.form.when.scroll_middle' => 'Nach dem Scrollen zur Mitte',
    'mautic.focus.form.when.scroll_slight' => 'Nach leichtem Scrollen nach unten',
    'mautic.focus.form.timeout' => 'Timeout vor Eingriff',
    'mautic.focus.form.timeout.seconds' => 'sek.',
    'mautic.focus.form.when' => 'Wann interagieren?',
    'mautic.focus.graph.clicks' => 'Klicks',
    'mautic.focus.graph.stats' => 'Focus Statistik',
    'mautic.focus.graph.submissions' => 'Submissions',
    'mautic.focus.graph.views' => 'Aufrufe',
    'mautic.focus.install.description' => 'Kopiere diese Codezeile in Ihre Site, vorzugsweise direkt vor den schließenden Body-Tag. Alternativ kann dieses Fokuselement durch eine Kampagnenaktion als Reaktion auf einen Seitenaufruf auf einer Seite angezeigt werden, die das Mautic-Tracking-Skript enthält.',
    'mautic.focus.install.header' => 'Focus Installation',
    'mautic.focus.new' => 'Neuer Fokus',
    'mautic.focus.noresults.tip' => 'Wecken Sie mit Fokus-Formularen, Fokus-Klicks oder Fokus-Mitteilungen die Aufmerksamkeit der Besucher auf Ihrer Website.',
    'mautic.focus.style.bar_description' => 'Zeigt eine Leiste am oberen Rand der Seite an.',
    'mautic.focus.style.bar' => 'Leiste',
    'mautic.focus.style.modal_description' => ' Popup in der Mitte der Seite anzeigen.',
    'mautic.focus.style.modal' => 'Modal',
    'mautic.focus.style.notification_description' => 'Zeigt ein kleines Fenster in einer Ecke der Seite an.',
    'mautic.focus.style.notification' => 'Benachrichtigung',
    'mautic.focus.style.page_description' => 'Zeigt ein Fenster an, welches die gesamte Seite abdeckt.',
    'mautic.focus.style.page' => 'Vollständige Seite',
    'mautic.focus.tab.focus_colors' => 'Farben',
    'mautic.focus.tab.focus_content' => 'Inhalt',
    'mautic.focus.tab.focus_style' => 'Style',
    'mautic.focus.tab.focus_type' => 'Fokus',
    'mautic.focus.thead.style' => 'Fokusstyle',
    'mautic.focus.thead.type' => 'Fokustyp',
    'mautic.focus.type.form' => 'Formular',
    'mautic.focus.type.link' => 'Link',
    'mautic.focus.type.notice' => 'Notiz',
    'mautic.focus.website_placeholder' => 'Geben Sie unten eine Website ein und Sie sehen in Echtzeit, wie Ihr Focus Item auf Ihrer Website aussehen wird, während Sie es erstellen!',
    'mautic.focums.html_mode.tooltip' => 'Wählen Sie einen Modus aus. Der Inhalt wird beim Wechseln zwischen den Modi nicht übernommen',
    'mautic.focus.campaign.event.show_focus' => 'Focus Item zeigen',
    'mautic.focus.campaign.event.show_focus_descr' => 'Focus Item Auslösen',
    'mautic.focus.no.focusitem.note' => 'Es gibt keine Focus Items zur Auswahl. Erstellen Sie zuerst welche.',
    'mautic.focus.focusitem.selectitem' => 'Focus Item auswählen',
    'mautic.focus.focusitem.selectitem_descr' => 'Focus Item auswählen',
    'mautic.focus.show.new.item' => 'Neuer Focus Item',
    'mautic.focus.show.edit.item' => 'Focus Item bearbeiten',
    'mautic.focus.show.preview.item' => 'Vorschau Focus Item ',
    'mautic.campaign.focus.show' => 'Focus Item',
    'mautic.focus.form.confirmdelete' => 'Focus Item löschen, %name%?',
    'mautic.focus.protocol.mismatch' => 'Diese Site kann nicht in der Vorschau angezeigt werden, da sie nicht sicher ist. Bitte versuche es mit %url%.',
    'mautic.focus.blocking.iframe.header' => 'Diese Website blockiert Iframe-Vorschauen mit dem Header %header%. Bitte versuche es mit einer anderen URL.',
    'mautic.focus.event.view' => 'Fokus Ansicht',
    'mautic.focus.view' => 'Fokus Ansicht',
    'mautic.focus.event.click' => 'Fokus Klick',
    'mautic.focus.click' => 'Fokus Klick',
    'mautic.channel.messages' => 'Marketingmitteilung',
    'mautic.channel.message.all_contacts' => 'Die Mitteilung wurde an die folgenden Kontakte gesendet.',
    'mautic.channel.message.channel_contacts' => 'Dieser Kanal wurde für die folgenden Kontakte während der ausgewählten Zeitspanne oberhalb verwendet.',
    'mautic.channel.message.header.new' => 'Neue Marketingmitteilung',
    'mautic.channel.message.failed' => 'Kein Channel konnte die Nachricht erfolgreich senden.',
    'mautic.channel.message.form.message' => 'Nachricht',
    'mautic.channel.message.form.enabled' => 'Aktiviert?',
    'mautic.channel.message.send.attempts' => 'Versuche',
    'mautic.channel.message.send.attempts.tooltip' => 'Anzahl Neuversuche wenn der Versand fehlgeschlagen ist',
    'mautic.channel.message.send.priority' => 'Priorität',
    'mautic.channel.message.send.priority.high' => 'Hoch',
    'mautic.channel.message.send.priority.normal' => 'Normal',
    'mautic.channel.message.send.priority.tooltip' => 'Mitteilungen mit hoher Priorität werden vor den erneut geplanten Mitteilungen verarbeitet',
    'mautic.channel.permissions.header' => 'Kanal Berechtigungen',
    'mautic.channel.permissions.messages' => 'Marketingmitteilungen - Benutzer haben Zugiff zu',
    'mautic.channel.form.additem' => 'Leider wurde nichts gefunden. Ändere das durch die Erstellung eines neuen Elementes.',
    'mautic.channel.campaign.event.send' => 'Sende eine Marketingmitteilung',
    'mautic.channel.campaign.event.send_descr' => 'Wähle aus der Liste von Marketingmitteilungen um diese in der Kampagne zu versenden',
    'mautic.channel.send.selectmessages' => 'Wähle eine Marketingmitteilung',
    'mautic.channel.choose.messages_descr' => 'Marketingmitteilungen',
    'mautic.email.send.edit.message' => 'Mitteilung bearbeiten',
    'mautic.channel.message.send.marketing.message' => 'Sende Marketingmitteilung',
    'mautic.channel.message.send.marketing.message.descr' => 'Sende innerhalb der ausgewählten Marketingnachricht eine Nachricht über die konfigurierten Kanäle.',
    'mautic.messages.processed.messages' => 'Versandte Mitteilungen pro Kanal',
    'mautic.channel.message.form.confirmdelete' => 'Diese Nachricht löschen?',
    'mautic.queued.channel' => 'Nachricht in Warteschlange für Channel eingereiht',
    'mautic.message.queue' => 'Nachricht in Warteschlange eingereiht',
    'mautic.queued.message.timeline.status' => 'Status',
    'mautic.queued.message.event.cancel' => 'Abbrechen',
    'mautic.queued.message.timeline.attempts' => 'Versuche',
    'mautic.queued.message.timeline.channel' => 'Kanal',
    'mautic.queued.message.timeline.date.added' => 'hinzugefügt am',
    'mautic.queued.message.timeline.rescheduled' => 'Neuer Termin',
    'mautic.message.form.confirmdelete' => 'Die Marketingnachricht löschen, %name%?',
    'mautic.message.queue.report.channel' => 'Nachrichtenchannel',
    'mautic.message.queue.report.channel_id' => 'Nachrichten-ID',
    'mautic.message.queue.report.priority' => 'Priorität',
    'mautic.message.queue.report.max_attempts' => 'Maximale Versuche',
    'mautic.message.queue.report.attempts' => 'Gesamtanzahl der Versuche',
    'mautic.message.queue.report.success' => 'Erfolg',
    'mautic.message.queue.report.status' => 'Status',
    'mautic.message.queue.report.last_attempt' => 'Datum des letzten Versuchs',
    'mautic.message.queue.report.date_sent' => 'Versanddatum',
    'mautic.message.queue.report.scheduled_date' => 'Geplantes Datum',
    'mautic.message.queue.report.date_published' => 'Datum der Veröffentlichung',
    'mautic.report.group.message.channel' => 'Channel Nachrichten',
    'mautic.messages.messages' => 'Marketingmitteilung',
    'mautic.report.dashboard.widgets' => 'Bericht-Widgets',
    'mautic.report.dashboard.widgets.full_report' => 'Gesamten Bericht anzeigen',
    'mautic.report.field.category_id' => 'Kategorie ID',
    'mautic.report.field.category_name' => 'Kategorie Name',
    'mautic.report.field.date_added' => 'Erstellungsdatum',
    'mautic.report.field.date_modified' => 'Letztes Änderungsdatum',
    'mautic.report.field.is_published' => 'Ist veröffentlicht',
    'mautic.report.field.lead.label' => 'Kontakt %field%',
    'mautic.report.field.lead.address1' => 'Kontakt Adressfeld 1',
    'mautic.report.field.lead.address2' => 'Kontakt Adressfeld 2',
    'mautic.report.field.lead.city' => 'Kontakt Stadt',
    'mautic.report.field.lead.company' => 'Kontakt Unternehmen',
    'mautic.report.field.lead.country' => 'Kontakt Land',
    'mautic.report.field.lead.email' => 'Kontakt E-Mail',
    'mautic.report.field.lead.firstname' => 'Kontakt Vorname',
    'mautic.report.field.lead.id' => 'Kontakt-ID',
    'mautic.report.field.lead.lastname' => 'Kontakt Nachname',
    'mautic.report.field.lead.mobile' => 'Kontakt Telefon Mobil',
    'mautic.report.field.lead.phone' => 'Kontakt Telefon',
    'mautic.report.field.lead.position' => 'Kontakt Position',
    'mautic.report.field.lead.state' => 'Kontakt Bundesland',
    'mautic.report.field.lead.title' => 'Kontakt Anrede',
    'mautic.report.field.lead.zipcode' => 'Kontakt PLZ',
    'mautic.report.field.modified_by_user' => 'Zuletzt geändert von ',
    'mautic.report.field.publish_down' => 'Als nicht verfügbar festlegen am',
    'mautic.report.field.utm_campaign' => 'UTM-Kampagne',
    'mautic.report.field.utm_content' => 'UTM-Inhalte',
    'mautic.report.field.utm_medium' => 'UTM-Medium',
    'mautic.report.field.utm_source' => 'UTM-Quelle',
    'mautic.report.field.utm_term' => 'UTM-Begriff',
    'mautic.report.field.publish_up' => 'Als verfügbar festlegen am',
    'mautic.report.field.source' => 'Originalquelle',
    'mautic.report.field.source_id' => 'Originalquelle ID',
    'mautic.report.graph.bar' => 'Balkendiagramm',
    'mautic.report.graph.line' => 'Liniendiagramm',
    'mautic.report.graph.pie' => 'Kreisdiagramm',
    'mautic.report.graph.table' => 'Tabelle',
    'mautic.report.permissions.header' => 'Berechtigung für die Reports',
    'mautic.report.permissions.reports' => 'Reports auf die der User Zugriff hat',
    'mautic.widget.report' => 'Berichts-Diagramm',
    'mautic.report.report.form.columnselector' => 'Spalten',
    'mautic.report.report.form.confirmbatchdelete' => 'Die ausgewählten Reports löschen?',
    'mautic.report.report.form.confirmdelete' => 'Den Report %name% löschen?',
    'mautic.report.report.form.graphs' => 'Diagramme/Tabellen für den Bericht',
    'mautic.report.report.form.displayBeforeTables' => 'Diagramme vor Tabellen anzeigen',
    'mautic.report.report.form.owner' => 'Eigentümer',
    'mautic.report.report.form.issystem' => 'Sichtbar für alle eingeloggten Benutzer',
    'mautic.report.report.form.issystem.tooltip' => 'Wenn Sie dies auf "Nein" setzen, wird es für Sie und Rollen mit der Berechtigung zum Anzeigen der Berichte anderer Benutzer sichtbar.',
    'mautic.report.report.form.display.dynamic.filters.settings' => 'Einstellungen für Dynamische Filter',
    'mautic.report.report.form.display.graphs.above.table' => 'Diagramme über den Tabellendaten auf der Berichtsseite anzeigen',
    'mautic.report.report.form.display.show.dynamic.filters' => 'Standardmäßig geöffnet',
    'mautic.report.report.form.display.hide.date.ranges' => 'Datumsbereich ausblenden',
    'mautic.report.report.form.source' => 'Datenquelle',
    'mautic.report.report.form.source.help' => 'Wählen Sie die Datenquelle für diesen Report. Diese Auswahl leert ihre bestehenden Spalten und Filter Einstellungen. ',
    'mautic.report.report.form.choose_graphs' => 'Diagramm auswählen',
    'mautic.report.report.header.edit' => 'Report %name% ändern',
    'mautic.report.report.header.new' => 'Neuer Report',
    'mautic.report.report.header.view' => 'Report %name% anzeigen',
    'mautic.report.report.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (kommagetrennte IDs, keine Leerzeichen)<br />is:published<br />is:unpublished<br />is:mine',
    'mautic.report.report.label.addfilter' => 'Filter hinzufügen',
    'mautic.report.report.label.addtableorder' => 'Sortierung hinzufügen',
    'mautic.report.report.label.availablecolumns' => 'Verfügbare Spalten',
    'mautic.report.report.label.filtercolumn' => 'Spalte',
    'mautic.report.report.label.filtercondition' => 'Bedingung',
    'mautic.report.report.label.filterdynamic' => 'Dynamisch?',
    'mautic.report.report.label.filterdynamic_tooltip' => 'Falls ja ausgewählt ist, ist dieser Filter in der Listeansicht für dynamische Fiterung verfügbar.',
    'mautic.report.report.label.filtervalue' => 'Wert',
    'mautic.report.report.label.removefilter' => 'Filter entfernen',
    'mautic.report.report.label.selectedcolumns' => 'ausgewählte Spalten',
    'mautic.report.report.label.tableorder_dir.asc' => 'Aufsteigend',
    'mautic.report.report.label.tableorder_dir.desc' => 'Absteigend',
    'mautic.report.report.menu.index' => 'Reports verwalten',
    'mautic.report.report.noresults' => 'Für diesen Report gibt es keine Daten',
    'mautic.report.report.tooltip.selected.columns' => 'Die Reihenfolge der Spalten im Bericht entspricht der Reihenfolge in dieser Box. Bitte verwenden Sie die Buttons, um die Reihenfolge zu ändern.',
    'mautic.report.reports' => 'Reports',
    'mautic.report.tab.data' => 'Daten',
    'mautic.report.tab.graphs' => 'Diagramme',
    'mautic.report.tab.schedule' => 'Planen',
    'mautic.report.table.noresults' => 'Keine Ergebnisse gefunden. Ändern Sie Ihre Datenfilter.',
    'mautic.report.campaign.channel.category_id' => 'Channel Element: Kategorie ID',
    'mautic.report.campaign.channel.created_by' => 'Channel Element: erstellt von',
    'mautic.report.campaign.channel.created_by_user' => 'Channel Element: Nach Namen erstellt',
    'mautic.report.campaign.channel.date_added' => 'Channel Element: hinzugefügt am',
    'mautic.report.campaign.channel.description' => 'Channel Element: Beschreibung',
    'mautic.report.campaign.channel.name' => 'Channel Element: Name',
    'mautic.report.form.groupby' => 'Gruppieren nach',
    'mautic.core.calculated.fields' => 'Berechnete Spalten',
    'mautic.report.report.label.function' => 'Funktion hinzufügen',
    'mautic.report.report.label.aggregators.count' => 'ANZAHL',
    'mautic.report.report.label.aggregators.avg' => 'AVG',
    'mautic.report.report.label.aggregators.sum' => 'SUM',
    'mautic.report.report.label.aggregators.min' => 'MINIMUM',
    'mautic.report.report.label.aggregators.max' => 'MAXIMUM',
    'mautic.report.function' => 'Funktion',
    'mautic.report.report.groupby.totals' => 'Gesamt',
    'mautic.report.report.glue.choice.and' => 'Und',
    'mautic.report.report.glue.choice.or' => 'Oder',
    'mautic.report.schedule.isScheduled' => 'E-Mail Bericht versenden',
    'mautic.report.schedule.toAddress.label' => 'To',
    'mautic.report.schedule.toAddress.tooltip' => 'Trennen Sie mehrere E-Mails mit einem Komma',
    'mautic.report.schedule.every' => 'Jede/r',
    'mautic.report.schedule.day' => 'An',
    'mautic.report.schedule.month_frequency' => 'An folgendem Tag',
    'mautic.report.schedule.unit.now' => 'jetzt',
    'mautic.report.schedule.unit.day' => 'Tag',
    'mautic.report.schedule.unit.week' => 'Woche',
    'mautic.report.schedule.unit.month' => 'Monat',
    'mautic.report.schedule.day.monday' => 'Montag',
    'mautic.report.schedule.day.tuesday' => 'Dienstag',
    'mautic.report.schedule.day.wednesday' => 'Mittwoch',
    'mautic.report.schedule.day.thursday' => 'Donnerstag',
    'mautic.report.schedule.day.friday' => 'Freitag',
    'mautic.report.schedule.day.saturday' => 'Samstag',
    'mautic.report.schedule.day.sunday' => 'Sonntag',
    'mautic.report.schedule.day.week_days' => 'Werktage',
    'mautic.report.schedule.month_frequency.first' => 'Erstes',
    'mautic.report.schedule.month_frequency.last' => 'Letztes',
    'mautic.report.schedule.preview_data' => 'Beispielhafte Daten-Berichte werden gesendet:',
    'mautic.report.schedule.email.subject' => 'Bericht %report_name% – %date%.',
    'mautic.report.schedule.email.message' => 'Der am %date% generierte Bericht <a href="%link%">%report_name%</a> ist beigefügt.',
    'mautic.report.schedule.email.message_file_not_attached' => 'Die Datei ist zu groß, um per E-Mail versendet zu werden. Klicken Sie auf den Link, um diesen Bericht anzuzeigen: <a href="%link%">%report_name%</a>.',
    'mautic.report.schedule.email.message_file_linked' => 'Klicke hier, um den Bericht herunterzuladen: <a href="%link%">%report_name%</a>.',
    'mautic.report.schedule.command.finished' => 'Scheduler ist fertig',
    'mautic.report.schedule.command.invalid_parameter' => 'Der Parameterbericht muss eine Nummer sein',
    'mautic.report.download.missing' => 'Für den Bericht %id% wurde noch keine CSV-Datei generiert. Es ist jedoch ein geplanter Bericht konfiguriert.',
    'mautic.report.download.missing.but.scheduled' => 'Für den Bericht %id% wurde noch keine CSV-Datei generiert. Sie wurde jedoch bei Ihrem Downloadversuch angefordert. Sie erhalten eine E-Mail-Benachrichtigung, sobald die Datei generiert wurde.',
    'mautic.report.dashboard.widgets.no_report_found' => '<strong>Oh nein!</strong> Der Bericht wurde gelöscht oder es wurden keine Daten gefunden.',
    'mautic.config.tab.reportconfig' => 'Report Einstellungen',
    'mautic.config.tab.form.csv_always_enclose' => 'Immer Angebotsdaten im CSV-Export',
    'mautic.config.tab.form.csv_always_enclose.tooltip' => 'Aktivieren Sie diese Option, wenn für die zum Öffnen der CSV verwendete Anwendung Werte erforderlich sind, mit doppelten Anführungszeichen zitiert werden. Beispielsweise: &#34;Vorname&#34;,&#34;&#34;,&#34;Familienname&#34;',
    'mautic.report.notfound' => 'Bericht mit ID %id% wurde nicht gefunden.',
    'mautic.report.export.and.send' => 'Exportieren & Senden',
    'mautic.format.invalid' => 'Das Format %format% wird nicht unterstützt. Unterstützte Formate sind: %validFormats%.',
    'mautic.report.is.scheduled' => 'Dieser Bericht soll per E-Mail versendet werden',
    'mautic.config.tab.messengerconfig' => 'Warteschlangen Einstelllungen',
    'mautic.messenger.config.retry_strategy' => 'Wiederholungsstrategie',
    'mautic.messenger.config.retry_strategy.max_retries' => 'Maximale Wiederholungsversuche',
    'mautic.messenger.config.retry_strategy.delay' => 'Verzögerung',
    'mautic.messenger.config.retry_strategy.multiplier' => 'Multiplikator',
    'mautic.messenger.config.retry_strategy.max_delay' => 'Maximale Verzögerung',
    'mautic.messenger.config.dsn_help_general' => 'Die Warteschlange ist standardmäßig nicht aktiviert (das Schema ist auf „Synchronisieren“ eingestellt). Wenn eine Warteschlange verwendet werden soll, dann folge der Dokumentation unter <a href="_QQ_"%link%"_QQ_">%link%</a>.',
    'mautic.messenger.config.dsn_help_retry_strategy' => 'Wenn die Verarbeitung einer Nachricht fehlschlägt, wird die Nachricht für einen weiteren Versuch zurück an die Warteschlange gesendet. Dieses Verhalten kann im folgenden Abschnitt angepasst werden. Weitere Einzelheiten sind in der Dokumentation zu finden: <a href="_QQ_"%link%"_QQ_">%link%</a>.',
    'mautic.messenger.config.dsn_help_failed' => 'Wenn eine Nachricht bei allen Wiederholungsversuchen fehlschlägt, wird sie standardmäßig verworfen. Um dies zu vermeiden, kann optional eine Warteschlange für Fehler konfiguriert werden. Weitere Einzelheiten sind in der Dokumentation zu finden: <a href="_QQ_"%link%"_QQ_">%link%</a>.',
    'mautic.messenger.config.dsn_email' => 'Warteschlange für E-Mail (SMS und Push-Nachrichten)',
    'mautic.messenger.config.dsn_hit' => 'Warteschlange für Treffer (Seite und E-Mail)',
    'mautic.messenger.config.dsn_failed' => 'Warteschlange für Fehler',
    'mautic.messenger.config.dsn.send_test_message' => 'Testnachricht senden',
    'mautic.messenger.config.dsn.test_message_failed' => 'Die Testnachricht konnte aufgrund des folgenden Fehlers nicht gesendet werden: \'"_QQ_"%message%"_QQ_"\'.',
    'mautic.messenger.config.dsn.test_message_processed' => 'Die Testnachricht für DSN \'"_QQ_"%type%"_QQ_"\' wurde erfolgreich verarbeitet.',
    'mautic.campaign.lead.changelist' => 'Segment des Kontakts anpassen',
    'mautic.campaign.lead.changepoints' => 'Kontakt-Punkte anpassen',
    'mautic.campaign.lead.changetags' => 'Tags ändern',
    'mautic.campaign.lead.adddnc' => 'Auf nicht kontaktieren setzen',
    'mautic.campaign.lead.removednc' => 'Entfernen von "nicht kontaktieren".',
    'mautic.campaign.lead.field_value' => 'Kontakt-Feld Wert',
    'mautic.campaign.lead.device' => 'Kontakt Device',
    'mautic.campaign.lead.owner' => 'Kontakt Inhaber',
    'mautic.campaign.lead.updatelead' => 'Kontakt aktualisieren',
    'mautic.campaign.lead.updatecompany' => 'Hauptunternehmen des Kontakts aktualisieren',
    'mautic.contact.error.notfound' => 'Kontakt nicht gefunden.',
    'mautic.campaign.lead.scorecontactscompanies' => 'Firmenscore',
    'mautic.campaign.lead.deletecontact' => 'Kontakt löschen',
    'mautic.campaign.lead.notfound' => 'Für diesen Kontakt gibt es keine Kampagnen.',
    'mautic.campaign.lead.segments' => 'Segmente',
    'mautic.campaign.lead.tags' => 'Tags',
    'mautic.campaign.lead.points' => 'Kontakt-Punkte',
    'mautic.core.date.added_first' => ' Datum des ersten Kontaktes hinzugefügt',
    'mautic.core.date.added_last' => ' Datum des letzten Kontaktes hinzugefügt',
    'mautic.lead.add.note' => 'Notiz hinzufügen',
    'mautic.lead.attribution' => 'Zuordnung',
    'mautic.lead.attribution.tooltip' => 'Geben Sie den Marketingkanal ein, der den Lead generiert hat. Zum Beispiel: E-Mail, bezahlte Werbung, soziale Medien usw.',
    'mautic.lead.attribution_date' => 'Datum der Zuordnung',
    'mautic.lead.attribution_date.tooltip' => 'Geben Sie das Datum ein, an dem der Benutzer mit dem Marketingkanal interagiert hat, der sein Verhalten beeinflusst hat.',
    'mautic.lead.batch.add_to' => 'Zu Folgendem hinzufügen:',
    'mautic.lead.batch.campaigns' => ' Kampagne wechseln',
    'mautic.lead.batch.owner' => 'Betreuer wechseln',
    'mautic.lead.batch.categories' => 'Ändere Kategorien',
    'mautic.lead.batch.channels' => 'Ändere Channels',
    'mautic.lead.batch.dnc' => ' Auf nicht kontaktieren setzen',
    'mautic.lead.batch.dnc_reason' => 'Grund',
    'mautic.lead.batch.lists' => ' Segment wechseln',
    'mautic.lead.batch.remove_from' => 'Von Folgendem entfernen:',
    'mautic.lead.batch.stages' => ' Status ändern',
    'mautic.lead.no_company' => 'Dieser Kontakt ist nicht mit dem Unternehmen verbunden.',
    'mautic.lead.contact' => 'Kontakt',
    'mautic.lead.contact.channels' => 'Channels',
    'mautic.lead.contact.frequency' => 'Kontaktpräferenzen',
    'mautic.lead.lead.field.stage' => 'Phase',
    'mautic.lead.device' => 'Device',
    'mautic.lead.device.header' => 'Typ',
    'mautic.lead.devices' => 'Devices',
    'mautic.lead.device_brand' => 'Device Marke',
    'mautic.lead.device_brand.header' => 'Marke',
    'mautic.lead.device_browser.header' => 'Browser',
    'mautic.lead.device_model' => 'Device Modell',
    'mautic.lead.device_os_name' => 'Device Betriebssystem',
    'mautic.lead.device_os_name.header' => 'Betriebsystem',
    'mautic.lead.device_os_shortname' => 'Device Betriessystem Kurzname',
    'mautic.lead.device_os_version' => 'Device Betriebssystemversion',
    'mautic.lead.device_os_version.header' => 'Betriebssystem-Version ',
    'mautic.lead.device_os_platform' => 'Device Betriebssystemplattform',
    'mautic.lead.do.not.contact' => 'Nicht kontaktieren',
    'mautic.lead.do.not.contact_bounced' => 'Gebounced',
    'mautic.lead.do.not.contact_unsubscribed' => 'Abgemeldet',
    'mautic.lead.do.not.contact_manual' => 'Manuell',
    'mautic.lead.do.not.contact_channel' => 'Do Not Contact: %channel%',
    'mautic.lead.do.not.contact_bounced_channel' => 'Bounced: %channel%',
    'mautic.lead.email.from_email' => 'Von',
    'mautic.lead.email.from_name' => 'Absender-Adresse',
    'mautic.lead.email.header.index' => 'Kontakt-Felder',
    'mautic.lead.email.send_email' => 'E-Mail senden',
    'mautic.lead.email.send_email.header' => 'Senden Sie eine individuelle E-Mail an %email%',
    'mautic.lead.email.template' => 'Import aus einer bestehenden Vorlage',
    'mautic.lead.event.delete' => 'Kontakt gelöscht',
    'mautic.lead.event.merge' => 'Kontakt zusammengeführt',
    'mautic.lead.event.create' => 'Kontakt erstellt',
    'mautic.lead.event.donotcontact' => 'Nicht kontaktieren',
    'mautic.lead.event.donotcontact_channel' => 'Do not contact: %channel%',
    'mautic.lead.event.donotcontact_contactable' => 'Kontakt darf kontaktiert werden.',
    'mautic.lead.event.donotcontact_bounced' => ' Kommunikation für diesen Kanal gebounced.',
    'mautic.lead.event.donotcontact_manual' => 'Der Kontakt wurde für diesen Kanal von Hand auf nicht kontaktieren gesetzt.',
    'mautic.lead.event.donotcontact_unsubscribed' => 'Der Kontakt hat sich von diesem Kanal abgemeldet.',
    'mautic.lead.event.identified' => 'Kontakt identifiziert',
    'mautic.lead.event.ipadded' => 'Zugriff von IP',
    'mautic.lead.event.update' => 'Kontakt aktualisiert',
    'mautic.lead.event.utmtagsadded' => 'UTM Tags aufgezeichnet',
    'mautic.lead.field.indexable' => 'Indexierbar',
    'mautic.lead.field.tags' => 'Tags',
    'mautic.lead.field.timezone' => 'Bevorzugte Zeitzone',
    'mautic.lead.field.address' => 'Adresse',
    'mautic.lead.field.utmcampaign' => 'Kampagne',
    'mautic.lead.field.utmcontent' => 'Inhalt',
    'mautic.lead.field.utmmedium' => 'Medium',
    'mautic.lead.field.umtsource' => 'Quelle',
    'mautic.lead.field.utmterm' => 'Begriff',
    'mautic.lead.event.api' => 'API',
    'mautic.lead.event.api.operation.not.allowed' => 'Der angeforderte Vorgang ist nicht zulässig.',
    'mautic.lead.event.api.lead.not.found' => 'Kontakt konnte nicht gefunden werden.',
    'mautic.lead.event.api.point.group.not.found' => 'Die angegebene Punktgruppe wurde nicht gefunden.',
    'mautic.lead.event.apiadded' => 'Durch API hinzugefügt',
    'mautic.lead.field.form.choose' => 'Wählen Sie ein Feld aus',
    'mautic.lead.field.form.confirmbatchdelete' => 'Ausgewählte benutzerdefinierte Felder löschen? WARNUNG: Alle Werte dieser Felder in vorhandenen Kontakten werden ebenfalls gelöscht.',
    'mautic.lead.field.form.confirmdelete' => 'Das benutzerdefinierte Feld %name% löschen? WARNUNG: Alle Werte dieses Felds in vorhandenen Kontakten werden ebenfalls gelöscht.',
    'mautic.lead.field.form.group.help' => 'Bestimmt, wo das Feld angezeigt wird, wenn ein bestimmter Kontakt betrachtet wird.',
    'mautic.lead.field.form.islistable' => 'Für Segmente verfügbar',
    'mautic.lead.field.form.isshortvisible' => 'Sichtbar beim schnellen Hinzufügen',
    'mautic.lead.field.form.isshortvisible.tooltip' => ' Wenn auf Ja gesetzt, wird dieses Feld im Schnell-Hinzufügen-Fenster gezeigt',
    'mautic.lead.field.form.isuniqueidentifer' => 'Ist eindeutige ID',
    'mautic.lead.field.form.isuniqueidentifer.tooltip' => 'Setzen Sie dieses Feld auf Ja, wenn es sich um eine eindeutige ID für den Kontakt handelt (z.B. E-Mail-Adresse, Nutzername, Social Media Name, usw.).',
    'mautic.lead.field.form.isuniqueidentifer.warning' => 'WARNUNG: Das ungeeignete Einstellen von &quot;Ist eindeutige ID&quot; auf Ja kann zu einer Massenzusammenführung von Kontakten und falsch getrackter Kontakt-Aktivität führen. Bitte setzen Sie das Feld nur auf Ja, wenn es sich um einen eindeutigen Wert für den Kontakt handelt, beispielsweise E-Mail-Adresse, Nutzername, usw.',
    'mautic.lead.field.form.isvisible' => 'Sichtbar auf Formularen',
    'mautic.lead.field.form.ispubliclyupdatable' => 'Öffentlich aktualisierbar',
    'mautic.lead.field.form.ispubliclyupdatable.tooltip' => 'Wenn ja ausgewählt ist, kann dieses Feld durch Hinzufügen des Feld-Alias aktualisiert werden und der Wert der Abfrage des /mtracking.gif Tracking-Pixels wird gesetzt.',
    'mautic.lead.field.form.maximum.character.length' => 'Maximale Zeichenlänge',
    'mautic.lead.field.form.number.rounddown' => 'Abrunden',
    'mautic.lead.field.form.number.roundhalfdown' => 'Halb-Abrunden',
    'mautic.lead.field.form.number.roundhalfeven' => 'Halb-Runden',
    'mautic.lead.field.form.number.roundhalfup' => 'Halb-Aufrunden',
    'mautic.lead.field.form.number.roundup' => 'Abrunden',
    'mautic.lead.field.form.properties.boolean' => 'Boolean Labels',
    'mautic.lead.field.form.properties.lookup' => 'Lookup Werte',
    'mautic.lead.field.form.properties.numberprecision' => 'Genauigkeit',
    'mautic.lead.field.form.properties.numberrounding' => 'Wie wird gerundet',
    'mautic.lead.field.form.properties.select' => 'Optionen',
    'mautic.lead.field.form.properties.allowhtml' => 'HTML erlauben',
    'mautic.lead.field.form.isIndex.tooltip' => 'Wenn dieses Feld indizierbar gemacht wird, kann dies die Suchleistung verbessern. %indexCount% von %maxCount% Indizes wurden verwendet.',
    'mautic.lead.field.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (Komma-getrennte IDs, keine Leerzeichen)<br />is:published<br />is:unpublished<br />is:mine<br />is:indexed<br />is:unique<br />type:{type name}<br />group:{group name}',
    'mautic.lead.field.searchcommand.isindexed' => 'is:indexed',
    'mautic.lead.field.searchcommand.isunique' => 'is:unique',
    'mautic.lead.field.searchcommand.type' => 'Typ',
    'mautic.lead.field.searchcommand.group' => 'Gruppe',
    'mautic.lead.lead.update.action.help' => 'Aktualisiert die Kontakt-Felder mit den Werten dieser Aktion',
    'mautic.lead.company.update.action.help' => 'Aktualisieren Sie die Unternehmensfelder mit Begriffen aus diesem Ereignis.',
    'mautic.lead.field.group' => 'Gruppe',
    'mautic.lead.field.group.core' => 'Core',
    'mautic.lead.field.group.company' => 'Firma',
    'mautic.lead.field.group.extra' => 'Extra',
    'mautic.lead.field.group.personal' => 'Persönlich',
    'mautic.lead.field.group.professional' => 'Professional',
    'mautic.lead.field.group.social' => 'Social',
    'mautic.lead.field.header.contact' => 'Kontakt',
    'mautic.lead.field.header.edit' => 'Name des benutzerdefinierten Feldes %name% ändern',
    'mautic.lead.field.header.engagements' => 'Engagements',
    'mautic.lead.field.header.index' => 'Benutzerdefinierte Felder',
    'mautic.lead.field.header.new' => 'Neues benutzerdefiniertes Feld',
    'mautic.lead.field.help.alias' => 'Buchstaben und Zahlen (ohne Leerzeichen) werden zur Identifizierung dieses Felds verwendet. Wenn das Feld leer gelassen wird, wird automatisch ein eindeutiger Alias ​​generiert.',
    'mautic.lead.field.help.lookup' => 'Auch typeahead genannt. Frei lassen, um eindeutige Werte aus der Datenbank zu laden oder ein bestimmtes Segment hinzuzufügen. Die Werte durch den Senkrechtstrich ( | ) trennen, z.B. Rot|Grün|Blau',
    'mautic.lead.field.help.numberprecision' => 'Anzahl der Stellen die erlaubt sind bevor gerundet wird.',
    'mautic.lead.field.help.numberrounding' => 'Abrunden - Richtung Null runden.<br />Aufrunden - von Null entfernen.<br />Halb-Abrunden - bis zum nächsten Nachbarn runden. Bei gleichem Abstand (gleiche Distanz) wird abgerundet.<br />Halb-Runden - bis zum nächsten Nachbarn runden. Bei gleichem Abstand wird zum geraden Nachbarn gerundet.<br />Halb-Aufrunden - bis zum nächsten Nachbarn runden. Bei gleichem Abstand wird aufgerundet.',
    'mautic.lead.field.help.select' => 'Fügen Sie hier die Werte ein. Trennen Sie die Werte mit einem Senkrechtstrich ( | ). Z.B. Rot|Grün|Blau',
    'mautic.lead.field.help.defaultvalue' => 'Ein Standardwert gilt nur für neue Kontakte. Vorhandene Kontakte werden nicht aktualisiert. In einem benutzerdefinierten Feld gilt der Wert nur für neue Kontakte, nicht für bestehende ',
    'mautic.lead.field.menu.index' => 'Benutzerdefinierte Felder',
    'mautic.lead.field.label' => 'Label',
    'mautic.lead.field.linkedin' => 'LinkedIn',
    'mautic.lead.field.tooltip.fixed' => 'Kann nicht entfernt werden (intern).',
    'mautic.lead.field.tooltip.invisible' => 'Wird in Kontaktformularen nicht angezeigt.',
    'mautic.lead.field.tooltip.listable' => 'Kann als Segment-Filter genutzt werden.',
    'mautic.lead.field.tooltip.required' => 'Ist erforderlich, wenn Kontaktformulare ausgefüllt werden.',
    'mautic.lead.field.tooltip.public' => 'Kann öffentlich über die Abfrage der Tracking-Pixel URL aktualisiert werden',
    'mautic.lead.field.tooltip.isuniqueidentifer' => 'Ist eindeutige ID',
    'mautic.lead.field.tooltip.isindex' => 'Ist indexiert und liefert schnellere Suchergebnisse',
    'mautic.lead.field.type' => 'Datentyp',
    'mautic.lead.field.type.datetime' => 'Datum/Uhrzeit',
    'mautic.lead.field.type.locale' => 'Ort',
    'mautic.lead.field.type.html' => 'HTML',
    'mautic.lead.field.type.lookup' => 'Lookup',
    'mautic.lead.field.type.multiselect' => 'Auswählen: Mehrfachauswahl',
    'mautic.lead.field.type.region' => ' Region',
    'mautic.lead.field.type.tel.home' => 'Telefon - zuhause',
    'mautic.lead.field.type.tel.mobile' => 'Mobil',
    'mautic.lead.field.type.textarea' => 'Text: Absatz',
    'mautic.lead.field.type.time' => 'Zeit',
    'mautic.lead.field.type.timezone' => 'Zeitzone',
    'mautic.lead.graph.line.leads' => 'Neuer Kontakt hinzugefügt',
    'mautic.lead.graph.line.leads.emails' => 'Neue Kontakte mit E-Mail-Adresse',
    'mautic.lead.graph.line.leads.leads' => 'Alle neuen Kontakte',
    'mautic.lead.graph.line.points' => 'Punkte',
    'mautic.lead.graph.line.all_engagements' => 'Engagements',
    'mautic.lead.graph.pie.attribution_campaigns' => '  Zuordnungen insgesamt nach Kampagnen',
    'mautic.lead.graph.pie.attribution_stages' => ' Zuordnungen insgesamt nach Stadien',
    'mautic.lead.graph.pie.attribution_actions' => ' Zuordnungen insgesamt nach Aktionen',
    'mautic.lead.graph.pie.attribution_channels' => ' Zuordnungen insgesamt nach Kanal',
    'mautic.lead.grid.noresults.header' => 'Keine Kontakte gefunden',
    'mautic.lead.grid.noresults.message' => 'Anscheinend gibt es keine! Wechseln Sie ggf. einen Filter.',
    'mautic.lead.import' => 'Import',
    'mautic.lead.import.batchlimit' => 'Limit',
    'mautic.lead.import.batchlimit_tooltip' => 'Legt fest, wie viele Kontakte pro Vorgang importiert werden.',
    'mautic.lead.import.delimiter' => 'Trennzeichen',
    'mautic.lead.import.delimiter.help' => 'Es ist das Zeichen, das die einzelnen Datenelemente in Ihrer Datei trennt, häufig ein Komma (,).',
    'mautic.lead.import.enclosure' => 'Anlage',
    'mautic.lead.import.enclosure.help' => 'Es ist ein Zeichen, das jedes Datenstück in Ihrer Datei enthält, oft ein Anführungszeichen (&#x22;).',
    'mautic.lead.import.error.header_mismatch' => 'Die Anzahl der Datenspalten ist höher als die Anzahl der Kopfzeilenspalten (erste Zeile)',
    'mautic.lead.import.error.line_empty' => 'Keine Daten gefunden',
    'mautic.lead.import.escape' => 'Austritt',
    'mautic.lead.import.escape.help' => 'Mit diesem Zeichen können Sie Sonderzeichen verwenden, ohne das System zu verwirren. Dabei handelt es sich häufig um einen Backslash (\\).',
    'mautic.lead.import.file' => 'CSV Datei hochladen',
    'mautic.lead.import.inprogress' => 'Der Import läuft.',
    'mautic.lead.import.completed' => 'Import abgeschlossen',
    'mautic.lead.import.result.info' => 'Anzeigen von Details %import%',
    'mautic.lead.import.ghost.limit.hit' => 'Der Import wurde in %limit% hours nicht durch Hintergrundaufgaben aktualisiert. Er gilt somit als gescheitert.',
    'mautic.lead.import.default.owner' => '(Optional) Legen Sie den Inhaber und das Kontakt-Segment der importierten Kontakte fest.',
    'mautic.lead.import.donotleave' => 'Bitte verlassen Sie diese Seite nicht bis der Vorgang abgeschlossen ist oder in die Warteschlange eingereiht wurde.',
    'mautic.lead.import.mapped.fields' => 'zugeordnete Felder',
    'mautic.lead.import.default.options' => 'Standard Optionen',
    'mautic.lead.import.csv.headers' => 'CSV Headers',
    'mautic.lead.import.csv.parser.config' => 'CSV Parser Konfiguration',
    'mautic.lead.import.fields' => 'Ordnen Sie die Felder der importierten Datei den Mautic Kontakt-Feldern zu.',
    'mautic.lead.special_fields' => 'Eigenschaften',
    'mautic.lead.import.leads' => 'Importieren %object%',
    'mautic.lead.import.skip_if_exists' => 'Den Wert beibehalten, falls er bereits existiert',
    'mautic.lead.import.in.background' => 'Import im Hintergrund',
    'mautic.lead.import.delayed' => 'Import verspätet: %reason%',
    'mautic.lead.import.start' => 'Import nach Browser',
    'mautic.lead.import.start.instructions' => 'Laden Sie die CSV-Datei mit den zu importierenden Kontakten hoch. Es kann maximal %size%MB hochgeladen werden. Der nächste Schritt besteht darin, die Felder in der Datei mit den in Mautic verfügbaren Feldern abzugleichen.',
    'mautic.lead.import.label.stage' => 'Phase',
    'mautic.lead.import.label.ownerusername' => 'Besitzer durch Benutzername',
    'mautic.lead.import.label.tags' => 'Tags',
    'mautic.lead.import.stats' => '%created% erstellt, %merged% zusammengefügt, %ignored% ignoriert',
    'mautic.lead.import.success' => 'Erfolgreich!',
    'mautic.lead.import.upload' => 'Upload',
    'mautic.lead.import.event.name' => 'Kontakt Import',
    'mautic.lead.import.action.name' => 'Nach %name%',
    'mautic.lead.import.by.user' => 'Importiert von %user%',
    'mautic.lead.import.label.id' => 'ID',
    'mautic.lead.import.label.createdByUser' => 'Erstellt von Nutzer',
    'mautic.lead.import.label.dateAdded' => 'Erstellungsdatum',
    'mautic.lead.import.label.dateIdentified' => 'Identifikationsdatum',
    'mautic.lead.import.label.dateModified' => 'Änderungsdatum',
    'mautic.lead.import.label.doNotEmail' => 'Nicht kontaktieren',
    'mautic.lead.import.label.ip' => 'IP',
    'mautic.lead.import.label.lastActive' => 'Datum der letzten Aktivität',
    'mautic.lead.import.label.modifiedByUser' => 'Geändert von Nutzer',
    'mautic.lead.import.label.points' => 'Punkte',
    'mautic.lead.import.is.starting' => 'Importieren %id% der %lines% Reihen beginnt.',
    'mautic.lead.import.result' => '%lines% Linien wurden bearbeitet %created% Artikel erstellt %updated% Artikel aktualisiert, %ignored% Artikel ignoriert%time% s',
    'mautic.lead.import.failed' => 'Import fehlgeschlagen. Grund: %reason%',
    'mautic.lead.background.import.if.more.rows.than' => 'Automatischer Import durch Hintergrund-Aufgaben, wenn der CSV mehr Zeilen als definiert hat',
    'mautic.lead.background.import.if.more.rows.than.tooltip' => 'Wenn diese Option größer als 0 ist, gibt es nur einen Import-Button, und der Browser- / Hintergrundimport wird basierend auf der CSV-Zeilennummer festgelegt',
    'mautic.lead.background.export.csv' => 'Exportieren Sie Kontakte im Hintergrund in CSV.',
    'mautic.lead.background.export.csv.tooltip' => 'Wenn dies Ja ist, werden die Kontakte nur im Hintergrund für CSV exportiert.',
    'mautic.lead.behaviors' => 'Kontaktverhalten und Aktionen',
    'mautic.lead.groups' => 'Kontaktgruppenpunkte',
    'mautic.config.tab.leadconfig' => 'Kontakt Einstellungen',
    'mautic.config.tab.companyconfig' => 'Firmeneinstellungen',
    'mautic.config.tab.importconfig' => 'Import Einstellungen',
    'mautic.config.tab.contact.list.settings' => 'Kontaktlisten-Einstellungen',
    'mautic.config.tab.exportconfig' => 'Export Einstellungen',
    'mautic.config.tab.columns' => 'Spalten',
    'mautic.config.tab.contact.merge.settings' => 'Kontaktzusammenführungs-Einstellungen',
    'mautic.config.tab.company.merge.settings' => 'Firmenzusammenführungs-Einstellungen',
    'mautic.core.config.unique_identifiers_operator' => 'Merge nach eindeutigen Feldern mit Operator',
    'mautic.core.config.unique_identifiers_operator.tooltip' => 'Wenn Sie mehr als einen eindeutigen Feldbezeichner verwenden, können Sie die Art und Weise definieren, wie die Suche zusammengeführt wird.',
    'mautic.core.config.allow_multiple_companies' => 'Mehrere Unternehmen pro Kontakt',
    'mautic.core.config.allow_multiple_companies.tooltip' => 'Aktivieren Sie die Zuweisung mehrerer Unternehmen zu einem Kontakt. Nein = Der Kontakt kann nur einem Unternehmen zugewiesen werden. Wenn Sie diesem Kontakt ein neues Unternehmen zuweisen, wird das zuvor zugewiesene Unternehmen ersetzt. Ja = Dem Kontakt können mehrere Unternehmen zugewiesen werden. Das zuletzt zugewiesene Unternehmen ist das primäre Unternehmen.',
    'mautic.core.config.contact_unique_identifiers_operator.or' => 'ODER',
    'mautic.core.config.contact_unique_identifiers_operator.and' => 'UND',
    'mautic.config.tab.segment_config' => 'Segment-Einstellungen',
    'mautic.lead.import.unique_field_not_exist' => 'Es sind keine eindeutigen Felder im Import vorhanden',
    'mautic.lead.import.database.exception' => 'Es ist ein Datenbankfehler aufgetreten:% message%. Der Import wurde auf verzögert gesetzt und wird später importiert.',
    'mautic.lead.lastactive' => 'Zuletzt aktiv',
    'mautic.lead.lead.anonymous' => 'Anonym',
    'mautic.lead.lead.anonymous_leads' => 'Auf anonyme Kontakte umschalten',
    'mautic.lead.lead.event.points' => 'Punkte (+/-)',
    'mautic.lead.lead.event.pointtrigger' => 'Kleinste Punktanzahle',
    'mautic.lead.lead.event.grouppoints' => 'Punkte (%group%)',
    'mautic.lead.lead.events.addtolists' => 'Kontakt zu ausgewählten Segmenten hinzufügen',
    'mautic.lead.lead.events.addutmtags' => 'UTM-Tags aufzeichnen',
    'mautic.lead.lead.events.addutmtags_descr' => ' Globale Tags  werden im Profil des Kontaktes aufgezeichnet',
    'mautic.lead.lead.events.removedonotcontact' => 'Kontakt von der Nicht-Kontaktieren-Liste nehmen',
    'mautic.lead.lead.events.removedonotcontact_descr' => 'Kontakt wird erneut eingeschrieben',
    'mautic.lead.lead.events.changelist' => 'Kontakt-Segmente anpassen',
    'mautic.lead.lead.events.changelist_descr' => 'Kontakt zu Segment(en) hinzufügen oder entfernen',
    'mautic.lead.lead.events.changepoints' => 'Kontakt-Punkte anpassen',
    'mautic.lead.lead.events.changepoints_descr' => 'Punkte geben oder nehmen',
    'mautic.lead.lead.events.changestage' => 'Kontakt-Phase ändern',
    'mautic.lead.lead.events.changestage_descr' => 'Phase eines Kontakts ändern, wenn die ausgewählte Aktion auftritt',
    'mautic.lead.lead.events.changetags' => 'Kontakt-Tags anpassen',
    'mautic.lead.lead.events.changetags_descr' => 'Tag zum Kontakt hinzufügen oder entfernen',
    'mautic.lead.lead.events.leadcreated' => 'Kontakt erstellt',
    'mautic.lead.lead.events.leadcreated_descr' => 'Ein Ereignis auslösen, wenn ein neuer Kontakt erstellt wird',
    'mautic.lead.lead.events.listchange' => 'Kontakt hat das Segment gewechselt',
    'mautic.lead.lead.events.listchange_descr' => 'Ein Ereignis auslösen, wenn der Kontakt das Segment wechselt',
    'mautic.lead.lead.events.listtrigger.added' => 'Zu Segment hinzugefügt',
    'mautic.lead.lead.events.listtrigger.removed' => 'Aus Segment entfernt',
    'mautic.lead.lead.events.pointchange' => 'Kontakt-Punkte geändert',
    'mautic.lead.lead.events.pointchange_descr' => 'Ein Ereignis auslösen, wenn sich die Kontakt-Punkte ändern',
    'mautic.lead.lead.events.removefromlists' => 'Kontakt von ausgewählten Segmenten entfernen',
    'mautic.lead.lead.events.updatelead' => 'Kontakt aktualisieren',
    'mautic.lead.lead.events.updatelead_descr' => 'Aktualisiert die aktuellen Kontakt-Felder mit den festgelegten Werten dieser Aktion',
    'mautic.lead.lead.events.updatecompany' => 'Hauptunternehmen des Kontakts aktualisieren',
    'mautic.lead.lead.events.updatecompany_descr' => 'Aktualisiert die aktuellen Unternehmens-Felder des Kontakts mit den festgelegten Werten dieser Aktion',
    'mautic.lead.lead.events.delete' => 'Kontakt löschen',
    'mautic.lead.lead.events.delete_descr' => '<span class=\'text-danger\'>Löscht den Kontakt sowie alle zugehörigen statistischen Daten dauerhaft.  <strong>Warnung: dies ist irreversibel!</strong></span>',
    'mautic.lead.lead.events.add_donotcontact' => 'Hinzufügen zu "nicht kontaktieren"',
    'mautic.lead.lead.events.add_donotcontact_desc' => 'Fügen Sie dem Kontakt die Flagge „DoNotContact“ hinzu',
    'mautic.lead.lead.events.remove_donotcontact' => 'Entfernen von "nicht kontaktieren".',
    'mautic.lead.lead.events.remove_donotcontact_desc' => 'Entfernen Sie die Markierung „Nicht kontaktieren“ vom Kontakt',
    'mautic.lead.lead.events.field_value' => 'Kontakt-Feld Wert',
    'mautic.lead.lead.events.field_value_descr' => 'Bedingung basiert auf einem Kontakt-Feld Wert.',
    'mautic.lead.lead.events.device' => 'Kontakt Device',
    'mautic.lead.lead.events.device_descr' => 'Bedingung basiert auf einem Kontakt Device.',
    'mautic.lead.lead.events.pageHit' => 'Besuchte Seite',
    'mautic.lead.lead.events.pageHit_descr' => 'Bedingung basierend auf allen Seiten, die der Kontakt in der Vergangenheit besucht hat',
    'mautic.lead.lead.events.tags' => 'Kontakt Tags',
    'mautic.lead.lead.events.tags_descr' => 'Bedingung basiert auf einem Kontakt Tag.',
    'mautic.lead.lead.events.segments' => 'Kontakt-Segmente',
    'mautic.lead.lead.events.segments_descr' => 'Bedingung basiert auf Kontakt-Segmenten.',
    'mautic.lead.lead.events.stages' => 'Kontakt-Phasen',
    'mautic.lead.lead.events.stages_descr' => 'Bedingung ist, dass der Kontakt zu mindestens einer der ausgewählten Phasen gehört.',
    'mautic.lead.lead.events.points' => 'Kontakt-Punkte',
    'mautic.lead.lead.events.points_descr' => 'Bedingung basierend auf Kontakt-Score',
    'mautic.lead.segment.dependencies' => 'Segmentabhängigkeiten',
    'mautic.lead.lead.events.campaigns' => 'Kontakt Kampagnen',
    'mautic.lead.lead.events.campaigns.membership' => 'Kampagnenzugehörigkeit',
    'mautic.lead.lead.events.campaigns_descr' => 'Bedingung basiert auf einer Kontakt Kampagne.',
    'mautic.lead.lead.events.campaigns.date.added.filter' => 'Filtern nach Datum des Hinzufügen zur Kampagne',
    'mautic.lead.lead.events.campaigns.expression' => 'Ausdruck',
    'mautic.lead.lead.events.campaigns.date' => 'Datum',
    'mautic.lead.lead.events.owner' => 'Kontakt Inhaber',
    'mautic.lead.lead.events.owner_descr' => 'Bedingung basiert auf Kontakt Besitzer',
    'mautic.lead.lead.field.custom_avatar' => 'Benutzerdefiniert',
    'mautic.lead.lead.events.condition_donotcontact' => 'Als DNC markiert',
    'mautic.lead.lead.events.condition_donotcontact_descr' => 'Die Bedingung prüft, ob der Kontakt die Markierung „Nicht kontaktieren“ hat.',
    'mautic.lead.lead.field.owner' => 'Kontakt Inhaber',
    'mautic.lead.lead.field.list' => 'Kontakt-Segment',
    'mautic.lead.lead.field.preferred_profile' => 'Bevorzugtes Profilfoto',
    'mautic.lead.lead.filter.bundles.exclude.placeholder' => 'Ereignisse nach Quelle ausschließen',
    'mautic.lead.lead.filter.bundles.include.placeholder' => 'Ereignisse nach Quelle einbinden',
    'mautic.lead.lead.form.confirmbatchdelete' => 'Die ausgewählten Kontakte löschen?',
    'mautic.lead.lead.form.confirmdelete' => 'Diesen Kontakt löschen?',
    'mautic.lead.lead.form.leadlists' => 'Nach Segment filtern...',
    'mautic.lead.lead.header.campaigns' => 'Kampagnen für %name%',
    'mautic.lead.lead.header.contact.frequency' => 'Kontaktpräferenzen',
    'mautic.lead.lead.header.edit' => '%name% ändern',
    'mautic.lead.lead.header.ipaddress' => 'IP Adressen',
    'mautic.lead.lead.header.lists' => 'Segmente für %name%',
    'mautic.lead.lead.header.new' => 'Neuer Kontakt',
    'mautic.lead.lead.header.pointslog' => 'Punkte Log',
    'mautic.lead.lead.header.quick.add' => 'Schnell neuen Kontakt anlegen',
    'mautic.lead.lead.header.socialprofiles' => 'Social Profile',
    'mautic.lead.lead.header.merge' => '%name% zusammenfügen',
    'mautic.lead.lead.help.searchcommands' => '<strong>Suchbefehle</strong><br />is:anonymous<br />is:unowned<br />is:mine<br />email:*<br />segment:{segment_alias}<br />name:*<br />company:*<br />company_id:*<br />owner:*<br />ip:*<br />ids:ID1,ID2 (Komma-getrennte IDs, keine Leerzeichen)<br />common:{segment_alias} + {segment_alias} + ...<br />tag:*<br />stage:*<br />email_sent:EMAIL_ID<br />email_read:EMAIL_ID<br />email_queued:EMAIL_ID<br />email_pending:EMAIL_ID',
    'mautic.lead.lead.import' => 'Import',
    'mautic.lead.lead.stage' => 'Kontakt-Phase',
    'mautic.lead.import.list' => 'Importe',
    'mautic.lead.import.source.file' => 'Ursprungsdatei',
    'mautic.lead.lead.import.index' => 'Import Verlauf',
    'mautic.lead.import.failed.rows' => 'Fehlgeschlagene Zeilen',
    'mautic.lead.import.no.failed.rows' => 'Keine fehlgeschlagenen Zeilen gefunden',
    'mautic.lead.import.csv.line.number' => 'CSV Zeilennummer',
    'mautic.lead.import.status' => 'Status',
    'mautic.lead.import.status.info' => 'Status Information',
    'mautic.lead.import.status.1' => 'in Warteschlange',
    'mautic.lead.import.status.2' => 'In Bearbeitung',
    'mautic.lead.import.status.3' => 'Importiert',
    'mautic.lead.import.status.4' => 'Fehlgeschlagen',
    'mautic.lead.import.status.5' => 'Gestoppt',
    'mautic.lead.import.status.6' => 'Manuell',
    'mautic.lead.import.status.7' => 'Verspätet',
    'mautic.lead.import.stage.not.exists' => '"Phase mit ID oder Name ‚%id%‘ wurde nicht gefunden."',
    'mautic.lead.import.parallel.limit.hit' => 'Der Import wurde verzögert, da das parallele Import-Limit von %limit% erreicht wurde.',
    'mautic.lead.view.imports' => 'Importe anzeigen',
    'mautic.lead.import.queue.btn' => 'Im Hintergrund fertigstellen',
    'mautic.lead.import.speed' => 'Import Geschwindigkeit',
    'mautic.lead.import.speed.value' => '%speed% Reihen per Sekunde',
    'mautic.lead.import.line.count' => 'Zeilen gesamt',
    'mautic.lead.import.inserted.count' => 'Eingefügt',
    'mautic.lead.import.updated.count' => 'Aktualisiert',
    'mautic.lead.import.ignored.count' => 'Ignoriert',
    'mautic.lead.import.progress' => 'In Bearbeitung',
    'mautic.lead.import.runtime' => 'Laufzeit',
    'mautic.lead.import.date.started' => 'Import beginnt am',
    'mautic.lead.import.date.ended' => 'Import endet am',
    'mautic.lead.import.contact.action.identified_contact' => 'Kontakt durch Import identifiziert',
    'mautic.lead.import.contact.action.inserted' => 'Kontakt importiert aus %name%',
    'mautic.lead.import.contact.action.updated' => 'Kontakt aktualisiert von %name%',
    'mautic.lead.import.contact.action.failed' => 'Kontaktimport fehlgeschlagen von %name%',
    'mautic.lead.import.row.statuses' => 'Zeilenstatus importieren',
    'mautic.lead.import.processed.rows.minute' => 'Zeilen pro Minute verarbeitet',
    'mautic.lead.import.processed.rows' => 'Verarbeitete Zeilen',
    'mautic.lead.event.imported' => 'Importiert',
    'mautic.lead.lead.lists' => 'Segmente',
    'mautic.lead.lead.live_update' => 'Aktivieren Sie den Live-Modus, in dem neue Kontakte bei ihrer Erstellung automatisch an den Anfang des Segments gesetzt werden.',
    'mautic.lead.lead.menu.index' => 'Kontakte verwalten',
    'mautic.lead.lead.menu.quickadd' => 'Schnell hinzufügen',
    'mautic.lead.lead.pointscount' => 'Kontakt-Punkte',
    'mautic.lead.lead.pointsevent.created' => 'Kontakt wurde manuell erstellt',
    'mautic.lead.lead.primary' => 'Primary',
    'mautic.lead.lead.remove.fromlist' => 'Aus Segment entfernen',
    'mautic.lead.lead.searchcommand.company' => 'firma',
    'mautic.lead.lead.searchcommand.company_id' => 'company_id',
    'mautic.lead.lead.searchcommand.isanonymous' => 'is:anonymous',
    'mautic.lead.lead.searchcommand.isunowned' => 'is:unowned',
    'mautic.lead.lead.searchcommand.list' => 'Segment',
    'mautic.lead.lead.searchcommand.owner' => 'eigentümer',
    'mautic.lead.lead.searchcommand.stage' => 'Phase',
    'mautic.lead.lead.searchcommand.tag' => 'tag',
    'mautic.lead.lead.searchcommand.duplicate' => 'häufig',
    'mautic.lead.lead.searchcommand.email_sent' => 'email_sent',
    'mautic.lead.lead.searchcommand.email_read' => 'email_read',
    'mautic.lead.lead.searchcommand.email_queued' => 'email_queued',
    'mautic.lead.lead.searchcommand.email_pending' => 'email_pending',
    'mautic.lead.lead.searchcommand.page_source' => 'page_source',
    'mautic.lead.lead.searchcommand.page_source_id' => 'page_source_id',
    'mautic.lead.lead.searchcommand.import_id' => 'import_id',
    'mautic.lead.lead.searchcommand.import_action' => 'import_action',
    'mautic.lead.lead.searchcommand.page_id' => 'page_id',
    'mautic.lead.lead.searchcommand.mobile_sent' => 'mobile_sent',
    'mautic.lead.lead.searchcommand.web_sent' => 'web_sent',
    'mautic.lead.lead.searchcommand.sms_sent' => 'sms_sent',
    'mautic.lead.lead.social.foursquare.lists' => 'Segmente',
    'mautic.lead.lead.social.foursquare.mayorship' => 'Landkreise',
    'mautic.lead.lead.social.foursquare.tips' => 'Tipps',
    'mautic.lead.lead.social.lastupdate' => 'Letzte Aktualisierung am %datetime%',
    'mautic.lead.lead.social.photos' => 'Fotos',
    'mautic.lead.lead.social.posts' => 'Posts',
    'mautic.lead.lead.social.profile' => 'Profil',
    'mautic.lead.lead.social.removecache' => 'Die Netzwerkdaten von diesem Kontakt löschen.',
    'mautic.lead.lead.social.tags' => 'Tags',
    'mautic.lead.lead.social.twitter.tweets' => 'Tweets',
    'mautic.lead.lead.submitaction' => 'Kontakt-Aktionen',
    'mautic.lead.lead.submitaction.changepoints' => 'Kontakt-Punkte anpassen',
    'mautic.lead.lead.submitaction.changepoints_descr' => 'Punkte anpassen, abhängig von dem ausgefüllten Formular.',
    'mautic.lead.lead.submitaction.operator' => 'Operator',
    'mautic.lead.lead.submitaction.operator_divide' => 'teilen (/)',
    'mautic.lead.lead.submitaction.operator_minus' => 'abziehen (-)',
    'mautic.lead.lead.submitaction.operator_plus' => 'hinzufügen (+)',
    'mautic.lead.lead.submitaction.operator_times' => 'malnehmen (x)',
    'mautic.lead.lead.submitaction.operator_set' => 'set',
    'mautic.lead.lead.submitaction.points' => 'Anzahl der Punkte die geändert werden soll',
    'mautic.lead.lead.tab.history' => 'Verlauf',
    'mautic.lead.lead.tab.notes' => 'Notizen',
    'mautic.lead.lead.tab.social' => 'Social',
    'mautic.lead.lead.tab.integration' => 'Integrationen',
    'mautic.lead.lead.tab.auditlog' => 'Audit-Log',
    'mautic.lead.lead.tab.socialactivity' => 'Öffentliche Aktivität',
    'mautic.lead.lead.tab.socialprofile' => 'Öffentliches Profil',
    'mautic.lead.lead.tab.places' => 'Orte',
    'mautic.lead.lead.thead.action' => 'Aktion auslösen',
    'mautic.lead.lead.thead.city' => 'Ort',
    'mautic.lead.lead.thead.country' => 'Land',
    'mautic.lead.lead.thead.delta' => 'Punkte &Differenz;',
    'mautic.lead.lead.thead.event' => 'Ereignis auslösen',
    'mautic.lead.lead.thead.location' => 'Standort',
    'mautic.lead.lead.thead.state' => 'Bundesland',
    'mautic.lead.lead.timeline' => 'Zeitverlauf',
    'mautic.lead.lead.upcoming.event.triggered.at' => '<strong class="text-primary">%event%</strong> Ereignis wird ausgelöst durch %link%',
    'mautic.lead.lead.upcoming.events' => 'nächste Ereignisse',
    'mautic.lead.leads' => 'Kontakte',
    'mautic.lead.lifecycle.graph.device.granularity' => 'Devices',
    'mautic.lead.lifecycle.graph.pie.all.lists' => 'Alle Kontakte',
    'mautic.lead.lifecycle.graph.stage.cycle' => 'Phasen-Zyklus',
    'mautic.lead.list.rebuild.total.time' => 'Gesamtzeit: %time% Sekunden',
    'mautic.lead.list.rebuild.contacts.time' => 'Zeit zum Wiederaufbau der Kontakte: %time% Sekunden',
    'mautic.lead.list.rebuild.leads_affected' => '%leads% Kontakt(e) betroffen',
    'mautic.lead.list.rebuild.rebuilding' => 'Baue Kontakte für Segment %id% neu auf',
    'mautic.lead.list.rebuild.not_found' => 'Segment #%id% nicht vorhanden',
    'mautic.lead.list.rebuild.to_be_added' => '%leads% Kontakt(e) insgesamt werden in Bündeln zu je %batch% hinzugefügt',
    'mautic.lead.list.rebuild.to_be_removed' => '%leads% Kontakt(e) insgesamt werden in Bündeln zu je %batch% entfernt',
    'mautic.lead.list.filter.date_identified' => 'Datum erkannt',
    'mautic.lead.list.filter.dnc_bounced' => ' Bounced  - E-Mail',
    'mautic.lead.list.filter.dnc_unsubscribed' => ' Abgemeldet - E-Mail',
    'mautic.lead.list.filter.dnc_manual_email' => 'Manuell abgemeldet - E-Mail',
    'mautic.lead.list.filter.dnc_manual_sms' => 'Abmeldung manuell - SMS',
    'mautic.lead.list.filter.last_active' => 'Letzte Aktivität Datum',
    'mautic.lead.list.filter.campaign' => 'Kampagnen-MItgliedschaft',
    'mautic.lead.list.filter.date_modified' => 'Änderungsdatum',
    'mautic.lead.list.filter.lists' => ' Segment-Mitgliedschaft',
    'mautic.lead.list.filter.lead_asset_download' => 'Ein bestimmtes Asset heruntergeladen',
    'mautic.lead.list.filter.lead_email_received' => 'Eine bestimmte E-Mail lesen',
    'mautic.lead.list.filter.lead_email_sent' => 'Wurde eine bestimmte E-Mail gesendet',
    'mautic.lead.list.filter.lead_email_sent_date' => 'Beliebige E-Mail gesendet (Datum)',
    'mautic.lead.list.filter.lead_email_read_date' => 'Beliebige E-Mails gelesen (Datum)',
    'mautic.lead.list.filter.lead_email_read_count' => 'Beliebige E-Mail x-mal gelesen',
    'mautic.lead.list.filter.visited_url' => 'Besuchte X URL',
    'mautic.lead.list.filter.visited_url_count' => 'Besuchte beliebige URL x-mal',
    'mautic.lead.list.filter.url_title' => 'Besuchte beliebige URL mit X als Seitentitel',
    'mautic.lead.list.filter.source' => 'Besuchte beliebige URL von X Quelle',
    'mautic.lead.list.filter.source.id' => 'Besuchte beliebige URL von X Quellen ID',
    'mautic.lead.list.filter.session' => 'Hat X Browsersitzungen',
    'mautic.lead.list.filter.page_id' => 'Hat eine bestimmte Landing Page besucht',
    'mautic.lead.list.filter.placeholder' => 'Segmentkategoriefilter',
    'mautic.lead.list.filter.referer' => 'Besuchte beliebige URL von X Referrer',
    'mautic.lead.list.filter.visited_url_date' => 'Besuchte beliebige URL (Datum)',
    'mautic.lead.list.source.segment.category' => 'Segmentkategorie',
    'mautic.lead.list.filter.notification' => 'Wurde beliebige Push-Benachrichtigung gesendet',
    'mautic.lead.list.filter.owner' => 'Eigentümer',
    'mautic.lead.list.filter.tags' => 'Tags',
    'mautic.lead.list.filter.device_type' => 'Device Typ',
    'mautic.lead.list.filter.device_brand' => 'Device Marke',
    'mautic.lead.list.filter.device_os' => 'Device Betriebssystem',
    'mautic.lead.list.filter.device_model' => 'Device Modell:',
    'mautic.lead.list.filter.redirect_id' => 'Klickte beliebigen Link aus beliebigem Kanal',
    'mautic.lead.list.filter.email_id' => 'Klickte beliebigen Link aus beliebigen E-Mail',
    'mautic.lead.list.filter.email_clicked_link_date' => 'Klickte beliebigen Link aus beliebigen E-Mail (Datum)',
    'mautic.lead.list.filter.sms_clicked_link' => 'Klickte beliebigen Link aus beliebiger Textnachricht',
    'mautic.lead.list.filter.sms_clicked_link_date' => 'Klickte beliebigen Link aus beliebiger Textnachricht (Datum)',
    'mautic.lead.list.form.config.segment_rebuild_time.message' => 'Dieses Segment wurde 1 Stunde lang nicht aktualisiert.|Dieses Segment wurde %count% Stunden lang nicht aktualisiert.',
    'mautic.lead.list.form.config.segment_rebuild_time_warning' => 'Warnung anzeigen, wenn das Segment X Stunden lang nicht aktualisiert wurde',
    'mautic.lead.list.form.config.segment_rebuild_time_warning.tooltip' => 'Neben einem Segmentnamen wird ein rotes Ausrufezeichen angezeigt',
    'mautic.lead.list.form.config.segment_build_time.message' => 'Die Erstellungszeit dieses Segments beträgt %count% Sekunden.',
    'mautic.lead.list.form.config.segment_build_time_warning' => 'Warnung anzeigen, wenn die Segmenterstellungszeit länger als X Sekunden ist',
    'mautic.lead.list.form.config.segment_build_time_warning.tooltip' => 'Neben einem Segmentnamen wird ein rotes Uhrensymbol angezeigt',
    'mautic.lead.list.form.confirmbatchdelete' => 'Ausgewählte Segmente löschen?',
    'mautic.lead.list.form.confirmdelete' => 'Das Segment %name% löschen?',
    'mautic.lead.list.form.filters.add' => 'Filter hinzufügen',
    'mautic.lead.list.form.filtervalue' => 'Filterwert',
    'mautic.lead.list.form.glue.and' => 'und',
    'mautic.lead.list.form.glue.or' => 'oder',
    'mautic.lead.list.form.isglobal' => 'Für andere Benutzer sichtbar',
    'mautic.lead.list.form.isglobal.tooltip' => 'Nur Benutzer innerhalb von Mautic können dieses Segment sehen. Wenn deaktiviert, ist dieses Segment nur für Sie verfügbar.',
    'mautic.lead.list.form.publicname' => 'Öffentlicher Name',
    'mautic.lead.list.form.publicname.tooltip' => 'Name im Preference Center sichtbar',
    'mautic.lead.list.form.isPreferenceCenter' => 'Im Preference Center verfügbar',
    'mautic.lead.list.form.isPreferenceCenter.tooltip' => 'Das Segment kann über den Kontakt im Einstellungscenter bearbeitet werden.',
    'mautic.lead.list.form.operator.between' => 'zwischen',
    'mautic.lead.list.form.operator.equals' => 'gleich',
    'mautic.lead.list.form.operator.greaterthan' => 'größer als',
    'mautic.lead.list.form.operator.greaterthanequals' => 'gleich oder grösser',
    'mautic.lead.list.form.operator.in' => 'einschließlich',
    'mautic.lead.list.form.operator.isempty' => 'leer',
    'mautic.lead.list.form.operator.islike' => 'wie',
    'mautic.lead.list.form.operator.isnotempty' => 'nicht leer',
    'mautic.lead.list.form.operator.regexp' => 'regexp',
    'mautic.lead.list.form.operator.notregexp' => 'not regexp',
    'mautic.lead.list.form.operator.isnotlike' => 'nicht wie',
    'mautic.lead.list.form.operator.lessthan' => 'kleiner als',
    'mautic.lead.list.form.operator.lessthanequals' => 'kleiner als oder gleich',
    'mautic.lead.list.form.operator.notbetween' => 'nicht zwischen',
    'mautic.lead.list.form.operator.notequals' => 'nicht gleich',
    'mautic.lead.list.form.operator.notin' => 'außer',
    'mautic.lead.list.form.startTyping' => 'Beginne mit der Eingabe',
    'mautic.lead.list.frequency.number' => 'Nicht öfter kontaktieren als',
    'mautic.lead.list.form.operator.date' => 'Datum',
    'mautic.lead.list.frequency.rules.msg' => 'Frequenzregeln wurden angepasst',
    'mautic.lead.list.frequency.times' => 'Jeweils X Nachrichten',
    'mautic.lead.list.header.edit' => 'Segment bearbeiten - %name%',
    'mautic.lead.list.header.index' => 'Kontakt-Segmente',
    'mautic.lead.list.header.new' => 'Neues Segment',
    'mautic.lead.list.help.alias' => 'Buchstaben und Zahlen (ohne Leerzeichen) zur Identifizierung dieses Segments',
    'mautic.lead.list.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (Komma-getrennte IDs, keine Leerzeichen)<br />is:global<br />name:*<br />category:category-alias',
    'mautic.lead.list.menu.index' => 'Segmente',
    'mautic.lead.list.searchcommand.isglobal' => 'is:global',
    'mautic.lead.list.thead.leadcount' => '# Kontakte',
    'mautic.lead.list.view' => '%objects% anzeigen',
    'mautic.lead.list.view_contacts' => 'Kontakte anzeigen',
    'mautic.lead.list.view_companies' => 'Unternehmen anzeigen',
    'mautic.lead.list.viewleads_count' => '{0} Keine Kontakte|{1} 1 Kontakt anzeigen|]1,Inf[ %count% Kontakte anzeigen',
    'mautic.lead.list.month_last' => 'letzter Monat',
    'mautic.lead.list.month_next' => 'nächster Monat',
    'mautic.plugin.actions.tooltip' => 'Ein Kontakt zur ausgewählten Integration weitergeben.',
    'mautic.lead.list.month_this' => 'dieser Monat',
    'mautic.lead.list.today' => 'heute',
    'mautic.lead.list.tomorrow' => 'morgen',
    'mautic.lead.list.yesterday' => 'gestern',
    'mautic.lead.list.week_last' => 'letzte Woche',
    'mautic.lead.list.week_next' => 'nächste Woche',
    'mautic.lead.list.week_this' => 'diese Woche',
    'mautic.lead.list.year_last' => 'letztes Jahr',
    'mautic.lead.list.year_next' => 'nächstes Jahr',
    'mautic.lead.list.year_this' => 'dieses Jahr',
    'mautic.lead.list.anniversary' => 'Jahrestag',
    'mautic.lead.list.checkall.help' => 'Wenn Sie mehrere Kontakte gleichzeitig auswählen, wird oben in der Liste ein grüner Dropdown-Pfeil angezeigt. Sie können mehrere Aktionen über diese Dropdown-Liste verwalten (z. B. Segmente ändern oder die "Nicht Kontaktieren"-Funktion festlegen).',
    'mautic.lead.merge' => 'Zusammenführen',
    'mautic.lead.merge.count' => '%count% Kontakte wurden zusammengeführt.',
    'mautic.lead.merge.select' => 'Wählen Sie den Kontakt für die Zusammenführung:',
    'mautic.lead.merge.select.tooltip' => 'Wählen Sie den Kontakt für die Zusammenführung.',
    'mautic.lead.merge.select.modal.tooltip' => 'Filtern Sie die Optionen, indem Sie das Suchfeld nutzen und dann den Lead zum Zusammenfügen auswählen.',
    'mautic.lead.note.confirmdelete' => 'Diese Notiz löschen?',
    'mautic.lead.note.details' => 'Am %dateAdded% schrieb %author%:',
    'mautic.lead.note.event' => 'Notiz für %lead%',
    'mautic.lead.note.form.text' => 'Notiztext',
    'mautic.lead.note.form.type' => 'Notiztyp',
    'mautic.lead.note.header.edit' => 'Notiz ändern',
    'mautic.lead.note.header.new' => 'Neue Notiz',
    'mautic.lead.note.notes' => 'Kontakt-Notizen',
    'mautic.lead.note.searchcommand.call' => 'Anruf',
    'mautic.lead.note.searchcommand.email' => 'E-Mail',
    'mautic.lead.note.searchcommand.general' => 'generell',
    'mautic.lead.note.searchcommand.meeting' => 'Meeting',
    'mautic.lead.note.searchcommand.type' => 'Typ',
    'mautic.lead.note.type.call' => 'Anruf',
    'mautic.lead.note.type.email' => 'E-Mail',
    'mautic.lead.note.type.general' => 'Generell',
    'mautic.lead.note.type.meeting' => 'Meeting',
    'mautic.lead.permissions.fields' => 'Benutzerdefinierte Felder, auf die der User Zugriff hat',
    'mautic.lead.permissions.header' => 'Kontakt-Berechtigungen',
    'mautic.lead.permissions.leads' => 'Kontakte, auf die der Nutzer zugreifen kann',
    'mautic.lead.permissions.lists' => 'Segmente, auf die der Nutzer zugreifen kann',
    'mautic.lead.permissions.imports' => 'Import - Benutzer hat Zugriff auf',
    'mautic.lead.point.trigger' => 'Kontakt-Trigger',
    'mautic.lead.point.trigger.changelists' => 'Kontakt-Segmente anpassen',
    'mautic.lead.points' => 'Punkte',
    'mautic.lead.points.count' => '{0}0 Punkte|{1}1 Punkt|]1,Inf[%count% Punkte|{-1}-1 Punkt|]-Inf,-1[%count% Punkte',
    'mautic.lead.groups.panel.title' => 'Gruppenpunkte',
    'mautic.lead.remove_dnc_status' => 'Kontakt wieder aktivieren',
    'mautic.lead.report.attribution.multi' => 'Multi Touch Zuordnungen',
    'mautic.lead.report.attribution.first' => 'First Touch Zuordnungen',
    'mautic.lead.report.attribution.last' => 'Last Touch Zuordnungen',
    'mautic.lead.report.attribution.campaign_id' => 'Kampagnen-ID',
    'mautic.lead.report.attribution.campaign_name' => 'Kampagnen-Bezeichnung',
    'mautic.lead.report.attribution.channel' => 'Kanal',
    'mautic.lead.report.attribution.channel_action' => 'Typ der Kanalaktion',
    'mautic.lead.report.attribution.action_name' => 'Bezeichnung der Kanalaktion',
    'mautic.lead.report.attribution.action_date' => 'Datum der Kanalaktion',
    'mautic.lead.report.attribution.filter.stage' => 'Kontakt-Phase',
    'mautic.lead.report.attribution.filter.campaign' => 'Kampagne',
    'mautic.lead.report.attribution.stage_id' => 'Phasen-ID',
    'mautic.lead.report.attribution.stage_name' => 'Phasen-Bezeichnung',
    'mautic.lead.report.attribution.stage_date_added' => 'Phase Datum hinzugefügt',
    'mautic.lead.report.contact_id' => 'Kontakt-ID',
    'mautic.lead.report.field.lead.label' => 'Kontakt %field%',
    'mautic.lead.report.date_identified' => 'Datum erkannt',
    'mautic.lead.report.owner_firstname' => 'Inhaber Vorname',
    'mautic.lead.report.owner_id' => 'Inhaber ID',
    'mautic.lead.report.owner_lastname' => 'Inhaber Nachname',
    'mautic.lead.report.points.action_name' => 'Punkte-Eventaktion',
    'mautic.lead.report.points.date_added' => 'Punkte-Änderung Datum',
    'mautic.lead.report.points.delta' => 'Punkte-Änderung',
    'mautic.lead.report.points.event_name' => 'Punkte-Eventname',
    'mautic.lead.report.points.table' => 'Kontakt-Punkte Log',
    'mautic.lead.report.points.type' => 'Punkte-Ereignistyp',
    'mautic.lead.report.points.id' => 'Punkt ID',
    'mautic.lead.report.points.group_id' => 'Gruppen ID',
    'mautic.lead.report.points.group_name' => 'Gruppenname',
    'mautic.lead.report.segment.id' => 'Segment ID',
    'mautic.lead.report.segment.membership' => ' Segment-Mitgliedschaft',
    'mautic.lead.report.segment.log' => 'Kontakt Segements-Aktivitätsprotokoll ',
    'mautic.lead.report.segment.manually_added' => 'Manuel hinzugefügt',
    'mautic.lead.report.segment.manually_removed' => 'Manuell entfernt',
    'mautic.lead.report.segment.date_added' => 'Zu Segement hinzugefügt am',
    'mautic.lead.report.segment.date_removed' => 'Von Segement entfernt am',
    'mautic.lead.report.utm.utm_tag' => 'UTM-Tags',
    'mautic.lead.report.utm.campaign' => 'UTM-Kampagne',
    'mautic.lead.report.utm.content' => 'UTM-Inhalte',
    'mautic.lead.report.utm.medium' => 'UTM-Medium',
    'mautic.lead.report.utm.source' => 'UTM-Quelle',
    'mautic.lead.report.utm.term' => 'UTM-Begriff',
    'mautic.lead.report.dnc' => 'Nicht kontaktieren',
    'mautic.lead.report.dnc_comment' => 'DNC Kommentar',
    'mautic.lead.report.dnc_contactable' => 'Kontaktierbar',
    'mautic.lead.report.dnc_unsubscribed' => 'DNC abgemeldet',
    'mautic.lead.report.dnc_bounced' => 'DNC gebounced',
    'mautic.lead.report.dnc_manual' => 'DNC manuell abgemeldet',
    'mautic.lead.report.dnc_reason' => 'DNC Grund',
    'mautic.lead.report.dnc_channel' => 'DNC Kanal',
    'mautic.lead.report.dnc_channel_id' => 'DNC Kanal ID',
    'mautic.lead.report.dnc_date_added' => 'DNC Datum',
    'mautic.lead.report.devices' => 'Devices',
    'mautic.lead.report.dev_date_added' => 'Gerät hinzugefügt am',
    'mautic.lead.report.dev_client_info' => 'Gerät Clientinformationen',
    'mautic.lead.report.dev_device' => 'Device Typ',
    'mautic.lead.report.dev_device_os_name' => 'Gerät OS Name',
    'mautic.lead.report.dev_device_os_version' => 'Device Betriebssystemversion',
    'mautic.lead.report.dev_device_os_platform' => 'Device OS Plattform',
    'mautic.lead.report.dev_device_brand' => 'Device Marke',
    'mautic.lead.report.dev_device_model' => 'Device Modell',
    'mautic.lead.integrations.header' => 'Keine Integrationsbeziehungen gefunden',
    'mautic.lead.socialprofiles.header' => 'Social Profil nicht gefunden',
    'mautic.lead.auditlog.header' => 'Keine Überwachungsprotokolleinträge gefunden',
    'mautic.lead.socialprofiles.noresults' => 'Hier klicken, um basierend auf den verfügbaren Profilinformationen nach Profilen in sozialen Netzwerken zu suchen. (Soziale Netzwerke müssen im Integrationsmanager konfiguriert werden.)',
    'mautic.lead.stage' => 'In Phase: %stage%',
    'mautic.lead.stage.label' => 'Phase',
    'mautic.lead.table.most.points' => 'Kontakte mit den meisten Punkten',
    'mautic.lead.table.top.actions' => 'Top Aktionen',
    'mautic.lead.table.top.cities' => 'Top Städte',
    'mautic.lead.table.top.countries' => 'Top Länder',
    'mautic.lead.table.top.events' => 'Top Ereignisse',
    'mautic.lead.tags' => 'Tags',
    'mautic.lead.tags.add' => 'Tags hinzufügen',
    'mautic.lead.tags.enter_to_create' => 'Drücken Sie Enter zum Erstellen',
    'mautic.lead.tags.remove' => 'Tags entfernen',
    'mautic.lead.tags.select_or_create' => 'Neuen Tag wählen oder eingeben',
    'mautic.lead.timeline.campaign_membership' => 'Kampagnen-Mitgliedschaft ändern',
    'mautic.lead.timeline.campaign_membership_added_by_object' => 'Kontakt zu Kampagne %name% hinzugefügt',
    'mautic.lead.timeline.campaign_membership_removed_by_object' => 'Kontakt von Kampagne %name% entfernt',
    'mautic.lead.timeline.created_source' => 'Kontakt erstellt von Quelle',
    'mautic.lead.timeline.displaying_events' => 'Anzeigen der %total% Ereignisse',
    'mautic.lead.timeline.events_new' => 'Neu',
    'mautic.lead.timeline.user_name' => 'Benutzername/Quellenname',
    'mautic.lead.timeline.event_name' => 'Ereignis Name',
    'mautic.lead.timeline.event_type' => 'Ereignis Typ',
    'mautic.lead.timeline.event_timestamp' => 'Ereignis Timestamp',
    'mautic.lead.timeline.event.utmcampaign' => 'UTM-Kampagne',
    'mautic.lead.timeline.event.utmcontent' => 'UTM-Inhalte',
    'mautic.lead.timeline.event.utmmedium' => 'UTM-Medium',
    'mautic.lead.timeline.event.umtsource' => 'UTM-Quelle',
    'mautic.lead.timeline.event.utmtags' => 'UTM-Tags ',
    'mautic.lead.timeline.event.utmterm' => 'UTM-Begriff',
    'mautic.lead.timeline.identified_source' => 'Kontakt identifiziert von Quelle',
    'mautic.lead.timeline.lead.source.created' => 'Kontakt wurde durch unbekannte Quelle angelegt (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.created_by_object' => 'Kontakt wurde angelegt durch %name%',
    'mautic.lead.timeline.lead.source.identified' => 'Kontakt wurde durch unbekannte Quelle identifiziert (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.identified_by_object' => 'Kontakt wurde identifiziert durch %name%',
    'mautic.lead.timeline.segment_membership' => 'Segment-Mitgliedschaft ändern',
    'mautic.lead.timeline.segment_membership_added_by_object' => 'Kontakt zu Segment %name% hinzugefügt',
    'mautic.lead.timeline.segment_membership_removed_by_object' => 'Kontakt von Segment %name% entfernt',
    'mautic.lead.timeline.toggle_all_details' => 'Alle Ereignisdetails ein-/ausblenden.',
    'mautic.lead.timeline.toggle_details' => 'Details ein-/ausblenden',
    'mautic.lead.tooltip.grid' => 'Grid-Ansicht',
    'mautic.lead.dashboard.widgets' => 'Kontakt-Widgets',
    'mautic.widget.created.leads.in.time' => 'Erstellte Kontakte im Zeitverlauf',
    'mautic.widget.device.granularity' => 'Device Granularität',
    'mautic.widget.anonymous.vs.identified.leads' => 'Anonyme gegen erkannte Kontakte',
    'mautic.widget.map.of.leads' => 'Karte',
    'mautic.widget.lead.lifetime' => 'Lebenszyklus',
    'mautic.lead.list.filter' => 'Segment-Filter',
    'mautic.widget.top.lists' => 'Top Segmente',
    'mautic.lead.show.all' => 'Alle Kontakte anzeigen',
    'mautic.lead.show.top' => 'Top Segmente',
    'mautic.lead.show.identified.vs.anonymous' => 'Alle erkannten gegen anonyme Kontakte',
    'mautic.lead.show.top.leads.identified.vs.anonymous' => 'Top Segmente mit erkannten gegen anonyme Kontakte',
    'mautic.widget.top.owners' => 'Top Kontakt Inhaber',
    'mautic.widget.top.creators' => 'Top Kontakt Ersteller',
    'mautic.widget.segments.build.time' => 'Segment-Erstellungszeit',
    'mautic.widget.segments.build.time.longest' => 'Längste Zeit',
    'mautic.widget.segments.build.time.shortest' => 'Kürzeste Zeit',
    'mautic.widget.created.leads' => 'Erstellte Kontakte',
    'mautic.lead.show.identified' => 'Nur erkannte',
    'mautic.lead.show.anonymous' => 'Nur anonyme',
    'mautic.lead.all.leads' => 'Alle Kontakte',
    'mautic.lead.identified' => 'Erkannt',
    'mautic.lead.tooltip.list' => 'Listenansicht',
    'mautic.lead.webhook.event.lead.deleted' => 'Kontakt löscht Ereignis',
    'mautic.lead.webhook.event.lead.deleted_desc' => 'Wird ausgelöst, wenn ein ein Kontakt gelöscht wird',
    'mautic.lead.webhook.event.lead.new' => 'Kontakt identifiziert Event',
    'mautic.lead.webhook.event.lead.new_desc' => 'Wird ausgelöst, wenn ein ein Kontakt identifiziert wird',
    'mautic.lead.webhook.event.lead.points' => 'Kontakt-Punkte Event geändert',
    'mautic.lead.webhook.event.lead.points_desc' => 'Wird ausgelöst, wenn sich die Kontakt-Punkte ändern',
    'mautic.lead.webhook.event.lead.update' => 'Kontakt Aktualisierung Ereignis',
    'mautic.lead.webhook.event.lead.update_desc' => 'Wird ausgelöst, wenn ein ein Kontakt aktualisiert wird',
    'mautic.lead.webhook.event.lead.dnc' => 'Kontaktiere zur Änderung des Channel-Abonnements',
    'mautic.lead.webhook.event.lead.dnc_desc' => 'Wird ausgelöst, wenn der Channel-Abonnementstatus eines Kontakts geändert wird.',
    'mautic.lead.webhook.event.lead.company.change' => 'Kontakt Unternehmens-Abonnement Änderungs-Ereignis',
    'mautic.lead.webhook.event.lead.company.change.desc' => 'Wird ausgelöst, wenn ein Unternehmen zum/vom Kontakt hinzugefügt oder daraus entfernt wird',
    'mautic.lead.webhook.event.company.new_or_update' => 'Unternehmens Erstellungs-/Aktualisierungs-Ereignis',
    'mautic.lead.webhook.event.company.new_or_update_desc' => 'Wird ausgelöst, wenn ein Unternehmen erstellt/aktualisiert wird',
    'mautic.lead.webhook.event.company.deleted' => 'Unternehmen gelöscht Ereignis',
    'mautic.lead.webhook.event.company.deleted_desc' => 'Wird ausgelöst, wenn ein Unternehmen gelöscht wird',
    'mautic.lead.webhook.event.lead.segment.change' => 'Kontakt Segment-Mitgliedschafts-Änderungs-Ereignis',
    'mautic.lead.webhook.event.lead.segment.change.desc' => 'Wird ausgelöst, wenn die Mitgliedschaft in einem Kontaktsegment geändert wird',
    'mautic.lead.campaign.event.field' => 'Kontakt-Feld',
    'mautic.lead.campaign.event.field_descr' => 'Wählen Sie das Kontakt-Feld, das den Wert beinhaltet, den Sie vergleichen möchten.',
    'mautic.lead.campaign.event.device_type' => 'Device Typ',
    'mautic.lead.campaign.event.device_brand' => 'Device Marke',
    'mautic.lead.campaign.event.device_os' => 'Device Betriebssystem',
    'mautic.lead.campaign.event.point_operator' => 'Operator',
    'mautic.lead.campaign.event.point_score' => 'Punktestand',
    'mautic.lead.campaign.event.point_group' => 'Punktegruppe',
    'mautic.lead.campaign.event.point_group.help' => 'Leer lassen, um die Hauptpunktzahl zu verwenden',
    'mautic.maintenance.visitors' => 'Besucher',
    'mautic.report.group.contacts' => 'Kontakte',
    'mautic.report.field.company.label' => 'Unternehmen %field%',
    'mautic.lead.exists.by.field' => 'Ein Kontakt mit diesem Wert existiert bereits',
    'mautic.lead.field.object' => 'Objekt',
    'mautic.companies.menu.index' => 'Unternehmen',
    'mautic.companies.menu.root' => 'Unternehmen',
    'mautic.company.action.noresults.tip' => 'Erstellen Sie ein Unternehmen, um Kontakte zu gruppieren, die zu einem Unternehmen gehören. Das wird Ihnen auch dabei helfen, Informationen über Unternehmen zu sammeln, die Sie ansprechen wollen.',
    'mautic.company.menu.new' => 'Neues Unternehmen',
    'mautic.company.menu.edit' => 'Unternehmen %name% ändern',
    'mautic.company.name' => 'Firmenname',
    'mautic.company.company.number' => 'Unternehmensnummer',
    'mautic.company.company.source' => 'Unternehmen Quelle',
    'mautic.company.annual.revenue' => 'Jährlicher Umsatz',
    'mautic.company.email' => 'Unternehmen E-Mail',
    'mautic.company.website' => 'Unternehmen Webseite',
    'mautic.company.phone' => 'Unternehmen Telefon',
    'mautic.company.fax' => 'Unternehmen Fax',
    'mautic.company.numberOfEmployees' => 'Anzahl Mitarbeiter',
    'mautic.company.score' => 'Punktestand',
    'mautic.company.score.count' => '{0}0 Punkte|{1}1 Punkt|]1,Inf[%count% Punkte|{-1}-1 Punkt|]-Inf,-1[%count% Punkte',
    'mautic.company.address1' => 'Adresszeile 1',
    'mautic.company.address2' => 'Adresszeile 2',
    'mautic.company.city' => 'Ort',
    'mautic.company.state' => 'Bundesland',
    'mautic.company.country' => 'Land',
    'mautic.company.zipcode' => 'Postleitzahl',
    'mautic.company.company' => 'Firma',
    'mautic.lead.company.viewleads_count' => '%count% Kontakte ansehen',
    'mautic.lead.lead.companies' => 'Unternehmen',
    'mautic.lead.lead.segment.add.help' => 'Wenn Sie eine CSV-Kontaktdatei in ein Segment hochladen, wird diese zu einer statischen Liste. Durch das Anwenden zusätzlicher Filter auf dieses Segment werden keine Kontakte aus der hochgeladenen Liste entfernt.',
    'mautic.lead.lead.segment.filter.info' => 'Kontakte, die den Filtern entsprechen, werden hinzugefügt und Kontakte, die nicht mehr übereinstimmen, werden entfernt. Manuell hinzugefügte Kontakte bleiben unverändert.',
    'mautic.lead.lead' => 'Kontakt',
    'mautic.lead.company' => 'Hauptunternehmen',
    'mautic.lead.lead.header.companies' => 'Kontakt zu Unternehmen hinzufügen',
    'mautic.lead.lead.events.addtocompany' => 'Zum Unternehmen hinzufügen',
    'mautic.lead.lead.events.addtocompany_descr' => 'Diese Aktion wird die Kontakte zum gewählten Unternehmen hinzufügen',
    'mautic.lead.lead.events.changeowner' => 'Kontaktbesitzer aktualisieren',
    'mautic.lead.lead.events.changeowner_descr' => 'Diese Aktion aktualisiert den Kontaktinhaber als Teil einer Kampagne',
    'mautic.company.selectcompany' => 'Unternehmen auswählen',
    'mautic.company.selectcompany_descr' => 'Kontakte die in dieser Kampagne angesprochen sind, werden zu dem gewählten Unternehmen hinzugefügt',
    'mautic.company.new.company' => 'Neues Unternehmen',
    'mautic.company.field.address' => 'Unternehmensadresse',
    'mautic.company.form.confirmdelete' => 'Dieses Unternehmen löschen?',
    'mautic.company.form.confirmbatchdelete' => 'Diese Unternehmen löschen?',
    'mautic.lead.field.companyemail' => 'Unternehmen E-Mail',
    'mautic.lead.field.companyname' => 'Firmenname',
    'mautic.lead.field.companyaddress1' => 'Adresse 1',
    'mautic.lead.field.companyaddress2' => 'Adresse 2',
    'mautic.lead.field.companycity' => 'Ort',
    'mautic.lead.field.companystate' => 'Bundesland',
    'mautic.lead.field.companycountry' => 'Land',
    'mautic.lead.field.companyzipcode' => 'Postleitzahl',
    'mautic.lead.field.companyindustry' => 'Branche',
    'mautic.lead.field.companyphone' => 'Telefon',
    'mautic.lead.field.companydescription' => 'Beschreibung',
    'mautic.lead.field.companywebsite' => 'Webseite',
    'mautic.lead.field.companynumber_of_employees' => 'Anzahl Mitarbeiter',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Jährlicher Umsatz',
    'mautic.lead.company.field.owner' => 'Unternehmen Betreuer',
    'mautic.lead.preferred.channels' => 'Bevorzugt',
    'mautic.lead.preferred.categories' => 'Kategorien',
    'mautic.lead.preferred.segments' => 'Segmente',
    'mautic.lead.preferred.campaigns' => 'Kampagnen',
    'mautic.lead.list.frequency.preferred.channel' => 'Ich bevorzuge die Kommunikation per',
    'mautic.lead.list.last_built_time' => 'Letzte Erstellungszeit',
    'mautic.lead.form.list' => ' Meine Segmente',
    'mautic.lead.frequency.contact.start.date' => 'Von',
    'mautic.lead.frequency.contact.end.date' => 'bis',
    'mautic.lead.frequency.dates.label' => 'Pausieren ab',
    'mautic.lead.contact.me.label' => 'Kontaktieren Sie mich via %channel%',
    'mautic.lead.form.categories' => ' Meine Kategorien',
    'mautic.lead.preferred.frequency' => 'Frequenz',
    'mautic.lead.company.set.primary' => 'Klicken um Primary rückgängig zu machen',
    'mautic.lead.graph.line.companies' => 'Unternehmen nach Zeitpunkt',
    'mautic.lead.all.companies' => 'Alle Unternehmen',
    'mautic.lead.graph.pie.companies.industry' => 'Unternehmen nach Branche',
    'mautic.lead.table.pie.company.country' => 'Unternehmen nach Land',
    'mautic.lead.company.table.top.cities' => 'Unternehmen nach Stadt',
    'mautic.report.group.companies' => 'Unternehmen',
    'mautic.lead.report.company.company_id' => 'Unternehmens-ID',
    'mautic.lead.report.company.is_primary' => 'Ist Haupt-Unternehmen',
    'mautic.lead.report.company.date_added' => 'Zu Unternehmen hinzugefügt am',
    'mautic.lead.company.header.merge' => 'Aktuelles Unternehmen zusammenfügen',
    'mautic.company.to.merge.into' => 'Wähle ein Unternehmen für das Zusammenfügen',
    'mautic.lead.lead.events.changecompanyscore' => 'Zum Firmenscore hinzufügen',
    'mautic.lead.lead.events.changecompanyscore_descr' => 'Durch diese Aktion wird der angegebene Wert des Unternehmens um den angegebenen Wert erhöht',
    'mautic.lead.timeline.displaying_events_for_contact' => 'für Kontakt:%contact% (d%)',
    'mautic.lead.list.filter.categories' => ' Abonnierte Kategorien',
    'mautic.lead.list.filter.utmcampaign' => 'UTM-Kampagne',
    'mautic.lead.list.filter.utmcontent' => 'UTM-Inhalte',
    'mautic.lead.list.filter.utmmedium' => 'UTM-Medium',
    'mautic.lead.list.filter.utmsource' => 'UTM-Quelle',
    'mautic.lead.list.filter.utmterm' => 'UTM-Begriff',
    'mautic.lead.audit.created' => 'Der Kontakt wurde erstellt.',
    'mautic.lead.audit.deleted' => 'Der Kontakt wurde gelöscht.',
    'mautic.lead.audit.updated' => 'Der Kontakt wurde aktualisiert.',
    'mautic.lead.audit.identified' => 'Der Kontakt wurde identifiziert.',
    'mautic.lead.audit.merged' => 'Der Kontakt wurde zusammengeführt.',
    'mautic.lead.audit.originip' => 'Ursprung der IP',
    'mautic.lead.audit.accessed' => 'Der Kontakt wurde aufgerufen von:',
    'mautic.lead.audit.log.field' => 'Feld/Objekt',
    'mautic.lead.audit.log.new_value' => 'Neuer Wert',
    'mautic.lead.audit.log.old_value' => 'Alter Wert',
    'mautic.lead.report.frequency.messages' => 'Frequenz Regeln',
    'mautic.lead.report.frequency.frequency_number' => 'Frequenz',
    'mautic.lead.report.frequency.frequency_time' => 'Frequenz Zeit',
    'mautic.lead.report.frequency.channel' => 'Frequenz Channel',
    'mautic.lead.report.frequency.preferred_channel' => 'Bevorzugter Channel',
    'mautic.lead.report.frequency.pause_from_date' => 'Pausieren ab',
    'mautic.lead.report.frequency.pause_to_date' => 'Pausieren bis',
    'mautic.lead.report.frequency.date_added' => 'Frequenzregeln hinzugefügt am',
    'mautic.segment.contact.manually.added' => 'Manuell hinzugefügte Kontakte',
    'mautic.segment.contact.manually.removed' => 'Manuell entfernte Kontakte',
    'mautic.segment.contact.filter.added' => 'Hinzugefügte Kontakte filtern',
    'mautic.segment.segment' => 'Segment',
    'mautic.segment.stats' => 'Kontakte im Zeitverlauf',
    'mautic.segment.form.confirmdelete' => 'Das Segment %name% löschen?',
    'mautic.lead.segments.contacts' => 'Alle Kontakte',
    'mautic.lead.segments.contacts.added' => 'Hinzugefügt',
    'mautic.lead.segments.contacts.removed' => 'Entfernt',
    'mautic.lead.segments.contacts.total' => 'Gesamt',
    'mautic.channel.stat.leadcount.tooltip' => 'Die Details stimmen möglicherweise nicht mit den Summen überein, wenn der Kontakt nicht mehr in Mautic existiert oder wenn ein Kontakt die Nachricht mehrmals gesendet hat',
    'mautic.lead.segments.usages' => 'Segment Nutzungen',
    'mautic.lead.segments.no_usages' => 'Es sieht so aus, als ob dieses Segment nicht verwendet wird.',
    'mautic.lead.campaign.share' => 'Kampagne teilen',
    'mautic.lead.share' => 'Teilen',
    'mautic.lead.field.notfound' => 'Lead Feld wurde nicht gefunden',
    'mautic.lead.field.column_was_created' => 'Spalte mit ID %id% wurde erstellt',
    'mautic.lead.field.column_already_created' => 'Spalte wurde bereits erstellt',
    'mautic.lead.field.column_creation_aborted' => 'Die Spaltenerstellung wurde abgebrochen',
    'mautic.lead.field.column_update_aborted' => 'Spaltenaktualisierung wurde abgebrochen',
    'mautic.lead.field.column_was_updated' => 'Spalte wurde aktualisiert',
    'mautic.lead.field.max_column_error' => 'Sie haben die zulässige Obergrenze für benutzerdefinierte Felder in Ihrer Datenbank erreicht.',
    'mautic.lead.field.pushed_to_background' => 'Ihr benutzerdefiniertes Feld wird erstellt. Wir benachrichtigen Sie, wenn es fertig ist',
    'mautic.lead.field.update_pushed_to_background' => 'Ihr benutzerdefiniertes Feld wird aktualisiert. Wir benachrichtigen Sie, wenn die Aktualisierung abgeschlossen ist.',
    'mautic.lead.field.being_created_in_background' => 'Benutzerdefiniertes Feld wird im Hintergrund erstellt',
    'mautic.lead.field.notification.created_message' => 'Ihr benutzerdefiniertes Feld „%label%“ wurde erstellt',
    'mautic.lead.field.notification.created_header' => 'Benutzerdefiniertes Feld erstellt',
    'mautic.lead.field.notification.updated_message' => 'Ihr benutzerdefiniertes Feld „%label%“ wurde aktualisiert',
    'mautic.lead.field.notification.updated_header' => 'Benutzerdefiniertes Feld aktualisiert',
    'mautic.lead.field.notification.cannot_be_created_message' => 'Benutzerdefiniertes Feld \'%label%\' kann nicht erstellt werden.',
    'mautic.lead.field.notification.cannot_be_created_header' => 'Benutzerdefiniertes Feld kann nicht erstellt werden.',
    'mautic.lead.field.notification.custom_field_limit_hit_message' => 'Das benutzerdefinierte Feld „%label%“ kann nicht erstellt werden – Sie haben das Limit der von Ihrer Datenbank zugelassenen benutzerdefinierten Felder erreicht.',
    'mautic.lead.field.notification.custom_field_limit_hit_header' => 'Benutzerdefiniertes Feld kann nicht erstellt werden.',
    'mautic.lead.command.error' => 'Befehl %name%, Fehler: %error%',
    'mautic.lead.command.delete_contact_secondary_company.allow_multiple_enabled' => 'Die Einstellung „Mehrere Unternehmen für Kontakt“ ist aktiviert, Vorgang wird abgebrochen. (Setzen Sie diese Konfigurationsoption auf „false“, um diesen Befehl auszuführen.)',
    'mautic.lead.command.delete_contact_secondary_company.success' => 'Sekundärfirmen wurden erfolgreich gelöscht.',
    'mautic.lead.stats' => 'Statistiken',
    'mautic.lead.stats.email_title' => 'Kanal: E-Mail',
    'mautic.lead.stats.sent_count' => 'Gesamt gesendet:',
    'mautic.lead.stats.open_rate' => 'Öffnungsrate:',
    'mautic.lead.stats.click_through_rate' => 'Click-through Rate:',
    'mautic.lead.stats.click_through_open_rate' => 'Click-to-Open Rate:',
    'mautic.lead.export.being.prepared' => 'Die Datei steht zur Verarbeitung in der Warteschlange. Die Datei wird an Ihre E-Mail-Adresse „%user_email%“ gesendet. Sie können die Datei über den in der E-Mail angegebenen Link herunterladen.',
    'mautic.lead.export.email_subject' => 'Kontakt-Export: %file_name%',
    'mautic.lead.export.email' => 'Ihr gewünschter Kontakte-Export: <a href="%link%">%label%</a>.',
    'mautic.lead.field.analyse.header.name' => 'Benutzerdefinierter Feldname',
    'mautic.lead.field.analyse.header.alias' => 'Benutzerdefiniertes Feld-Alias',
    'mautic.lead.field.analyse.header.length' => 'Aktuelle Größe',
    'mautic.lead.field.analyse.header.max_length' => 'Derzeit genutzte maximale Größe',
    'mautic.lead.field.analyse.header.suggested_length' => 'Empfohlene maximale Größe',
    'mautic.lead.field.analyse.header.indexed' => 'Ist Index vorhanden',
    'mautic.config.header.index' => 'Konfiguration',
    'mautic.config.menu.index' => 'Konfiguration',
    'mautic.config.restricted' => 'Vom System vorgegeben',
    'mautic.config.notwritable' => 'Die Konfigurationsdatei kann nicht beschrieben werden! Änderungen werden nicht gespeichert.',
    'mautic.config.remove_file_contents' => 'Gespeicherte Inhalte für diese Einstellung entfernen?',
    'mautic.sysinfo.header.index' => 'System-Info',
    'mautic.sysinfo.menu.index' => 'System-Info',
    'mautic.sysinfo.tab.phpinfo' => 'PHP-Info',
    'mautic.sysinfo.tab.recommendations' => 'Vorschläge',
    'mautic.sysinfo.no.recommendations' => 'Es gibt aktuell keine Vorschläge. Der Server ist korrekt konfiguriert.',
    'mautic.sysinfo.tab.folders' => 'Datei- und Ordnerberechtigung',
    'mautic.sysinfo.folders.title' => 'Diese Ordner und Dateien müssen beschreibbar (writeable) sein, um richtig zu funktionieren. ',
    'mautic.sysinfo.folder.path' => 'Ordner-/Dateipfad',
    'mautic.sysinfo.is.writable' => 'Ist beschreibbar',
    'mautic.sysinfo.writable' => 'Beschreibbar',
    'mautic.sysinfo.unwritable' => 'Nicht beschreibbar',
    'mautic.sysinfo.tab.log' => 'Log-Datei',
    'mautic.sysinfo.log.title' => 'Aktuelles Fehler-Log',
    'mautic.sysinfo.log.missing' => 'Das heutige Fehlerlog ist leer. Überprüfe die Server-Logdatei für Fehler, die Mautic nicht erkennen konnte.',
    'mautic.sysinfo.phpinfo.missing' => 'Diese Information ist nicht verfügbar. Die PHP-Funktion phpinfo() ist auf diesem Server deaktiviert.',
    'mautic.sysinfo.phpinfo.phpversion' => 'Die PHP-Funktion phpinfo() ist auf diesem Server deaktiviert. Die aktuelle PHP-Version ist <b>%phpversion%</b>.',
    'mautic.sysinfo.tab.dbinfo' => 'Datenbank Info',
    'mautic.sysinfo.dbinfo.title' => 'Datenbank Info',
    'mautic.sysinfo.dbinfo.property' => 'Eigenschaft',
    'mautic.sysinfo.dbinfo.value' => 'Wert',
    'mautic.sysinfo.dbinfo.version' => 'Version',
    'mautic.sysinfo.dbinfo.driver' => 'Doctrine Treiber',
    'mautic.sysinfo.dbinfo.platform' => 'Doctrine Datenbank Plattform (automatisch erkannt)',
    'mautic.config.dsn.scheme' => 'Schema',
    'mautic.config.dsn.host' => 'Host',
    'mautic.config.dsn.port' => 'Port',
    'mautic.config.dsn.user' => 'Benutzer',
    'mautic.config.dsn.password' => 'Passwort',
    'mautic.config.dsn.path' => 'Pfad',
    'mautic.config.dsn.options' => 'Optionen',
    'mautic.config.dsn.using_current_dsn' => 'Aktuell gespeicherten DSN verwenden',
    'mautic.config.dsn.save_to_test' => 'Speichern Sie die Änderungen, um den DSN zu testen.',
    'mautic.config.tab.social_config' => 'Netzwerk-Einstellungen',
    'mautic.integration.common.about' => 'Über',
    'mautic.integration.common.bio' => 'Bio',
    'mautic.integration.common.birthday' => 'Geburtstag',
    'mautic.integration.common.email' => 'E-Mail',
    'mautic.integration.common.gender' => 'Geschlecht',
    'mautic.integration.common.profileHandle' => 'Social Handle',
    'mautic.integration.enabled' => 'Ist aktiviert?',
    'mautic.integration.Facebook' => 'Facebook',
    'mautic.integration.Facebook.first_name' => 'Vorname',
    'mautic.integration.Facebook.last_name' => 'Nachname',
    'mautic.integration.Facebook.link' => 'Profil',
    'mautic.integration.Facebook.locale' => 'Ort',
    'mautic.integration.Facebook.middle_name' => 'Zweiter Vorname',
    'mautic.integration.Facebook.name' => 'Vollständiger Name',
    'mautic.integration.Facebook.political' => 'Politisch',
    'mautic.integration.Facebook.quotes' => 'Angebote',
    'mautic.integration.Facebook.religion' => 'Religion',
    'mautic.integration.Facebook.timezone' => 'Zeitzone',
    'mautic.integration.Facebook.website' => 'Webseite',
    'mautic.integration.Facebook.ProfileLink' => 'Profil Link',
    'mautic.integration.Facebook.share.action' => 'Aktionstext',
    'mautic.integration.Facebook.share.action.like' => 'Like',
    'mautic.integration.Facebook.share.action.recommend' => 'Empfehlen',
    'mautic.integration.Facebook.share.action.share' => 'Teilen',
    'mautic.integration.Facebook.share.layout' => 'Layout',
    'mautic.integration.Facebook.share.layout.boxcount' => 'Vertikal mit Zähler',
    'mautic.integration.Facebook.share.layout.button' => 'Horizontal ohne Zähler',
    'mautic.integration.Facebook.share.layout.buttoncount' => 'Horizontal mit Zähler',
    'mautic.integration.Facebook.share.layout.icon' => 'Icon (nur Share Button)',
    'mautic.integration.Facebook.share.layout.standard' => 'Horizontal mit Text (Like/Empfehlen Button)',
    'mautic.integration.Facebook.share.showfaces' => 'Die Gesichter der Freunde zeigen (anwendbar auf Like/Empfehlen Button)',
    'mautic.integration.Facebook.share.showshare' => 'Einen Button zum Teilen einfügen (anwendbar auf Like/Empfehlen Button)',
    'mautic.integration.Facebook.login.width' => 'Button Breite',
    'mautic.integration.Facebook.login.buttonlabel' => 'Button Label',
    'mautic.integration.Foursquare' => 'Foursquare',
    'mautic.integration.Foursquare.emailContact' => 'E-Mail',
    'mautic.integration.Foursquare.facebookContact' => 'Profil - Facebook',
    'mautic.integration.Foursquare.facebookProfileHandle' => 'Profil - Facebook',
    'mautic.integration.Foursquare.firstName' => 'Vorname',
    'mautic.integration.Foursquare.homeCity' => 'Heimatstadt',
    'mautic.integration.Foursquare.lastName' => 'Nachname',
    'mautic.integration.Foursquare.mayorship' => 'Bürgermeister',
    'mautic.integration.Foursquare.phoneContact' => 'Telefon',
    'mautic.integration.Foursquare.profileImage' => 'Foursquare Profilbild URL',
    'mautic.integration.Foursquare.twitterContact' => 'Profil - Twitter',
    'mautic.integration.Foursquare.twitterProfileHandle' => 'Profil - Twitter',
    'mautic.integration.Instagram' => 'Instagram',
    'mautic.integration.Instagram.full_name' => 'Vollständiger Name',
    'mautic.integration.Instagram.website' => 'Webseite',
    'mautic.integration.Twitter' => 'Twitter',
    'mautic.integration.Twitter.description' => 'Beschreibung',
    'mautic.integration.Twitter.lang' => 'Sprache',
    'mautic.integration.Twitter.location' => 'Standort',
    'mautic.integration.Twitter.name' => 'Name',
    'mautic.integration.Twitter.share.hashtag' => 'Hashtag',
    'mautic.integration.Twitter.share.hashtag.placeholder' => 'hastag',
    'mautic.integration.Twitter.share.largesize' => 'Großer Button',
    'mautic.integration.Twitter.share.layout' => 'Layout',
    'mautic.integration.Twitter.share.layout.horizontal' => 'Horizontal mit Zähler',
    'mautic.integration.Twitter.share.layout.none' => 'Ohne Zähler',
    'mautic.integration.Twitter.share.layout.vertical' => 'Vertikal mit Zähler',
    'mautic.integration.Twitter.share.related' => 'Empfehlen',
    'mautic.integration.Twitter.share.text' => 'Tweet Text',
    'mautic.integration.Twitter.share.text.pagetitle' => 'nutze Seitentitel',
    'mautic.integration.Twitter.share.tweet' => 'Tweet',
    'mautic.integration.Twitter.share.username' => 'Benutzername',
    'mautic.integration.Twitter.share.via' => 'Via',
    'mautic.integration.Twitter.time_zone' => 'Zeitzone',
    'mautic.integration.Twitter.url' => 'URLs - Webseite',
    'mautic.integration.Twitter.text.required' => 'Tweet Text erforderlich',
    'mautic.integration.Twitter.send.selecttweet' => 'Tweet auswählen',
    'mautic.integration.Twitter.send.selecttweet.desc' => 'Sendet Tweet an Kontakt',
    'mautic.social.tweets' => 'Tweets',
    'mautic.social.monitoring.twitter.tweet.name' => 'Name',
    'mautic.social.monitoring.twitter.tweet.name.tooltip' => 'Interner Mautic Name des Tweets',
    'mautic.integration.Twitter.new.tweet' => 'Neuer Tweet',
    'mautic.integration.Twitter.edit.tweet' => 'Tweet bearbeiten',
    'mautic.plugin.actions.socialLogin' => 'Netzwerk-Login',
    'mautic.mauticSocial.permissions.header' => 'Netzwerk-Berechtigungen',
    'mautic.mauticSocial.permissions.monitoring' => 'Überwachung - Benutzer hat Zugriff auf',
    'mautic.mauticSocial.permissions.tweet' => 'Tweets auf die der Nutzer zugreifen kann',
    'mautic.mautic.social.monitoring.form.confirmdelete' => 'Überwachung löschen?',
    'mautic.integration.Twitter.form.confirmdelete' => 'Tweet löschen?',
    'mautic.mautic.social.monitoring.form.confirmbatchdelete' => 'Ausgewählte Überwachungen löschen?',
    'mautic.mautic.social.monitoring.noresults.tip' => 'Beginnen Sie mit dem Hinzufügen Ihres ersten Monitor Record. Stellen Sie sicher, dass Sie die Twitter-Integration konfiguriert haben!',
    'mautic.mautic.social.tweet.noresults.tip' => 'Beginnen Sie mit dem Hinzufügen Ihrer ersten Tweets. Stellen Sie sicher, dass Sie die Twitter-Integration konfiguriert haben!',
    'mautic.social.tweet.menu.edit' => 'Tweet bearbeiten %name%',
    'mautic.social.tweet.menu.new' => 'Neuer Tweet',
    'mautic.social.twitter.handle' => '@handle',
    'mautic.social.config.twitter.field.label' => 'Feld für twitter-Namen',
    'mautic.social.monitoring' => 'Netzwerk-Überwachung',
    'mautic.social.monitoring.list.choose' => 'Wählen Sie eine Option',
    'mautic.social.monitoring.list.action.retweet' => 'Tweet retweeten',
    'mautic.social.monitoring.list.action.favorite' => 'Tweet hervorheben',
    'mautic.social.monitoring.menu.edit' => 'Social Monitor Bearbeiten',
    'mautic.social.monitoring.menu.new' => 'neuer Social Monitor',
    'mautic.social.monitoring.monitor.leads' => 'Neue Kontakte',
    'mautic.social.monitoring.twitter.assets' => 'Asset Link einfügen',
    'mautic.social.monitoring.twitter.assets.descr' => 'Wählen Sie ein Asset aus der Liste aus, um einen Platzhalter in den Tweet einzufügen',
    'mautic.social.monitoring.twitter.hashtag' => 'Twitter Hashtag',
    'mautic.social.monitoring.twitter.hashtag.tooltip' => 'Geben Sie einen Hashtag ein, nach dem auf Twitter gesucht werden soll. Fügen Sie nicht das Symbol "#" hinzu',
    'mautic.social.monitoring.twitter.custom' => 'Twitter angepasste Suche',
    'mautic.social.monitoring.twitter.custom.tooltip' => 'Erstellen Sie eine benutzerdefinierte Suchabfrage mit den Abfrageerstellungskriterien von Twitter.',
    'mautic.social.monitoring.twitter.handle' => 'Twitter Erwähnung',
    'mautic.social.monitoring.twitter.handle.tooltip' => 'Der Twitter Handle. Benutzen sie nicht das \'@\' Symbol',
    'mautic.social.monitoring.twitter.interact.label' => 'Mit Tweets interagieren',
    'mautic.social.monitoring.twitter.interact.tooltip' => 'Wählen Sie eine Interaktion aus, wenn Sie Tweets entdecken oder als Favorit markieren möchten.',
    'mautic.social.monitoring.twitter.not.published' => 'Twitter Plugin nicht veröffentlicht!',
    'mautic.social.monitoring.twitter.pages' => 'Seitenlink einfügen',
    'mautic.social.monitoring.twitter.pages.descr' => 'Wählen Sie einen Seitenblick aus der Liste aus, um einen Platzhalter in den Tweet einzufügen',
    'mautic.social.monitoring.twitter.tweet.text' => 'Nachricht tweeten',
    'mautic.social.monitoring.twitter.tweet.text.tooltip' => 'Text des Tweets. Folgende Platzhalter können benutzt werden: {twitter_handle}, {pagelink=X}, and {assetlink=X}',
    'mautic.social.monitoring.twitter.tweet.description' => 'Beschreibung',
    'mautic.social.monitoring.twitter.tweet.description.tooltip' => 'Beschreibung des Tweets',
    'mautic.social.monitoring.type.list' => 'Überwachungsmethoden',
    'mautic.social.monitoring.type.list.twitter.custom' => 'Twitter angepasste Suche',
    'mautic.social.monitoring.type.list.twitter.handle' => 'Twitter Erwähnung',
    'mautic.social.monitoring.type.list.twitter.hashtag' => 'Twitter Hashtag',
    'mautic.social.monitoring.twitter_hashtag.popularity' => 'Tweets pro Tag',
    'mautic.social.monitoring.twitter_handle.popularity' => 'Tweets pro Tag',
    'mautic.social.monitoring.twitter_custom.popularity' => 'Tweets pro Tag',
    'mautic.social.twitter.error.handle_not_found' => 'Handle nicht gefunden',
    'mautic.social.twitter.tweet.event.open' => 'Tweet Kontakt',
    'mautic.social.twitter.tweet.event.open_desc' => 'Tweets automatisch an Kontakte senden. Dies muss übereinstimmen mit  <a href=\'https://support.twitter.com/articles/76915#Tweets\' target=\'_blank\'>den Automatisierungsregeln von Twitter</a>.',
    'mautic.social.twitter.tweet.count' => 'Anzahl',
    'mautic.social.twitter.tweet.handle' => 'Kontakt Handle einfügen',
    'mautic.monitoring.form.confirmdelete' => 'Wollen Sie das Social Monitoring %name% löschen?',
    'mautic.campaign.twitter.tweet' => 'Tweet Kontakt',
    'mautic.social.monitoring.twitter.not.configured' => 'Twitter-Integration nicht konfiguriert oder autorisiert. Konfigurieren Sie die Integration, um diese Aufgabe auszuführen.',
    'mautic.social.monitoring.twitter.mid.empty' => '--mid option darf nicht leer sein',
    'mautic.social.monitoring.twitter.monitor.does.not.exist' => 'Monitor %id% wurde nicht gefunden',
    'mautic.social.monitoring.twitter.no.new.tweets' => 'Keine neuen Tweets',
    'mautic.social.monitoring.twitter.filed.not.found' => 'Twitter-Lead-Feld nicht gefunden.',
    'mautic.social.monitoring.twitter.field.not.found' => 'Twitter-Lead-Feld nicht gefunden.',
    'mautic.social.monitoring.twitter.namematching' => 'Kontakt Namen kombinieren',
    'mautic.social.monitoring.twitter.namematching.tooltip' => 'Wenn dies aktiviert ist, versucht Mautic, Twitter-Namen mit vorhandenen Kontaktnamen abzugleichen, um Twitter-Konten vorhandener Kontakte zu ermitteln',
    'mautic.social.monitoring.twitter.yes' => 'Ja',
    'mautic.social.monitoring.twitter.no' => 'Nein',
    'mautic.formactions.save_field' => 'Formular speichern',
    'mautic.formactions.save_field.desc' => 'Aktionen erlauben Formularfelder und Kontaktfelder nach dem Speichern des Formulars zu verarbeiten',
    'mautic.formactions.syntax' => 'Twig Syntax',
    'mautic.formactions.syntax.desc' => 'Erlaubte Tags:  {{ formfield.alias }} und{{ contactfield.alias }}',
    'mautic.formactions.overwriteWithBlank' => 'Überschreiben mit leerem Inhalt',
    'mautic.formactions.contact.field.to.save' => 'Kontaktfeld um verarbeitete Daten zu speichern',
    'mautic.integration.clearbit.apikey' => 'Clearbit API-Schlüssel',
    'mautic.plugin.clearbit.button.caption' => 'Nachschlagen mit Clearbit',
    'mautic.plugin.clearbit.lookup.header' => 'Clearbit - Nachschlagen von Informationen für%item%',
    'mautic.plugin.clearbit.test_api' => 'Teste API und erzeuge Statistiken',
    'mautic.plugin.clearbit.stats' => 'Testergebnisse',
    'mautic.plugin.clearbit.toomany' => 'Sie können höchstens 20 Kontakte gleichzeitig nachschlagen!',
    'mautic.plugin.clearbit.comptoomany' => 'Sie können höchstens 20 Unternehmen gleichzeitig nachschlagen!',
    'mautic.plugin.clearbit.empty' => 'Keine Kontakte zum Nachschlagen!',
    'mautic.plugin.clearbit.compempty' => 'Es gibt keine Unternehmensseiten zum Nachschlagen!<br/>(Firmenwebsite ist leer?)',
    'mautic.plugin.clearbit.forbidden' => 'Sie haben nicht die nötigen Rechte, um diesen Kontakt zu aktualisieren.',
    'mautic.plugin.clearbit.compforbidden' => 'Sie haben nicht die nötigen Rechte, um die Daten dieses Unternehmens zu aktualisieren.',
    'mautic.plugin.clearbit.auto_update' => 'Beim Speichern automatisch aktualisieren?',
    'mautic.plugin.clearbit.auto_update.tooltip' => 'WARNUNG: Dadurch kann Ihre Quote an API-Aufrufen pro Monat möglicherweise erschöpft werden.',
    'mautic.plugin.clearbit.notify' => 'Zeigt eine Benachrichtigung an, wenn die Informationen empfangen wurden.',
    'mautic.plugin.clearbit.contact_retrieved' => 'Die Kontaktinformationen für %s wurden abgerufen',
    'mautic.plugin.clearbit.company_retrieved' => 'Die Unternehmensinformationen für %s wurden abgerufen',
    'mautic.plugin.clearbit.unable' => 'Speichern der Informationen nicht möglich:%s',
    'mautic.plugin.clearbit.webhook_info' => 'Damit das Plugin funktioniert, müssen Sie Folgendes als Webhook-URL in Ihren Kontoeinstellungen auf der Website verwenden<a href="https://dashboard.clearbit.com/account" target="_blank">Clearbit Dashboard</a>:',
    'mautic.plugin.clearbit.public_info' => '<strong>Warnung!</strong> Dies muss eine öffentlich zugängliche URL sein, damit der Webhook funktionieren kann.',
    'mautic.plugin.clearbit.submit' => 'Klicken Sie auf "Senden", um nach Informationen zu suchen:',
    'mautic.plugin.clearbit.submit_items' => 'Klicken Sie auf "Senden", um Informationen für die ausgewählten Elemente zu suchen.',
    'mautic.install.composer.dependencies' => 'Die Bibliotheken des Anbieters müssen installiert sein. Wenn Sie Mautic direkt von einer Quelle ausführen, rufen Sie "Composer Install" auf. Wenn Sie Mautic heruntergeladen haben, prüfen Sie bitte das "Vendor" Verzeichnis.',
    'mautic.install.config.unwritable' => 'Mautic kann die Konfigurationsdatei nicht speichern. Bitte überprüfen Sie die Berechtigungen des Dateisystems und stellen Sie sicher, dass folgendes  Verzeichnis beschreibbar ist: <strong>%path%</strong>.',
    'mautic.install.database.installing' => 'Überprüfen der Details und Erzeugen der Datenbank. Das kann ein paar Sekunden dauern.',
    'mautic.install.database.introtext' => 'Mautic erfordert die Verbindung zu einem Datenbank-Server. Geben Sie hier die Verbindungsdetails an.',
    'mautic.install.date.timezone.not.set' => 'Die <strong>date.timezone</strong> Einstellung ist in Ihrer PHP Konfiguration nicht eingestellt. Mautic hat die Standard-Zeitzone auf "UTC" gesetzt, wir empfehlen aber, dass Sie dies in Ihrer PHP Konfiguration einstellen.',
    'mautic.install.detect.unicode' => 'Die Einstellung detect_unicode muss in der PHP Konfiguration deaktiviert werden',
    'mautic.install.directory.unwritable' => 'Das Verzeichnis %path% muss beschreibbar sein. Ändern Sie die Berechtigungen des <strong>%path%</strong> Verzeichnisses, damit der Server dort schreiben kann.',
    'mautic.install.extension.curl' => 'Installieren und aktivieren Sie die <strong>curl</strong>-Erweiterung.',
    'mautic.install.extension.fileinfo' => 'Installieren und aktivieren Sie bitte die <strong>fileinfo</strong> Erweiterung.',
    'mautic.install.extension.imap' => 'Installieren und aktivieren Sie bitte die <strong>imap</strong> Erweiterung, um E-Mail Tracking zu ermöglichen.',
    'mautic.install.extension.mbstring' => 'Installieren und aktivieren Sie bitte die <strong>mbstring</strong>-Erweiterung.',
    'mautic.install.extension.openssl' => 'Installieren und aktivieren Sie bitte die <strong>openssl</strong> Erweiterung. Wenn open_basedir aktiviert ist, stellen Sie sicher, dass es Zugriff auf / dev / random oder / dev / urandom hat.',
    'mautic.install.extension.zip' => 'Installieren und aktivieren Sie das <strong>zip</strong> Dateiformat. Das ist nötig, um Mautic die Installation von Sprachpaketen zu ermöglichen und Updates innerhalb der Anwendung auszuführen.',
    'mautic.install.final.step' => 'Beendet',
    'mautic.install.finalizing' => 'Die Installation wird finalisiert. Dies kann einige Sekunden in Anspruch nehmen.',
    'mautic.install.form.backup_prefix' => 'Prefix für Backup-Tabellen',
    'mautic.install.form.cache_path' => 'Cache-Verzeichnis',
    'mautic.install.form.database.driver' => 'Datenbanktreiber',
    'mautic.install.form.database.host' => 'Datenbank-Host',
    'mautic.install.form.database.name' => 'Datenbankname',
    'mautic.install.form.database.password' => 'Datenbank-Passwort',
    'mautic.install.form.database.port' => 'Datenbank-Port',
    'mautic.install.form.database.secret' => 'Site Secret Wert',
    'mautic.install.form.database.table.prefix' => 'Datenbank Tabellenprefix',
    'mautic.install.form.database.user' => 'Datenbank-Benutzername',
    'mautic.install.form.existing_tables' => 'Einen Backup der bestehenden Tabellen machen?',
    'mautic.install.form.existing_tables_descr' => 'Wenn nein, dann werden Tabellen entfernt.',
    'mautic.install.form.log_path' => 'Log-Verzeichnis',
    'mautic.install.form.none' => 'Keine',
    'mautic.install.form.update_stability' => 'Minimum Stability',
    'mautic.install.form.user.email' => 'E-Mail-Adresse',
    'mautic.install.form.user.password' => 'Administrator Passwort',
    'mautic.install.form.user.username' => 'Admin-Benutzername',
    'mautic.install.function.ctypealpha' => 'Installieren und aktivieren Sie bitte die <strong>ctype</strong> Erweiterung.',
    'mautic.install.function.iconv' => 'Installieren und aktivieren Sie bitte die <strong>iconv</strong> Erweiterung.',
    'mautic.install.function.jsonencode' => 'Installieren und aktivieren Sie bitte die <strong>JSON</strong> Erweiterung.',
    'mautic.install.function.mbstring' => 'Installieren und aktivieren Sie bitte die <strong>mbstring</strong> Erweiterung.',
    'mautic.install.function.posix.enable' => 'Aktivieren Sie die Erweiterung <strong>php_posix</strong> (wird zum Einfärben der Befehlszeilenausgabe verwendet).',
    'mautic.install.function.sessionstart' => 'Installieren und aktivieren Sie bitte die <strong>session</strong> Erweiterung.',
    'mautic.install.function.simplexml' => 'Installieren und aktivieren Sie bitte die <strong>SimpleXML</strong> Erweiterung.',
    'mautic.install.function.tokengetall' => 'Installieren und aktivieren Sie bitte die <strong>Tokenizer</strong> Erweiterung.',
    'mautic.install.function.xml' => 'Installieren und aktivieren Sie bitte die <strong>XML</strong> Erweiterung.',
    'mautic.install.memory.limit' => 'Die Einstellung <strong>memory_limit</strong> in Ihrer PHP-Konfiguration ist niedriger als das empfohlene Mindestlimit von %min_memory_limit%. Bei Mautic können bei großen Datensätzen ohne ausreichend Speicher Leistungsprobleme auftreten.',
    'mautic.install.heading.check.environment' => 'Mautic Installation - Prüfung der Umgebung',
    'mautic.install.heading.configured' => 'Mautic ist nun installiert! Besuche <a href=\'https://www.mautic.org/getting-started\' target=\'_blank\'>Getting Started</a> für die nächsten Schritte.',
    'mautic.install.heading.database.configuration' => 'Mautic Installation - Datenbank Setup',
    'mautic.install.heading.final' => 'Mautic Installation - letzte Schritte',
    'mautic.install.heading.finished' => 'Gut gemacht!',
    'mautic.install.heading.major.problems' => 'Diese Probleme müssen gelöst werden',
    'mautic.install.heading.minor.problems' => 'Ein paar Vorschläge',
    'mautic.install.heading.misc.configuration' => 'Mautic Installation - Sonstiges',
    'mautic.install.heading.ready' => 'Bereit für die Installation',
    'mautic.install.heading.user.configuration' => 'Mautic Installation - Administrator',
    'mautic.install.intl.config' => 'Die intl-Extension arbeitet nicht so wie erwartet. Bitte stellen Sie sicher, dass die intl-Extension on PHP installiert und korrekt konfiguriert ist.',
    'mautic.install.zend_assertions' => 'Konfigurieren Sie <code>zend.assertions = -1</code> in php.ini für Produktionsumgebungen für eine schnellere und stabilere Ausführung.',
    'mautic.install.magic_quotes_enabled' => 'Auf dem Server ist PHPs <strong>magic_quotes_gpc</strong> aktiviert. Bitte deaktivieren Sie diese Option.',
    'mautic.install.minimum.php.version' => 'Ihr Server erfüllt nicht die PHP-Mindestanforderungen. Mautic benötigt PHP Version %minimum%, während auf Ihrem Server Version %installed% installiert ist. Bitte kontaktieren Sie Ihren Provider, um Ihre PHP-Version zu aktualisieren.',
    'mautic.install.misc.header.paths' => 'Wo sollen Logs und Cache gespeichert werden?',
    'mautic.install.misc.header.stability' => 'Lege den Update Stabilität Pfad fest',
    'mautic.install.misc.header.url' => 'vollständige URL zur Webseite',
    'mautic.install.misc.subheader.paths' => 'Lege hier den absoluten Pfad fest, der von Mautic verwendet werden soll. Er sollte ausserhalb des öffentlich zugänglichen Webverzeichnisses sein.',
    'mautic.install.misc.subheader.stability' => 'Sie installieren eine instabile Version von Mautic (z.B. eine Beta-Version). Standardmäßig zeigt Mautic nur stabile Releases an. Optional können Sie Sie auch Updates für instabile Releases zulassen. So werden zum Beispiel Beta-Releases angezeigt, wenn Sie den Beta-Channel auswählen.',
    'mautic.install.misc.subheader.url' => 'Einige Funktionen, wie z.B. zeitgesteuerte Kampagnen und/oder Kampagnen auf Basis nicht ausgeführter Interaktionen müssen durch einen Cron-Job gesteuert werden. Mautic benötigt die URL der Webseite, um die URLs für Landing Pages, Assets und Clickthroughs (Redirects) zu generieren.',
    'mautic.install.module.intl' => '<strong>intl</strong> Erweiterung installieren und aktivieren.',
    'mautic.install.module.phpxml' => '<strong>PHP-XML</strong> Modul installieren und aktivieren.',
    'mautic.install.next.step' => 'Nächster Schritt',
    'mautic.install.password.minlengt' => 'Ihr Passwort muss mindestens 6 Zeichen lang sein.',
    'mautic.install.pdo.drivers' => 'Bitte installieren Sie den mysql PDO-Treiber',
    'mautic.install.pdo.mandatory' => 'Die PDO Erweiterungen sind erforderlich',
    'mautic.install.php.version.has.only.security.support' => 'Sie haben PHP-Version %phpversion% installiert, die nur noch Sicherheitsupdates erhält. Das heißt, dass Ihre PHP-Version schon bald nicht mehr unterstützt wird. Wir empfehlen deshalb, dass Sie demnächst auf eine neuere PHP-Version aktualisieren. Die aktiv unterstützten Versionen finden Sie <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'>auf PHP.net</a>.',
    'mautic.install.php.version.not.supported' => 'Sie haben eine von Mautic oder dem PHP-Projekt nicht mehr unterstützte PHP-Version installiert. Es wird dringend empfohlen, eine höhere PHP-Version auf Ihrem Server zu installieren. Die aktiv unterstützten Versionen finden Sie <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'>auf PHP.net</a>.',
    'mautic.install.please.wait' => 'Bitte warten',
    'mautic.install.sentence.config.written' => 'local.php (in <em>%path%</em>) wurde mit folgenden Parametern überschrieben: ',
    'mautic.install.sentence.major.problems' => 'Es sind folgende Probleme aufgetaucht: <strong>%majors%</strong>. Bitte lösen Sie diese Probleme bevor Sie fortfahren:',
    'mautic.install.sentence.minor.problems' => 'Es gibt ein paar Kleinigkeiten, die noch gefixt werden könnten, damit Mautic am besten funktioniert:',
    'mautic.install.sentence.proceed.to.mautic' => 'Weiter zu Mautic',
    'mautic.install.sentence.ready' => 'Super! Ihre Umgebung ist bereit für Mautic!',
    'mautic.install.ssl.certificate' => 'Es wird empfohlen, Ihre Installation mit einem SSL-Zertifikat (https) zu sichern. Ab Februar 2020 sendet Google Chrome keine Drittanbieter-Cookies mehr in Cross-Site-Anfragen, es sei denn, die Cookies sind sicher. Das Tracking funktioniert nicht mehr für Mautic-Instanzen, die auf HTTP laufen. Verwenden Sie HTTPS.',
    'mautic.install.step.1' => '1',
    'mautic.install.step.2' => '2',
    'mautic.install.step.3' => '3',
    'mautic.install.step.4' => '4',
    'mautic.install.step.5' => '5',
    'mautic.install.suhosin.whitelist' => 'Suhosin ist nicht korrekt konfiguriert. Fügen Sie in der PHP Konfiguration <strong>phar</strong> zu <strong>suhosin.executor.include.whitelist</strong> hinzu.',
    'mautic.install.timezone.not.supported' => 'Ihre Standard-Zeitzone wird von PHP nicht unterstützt. Bitte prüfen Sie auf Rechtschreibfehler.',
    'mautic.install.user.introtext' => 'Legen Sie einen Administrator an.',
    'mautic.install.xdebug.exception.trace' => 'Die \'show_exception_trace\' für Xdebug sollte deaktiviert werden.',
    'mautic.install.xdebug.nesting' => 'Setzen Sie <strong>xdebug.max_nesting_level</strong> auf mindestens <strong>250</strong> in der PHP Konfiguration. So wird ein falsche Fehlermeldung verhindert.',
    'mautic.install.xdebug.scream' => 'Die \'Scream\'-Option von Xdebug sollte in der PHP Konfiguration deaktiviert werden.',
    'mautic.campaign.add_new_source' => 'Kontaktquelle wählen',
    'mautic.campaign.allow_restart' => 'Zulassen, dass Kontakte die Kampagne erneut starten',
    'mautic.campaign.allow_restart.tooltip' => 'Wenn ein Kontakt aus irgendeinem Grund aus der Kampagne entfernt und dann wieder hinzugefügt wurde, muss er von vorn anfangen.',
    'mautic.campaign.campaign' => 'Kampagne',
    'mautic.campaign.campaign.id' => 'Kampagnen-ID',
    'mautic.campaign.campaign.addremovelead' => 'Kontakt hinzufügen / entfernen',
    'mautic.campaign.campaign.description' => '<strong>Beschreibung der Kampagne:</strong> %description%',
    'mautic.campaign.campaign.launch.builder' => 'Kampagnen-Builder starten',
    'mautic.campaign.campaign.leads' => 'Kontakte hinzugefügt',
    'mautic.campaign.campaigns' => 'Kampagnen',
    'mautic.campaign.connection.trigger.date.label' => 'Warte bis %full%',
    'mautic.campaign.connection.trigger.date.label_inaction' => 'von %full%',
    'mautic.campaign.connection.trigger.interval.label' => 'Warte %number% %unit%',
    'mautic.campaign.connection.trigger.interval.label_inaction' => 'innerhalb %number% %unit%',
    'mautic.campaign.email.send.to.user' => 'Sende eine E-Mail an eine:n Mitarbeiter:in',
    'mautic.campaign.event.action.descr' => 'Eine Aktion ist etwas, das durch Mautic ausgeführt wird (z.B. eine E-Mail senden).',
    'mautic.campaign.event.action.header' => 'Aktion',
    'mautic.campaign.event.actions.header' => 'Aktionen',
    'mautic.campaign.event.addremovelead' => 'Kampagnen ändern',
    'mautic.campaign.event.addremovelead_descr' => 'Kontakt zu bestimmten Kampagnen hinzufügen und/oder von Kampagnen entfernen, wenn ein Ereignis ausgelöst wird.',
    'mautic.campaign.event.campaign_unpublished' => 'Die Kampagne wurde nicht veröffentlicht.',
    'mautic.campaign.event.condition.header' => 'Bedingung',
    'mautic.campaign.event.condition.descr' => 'Eine Kondition basiert auf einem bekannten Profilfeld oder ist durch ein Formular gesendet worden.',
    'mautic.campaign.event.conditions.header' => 'Bedingungen',
    'mautic.campaign.event.decision.descr' => 'Eine Entscheidung wird gefällt, wenn ein Kontakt eine Aktion ausführt (z.B. eine E-Mail öffnet).',
    'mautic.campaign.event.decision.header' => 'Entscheidung',
    'mautic.campaign.event.decisions.header' => 'Entscheidungen',
    'mautic.campaign.event.clone.header' => 'Geklontes Ereignis hier einfügen',
    'mautic.campaign.event.clone.name' => 'Name',
    'mautic.campaign.event.clone.from' => 'Von',
    'mautic.campaign.event.clone.insert' => 'Einfügen',
    'mautic.campaign.event.clone.request.missing' => 'Der Klon ist nicht mehr verfügbar',
    'mautic.campaign.event.clone.btn.tooltip' => 'Duplizieren',
    'mautic.campaign.event.clone.new.campaign' => 'Neue Kampagne',
    'mautic.campaign.event.edit.btn.tooltip' => 'Ändern',
    'mautic.campaign.event.remove.btn.tooltip' => 'Entfernen',
    'mautic.campaign.event.inline.triggerimmediately' => 'sofort',
    'mautic.campaign.event.inline.triggerinterval' => '+ %interval% %unit%',
    'mautic.campaign.event.last_error' => 'Letzter Ausführungs-Fehler',
    'mautic.campaign.event.failed' => 'Das Kampagnenereignis für %contact% konnte nicht ausgeführt werden.',
    'mautic.campaign.event.failed.campaign.unpublished' => 'Aufgrund wiederholter Ereignisfehler wurde Ihre Kampagne %campaign% nicht veröffentlicht. Das fehlgeschlagene Ereignis hat den Namen %event%.',
    'mautic.campaign.event.failed.timeline' => 'Allgemeiner Fehler.',
    'mautic.campaign.event.intervalunit.choice.d' => 'Tag(e)',
    'mautic.campaign.event.intervalunit.choice.h' => 'Stunde(n)',
    'mautic.campaign.event.intervalunit.choice.i' => 'Minute(n)',
    'mautic.campaign.event.intervalunit.choice.m' => 'Monat(e)',
    'mautic.campaign.event.intervalunit.choice.y' => 'Jahr(e)',
    'mautic.campaign.event.intervalunit.d' => '{0} Tage|{1} Tag|[2,Inf] Tage',
    'mautic.campaign.event.intervalunit.h' => '{0} Stunden|{1} Stunde|[2,Inf] Stunden',
    'mautic.campaign.event.intervalunit.i' => '{0} Minuten|{1} Minute|[2,Inf] Minuten',
    'mautic.campaign.event.intervalunit.m' => '{0} Monate|{1} Monat|[2,Inf] Monate',
    'mautic.campaign.event.intervalunit.y' => '{0} Jahre|{1} Jahr|[2,Inf] Jahre',
    'mautic.campaign.event.timed.choice.today' => 'Ist heute',
    'mautic.campaign.event.timed.choice.yesterday' => 'Ist gestern',
    'mautic.campaign.event.timed.choice.tomorrow' => 'Ist morgen',
    'mautic.campaign.event.timed.choice.anniversary' => 'Jahrestag',
    'mautic.campaign.event.timed.choice.custom' => 'Benutzerdefiniert',
    'mautic.campaign.event.leadchange' => 'Kontakt veränderte Kampagnen',
    'mautic.campaign.event.leadchange_descr' => 'Aktionen auslösen, wenn ein Kontakt zu einer Kampagne hinzugefügt oder von einer Kampagne entfernt wird.',
    'mautic.campaign.event.reschedule' => 'Ereignis neu planen.',
    'mautic.campaign.event.save' => 'Speichern',
    'mautic.campaign.event.cancel' => 'Dieses Ereignis abbrechen (es kann später nicht neu geplant werden).',
    'mautic.campaign.event.cancelled' => 'Dieses Ereignis wurde abgebrochen. Zur Wiederherstellung bitte neu einplanen.',
    'mautic.campaign.event.cancelled.time' => 'Dieses Ereignis wurde für %date% eingeplant, wurde aber abgebrochen.',
    'mautic.campaign.event.has_last_attempt_error' => 'Das Ereignis ist fehlgeschlagen während dem letzten Ausführungsversuch.',
    'mautic.campaign.event.systemchanges.header' => 'Systemänderungen',
    'mautic.campaign.event.triggered' => '%event%\' Ereignis ausgelöst',
    'mautic.campaign.event.triggered.description' => 'getriggert in \'%campaign%\' Kampagne von %lead%',
    'mautic.campaign.event.upcoming' => '\'%event%\' Ereignis Trigger',
    'mautic.campaign.event.upcoming.description' => 'Wird getriggert in \'%campaign%\'',
    'mautic.campaign.filter.placeholder' => 'Filter für Kontakt-Quelle',
    'mautic.campaign.form.addevent' => 'Verwenden Sie die Liste rechts, um Trigger und Aktionen zum Dripflow hinzuzufürgen',
    'mautic.campaign.form.addtocampaigns' => 'Kontakt hinzufügen zu',
    'mautic.campaign.form.confirmbatchdelete' => 'Wollen Sie die ausgewählte Kampagne löschen?',
    'mautic.campaign.form.confirmdelete' => 'Wollen Sie die Kampagne %name% löschen?',
    'mautic.campaign.form.lead_source' => 'Kontakt-Quelle',
    'mautic.campaign.form.limittocampaigns' => 'eingeschränkt auf Kampagnen',
    'mautic.campaign.form.limittocampaigns_descr' => 'Wählen Sie die Kampagnen aus, auf die dieser Trigger angewendet werden soll (Der Trigger wird dann nur bei den ausgewählten Kampagnen verwendet). Wenn keine Kampagne ausgewählt ist dann wird der Trigger bei allen Kampagnen verwendet.',
    'mautic.campaign.form.modalheader' => 'Details zu Kampagnen-Ereignissen',
    'mautic.campaign.form.removefromcampaigns' => 'Kontakt entfernen von',
    'mautic.campaign.form.thiscampaign' => 'Diese Kampagne',
    'mautic.campaign.form.thiscampaign_restart' => 'Diese Kampagne (Kampagne erneut starten)',
    'mautic.campaign.form.trigger_leadchanged' => 'Anwenden, wenn Kontakt',
    'mautic.campaign.form.trigger_leadchanged_added' => 'hinzugefügt',
    'mautic.campaign.form.trigger_leadchanged_removed' => 'entfernt',
    'mautic.campaign.form.type' => 'Diesen Vorgang ausführen...',
    'mautic.campaign.form.type_inaction' => 'Führe dieses Ereignis aus, wenn der Kontakt nichts unternimmt...',
    'mautic.campaign.form.type.date' => 'zu einem/r bestimmten Datum/Zeit',
    'mautic.campaign.form.type.date_inaction' => 'zu einem/r bestimmten Datum/Zeit',
    'mautic.campaign.form.type.help' => 'Dieses Ereignis wird für neu zur Kampagne hinzugefügte Kontakte ausgeführt, auch wenn das geplante Datum in der Vergangenheit liegt. Bei geplanten E-Mails wird empfohlen, die Veröffentlichung der E-Mail aufzuheben, wenn Sie nicht möchten, dass Kontakte sie nach diesem Datum erhalten. Alle Daten sind in der Zeitzone des Kontakts angegeben.',
    'mautic.campaign.form.type.immediate' => 'sofort',
    'mautic.campaign.form.type.interval' => 'innerhalb eines bestimmten Zeitraumes',
    'mautic.campaign.form.type.interval_inaction' => 'innerhalb eines bestimmten Zeitraumes',
    'mautic.campaign.form.type.interval_schedule_at' => 'Absender',
    'mautic.campaign.form.type.interval_schedule_between_hours' => 'oder zwischen folgenden Uhrzeiten',
    'mautic.campaign.form.type.interval_trigger_restricted_dow' => 'Schedule only on the selected days of the week:',
    'mautic.campaign.lead.changeowner' => 'Kontaktbesitzer ändern',
    'mautic.campaign.leadsource.form' => 'Formular',
    'mautic.campaign.leadsource.forms' => 'Kampagnen-Formulare',
    'mautic.campaign.leadsource.forms.tooltip' => 'Kontakte, die über die ausgewählten Formulare erzeugt werden, werden dieser Kampagne automatisch hinzugefügt.',
    'mautic.campaign.leadsource.header' => 'Kontakt-Quellen',
    'mautic.campaign.leadsource.header.singular' => 'Kontakt-Quelle',
    'mautic.campaign.leadsource.list' => 'Segment',
    'mautic.campaign.leadsource.lists' => 'Kontakt-Segmente',
    'mautic.campaign.leadsource.lists.tooltip' => 'Kontakte, die zu den ausgewählten Segmenten gehören, werden dieser Kampagne automatisch hinzugefügt.',
    'mautic.campaign.menu.edit' => 'Kampagne ändern',
    'mautic.campaign.menu.index' => 'Kampagnen',
    'mautic.campaign.menu.new' => 'Neue Kampagne',
    'mautic.campaign.member.removed' => 'Kontakt wurde aus der Kampagne entfernt am %date%',
    'mautic.campaign.modify.warning' => 'WARNUNG: Diese Kampagne ist veröffentlicht. Wenn Sie Ereignisse ändern oder Kontakt-Segmente entfernen, werden möglicherweise Kontakte in der laufenden Kampagne beeinflusst.',
    'mautic.campaign.noresults.tip' => 'Kampagnen ermöglichen eine automatische Interaktion mit Kontakten über Dripflows, die auf Aktionen und Entscheidungen basieren. Sie können zum Beispiel eine Follow-Up E-Mail verschicken, wenn der Kontakt eine bereits gesendete E-Mail öffnet. Oder dem Kontakt 10 Punkte zuweisen, wenn er den Link zu einer Landing Page klickt.',
    'mautic.campaign.permissions.campaigns' => 'Kampagnen, auf die der Nutzer Zugriff hat',
    'mautic.campaign.permissions.header' => 'Berechtigungen für die Kampagne',
    'mautic.campaign.point.trigger' => 'Kampagnen-Trigger',
    'mautic.campaign.point.trigger.changecampaigns' => 'Die Kampagnen des Kontakts bearbeiten',
    'mautic.campaign.preview.header' => 'Vorschau',
    'mautic.campaign.rebuild.leads_affected' => '%leads% Kontakt(e) betroffen',
    'mautic.campaign.rebuild.rebuilding' => 'Stelle Kontakte für Kampagne %id% wieder her',
    'mautic.campaign.rebuild.no_lists' => 'Es gibt keine Listen, die wiederhergestellt werden können.',
    'mautic.campaign.rebuild.not_found' => 'Kampagne #%id% nicht gefunden',
    'mautic.campaign.rebuild.to_be_added' => '%leads% Kontakt(e) insgesamt werden in Bündeln zu je %batch% hinzugefügt',
    'mautic.campaign.rebuild.to_be_removed' => '%leads% Kontakt(e) insgesamt werden in Bündeln zu je %batch% entfernt',
    'mautic.campaign.scheduled' => 'Kampagnenereignis geplant',
    'mautic.campaign.summarizing' => 'Erstellen von zusammenfassenden Statistiken für vergangene Kampagnenereignisse in Stapeln von %batch% Stunden. Dabei werden die Daten von den neuesten bis zu den ältesten Ereignissen nachträglich ergänzt.',
    'mautic.campaign.trigger.event_count' => '%events% Ereignis(se) gesamt werden in Bündeln zu je %batch% verarbeitet',
    'mautic.campaign.trigger.events_executed' => '{0} 0 Ereignisse wurden ausgeführt|{1} 1 Ereignis wurde ausgeführt|[2,Inf] %count% Ereignisse wurden ausgeführt',
    'mautic.campaign.trigger.events_scheduled' => '{0} 0 Ereignisse wurden geplant|{1} 1 Ereignis wurde geplant|[2,Inf] %count% Ereignisse wurden geplant',
    'mautic.campaign.trigger.decision_count_analyzed' => '%decisions% Entscheidungen, die auf Inaktivität zu analysieren sind, für ungefähr %leads% Kontakte in Batches of %batch%',
    'mautic.campaign.trigger.lead_count_processed' => '%leads% Kontakt(e) insgesamt werden in Bündeln zu je %batch% verarbeitet',
    'mautic.campaign.trigger.negative' => 'Auslösen von Ereignissen für inaktive Kontakte',
    'mautic.campaign.trigger.scheduled' => 'Löse geplante Ereignisse aus',
    'mautic.campaign.trigger.starting' => 'Ereignisse für neu hinzugefügte Kontakte auslösen',
    'mautic.campaign.trigger.triggering' => 'Löse Ereignisse für Kampagne %id% aus',
    'mautic.campaign.triggered' => 'Kampagnen Aktion ausgelöst',
    'mautic.campaign.user.devent.description' => '<strong>Beschreibung des Ereignisses:</strong> %description%',
    'mautic.campaign.user.event.triggered' => 'getriggertes <strong>%event%</strong> Ereignis',
    'mautic.campaign.dashboard.widgets' => 'Kampagnen-Widgets',
    'mautic.widget.events.in.time' => 'Ausgelöste Ereignisse im Zeitverlauf',
    'mautic.widget.leads.added.in.time' => 'Hinzugefügte Kontakte im Zeitverlauf',
    'mautic.campaign.triggered.events' => 'Ausgelöste Ereignisse',
    'mautic.config.tab.campaignconfig' => 'Kampagnen-Einstellungen',
    'mautic.campaignconfig.campaign_time_wait_on_event_false' => 'Wartezeit, bevor eine fehlerhafte Aktion wiederholt wird',
    'mautic.campaignconfig.campaign_time_wait_on_event_false_tooltip' => 'Warten Sie bitte so lange, bevor Sie eine fehlgeschlagene Aktion wiederholen.',
    'mautic.campaignconfig.campaign_by_range' => 'Datumsbereich für alle Ansichten verwenden',
    'mautic.campaignconfig.campaign_by_range.tooltip' => 'Die Registerkarten „Aktionen“, „Bedingungen“, „Entscheidungen“ und „Kontakte“ basieren auf dem beim Anzeigen einer Kampagne angegebenen Datumsbereich.',
    'mautic.campaignconfig.use_summary' => 'Verwende zusammenfassende Statistiken',
    'mautic.campaignconfig.use_summary.tooltip' => 'Verbessert die Leistung beim Anzeigen einer Kampagne mit Tausenden von Ereignissen pro Tag durch die Verwendung zusammengefasster Daten. Möglicherweise müssen Sie einen Befehl über SSH ausführen, um Ihre Daten einmal nachzufüllen.',
    'mautic.campaign.stats' => 'Kampagnen-Statistiken',
    'mautic.stage.campaign.event.change_descr' => 'Wählen Sie eine Phase, auf die ein Kontakt geändert werden soll.',
    'mautic.campaign.command.process.messages' => 'Verarbeite Nachrichtenwarteschlange',
    'mautic.campaign.command.messages.sent' => 'Nachrichten gesendet: %events%',
    'mautic.campaign.lead.addtocompany' => 'Kontakt zu Unternehmen hinzufügen',
    'mautic.campaign.event.messages.header' => 'Nachrichten',
    'mautic.campaign.event.message.header' => 'Nachricht',
    'mautic.campaign.event.message.descr' => 'Sende eine Nachricht über den vom Kontakt präferierten Kanal.',
    'mautic.report.group.campaign_lead_event_log' => 'Kampagnen',
    'mautic.campaign.events' => 'Kampagnenereignisse',
    'mautic.report.campaign.event.name' => 'Ereignis Name',
    'mautic.report.campaign.event.description' => 'Ereignis Beschreibung',
    'mautic.report.campaign.event.type' => 'Kontext des Ereignisses',
    'mautic.report.campaign.event.event_type' => 'Ereignis Art',
    'mautic.report.campaign.event.trigger_date' => 'Auslösedatum des Ereignisses',
    'mautic.report.campaign.event.trigger_mode' => 'Auslösemodus des Ereignisses',
    'mautic.report.campaign.event.channel' => 'Ereignis Kanal',
    'mautic.report.campaign.event.channel_id' => 'Ereignis Kanal ID',
    'mautic.report.campaign.event.rotation' => 'Wechsel',
    'mautic.report.campaign.log.date_triggered' => 'Ereignisprotokolldatum ausgelöst',
    'mautic.report.campaign.log.is_scheduled' => 'Das Ereignisprotokoll ist geplant',
    'mautic.report.campaign.log.trigger_date' => 'Auslöserdatum für Ereignisprotokoll',
    'mautic.report.campaign.log.system_triggered' => 'Ereignisprotokollsystem ausgelöst?',
    'mautic.report.campaign.log.non_action_path_taken' => 'Nicht protokollierter Ereignisprotokollpfad?',
    'mautic.report.campaign.log.channel' => 'Ereignisprotokollkanal',
    'mautic.report.campaign.log.channel_id' => 'Ereignisprotokoll-Kanal-ID',
    'mautic.report.campaign.yes.percent' => 'Erfolg in Prozent',
    'mautic.report.campaign.no.percent' => 'Nicht-Erfolg in Prozent',
    'mautic.report.campaign.completed.actions' => 'Abgeschlossene Aktionen',
    'mautic.report.campaign.pending.actions' => 'Ausstehende Aktionen',
    'mautic.campaign.event.jump_to_event' => 'Zu Ereignis springen',
    'mautic.campaign.campaign.jump_to_event' => 'Zu Ereignis springen',
    'mautic.campaign.campaign.jump_to_event.target_not_exist' => 'Pfad zum Ziel existiert nicht mehr',
    'mautic.campaign.event.jump_to_event_descr' => 'Springen Sie zu dem ausgewählten Ereignis innerhalb der Kampagne',
    'mautic.campaign.form.jump_to_event' => 'Gehe zu Ereignis',
    'mautic.campaign.message.send' => 'Gesendete Nachrichten',
    'mautic.campaign.form.confirmation.message' => 'Möchten Sie die Veröffentlichung dieser Kampagne wirklich rückgängig machen und die Verarbeitung von Kontakten und Kampagnenereignissen (einschließlich geplanter Ereignisse) sofort beenden?',
    'mautic.campaign.form.confirmation.confirm_text' => 'Ja',
    'mautic.campaign.form.confirmation.cancel_text' => 'Nein',
    'mautic.tagManager.permissions.header' => 'Manager-Berechtigungen markieren ',
    'mautic.tagManager.permissions.tagManager' => 'Manager markieren ',
    'tagmanager.menu.index' => 'Tags',
    'mautic.tagmanager.tag.header.index' => 'Tags',
    'mautic.tagmanager.lead.searchcommand.list' => 'tag',
    'mautic.tagmanager.tag.form.confirmdelete' => 'Markierung löschen?',
    'mautic.tagmanager.tag.error.notfound' => 'Keine Markierung mit der ID %id% gefunden!',
    'mautic.tagmanager.menu.new' => 'Neue Markierung erstellen',
    'mautic.tagmanager.menu.edit' => 'Markierung bearbeiten %name%',
    'mautic.tagmanager.form.confirmdelete' => 'Markierung löschen?',
    'mautic.tagmanager.tag.summary' => 'Zusammenfassung',
    'mautic.tagmanager.batch.tags' => 'Ändere Tags',
    'mautic.integration.form.feature.cloud_storage' => 'Mit dem Cloud Speicherprovider verbinden',
    'mautic.integration.form.provider.settings' => 'Provider Einstellungen',
    'mautic.integration.keyfield.amazons3.bucket' => 'Bucket Pfad',
    'mautic.integration.keyfield.OpenCloud.containerName' => 'Container Speicherpfad',
    'mautic.integration.Amazon.region' => 'Region S3',
    'mautic.integration.Amazon.endpoint' => 'S3 Endpunkt',
    'mautic.twigTemplates' => 'Twig-Templates',
    'mautic.twigTemplates.manage' => 'Twig-Templates',
    'mautic.twigTemplates.sql' => 'Twig',
    'mautic.twigTemplates.permissions.header' => 'Twig-Templates',
    'mautic.twigTemplates.permissions.twigTemplates' => 'Twig-Templates, auf die der User zugreifen darf',
    'mautic.twigTemplates.testing_area' => 'Test-Bereich',
    'mautic.twigTemplates.example.content.filter.contact' => 'Beispiel für Kontakt %contactId%',
    'mautic.twigTemplates.test' => 'Testen',
    'mautic.integration.gmail.secret' => 'Gmail Extension Secret',
    'mautic.chat.channel.header.edit' => '%name% ändern',
    'mautic.chat.channel.modal.header' => 'Kanalliste',
    'mautic.chat.channel.notification.header' => 'Nachricht von %from% in %name%',
    'mautic.chat.channel.thead.name' => 'Handle',
    'mautic.chat.chat.form.notification_sound' => 'Sound bei Benachrichtigungen',
    'mautic.chat.chat.form.notification_sound.tooltip' => 'Legen Sie den Sound für neue Chatnachrichten fest.',
    'mautic.chat.chat.notification.header' => 'Nachricht von %name%',
    'mautic.chat.chat.status.idle' => 'Leerlauf',
    'mautic.chat.chat.status.manualaway' => 'Away',
    'mautic.chat.filter.archived' => 'Ist archiviert',
    'mautic.chat.filter.invisible' => 'Nicht sichbar',
    'mautic.chat.filter.mute' => 'Sound deaktiviert',
    'mautic.chat.filter.newmessages' => 'Hat neue Nachrichten',
    'mautic.chat.filter.silent' => 'Benachrichtigungen deaktiviert',
    'mautic.chat.filter.subscribed' => 'Abonnement von',
    'mautic.chat.header.index' => 'Chatnachrichten',
    'mautic.chat.search.more' => 'Zu viele Ergebnisse. Grenzen Sie Ihre Suche ein.',
    'mautic.chat.setting.archived' => 'Archiviert',
    'mautic.chat.setting.notifications' => 'Meldungen',
    'mautic.chat.setting.sound' => 'Sound abspielen',
    'mautic.chat.setting.subscribed' => 'Abonniert',
    'mautic.chat.setting.visible' => 'Sichtbar',
    'mautic.chat.sidebar.chat' => 'Chat',
    'mautic.chat.sidebar.communication' => 'Kommunikation',
    'mautic.chat.user.modal.header' => 'Nutzerliste',
    'mautic.chat.user.thead.username' => 'Benutzername',
    'mautic.config.tab.chatconfig' => 'Chat Add-On Einstellungen',
    'mautic.notifications.type.mautic.chat' => 'Nachricht',
    'mautic.campaign.page.devicehit' => 'Gerätaufruf',
    'mautic.campaign.page.pagehit' => 'Seitenzugriff',
    'mautic.config.tab.pageconfig' => 'Landing Page Einstellungen',
    'mautic.maintenance.page_hits' => 'Besucher Seitenaufrufe',
    'mautic.maintenance.lead_utmtags' => 'UTM Tag Verlauf',
    'mautic.page.page' => 'Seite',
    'mautic.config.tab.trackingconfig' => 'Tracking Einstellungen',
    'mautic.config.tab.pixels.event.in.campaign' => 'Aktivieren Sie die Kampagnenaktion von Drittanbietern',
    'mautic.page.config.form.pixel.campaign.enabled' => 'Kampagnenaktion aktivieren "Drittanbieter-Pixel senden"',
    'mautic.page.abtest.criteria' => 'Landing Page Statistik',
    'mautic.page.abtest.criteria.bounce' => 'Niedrigste Bounce Rate',
    'mautic.page.abtest.criteria.dwelltime' => 'Längste Verweildauer',
    'mautic.page.abtest.label.bounces' => 'Bounce Rate',
    'mautic.page.abtest.label.dewlltime.average' => 'Durchschnittliche Verweildauer (s)',
    'mautic.page.builder.addcontent' => 'Klick um Inhalte hinzuzufügen',
    'mautic.page.builder.externallink' => 'Externer Link',
    'mautic.page.campaign.event.form.pages' => 'Nur für Seiten',
    'mautic.page.campaign.event.form.pages.descr' => 'Seiten für diesen Auslöser auswählen. Wenn Sie keine Seite auswählen, wird der Auslöser auf alle Seiten angewandt.',
    'mautic.page.campaign.event.form.url' => 'URL',
    'mautic.page.campaign.event.form.url.descr' => 'Geben Sie die URL der Seite an, wo der Tracking-Pixel installiert ist. Es ist möglich Platzhalter (*) zu nutzen. Beispiel: *product/123* passt zu http://web.com/product/1234.htm. Mehrere URLs mit Komma trennen.',
    'mautic.page.campaign.event.form.referer' => 'Referrer',
    'mautic.page.campaign.event.form.referer.descr' => 'Geben Sie die Referrer-URL der Seite ein, auf der Sie das Tracking-Pixel platziert haben. Es ist möglich, Platzhalterzeichen (*) zu verwenden. Beispiel: * product / 123 * stimmt mit http://web.com/product/1234.htm überein. Mehrere Referrer-URLs werden mit Komma getrennt.',
    'mautic.page.campaign.event.pagehit' => 'Besucht eine Seite',
    'mautic.page.campaign.event.pagehit_descr' => 'Löse Aktionen aus, wenn eine Seite/URL aufgerufen wird.',
    'mautic.page.campaign.event.devicehit' => 'Besuch durch Device',
    'mautic.page.campaign.event.devicehit_descr' => 'Seiten- / URL-Treffer bei einem Device auslösen.',
    'mautic.page.campaign.condition.form.startdate' => 'Startdatum',
    'mautic.page.campaign.condition.form.enddate' => 'Enddatum',
    'mautic.page.campaign.condition.form.timespent' => 'Verweildauer (Sekunden)',
    'mautic.page.campaign.condition.form.page' => 'Seite',
    'mautic.page.campaign.condition.form.page.descr' => 'Wählen Sie die Seite aus, auf die dieser Trigger angewendet wird. Wenn keine Seite ausgewählt ist, wird der Trigger auf jede beliebige Seite angewendet.',
    'mautic.page.config.form.cat.in.url' => 'Die Kategorie in der Seiten-URL anzeigen?',
    'mautic.page.config.form.cat.in.url.tooltip' => 'Wenn ausgewählt, dann wird die Kategorie in der URL angezeigt.',
    'mautic.page.config.form.track.by.tracking.url' => 'Besucher via URL Tracking identifizieren',
    'mautic.page.config.form.track.by.tracking.url.tooltip' => 'Wenn aktiviert, können Sie den wiederkehrenden Besucher durch Tracking-URL von Kanälen (insbesondere von E-Mails) identifizieren, wenn noch kein Cookie vorhanden ist. Hinweis: E-Mail-Felder müssen als unique Identifier markiert und in der Konfiguration öffentlich aktualisierbar sein.',
    'mautic.page.config.form.google.analytics' => 'Analyse-Code (z.B. Google Analytics)',
    'mautic.page.config.form.google.analytics.tooltip' => 'Fügen Sie das Analyseskript ein, um es automatisch in die Quelle der Zielseiten aufzunehmen.',
    'mautic.page.config.form.track_contact_by_ip' => 'Besucher via IP identifizieren',
    'mautic.page.config.form.track_contact_by_ip.tooltip' => 'Wenn aktiviert, werden nicht identifizierte Besucher mit derselben IP-Adresse wie ein vorhandener Kontakt als dieser Kontakt nachverfolgt.',
    'mautic.page.config.form.do_not_track_404_anonymous' => 'Do Not Track 404-Fehler für anonyme Kontakte',
    'mautic.page.config.form.do_not_track_404_anonymous.tooltip' => 'Wenn die Option aktiviert ist, werden nicht identifizierte Besuche auf 404-Antwortcode-Fehlerseiten nicht verfolgt. Diese Option hilft, das Tracking durch Bots zu verhindern.',
    'mautic.page.config.form.anonymize_ip' => 'IP anonymisieren',
    'mautic.page.config.form.anonymize_ip.tooltip' => 'Die IP des Besuchers wird nirgends gespeichert.',
    'mautic.page.config.form.anonymize_ip.warning' => 'Vorhandene Daten werden anonymisiert. Diese Aktion ist nicht umkehrbar',
    'mautic.page.event.hit' => 'Seitenaufruf',
    'mautic.page.event.publish.down' => '%page% als nicht verfügbar festlegen',
    'mautic.page.event.publish.down.description' => 'Die Seite „%page%“ wird nicht mehr verfügbar sein.',
    'mautic.page.event.publish.up' => '%page% als verfügbar festlegen',
    'mautic.page.event.publish.up.description' => 'Seite „%page%“ wird verfügbar.',
    'mautic.page.field.hits' => 'Zugriffe',
    'mautic.page.field.unique_hits' => 'Eindeutige Zugriffe',
    'mautic.page.form.confirmbatchdelete' => 'Ausgewählte Seiten löschen? WARNUNG - Dadurch werden auch alle zugehörigen A / B-Tests und Übersetzungen gelöscht!',
    'mautic.page.form.confirmdelete' => 'Seite löschen, %name%? WARNUNG - Dadurch werden auch alle zugehörigen A / B-Tests und Übersetzungen gelöscht!',
    'mautic.page.form.customhtml' => 'benutzerdefinierter HTML Text',
    'mautic.page.form.customhtml.help' => 'Die gesamte Landing Page mit benutzerdefiniertem HTML erzeugen',
    'mautic.page.form.language.help' => 'Übersetzen Sie die Inhalte in mehrere Sprachen und verknüpfen Sie diese miteinander, indem Sie ihnen die gleiche Seite zuordnen. Über Sprachauswahl-Links kann der Besucher auf den entsprechenden Landing Pages dann die gewünschte Sprache auswählen.',
    'mautic.page.form.metadescription' => 'Meta Description',
    'mautic.page.form.headscript' => 'Skript in der Kopfzeile',
    'mautic.page.form.script.help' => 'Stelle sicher, dass das Skript in <&#8239;script&#8239;>-Tags eingeschlossen ist, um zu verhindern, dass es auf der Seite als Text angezeigt, anstatt ausgeführt zu werden.',
    'mautic.page.form.footerscript' => 'Skript in der Fusszeile',
    'mautic.page.form.template.help' => 'Wählen Sie eine Vorlage für die Landing Page, um das Aussehen festzulegen. Nutzen Sie dann den Seiteneditor, um den Inhalt einzufügen. WARNUNG: Wenn Sie Inhalte angegeben haben und danach die Vorlage ändern, kann es sein, dass die Inhalte nicht mehr angezeigt werden, weil die Vorlagen verschiedene Platzhalter haben.',
    'mautic.page.form.redirecttype' => 'Redirect Typ',
    'mautic.page.form.redirecttype.help' => 'Wählen Sie den Redirect Typ (301 permanent, 302 temporary, keinen)',
    'mautic.page.form.redirecttype.none' => 'Kein Redirect',
    'mautic.page.form.redirecttype.permanent' => '301 Permanent',
    'mautic.page.form.redirecttype.temporary' => '302 Temporary',
    'mautic.page.form.redirecttype.303_temporary' => '303 Temporär',
    'mautic.page.form.redirecttype.307_temporary' => '307 Temporär',
    'mautic.page.form.redirecttype.308_permanent' => '308 Permanent',
    'mautic.page.form.redirecturl' => 'URL Redirect',
    'mautic.page.form.redirecturl.help' => 'Wählen Sie eine URL, die angezeigt werden soll, wenn die Seite noch nicht veröffentlicht ist. Sie können eine benutzerdefinierte URL festlegen oder aus den bereits veröffentlichten Seiten wählen.',
    'mautic.page.graph.line.hits' => 'Seitenzugriffe',
    'mautic.page.graph.line.time.on.site' => 'Durchschnittlicher Verbleib auf der Site in Sekunden',
    'mautic.page.graph.pie.devices' => 'Device Granularität',
    'mautic.page.graph.pie.languages' => 'Sprachen',
    'mautic.page.graph.pie.new.vs.returning' => 'Neu vs Wiederkehrend',
    'mautic.page.graph.pie.new.vs.returning.new' => 'Neu',
    'mautic.page.graph.pie.new.vs.returning.returning' => 'Wiederkehrend',
    'mautic.page.graph.pie.time.on.site' => 'Zeit auf Site',
    'mautic.page.header.edit' => 'Seite %name% ändern',
    'mautic.page.header.new' => 'Neue Seite',
    'mautic.page.help.alias' => 'Buchstaben und Zahlen (Bindestriche zulässig), die zur URL-Generierung dieser Zielseite verwendet werden. Wenn das Feld leer gelassen wird, wird automatisch ein eindeutiger Alias ​​basierend auf dem Titel generiert.',
    'mautic.page.help.searchcommands' => '<strong>Such-Befehle</strong><br />ids:ID1,ID2 (kommagetrennte IDs, keine Leerzeichen)<br />is:published<br />is:unpublished<br />is:mine<br />is:uncategorized<br />is:prefcenter<br />category:{category alias}<br />lang:{lang code}',
    'mautic.page.hits' => 'Seitenaufrufe',
    'mautic.page.menu.edit' => 'Seite ändern',
    'mautic.page.menu.view' => 'Seite anzeigen',
    'mautic.page.pages' => 'Landing Pages',
    'mautic.page.pageviews' => 'Seitenaufrufe',
    'mautic.page.permissions.header' => 'Berechtigungen für Landing Pages',
    'mautic.page.permissions.pages' => 'Seiten, auf die der User zugreifen darf',
    'mautic.page.point.action' => 'Landing-Page-Aktionen',
    'mautic.page.point.action.form.accumulative.time' => 'Gesamte Besuchsdauer',
    'mautic.page.point.action.form.accumulative.time.descr' => 'Punkte werden basierend auf der gesamten Besuchszeit der Seite über alle Besuche hinweg vergeben.',
    'mautic.page.point.action.form.first.time.only' => 'Nur beim ersten Besuch',
    'mautic.page.point.action.form.first.time.only.descr' => 'Kontakte können eine bestimmte URL mehrmals aufrufen. Hier legen Sie fest, ob die Punkte jedes Mal oder nur beim ersten Besuch angepasst werden sollen.',
    'mautic.page.point.action.form.page.hits.descr' => 'Punkte werden basierend auf der Anzahl der Seitenaufrufe des Kontakts geändert.',
    'mautic.page.point.action.form.page.url' => 'Seiten-URL',
    'mautic.page.point.action.form.page.url.descr' => 'Geben Sie die URL der Seite ein, auf der Sie das Tracking-Pixel platziert haben. Die URL muss mit http: // oder https: // beginnen. Es ist möglich, Platzhalterzeichen (*) zu verwenden. Beispiel: http://yourweb.com/product/* stimmt mit http://yourweb.com/product/1, http://yourweb.com/product/green-carpet usw. überein.',
    'mautic.page.point.action.form.pages' => 'Eingeschränkt auf die ausgewählten Seiten',
    'mautic.page.point.action.form.pages.descr' => 'Seiten für diese Aktion auswählen. Wenn Sie keine Seite ausgewählt haben wird die Aktion auf alle Seiten ausgeführt.',
    'mautic.page.point.action.form.returns.after' => 'Rückkehr nach',
    'mautic.page.point.action.form.returns.after.descr' => 'Punkte werden geändert, wenn der Kontakt <em>nach</em> der gesetzten Zeit zu der URL zurückkehrt.',
    'mautic.page.point.action.form.returns.within' => 'Rückkehr innerhalb',
    'mautic.page.point.action.form.returns.within.descr' => 'Punkte werden geändert, wenn der Kontakt <em>während</em> der gesetzten Zeit zu der URL zurückkehrt.',
    'mautic.page.point.action.pagehit' => 'eine Landing Page besucht',
    'mautic.page.point.action.pagehit_descr' => 'Kontakt-Punkte werden nach dem Besuch einer Landing Page geändert',
    'mautic.page.point.action.urlhit' => 'eine spezifische URL besucht',
    'mautic.page.point.action.urlhit_descr' => 'Kontakt-Punkte werden geändert, wenn eine bestimmte URL aufgerufen wird, auf der ein Mautic Tracking-Pixel installiert ist.',
    'mautic.page.preview.url' => 'Öffentliche Preview URL',
    'mautic.page.publish.down' => 'Als nicht verfügbar festlegen',
    'mautic.page.publish.up' => 'Als verfügbar festlegen',
    'mautic.page.referrer' => 'Referrer',
    'mautic.page.report.hits.browser_languages' => 'Zugriff Browsersprachen',
    'mautic.page.report.hits.city' => 'Zugriff Stadt',
    'mautic.page.report.hits.code' => 'Zugriff Code',
    'mautic.page.report.hits.country' => 'Zugriff Land',
    'mautic.page.report.hits.date_hit' => 'Zugriff Datum',
    'mautic.page.report.hits.date_left' => 'Datum des Verlassens',
    'mautic.page.report.hits.device' => 'Device',
    'mautic.page.report.hits.email_id' => 'E-Mail ID',
    'mautic.page.report.hits.email_subject' => 'E-Mail Betreff',
    'mautic.page.report.hits.isp' => 'Zugriff ISP',
    'mautic.page.report.hits.organization' => 'Zugriff Organisation',
    'mautic.page.report.hits.redirect_hit_count' => 'Weiterleitung Zugriffe',
    'mautic.page.report.hits.redirect_unique_hits' => 'Weiterleitung eindeutige Zugriffe',
    'mautic.page.report.hits.redirect_url' => 'Redirect URL',
    'mautic.page.report.hits.referer' => 'Zugriff Referer',
    'mautic.page.report.hits.region' => 'Zugriff Region',
    'mautic.page.report.hits.remote_host' => 'Zugriff Remote Host',
    'mautic.page.report.hits.url' => 'Zugriff URL',
    'mautic.page.report.hits.url_title' => 'Zugriff Seitentitel',
    'mautic.page.report.hits.user_agent' => 'Zugriff User Agent',
    'mautic.page.report.revision' => 'Revision',
    'mautic.page.report.translation_parent_id' => 'Übersetzung der Vorläufer ID',
    'mautic.page.report.translation_parent_title' => 'Übersetzung des Vorläufer Name',
    'mautic.page.report.variant_hits' => 'A/B Test Zugriffe',
    'mautic.page.report.variant_parent_id' => 'A/B Test Vorläufer ID',
    'mautic.page.report.variant_parent_title' => 'A/B Test Vorläufer Name',
    'mautic.page.report.variant_start_date' => 'A/B Test Startdatum',
    'mautic.page.report.hits.id' => 'Seitenaufruf ID',
    'mautic.report.group.videos' => 'Videos',
    'mautic.video.hits' => 'Video Aufrufe',
    'mautic.page.report.hits.time_watched' => 'Zeit geschaut',
    'mautic.page.report.hits.duration' => 'Dauer',
    'mautic.page.stage.action' => 'Seitenaktivitäten',
    'mautic.page.stage.action.pagehit' => 'Besucht eine Seite',
    'mautic.page.stage.action.urlhit' => 'Besucht eine URL',
    'mautic.page.table.most.visited' => 'Am meisten besuchte Seiten',
    'mautic.page.table.most.visited.unique' => 'die meisten eindeutigen Besuche',
    'mautic.page.table.referrers' => 'Top Referrers',
    'mautic.page.thead.hits' => 'Treffer',
    'mautic.page.time.on.page' => 'Zeit verbracht auf der Seite',
    'mautic.page.token.lang' => 'Spachbalken',
    'mautic.page.token.lang.descr' => 'Fügt eine neue Sprachauswahl hinzu wenn die Seite mehrere Übersetzungen hat.',
    'mautic.page.token.share' => 'Share Buttons',
    'mautic.page.token.share.descr' => 'In den Einstellungen für Social Networks konfigurierte Share Buttons einfügen',
    'mautic.page.tokens.header' => 'Token',
    'mautic.page.tokens.help' => 'Tokens sind Platzhalter für Objekte wie Formulare. Ziehen Sie den Token einfach in den Editor, um ihn hinzuzufügen!',
    'mautic.page.url' => 'Seiten-URL',
    'mautic.page.webhook.event.hit' => 'Seitenzugriff Ereignis',
    'mautic.page.dashboard.widgets' => 'Seiten-Widgets',
    'mautic.widget.page.hits.in.time' => 'Seitenbesuche im Zeitverlauf',
    'mautic.widget.unique.vs.returning.leads' => 'Einmalige gegen wiederkehrende Besucher',
    'mautic.widget.dwell.times' => 'Verweildauer',
    'mautic.widget.popular.pages' => 'Beliebte Landing Pages',
    'mautic.widget.created.pages' => 'Erstellte Landing Pages',
    'mautic.page.visit.flag.filter' => 'Besuchsstatus',
    'mautic.page.show.total.visits' => 'Gesamte Besuche',
    'mautic.page.show.unique.visits' => 'Eindeutige Besuche',
    'mautic.page.show.unique.and.total.visits' => 'Gesamte und eindeutige Besuche',
    'mautic.page.unique' => 'Eindeutig',
    'mautic.trackable.click_count' => 'Klicks',
    'mautic.trackable.click_counts' => 'Klickanzahl',
    'mautic.trackable.click_counts.header_none' => 'Keine URLs zum Tracken gefunden',
    'mautic.trackable.click_counts.none' => 'Es gibt keine URLs, die momentan für diesen Kanal getrackt werden. Es könnte sein, dass der Kanal bisher nicht versendet wurde oder gar keine URLs enthält.',
    'mautic.trackable.click_track_id' => 'Tracking ID',
    'mautic.trackable.click_unique_count' => 'Eindeutige Klicks',
    'mautic.trackable.click_url' => 'URL',
    'mautic.trackable.click_conversion_rate' => 'Konversionsrate',
    'mautic.trackable.total_clicks' => 'Klicks gesamt',
    'mautic.trackable.total_conversion_rate_tooltip' => 'Anzahl der Kontakte, die auf mindestens einen Link geklickt haben / Gesamtzahl der eindeutigen Aufrufe',
    'mautic.config.tab.pagetracking' => 'Mautic Tracking Einstellungen',
    'mautic.config.tab.pagetracking.info' => 'Fügen Sie vor dem Beenden folgenden Code am Ende der Webseite ein <code>&lt;/body&gt;</code> tag. Mautic Landing Pages werden automatisch verfolgt. Verwenden Sie dies nur, um ein Tracking auf externen Websites einzurichten.',
    'mautic.report.group.pages' => 'Seiten',
    'mautic.page.event.videohit' => 'Videoansicht Ereignis',
    'mautic.page.time.on.video' => 'Gesamt angeschaut',
    'mautic.page.time.on.video.value' => '%time_watched% of %duration% (%percentage%%)',
    'mautic.video.url' => 'Video URL',
    'mautic.page.tracking.pixel.event.send' => 'Tracking Ereignis senden',
    'mautic.page.tracking.pixel.event.send_desc' => 'Benutzerdefiniertes Tracking-Ereignis von Google Analytics / Facebook Pixel senden',
    'mautic.campaign.tracking.pixel.send' => 'Tracking Ereignis senden',
    'mautic.page.tracking.form.category' => 'Kategorie',
    'mautic.page.tracking.form.category.tooltip' => 'nur Google Analytics ',
    'mautic.page.tracking.form.action' => 'Aktion',
    'mautic.page.tracking.form.label' => 'Label',
    'mautic.page.tracking.form.services' => 'Services',
    'mautic.page.config.form.event.google.analytics.enabled' => 'Google Analytics Ereignis',
    'mautic.config.tab.tracking.facebook.pixel' => 'Facebook Pixel',
    'mautic.page.config.form.facebook.pixel.id' => 'Facebook Pixel ID',
    'mautic.config.tab.tracking.google.analytics' => 'Google Analytics',
    'mautic.page.config.form.google.analytics.id' => 'Google Analytics ID',
    'mautic.page.config.form.tracking.landingpage.enabled' => 'Auf Mautic Landing Page aktivieren',
    'mautic.page.config.form.tracking.trackingpage.enabled' => 'Auf Tracking Page aktiviert',
    'mautic.page.config.form.tracking.anonymize.ip.enabled' => 'IP Anonymisierung aktiviert',
    'mautic.page.config.form.tracking.anonymize.ip.enabled.tooltip' => 'In einigen Fällen müssen Sie möglicherweise die IP-Adresse des an Google Analytics gesendeten Treffers anonymisieren.',
    'mautic.page.form.preference_center' => 'Als Einstellungscenter-Seite festlegen',
    'mautic.page.form.preference_center.tooltip' => 'Wenn diese Option ausgewählt ist, wird die Seite als Zielseite des Einstellungscenters markiert. Wenn diese Seite als Einstellungscenter in einer Mautic-E-Mail konfiguriert ist, wird den Empfängern die Seite angezeigt, wenn sie auf den Link <strong><code>{unsubscribe_url}</code></strong> klicken.<br />Weitere Informationen finden Sie in der <a href="https://www.mautic.org/docs/en/contacts/customize_preference_center.html" target="_blank">Mautic-Dokumentation</a> unter Contacts / Preference Center.',
    'mautic.page.config.no_index' => 'Suchindex deaktivieren',
    'mautic.email.form.preference_center' => 'Abmeldeseite',
    'mautic.email.form.preference_center.tooltip' => 'Zeigt die ausgewählte Seite als Abmeldeseite an, wenn ein Benutzer über diese E-Mail darauf zugreift.',
    'mautic.page.permissions.preference_center' => 'Abmeldeseiten, auf die der User zugreifen darf',
    'mautic.page.form.segmentlist' => 'Liste der Segmente',
    'mautic.page.form.categorylist' => 'Liste der Kategorien',
    'mautic.page.form.preferredchannel' => 'Bevorzugter Channel',
    'mautic.page.form.channelfrequency' => 'Channel Frequenz',
    'mautic.page.form.saveprefs' => 'Präferenzen speichern',
    'mautic.page.form.successmessage' => 'Erfolgsmeldung',
    'mautic.page.form.leadidentifier' => 'Lead Erkennung',
    'mautic.page.form.frequency.label1' => 'Frequency Label 1',
    'mautic.page.form.frequency.label2' => 'Frequency Label 2',
    'mautic.page.form.pause.label1' => 'Pause Label 1',
    'mautic.page.form.pause.label2' => 'Pause Label 2',
    'mautic.page.form.has_variants' => 'Hat Varianten',
    'mautic.page.searchcommand.isprefcenter' => 'is:prefcenter',
    'mautic.page.result.header.index' => 'Ergebnisse für %name%',
    'mautic.asset.abtest.criteria' => 'Asset Statistiken',
    'mautic.asset.abtest.criteria.downloads' => 'Download Rate',
    'mautic.asset.abtest.downloads' => '%count% Downloads',
    'mautic.asset.abtest.label.downloads' => 'Anzahl Downloads',
    'mautic.asset.abtest.label.hits' => 'Anzahl eindeutiger Asset Downloads',
    'mautic.asset.abtest.label.sentemils' => 'Anzahl gesendeter E-Mails',
    'mautic.asset.actions' => 'Asset-Aktionen',
    'mautic.asset.asset' => 'Asset',
    'mautic.asset.asset.downloads.total' => 'Total: Anzahl',
    'mautic.asset.asset.downloads.unique' => 'Eindeutige: Anzahl',
    'mautic.asset.asset.error.missing.remote.path' => 'Es muss eine Remote URL angegeben werden, wenn die Remote Speicherung ausgewählt ist.',
    'mautic.asset.asset.form.confirmbatchdelete' => 'Die ausgewählten Assets löschen?',
    'mautic.asset.asset.form.confirmdelete' => 'Asset %name% löschen?',
    'mautic.asset.asset.form.file.upload' => 'Laden Sie eine Datei hoch (maximale Dateigröße = %max%)',
    'mautic.asset.asset.form.language.help' => 'Sprache für das Asset auswählen.',
    'mautic.asset.asset.form.remotePath' => 'Remote URL',
    'mautic.asset.asset.form.storageLocation' => 'Speicherort',
    'mautic.asset.asset.form.storageLocation.local' => 'Lokal',
    'mautic.asset.asset.form.storageLocation.remote' => 'Remote',
    'mautic.asset.asset.form.disallow.crawlers' => ' Indexierung dieser Datei durch Suchmaschinen blockieren',
    'mautic.asset.asset.form.disallow.crawlers.descr' => 'Wenn Sie keine Dateien wie PDF, DOCX usw. indizieren möchten, werden mit dieser Option Such-Bots mit dem HTTP-Header X-Robots-Tag nicht zugelassen.',
    'mautic.asset.asset.help.alias' => 'Buchstaben und Zahlen (Bindestriche zulässig), die zur URL-Generierung dieses Assets verwendet werden. Wenn das Feld leer gelassen wird, wird automatisch ein eindeutiger Alias ​​basierend auf dem Titel generiert.',
    'mautic.asset.asset.menu.edit' => 'Asset ändern',
    'mautic.asset.asset.menu.new' => 'Neues Asset',
    'mautic.asset.asset.path.relative' => 'relativer Pfad',
    'mautic.asset.asset.preview' => 'Vorschau',
    'mautic.asset.asset.size' => 'Größe der Datei',
    'mautic.asset.asset.submitaction.downloadfile' => 'Asset downloaden',
    'mautic.asset.asset.submitaction.downloadfile.msg' => '<br />Der Download sollte in 5 Sekunden starten. Wenn nicht, dann bitte hier <a href=\'%url%\'>klicken</a>.<script>setTimeout(function(){window.location=\'%url%\';}, 5000);</script>',
    'mautic.asset.asset.submitaction.downloadfile_descr' => 'Das ausgewählte Asset wenn das Formular abgeschickt wird',
    'mautic.asset.asset.thead.download.count' => 'Anzahl Downloads',
    'mautic.asset.asset.url' => 'Download URL',
    'mautic.asset.assets' => 'Assets',
    'mautic.asset.campaign.event.assets' => 'Nur für Assets',
    'mautic.asset.campaign.event.assets.descr' => 'Wählen Sie die Assets aus für die dieser Trigger gelten soll.. Wen Sie keine Assets ausgewählt haben gilt der Trigger für alle Assets.',
    'mautic.asset.campaign.event.download' => 'Downloads Asset',
    'mautic.asset.campaign.event.download_descr' => 'Acktionen triggern wenn ein Asset runtergeladen wurde',
    'mautic.asset.config.form.allowed.extensions' => 'Erlaubte Dateierweiterungen',
    'mautic.asset.config.form.allowed.extensions.tooltip' => 'Kommagetrennte Liste an Dateierweiterungen. Nur Dateien mit den angegebenen Erweiterungen können hochgeladen werden.',
    'mautic.asset.config.form.upload.dir' => 'Pfad zum Asset-Verzeichnis',
    'mautic.asset.config.form.upload.dir.tooltip' => 'Legen Sie den absoluten Pfad fest, wohin Assets hochgeladen werden sollen. %kernel.project_dir%/app kann als Platzhalter für das App-Verzeichnis im öffentlichen Webstamm verwendet werden. Es wird empfohlen, ein Verzeichnis außerhalb des öffentlichen Webstamms zu verwenden, um zu verhindern, dass Assets öffentlich zugänglich sind.',
    'mautic.asset.config.form.max.size' => 'Maximale Größe (MB)',
    'mautic.asset.config.form.max.size.tooltip' => 'Legen Sie die maximale Größe für hochgeladene Assets in MB (Megabyte) fest. Der Standardwert beträgt 6 MB.',
    'mautic.asset.downloadcount' => 'Anzahl Downloads',
    'mautic.asset.drop.file.here' => 'Ziehen Sie die Datei hierhin oder klicken Sie, um nach der Datei zu suchen und diese auszuwählen.',
    'mautic.asset.error.file.failed' => 'Datei konnte nicht hochgeladen werden.',
    'mautic.asset.event.download' => 'Asset runtergeladen',
    'mautic.asset.filename.local' => 'Lokaler Dateiname',
    'mautic.asset.filename.original' => 'Originaler Dateiname',
    'mautic.asset.filename.remote' => 'Remote Dateiname',
    'mautic.asset.form.submit.assets' => 'Asset',
    'mautic.asset.form.submit.assets_descr' => 'Wählen Sie das Asset aus das runtergeladen werden soll',
    'mautic.asset.form.submit.latest.category' => 'Benutze das letzte Asset der Kategorie',
    'mautic.asset.form.submit.latest.category_descr' => 'Wenn die Option \'Verwenden Sie die neueste Datei aus der Kategorie\' ausgewählt ist, wird durch die Aktion das neueste Asset aus der ausgewählten Kategorie heruntergeladen.',
    'mautic.asset.graph.line.downloads' => 'Downloads',
    'mautic.asset.graph.pie.statuses' => 'Download HTTP Status',
    'mautic.asset.no_audio_support' => 'Ihr Browser unterstützt keine Audio-Wiedergabe.',
    'mautic.asset.no_video_support' => 'Ihr Browser unterstützt keine Video-Wiedergabe.',
    'mautic.asset.noresults.tip' => 'Assets sind zum Beispiel White Papers, PDFs, Bilder, Dokumente, eBooks oder jede Datei, die an Kunden verteilt werden soll. Möchten Sie ein Asset anbieten, wenn der Kunde ein Formular ausgefüllt hat? Das geht ganz einfach! Fügen Sie die "Asset-Download"-Aktion im Formular-Editor hinzu.',
    'mautic.asset.permissions.assets' => 'Assets - auf die der User Zugriff hat',
    'mautic.asset.permissions.header' => 'Berechtigungen für Assets',
    'mautic.asset.point.action.assets' => 'Eingeschränkt auf die ausgewählten Assets',
    'mautic.asset.point.action.assets.descr' => 'Assets für diese Aktion auswählen. Wenn Sie kein Asset ausgewählt haben wir die Aktion auf alle Assets ausgeführt',
    'mautic.asset.point.action.download' => 'ein Asset herunterlädt',
    'mautic.asset.point.action.download_descr' => 'Kontakt-Punkte aktualisieren, wenn ein Asset heruntergeladen wird.',
    'mautic.asset.remote.file.browse' => 'Remote Dateien durchsuchen',
    'mautic.asset.remote.no_results' => 'Keine Remote Dateien gefunden.',
    'mautic.asset.remote.select_service' => 'Wählen Sie auf der linken Seite den Dienst aus. Sofern keine Dienste vorhanden sind, konfigurieren Sie diese im Zusatzmodul für Cloud Storage.',
    'mautic.asset.report.download.code' => 'Antwortcode',
    'mautic.asset.report.download.date_download' => 'Datum des Downloads',
    'mautic.asset.report.download_count' => 'Anzahl Downloads',
    'mautic.asset.report.downloads.table' => 'Asset Downloads',
    'mautic.asset.report.unique_download_count' => 'Anzahl eindeutiger Downloads',
    'mautic.asset.stage.action.download' => 'Asset herunterladen',
    'mautic.asset.table.most.downloaded' => 'Am häufigsten runtergeladene Assets',
    'mautic.asset.table.top.referrers' => 'Top Referrers',
    'mautic.campaign.asset.download' => 'Asset runtergeladen',
    'mautic.config.AssetBundle.upload_dir' => 'Upload Verzeichnis',
    'mautic.config.tab.assetconfig' => 'Asset Einstellungen',
    'mautic.asset.dashboard.widgets' => 'Asset Widgets',
    'mautic.asset.unique' => 'Einmalig',
    'mautic.asset.repetitive' => 'Wiederholend',
    'mautic.widget.asset.downloads.in.time' => 'Rechtzeitige Downloads',
    'mautic.widget.unique.vs.repetitive.downloads' => 'Einmalige gegen wiederholende Downloads',
    'mautic.widget.popular.assets' => 'Beliebte Assets',
    'mautic.widget.created.assets' => 'Erstellte Assets',
    'mautic.report.group.assets' => 'Assets',
    'mautic.asset.asset.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (Kommagetrennte IDs, keine Leerzeichen)<br />is:mine<br />is:published<br />is:unpublished<br />name:*<br />is:uncategorized<br />category:{category alias}',
    'mautic.campaign.form.submit' => 'Formular abgeschickt',
    'mautic.campaign.form.field_value' => 'Formularfeld Wert',
    'mautic.email.form.users' => 'Sende eine E-Mail an eine:n Mitarbeiter:in',
    'mautic.form.field' => 'Formularfeld',
    'mautic.form.abtest.criteria' => 'Formular Statistik',
    'mautic.form.abtest.criteria.submissions' => 'Submission-Rate',
    'mautic.form.abtest.label.hits' => 'Anzahl eindeutiger Seitenaufrufe',
    'mautic.form.abtest.label.sentemils' => 'Anzahl gesendeter E-Mails',
    'mautic.form.abtest.label.submissions' => 'Anzahl der Submissions',
    'mautic.form.abtest.submissions' => '%count% mal abgeschickt',
    'mautic.form.actions' => 'Formular Aktionen',
    'mautic.form.action.add' => 'Eine Submit Aktion hinzufügen',
    'mautic.form.action.repost' => 'Veröffentlichen Sie die Ergebnisse in einem anderen Formular',
    'mautic.form.action.repost.descr' => 'Leiten Sie die Ergebnissen ein anderes Formular weiter',
    'mautic.form.action.repost.authorization_header' => 'Authorisierungs Header',
    'mautic.form.action.repost.authorization_header.tooltip' => 'Wenn sich das Formular hinter einer Firewall befindet, setzen Sie hier den Authorization Header.',
    'mautic.form.action.repost.failed_subject' => 'Erneutes Senden des Formulars fehlgeschlagen: %form%',
    'mautic.form.action.repost.failed_message' => 'Submission URL: <a href=\'%link%\'>%link%</a><br /><br />Fehlermeldung: %message%<br /><br />Ergebnisse:<br />%results%',
    'mautic.form.action.repost.failure_email' => 'E-Mail zur Fehlerbenachrichtigung posten',
    'mautic.form.action.repost.failure_email.tooltip' => 'Wenn die erneute Veröffentlichung fehlschlägt, wird diese E-Mail benachrichtigt',
    'mautic.form.action.repost.field_mapping' => '(Optional) Überschreiben Sie die Feldnamen für das Empfangsformular:',
    'mautic.form.action.repost.post_url' => 'URL veröffentlichen',
    'mautic.form.action.repost.post_url.tooltip' => 'URL zur erneuten Veröffentlichung der Ergebnisse',
    'mautic.form.action.repost.validation_failed' => 'Die Formularüberprüfung ist fehlgeschlagen.',
    'mautic.form.action.sendemail' => 'Formular-Eingaben senden',
    'mautic.form.action.sendemail.descr' => 'Senden Sie eine einfache E-Mail mit den Formular-Eingaben an den Kontakt oder an andere E-Mail-Adressen.',
    'mautic.form.action.sendemail.immediately' => 'Sofort senden',
    'mautic.form.action.sendemail.immediately.desc' => 'Ignoriere den Warteschlangenmodus in den E-Mail-Einstellungen',
    'mautic.form.action.sendemail.copytolead' => 'An Kontakt senden',
    'mautic.form.action.sendemail.setreplyto' => 'Dem Kontakt antworten',
    'mautic.form.action.sendemail.setreplyto_tooltip' => 'Legen Sie die E-Mail-Adresse des Kontakts als &quot;Reply To&quot; Adresse an, damit bei der Beantwortung der Ergebnis-E-Mail die Kontaktadresse der Standardempfänger ist.',
    'mautic.form.action.sendemail.emailtoowner' => 'An den Eigentümer senden',
    'mautic.form.action.sendemail.dragfield' => 'Klicken, um ein Feld einzufügen',
    'mautic.form.action.sendemail.message' => 'Nachricht',
    'mautic.form.action.sendemail.subject' => 'Betreff',
    'mautic.form.action.sendemail.subject.default' => 'Neue Formular-Eingaben',
    'mautic.form.builder.formfield' => 'Übertragungsergebnis',
    'mautic.form.builder.formfield.placeholder' => 'Alias für das Formularfeld einfügen...',
    'mautic.form.campaign.event.forms' => 'Nur für Formulare',
    'mautic.form.campaign.event.forms_descr' => 'Wählen Sie ein oder mehrere Formulare die die Aktion für Dripflow auslösen sollen.',
    'mautic.form.campaign.event.submit' => 'Sendet den Inhalt des Formulars',
    'mautic.form.campaign.event.submit_descr' => 'Lösen Sie Aktionen aus, wenn ein Kontakt ein Formular abschickt',
    'mautic.form.confirm_batch_rebuild' => 'Gecachtes HTML für das ausgewählte Formular(e) wiederherstellen?',
    'mautic.form.details.detail' => 'Detail',
    'mautic.form.details.field_order' => 'Feldreihenfolge: %order%',
    'mautic.form.details.field_type' => 'Feldtyp: %type%',
    'mautic.form.event.submission' => '%form% abgeschickt',
    'mautic.form.event.submitted' => 'Formular abgeschickt',
    'mautic.form.field.add' => 'Ein Feld hinzufügen',
    'mautic.form.field.form.alias' => 'Name des HTML-Felds',
    'mautic.form.field.form.alias.tooltip' => 'Name für das HTML-Element. Nachdem das Formular gespeichert wurde, kann es nicht mehr bearbeitet werden. Bleibt das Feld leer, wird ein Name aus der Feldbezeichnung generiert.',
    'mautic.form.field.form.auto_fill' => 'Automatisches Ausfüllen',
    'mautic.form.field.form.container_attr' => 'Feld-Container Attribute',
    'mautic.form.field.form.value' => 'Wert',
    'mautic.form.field.form.emptyvalue' => 'Leerer Wert',
    'mautic.form.field.form.freetext_attributes' => 'Beschreibungstext Attribute',
    'mautic.form.field.form.freehtml_attributes' => 'HTML-Textattribute',
    'mautic.form.field.form.header' => 'Header',
    'mautic.form.field.form.header_attributes' => 'Header-Attribute',
    'mautic.form.field.form.helpmessage' => 'Hilfetext',
    'mautic.form.field.form.inputattr' => 'Eingabe-Attribute',
    'mautic.form.field.form.label' => 'Label',
    'mautic.form.field.form.labelattr' => 'Label-Attribute',
    'mautic.form.field.form.mapped.object' => 'Passendes Objekt',
    'mautic.form.field.form.mapped.field' => 'Passendes Feld',
    'mautic.form.field.form.multiple' => 'Mehrfache erlaubt?',
    'mautic.form.field.form.property_buttontype' => 'Button-Typ',
    'mautic.form.field.form.property_captcha' => 'Captcha Antwort',
    'mautic.form.field.form.property_captchaerror' => 'benutzerdefinierte Fehlermeldung',
    'mautic.form.field.form.property_list_sync_choices' => 'Verwenden Sie die Listenoptionen des zugewiesenen Kontakt- / Firmenfeldes.',
    'mautic.form.field.form.property_placeholder' => 'Eingabeplatzhalter',
    'mautic.form.field.form.property_pagebreak_nextpage_label' => 'Nächste Seite des Button Labels',
    'mautic.form.field.form.property_pagebreak_prevpage_label' => 'Vorherige Seite des Button Labels',
    'mautic.form.field.form.property_pagebreak_prevpage_placeholder' => 'Lassen Sie das Feld leer, um es zu verbergen',
    'mautic.form.field.form.saveresult' => 'Ergebnis speichern?',
    'mautic.form.field.form.showheader' => 'Header anzeigen?',
    'mautic.form.field.form.showlabel' => 'Label anzeigen?',
    'mautic.form.field.form.validationmsg' => 'Validierungstext',
    'mautic.form.field.group.labelattr' => 'Radio/Checkbox Label Attribute',
    'mautic.form.field.help.attr' => 'Füge benutzerdefinierte HTML Attribute hinzu. z.B. class=&quot;myclass&quot;',
    'mautic.form.field.help.auto_fill' => 'Aktiveren Sie das automatische Ausfüllen dieses Wertes mit den getrackten Werten eines Kontaktes. Bitte beachten Sie, dass es bei der Erfassung zu fehlerhaften Werten kommen kann, wenn mehrere Kontakte dieselbe IP-Adresse nutzen. Diese Funktion funktioniert momentan lediglich für eingebettete Formulare auf einer Mautic Landing Page.',
    'mautic.form.field.help.captcha' => 'Verwenden Sie das Label, um eine einfache Frage zu stellen, die jeder Mensch beantworten kann. Geben Sie hier die richtige Antwort ein. Wenn die Frage beispielsweise lautet "Was ist 10 plus 8?" Geben Sie hier 18 ein. Oder lassen Sie das Label leer, um es als Captcha zu verwenden.',
    'mautic.form.field.help.captcha_placeholder' => 'Lassen Sie das Feld leer, um es als Honeypot zu verwenden.',
    'mautic.form.field.help.container_attr' => 'Fügen Sie benutzerdefinierte HTML Attribute für das div hinzu, welches das gesamte Feld umfasst, z.B. class=&quot;myclass&quot;',
    'mautic.form.field.help.emptyvalue' => 'Geben Sie das Label an, das als leerer Wert in der ausgewählten Liste verwendet werden soll. Zum Deaktivieren frei lassen.',
    'mautic.form.field.help.pagebreak' => 'Fügen Sie einen Seitenumbruch ein, bei dem nur Felder für die aktuelle Seite angezeigt werden.',
    'mautic.form.field.help.group.labelattr' => 'Fügen Sie benutzerdefinierte HTML Attribute für das Label hinzu, das jeden Radio-Button/Checkbox umfasst, z.B. class=&quot;myclass&quot;. Wenn leer oder wenn Class nicht enthalten, wird ein umfassendes div um jedes Label/Eingabe gesetzt',
    'mautic.form.field.help.helpmessage' => 'Text, der unterhalb des Labels angezeigt wird.',
    'mautic.form.field.help.mapped.object' => 'Wähle ein Objekt aus, um unten die Liste der Felder anzuzeigen.',
    'mautic.form.field.help.mapped.field' => 'Wähle ein Feld aus, um es mit diesem Formularfeld zu verknüpfen. Wenn das Feld eine eindeutige Kennung wie eine E-Mail für Kontakte ist und ein Kontakt mit demselben Wert vorhanden ist, wird der entsprechende Kontakt aktualisiert. Wenn kein passender Kontakt gefunden wird, wird ein neuer Kontakt erstellt.',
    'mautic.form.field.help.saveresult' => 'Wenn nein, wird der Wert nicht in der Datenbank gespeichert.',
    'mautic.form.field.section.attributes' => 'Attribute',
    'mautic.form.field.section.general' => 'Generell',
    'mautic.form.field.section.mappedfield' => 'Zugeordnetes Feld',
    'mautic.form.field.section.properties' => 'Eigenschaften',
    'mautic.form.field.section.validation' => 'Validierung',
    'mautic.form.field.type.button' => 'Button',
    'mautic.form.field.type.captcha' => 'Sicherheitsüberprüfung',
    'mautic.form.field.type.checkboxgrp' => 'Checkbox-Gruppe',
    'mautic.form.field.type.freetext' => 'Beschreibungsbereich',
    'mautic.form.field.type.freehtml' => 'HTML Bereich',
    'mautic.form.field.type.hidden' => 'Versteckt',
    'mautic.form.field.type.password' => 'Passwort',
    'mautic.form.field.type.pagebreak' => 'Seitenumbruch',
    'mautic.form.field.type.radiogrp' => 'Radio-Gruppe',
    'mautic.form.field.type.textarea' => 'Text: Absatz',
    'mautic.form.field.type.file' => 'Datei',
    'mautic.form.field.type.tel.international' => 'Als internationales Forma validieren',
    'mautic.form.field.file.public' => 'Öffentlich zugänglicher Link zum Herunterladen',
    'mautic.form.field.file.allowed_extensions' => 'Erlaubte Dateierweiterungen',
    'mautic.form.field.file.allowed_size' => 'Maximale Größe (MB)',
    'mautic.form.field.file.set_as_profile_image' => 'Als Kontaktprofilbild festlegen',
    'mautic.form.field.file.tooltip.allowed_extensions' => 'Durch Kommas getrennte Werte (zB \'gif, jpg\')',
    'mautic.form.field.file.tooltip.allowed_size' => 'Die maximale Uploadgröße der PHP-Konfiguration beträgt: %uploadSize%MB',
    'mautic.form.stats.submission_counts' => 'Submissions (Unique/Total)',
    'mautic.form.form' => 'Formular',
    'mautic.form.form.addaction' => 'Wählen Sie eine Aktion aus der Liste "Neue Übermittlungsaktion hinzufügen" aus.',
    'mautic.form.form.addfield' => 'Wählen Sie ein Feld aus der Liste \'Neues Feld hinzufügen\' aus.',
    'mautic.form.form.component.fields' => 'Ein neues Feld hinzufügen',
    'mautic.form.form.component.submitactions' => 'Eine neue Übermittlungsaktion hinzufügen',
    'mautic.form.form.confirmbatchdelete' => 'Ausgewählte Formulare löschen? Dadurch werden auch ALLE Ergebnisse dieser Formulare gelöscht!',
    'mautic.form.form.confirmdelete' => 'Das Formular %name% löschen?  Dadurch werden auch ALLE Ergebnisse dieser Formulare gelöscht!',
    'mautic.form.form.header.embedded' => 'Eingebettet',
    'mautic.form.form.header.copy' => 'Formular HTML',
    'mautic.form.form.header.edit' => 'Formular %name% ändern',
    'mautic.form.form.header.selfhosted' => 'Selbst gehostet',
    'mautic.form.form.header.new' => 'Neues Formular',
    'mautic.form.form.header.preview' => 'Vorschau des Formulars',
    'mautic.form.form.help.automaticcopy' => 'Wenn diese Option verwendet wird, kann das gesamte Formular innerhalb der Plattform bearbeitet werden und diese Änderungen werden automatisch auf jeder Seite angezeigt, auf der es eingefügt wird.',
    'mautic.form.form.help.automaticcopy.js' => 'Durch Javascript (empfohlen)',
    'mautic.form.form.help.automaticcopy.iframe' => 'Durch iframe',
    'mautic.form.form.help.automaticcopy.iframe.note' => 'Hinweis: Passen Sie die Breite und Höhe an, damit das Formular hineinpasst.',
    'mautic.form.form.help.landingpages' => 'Es ist sehr einfach ein Formular in eine Mautic Landing Page einzubauen: Verwenden Sie den Editor und wählen Sie das Formular aus. Für mehr Flexibilität gibt es zwei weiter Optionen:',
    'mautic.form.form.help.selfhosted' => 'Bei Verwendung von selbst gehostetem HTML werden auf der Plattform vorgenommene Änderungen erst dann auf Ihrer Site aktualisiert, wenn Sie den HTML-Code manuell bearbeiten. Dadurch wird sichergestellt, dass Sie nicht von externen Servern abhängig sind und die Privatsphäre besser geschützt ist.',
    'mautic.form.form.help.selfhosted.body' => 'Kopieren und fügen Sie die Formularinhalte in das Dokument ein.',
    'mautic.form.form.help.selfhosted.script' => 'Kopieren und fügen Sie Inhalte in das Dokument ein. Wenn Sie mehrere Formulare einfügen, nutzen Sie diese Funktion nur einmal pro Seite.',
    'mautic.form.form.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (Kommagetrennte IDs, keine Leerzeiche)<br />is:mine<br />is:published<br />is:unpublished<br />has:results<br />name:*<br />is:uncategorized<br />category:{category alias}',
    'mautic.form.form.kioskmode' => 'Kiosk-Modus',
    'mautic.form.form.kioskmode.tooltip' => 'Wenn ja, werden beim Abschicken des Formulars keine neuen Kontakt Tracking Cookies erstellt oder die IP-Adresse bestehenden/aktualisierten Kontakten zugewiesen.',
    'mautic.form.form.renderstyle' => 'Vorlagenstil verwenden?',
    'mautic.form.form.renderstyle.tooltip' => 'Deaktivieren/Aktivieren der Darstellung von CSS aus der Vorlage',
    'mautic.form.form.no_index' => 'Suchindex deaktivieren',
    'mautic.form.form.progressive_profiling_limit.max_fields' => 'Maximale gleichzeitig angezeigte Felder',
    'mautic.form.form.progressive_profiling_limit.max_fields.tooltip' => 'Die Nummer für dieses Feld aktiviert die Funktion für progressives Profiling und erlaubt das Rendern nur einer bestimmten Anzahl von Feldern gleichzeitig.',
    'mautic.form.form.progressive_profiling_limit_unlimited' => 'unlimitiert',
    'mautic.form.form.modalheader' => 'Details der Formularkomponenten',
    'mautic.form.form.pagetoken.notpublished' => 'Dieses Formular wurde noch nicht veröffentlicht. Es ist nicht öffentlich sichtbar.',
    'mautic.form.form.postaction' => 'Aktion nach erfolgreichem Absenden',
    'mautic.form.form.postaction.message' => 'Text anzeigen',
    'mautic.form.form.postaction.redirect' => 'Weiterleiten zu URL',
    'mautic.form.form.postaction.return' => 'Im Formular bleiben',
    'mautic.form.form.postactionproperty' => 'Weiterleitungs-URL/Text',
    'mautic.form.form.preview' => 'Vorschau',
    'mautic.form.form.resultcount' => 'Anzahl Ergebnisse',
    'mautic.form.form.results' => 'Ergebnisse',
    'mautic.form.form.viewresults' => '{0} Keine Ergebnisse|{1} Ein Ergebnis anzeigen|]1,Inf[ %count% Ergebnisse anzeigen',
    'mautic.form.form.results.name' => 'Ergebnis ID %id%',
    'mautic.form.form.searchcommand.hasresults' => 'hat:ergebnisse',
    'mautic.form.form.searchcommand.isexpired' => 'is:expired',
    'mautic.form.form.searchcommand.ispending' => 'is:pending',
    'mautic.form.form.template.help' => 'Wenn dieses Formular in eine externe 3rd Party Seite via Popup oder iFrame eingebunden werden soll, wählen Sie eine Vorlage, um den Style der Seite festzulegen, in die das Formular eingebunden wird.',
    'mautic.form.field.form.form_attr' => 'Formular-Attribute',
    'mautic.form.field.form.form_attr.tooltip' => 'Fügen Sie dem Formular-Tag benutzerdefinierte HTML-Attribute hinzu, z. B. name=&quot;my-form&quot;. Einige Softwareprogramme erfordern möglicherweise benutzerdefinierte Attribute.',
    'mautic.form.forms' => 'Formulare',
    'mautic.form.graph.line.submissions' => 'Submissions',
    'mautic.form.icon_tooltip.campaign_form' => 'Ist ein Kampagnen-Formular',
    'mautic.form.noresults.tip' => 'Verwenden Sie unsere Third-Party-CMS-Plugins, um Formulare in Ihre Webseite einzubinden.',
    'mautic.form.permissions.forms' => 'Formulare, auf die der User Zugriff hat',
    'mautic.form.permissions.header' => 'Berechtigungen für Formulare',
    'mautic.form.point.action' => 'Formular-Aktionen',
    'mautic.form.point.action.forms' => 'Beschränkt auf ausgewählte Formulare',
    'mautic.form.point.action.forms.descr' => 'Wählen Sie die Formulare, für die diese Aktion zutrifft. Wenn nichts ausgewählt wird, gilt sie für alle Formulare.',
    'mautic.form.point.action.submit' => 'ein Formular abschickt',
    'mautic.form.point.action.submit_descr' => 'Passen Sie die Kontakt-Punkte an, wenn ein Formular gesendet wird.',
    'mautic.form.rebuild' => 'Cache neu erstellen',
    'mautic.form.report.form_id' => 'Formular-ID',
    'mautic.form.report.page_id' => 'Seiten-ID',
    'mautic.form.report.page_name' => 'Seitenname',
    'mautic.form.report.submission.table' => 'Formularübertragungen',
    'mautic.form.report.submission.id' => 'Einsendung ID',
    'mautic.form.report.submit.date_submitted' => 'Übertragungsdatum',
    'mautic.form.report.form_results.label' => 'Formularergebnisse %field%',
    'mautic.form.result.export.csv' => 'CSV-Export',
    'mautic.form.result.export.html' => 'HTML-Export',
    'mautic.form.result.export.pdf' => 'PDF-Export',
    'mautic.form.result.export.xlsx' => 'Excel-Export',
    'mautic.form.result.header.index' => 'Ergebnisse für %name%',
    'mautic.form.result.thead.date' => 'Datum der Absendung',
    'mautic.form.result.thead.referrer' => 'Referrer',
    'mautic.form_results.form.confirmbatchdelete' => 'Die ausgewählten Ergebnisse löschen?',
    'mautic.form.results.form.confirmdelete' => 'Dieses Ergebnis löschen?',
    'mautic.form.stage.action' => 'Formular Aktionen',
    'mautic.form.stage.action.submit' => 'Schickt das Formular ab',
    'mautic.form.submission.errors' => 'Fehler:',
    'mautic.form.submission.thankyou' => 'Vielen Dank!',
    'mautic.form.submission.pleasewait' => 'Bitte warten...',
    'mautic.form.tab.actions' => 'Aktionen',
    'mautic.form.tab.fields' => 'Felder',
    'mautic.form.table.most.submitted' => 'Am meisten abgeschickte Formulare',
    'mautic.form.table.top.referrers' => 'Top Referrer',
    'mautic.form.type.header' => 'Welche Art von Formular möchten Sie erstellen?',
    'mautic.form.type.campaign' => 'Kampagnen-Formulare',
    'mautic.form.type.one.differences.1st' => 'Wird verwendet, um automatisierte Kampagnen-Workflows zu initiieren',
    'mautic.form.type.one.differences.2nd' => 'Eingeschränkte Formularaktionen',
    'mautic.form.type.one.differences.3rd' => 'Konzentriert sich auf das Kontaktmanagement',
    'mautic.form.type.two.differences.1st' => 'Eigenständige Formulare mit Fokus auf Flexibilität',
    'mautic.form.type.two.differences.2nd' => 'Enthält alle Formularaktionen',
    'mautic.form.type.two.differences.3rd' => 'Aktionen zur Bewertung, Segmentierung und Integration',
    'mautic.form.type.campaign.header' => 'Kampagnenformular',
    'mautic.form.type.standalone' => 'Einzelformulare',
    'mautic.form.type.standalone.header' => 'Eigenständiges Formular',
    'mautic.form.webhook.event.form.submit' => 'Abgeschicktes Formular Ereignis',
    'mautic.form.campaign.event.field_value' => 'Formularfeld Wert',
    'mautic.form.campaign.event.field_value_descr' => 'Stoßen Sie Aktionen an, wenn der eingetragene Formularfeld Wert die festgelegte Bedingung erfüllt.',
    'mautic.form.dashboard.widgets' => 'Formular-Widgets',
    'mautic.form.lead' => 'Lead',
    'mautic.form.submission.count' => 'Anzahl der Einreichungen',
    'mautic.widget.submissions.in.time' => 'Einreichungen im Zeitverlauf',
    'mautic.widget.top.submission.referrers' => 'Top Referrer für Einreichungen',
    'mautic.widget.top.submitters' => 'Top Sender',
    'mautic.widget.created.forms' => 'Erstellte Formulare',
    'mautic.report.group.forms' => 'Formulare',
    'mautic.report.group.form.results' => 'Formularergebnisse',
    'mautic.form.field.section.progressive.profiling' => 'Verhalten',
    'mautic.form.field.form.always_display' => 'Immer anzeigen',
    'mautic.form.field.form.always_display.tooltip' => 'Erzwingen Sie die Anzeige dieses Felds im Formular, wenn Sie die maximale Anzahl gleichzeitig angezeigter Felder festlegen.',
    'mautic.form.field.form.show.when.value.exists' => 'Wert anzeigen, wenn vorhanden',
    'mautic.form.field.help.show.when.value.exists' => 'Zeige dieses Feld, wenn der aktive Kontakt diesen Feld-Wert ausgefüllt hat.',
    'mautic.form.field.form.show.after.x.submissions' => 'Zeige nach X Einreichungen',
    'mautic.form.field.help.show.after.x.submissions' => 'Zeige dieses Feld nur, wenn der aktive Kontakt dieses Formular X Mal abgeschickt hat, wobei X die Anzahl der Einreichungen ist.',
    'mautic.form.field.hide.if.value' => 'Verstecken, wenn Wert vorhanden',
    'mautic.form.field.hide.if.submission.count' => '{1}Zeige nach 1 Einreichung|[2,Inf] Zeige nach %count% Einreichungen',
    'mautic.config.tab.formconfig' => 'Formulareinstellungen',
    'mautic.config.tab.formresultsconfig' => 'Einstellungen für Formularergebnisse',
    'mautic.form.field.type.donotsubmit' => 'Filter für die Übermittlung von Domänennamen',
    'mautic.form.config.form.do_not_submit_email' => 'Akzeptiere keine Einsendungen von diesen Domänennamen',
    'mautic.form.config.form.do_not_submit_email.tooltip' => 'Geben Sie die E-Mail-Adressen ein (eine pro Zeile), auf die Sie die Formularübermittlung beschränken möchten. Sie können eine bestimmte E-Mail-Adresse (email@yourdomain.com) oder einen ganzen Domänennamen mit Platzhaltern (*domain.com) filtern.',
    'mautic.form.config.form_results_data_sources' => 'Verwenden des Formularergebnisses als Berichtsdatenquelle',
    'mautic.form.config.form_results_data_sources.tooltip' => 'Aktivieren Sie diese Option, wenn Sie die Formularergebnistabellen als Berichtsdatenquellen verwenden möchten.',
    'mautic.form.config.form.successful_submit_action' => 'Erfolgreiche Übermittlungsaktion',
    'mautic.form.config.form.successful_submit_action.tooltip' => 'Wählen Sie den Ort der erfolgreichen Übermittlungsaktion im Formular aus',
    'mautic.form.config.form.successful_submit_action_at_the_top' => 'zuoberst',
    'mautic.form.config.form.successful_submit_action_at_the_bottom' => 'ganz unten',
    'mautic.form.field.form.condition' => 'Bedingung',
    'mautic.form.field.form.condition.enabled' => 'Aktiviert',
    'mautic.form.field.form.condition.show.only' => 'Nur bei ausgewählten Werten anzeigen',
    'mautic.form.field.form.condition.show.only.tooltip' => 'Auswahlfelder mit Optionsgruppen zeigen nur die Optionsgruppe an, die dem übergeordneten Feldwert entspricht. Wenn keine Optionsgruppe vorhanden ist, wird das bedingte Feld selbst ausgeblendet. Anwendungsfall: Nur Bundesstaaten für Länder anzeigen, die einige Bundesstaaten haben.',
    'mautic.form.field.form.condition.field.value' => '',
    'mautic.form.field.form.dependency.label' => 'Ist dieses Feld vom eingegebenen Wert eines anderen Feldes abhängig?',
    'mautic.form.field.form.dependent.field.mapping' => 'Abhängige Feldzuordnung',
    'mautic.form.field.form.condition.show.on' => 'Nur anzeigen, wenn Auswahl aus',
    'mautic.form.field.form.condition.select.value' => 'Werte',
    'mautic.form.field.form.condition.any_value' => 'Jeder Wert',
    'mautic.form.field.form.number_precision' => 'Genauigkeit',
    'mautic.form.field.form.number_precision.tooltip' => 'Anzahl der Stellen die erlaubt sind bevor gerundet wird.',
    'mautic.form.form.component.fields.conditional' => 'Feld basierend auf ausgewähltem Wert hinzufügen',
    'mautic.form.field.form.condition.select_one_of' => 'Wählen Sie eine der',
    'mautic.form.field.form.condition.select_other_thatn' => 'Wähle etwas anderes als',
    'mautic.form.form.locale.tooltip' => 'Legen Sie die primäre Sprache des Formulars fest. Standardmäßig wird die Sprache der Konfiguration verwendet.',
    'helloworld.client_id' => 'Client-ID',
    'helloworld.client_secret' => 'Client-Secret',
    'helloworld.default_world' => 'Standard Welt',
    'helloworld.object.citizen' => 'Einwohner',
    'helloworld.object.world' => 'Welt',
    'helloworld.world.earth' => 'Erde',
    'helloworld.world.jupiter' => 'Jupiter',
    'helloworld.world.mars' => 'Mars',
    'helloworld.world.saturn' => 'Saturn',
    'mautic.api.auth.error.accessdenied' => 'API Autorisierung abgelehnt',
    'mautic.api.auth.error.apidisabled' => 'API Zugang ist deaktiviert. Bitte kontaktieren Sie den Adminsitrator.',
    'mautic.api.auth.error.parameter_absent' => 'In der Anfrage fehlt ein Parameter. Falls doch alle Parameter angegeben sind, ist ein typischer Grund ein Tippfehler im Authorization Header. Prüfen Sie auf Schreibfehler, falsche Anführungszeichen usw. Denken Sie daran, das jeder OAuth Protocol Parameter mit doppelten Anführungszeichen eingeschlossen werden muss.',
    'mautic.api.auth.error.timestamp_refused' => 'Der eigegebene Timestamp ist ungültig (entweder ist er nicht richtig formatiert oder er ist außerhalb des erlaubten Zeitfensters).',
    'mautic.api.auth.error.nonce_used' => 'Der Nonce-Wert wurde nicht akzeptiert.',
    'mautic.api.auth.error.signature_method_rejected' => 'Die Signatur-Methode wird nicht unterstützt.',
    'mautic.api.auth.error.signature_invalid' => 'Die mitgeteilte Signatur entspricht nicht der berechneten des Dienstes.',
    'mautic.api.auth.error.consumer_key_unknown' => 'Der mitgeteilte Consumer Key wird nicht unterstützt.',
    'mautic.api.auth.error.token_expired' => 'Der Access Token ist gültig, ist aber abgelaufen.',
    'mautic.api.auth.error.token_rejected' => 'Das angegebene Zeichen hat nicht das richtige Format.',
    'mautic.api.auth.error.additional_authorization_required' => 'Das Access Token hat nicht die passenden Berechtigungen.',
    'permission_denied' => 'Der Access Session Handle (ASH) ist abgelaufen oder ungültig.',
    'mautic.api.call.notfound' => 'Objekt nicht gefunden',
    'mautic.api.call.batch_exception' => 'Es werden höchstens %limit% Einheiten pro Durchgang unterstützt.',
    'mautic.api.call.id_missing' => 'Die ID der Nutzdaten (payload) fehlt.',
    'mautic.api.client.form.auth_protocol' => 'Protokoll der Autorisierung',
    'mautic.api.client.form.clientid' => 'Client-ID',
    'mautic.api.client.form.clientsecret' => 'Client-Secret',
    'mautic.api.client.form.confirmdelete' => 'API-Client  %name% löschen? Anwendungen, die diesen Client verwenden werden keinen Zugriff auf Mautics API mehr haben',
    'mautic.api.client.form.confirmrevoke' => 'Zugriff für %name% widerrufen?',
    'mautic.api.client.form.help.callback' => 'Geben Sie bitte eine Callback URI an. Lassen Sie das Feld frei wenn Sie keine Callbacks zulassen möchten.',
    'mautic.api.client.form.help.requesturis' => 'Geben Sie die URI(s) an, die Zugriff auf die API haben dürfen. Mehrere URIs können durch Kommas getrennt werden.',
    'mautic.api.client.form.name' => 'Name vom Client',
    'mautic.api.client.form.revoke' => 'Zugang widerrufen',
    'mautic.api.client.header.edit' => 'Berechtigungen - %name% bearbeiten',
    'mautic.api.client.header.index' => 'API Berechtigungen (Anwendungen)',
    'mautic.api.client.header.new' => 'Berechtigungen - Neue Berechtigung',
    'mautic.api.client.help.searchcommands' => '<strong>Suchbefehle</strong><br />name:*<br />ids:ID1,ID2 (comma separated IDs, no spaces)<br />callback:* (OAuth 1.0a)<br />redirecturi:* (OAuth 2)',
    'mautic.api.client.menu.index' => 'API Berechtigungen',
    'mautic.api.client.redirecturis' => 'Redirect URI',
    'mautic.api.client.searchcommand.callback' => 'Callback',
    'mautic.api.client.searchcommand.redirecturi' => 'RedirectUrl',
    'mautic.api.client.thead.publicid' => 'öffentlicher Schlüssel',
    'mautic.api.client.thead.secret' => 'Geheimer Schlüssel',
    'mautic.api.config.form.api.enabled' => 'API aktiviert?',
    'mautic.api.config.form.api.basic_auth_enabled' => 'HTTP basic aktivieren?',
    'mautic.api.config.form.api.basic_auth.tooltip' => 'HTTP Basic Authentifizierung für die Mautic API aktivieren. Es wird dringend empfohlen, dies nur mit gesicherten Seiten zu verwenden (HTTPS).',
    'mautic.api.config.form.api.enabled.tooltip' => 'Mautics API aktivieren?',
    'mautic.api.config.form.api.oauth2_access_token_lifetime' => 'Access Token Lebensdauer (in Minuten)',
    'mautic.api.config.form.api.oauth2_access_token_lifetime.tooltip' => 'Wenn Sie OAuth2 nutzen, setzen Sie die Lebensdauer des Access Token, der die Anfrage autorisiert. Standard sind 60 Minuten.',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime' => 'Refresh Token Lebensdauer (in Tagen)',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime.tooltip' => 'Wenn Sie OAuth2 nutzen, setzen Sie die Lebensdauer des Refresh Token, der einen neuen Access Token anfordert, sobald der aktuelle abgelaufen ist. Wenn der Refresh Token abläuft, muss die Autorisierung erneut durchgeführt werden. Standard sind 14 Tage.',
    'mautic.api.config.oauth2' => 'OAuth2',
    'mautic.api.oauth.accept' => 'Annehmen',
    'mautic.api.oauth.auth.failed' => 'OAuth Authentifizierung fehlgeschlagen',
    'mautic.api.oauth.clientnoname' => 'Eine Anwendung möchte sich mit Ihrem Account verbinden',
    'mautic.api.oauth.clientwithname' => 'Die Anwendung <strong>%name%</strong> möchte sich mit Ihrem Account verbinden.',
    'mautic.api.oauth.deny' => 'Verweigern',
    'mautic.api.oauth.header' => 'OAuth Authorisierung',
    'mautic.api.permissions.apiaccess' => 'API Zugriff',
    'mautic.api.permissions.clients' => 'Clients (Anwendungen) zu denen der Benutzer Zugriff hat',
    'mautic.api.permissions.granted' => 'Genehmigt',
    'mautic.api.permissions.header' => 'API Berechtigungen',
    'mautic.config.tab.apiconfig' => 'API Einstellungen',
    'mautic.core.error.badrequest' => 'Falscher Request',
    'mautic.api.error.api.disabled' => 'API deaktiviert. Sie müssen die API in den API-Einstellungen der Mautic-Konfiguration aktivieren.',
    'mautic.api.error.basic.auth.disabled' => 'Basic Authentifizierung deaktiviert. Sie müssen die HTTP-Basic Authentifizierung in den API-Einstellungen der Mautic-Konfiguration aktivieren.',
    'mautic.api.error.basic.auth.invalid.credentials' => 'Zugriff verweigert, ungültige Zugangsdaten.',
    'mautic.config.tab.webhookconfig' => 'Webhook Einstellungen',
    'mautic.webhook.config.cron_process' => 'Nur Queue Ereignisse - ausgeführt per CLI Befehl',
    'mautic.webhook.config.form.queue.mode.tooltip' => 'Legen Sie fest, wie Webhook Ereignisse verarbeitet werden. Sie können entweder sofort ausgeführt werden oder in eine Warteschlange gelegt werden, um später mit einem Cronjob ausgeführt zu werden.',
    'mautic.webhook.config.form.queue.mode' => 'Queue Modus',
    'mautic.webhook.config.immediate_process' => 'Ereignisse sofort verarbeiten',
    'mautic.webhook.error.notfound' => 'Webhook nicht gefunden',
    'mautic.webhook.form.confirmbatchdelete' => 'Ausgewählte Webhooks löschen?',
    'mautic.webhook.form.confirmdelete' => 'Webhook %name% löschen?',
    'mautic.webhook.form.description' => 'Webhook Beschreibung',
    'mautic.webhook.form.webhook.events' => 'Webhook Ereignisse',
    'mautic.webhook.form.webhook_url' => 'Webhook POST URL',
    'mautic.webhook.form.secret' => 'Geheim',
    'mautic.webhook.secret.tooltip' => 'Dieses Feld wird automatisch generiert, wenn kein Wert angegeben wird. Verwenden Sie diesen geheimen Hash, um die Authentizität des Webhook-Payloads auf dem Zielserver zu überprüfen.',
    'mautic.webhook.label.success' => 'Erfolgreich!',
    'mautic.webhook.label.warning' => 'Fehler gefunden!',
    'mautic.webhook.label.no.url' => 'Keine URL angegeben',
    'mautic.webhook.no.logs' => 'Keine Webhook Logs',
    'mautic.webhook.no.logs_desc' => 'Dieser Webhook wurde bisher nicht ausgeführt, sodass keine Logs verfügbar sind.',
    'mautic.webhook.permissions.header' => 'Webhook Berechtigungen',
    'mautic.webhook.permissions.webhooks' => 'Webhooks, auf die der Nutzer Zugriff hat',
    'mautic.webhook.send.test.payload' => 'Test-Nutzlast senden',
    'mautic.webhook.status' => 'Antwort',
    'mautic.webhook.webhook.header.edit' => 'Webhook bearbeiten',
    'mautic.webhook.webhook.header.new' => 'Neuen Webhook erstellen',
    'mautic.webhook.webhook.logs.desc' => 'Das sind die Logs für diesen Hook. Immer wenn ein Ereignis diesen Hook aktiviert, speichern wir den HTTP Response Header. Eine erfolgreiche Antwort sollte ein 200 Header sein. Alle anderen Antworten werden als Fehler angesehen.',
    'mautic.webhook.webhook.logs.title' => 'Webhook Antwort-Log',
    'mautic.webhook.webhook.logs.empty.response' => 'Leere Antwortnachricht erhalten.',
    'mautic.webhook.webhook.menu.index' => 'Webhooks',
    'mautic.webhook.webhook_url' => 'Webhook URL',
    'mautic.webhook.webhooks' => 'Webhooks',
    'mautic.webhook.stopped' => 'Webhook wurde gestoppt',
    'mautic.webhook.stopped.details' => '%webhook% wurde wegen %reason% gestoppt',
    'mautic.webhook.stopped.reason' => 'Die Antworten waren einige Zeit nicht erfolgreich',
    'mautic.webhook.stopped.reason.410' => 'Der Antwort-HTTP-Code war 410, was bedeutet, dass der Empfänger keine weiteren Anfragen möchte.',
    'mautic.webhook.note' => 'Meldung',
    'mautic.webhook.runtime' => 'Laufzeit anfordern',
    'mautic.webhook.killed' => 'Der Webhook wurde automatisch deaktiviert, da die Antwort %limit% Mal hintereinander einen Fehler verursacht hat.',
    'mautic.webhook.config.event.orderby' => 'Sortierung der anstehenden Ereignisse',
    'mautic.webhook.config.event.orderby.tooltip' => 'Eine Webhook-Anfrage kann mehrere Ereignisse enthalten, wenn eine Warteschlange verwendet wird. Der Standardwert wird in den Einstellungen definiert.',
    'mautic.webhook.config.event.orderby.chronological' => 'Chronologisch',
    'mautic.webhook.config.event.orderby.reverse.chronological' => 'umgekehrte chronologische Reihenfolge',
    'mautic.webhook.event.sendwebhook' => 'Webhook senden',
    'mautic.webhook.event.sendwebhook_desc' => 'Webhook senden (nur für erfahrene Nutzer)',
    'mautic.campaign.campaign.sendwebhook' => 'Webhook senden',
    'mautic.webhook.event.sendwebhook.url' => 'URL',
    'mautic.webhook.event.sendwebhook.method' => 'Vorgehensweise',
    'mautic.webhook.event.sendwebhook.data' => 'Daten',
    'mautic.webhook.event.sendwebhook.headers' => 'Überschriften',
    'mautic.webhook.event.sendwebhook.timeout' => 'Zeitüberschreitung',
    'mautic.webhook.config.email.details' => 'E-Mail-Details senden',
    'mautic.webhook.config.email.details.tooltip' => 'Wenn aktiviert, senden E-Mail-bezogene Webhooks detaillierte Daten.',
    'mautic.constantcontact.customfield1' => 'Benutzerdefiniertes Feld 1',
    'mautic.constantcontact.customfield2' => 'Benutzerdefiniertes Feld 2',
    'mautic.constantcontact.customfield3' => 'Benutzerdefiniertes Feld 3',
    'mautic.constantcontact.customfield4' => 'Benutzerdefiniertes Feld 4',
    'mautic.constantcontact.customfield5' => 'Benutzerdefiniertes Feld 5',
    'mautic.constantcontact.customfield6' => 'Benutzerdefiniertes Feld 6',
    'mautic.constantcontact.customfield7' => 'Benutzerdefiniertes Feld 7',
    'mautic.constantcontact.customfield8' => 'Benutzerdefiniertes Feld 8',
    'mautic.constantcontact.customfield9' => 'Benutzerdefiniertes Feld 9',
    'mautic.constantcontact.customfield10' => 'Benutzerdefiniertes Feld 10',
    'mautic.constantcontact.customfield11' => 'Benutzerdefiniertes Feld 11',
    'mautic.constantcontact.customfield12' => 'Benutzerdefiniertes Feld 12',
    'mautic.constantcontact.customfield13' => 'Benutzerdefiniertes Feld 13',
    'mautic.constantcontact.customfield14' => 'Benutzerdefiniertes Feld 14',
    'mautic.constantcontact.customfield15' => 'Benutzerdefiniertes Feld 15',
    'mautic.constantcontact.field.address_city' => 'Ort',
    'mautic.constantcontact.field.address_country_code' => 'Länderkürzel (2 Zeichen)',
    'mautic.constantcontact.field.address_line1' => 'Adresszeile 1',
    'mautic.constantcontact.field.address_line2' => 'Adresszeile 2',
    'mautic.constantcontact.field.address_state' => 'Bundesland',
    'mautic.constantcontact.field.address_postal_code' => 'Postleitzahl',
    'mautic.constantcontact.field.cell_phone' => 'Mobiltelefon',
    'mautic.constantcontact.field.company_name' => 'Firmenname',
    'mautic.constantcontact.field.email' => 'E-Mail',
    'mautic.constantcontact.field.fax' => 'Fax',
    'mautic.constantcontact.field.first_name' => 'Vorname',
    'mautic.constantcontact.field.home_phone' => 'Telefon Zuhause',
    'mautic.constantcontact.field.job_title' => 'Berufsbezeichnung',
    'mautic.constantcontact.field.last_name' => 'Nachname',
    'mautic.constantcontact.field.prefix_name' => 'Präfixnamen',
    'mautic.constantcontact.field.work_phone' => 'Telefon Arbeit',
    'mautic.icontact.field.business' => 'Telefon Geschäft',
    'mautic.icontact.field.city' => 'Ort',
    'mautic.icontact.field.email' => 'E-Mail',
    'mautic.icontact.field.fax' => 'Fax',
    'mautic.icontact.field.firstName' => 'Vorname',
    'mautic.icontact.field.lastName' => 'Nachname',
    'mautic.icontact.field.phone' => 'Telefon',
    'mautic.icontact.field.postalCode' => 'Postleitzahl',
    'mautic.icontact.field.prefix' => 'Namensvorsatz',
    'mautic.icontact.field.street' => 'Adresszeile 1',
    'mautic.icontact.field.street2' => 'Adresszeile 2',
    'mautic.icontact.field.suffix' => 'Suffix',
    'mautic.icontact.field.state' => 'Bundesland',
    'mautic.icontact.keyfield.appid' => 'App-ID',
    'mautic.icontact.keyfield.username' => 'App Nutzername',
    'mautic.icontact.keyfield.password' => 'App API Passwort',
    'mautic.emailmarketing.list' => 'Liste',
    'mautic.emailmarketing.list.tooltip' => 'Wählen Sie die Liste, zu der der Lead hinzugefügt werden soll.',
    'mautic.emailmarketing.list.update' => 'Der Tab für die Zuordnung der Lead-Felder erscheint, nachdem eine Liste ausgewählt wurde und wird bei Veränderungen der ausgewählten Liste aktualisiert.',
    'mautic.emailmarketing.send_welcome' => 'Begrüßungsmail senden',
    'mautic.mailchimp.double_optin' => 'Double Opt-In aktivieren',
    'marketplace.title' => 'Marktplatz <sup>BETA</sup>',
    'marketplace.beta.warning' => '<strong>Achtung!</strong> Dies ist eine Vorschau des Mautic Marketplace. Einige Dinge funktionieren möglicherweise noch nicht wie erwartet. <a target=\'_blank\' href=\'https://docs.mautic.org/en/marketplace\'>[Weiterlesen]</a>',
    'marketplace.composer.required' => '<strong>Achtung!</strong> Zum Installieren oder Aktualisieren von Plugins sind technische Einstellungen erforderlich. <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>Sende diese Anweisungen an einen Entwickler.</a>',
    'mautic.marketplace.permissions.header' => 'Marktplatz Berechtigungen ',
    'mautic.marketplace.permissions.packages' => 'Pakete - auf welche der Nutzer Zugriff hat ',
    'marketplace.vendor' => 'Verkäufer ',
    'marketplace.downloads' => 'Downloads',
    'marketplace.favers' => 'Stars',
    'marketplace.package.github.stars' => 'Stars',
    'marketplace.package.github.watchers' => 'Zuschauer',
    'marketplace.package.github.forks' => 'Forks',
    'marketplace.package.github.open.issues' => 'Thema öffnen',
    'marketplace.package.dependents' => 'Zugehöriges Paket',
    'marketplace.package.suggesters' => 'Vorgeschlagen von anderen Paketen ',
    'marketplace.package.total.downloads' => 'Total Downloads',
    'marketplace.package.monthly.downloads' => 'Monatliche Downloads',
    'marketplace.package.daily.downloads' => 'Tägliche Downloads',
    'marketplace.package.version' => 'Version',
    'marketplace.package.homepage' => 'Homepage',
    'marketplace.package.create.date' => 'Paket erstellt',
    'marketplace.package.maintainers' => 'Paket Betreuer',
    'marketplace.package.license' => 'Lizenz',
    'marketplace.package.issue.tracker' => 'Thema Tracker',
    'marketplace.package.wiki' => 'Dokumentation',
    'marketplace.package.version.release.date' => 'Freigabedatum',
    'marketplace.package.required.packages' => 'Benötigte Pakete',
    'marketplace.package.keywords' => 'Keywords',
    'marketplace.other.packages' => 'Weitere Pakete von %name%',
    'marketplace.package.repository' => 'Ablage',
    'marketplace.package.cli.install' => 'Installation über die CLI',
    'marketplace.package.cli.install.descr' => 'Es wird empfohlen, ein Plugin über die Befehlszeilenschnittstelle zu installieren. Um dieses Plugin zu installieren, führe diesen Befehl aus: <code>bin/console mautic:marketplace:install %vendor%/%package%</code>',
    'marketplace.package.latest.stable.version' => 'Aktuelle stabile Version',
    'marketplace.package.all.versions' => 'Alle Versionen',
    'marketplace.package.github.info' => 'GitHub Info',
    'marketplace.package.packagist.info' => 'Info Paket-Ersteller',
    'marketplace.package.install' => 'Installieren',
    'marketplace.package.remove' => 'Entfernen',
    'marketplace.package.install.failed' => 'Die Installation des Pakets ist fehlgeschlagen. Weitere Einzelheiten sind in den Protokollen von Mautic zu finden.',
    'marketplace.package.install.already.installed' => 'Dieses Paket ist bereits auf dem System installiert.',
    'marketplace.package.install.html.failed' => 'Bei der Installation von <strong>%packagename%</strong> ist ein Fehler aufgetreten. Dies ist der Fehler:',
    'marketplace.package.install.html.in.progress' => '<strong>%packagename%</strong> wird installiert. Dies kann eine Weile dauern ...',
    'marketplace.package.install.html.success' => '<strong>%packagename%</strong> erfolgreich installiert!',
    'marketplace.package.install.html.success.continue' => 'Gehen Sie zur Plugin-Seite, um das Plugin zu aktivieren',
    'marketplace.package.request.details.missing' => 'Der Paketanbieter oder Name wurde nicht angegeben. Bitte versuche es erneut.',
    'marketplace.package.cache.clear.failed' => 'Die Plug-In-Liste konnte nicht aktualisiert werden. Bitte einen Entwickler, die Serverberechtigungen zu überprüfen, und versuche es erneut.',
    'marketplace.package.remove.not.installed' => 'Das ausgewählte Paket ist derzeit nicht installiert und kann daher nicht entfernt werden. Bitte versuche es erneut mit einem anderen Paketnamen.',
    'marketplace.package.remove.failed' => 'Das Entfernen des Pakets ist fehlgeschlagen. Weitere Einzelheiten sind in den Protokollen von Mautic zu finden.',
    'marketplace.package.remove.html.failed' => 'Beim Entfernen von <strong>%packagename%</strong> ist ein Fehler aufgetreten. Dies ist der Fehler:',
    'marketplace.package.remove.html.in.progress' => '<strong>%packagename%</strong> wird entfernt. Dies kann eine Weile dauern ...',
    'marketplace.package.remove.html.success' => '<strong>%packagename%</strong> erfolgreich entfernt!',
    'marketplace.package.remove.html.success.continue' => 'Zurück zur Marktplatzübersicht',
    'marketplace.latest.version.missing' => 'Keine Version dieses Pakets konnte gefunden werden. Bitte versuche es später erneut.',
    'marketplace.noresults.tip' => 'Für diese Version von Mautic sind keine Pakete verfügbar. Versuche, auf eine neuere Version zu aktualisieren.',
    'marketplace.clear.cache' => 'Plugin-Liste aktualisieren',
    'marketplace.clear.cache.tooltip' => 'Wir speichern einige Daten, damit der Marktplatz schneller geladen wird. Klicke hier, um diese gespeicherten Daten zu aktualisieren.',
    'marketplace.package.details.close' => 'Zurück zur Marktplatz',
    'mautic.form.tab.forms' => 'Formulare',
    'mautic.form.tab.forms.label' => 'Diese Formulare im Kontakt Tab anzeigen',
    'mautic.form.tab.add' => 'Neues Formular zu Kontakt %contactEmail% hinzufügen',
    'mautic.form.tab.edit' => 'Formulareintrag %formName% für Kontakt %contactEmail% bearbeiten',
    'mautic.form.tab.edit.simple' => 'Formulareintrag bearbeiten',
    'mautic.form.tab.update.contact' => 'Kontakt aktualisieren',
    'mautic.form.tab.add_to_campaigns' => 'Zu den mit dem Formular verknüpften Kampagnen hinzufügen',
    'mautic.form.tab.trigger_actions' => 'Mit Formular verknüpfte Aktionen triggern',
    'mautic.campaign.form.complex.condition' => 'Komplexe Bedingung',
    'mautic.integration.outlook.secret' => 'Outlook Add-In Secret',
    'mautic.plugin.outlook.url' => 'Verwenden Sie als Mautic-URL im Dialogfeld "Outlook-Add-In-Optionen" Folgendes:',
    'mautic.plugin.outlook.public_info' => '<strong>Warnung!</strong> Dies muss eine öffentlich zugängliche URL sein, damit das Add-In funktioniert.',
    'mautic.addon.actions' => 'Zusatzmodul-Aktionen',
    'mautic.addon.actions.push_lead' => 'Lead zur Integration weitergeben',
    'mautic.addon.actions.tooltip' => 'Lead zur ausgewählten Integration weitergeben.',
    'mautic.addon.addons' => 'Addons',
    'mautic.addon.help.searchcommands' => '<strong>Suchbefehle</strong><br />is:published<br />is:unpublished',
    'mautic.addon.integration.tab.details' => 'Aktiviert/Auth',
    'mautic.addon.integration.tab.features' => 'Features',
    'mautic.addon.integration.tab.fieldmapping' => 'Zuordnung der Lead-Felder',
    'mautic.addon.manage.addons' => 'Addons verwalten',
    'mautic.addon.manage.integrations' => 'Integrationen verwalten',
    'mautic.addon.permissions.addons' => 'Addons - auf die der User Zugriff hat',
    'mautic.addon.permissions.header' => 'Berechtigungen für Zusatzmodule',
    'mautic.addon.point.action' => 'Addon Trigger',
    'mautic.addon.reload.addons' => 'Zusatzmodule installieren/aktualisieren',
    'mautic.addon.reload.addons.tooltip' => 'Laden Sie das Zusatzmodul per FTP oder ein anderes Protokoll in das Verzeichnis für Zusatzmodule und klicken Sie den Button zum installieren/aktualisieren.',
    'mautic.integration.callbackuri' => 'Benutzen Sie bei der Einrichtung Ihrer Applikation bei Bedarf die folgende Callback-URL (bzw. Return-URI):',
    'mautic.integration.closewindow' => 'Fenster schließen',
    'mautic.integration.error.refreshtoken_expired' => 'Der Refresh Token ist abgelaufen, eine Neuautorisierung ist erforderlich.',
    'mautic.integration.filter.all' => 'Alle Plugins anzeigen',
    'mautic.integration.form.authorize' => 'App autorisieren',
    'mautic.integration.form.enabled' => 'aktiviert?',
    'mautic.integration.form.feature.public_activity' => 'öffentliche Aktivität anzeigen',
    'mautic.integration.form.feature.public_profile' => 'Öffentliches Profil anzeigen und Profil für die Verknüpfung der Kontakt-Felder aktivieren',
    'mautic.integration.form.feature.push_lead' => 'Ausgelöste Aktion gibt Kontakt an Integration weiter',
    'mautic.integration.form.feature.settings' => 'spezielle Einstellungen  für Funktionen',
    'mautic.integration.form.feature.share_button' => 'Share Button im Landing Page Widget anzeigen',
    'mautic.integration.form.features' => 'aktivierte Funktionen',
    'mautic.integration.form.field_match_notes' => 'Wenn die Werte für das Mautic-Objekt leer sind, wird der Wert \'Unknown\' gesendet. Wenn das Integrationsfeld eine Auswahlliste ist, stellen Sie sicher, dass die Listenwerte des Mautic-Felds mit denen der Integration übereinstimmen.',
    'mautic.integration.form.lead.unknown' => 'Unbekannt',
    'mautic.integration.form.profile' => 'Öffentliches Profil',
    'mautic.integration.form.reauthorize' => 'App erneut aurhorizieren',
    'mautic.integration.form.savefirst' => 'Es fehlen die erforderliche Schlüssel zu Authentisierung. Bitte geben Sie die Schlüssel erneut ein.',
    'mautic.integration.form.sharebutton' => 'Share Buttons',
    'mautic.integration.integrations' => 'Integrationen',
    'mautic.integration.integration' => 'Integration',
    'mautic.integration.integration.tooltip' => 'Wählen Sie die zu verwendenden Integrationen aus.',
    'mautic.integration.keyfield.api' => 'API-Schlüssel',
    'mautic.integration.keyfield.appid' => 'App-ID',
    'mautic.integration.keyfield.appsecret' => 'App-Secret',
    'mautic.integration.keyfield.clientid' => 'Client-ID',
    'mautic.integration.keyfield.clientsecret' => 'Client-Secret',
    'mautic.integration.keyfield.consumerid' => 'Consumer-ID',
    'mautic.integration.keyfield.consumersecret' => 'Consumer Secret',
    'mautic.integration.leadfield_matches' => 'Verfügbare Felder der Integration mit Kontakt-Feldern verknüpfen.',
    'mautic.integration.missingkeys' => 'Für diese Transaktion fehlen die Schlüssel. Bitte kontrollieren Sie Ihre Einstellungen und versuchen Sie es nochmal.',
    'mautic.integration.noresults.tip' => 'Integrationen nicht sichtbar? Aktivieren Sie die Integration mit dem Addon-Manager! Zum Beispiel müssen Sie das Social Media Addon aktivieren, um Facebook in der Liste zu sehen.',
    'mautic.integration.oauth.popupblocked' => 'Es sieht so aus, als ob Ihr Browser Popups verhindert. Bitte lassen Sie Popups für diese Webseite zu.',
    'mautic.integrations.noresults' => '',
    'mautic.integration.app.authorize' => 'App autorisieren ',
    'mautic.integration.app.reauthorize' => 'App re-autorisieren',
    'mautic.integration.message' => 'Nachricht',
    'mautic.integration.not_configured' => 'Die Einbindung ist nicht konfiguriert. ',
    'mautic.integration.object' => 'Objekt',
    'mautic.integration.object_id' => 'Objekt ID',
    'mautic.integration.last_sync_date' => 'Letztes Sync-Datum',
    'mautic.integration.sync_objects' => 'Objekte für die Synchronisierung mit Mautic markieren ',
    'mautic.integration.sync.update_blanks' => 'Sollen Werte, die nicht leer sind, mit Leerzeichen aus dem gegenüberliegenden System überschrieben werden?',
    'mautic.integration.feature.sync' => 'Sync-Objekte zwischen Mautic und dieser Integration',
    'mautic.integration.feature.push_activity' => 'Mautic-Aktivität zu dieser Integration pushen',
    'mautic.integration.feature.push_activity.included_events' => 'Zu berücksichtigende Events bei Push-Vorgang',
    'mautic.integration.feature.push_activity.included_events.tooltip' => 'Mautic-Ereignisse auswählen, die als Aktivität an die Integration gesendet werden sollen.',
    'mautic.integration.features' => 'Welche Features dieser Integration sollen aktiviert werden?',
    'mautic.integration.sync_field_mapping' => '%object% Feld-Zuordung',
    'mautic.integration.sync_direction_integration' => 'Nur zur Integration synchronisieren',
    'mautic.integration.sync_direction_mautic' => 'Nur zu Mautic synchronisieren',
    'mautic.integration.sync_direction_bidirectional' => 'auf beide Wege synchronisieren',
    'mautic.integration.sync_mautic_field' => 'Mautic-Feld wählen...',
    'mautic.integration.sync_filter_fields' => 'Integrations-Felder filtern',
    'mautic.integration.oauth1a.consumer.key' => 'Consumer Key',
    'mautic.integration.oauth1a.consumer.secret' => 'Consumer Secret',
    'mautic.integration.oauth1a.token' => 'Token',
    'mautic.integration.oauth1a.token.secret' => 'Token Geheimnis',
    'mautic.integration.sync.channel_dnc' => 'Nicht kontaktieren - %channel%',
    'mautic.integration.sync.contact_timeline' => 'Kontakt Timeline URL',
    'mautic.integration.sync.event' => '%integration%: %message%',
    'mautic.integration.sync.user_notification.header' => 'Auf Probleme gestoßen bei Synchronisation mit %integration% %object% object',
    'mautic.integration.sync.user_notification.count_message' => '%count% Objekte konnten nicht synchronisiert werden. Möglicherweise muß die Konfiguration der Integration validiert werden.',
    'mautic.integration.sync.user_notification.contact' => 'Folgende Kontakt-Felder konnten nicht synchronisiert werden. Timelines für mehr Details prüfen. %contacts%',
    'mautic.integration.sync.user_notification.sync_error' => '%name% konnte nicht mit Nachricht synchronisert werden, &quot;%message%&quot;',
    'mautic.integration.sync.timeline_notices' => 'Hinweis zur Integration der Synchronisierung',
    'mautic.campaign.notification.send_notification' => 'Benachrichtigung senden',
    'mautic.channel.mobile_notification' => 'Mobile Push Benachrichtigung',
    'mautic.notification.notification' => 'Web-Benachrichtigung',
    'mautic.notification.notifications' => 'Web-Benachrichtigungen',
    'mautic.notification.campaign.send_notification' => 'Web-Benachrichtigung senden',
    'mautic.notification.campaign.send_notification.tooltip' => 'Sendet eine Web-Benachrichtigung an den Kontakt.',
    'mautic.notification.mobile_notification' => 'Mobile Benachrichtigung',
    'mautic.notification.mobile_notifications' => 'Mobile Benachrichtigungen',
    'mautic.notification.campaign.send_mobile_notification' => 'Sende mobile Benachrichtigung',
    'mautic.notification.campaign.send_mobile_notification.tooltip' => 'Sendet eine mobile Benachrichtigung an den Kontakt, wenn Push-Benachrichtigungen in der App auf dem mobilen Endgerät aktiviert sind.',
    'mautic.notification.tab.ios' => 'iOS',
    'mautic.notification.tab.android' => 'Android',
    'mautic.notification.tab.data' => 'Weitere Daten',
    'mautic.notification.tab.mobile' => 'Mobile Einstellungen',
    'mautic.integration.form.feature.mobile' => 'Mobile App Benachrichtigungen',
    'mautic.integration.form.feature.landing_page_enabled' => 'Aktiviert auf Landing Pages?',
    'mautic.integration.form.features.landing_page_enabled.tooltip' => 'OneSignal auf ihren Mautic Landing Pages aktivieren?',
    'mautic.integration.form.feature.tracking_page_enabled' => 'Auf getrackten Seiten aktivieren?',
    'mautic.integration.form.features.tracking_page_enabled.tooltip' => 'OneSignal auf Webseiten aktivieren, die mtc.js aus dieser Mautic Installation eingebettet haben?',
    'mautic.integration.form.feature.welcome_notification_enabled' => 'Willkommensnachricht',
    'mautic.integration.form.platforms' => 'Unterstützte Plattformen für Mobile Push',
    'mautic.integration.form.platforms.tooltip' => 'Plattformen auswählen, die die OneSignal-Konfiguration unterstützen. Nur Plattformen auswählen, für die eine App vorhanden ist und die OneSignal SDK integriert haben.',
    'mautic.integration.form.platforms.ios' => 'iOS',
    'mautic.integration.form.platforms.android' => 'Android',
    'mautic.integration.form.platforms.error' => 'Wenn mobile Benachrichtigungen aktiviert sind, muss mindestens eine Plattform ausgewählt werden.',
    'mautic.notification.form.mobile.url' => 'URL',
    'mautic.notification.form.mobile.url.tooltip' => 'Öffnet eine URL wenn die Benachrichtigung angeklickt wird',
    'mautic.notification.form.mobile.heading' => 'Titel',
    'mautic.notification.form.mobile.ios_subtitle' => 'Nachrichten-Untertitel',
    'mautic.notification.form.mobile.ios_subtitle.tooltip' => 'Diese Funktion steht nur in iOS 10 zur Verfügung',
    'mautic.notification.form.mobile.ios_sound' => 'Ton',
    'mautic.notification.form.mobile.ios_sound.tooltip' => 'Die Sound-Datei wird abgespielt, wenn die Benachrichtigung vom Gerät empfangen wird. Lassen Sie das Feld leer, um den Standard-Sound zu verwenden, oder geben Sie den Namen einer Sound-Datei in Ihrem App-Bundle ein.',
    'mautic.notification.form.mobile.ios_badges' => 'Badges',
    'mautic.notification.form.mobile.ios_badges.tooltip' => 'Eine kleine Zahl auf dem App-Symbol auf dem Startbildschirm gibt an, wie viele Benachrichtigungen für Ihre App eingegangen sind. Wird gelöscht, wenn die App geöffnet wird.',
    'mautic.notification.form.mobile.ios_badges.placeholder' => 'Nicht festsetzen oder verändern',
    'mautic.notification.form.mobile.ios_badges.set' => 'Setzen auf',
    'mautic.notification.form.mobile.ios_badges.increment' => 'Erhöhen um',
    'mautic.notification.form.mobile.ios_badgecount' => 'Badge Anzahl',
    'mautic.notification.form.mobile.ios_badgecount.tooltip' => 'Dadurch wird die Anzahl der Badges abhängig von Ihrer vorherigen Auswahl festgelegt oder erhöht.',
    'mautic.notification.form.mobile.ios_contentavailable' => 'Inhalt verfügbar',
    'mautic.notification.form.mobile.ios_contentavailable.tooltip' => 'Nur für ursprüngliche iOS-Apps. Weckt die App auf, wenn die Benachrichtigung eingeht, sodass Sie im Hintergrund arbeiten können. Weitere Informationen finden Sie in der "content-available"-Dokumentation von Apple.',
    'mautic.notification.form.mobile.ios_media' => 'Medien',
    'mautic.notification.form.mobile.ios_media.tooltip' => 'Rich Media-Anhang. Bild, Ton oder Video zur Anzeige, wenn 3D die Benachrichtigung berührt. OneSignal iOS 2.1.1 SDK oder neuer erforderlich.',
    'mautic.notification.form.mobile.ios_mutablecontent' => 'Veränderbare Inhalte',
    'mautic.notification.form.mobile.ios_mutablecontent.tooltip' => 'Ursprünglicher Code, der auf iOS 10+ ausgeführt wird. Ermöglicht das Ändern der Benachrichtigung in Ihrer App, bevor sie angezeigt wird. Weitere Informationen finden Sie in der "mutable-content"-Dokumentation von Apple.',
    'mautic.notification.form.mobile.android_sound' => 'Ton',
    'mautic.notification.form.mobile.android_small_icon' => 'Kleines Symbol',
    'mautic.notification.form.mobile.android_large_icon' => 'Großes Symbol',
    'mautic.notification.form.mobile.android_group_key' => 'Gruppenschlüssel',
    'mautic.notification.form.mobile.android_lockscreen_visibility' => 'Sichtbarkeit bei gesperrtem Bildschirm',
    'mautic.notification.form.mobile.android_lockscreen_visibility.placeholder' => 'Öffentlich',
    'mautic.notification.form.mobile.android_lockscreen_visibility.private' => 'Privat',
    'mautic.notification.form.mobile.android_lockscreen_visibility.secret' => 'Geheim',
    'mautic.notification.form.mobile.android_big_picture' => 'Big Picture',
    'mautic.notification.form.mobile.android_led_color' => 'LED Farbe',
    'mautic.notification.form.mobile.android_accent_color' => 'Akzentfarbe',
    'mautic.notification.form.mobile.android_sound.tooltip' => 'Der Ton wird abgespielt, wenn die Benachrichtigung vom Device empfangen wird.',
    'mautic.notification.form.mobile.android_small_icon.tooltip' => 'Das Symbol wird in der Statusleiste angezeigt. Wird auch links neben dem Benachrichtigungstext angezeigt, es sei denn, ein großes Symbol ist gesetzt.',
    'mautic.notification.form.mobile.android_large_icon.tooltip' => 'Erfordert Android 3.0 oder höher. Das Symbol wird am linken Rand des Benachrichtigungstextes angezeigt.',
    'mautic.notification.form.mobile.android_group_key.tooltip' => 'Benachrichtigungen mit demselben Group Key werden als eine einzige zusammenfassende Benachrichtigung mit der Anzahl ungeöffneter Benachrichtigungen zusammengestellt.',
    'mautic.notification.form.mobile.android_lockscreen_visibility.tooltip' => 'Gilt nur für Apps, die auf Android API Level 21 oder höher ausgerichtet sind und auf Devices die ab Android 5.0 ausgeführt werden.',
    'mautic.notification.form.mobile.android_big_picture.tooltip' => 'Erfordert Android 4.1+ Wird in einer erweiterbaren Ansicht unter dem Benachrichtigungstext angezeigt.',
    'mautic.notification.form.mobile.android_led_color.tooltip' => 'Legt die LED-Benachrichtigungslampe des Device fest, wenn das Device über eine verfügt. Verwendet den ARGB-Hex-Wert. Der angezeigte Platzhaltertext ist blau.',
    'mautic.notification.form.mobile.android_accent_color.tooltip' => 'Legt die Kreisfarbe um das kleine Symbol fest, das links vom Benachrichtigungstext angezeigt wird. Verwendet den ARGB-Hex-Wert. Der Platzhaltertext wird rot angezeigt. Gilt nur für Apps, die auf Android API Level 21 oder höher ausgerichtet sind und auf Geräten ab Android 5.0.',
    'mautic.config.tab.notificationconfig' => 'Web-Benachrichtigung Einstellungen',
    'mautic.notification.config.form.notification.enabled' => 'Web-Benachrichtigungen aktiviert?',
    'mautic.notification.config.form.notification.enabled.tooltip' => 'Unterstützung für Web-Benachrichtigungen in Ihren Kampagnen aktivieren?',
    'mautic.notification.config.form.notification.landingpage.enabled' => 'Aktiviert auf Mautic Landing Pages?',
    'mautic.notification.config.form.notification.landingpage.enabled.tooltip' => 'Web Benachrichtigungen auf Landing Pages aktivieren?',
    'mautic.notification.config.form.notification.trackingpage.enabled' => 'Aktiviert auf getrackten Seiten?',
    'mautic.notification.config.form.notification.trackinggpage.enabled.tooltip' => 'Web Benachrichtigungen auf getrackten Seiten aktivieren?',
    'mautic.notification.config.form.notification.welcome.enabled' => 'Willkommensnachricht',
    'mautic.notification.config.form.notification.welcome.enabled.tooltip' => 'Willkommensnachricht nach Registrierung aktivieren',
    'mautic.notification.config.form.notification.app_id' => 'One Signal App ID',
    'mautic.notification.config.form.notification.app_id.tooltip' => 'One Signal App ID',
    'mautic.notification.config.form.notification.rest_api_key' => 'One Signal Rest API Key',
    'mautic.notification.config.form.notification.rest_api_key.tooltip' => 'One Signal Rest API Key',
    'mautic.notification.config.form.notification.gcm_sender_id' => 'Shared Key für Push Benachrichtigungen',
    'mautic.notification.config.form.notification.gcm_sender_id.tooltip' => 'gcm_sender_id key - nicht verändern',
    'mautic.notification.config.form.notification.subdomain_name' => 'Subdomain von onesignal.com',
    'mautic.notification.config.form.notification.subdomain_name.tooltip' => 'Nur auf nicht-https Seiten.',
    'mautic.notification.config.form.notification.notification_safari_web_id' => 'Web-Benachrichtigungen Provider Safari Web ID',
    'mautic.notification.config.form.notification.notification_safari_web_id.tooltip' => 'One Signal Safari Web ID für Ihre One Signal App',
    'mautic.notification.config.form.notification.icon' => 'Web-Benachrichtigung Icon',
    'mautic.notification.config.form.notification.icon.tooltip' => 'Das Icon, das auf der linken Seite Ihrer Web-Benachrichtigungen angezeigt wird.',
    'mautic.notification.form.action.sendnotification.admin' => 'Provider Safari Web ID ',
    'mautic.notification.form.action.sendnotification.admin.descr' => 'Sendet die Web-Benachrichtigung an die ausgewählten Nutzer, nachdem das Formular abgeschickt wurde.',
    'mautic.notification.form.action.sendnotification.lead' => 'Web Benachrichtigung an Kontakt senden',
    'mautic.notification.form.action.sendnotification.lead.descr' => 'Senden Sie die vom Web ausgewählte Benachrichtigung beim Senden des Formulars an den Kontakt.',
    'mautic.notification.form.body' => 'Body',
    'mautic.notification.form.confirmbatchdelete' => 'Die ausgewählten Web-Benachrichtigungen löschen?',
    'mautic.notification.form.confirmdelete' => 'Web-Benachrichtigung %name% löschen?',
    'mautic.notification.form.confirmsend' => 'Queue, %name%, senden?',
    'mautic.notification.form.internal.name' => 'Name',
    'mautic.notification.form.list' => 'Kontaktliste',
    'mautic.notification.header.edit' => 'Web-Benachrichtigung bearbeiten',
    'mautic.notification.header.new' => 'Neue Web-Benachrichtigung',
    'mautic.notification.mobile.header.edit' => 'Mobile Benachrichtigung bearbeiten',
    'mautic.notification.mobile.header.new' => 'Neue mobile Benachrichtigung',
    'mautic.notification.text' => 'Web-Benachrichtigung Inhalt',
    'mautic.notification.text.tooltip' => 'Der Inhalt für die Web-Benachrichtigung',
    'mautic.notification.headings' => 'Web-Benachrichtigung Titel',
    'mautic.notification.headings.tooltip' => 'Der Titel der Web-Benachrichtigung',
    'mautic.notification.link' => 'Link',
    'mautic.notification.link.placeholder' => 'http://',
    'mautic.notification.link.tooltip' => 'Wohin soll der Nutzer weitergeleitet werden, wenn er auf die Web-Benachrichtigung klickt?',
    'mautic.notification.permissions.mobile_notifications' => 'Mobile Benachrichtigungen, auf die der User zugreifen kann',
    'mautic.notification.permissions.header' => 'Push-Benachrichtigungsberechtigungen',
    'mautic.notification.permissions.notifications' => 'Web-Benachrichtigungen - Der Benutzer hat Zugriff auf',
    'mautic.notification.stats' => 'Statistiken der Benachrichtigung',
    'mautic.notification.stats.report.table' => 'Benachrichtigungen gesendet',
    'mautic.notification.stat.leadcount' => '%count% ausstehend',
    'mautic.notification.stat.readcount' => '%count% gelesen',
    'mautic.notification.stat.sentcount' => '%count% gesendet',
    'mautic.notification.type.header' => 'Welche Art von Benachrichtigung möchten Sie erstellen?',
    'mautic.notification.type.list' => 'Listen Benachrichtigungen',
    'mautic.notification.type.list.header' => 'Neue Listen Benachrichtigung',
    'mautic.notification.type.list.description' => 'Eine Listenbenachrichtigung kann manuell an ausgewählte Kontaktlisten gesendet werden. Nachdem die Benachrichtigung gesendet wurde, kann sie nicht mehr bearbeitet werden. Sie kann jedoch an neue Kontakte gesendet werden, wenn sie den zugehörigen Listen hinzugefügt werden.',
    'mautic.notification.type.template' => 'Vorlagen Benachrichtigungen',
    'mautic.notification.type.template.header' => 'Neue Vorlagen Benachrichtigung',
    'mautic.notification.type.template.description' => 'Eine Benachrichtigungsvorlage wird automatisch von Kampagnen, Formularen, Punktauslösern usw. gesendet. Diese können bearbeitet, jedoch nicht an eine Kontaktliste gesendet werden.',
    'mautic.notification.form.internal.description' => 'Beschreibung',
    'mautic.notification.form.heading' => 'Überschrift',
    'mautic.notification.form.url' => 'Link',
    'mautic.notification.form.url.tooltip' => 'Das Ziel, zu dem der Nutzer geschickt wird, wenn er auf die Benachrichtigung klickt.',
    'mautic.notification.form.button' => 'Action Button Text',
    'mautic.notification.form.button.tooltip' => 'Aktions-Button zur Benachrichtigung hinzufügen (nur Chrome)',
    'mautic.notification.form.message' => 'Nachricht',
    'mautic.notification.send.selectnotifications' => 'Benachrichtigung wählen',
    'mautic.notification.choose.notifications' => 'Wählen Sie die Benachrichtigung, die an den Nutzer gesendet werden soll.',
    'mautic.notification.send.new.notification' => 'Neue Benachrichtigung',
    'mautic.notification.send.edit.notification' => 'Benachrichtigung bearbeiten',
    'mautic.notification.send.preview.notification' => 'Vorschau Benachrichtigung',
    'mautic.notification.preview' => 'Vorschau',
    'mautic.notification.notification.header.preview' => 'Web-Benachrichtigung Vorschau',
    'mautic.notification.timeline.status' => 'Status',
    'mautic.notification.timeline.type' => 'Typ',
    'mautic.notification.timeline.status.delivered' => 'Zugestellt',
    'mautic.notification.timeline.status.failed' => 'Fehlgeschlagen',
    'mautic.notification.config.form.notification.safari_web_id' => 'Safari Web ID',
    'mautic.notification.config.form.notification.safari_web_id.tooltip' => 'Safari Web ID from OneSignal, wenn Sie Apple Push Notifications nutzen möchten',
    'mautic.notification.campaign.failed.not_contactable' => 'Kontakt kann nicht durch Web Benachrichtigungs-Channel kontaktiert werden',
    'mautic.notification.campaign.failed.not_subscribed' => 'Kontakt hat den Web Benachrichtigungs-Channel nicht abonniert',
    'mautic.notification.campaign.failed.missing_entity' => 'Die angegebene Web Benachrichtigung existiert nicht.',
    'mautic.notification.campaign.failed.unpublished' => 'Die angegebene Web Benachrichtigung ist nicht veröffentlicht.',
    'mautic.notification.show.total.sent' => 'Gesamt gesendet',
    'mautic.notification.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (kommagetrennte IDs, ohne Leerstellen)',
    'mautic.notification.campaign.event.notification.has.active' => 'hat aktive Benachrichtigung',
    'mautic.campaign.notification.has.active' => 'hat aktive Benachrichtigung',
    'mautic.notification.campaign.event.notification.has.active.desc' => 'Überprüfen, ob Kontakt aktive Benachrichtigungen hat',
    'mautic.report.group.mobile_notifications' => 'Mobile Benachrichtigungen',
    'mautic.mobile_notification.stats.report.table' => 'Mobile Benachrichtigung gesendet',
    'mautic.mobile_notification.report.hits_count' => 'Zugriffe',
    'mautic.mobile_notification.report.hits_ratio' => 'Zugriffsrate',
    'mautic.mobile_notification.report.read_count' => 'Anzahl gelesen',
    'mautic.mobile_notification.report.read_ratio' => 'Leserate',
    'mautic.mobile_notification.report.sent_count' => 'Anzahl gesendet',
    'mautic.mobile_notifications.report.stat.date_read' => 'Abrufdatum',
    'mautic.mobile_notifications.report.stat.date_sent' => 'Versanddatum',
    'mautic.mobile_notification.report.unique_hits_count' => 'Eindeutige Zugriffe',
    'mautic.mobile_notification.report.unique_ratio' => 'Eindeutige Rate',
    'mautic.notification.mobile_notification.heading' => 'Titel',
    'mautic.notification.mobile_notification.preview' => 'Vorschau Benachrichtigung',
    'mautic.notification.mobile_notification.header.preview' => 'Mobile Benachrichtigung',
    'mautic.mobile_notification.graph.line.stats.read' => 'Lesen',
    'mautic.mobile_notification.graph.line.stats.sent' => 'Gesendet',
    'mautic.mobile_notification.graph.line.stats' => 'Mobile Benachrichtigung gesendet',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.ignored' => 'Ignoriert',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.read' => 'Lesen',
    'mautic.mobile_notification.graph.pie.ignored.read.failed' => 'Ignorierte / Gelesene / Fehlgeschlagene Benachrichtigungen',
    'mautic.notification.actions' => 'Benachrichtigungsaktionen',
    'mautic.notification.actions.mobile_tooltip' => 'Sende die gewählte mobile Benachrichtigung zum Nutzer, wenn ein Formular ausgefüllt wurde und mobile Benachrichtigungen aktiviert wurden.',
    'mautic.notification.actions.send_mobile_notification' => 'Sende mobile Benachrichtigung',
    'mautic.notification.form.subdomain_name.label' => 'Subdomain Name',
    'mautic.campaign.notification.send_mobile_notification' => 'Sende mobile Benachrichtigung',
    'mautic.config.tab.notification_config' => 'Benachrichtigungseinstellungen',
    'mautic.config.tab.campaign_notification_config' => 'Einstellungen für Kampagnenbenachrichtigungen',
    'mautic.config.tab.webhook_notification_config' => 'Webhook-Benachrichtigungseinstellungen',
    'mautic.notification.form.config.send_notification_to_author' => 'Benachrichtigung an Autor/-in senden',
    'mautic.notification.form.config.send_notification_to_author.tooltip' => 'Sende eine Benachrichtigung an die E-Mail-Adressen der Autorin/des Autor oder anderer Benutzer/-innen',
    'mautic.notification.form.config.notification_email_addresses' => 'E-Mail-Adressen zum Empfangen von Benachrichtigungen',
    'mautic.notification.form.config.notification_email_addresses.tooltip' => 'Füge eine durch Kommas getrennte Liste mit E-Mail-Adressen hinzu, um Benachrichtigungen zu erhalten',
    'mautic.dynamicContent.dynamicContent' => 'Dynamischer Inhalt',
    'mautic.dynamicContent.dynamicContents' => 'Dynamischer Inhalt',
    'mautic.dynamicContent.campaign.event.form.dynamicContents' => 'Nur für Seiten',
    'mautic.dynamicContent.campaign.event.form.dynamicContents.descr' => 'Seiten für diesen Auslöser auswählen. Wenn Sie keine Seite auswählen, wird der Auslöser auf alle Seiten angewandt.',
    'mautic.dynamicContent.campaign.event.form.url' => 'URL',
    'mautic.dynamicContent.campaign.event.form.url.descr' => 'Geben Sie die URL der Seite an, wo der Tracking-Pixel installiert ist. Es ist möglich Platzhalter (*) zu nutzen. Beispiel: *product/123* passt zu http://web.com/product/1234.htm. Mehrere URLs mit Komma trennen.',
    'mautic.dynamicContent.campaign.event.dynamicContenthit' => 'Besucht eine Seite',
    'mautic.dynamicContent.campaign.event.dynamicContenthit_descr' => 'Löse Aktionen aus, wenn eine Seite/URL aufgerufen wird.',
    'mautic.dynamicContent.config.form.cat.in.url' => 'Die Kategorie in der Seiten-URL anzeigen?',
    'mautic.dynamicContent.config.form.cat.in.url.tooltip' => 'Wenn ausgewählt, dann wird die Kategorie in der URL angezeigt.',
    'mautic.dynamicContent.config.form.google.analytics' => 'Analyse-Code (z.B. Google Analytics)',
    'mautic.dynamicContent.config.form.google.analytics.tooltip' => 'Fügen Sie das Analyseskript ein, um es automatisch in die Quelle der Zielseiten aufzunehmen.',
    'mautic.dynamicContent.event.hit' => 'Seitenzugriff',
    'mautic.dynamicContent.event.publish.down' => '%dwc% als nicht verfügbar festlegen',
    'mautic.dynamicContent.event.publish.down.description' => 'Der dynamische Inhalt „%dwc%“ wird nicht mehr zur Verfügung stehen.',
    'mautic.dynamicContent.event.publish.up' => '%dwc% als nicht verfügbar festlegen',
    'mautic.dynamicContent.event.publish.up.description' => 'Die Seite „%dwc%“ wird zur Nutzung verfügbar sein.',
    'mautic.dynamicContent.form.internal.name' => 'Interner Name',
    'mautic.dynamicContent.form.confirmbatchdelete' => 'Ausgewählte Objekte löschen? WARNUNG - alle assoziierten Übersetzungen werden auch gelöscht!',
    'mautic.dynamicContent.form.confirmdelete' => 'Löschen Sie das Element mit dynamischem Inhalt, WARNUNG - dadurch werden auch alle zugehörigen Übersetzungen gelöscht!',
    'mautic.dynamicContent.form.content' => 'Inhalt',
    'mautic.dynamicContent.form.content.help' => 'Der Inhalt, der zurückkommt, wenn diese Variante / Standardposition angefordert wird.',
    'mautic.dynamicContent.form.language.help' => 'Übersetzen Sie die Inhalte in mehrere Sprachen und verknüpfen Sie diese miteinander, indem Sie ihnen die gleiche Seite zuordnen. Über Sprachauswahl-Links kann der Besucher auf den entsprechenden Landing Pages dann die gewünschte Sprache auswählen.',
    'mautic.dynamicContent.header.edit' => 'Dynamischen Inhalt editieren - %name%',
    'mautic.dynamicContent.header.new' => 'Neuer dynamischer Inhalt',
    'mautic.dynamicContent.help.searchcommands' => '<strong>Such-Befehle</strong><br />ids:ID1,ID2 (comma separated IDs, no spaces)<br />is:published<br />is:unpublished<br />is:mine<br />is:uncategorized<br />category:{category alias}<br />lang:{lang code}',
    'mautic.dynamicContent.menu.edit' => 'Seite ändern',
    'mautic.dynamicContent.menu.view' => 'Seite anzeigen',
    'mautic.dynamiccontent.permissions.header' => 'Berechtigungen für dynamische Inhalte',
    'mautic.dynamiccontent.permissions.dynamiccontents' => 'Dynamischer Inhalt, auf den der Nutzer Zugriff hat',
    'mautic.dynamicContent.publish.down' => 'Als nicht verfügbar festlegen',
    'mautic.dynamicContent.publish.up' => 'Als verfügbar festlegen',
    'mautic.dynamicContent.report.revision' => 'Revision',
    'mautic.dynamicContent.campaign.send_dwc' => 'Dynamischen Content unterstützen',
    'mautic.dynamicContent.campaign.send_dwc.tooltip' => 'Löst eine Aktion aus, wenn ein Dynamischer Inhalt angefordert wird.',
    'mautic.dynamicContent.send.selectDynamicContents.default' => 'Standardinhalt auswählen',
    'mautic.dynamicContent.send.selectDynamicContents' => 'Dynamischen Inhalt auswählen',
    'mautic.dynamicContent.send.new.dynamicContent' => 'Neuer dynamischer Inhalt',
    'mautic.dynamicContent.send.edit.dynamicContent' => 'Dynamischen Inhalt editieren',
    'mautic.dynamicContent.send.slot_name' => 'Angeforderter Name',
    'mautic.dynamicContent.label.slot_name' => 'Slot Name',
    'mautic.dynamicContent.send.slot_name.tooltip' => 'Der Name des Slots, welcher der Kontakt anfragt.',
    'mautic.dynamicContent.choose.dynamicContents' => 'Wählen Sie den dynamischen Standardinhalt aus, der angezeigt werden soll.',
    'mautic.dynamicContent.campaign.decision_dwc' => 'Dynamischen Inhalt anfordern',
    'mautic.dynamicContent.campaign.decision_dwc.tooltip' => 'Dies ist die oberste Ebene für eine Anforderung dynamischer Inhalte.',
    'mautic.dynamicContent.error.notfound' => 'Dynamischer Inhalt %id% nicht gefunden.',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% Dynamischer Inhalt wurde gelöscht.',
    'mautic.dwc.form.confirmbatchdelete' => 'Stapellöschung bestätigen',
    'mautic.dwc.form.is_campaign_based' => 'Ist es kampagnen-basiert?',
    'mautic.dwc.form.is_campaign_based.tooltip' => 'Wählen Sie aus, ob der Inhalt basierend auf Kampagnenbedingungen oder Filtern angezeigt wird',
    'mautic.campaign.dwc.decision' => 'Dynamischen Inhalt anfordern',
    'mautic.campaign.dwc.push_content' => 'Dynamischen Content unterstützen',
    'mautic.dynamic.content.triggered' => 'Ausgelöst durch Dynamischen Inhalt',
    'mautic.dynamicContent.views' => 'Aufrufe',
    'mautic.dynamicContent.show.total.views' => 'Gesamtaufrufe',
    'mautic.dynamicContent.show.unique.views' => 'Eindeutige Aufrufe',
    'mautic.dynamicContent.timeline.content' => 'Inhalt',
    'mautic.dynamicContent.timeline.title' => 'Lese Dynamischen Inhalt',
    'mautic.dynamicContent.token.slot' => 'Dynamischer Web Inhalt',
    'mautic.dynamicContent.slot.campaign' => 'Ist kampagnen-basiert',
    'mautic.core.icon_tooltip.is_filter_based' => 'Ist ein auf Filtern basierender dynamischer Webinhalt',
    'mautic.dynamicContent.header.is_filter_based' => 'Ist ein auf Filtern basierender dynamischer Webinhalt für:',
    'mautic.point.point' => 'Punkt',
    'mautic.point.action.delta' => 'Punkte ändern (+/-)',
    'mautic.point.action.delta.help' => 'Legen Sie fest, wie viele Punkte für diese Aktion hinzugefügt oder abgezogen werden. Bei einer positiven Zahl werden dem Kontakt Punkte hinzugefügt. Wenn die Zahl negativ ist, werden Punkte abgezogen.',
    'mautic.point.action.noresults.tip' => 'Nutzen Sie Punkte-Aktionen, um den Punktestand eines Kontakts bei definierten Ereignissen anzupassen. Geben Sie einem Kontakt z.B. 10 Punkte, wenn er/sie die E-Mail einer Kampagne öffnet.',
    'mautic.point.actions.header.index' => 'Punktaktionen',
    'mautic.point.event.gained' => 'Punkt gewonnen',
    'mautic.point.event.manual_change' => 'Manuelle Änderung',
    'mautic.point.form.score_not_set' => 'Punktzahl nicht festgelegt',
    'mautic.point.form.no_point_groups' => 'Es sind keine Punktegruppen verfügbar.',
    'mautic.point.form.addaction' => 'Verwenden Sie die Liste rechts um Aktionen hinzuzufügen',
    'mautic.point.form.confirmbatchdelete' => 'Die ausgewählten Punkte Aktionen löschen?',
    'mautic.point.form.confirmdelete' => 'Die Punkte-Aktion %name% löschen?',
    'mautic.point.form.repeat' => 'mehrfach ausführbar',
    'mautic.point.form.type' => 'Vom Kontakt ausgeführte Aktionen',
    'mautic.point.form.repeat.help' => 'Aktiviere diese Option, um Leads für diese Aktion mehrfach zu bewerten. Deaktiviere sie für eine einmalige Bewertung.',
    'mautic.point.menu.edit' => 'Punkte-Aktion ändern',
    'mautic.point.menu.index' => 'Aktionen verwalten',
    'mautic.point.menu.new' => 'Neue Punkte-Aktion',
    'mautic.point.permissions.header' => 'Berechtigung für Punkte',
    'mautic.point.permissions.points' => 'Punkte-Aktionen - zu denen der Benutzer Zugriff hat',
    'mautic.point.permissions.triggers' => 'Triggers - zu denen der User Zugriff hat',
    'mautic.point.permissions.groups' => 'Gruppen - Der Benutzer hat Zugriff auf',
    'mautic.point.thead.action' => 'Aktion',
    'mautic.point.thead.delta' => 'Punkte +/-',
    'mautic.point.thead.group' => 'Gruppe',
    'mautic.point.trigger.addevent' => 'Ein Ereignis von der \'Ereignis hinzufügen\' Liste auswählen.',
    'mautic.point.trigger.event.add' => 'Ereignis hinzufügen',
    'mautic.point.trigger.form.color' => 'Kontakt-Farbe',
    'mautic.point.trigger.form.color_descr' => 'Kontakten mit mindestens der oben genannten Punktzahl wird diese Farbe zugeordnet.',
    'mautic.point.trigger.form.confirmbatchdelete' => 'Das ausgewählte Trigger-Ereignis ändern?',
    'mautic.point.trigger.form.confirmdelete' => 'Den Trigger %name% löschen?',
    'mautic.point.trigger.form.existingleads' => 'Nach dem Speichern auf bestehende Kontakte anwenden (wenn veröffentlicht)?',
    'mautic.point.trigger.form.modalheader' => 'Trigger-Aktion Details',
    'mautic.point.trigger.form.points' => 'Minimum Anzahl Punkte',
    'mautic.point.trigger.form.points_descr' => 'Mindestanzahl Punkte erforderlich um die assoziierte Aktion zu triggern',
    'mautic.point.trigger.header.edit' => 'Trigger ändern',
    'mautic.point.trigger.header.index' => 'Punkte-Trigger',
    'mautic.point.trigger.header.new' => 'Neuer Trigger',
    'mautic.point.trigger.menu.edit' => 'Trigger-Ereignis ändern',
    'mautic.point.trigger.menu.index' => 'Trigger verwalten',
    'mautic.point.trigger.noresults.tip' => 'Erstellen Sie einen Trigger, der eine Aktion auslöst, wenn der Kontakt eine bestimmte Punktanzahl erreicht. Sie können z.B. eine Kampagne anpassen, den Kontakt dem CRM übergeben, eine E-Mail versenden usw. Legen Sie eine Farbe fest, um beim Ansehen von Kontaktlisten einen schnellen Überblick zu haben!',
    'mautic.point.trigger.tab.events' => 'Ereignisse',
    'mautic.point.trigger.thead.points' => 'Punkte gesamt',
    'mautic.point.trigger.thead.pointstrigger' => 'Trigger auf Punkte',
    'mautic.point.group.menu.index' => 'Gruppen verwalten',
    'mautic.point.group.menu.new' => 'Neue Gruppe',
    'mautic.point.group.menu.edit' => 'Gruppe bearbeiten',
    'mautic.point.group.header.index' => 'Punktegruppen',
    'mautic.point.group.form.group' => 'Punktegruppe',
    'mautic.point.group.form.group_descr' => 'Wählen Sie die Punktgruppe aus, für die dies gilt. Wenn keine Gruppen ausgewählt sind, gilt dies für die Hauptkontaktpunkte.',
    'mautic.point.group.form.nogroup' => 'Keine',
    'mautic.point.group.form.confirmdelete' => 'Die Punktgruppe %name% löschen?',
    'mautic.points.menu.root' => 'Punkte',
    'mautic.point.dashboard.widgets' => 'Punkte-Widgets',
    'mautic.widget.points.in.time' => 'Punkte im Zeitverlauf',
    'mautic.point.changes' => 'Punkte-Änderungen',
    'mautic.point.group.report.table' => 'Gruppenpunkte',
    'mautic.point.report.group_id' => 'Gruppen ID',
    'mautic.point.report.group_name' => 'Gruppenname',
    'mautic.point.report.group_score' => 'Gruppenpunkte',
    'mautic.campaign.email.open' => 'E-Mail wurde geöffnet',
    'mautic.campaign.email.click' => 'E-Mail angeklickt',
    'mautic.campaign.email.send' => 'E-Mail senden oder planen',
    'mautic.campaign.email.reply' => 'auf E-Mail geantwortet',
    'mautic.campaign.email.validate.address' => 'Gültige E-Mail Adresse',
    'mautic.config.tab.emailconfig' => 'E-Mail Einstellungen',
    'mautic.email.abtest.criteria.clickthrough' => 'Clickthrough Rate',
    'mautic.email.abtest.criteria.open' => 'Leserate',
    'mautic.email.abtest.label.clickthrough' => 'Anzahl der Clickthroughs',
    'mautic.email.abtest.label.opened' => 'Anzahl gelesen',
    'mautic.email.abtest.label.sent' => 'Anzahl gesendet',
    'mautic.email.actions' => 'E-Mail-Aktionen',
    'mautic.email.add_recipient' => 'Empfänger eintragen',
    'mautic.email.address.invalid_format' => '%email% ist ungültig.',
    'mautic.email.address.invalid_characters' => '%email% hat für E-Mail Adressen unerlaubte Zeichen.',
    'mautic.email.address.invalid_domain' => '%email% scheint keine gültige E-Mail-Domain zu haben (MX DNS record).',
    'mautic.email.attachments' => 'Anhänge',
    'mautic.email.attachments.help' => 'Anhänge werden als Dateikopie gesendet und können nicht verfolgt werden. Um Downloads zu verfolgen, verwenden Sie den Link im E-Mail-Inhalt.',
    'mautic.email.bcc.tooltip' => 'Richten Sie eine BCC-Adresse ein, um eine Kopie jeder gesendeten E-Mail zu erhalten.',
    'mautic.email.bcc' => 'BCC Adresse',
    'mautic.email.utm_tags' => 'UTM-Tags',
    'mautic.email.utm_tags.tooltip' => 'Generieren Sie benutzerdefinierte Kampagnenparameter für Ihre Werbe-URLs. Fügen Sie den URLs Parameter hinzu, um die Kampagnen zu identifizieren, die auf den Datenverkehr verweisen.',
    'mautic.email.campaign_source' => 'Kampagnen Ursprung',
    'mautic.email.campaign_medium' => 'Kampagnen-Medium',
    'mautic.email.campaign_name' => 'Kampagnen-Name',
    'mautic.email.campaign_content' => 'Kampagnen Inhalt',
    'mautic.email.bounce.reason.antispam' => 'Als Spam blockiert',
    'mautic.email.bounce.reason.autoreply' => 'Automatische Antwort erhalten',
    'mautic.email.bounce.reason.bad_email' => 'Keine korrekte E-Mail Adresse',
    'mautic.email.bounce.reason.command_reject' => 'Server hat die Anfrage abgelehnt',
    'mautic.email.bounce.reason.concurrent' => 'Zu viele gleichzeitige Verbindungen',
    'mautic.email.bounce.reason.content_reject' => 'Inhalt wurde abgelehnt',
    'mautic.email.bounce.reason.defer' => 'Nachricht wurde zurückgestellt',
    'mautic.email.bounce.reason.delayed' => 'Nachricht hat sich verzögert',
    'mautic.email.bounce.reason.dns_loop' => 'Es besteht eine DNS-Schleife',
    'mautic.email.bounce.reason.dns_unknown' => 'Domain ist unbekannt',
    'mautic.email.bounce.reason.full' => 'Posteingang ist voll',
    'mautic.email.bounce.reason.hard_bounce' => 'Hard Bounce',
    'mautic.email.bounce.reason.inactive' => 'Posteingang ist inaktiv',
    'mautic.email.bounce.reason.internal_error' => 'Temporärer Systemfehler',
    'mautic.email.bounce.reason.invalid' => 'E-Mail ist ungültig',
    'mautic.email.bounce.reason.latin_only' => 'Server akzeptiert nur lateinische Schriftzeichen',
    'mautic.email.bounce.reason.other' => 'Zustellung fehlgeschlagen',
    'mautic.email.bounce.reason.outofoffice' => 'Nutzer ist abwesend',
    'mautic.email.bounce.reason.oversize' => 'Nachricht ist zu groß',
    'mautic.email.bounce.reason.rejected' => 'Mail zurückgewiesen',
    'mautic.email.bounce.reason.soft_bounce' => 'Soft Bounce',
    'mautic.email.bounce.reason.spam' => 'Als Spam markiert',
    'mautic.email.bounce.reason.unknown' => 'Unbekannter Nutzer oder Server',
    'mautic.email.bounce.reason.unrecognized' => 'Nicht erkannter Nutzer',
    'mautic.email.bounce.reason.unsubscribed' => 'Kontakt hat sich per E-Mail abgemeldet',
    'mautic.email.bounce.reason.user_reject' => 'Nutzer hat diese E-Mail abgelehnt',
    'mautic.email.bounce.reason.warning' => 'Server hat eine Warnung ausgegeben',
    'mautic.email.complaint.reason.unknown' => 'Unbekannte Beschwerde vom E-Mail-Anbieter',
    'mautic.email.complaint.reason.abuse' => 'Der E-Mail-Dienstleister hat auf unerwünschte E-Mails oder eine andere Art von E-Mail-Missbrauch hingewiesen',
    'mautic.email.complaint.reason.fraud' => 'Der E-Mail-Dienstleister hat auf Betrug oder Phishing-Aktivitäten hingewiesen',
    'mautic.email.complaint.reason.virus' => 'Der E-Mail-Dienstleister meldet, dass ein Virus in der ursprünglichen Nachricht gefunden wurde',
    'mautic.email.contact_already_received_marketing_email' => '%contact% hat diese Marketing-E-Mail bereits erhalten.',
    'mautic.email.contact_has_no_email' => '%contact% hat keine E-Mail Adresse.',
    'mautic.email.contact_has_unsubscribed_from_category' => '%contact% hat die Kategorie %category% abbestellt.',
    'mautic.email.builder.addcontent' => 'Klick um Inhalte hinzuzufügen',
    'mautic.email.builder.index' => 'Extras',
    'mautic.email.campaign.event.open' => 'Öffnet die E-Mail',
    'mautic.email.campaign.event.open_descr' => 'Löse Aktionen aus, wenn eine E-Mail geöffnet wird. Verbinden Sie oben mit dieser Entscheidung eine Aktion „E-Mail senden“.',
    'mautic.email.campaign.event.click' => 'Klickt E-Mail',
    'mautic.email.campaign.event.click_descr' => 'Löse Aktionen aus, wenn auf eine E-Mail geklickt wird. Verbinden Sie oben mit dieser Entscheidung eine Aktion „E-Mail senden“.',
    'mautic.email.campaign.event.failure_missing_email' => 'E-Mail nicht gefunden oder veröffentlicht',
    'mautic.email.click.urls.contains' => 'Nur URLs, die enthalten',
    'mautic.email.campaign.event.send' => 'Sende E-Mail',
    'mautic.email.campaign.event.send_descr' => 'Senden Sie die ausgewählte E-Mail an den Kontakt.',
    'mautic.email.campaign.event.send.to.user' => 'Sende eine E-Mail an eine:n Mitarbeiter:in',
    'mautic.email.campaign.event.send.to.user_descr' => 'E-Mail an Benutzer, Besitzer oder andere E-Mail-Adressen senden',
    'mautic.email.campaign.event.validate_address' => 'hat gültige E-Mail Adresse',
    'mautic.email.campaign.event.validate_address_descr' => 'Versuchen Sie, die E-Mail-Adresse des Kontakts zu überprüfen. Dies muss nicht 100% genau sein.',
    'mautic.email.campaignId.filter' => 'Kampagnenfilter',
    'mautic.form.action.send.email.to.owner' => 'Senden Sie eine E-Mail an den Besitzer des Kontakts',
    'mautic.email.choose.emails_descr' => 'Wählen Sie die zu sendende E-Mail aus. Wenn Ihre E-Mail nicht angezeigt wird, wurde sie möglicherweise nicht veröffentlicht oder es handelt sich um eine Segment-E-Mail.',
    'mautic.email.companyId.filter' => 'Unternehmensfilter',
    'mautic.email.config.header.mail' => 'Einstellungen für gesendete E-Mails',
    'mautic.email.config.header.message' => 'Einstellungen für Nachrichten',
    'mautic.email.config.header.monitored_email' => 'Einstellungen für überwachten Posteingang',
    'mautic.email.config.mailer.append.tracking.pixel.tooltip' => 'Aktiviert das automatische Einfügen eines Tracking-Pixels in den E-Mail Body. WARNUNG: Das Deaktivieren dieser Option deaktiviert das Tracking von E-Mail Öffnungsaktionen!',
    'mautic.email.config.mailer.append.tracking.pixel' => 'Tracking-Pixel zum E-Mail Body hinzufügen?',
    'mautic.email.config.mailer.disable.trackable.urls' => 'Deaktivieren Sie nachverfolgbare URLs',
    'mautic.email.config.mailer.disable.trackable.urls.tooltip' => 'Gmail (und GSuite) mögen keine URL-Umleitungen.',
    'mautic.email.config.mailer.minify.html' => 'HTML minimieren',
    'mautic.email.config.mailer.minify.html.tooltip' => 'Durch die Minimierung von HTML können Sie die Leistung beim Versenden von Marketing-E-Mails verbessern, indem Sie die Größe der E-Mail verringern. Allerdings kann es auch zu einer leichten Verzögerung des Sendevorgangs und einer erhöhten CPU-Auslastung beim Absender kommen.',
    'mautic.email.config.mailer.convert.embed.images.tooltip' => 'Aktiviert die automatische Umwandlung von eingebetteten Bildern zu Base64',
    'mautic.email.config.mailer.convert.embed.images' => 'Eingebettete Bilder zu Base64 umwandeln',
    'mautic.email.config.mailer.encryption.tooltip' => 'Die Art der Verschlüsselung des SMTP Servers',
    'mautic.email.config.mailer.encryption' => 'SMTP Verschlüsselung',
    'mautic.email.config.mailer.from.email.tooltip' => 'Geben Sie die from E-Mail an, mit der E-Mails versendet werden sollen',
    'mautic.email.config.mailer.from.email' => 'E-Mail Adresse von der gesendet werden soll',
    'mautic.email.config.mailer.from.name.tooltip' => 'Der from Name der zum Senden von E-Mails verwendet werden soll',
    'mautic.email.config.mailer.from.name' => 'Der Name unter dem die E-Mail versendet werden soll',
    'mautic.email.config.mailer.host.tooltip' => 'Geben Sie hier den SMTP Server an',
    'mautic.email.config.mailer.host' => 'SMTP Server',
    'mautic.email.config.mailer.is.owner.tooltip' => 'Legen Sie die Standardeinstellung „Mailer ist Eigentümer“ für alle neuen E-Mails fest, die erstellt werden',
    'mautic.email.config.mailer.is.owner' => 'Versender ist Inhaber',
    'mautic.email.config.mailer.is.owner.local.warning' => 'Die globale Option „Mailer ist Eigentümer“ ist auf <strong>%value%</strong> eingestellt. Diese Option überschreibt diese globale Option nur für diese E-Mail.',
    'mautic.email.config.mailer.password.tooltip' => 'Passwort für die Authentifizierung beim E-Mail Server',
    'mautic.email.config.mailer.password' => 'Passwort für die Kennung von der E-Mail verschickt wird',
    'mautic.email.config.mailer.port.tooltip' => 'Legen Sie den Port für den Mailserver fest',
    'mautic.email.config.mailer.port' => 'Port',
    'mautic.email.config.mailer.return.path.tooltip' => 'Geben Sie eine benutzerdefinierte Return Path/Bounce E-Mail Adresse für E-Mails an, die vom System versendet werden. Beachten Sie, dass diese Funktion von manchen E-Mail Providern, wie z.B. Gmail, nicht unterstützt wird.',
    'mautic.email.config.mailer.return.path' => 'Benutzerdefinierte Return Path (Bounce) Adresse',
    'mautic.email.config.mailer.transport.test_send.body' => 'Hallo! Das ist eine Test E-Mail von Mautic. Test...Test...1...2...3!',
    'mautic.email.config.mailer.transport.test_send.subject' => 'Mautic Test E-Mail',
    'mautic.email.config.mailer.transport.test_send' => 'Test E-Mail senden',
    'mautic.email.config.mailer.transport.tooltip' => 'Wählen Sie den Dienst aus, der für E-Mails verwendet werden soll. Mautic hat keine Beziehung zu diesen Diensten. Es dient nur der einfachen Konfiguration.',
    'mautic.email.config.mailer.transport' => 'E-Mail Dienst, der Mails versenden soll',
    'mautic.email.config.mailer.user.tooltip' => 'Benutzername für die Authentifizierung beim E-Mail Server',
    'mautic.email.config.mailer.user' => 'Name der Kennung, von der E-Mail verschickt wird',
    'mautic.email.config.mailer_transport.smtp' => 'Anderer SMTP Server',
    'mautic.email.config.monitored_email.not_configured' => 'IMAP Konto ist nicht konfiguriert.',
    'mautic.email.config.monitored_email.bounce_folder.tooltip' => 'Ordner, der für neue Bounces überwacht werden soll. Zum Deaktivieren leer lassen. <strong>HINWEIS</strong>: Gmail überschreibt beim Versand über die SMTP Server die Return-Path Header. Mautic versucht trotzdem, Bounces von neuen Nachrichten zu erkennen, aber eine andere Versandmethode oder ein eindeutiger Posteingang ist am besten.',
    'mautic.email.config.monitored_email.bounce_folder' => 'Bounces',
    'mautic.email.config.monitored_email.general' => 'Standard-Posteingang',
    'mautic.email.config.monitored_email.test_connection' => 'Verbindung testen und Ordner abrufen',
    'mautic.email.config.monitored_email.unsubscribe_folder.tooltip' => 'Ordner, der für Abmeldungen überwacht werden soll. Zum Deaktivieren leer lassen.',
    'mautic.email.config.monitored_email.unsubscribe_folder' => 'Aufforderung zur Abmeldung',
    'mautic.email.config.monitored_email_address.tooltip' => 'Die Adresse für das zu überwachende Konto. Dies wird verwendet, wenn Sie eine Absprungs-, Abbestellungs-, etc.-Adresse generieren, falls zutreffend.',
    'mautic.email.config.monitored_email_address' => 'Überwachte Adresse',
    'mautic.email.config.monitored_email_encryption.ssl_novalidate' => 'SLL mit novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tls_novalidate' => 'TLS mit novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tooltip' => 'Verschlüsselung für die Verbindung zum Server. Manche Server erfordern die no-validate Variante, bei der das SSL Zertifikat des Servers nicht überprüft wird.',
    'mautic.email.config.monitored_email_encryption' => 'Verschlüsselung',
    'mautic.email.config.monitored_email_folder.tooltip' => 'Wählen Sie den Ordner, der überwacht werden soll, oder deaktivieren Sie die Funktion, indem Sie nichts eintragen.',
    'mautic.email.config.monitored_email_folder' => 'Überwachter Ordner',
    'mautic.email.config.monitored_email_host.tooltip' => 'IMAP URL für den E-Mail Provider.',
    'mautic.email.config.monitored_email_host' => 'IMAP Host',
    'mautic.email.config.monitored_email_override_settings.tooltip' => 'Wenn ja, konfigurieren Sie die individuellen Verbindungseinstellungen für diesen Posteingang. Ansonsten nutzt Mautic den Standard-Posteingang.',
    'mautic.email.config.monitored_email_override_settings' => 'Individuelle Verbindungseinstellungen nutzen?',
    'mautic.email.config.monitored_email_password.tooltip' => 'Passwort für den Login in den IMAP Server.',
    'mautic.email.config.monitored_email_password' => 'IMAP Passwort',
    'mautic.email.config.monitored_email_port.tooltip' => 'Port, der zur Verbindung mit dem E-Mail Provider genutzt werden soll.',
    'mautic.email.config.monitored_email_port' => 'Port',
    'mautic.email.config.monitored_email_user.tooltip' => 'Nutzername für den Login in den IMAP Server.',
    'mautic.email.config.monitored_email_user' => 'IMAP Nutzername',
    'mautic.email.config.resubscribe_message.tooltip' => 'Legen Sie den Standard-Text fest, der einem Kontakt nach der erneuten Anmeldung über den Link in der Abmeldungsnachricht angezeigt wird. Setzen Sie den <code>|URL|</code> Platzhalter an die Stelle, wo die URL zur Abmeldung eingefügt werden soll. Die Nutzung von <code>|EMAIL|</code> ist optional.',
    'mautic.email.config.resubscribe_message' => 'Nachricht zur Bestätigung der Wiederanmeldung',
    'mautic.email.config.unsubscribe_message.tooltip' => 'Legen Sie den Standard-Text fest, der einem Kontakt nach der Abmeldung über den Link in einer E-Mail angezeigt wird. Setzen Sie den <code>|URL|</code> Platzhalter an die Stelle, wo die URL zur erneuten Anmeldung eingefügt werden soll. Die Nutzung von <code>|EMAIL|</code> ist optional.',
    'mautic.email.config.unsubscribe_message' => 'Nachricht zur Bestätigung der Abmeldung',
    'mautic.email.config.unsubscribe_text.tooltip' => 'Legen Sie den Standard-Text für den {unsubscribe_token} in E-Mails fest. Setzen Sie den <code>|URL|</code> Platzhalter an die Stelle, wo die URL zur Abmeldung eingefügt werden soll.',
    'mautic.email.config.unsubscribe_text' => 'Text für den {unsubscribe_text} Token',
    'mautic.email.config.webview_text.tooltip' => 'Legen Sie den Standard-Text für den {webview_text} in E-Mails fest. Setzen Sie den <code>|URL|</code> Platzhalter an die Stelle, wo die URL zur Web-Ansicht eingefügt werden soll.',
    'mautic.email.config.webview_text' => 'Text für den {webview_text} Token',
    'mautic.email.config.mailer.mailjet.sandbox' => 'Sandbox-Modus',
    'mautic.email.config.mailer.mailjet.sandbox.mail' => 'Standard-E-Mail für den Sansbox-Modus',
    'mautic.email.custom_headers' => 'benutzerdefinierte Header',
    'mautic.email.custom_headers.config.tooltip' => 'Definieren Sie benutzerdefinierte Header, die für ausgehende E-Mails verwendet werden sollen, die nicht mit einer Mautic-E-Mail verknüpft sind. Dazu gehören E-Mails zum Zurücksetzen des Passworts, E-Mails an Mautic-Benutzer, Ergebnisse aus der Formularerstellung, direkt zusammengestellte E-Mails an Kontakte usw. Wenn für eine E-Mail benutzerdefinierte Kopfzeilen erforderlich sind (in Kampagnen oder Broadcasts verwendet), legen Sie die Kopfzeilen der Kunden auf der Registerkarte Erweitert der E-Mail fest.',
    'mautic.email.custom_headers.tooltip' => 'Fügen Sie Informationen für E-Mail-Tracking, Spam-Identifizierung, Authentifizierung und mehr hinzu',
    'mautic.email.dashboard.widgets' => 'E-Mail Widgets',
    'mautic.email.default.signature' => 'Liebe Grüße, %from_name%',
    'mautic.email.dnc.failed' => 'Zu viele Abbrüche als versucht wurde die Mail mit dem Betreff \'%subject%\' zu verschicken.',
    'mautic.email.dnc.retries' => 'Mehr als 3 Versuche die E-Mail zu verschicken.',
    'mautic.email.dnc.unsubscribed' => 'Der Benutzer hat sich abgemeldet',
    'mautic.email.dnc' => 'Kontakt hat gebeten, nicht per E-Mail benachrichtigt zu werden.',
    'mautic.email.email' => 'E-Mail',
    'mautic.email.emails' => 'E-Mails',
    'mautic.email.event.sent.direct' => 'Direkte E-Mail an %contact%',
    'mautic.email.event.sent' => '%email% %x% mal ausgeliefert',
    'mautic.email.example_recipients' => 'Empfänger',
    'mautic.email.failed.emails' => 'Fehlgeschlagene E-Mails',
    'mautic.email.failed' => 'E-Mail nicht versandt',
    'mautic.email.replied' => 'auf E-Mail geantwortet',
    'mautic.email.fetch.processed' => '{0}0 E-Mails verarbeitet für %imapPath% mit der Bedingung %criteria%|{1}1 E-Mail verarbeitet für %imapPath% mit der Bedingung %criteria%|]1,Inf[%count% E-Mails verarbeitet für %imapPath% mit der Bedingung %criteria%',
    'mautic.email.fetch.no_mailboxes_configured' => 'Es sind keine Mailboxen konfiguriert.',
    'mautic.email.filter.options.empty' => 'Es sind keine Filteroptionen vorhanden. Erstellen Sie E-Mail Kategorien oder Kontakt-Segmente.',
    'mautic.email.filter.placeholder' => 'Segment/Motiv-Filter',
    'mautic.email.flag.failed' => 'Nur fehlgeschlagene E-Mails',
    'mautic.email.flag.filter' => 'E-Mail Statusfilter',
    'mautic.email.flag.opened' => 'Nur geöffnete E-Mails',
    'mautic.email.flag.sent.and.opened.and.failed' => 'Gesendete, geöffnete und fehlgeschlagene E-Mails',
    'mautic.email.flag.sent.and.opened' => 'Gesendete und geöffnete E-Mails',
    'mautic.email.flag.sent' => 'Nur gesendete E-Mails',
    'mautic.email.form.abtestwinner' => 'A/B Test Sieger Kriterium',
    'mautic.email.form.action.sendemail.admin' => 'Sende eine E-Mail an eine:n Mitarbeiter:in',
    'mautic.email.form.action.sendemail.admin.descr' => 'ausgewählte E-Mail dem User schicken wenn er das Formular abgeschickt hat.',
    'mautic.email.form.action.sendemail.lead.descr' => 'Senden Sie die ausgewählte E-Mail an den Kontakt, nachdem er das Formular abgeschickt hat.',
    'mautic.email.form.action.sendemail.lead' => 'E-Mail an Kontakt senden',
    'mautic.email.form.body' => 'HTML Code',
    'mautic.email.form.body.help' => 'Passe den HTML-Inhalt der E-Mail an.',
    'mautic.email.form.confirmbatchdelete' => 'Ausgewählte E-Mails löschen? Dadurch werden auch damit verbundenen A/B Tests und Übersetzungen gelöscht!',
    'mautic.email.form.confirmdelete' => 'Die E-Mail %name% löschen? WARNUNG - Dadurch werden auch alle damit verbundenen A/B Tests und Übersetzungen gelöscht!',
    'mautic.email.form.confirmsend' => 'Queue, %name%, senden?',
    'mautic.email.form.internal.name' => 'Interner Name',
    'mautic.email.form.list' => 'Kontakt-Segment',
    'mautic.email.form.excluded_list' => 'Kontakt-Segment ausschließen',
    'mautic.email.form.plaintext.help' => 'Verwenden Sie den E-Mail-Builder, um den Inhalt der E-Mail zu bearbeiten. Wenn Sie einen unformatierten Text verwenden wollen, geben Sie ihn hier ein.',
    'mautic.email.form.plaintext' => 'Textversion',
    'mautic.email.form.publishdown.help' => 'Für Segment-E-Mails - Um ein "Unveröffentlichungsdatum" für eine Segment-E-Mail festzulegen, wählen Sie Ihr Unveröffentlichungsdatum aus, bevor Sie es speichern und schließen.',
    'mautic.email.form.submit.message' => 'Nachricht senden',
    'mautic.email.form.submit.message_descr' => 'benutzerdefinierte \'Danke\'-Nachricht',
    'mautic.email.form.template.help' => 'Wählen Sie die Vorlage für das Design der E-Mail. Nutzen Sie dann den Builder, um den Inhalt einzufügen. WARNUNG: Wenn Sie die E-Mail erstellt haben und danach die Vorlage ändern, kann es sein, dass die Inhalte nicht mehr angezeigt werden, weil die Vorlagen verschiedene Platzhalter haben.',
    'mautic.email.form.trafficweight.help' => 'Hier wird der Prozentanteil definiert, dem diese Variante gezeigt wird. Beispiel: Bei 50 wird die Vorläufer/Haupt-E-Mail zu 50% verschickt und 50% diese Variante. Wenn es zwei Varianten mit einem Anteil von 25 gibt, dann wird die Vorläufer/Haupt-E-Mail zu 50% verschickt und die beiden anderen Varianten jeweils zu 25%.',
    'mautic.email.form.trafficweight' => 'gewichteter Traffic',
    'mautic.email.form.unsubscribeform.tooltip' => 'Zeige das ausgewählte Formular auf der Abmeldeseite an, wenn sich ein Benutzer über diese E-Mail abmeldet.',
    'mautic.email.form.unsubscribeform' => 'Formular für die Abmeldung',
    'mautic.email.from_email.tooltip' => 'Legen Sie die Absender-Adresse für diese E-Mail fest. Wenn Sie das Feld leer lassen, wird die Standard-Adresse des Systems verwendet.',
    'mautic.email.from_email' => 'Absender-Adresse',
    'mautic.email.from_name.tooltip' => 'Legen Sie den Absender-Namen für diese E-Mail fest. Wenn Sie das Feld leer lassen, wird der Standard-Name des Systems verwendet.',
    'mautic.email.from_name' => 'Absender-Name',
    'mautic.email.use.owner.as.mailer.tooltip' => 'Sofern im Profil des Kontakts angegeben, werden die E-Mail-Adresse und der Name des Besitzers als Absender festgelegt.',
    'mautic.email.use.owner.as.mailer' => 'Kontaktinhaber als Mailer verwenden',
    'mautic.email.graph.line.stats.failed' => 'Fehlgeschlagen',
    'mautic.email.graph.line.stats.read' => 'Lesen',
    'mautic.email.graph.line.stats.sent' => 'Gesendet',
    'mautic.email.graph.line.stats' => 'E-Mails versendet',
    'mautic.email.graph.pie.ignored.read.failed.failed' => 'Fehlgeschlagen',
    'mautic.email.graph.pie.ignored.read.failed.ignored' => 'Ignoriert',
    'mautic.email.graph.pie.ignored.read.failed.read' => 'Lesen',
    'mautic.email.graph.pie.ignored.read.failed' => 'Ignorierte / Gelesene / Fehlerhafte E-Mails',
    'mautic.email.graph.pie.read.ingored.unsubscribed.bounced' => 'Gelesen / Ignoriert / Deabonniert / Abgesprungen',
    'mautic.email.header.edit' => 'E-Mail %name% ändern',
    'mautic.email.header.new' => 'Neue E-Mail',
    'mautic.email.help.searchcommands' => '<strong>Such-Befehle</strong><br />ids:ID1,ID2 (comma separated IDs, no spaces)<br />is:published<br />is:unpublished<br />is:mine<br />is:uncategorized<br />category:{category alias}<br />lang:{lang code}',
    'mautic.email.icon_tooltip.abtest' => 'Hat A/B Tests',
    'mautic.email.icon_tooltip.list_email' => 'Ist eine Segment (broadcast) E-Mail',
    'mautic.email.imap_extension_missing' => 'Die <a href=\'http://php.net/manual/en/book.imap.php\' target=\'_new\'>PHP IMAP Erweiterung</a> ist erforderlich, um die Funktionen zur E-Mail Überwachung zu aktivieren.',
    'mautic.email.lead.list.comparison' => 'Kontakt-Segment Vergleich',
    'mautic.email.label.reads' => 'Anzahl gelesen',
    'mautic.email.label.sends' => 'Anzahl gesendet',
    'mautic.email.lists.combined' => 'Alle Listen',
    'mautic.email.no.emails.note' => 'Es gibt keine E-Mails. Bitte legen Sie vorher eine E-Mail an.',
    'mautic.email.open.limittoemails' => 'Beschränken auf die ausgewählten E-Mails',
    'mautic.email.open.limittoemails_descr' => 'Gilt nur für E-Mails die geöffnet wurden. Wenn keine E-Mail ausgewählt ist wird es für alle geöffneten E-Mails ausgeführt.',
    'mautic.email.permissions.emails' => 'E-Mails, auf die der User Zugriff hat',
    'mautic.email.permissions.header' => 'Berechtigungen für E-Mails',
    'mautic.email.plaintext.generate' => 'Automatisch erzeugen',
    'mautic.email.point.action.open' => 'eine E-Mail geöffnet hat',
    'mautic.email.point.action.send' => 'eine E-Mail bekommen hat',
    'mautic.email.point.trigger.sendemail' => 'Sende eine E-Mail',
    'mautic.email.point.trigger.send_email_to_user' => 'Sende eine E-Mail an eine:n Mitarbeiter:in',
    'mautic.email.read' => 'E-Mail gelesen',
    'mautic.email.click' => 'E-Mail angeklickt',
    'mautic.email.point.trigger' => 'E-Mail Trigger',
    'mautic.email.read.emails' => 'Gelesene E-Mails',
    'mautic.email.readcount' => 'Anzahl gelesen',
    'mautic.email.recipient.lists' => 'Liste der Empfänger',
    'mautic.email.reply_to_email.tooltip' => 'Leer lassen, um die Absender-Adresse zu nutzen.',
    'mautic.email.reply_to_email' => 'Antwort-Adresse',
    'mautic.email.report.read.delay' => 'mit Verzögerung gelesen',
    'mautic.email.report.read_count' => 'Anzahl gelesen',
    'mautic.email.report.read_ratio' => 'Leserate',
    'mautic.email.report.sent_count' => 'Anzahl gesendet',
    'mautic.email.report.is_hit' => 'Geklickt',
    'mautic.email.report.hits_count' => 'Klicks',
    'mautic.email.report.unique_hits_count' => 'Eindeutige Klicks',
    'mautic.email.report.hits_ratio' => 'Klickrate',
    'mautic.email.report.unique_ratio' => 'Eindeutige Klickrate',
    'mautic.email.report.unsubscribed' => 'Abgemeldet',
    'mautic.email.report.unsubscribed_ratio' => 'Abmelderate',
    'mautic.email.report.bounced' => 'Gebounced',
    'mautic.email.report.bounced_ratio' => 'Bounce Rate',
    'mautic.email.report.revision' => 'Revision',
    'mautic.email.report.stat.date_read' => 'Abrufdatum',
    'mautic.email.report.stat.date_sent' => 'Versanddatum',
    'mautic.email.report.stat.email_address' => 'E-Mail Adresse',
    'mautic.email.report.stat.is_failed' => 'Ist fehlgeschlagen',
    'mautic.email.report.stat.is_read' => 'Lesen',
    'mautic.email.report.stat.retry_count' => 'Wiederholungsversuche',
    'mautic.email.report.stat.viewed_in_browser' => 'Im Browser angesehen',
    'mautic.email.report.variant_parent_id' => 'A/B Test Vorläufer ID',
    'mautic.email.report.variant_parent_subject' => 'A/B Test Vorläufer Betreff',
    'mautic.email.report.variant_read_count' => 'A/B Test Lesezahl',
    'mautic.email.report.variant_sent_count' => 'A/B Test Versandzahl',
    'mautic.email.report.variant_start_date' => 'A/B Test Startdatum',
    'mautic.email.report.click_through_count' => 'Click-through Anzahl',
    'mautic.email.report.click_through_rate' => 'Click-through Rate',
    'mautic.email.report.click_to_open_rate' => 'Click-to-Open Rate',
    'mautic.email.resubscribed.success' => '%email% hat sich wieder angemeldet. Wenn das ein Versehen war können Sie sich <a href=\'%unsubscribeUrl%\'>hier abmelden</a>.',
    'mautic.email.segmentId.filter' => 'Segment-Filter',
    'mautic.email.send' => 'Senden',
    'mautic.email.send.emailtype' => 'E-Mail Typ',
    'mautic.email.send.emailtype.tooltip' => 'Transaktionale E-Mails können an den gleichen Kontakt beliebig oft über mehrere Kampagnen hinweg geschickt werden. Marketing E-Mails werden nur ein einziges Mal an den Kontakt geschickt, auch wenn sie von einer anderen Kampagne gesendet worden sind.',
    'mautic.email.send.emailtype.transactional' => 'Transaktional',
    'mautic.email.send.emailtype.marketing' => 'Marketing',
    'mautic.email.send.edit.email.desc' => 'Bearbeiten der E-Mail. Sie können die E-Mail in einem Popup-Fenster bearbeiten.',
    'mautic.email.send.edit.email' => 'E-Mail ändern',
    'mautic.email.send.example' => 'Test senden',
    'mautic.email.send.disabled' => 'E-Mails werden im Hintergrund gesendet. Das Senden über den Browser wird blockiert, um doppelte E-Mails zu verhindern',
    'mautic.email.send.inprogress' => 'Der Versand läuft. Wenn Sie diese Seite verlassen, wird der Versand gestoppt und die Kontakte bekommen vielleicht doppelte E-Mails, wenn Sie den Versand später erneut starten.',
    'mautic.email.send.instructions' => 'Geben Sie die Anzahl der E-Mail an, die pro Batch verschickt werden sollen, und starten Sie dann den Versand.',
    'mautic.email.send.list' => '&quot;%name%&quot; senden',
    'mautic.email.send.new.email.desc' => 'Neue E-Mail. Es öffnet sich ein Fenster, in dem Sie Ihre Email erstellen können.',
    'mautic.email.send.new.email' => 'Neue E-Mail',
    'mautic.email.send.pending' => '{0} Es sind keine Kontakte ausstehend.|{1} Es ist ein Kontakt ausstehend.|[2, +Inf[ Es sind %count% Kontakte ausstehend.',
    'mautic.email.send.preview.email' => 'E-Mail Vorschau',
    'mautic.email.send.preview.email.desc' => 'Vorschau der E-Mail. Sie können die E-Mail in einem Popup-Fenster ansehen.',
    'mautic.email.send.selectemails' => 'E-Mail die versendet werden soll',
    'mautic.email.send.stats' => '%sent% gesendet und %failed% fehlgeschlagen',
    'mautic.email.send.success' => '&quot;%subject%&quot; wurde gesendet!',
    'mautic.email.send.with_errors' => '&quot;%subject%&quot; wurde gesendet, allerdings mit einigen Fehlern.',
    'mautic.email.sendmanual' => 'Senden (manuell)',
    'mautic.email.sent.emails' => 'Gesendete E-Mails',
    'mautic.email.sent' => 'E-Mail versendet',
    'mautic.email.stage.action.open' => 'Öffnet eine E-Mail',
    'mautic.email.stage.action.send' => 'Sendet eine E-Mail',
    'mautic.email.stats.options.title' => 'E-Mails',
    'mautic.email.stats' => 'E-Mail Statistiken',
    'mautic.email.stats.report.table' => 'Gesendete E-Mails',
    'mautic.email.stat.leadcount' => '%count% ausstehend',
    'mautic.email.stat.readcount' => '%count% gelesen',
    'mautic.email.stat.sentcount' => '%count% gesendet',
    'mautic.email.stat.failed' => 'Fehlgeschlagen',
    'mautic.email.stat.leadcount.tooltip' => 'Anzahl der Kontakte, die diese E-Mail nicht erhalten haben',
    'mautic.email.stat.pending' => 'Ausstehend',
    'mautic.email.stat.queued' => '%count% in Warteschlange',
    'mautic.email.stat.queued.tooltip' => 'Anzahl der Kontakte, für die diese E-Mail in die Sende-Warteschlange platziert wurde, basierend auf ihren Frequenzen.',
    'mautic.email.stat.read' => 'Lesen',
    'mautic.email.stat.readpercent' => '%count%% gelesen',
    'mautic.email.stat.sent' => 'Gesendet',
    'mautic.email.stat.delivered' => 'Zugestellt',
    'mautic.email.stat_record.not_found' => 'Daten nicht gefunden.',
    'mautic.email.subject' => 'Betreff',
    'mautic.email.table.most.emails.failed' => 'Die meisten E-Mails sind fehlgeschlagen',
    'mautic.email.table.most.emails.unsubscribed' => 'Die meisten E-Mails wurden nicht abonniert',
    'mautic.email.table.most.emails.bounced' => 'Die meisten E-Mails wurden zurückgeschickt',
    'mautic.email.table.most.emails.read.percent' => 'Anteil gelesen  [%]',
    'mautic.email.table.most.emails.read' => 'Am meisten gelesene E-Mails',
    'mautic.email.table.most.emails.sent' => 'Am meisten gesendete E-Mails',
    'mautic.email.table.most.emails.clicks' => 'Meistgeklickte Links',
    'mautic.email.thead.stats' => 'Statistik',
    'mautic.email.thead.maps' => 'Karte',
    'mautic.email.timeline.event.bounced' => 'E-Mail gebounced',
    'mautic.email.timeline.event.custom_email' => 'Individuelle E-Mail',
    'mautic.email.timeline.event.email_reply' => 'Geantwortet',
    'mautic.email.timeline.event.failed' => 'Das Senden der E-Mail ist fehlgeschlagen.',
    'mautic.email.timeline.event.list' => 'Die E-Mail wurde an diesen Kontakt gesendet, da er zum Segment \'%list%\' gehört.',
    'mautic.email.timeline.event.not.read' => 'URL Vorschau',
    'mautic.email.timeline.open_details' => 'Historie der geöffneten E-Mails',
    'mautic.email.timeline.event.read' => 'E-Mail <strong>wurde erstmals am %date% gelesen</strong>. Das war %interval%, nachdem die E-Mail am %sent% gesendet wurde',
    'mautic.email.timeline.event.retried' => 'one: Die E-Mail wurde bis jetzt einmal versandt.| Die E-Mail wurde %count% mal versendet.',
    'mautic.email.timeline.event.sent' => 'E-Mail <strong>wurde erstmals am %date% gelesen</strong>. Das war %interval%, nachdem die E-Mail gesendet wurde.',
    'mautic.email.timeline.event.viewed.in.browser' => 'Der Kontakt hat sich die E-Mail auch im Browser angesehen.',
    'mautic.email.token.dragme' => 'Ziehe mich in den Bereich',
    'mautic.email.token.help' => 'Ziehen Sie das Token in den gewünschten Bereich',
    'mautic.email.token.signature.descr' => 'Der Signatur-Text kann in der Konfiguration oder im Nutzerprofil festlegt werden',
    'mautic.email.token.signature' => 'Signatur',
    'mautic.email.config.default_signature_text' => 'Standard E-Mail Signatur',
    'mautic.email.config.default_signature_text.tooltip' => 'Diese Signatur wird für E-Mails verwendet, die an Kontakte ohne einen Besitzer versandt werden. Falls die "Mail-System ist Besitzer"-Option aktiviert ist und der Kontakt einen Besitzer hat, wird die Signatur aus dem Profil des Besitzers verwendet. Verwenden Sie {signature}, um eine Signatur in die E-Mail einzufügen.',
    'mautic.email.token.unsubscribe_text.descr' => 'Fügt eine Nachricht für die Abmeldung und einen Link hinzu',
    'mautic.email.token.unsubscribe_text' => 'Text für die Abmeldung',
    'mautic.email.token.unsubscribe_url.descr' => 'Fügt nur die Abmelde-URL hinzu.',
    'mautic.email.token.unsubscribe_url' => 'Abmelde-URL',
    'mautic.email.token.webview_text.descr' => 'Fügt einen Text für die Web-Ansicht und einen Link hinzu.',
    'mautic.email.token.webview_text' => 'Text für Web-Ansicht',
    'mautic.email.token.webview_url.descr' => 'Fügt nur die Web-Ansicht-URL hinzu',
    'mautic.email.token.webview_url' => 'Web-Ansicht-URL',
    'mautic.email.tokens.header' => 'Token',
    'mautic.email.tokens.help' => 'Tokens sind Platzhalter für "featured Objekte". Ziehen Sie den Token einfach in den Editor, um ihn hinzuzufügen!',
    'mautic.email.total' => 'Gesamt',
    'mautic.email.type.header' => 'Welche Art von E-Mail möchten Sie erstellen?',
    'mautic.email.type.segment.differences.1st' => 'Für Newsletter, Angebote, Updates etc.',
    'mautic.email.type.segment.differences.2nd' => 'Ermöglicht einen Versand pro Kontakt',
    'mautic.email.type.segment.differences.3rd' => 'Für Marketingzwecke konzipiert',
    'mautic.email.type.segment.differences.4th' => 'Wird beim Versenden von Massen-E-Mails verwendet',
    'mautic.email.type.list.header' => 'Segment E-Mail',
    'mautic.email.type.list' => 'Segment E-Mails',
    'mautic.email.type.template.header' => 'Vorlagen E-Mail',
    'mautic.email.type.template.differences.1st' => 'Für Kampagnen, Formular und Auslöser',
    'mautic.email.type.template.differences.2nd' => 'Erlaube mehrmaliges Senden',
    'mautic.email.type.template.differences.3rd' => 'Geeignet für transaktionalen Einsatz',
    'mautic.email.type.template.differences.4th' => 'Basierend spezifischen Aktionen des Benutzers',
    'mautic.email.type.template' => 'Vorlagen E-Mails',
    'mautic.email.unsubscribe.text' => '<a href=\'%link%\'>Abmelden</a> um von uns keine E-Mails mehr zu erhalten.',
    'mautic.email.unsubscribe' => 'Abmelden',
    'mautic.email.unsubscribed.success' => 'Es tut uns leid, dass Sie uns verlassen! %email% wird von uns keine E-Mails mehr erhalten. Wenn das ein Versehen war, können Sie sich <a href=\'%resubscribeUrl%\'>hier wieder anmelden</a>.',
    'mautic.email.preferences_center_success_message.text' => 'Einstellungen erfolgreich gespeichert',
    'mautic.email.urlvariant' => 'Öffentliche Preview URL',
    'mautic.email.preview.show.translation' => 'Zeige Vorschau für Übersetzung',
    'mautic.email.preview.show.ab.variant' => 'Zeige Vorschau für A/B Variante',
    'mautic.email.preview.show.contact' => 'Zeige Vorschau für Kontakt',
    'mautic.email.preview.url' => 'Vorschau URL',
    'mautic.email.variant.misconfiguration' => 'Es gibt ein Problem mit der Konfiguration der Varianten. Stellen Sie bitte sicher, dass alle Varianten mit dem selben Sieger-Kriterium konfiguriert sind.',
    'mautic.email.variants' => 'Varianten',
    'mautic.email.variantstartdate' => 'A/B Test gestartet am %date% um %time%',
    'mautic.email.variant.graph.all' => 'Alle',
    'mautic.email.variant.graph.variant' => 'Variante',
    'mautic.email.webhook.event.send' => 'E-Mail gesendet Ereignis',
    'mautic.email.webhook.event.open' => 'Geöffnete E-Mail Ereignis',
    'mautic.email.webview.text' => '<a href=\'%link%\'>Wird die Seite nicht korrekt angezeigt? Hier klicken.</a>',
    'mautic.widget.created.emails' => 'Erstellte E-Mails',
    'mautic.widget.emails.in.time' => 'E-Mails im Zeitverlauf',
    'mautic.widget.emails.best.hours' => 'Beste E-Mail-Lesezeiten',
    'mautic.widget.emails.best.hours.reads_total' => 'Stündlicher Prozentsatz von %reads% Lesevorgängen',
    'mautic.widget.most.hit.email.redirects' => 'Die meisten E-Mail-Weiterleitungen',
    'mautic.widget.sent.email.to.contacts' => 'E-Mail an Kontakte gesendet',
    'mautic.widget.ignored.vs.read.emails' => 'Ignoriert gegen gelesen',
    'mautic.widget.most.read.emails' => 'Am meisten gelesene E-Mails',
    'mautic.widget.most.sent.emails' => 'Am meisten gesendete E-Mails',
    'mautic.widget.upcoming.emails' => 'Geplante E-Mails',
    'mautic.email.ignored.emails' => 'Ignorierte E-Mails',
    'mautic.email.unsubscribed.emails' => 'Deabonnierte E-Mails',
    'mautic.email.bounced.emails' => 'Zurückgeschickte E-Mails',
    'mautic.email.unsubscribed' => 'Abgemeldet',
    'mautic.email.bounced' => 'Gebounced',
    'mautic.email.clicked' => 'Geklickt',
    'mautic.email.config.header.queue' => 'Queue',
    'mautic.email.config.alert.queue' => 'Stellen Sie sicher, dass Ihre Anmeldeinformationen ordnungsgemäß geschrieben sind.',
    'mautic.email.config.track.mail.use.queue' => 'Warteschlange verwenden',
    'mautic.email.config.track.mail.use.queue.tooltip' => 'E-Mails werden mit RabbitMQ verfolgt',
    'device.granularity.email' => 'Endgeräte der gelesenen E-Mails',
    'mautic.widget.device.granularity.email' => 'Endgeräte der gelesenen E-Mails',
    'mautic.email.config.header.unsubscribe' => 'Einstellungen für die Abmeldung',
    'mautic.email.config.show.preference.options' => 'Kontakteinstellungen anzeigen',
    'mautic.email.config.show.preference.options.tooltip' => 'Wenn diese Option aktiviert ist, wird die standardmäßige Abmeldungs-Nachricht nicht angezeigt.',
    'mautic.email.config.show.contact.segments' => 'Einstellungen für die Segmente anzeigen',
    'mautic.email.config.show.contact.segments.tooltip' => 'Dies ermöglicht dem Kontakt, die Auswahl der Segmente aufzuheben.',
    'mautic.email.config.show.contact.frequency' => 'Einstellungen für die Kontakt-Frequenz anzeigen',
    'mautic.email.config.show.contact.frequency.tooltip' => 'Dies ermöglicht dem Kontakt, Regeln für die Kontakt-Frequenz festzulegen.',
    'mautic.email.config.show.contact.pause.dates' => 'Einstellungen für die Kontakt-Pause anzeigen',
    'mautic.email.config.show.contact.pause.dates.tooltip' => 'Dies ermöglicht dem Kontakt, ein Anfang- und Ende-Datum für die Kontakt-Pause anzugeben.',
    'mautic.email.config.show.contact.categories' => 'Kategorien des Kontakts zeigen',
    'mautic.email.config.show.contact.categories.tooltip' => 'Dies ermöglicht dem Kontakt, sich von allen Kategorien abzumelden, denen er angehört.',
    'mautic.email.config.show.contact.preferred.channels' => 'Bevorzugte Kanaloption anzeigen',
    'mautic.email.config.show.contact.preferred.channels.tooltip' => 'Damit kann der Kontakt seinen bevorzugten Kanal festlegen; wird nur angezeigt, wenn es mehr als einen Kontaktkanal gibt.',
    'mautic.lead.message.preferences' => 'Einstellungen für Nachrichten',
    'mautic.lead.message.preferences.descr' => 'Bitte benutzen Sie das Formular, um Ihre Einstellungen für Nachrichten festzulegen.',
    'mautic.report.group.emails' => 'E-Mails',
    'mautic.email.campaign.event.reply' => 'Antwortet auf E-Mail',
    'mautic.email.campaign.event.reply_descr' => 'Lösen Sie Aktionen aus, wenn ein Kontakt auf eine E-Mail antwortet',
    'mautic.email.config.monitored_email.reply_folder' => 'Kontakt antwortet',
    'mautic.email.stat.tooltip' => 'Die Details stimmen möglicherweise nicht mit den Summen überein. Dies kann passieren, wenn der Kontakt nicht mehr in Ihrem Mautic-Konto existiert, oder die E-Mail mehrmals an den gleichen Kontakt gesendet wurde, oder ein Kontakt die E-Mail mehrmals gelesen hat.',
    'mautic.email.stat.simple.tooltip' => 'Details stimmen möglicherweise nicht mit den Summen überein, wenn der Kontakt nicht mehr in Ihrem Mautic-Konto vorhanden ist',
    'mautic.email.associated.contacts' => 'Kontakte',
    'mautic.email.segment.choice.generated_email_domain' => 'E-Mail Domäne',
    'mautic.email.config.mailer_encryption.none' => 'Keine',
    'mautic.email.config.mailer_encryption.ssl' => 'SSL',
    'mautic.email.config.mailer_encryption.tls' => 'TLS',
    'mautic.email.config.header.dsn' => 'E-Mail DSN',
    'mautic.email.heatmap.click_heatmap' => 'Klick Heatmap',
    'mautic.email.heatmap.clicks' => '{0}0 Klicks|{1}1 Klick|[2,Inf]%count% Klicks',
    'mautic.email.heatmap.clicks_recorded' => 'Klick registriert',
    'mautic.email.heatmap.total' => 'Gesamt',
    'mautic.email.heatmap.unique' => 'Einmalig',
    'mautic.email.heatmap.heat_scale' => 'Heat scale',
    'mautic.email.heatmap.cold' => 'kalt',
    'mautic.email.heatmap.hot' => 'heiss',
    'mautic.email.usages' => 'E-Mail-Nutzung',
    'mautic.email.no_usages' => 'Diese E-Mail wird nicht von anderen Komponenten verwendet.',
    'mautic.config.tab.themeconfig' => 'Themen Einstellungen',
    'mautic.core.config.form.theme.import.allowed.extensions' => 'Zulässige Dateierweiterungen bei dem Installationspaket',
    'mautic.config.tab.coreconfig' => 'Systemeinstellungen',
    'mautic.config.tab.frequency_rules' => 'Standardregel für Häufigkeit',
    'mautic.core.ab_test.confirm_make_winner' => 'Achtung: Wenn Sie %name% zum Gewinner erklären, wird dieser automatisch zur Hauptvariante erklärt, die anderen Varianten werden von der Veröffentlichung zurückgezogen, der A/B-Test wird gestoppt und die laufende A/B-Test-Statistik wird zurückgesetzt. Sind Sie sicher, dass Sie fortfahren möchten?',
    'mautic.core.ab_test.create' => 'A/B Test erstellen',
    'mautic.core.ab_test.make_winner' => 'Als Gewinner festlegen',
    'mautic.core.ab_test.noresults' => 'Im Moment sind keine Ergebnisse verfügbar',
    'mautic.core.ab_test.parent_winning' => 'Parent ist Sieger, oder mit der Variante verknüpft.',
    'mautic.core.ab_test.stats' => 'A/B Test Statistiken',
    'mautic.core.ab_test.form.traffic_weight' => 'gewichteter Traffic',
    'mautic.core.ab_test.form.traffic_weight.help' => 'Legen Sie den Prozentsatz der Besuche fest, denen diese Variante gezeigt werden soll. Wenn Sie z.B. 50 eintragen und nur eine Variante existiert, erhält die Variante 50% der Besucher und die Hauptseite ebenfalls 50%. Tragen Sie 25 ein und haben zwei Varianten, erhält jede Variante 25% und die Hauptseite 50%. ',
    'mautic.core.ab_test.form.winner' => 'A/B Test Sieger Kriterium',
    'mautic.core.actions' => 'Aktionen',
    'mautic.core.advanced' => 'Fortgeschritten',
    'mautic.core.alias' => 'Alias',
    'mautic.core.autogenerated' => 'Automatisch generiert',
    'mautic.core.all' => 'Alle',
    'mautic.core.and' => 'und',
    'mautic.core.author' => 'Autor',
    'mautic.core.builder' => 'Builder',
    'mautic.core.builder.legacy' => 'Altlast',
    'mautic.core.builder.link.text.placeholder' => 'Link Text (z.B. Suche)',
    'mautic.core.builder.link.url.placeholder' => 'Link URL (z.B. http://google.com)',
    'mautic.core.builder.token.dragme' => 'Ziehe mich in den Bereich',
    'mautic.core.builder.token.drophere' => 'Hier ablegen!',
    'mautic.core.builder.token.help' => 'Ziehen Sie das Token in den gewünschten Bereich',
    'mautic.core.builder.token.help_custom' => 'Ziehen Sie den gewünschten Token hier her, um ihn an der aktuellen Maus-Position in den Editor einzufügen.',
    'mautic.email.token.today' => 'Heute',
    'mautic.core.category' => 'Kategorie',
    'mautic.core.channels' => 'Channels',
    'mautic.core.channel' => 'Kanal',
    'mautic.core.channel.broadcast_success_count' => '# gesendet',
    'mautic.core.channel.broadcast_failed_count' => '# fehlgeschlagen',
    'mautic.core.close' => 'Schließen',
    'mautic.core.close.builder' => 'Builder schließen',
    'mautic.core.color' => 'Farbe',
    'mautic.core.error.message' => 'Fehlermeldung',
    'mautic.core.command.asset_generate_success' => 'Die Assets für die Produktion wurden neu erzeugt',
    'mautic.core.command.install_application_configuration_loaded' => 'Die Konfiguration wurde erfolgreich geladen',
    'mautic.core.command.install_application_could_not_clear_cache' => 'Anwendungs-Cache konnte nicht zurückgesetzt werden',
    'mautic.core.command.install_application_could_not_create_database' => 'Mautic Datenbank konnte nicht erzeugt werden',
    'mautic.core.command.install_application_could_not_create_database_exception' => 'Mautic Datenbank konnte nicht erzeugt werden. Fehler: %message%',
    'mautic.core.command.install_application_could_not_create_user' => 'Konnte den Administrator nicht anlegen: %message%',
    'mautic.core.command.install_application_could_not_load_fixtures' => 'Konnte die Daten nicht in die Datenbank laden',
    'mautic.core.command.install_application_could_not_load_fixtures_exception' => 'Konnte die Datenbank nicht in die Datenbank laden: %message%',
    'mautic.core.command.install_application_could_not_write_config' => 'Konnte die Konfigurationsdatei nicht speichern: %message%',
    'mautic.core.command.install_application_success' => 'Erfolg! Mautic ist nun installiert',
    'mautic.core.command.install_data_confirm' => 'Dies überschreibt sämtliche Daten in den Mautic-Tabellen. Sind Sie sicher?',
    'mautic.core.command.install_data_success' => 'Erfolg! Default Mautic Daten sind installiert. Der Default-Login ist admin/mautic',
    'mautic.core.command.language_config.config_written' => 'Konfiguration für Sprache %lang% geschrieben.',
    'mautic.core.command.language_config.could_not_create' => 'Die Konfigurationsdatei für Sprachen konnte nicht in %file% geschrieben werden.',
    'mautic.core.command.transifex_error_creating_directory' => 'Das Verzeichnis %directory% konnte nicht erstellt werden.',
    'mautic.core.command.transifex_error_creating_file' => 'Die Datei %file% konnte nicht geschrieben werden.',
    'mautic.core.command.transifex_error_pushing_data' => 'Bei der Übertragung der Daten zu Transiflex ist ein Fehler aufgetaucht: %message%',
    'mautic.core.command.transifex_no_credentials' => 'Speichern Sie bitte die Transiflex Login-Informationen um diesen Befehl zu verwenden.',
    'mautic.core.command.transifex_processing_language' => 'Sprache \'%language%\' wird verarbeitet.',
    'mautic.core.command.transifex_processing_resource' => 'Resouce \'%resource%\' wird verarbeitet.',
    'mautic.core.command.transifex_resource_created' => 'Resource wurde erfolgreich erzeugt',
    'mautic.core.command.transifex_resource_downloaded' => 'Resource wurde erflogreich runtergeladen',
    'mautic.core.command.transifex_resource_updated' => 'Resource für %file% erfolgreich aktualisiert.',
    'mautic.core.command.transifex_error_pulling_data' => 'Es gab einen Transifex API Fehler: %message%',
    'mautic.core.command.update.composer' => 'Es sind Composer-Udates aktiviert. Das bedeutet, dass Mautic nur über den Befehl \'compuser update\' aktualisiert werden kann. Weitere Informationen sind in der Dokumentation zu finden: https://mau.tc/switch-to-composer',
    'mautic.core.command.update.finalize_instructions' => 'WICHTIG: Führen Sie denselben Befehl erneut mit --finish aus. Beispiel: \'php bin/console mautic:update:apply --finish\'',
    'mautic.core.command.update.step.checks' => 'Es werden Prüfungen vor dem Update ausgeführt …',
    'mautic.core.command.update.step.critical_migrations' => 'Wende kritische Schemaanpassungen an...',
    'mautic.core.command.update.step.download_update_package' => 'Update wird heruntergeladen...',
    'mautic.core.command.update.step.extract_update_package' => 'Update wird extrahiert...',
    'mautic.core.command.update.step.loading_package' => 'Paket wird geladen...',
    'mautic.core.command.update.step.loading_update_information' => 'Update Information wird geladen...',
    'mautic.core.command.update.step.update_languages' => 'Sprachpakete werden aktualisiert...',
    'mautic.core.command.update.step.validate_update_package' => 'Update wird überprüft...',
    'mautic.core.command.update.step.wrapping_up' => 'Bereite nach...',
    'mautic.core.command.prepare_upgrade_success' => 'Die mautic.zip Datei wurde erfolgreich erstellt und in das Web-Hauptverzeichnis gelegt. Bitte machen Sie jetzt ein Backup der Datei.',
    'mautic.core.command.prepare_upgrade_fail' => 'Die mautic.zip-Datei konnte nicht erstellt und in Ihr Web-Hauptverzeichnis gelegt werden. Ihre Installation kann deshalb nicht aktualisiert werden.',
    'mautic.core.company' => 'Firma',
    'mautic.core.components' => 'Komponenten',
    'mautic.core.integrations' => 'Integrationen',
    'mautic.core.config.cors.restrict.domains' => 'Domains beschränken',
    'mautic.core.config.cors.restrict.domains.tooltip' => 'Wollen Sie Domains beschränken, die CORS-Anfragen an Ihre Mautic-Instanz senden können?',
    'mautic.core.config.cors.valid.domains' => 'Valide Domains',
    'mautic.core.config.cors.valid.domains.tooltip' => 'Tragen Sie zeilenweise die Domains (http://ihredomain.de) ein, für die Sie eingehende CORS-Anfragen beschränken wollen.',
    'mautic.core.config.response.headers.sts' => 'Strict Transport Security',
    'mautic.core.config.response.headers.sts.tooltip' => 'Der HSTS-Antwortheader informiert den Browser darüber, dass auf die Site nur über HTTPS zugegriffen werden darf und dass alle zukünftigen Zugriffsversuche über HTTP automatisch auf HTTPS umgestellt werden sollen.',
    'mautic.core.config.response.headers.sts.expire_time' => 'Ablaufzeit (Sekunden)',
    'mautic.core.config.response.headers.sts.subdomains' => 'Subdomains einschließen',
    'mautic.core.config.response.headers.sts.subdomains.tooltip' => 'Wenn diese Regel aktiviert ist, gilt sie auch für alle Subdomains der Site.',
    'mautic.core.config.response.headers.sts.preload' => 'Preload',
    'mautic.core.config.response.headers.sts.preload.tooltip' => 'HSTS preload service (https://hstspreload.org/)',
    'mautic.core.config.form.cache.path' => 'Pfad zum Cache-Verzeichnis',
    'mautic.core.config.form.cache.path.tooltip' => 'Lege den absoluten Pfad zum Cache-Verzeichnis fest. %kernel.project_dir%/app kann als Platzhalter für das App-Verzeichnis im öffentlichen Webstamm verwendet werden. Es wird empfohlen, ein Verzeichnis außerhalb des öffentlichen Webstamms zu verwenden, um zu verhindern, dass der Cache öffentlich zugänglich ist.',
    'mautic.core.dir.not.accesssible' => '%dir% ist nicht zugänglich',
    'mautic.core.config.form.date.format.dateonly' => 'Standardformat für das Datum ',
    'mautic.core.config.form.date.format.dateonly.tooltip' => 'Setzt das Format für die das Datum ohne Zeit. Sie können die PHP Datumsformate verwenden (http://php.net/manual/en/function.date.php).\\nZum Beispiel: j. F, Y wird zu 21. Dezember, 2014.',
    'mautic.core.config.form.date.format.full' => 'Standardformat für das komplette Datum ',
    'mautic.core.config.form.date.format.full.tooltip' => 'Setzt das Format für die lange Version eines Datums. Sie können die PHP Datumsformate verwenden (http://php.net/manual/en/function.date.php).\\nZum Beispiel: F j, Y g:i a T wird zu December 21, 2014 5:22 pm CST',
    'mautic.core.config.form.date.format.short' => 'Standardformat für das kurze Datum',
    'mautic.core.config.form.date.format.short.tooltip' => 'Setzt das Format für die lange Version eines Datums. Sie können die PHP Datumsformate verwenden (http://php.net/manual/en/function.date.php).\\nZum Beispiel: D, d. M wird zu Son, 21. Dez.',
    'mautic.core.config.form.date.format.timeonly' => 'Standardformat Zeit (nur Zeit)',
    'mautic.core.config.form.date.format.timeonly.tooltip' => 'Setzt das Format für die Zeit. Sie können die PHP Datumsformate verwenden (http://php.net/manual/en/function.date.php).\\nZum Beispiel: g:i wird zu 17:22.',
    'mautic.core.config.form.default.pagelimit' => 'Standard Höchstanzahl pro Seite',
    'mautic.core.config.form.default.pagelimit.tooltip' => 'Legt fest, wieviele Listenelemente auf der Seite angezeigt werden',
    'mautic.core.config.form.default.timezone' => 'Standardzeitzone',
    'mautic.core.config.form.default.timezone.tooltip' => 'Setzt die Zeitzone für die Site. User können im Profil eine andere Zeitzone einstellen.',
    'mautic.core.config.form.cached.data.timeout' => 'Zeitüberschreitung bei gecachten Daten',
    'mautic.core.config.form.cached.data.timeout.tooltip' => 'Einige Grafik- und Tabellen-Daten werden gecacht, um die Ladegeschwindigkeit zu erhöhen. Definieren Sie, wie oft der Cache ablaufen und sich neue Daten aus der Datenbank holen soll. Mit 0 deaktivieren Sie den Cache.',
    'mautic.core.config.form.do_not_track_ips' => 'Liste von IPs für die keine Kontakte nachverfolgt werden sollen (eine pro Zeile)',
    'mautic.core.config.form.do_not_track_ips.tooltip' => 'Listen Sie die IPs auf (eine pro Zeile), die nicht mit dem Kontakt-Tracking verbunden werden soll. Zum Beispiel die IPs bekannter Webmail-Programme. Sie können genaue IPs angeben (127.0.0.1), IP-Bereiche (127.0.0.1/32) oder IPs mit Platzhaltern (127.0.0.*).',
    'mautic.core.config.form.do_not_track_bots' => 'Liste der Bots, die nicht zum Tracken von Kontakten genutzt werden sollen (eine pro Zeile)',
    'mautic.core.config.form.do_not_track_bots.tooltip' => 'Liste der Bots, einer pro Zeile, welche nicht mit Kontaktverfolgung verknüpft werden sollten',
    'mautic.core.config.form.image.path' => 'Relativer Pfad zum Verzeichnis der Bilder',
    'mautic.core.config.form.image.path.tooltip' => 'Geben Sie hier den relativen Pfad zum öffentlichen Hauptverzeichnis an. Hier werden die Bilder gespeichert die von den Editoren hochgeladen werden.',
    'mautic.core.config.form.ip.lookup.auth' => 'Authentifizierung für den IP Lookup Service',
    'mautic.core.config.form.ip.lookup.auth.tooltip' => 'Geben Sie hier die Daten für den Service an. Wenn Benutzername und Passwort gefordert sind geben Sie diese bitte in der Form Benutzername:Passwort an.',
    'mautic.core.config.create.organization.from.ip.lookup' => 'Erstellen Sie eine Firma aus der IP-lookup',
    'mautic.core.config.create.organization.from.ip.lookup.tooltip' => 'Obwohl es nützlich sein kann, das Unternehmen über IP-Lookup zu erhalten, wird Mautic einen solchen Kontakt als identifiziert betrachten, und das möchten Sie möglicherweise nicht.',
    'mautic.core.config.form.transliterate.page.title' => 'Seitentitel transkribieren',
    'mautic.core.config.form.transliterate.page.title.tooltip' => 'Legen Sie fest, ob die Seitentitel im Ereignisverlauf des Kontakts transliteriert oder in der Originalsprache angezeigt werden sollen. Diese Einstellung war in früheren Versionen von Mautic standardmäßig aktiviert.',
    'mautic.core.config.load.froala.assets' => 'Lade Froala assets',
    'mautic.core.config.load.froala.assets.tooltip' => 'Lade die Froala WYSIWYG JS-Dateien in die Mautic-Verwaltung. Froala wird für das Legacy-JS und den Page Builder benötigt',
    'mautic.core.config.load.froala.assets.warning' => 'Froala wird standardmäßig nicht geladen, da die von Mautic verwendete Version bekannte Sicherheitslücken aufweist und die JS-Bibliothek aufgrund von Lizenzänderungen nicht aktualisiert werden kann. Sie können es dennoch aktivieren, wenn Sie mit den Risiken einverstanden sind und den Legacy-Builder verwenden müssen.',
    'mautic.core.config.form.404_page' => '404 Seite',
    'mautic.core.config.form.404_page.tooltip' => 'Wählen Sie die Seite aus, die beim Navigieren zu Mautics 404-Fehler angezeigt werden soll. Lassen Sie das Feld leer, um zur 404-Standardseite umgeleitet zu werden.',
    'mautic.core.config.form.ip.lookup.service' => 'IP Lookup Service',
    'mautic.core.config.form.ip.lookup.service.tooltip' => 'Stellen Sie hier ein, welcher Dienst für die Bestimmung der Geodaten verwendet werden soll. Dies sind kommerzielle Anbieter. Mautic hat keine Beziehung zu diesen Anbietern. Sie werden hier angezeigt um die Konfiguration zu vereinfachen.',
    'mautic.core.config.form.shortener.enable_email' => 'E-Mail',
    'mautic.core.config.form.shortener.enable_email.tooltip' => 'Kurze URLs in E-Mails aktivieren',
    'mautic.core.config.form.shortener.enable_sms' => 'SMS',
    'mautic.core.config.form.shortener.enable_sms.tooltip' => 'Kurz-URLs in SMS aktivieren',
    'mautic.core.config.form.shortener.empty' => 'Bitte installieren und richte zuerst den Shortener-Dienst ein (bitly via Plugins oder andere)',
    'mautic.core.config.form.shortener' => 'URL-Kürz-Dienst',
    'mautic.core.config.form.shortener.tooltip' => 'Wähle den Dienst zum Kürzen von URLs aus.',
    'mautic.core.config.form.link.max_entity_lock_time' => 'Maximale Sperrzeit des Elements (Sekunden)',
    'mautic.core.config.form.link.max_entity_lock_time.tooltip' => 'Zeit in Sekunden, bevor eine Entität (E-Mail, Segmente usw.) automatisch frei ist.',
    'mautic.core.config.form.locale' => 'Standardsprache',
    'mautic.core.config.form.locale.tooltip' => 'Setzt die Sprache für die Site. User können im Profil eine andere Sprache einstellen.',
    'mautic.core.config.form.log.path' => 'Pfad zum Log-Verzeichnis',
    'mautic.core.config.form.log.path.tooltip' => 'Legen Sie den absoluten Pfad zum Protokollverzeichnis fest. %kernel.project_dir%/app kann als Platzhalter für das App-Verzeichnis im öffentlichen Webstamm verwendet werden. Es wird empfohlen, ein Verzeichnis außerhalb des öffentlichen Webstamms zu verwenden, um zu verhindern, dass die Protokolle öffentlich zugänglich sind.',
    'mautic.core.config.form.site.url' => 'URL der Webseite',
    'mautic.core.config.form.site.url.tooltip' => 'Geben Sie hier die URL zur Seite an. Sie wird von Cronjobs für Links in E-Mails verwendet. ',
    'mautic.core.config.form.theme' => 'Standard Landingpage und Formular-Vorlage',
    'mautic.core.config.form.theme.tooltip' => 'Legen Sie die Standard-Vorlage fest, das vom System zum Rendern von Landingpages und Formularen verwendet wird. HINWEIS: Wenn Sie diese Vorlage ändern, wirkt sich dies nur auf neue Seiten aus, vorhandene Seiten werden jedoch nicht geändert.',
    'mautic.core.config.form.trusted.hosts' => 'Vertrauenswürdige Server',
    'mautic.core.config.form.trusted.hosts.tooltip' => 'Geben Sie hier die Server an, die Anfragen an Mautic stellen dürfen. Sie können reguläre Ausdrücke verwenden und mehrere Server mit einem Komma trennen, z.B. .*\\.?trusted.com$. Wenn nichts angeben ist, reagiert Mautic auf alle Anfragen.',
    'mautic.core.config.form.trusted.proxies' => 'Vertrauenswürdige Proxies',
    'mautic.core.config.form.trusted.proxies.tooltip' => 'Geben Sie hier die IP-Adressen der vertrauenswürdigen Proxies an. Diese Einstellung ist obligatorisch, wenn Mautic hinter einem SSL-Abschlussproxy verwendet wird. Sie können mehrere IP-Adressen durch Komma trennen. Z.B. 127.0.0.1, 10.0.0.0/8, fc00::/7',
    'mautic.core.config.form.update.composer' => 'Update Mautic mit Composer [BETA]',
    'mautic.core.config.form.update.composer.tooltip' => 'Auf „Ja“ setzen, wenn Sie Mautic über Composer aktualisieren. Dies ist eine Voraussetzung, wenn Sie Plugins über den Marketplace installieren und aktualisieren möchten. Dies ist die Standardinstallations- und Aktualisierungsmethode in Mautic 5.',
    'mautic.core.config.form.update.composer.warning' => 'ACHTUNG: Das Ändern dieser Einstellung kann Ihre Installation beschädigen. Weitere Einzelheiten finden Sie unter %url_start%diese Seite%url_end%.</span>',
    'mautic.core.config.form.update.stability' => 'Update Stability Level',
    'mautic.core.config.form.update.stability.tooltip' => 'Geben Sie das Mindest-Stability Level für Aktualisierungen an.',
    'mautic.core.config.form.webroot' => 'Mautic Root URL',
    'mautic.core.config.form.webroot.dashboard' => 'Mautic Dashboard',
    'mautic.core.config.form.webroot.tooltip' => 'Wählen Sie die Seite, die angezeigt werden soll, wenn Ihre Mautic-Root-URL (z.B. http://your-mautic-site.com/) aufgerufen wird. Lassen Sie das Feld leer, um zum Mautic Dashboard weitergeleitet zu werden.',
    'mautic.core.config.header.cors' => 'CORS-Einstellungen',
    'mautic.core.config.header.defaults' => 'Systemvoreinstellungen',
    'mautic.core.config.header.general' => 'Allgemeine Einstellungen',
    'mautic.core.config.header.misc' => 'Sonstige Einstellungen',
    'mautic.core.config.header.response.headers' => 'Zusätzliche Antwort-Kopfzeilen',
    'mautic.core.config.header.update' => 'Aktualisiere Einstellungen',
    'mautic.core.config.update_stability.alpha' => 'Alpha',
    'mautic.core.config.update_stability.beta' => 'Beta',
    'mautic.core.config.update_stability.rc' => 'Release Candidate',
    'mautic.core.config.update_stability.stable' => 'Stabil',
    'mautic.core.copyright' => '© %date% Mautic. Alle Rechte vorbehalten.',
    'mautic.core.create.by.past.tense' => 'Erstellt von',
    'mautic.core.createnew' => 'Neu erstellen...',
    'mautic.core.created' => 'Erzeugt am',
    'mautic.core.createdby' => 'Erstellt von',
    'mautic.core.current' => 'Jetzt',
    'mautic.core.date.added' => 'hinzugefügt am',
    'mautic.core.date.ago' => 'vor %days% Tagen ',
    'mautic.core.date.day' => 'one: %count% Tag|some: %count% Tage',
    'mautic.core.date.hour' => 'one: %count% Stunde|some: %count% Stunden',
    'mautic.core.date.minute' => 'one: %count% Minute|some: %count% Minuten',
    'mautic.core.date.modified' => 'geändert am',
    'mautic.core.date.month' => 'one: %count% Tag|some: %count% Tage',
    'mautic.core.date.second' => 'one: %count% Sekunden|some: %count% Sekunden',
    'mautic.core.date.today' => 'Heute, %time%',
    'mautic.core.date.tomorrow' => 'Morgen, %time%',
    'mautic.core.date.week' => 'one: %count% Woche|some: %count% Wochen',
    'mautic.core.date.year' => 'one: %count% Jahr|some: %count% Jahre',
    'mautic.core.date.yesterday' => 'Gestern, %time%',
    'mautic.core.date.less.than.second' => 'Weniger als eine Sekunde',
    'mautic.core.db.connection.error' => 'Fehler bei der Verbindung zur Datenbank (Code #%code%)',
    'mautic.core.defaultvalue' => 'Standardwert',
    'mautic.core.description' => 'Beschreibung',
    'mautic.core.details' => 'Details',
    'mautic.core.device' => 'Device',
    'mautic.core.droppable.placeholder' => 'Wählen Sie durch Drag & Drop aus',
    'mautic.core.email.cc.copy' => 'Kopie der E-Mail an %email%',
    'mautic.core.error.403' => 'Ts, Ts. Offensichtlich haben Sie keine Berechtigung für diesen Bereich.',
    'mautic.core.error.404' => 'Tut uns leid! Die Seite konnte nicht gefunden werden.',
    'mautic.core.error.500' => 'Oh oh! Ich glaube ich habe da was falsch gemacht. Bitte dem Administrator melden, wenn das wieder passiert.',
    'mautic.core.error.generic' => 'Es sieht so aus, als ob wir auf einen Fehler gestoßen sind (Fehler #%code%). Bitte melden Sie dies dem Administrator wenn es nochmal passiert. ',
    'mautic.core.error.previousexceptions' => 'Previous Exceptions',
    'mautic.core.filter.categories' => 'Kategorie',
    'mautic.core.filter.clear' => 'Filter zurücksetzen',
    'mautic.core.filter.header' => 'Filter',
    'mautic.core.filter.lists' => 'Segment',
    'mautic.core.filter.themes' => 'Vorlage',
    'mautic.core.filter.tags' => 'Tag',
    'mautic.core.filters' => 'Filter',
    'mautic.core.firstname' => 'Vorname',
    'mautic.core.form.abtest' => 'A/B Test hinzufügen',
    'mautic.core.form.add' => 'Hinzufügen',
    'mautic.core.form.apply' => 'Speichern',
    'mautic.core.form.archive' => 'Archivieren',
    'mautic.core.form.confirmbatchdelete' => 'Löschen der gewählten Elemente?',
    'mautic.core.form.cancel' => 'Abbrechen',
    'mautic.core.form.categories' => 'Filter über Kategorie',
    'mautic.core.form.choosemultiple' => 'Wählen Sie eines oder mehrere...',
    'mautic.core.form.chooseone' => 'Auswählen',
    'mautic.core.form.clone' => 'Duplizieren',
    'mautic.core.form.close' => 'Schließen',
    'mautic.core.form.default' => 'Default',
    'mautic.core.form.delete' => 'Löschen',
    'mautic.core.form.delete_selected' => 'Ausgewählte löschen',
    'mautic.core.form.done' => 'Fertig',
    'mautic.core.form.edit' => 'Ändern',
    'mautic.core.form.expired' => 'Abgelaufen',
    'mautic.core.form.expired_to' => 'Abgelaufen. Senden gestoppt am %date%',
    'mautic.core.form.filters.available' => 'Verfügbar',
    'mautic.core.form.filters.selected' => 'Ausgewählt',
    'mautic.core.form.insert' => 'Einfügen',
    'mautic.core.form.list' => 'Listenwerte',
    'mautic.core.form.list.additem' => 'Einen Wert hinzufügen',
    'mautic.core.form.new' => 'Neu',
    'mautic.core.form.no' => 'Nein',
    'mautic.core.form.nomatches' => 'Keine Ergebnisse gefunden',
    'mautic.core.form.pending' => 'Ausstehend',
    'mautic.core.form.pending.start_at' => 'Ausstehend. Senden wird gestartet am %date%',
    'mautic.core.form.publishdown' => 'Deaktivieren ab (Datum/Uhrzeit)',
    'mautic.core.form.activate_at' => 'Aktivieren ab (Datum/Uhrzeit)',
    'mautic.core.form.public' => 'Öffentlich',
    'mautic.core.form.not.public' => 'Nicht öffentlich',
    'mautic.core.form.reset' => 'Zurücksetzen',
    'mautic.core.form.save' => 'Speichern',
    'mautic.core.form.saveandclose' => 'Speichern & Schließen',
    'mautic.core.form.submit' => 'Absenden',
    'mautic.core.form.thead.filter' => 'Filtern...',
    'mautic.core.form.theme' => 'Vorlage',
    'mautic.core.form.translation_parent' => 'ist die Übersetzung von',
    'mautic.core.form.translation_parent.empty' => 'Wähle das übersetzte Element…',
    'mautic.core.form.translation_parent.help' => 'Wenn es sich bei diesem Artikel um die Übersetzung eines anderen Artikels handelt, wählen Sie den zu übersetzenden Artikel aus, damit er verknüpft wird. Beginnen Sie mit der Eingabe des gewünschten Werts und wählen Sie dann aus der Autovervollständigungsliste aus.',
    'mautic.core.form.uncategorized' => 'Ohne Kategorie',
    'mautic.core.form.update' => 'Aktualisieren',
    'mautic.core.form.yes' => 'Ja',
    'mautic.core.go_to_dashboard' => 'Zum Dashboard',
    'mautic.core.header.edit' => '%name% ändern',
    'mautic.core.header.new' => 'Neuer Eintrag',
    'mautic.core.help.autocomplete' => 'Beginnen Sie mit der Eingabe und wählen Sie aus der Liste.',
    'mautic.core.help.searchcommands' => '<strong>Suchbefehle</strong><br />ids:ID1,ID2 (kommagetrennte IDs, keine Leerzeichen)<br />is:published<br />is:unpublished<br />is:mine<br />is:uncategorized<br />category:{category alias}',
    'mautic.core.icon_tooltip.ab_test' => 'Hat A/B Tests',
    'mautic.core.icon_tooltip.preference_center' => 'Ist eine Abmeldeseite',
    'mautic.core.icon_tooltip.translation' => 'Hat Übersetzungen',
    'mautic.core.id' => 'ID',
    'mautic.core.insert' => 'Einfügen',
    'mautic.core.indexable' => 'Indexierbar',
    'mautic.core.ip_lookup.fetch_data' => 'IP Lookup Daten abrufen',
    'mautic.core.ip_lookup.remote_fetch_error' => 'Das automatische Abrufen der IP Lookup Daten ist fehlgeschlagen. Download unter %remoteUrl%, extrahieren falls nötig und Upload nach %localPath%.',
    'mautic.core.ip_lookup.remote_fetch_error_generic' => 'Das automatische Abrufen der IP Lookup Daten ist fehlgeschlagen.',
    'mautic.core.ip_lookup.update_data' => 'IP Lookup Daten updaten',
    'mautic.core.ip_lookup.last_updated' => 'Letztes Update am %date%',
    'mautic.core.ipaddress' => 'IP Adresse',
    'mautic.core.label' => 'Label',
    'mautic.core.language' => 'Sprache',
    'mautic.core.language.helper.error.fetching.languages' => 'Beim Abrufen der Sprachenliste ist ein Fehler aufgetreten.',
    'mautic.core.lastname' => 'Nachname',
    'mautic.core.email' => 'E-Mail',
    'mautic.core.list.filter' => 'Filter...',
    'mautic.core.loading' => 'Laden...',
    'mautic.core.menu.index' => 'Home',
    'mautic.core.menu.left.collapse' => 'Menü einklappen',
    'mautic.core.modified' => 'Zuletzt geändert',
    'mautic.core.modifiedby' => 'Geändert von',
    'mautic.core.more.hide' => '[ausblenden]',
    'mautic.core.more.show' => '[mehr]',
    'mautic.core.name' => 'Name',
    'mautic.core.never' => 'Niemals',
    'mautic.core.none' => 'Keine',
    'mautic.core.noresults' => 'Keine Ergebnisse! Passen Sie den Filter (wenn vorhanden) an, oder geben Sie einen neuen Filter an. ',
    'mautic.core.noresults.header' => 'Keine Ergebnisse gefunden',
    'mautic.core.noresults.tip' => 'Hallo! Wie wäre es mit einem Tipp?',
    'mautic.core.not_required' => 'Nicht erforderlich',
    'mautic.core.notification.read_more' => '[Weiterlesen]',
    'mautic.core.notifications' => 'Meldungen',
    'mautic.core.notifications.clear' => 'Diese Benachrichtigung zurücksetzen',
    'mautic.core.notifications.clearall' => 'Benachrichtigungen zurücksetzten',
    'mautic.core.now' => 'Jetzt',
    'mautic.core.number' => 'Nummer',
    'mautic.core.operator.between' => 'zwischen',
    'mautic.core.operator.equals' => 'gleich',
    'mautic.core.operator.greaterthan' => 'größer als',
    'mautic.core.operator.greaterthanequals' => 'gleich oder grösser',
    'mautic.core.operator.in' => 'einschließlich',
    'mautic.core.operator.isempty' => 'leer',
    'mautic.core.operator.islike' => 'wie',
    'mautic.core.operator.isnotempty' => 'nicht leer',
    'mautic.core.operator.isnotlike' => 'nicht wie',
    'mautic.core.operator.lessthan' => 'kleiner als',
    'mautic.core.operator.lessthanequals' => 'kleiner als oder gleich',
    'mautic.core.operator.notbetween' => 'nicht zwischen',
    'mautic.core.operator.notequals' => 'nicht gleich',
    'mautic.core.operator.notin' => 'außer',
    'mautic.core.operator.contains' => 'enthält',
    'mautic.core.operator.starts.with' => 'beginnt mit',
    'mautic.core.operator.ends.with' => 'endet mit',
    'mautic.core.optional' => 'Optional',
    'mautic.core.or' => 'oder',
    'mautic.core.order' => 'Sortierung',
    'mautic.core.order.field' => 'Feldreihenfolge',
    'mautic.core.form.available' => 'Verfügbar',
    'mautic.core.order.field.tooltip' => 'Das neue Feld wird oberhalb des selektieren Feldes platziert',
    'mautic.core.override.lock' => '<a href=\'%url%\'>Sperre umgehen</a>',
    'mautic.core.pagination.10' => '10',
    'mautic.core.pagination.100' => '100',
    'mautic.core.pagination.15' => '15',
    'mautic.core.pagination.20' => '20',
    'mautic.core.pagination.25' => '25',
    'mautic.core.pagination.30' => '30',
    'mautic.core.pagination.5' => '5',
    'mautic.core.pagination.50' => '50',
    'mautic.core.pagination.all' => 'Alle',
    'mautic.core.pagination.items' => 'one: %count% Eintrag|some %count% Einträge',
    'mautic.core.pagination.pages' => 'one: %count% Seite|some: %count% Seiten',
    'mautic.core.pagination.total' => 'Gesamthaft',
    'mautic.core.parent' => 'Parent',
    'mautic.core.password' => 'Passwort',
    'mautic.core.permissions.badformat' => 'Die Berechtung muss im Format bundle:permission:level (i.e. user:users:view). \'%permission%\' angegeben werden.',
    'mautic.core.permissions.create' => 'Erzeugen',
    'mautic.core.permissions.delete' => 'Löschen',
    'mautic.core.permissions.deleteother' => 'Andere löschen',
    'mautic.core.permissions.deleteown' => 'Eigene löschen',
    'mautic.core.permissions.edit' => 'Ändern',
    'mautic.core.permissions.editother' => 'Andere ändern',
    'mautic.core.permissions.editown' => 'Eigene ändern',
    'mautic.core.permissions.full' => 'Voll',
    'mautic.core.permissions.manage' => 'Verwalten',
    'mautic.core.permissions.mode.notfound' => 'Der Modus  %mode% for isGranted()  wurde nicht erkannt.',
    'mautic.core.permissions.notfound' => 'Berechtigung nicht gefunden.  \'%permission%\' wurde eingegben.',
    'mautic.core.permissions.publish' => 'Veröffenltichen',
    'mautic.core.permissions.publishother' => 'Andere veröffentlichen',
    'mautic.core.permissions.publishown' => 'Eigene veröffentlichen',
    'mautic.core.permissions.view' => 'Zeigen',
    'mautic.core.permissions.viewother' => 'Andere zeigen',
    'mautic.core.permissions.viewown' => 'Eigene zeigen',
    'mautic.core.permissions.export' => 'Exportzugriff',
    'mautic.core.permissions.enable' => 'Aktiviere',
    'mautic.core.popupblocked' => 'Es sieht so aus, als ob Ihr Browser Popups verhindert. Bitte lassen Sie Popups für diese Webseite zu.',
    'mautic.core.position' => 'Position',
    'mautic.core.signature' => 'Signatur',
    'mautic.core.preview' => 'Vorschau',
    'mautic.core.recent.activity' => 'Letzte Aktivitäten',
    'mautic.core.redo' => 'Erneut',
    'mautic.core.referer' => 'Referer',
    'mautic.core.remove' => 'Entfernen',
    'mautic.core.report_issue' => 'Ein Problem melden',
    'mautic.core.required' => 'Eingabe erforderlich',
    'mautic.core.retry' => 'Wiederholen',
    'mautic.core.search.everything.placeholder' => 'Suche alles...',
    'mautic.core.search.header' => 'Suche Hilfe',
    'mautic.core.search.help' => '<strong>Suchparameter</strong>:<br />+ (plus sign) - exakte Suche (d.h. wenn admin, dann wird administrator nicht gefunden)<br />! (Ausrufezeichen) - ungleich<br />&quot; &quot; (doppeltes Hochkomma) - Suchbegriffe<br />( ) (Klammern) - Ausdrücke verknüpfen.<br />OR - Ausdrücke werden per AND verknüpft. Verwenden Sie OR um das zu ändernt.<br />% - Verwenden Sie% als Platzhalter, um nach bestimmten Namen oder Werten in einer Phrase zu suchen (d. H. Um alle Unternehmen mit dem Wort "Technologien" zu finden, geben Sie% technologies% ein.)<br />',
    'mautic.core.search.livesearch' => 'Zeichen eingeben oder Enter',
    'mautic.core.search.more' => '%count% weiter...',
    'mautic.core.search.placeholder' => 'Filter...',
    'mautic.core.search.results' => 'Suchergebnisse',
    'mautic.core.searchcommand.category' => 'Kategorie',
    'mautic.core.searchcommand.email' => 'E-Mail',
    'mautic.core.searchcommand.ip' => 'ip',
    'mautic.core.searchcommand.isactive' => 'is:aktiv',
    'mautic.core.searchcommand.isinactive' => 'is:inaktiv',
    'mautic.core.searchcommand.ismine' => 'is:mein',
    'mautic.core.searchcommand.ispublished' => 'is:veröffentlicht',
    'mautic.core.searchcommand.isuncategorized' => 'is:nicht kategorisiert',
    'mautic.core.searchcommand.isunpublished' => 'is:nicht veröffentlicht',
    'mautic.core.searchcommand.lang' => 'lang',
    'mautic.core.searchcommand.name' => 'Name',
    'mautic.core.searchcommand.ids' => 'IDs',
    'mautic.core.select' => 'Auswählen',
    'mautic.core.settings' => 'Einstellungen',
    'mautic.core.source' => 'Quelle',
    'mautic.core.stats' => 'Statistik',
    'mautic.core.success' => 'Erfolgreich!',
    'mautic.core.system' => 'System',
    'mautic.core.table.selectall' => 'Alle auswhlen',
    'mautic.core.time.days' => 'Tage',
    'mautic.core.time.days_numbered' => 'vor %days% Tagen ',
    'mautic.core.time.hours' => 'Stunden',
    'mautic.core.time.hour' => 'Stunde',
    'mautic.core.time.minutes' => 'Minuten',
    'mautic.core.time.months' => 'Monate',
    'mautic.core.time.seconds' => 'Sekunden',
    'mautic.core.time.weeks' => 'Wochen',
    'mautic.core.time.years' => 'Jahre',
    'mautic.core.time.unit' => 'Zeiteinheit',
    'mautic.core.timeframe.daily' => 'Täglich',
    'mautic.core.timeframe.hourly' => 'Stündlich',
    'mautic.core.timeframe.monthly' => 'Monatlich',
    'mautic.core.timeframe.weekly' => 'Wöchentlich',
    'mautic.core.timeframe.yearly' => 'Jährlich',
    'mautic.core.timeline.device.granularity' => 'Device Granularität',
    'mautic.core.timeline.device.client.info' => 'Kunden Info:',
    'mautic.core.timeline.device.name' => 'Device Name:',
    'mautic.core.timeline.device.os' => 'Device Betriebssystem:',
    'mautic.core.timeline.device.brand' => 'Device Marke:',
    'mautic.core.timeline.device.model' => 'Device Modell:',
    'mautic.core.timeline.event.time' => 'Am %date%, %event%.',
    'mautic.core.timeline.event.scheduled.time' => 'Ausführung geplant am %date%',
    'mautic.core.timezone' => 'Zeitzone',
    'mautic.core.title' => 'Titel',
    'mautic.core.translations' => 'Übersetzungen',
    'mautic.core.translation_of' => 'Übersetzung von %parent%',
    'mautic.core.type' => 'Typ',
    'mautic.core.type.date' => 'Datum',
    'mautic.core.type.datetime' => 'Datum/Uhrzeit',
    'mautic.core.type.boolean' => 'Boolean',
    'mautic.core.type.country' => 'Wähle: Land',
    'mautic.core.type.email' => 'E-Mail',
    'mautic.core.type.number' => 'Nummer',
    'mautic.core.type.select' => 'Wähle: Einfache Auswahl',
    'mautic.core.type.tel' => 'Telefon',
    'mautic.core.type.text' => 'Text: kurze Antwort',
    'mautic.core.type.url' => 'URL',
    'mautic.core.type.time_format' => 'Zeitformat',
    'mautic.core.undo' => 'Rückgängig',
    'mautic.core.unknown' => 'Unbekannt',
    'mautic.core.update.aborted' => 'Update abgebrochen.',
    'mautic.core.update.announcement' => 'Ankündigung',
    'mautic.core.update.archive_could_not_open' => 'Konnte die ZIP-Datei nicht öffnen',
    'mautic.core.update.archive_file_exists' => 'Das Verzeichnis existiert bereits. Bitte kontrollieren Sie das Cache-Verzeichnis und löschen Sie alle Installationsverzeichnisse.',
    'mautic.core.update.archive_no_such_file' => 'Das ZIP Archiv ist nicht vorhanden.',
    'mautic.core.update.archive_not_valid_zip' => 'Das ist kein gültiges ZIP-Archiv. Bitte überprüfen Sie das Cache-Verzeichnis, löschen Sie das Paket und versuchen Sie es erneut.',
    'mautic.core.update.archive_zip_corrupt' => 'Das ZIP-Archiv ist wahrscheinlich defekt. Bitte überprüfen Sie das Cache-Verzeichnis, löschen Sie das Paket und versuchen Sie es erneut.',
    'mautic.core.update.archive_failed_to_extract' => 'Das Extrahieren der Dateien ist fehlgeschlagen.',
    'mautic.core.update.available' => 'Es gibt eine neue Version',
    'mautic.core.update.backup_warning' => 'Es wird SEHR EMPFOHLEN, die Dateien und Datenbank vor dem Update zu sichern.',
    'mautic.core.update.by.past.tense' => 'Aktualisiert von',
    'mautic.core.update.clear.cache' => 'Cache löschen',
    'mautic.core.update.confirm_application_update' => 'Sind Sie sicher, dass Sie Mautic auf die neueste Version aktualisieren möchten?',
    'mautic.core.update.current.version' => 'aktuelle Version',
    'mautic.core.update.check.error' => 'Bei der Vorab-Prüfung für das Mautic Update sind ein oder mehrere Fehler in der Umgebung gefunden worden:',
    'mautic.core.update.check.error.release_data' => 'Beim Vorbereiten der Überprüfungen vor dem Update sind ungültige oder unvollständige Versionsinformationen eingegangen. Dies kann ein vorübergehender Fehler sein. Bitte versuchen Sie es erneut.',
    'mautic.core.update.check.phpversion' => 'Ihre PHP-Version ist zu alt oder zu neu, um von Mautic aktualisiert zu werden. Sie verwenden derzeit PHP %currentversion%. Bitte stellen Sie sicher, dass Ihre Version zwischen %lowestversion% und %highestversion% liegt.',
    'mautic.core.update.check.database_driver' => 'Ihr Datenbanktreiber (%currentdriver%) wird nicht unterstützt. Es muss einer von %supporteddrivers% sein.',
    'mautic.core.update.check.database_version' => 'Ihre Datenbankversion (%currentversion%) ist zu alt, damit Mautic richtig funktioniert. Unterstützte Versionen sind MySQL %mysqlminversion% (oder höher) und MariaDB %mariadbminversion% (oder höher).',
    'mautic.core.update.error' => 'Die Aktualisierung von Mautic ist fehlgeschlagen: %error%',
    'mautic.core.update.error_extracting_package' => 'Konnte die Inhalte der ZIP-Datei nicht in das Verzeichnis extrahieren.',
    'mautic.core.update.error_performing_migration' => 'Bei der Aktualisierung der Datenbank ist ein Fehler aufgetreten. Mehr Informationen finden Sie in den Logs.',
    'mautic.core.update.error_updating_language' => 'Konnte die Sprache \'%language%\' nicht aktualisieren.',
    'mautic.core.update.error.removing.file' => 'Beim Entfernen der Datei unter %path% ist ein Fehler aufgetreten. Sie können diese Datei manuell entfernen, da sie nicht mehr benötigt wird.',
    'mautic.core.update.heading.status' => 'Status',
    'mautic.core.update.heading.step' => 'Schritt',
    'mautic.core.update.in.progress' => 'Mautic wird aktualisiert',
    'mautic.core.update.index' => 'Mautic aktualisieren',
    'mautic.core.update.migrating.database.schema' => 'Migriere das Datenbankschema...',
    'mautic.core.update.no_cache_data' => 'Konnte die Aktualisierung im Cache nicht lesen',
    'mautic.core.update.now' => 'Jetzt aktualisieren',
    'mautic.core.update.composer' => 'Sie haben Composer-Updates aktiviert. Das bedeutet, dass Sie Mautic nur über die Befehlszeile aktualisieren können. Weitere Informationen finden Sie in der <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>Dokumentation</a>.',
    'mautic.core.update.ui.deprecated' => 'Die Aktualisierung von Mautic über die Benutzeroberfläche ist veraltet und wird in Mautic 5.0 nicht mehr unterstützt. Weitere Informationen und Hinweise, wie Sie sich vorbereiten können, finden Sie in der <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>Dokumentation</a>.',
    'mautic.core.update.post_message' => 'Meldung nach dem Update',
    'mautic.core.update.remove.deleted.files' => 'Gelöschte Dateien entfernen',
    'mautic.core.update.schema_updated' => 'Das Datenbank-Schema wurde aktualisiert.',
    'mautic.core.update.schema_uptodate' => 'Das Datenbank-Schema ist bereits auf dem neusten Stand.',
    'mautic.core.update.step.downloading.package' => 'Package wird runtergeladen',
    'mautic.core.update.step.extracting.package' => 'Package wird extrahiert',
    'mautic.core.update.step.failed' => 'Fehlgeschlagen',
    'mautic.core.update.step.finalizing' => 'Update abschließen',
    'mautic.core.update.step.in.progress' => 'In Bearbeitung',
    'mautic.core.update.step.moving.package' => 'Package wird übertragen',
    'mautic.core.update.step.running.checks' => 'Ausführen von Prüfungen vor der Aktualisierung',
    'mautic.core.update.step.success' => 'Erfolg',
    'mautic.core.update.update_successful' => 'Erfolg! Sie verwenden nun Mautic %version%.',
    'mautic.core.update.upgrade.version' => 'Version aktualisieren',
    'mautic.core.updater.cli.update' => 'Geben Sie \'php bin/console mautic:update:apply\' in die Kommandozeile ein, um das Update durchzuführen.',
    'mautic.core.updater.error.fetching.package' => 'Ein Fehler ist beim Download der Update Pakete aufgetaucht.',
    'mautic.core.updater.error.fetching.updates' => 'Ein Fehler ist beim Prüfen auf Aktualisierungen aufgetaucht. Bitte probieren Sie es später nochmal.',
    'mautic.core.updater.running.latest.version' => 'Sehr gut! Sie verwenden die aktuellste Version von Mautic.',
    'mautic.core.updater.update.available' => 'Version %version% von Mautic ist zum Download bereit. Weitere Informationen finden Sie hier: %announcement%.',
    'mautic.core.updater.update.announcement_link' => '<a class=\'alert-link\' href=\'%announcement%\' target=\'_new\'>diese Ankündigung</a>',
    'mautic.core.url.error.401' => 'Unbefugter Zugriff auf die URL: %url%',
    'mautic.core.url.error.404' => 'Die URL wurde nicht gefunden: %url%',
    'mautic.core.url.uncategorized' => 'nicht kategorisiert',
    'mautic.core.username' => 'Benutzername',
    'mautic.core.value' => 'Wert',
    'mautic.core.variant.misconfiguration' => 'Es gibt ein Problem mit der Konfiguration der Varianten. Stellen Sie bitte sicher, dass alle Varianten mit dem selben Sieger-Kriterium konfiguriert sind und dass die Summe der Gewichtung nicht größer ist als 100.',
    'mautic.core.variant_of' => 'Variante von %parent%',
    'mautic.core.variant_start_date' => 'A/B Test gestartet am %date% um %time%',
    'mautic.core.variants' => 'Varianten',
    'mautic.core.wait' => 'Bitte warten...',
    'mautic.core.configuration.value.not.set' => 'Ein Wert in der Konfiguration ist nicht richtig gesetzt.',
    'mautic.core.dashboard.widgets' => 'Core Widgets',
    'mautic.core.date.from' => 'Von',
    'mautic.core.date.to' => 'To',
    'mautic.core.padding.top' => 'Innenabstand oben',
    'mautic.core.padding.bottom' => 'Innenabstand unten',
    'mautic.core.button.border.radius' => 'Ecken-Radius',
    'mautic.core.button.link' => 'Schaltflächen-Link',
    'mautic.core.button.size' => 'Schaltflächen-Größe',
    'mautic.core.button.position' => 'Schaltflächen-Position',
    'mautic.core.button.text' => 'Schaltflächen-Text',
    'mautic.core.caption.position' => 'Position des Titels',
    'mautic.core.image.position' => 'Position des Bildes',
    'mautic.core.image.caption' => 'Titel des Bildes',
    'mautic.core.twitter.url' => 'Twitter URL',
    'mautic.core.facebook.url' => 'Facebook URL',
    'mautic.core.caption.color' => 'Beschriftung Hintergrundfarbe',
    'mautic.core.background.color' => 'Hintergrundfarbe',
    'mautic.core.content.background.color' => 'Hintergrundfarbe des Inhalts',
    'mautic.core.content.background.image' => 'Hintergrundbild des Inhalts',
    'mautic.core.content.background.repeat' => 'Inhalts-Hintergrund wiederholen',
    'mautic.core.content.background.size' => 'Inhalts Hintergrundgröße (Breite Höhe | \'Abdeckung\' | \'enthalten\')',
    'mautic.core.content.background.position' => 'Inhalts-Hintergrund Position (horizontal, vertikal)',
    'mautic.core.continue' => 'Weiter',
    'mautic.core.wrapper.background.color' => 'Wrapper Hintergrundfarbe',
    'mautic.core.wrapper.background.image' => 'Wrapper Hintergrundbild',
    'mautic.core.wrapper.background.repeat' => 'Wrapper Hintergrund wiederholen',
    'mautic.core.wrapper.background.size' => 'Wrapper Hintergrundgröße (Breite Höhe | \'Abdeckung\' | \'enthalten\')',
    'mautic.core.wrapper.background.position' => 'Wrapper Hintergrund Position (horizontal, vertikal)',
    'mautic.core.text.color' => 'Textfarbe',
    'mautic.core.slot.types' => 'Aussparungstypen',
    'mautic.core.section.types' => 'Abschnittstypen',
    'mautic.core.separator.color' => 'Trennfarbe',
    'mautic.core.separator.thickness' => 'Dicke des Separators',
    'mautic.core.drag.info' => 'Ziehe den Typ an die gewünschte Position',
    'mautic.core.customize.slot' => 'Aussparung anpassen',
    'mautic.core.customize.section' => 'Bereich anpassen',
    'mautic.core.slot.customize.info' => 'Wählen Sie die zu bearbeitende Aussparung aus',
    'mautic.core.section.customize.info' => 'Wählen Sie den zu bearbeitenden Bereich aus',
    'mautic.core.left' => 'Links',
    'mautic.core.right' => 'Rechts',
    'mautic.core.center' => 'Zentriert',
    'mautic.core.no.info' => 'nicht verfügbar',
    'mautic.widget.recent.activity' => 'Letzte Aktivitäten',
    'mautic.theme.menu.index' => 'Vorlagen',
    'mautic.core.themes' => 'Vorlagen',
    'mautic.core.features' => 'Features',
    'mautic.core.theme.install' => 'Installieren',
    'mautic.core.permissions.themes' => 'Vorlagen welche der Nutzer benutzen darf',
    'mautic.core.permissions.header' => 'Zentrale Berechtigungen',
    'mautic.core.theme.form.confirmdelete' => 'Möchten Sie die Vorlage %theme% löschen?',
    'mautic.core.theme.form.confirmbatchdelete' => 'Die ausgewählten Vorlagen löschen?',
    'mautic.theme.noresults.tip' => 'Vorlagen erlauben es Ihnen, einfach und schnell die Struktur und das Aussehen Ihrer E-Mails, Formulare und Abmelde-E-Mails festzulegen.',
    'mautic.core.download' => 'Download',
    'mautic.core.theme.feature.page' => 'Seite',
    'mautic.core.theme.feature.email' => 'E-Mail',
    'mautic.core.theme.feature.form' => 'Formular',
    'mautic.maintenance.audit_log' => 'Audit-Log-Einträge',
    'mautic.maintenance.notifications' => 'Benutzer Benachrichtigung',
    'mautic.maintenance.user_tokens' => 'Benutzertoken',
    'mautic.maintenance.confirm_data_purge' => 'Dadurch werden Daten, die älter als %days% Tage sind, dauerhaft gelöscht! Bitte machen Sie eine Sicherungskopie, bevor Sie fortfahren. Führen Sie diesen Befehl mit --dry-run aus, um die ungefähren Datensätze zu erhalten, die gelöscht werden sollen. Fortsetzen? (y/n)',
    'mautic.maintenance.header.key' => 'Eintrags-Art',
    'mautic.maintenance.header.records_affected' => 'betroffene Datensätze ',
    'mautic.maintenance.header.query' => 'Such-Details',
    'mautic.core.code.mode' => 'Code-Modus',
    'mautic.core.code.mode.placeholder' => 'Platzieren Sie hier Ihren Inhalt',
    'mautic.core.format.code' => 'Code formatieren',
    'mautic.core.format.code.desc' => 'Diese Option optimiert die Formatierung Ihres Codes.',
    'mautic.core.media.manager' => 'Medien-Verwaltung',
    'mautic.core.media.manager.desc' => 'Öffnet ein neues Fenster mit der Medien-Verwaltung, wo Sie eine neue Datei hochladen können. Wenn eine Datei ausgewählt wird, wird die URL an der Cursor-Position eingefügt.',
    'mautic.core.code.mode.token.dropdown.hint' => 'Hinweis: Drücken Sie <b>STRG</b> + <b>LEERTASTE</b> um die Auswahl anzuzeigen',
    'mautic.core.export' => 'Export',
    'mautic.core.export.csv' => 'CSV-Export',
    'mautic.core.export.xlsx' => 'Excel-Export',
    'mautic.core.export.items' => 'Ausgewählte %items% exportieren?',
    'mautic.core.dynamicContent' => 'Dynamischer Inhalt',
    'mautic.core.dynamicContent.token_name' => 'Name',
    'mautic.core.dynamicContent.tab' => 'Variation',
    'mautic.core.dynamicContent.default_content' => 'Standard-Inhalt',
    'mautic.core.dynamicContent.alt_content' => 'Inhalt',
    'mautic.core.form.builder.error' => 'Es gibt einige Fehler bei der Formularprüfung (%error%) Bitte schließen Sie den Builder und beheben Sie sie.',
    'mautic.error.invalid.export.type' => 'Ungültiger Exporttyp "%type%" Muss "csv" oder "xlsx" sein.',
    'mautic.core.send.email.to.multiple.addresses' => 'Mehrere E-Mail-Adressen mit Komma trennen',
    'mautic.core.send.email.to' => 'To',
    'mautic.core.send.email.cc' => 'CC',
    'mautic.core.send.email.bcc' => 'BCC',
    'mautic.core.slot.label.text' => 'Text',
    'mautic.core.slot.label.text.insert' => 'Fügen Sie hier Text ein',
    'mautic.core.slot.label.image' => 'Bild',
    'mautic.core.slot.label.imagecard' => 'Image Card',
    'mautic.core.slot.label.imagecaption' => 'Bild+Bildunterschrift',
    'mautic.core.slot.label.button' => 'Button',
    'mautic.core.slot.label.socialshare' => 'Teilen in sozialen Medien',
    'mautic.core.slot.label.socialfollow' => 'Folgen in sozialen Medien',
    'mautic.core.slot.label.segmentlist' => 'Liste der Segmente',
    'mautic.core.slot.label.categorylist' => 'Liste der Kategorien',
    'mautic.core.slot.label.preferredchannel' => 'Bevorzugter Channel',
    'mautic.core.slot.label.channelfrequency' => 'Channel Frequenz',
    'mautic.core.slot.label.saveprefsbutton' => 'Präferenzen speichern',
    'mautic.core.slot.label.successmessage' => 'Erfolgsmeldung',
    'mautic.core.slot.label.successmessage.insert' => 'Einstellungen gespeichert.',
    'mautic.core.slot.label.codemode' => 'Code-Modus',
    'mautic.core.slot.label.separator' => 'Separator',
    'mautic.core.slot.label.gatedvideo' => 'Video',
    'mautic.core.slot.label.dynamiccontent' => 'Dynamischer Inhalt',
    'mautic.core.slot.label.onecolumn' => 'Eine Spalte',
    'mautic.core.slot.label.twocolumns' => 'Zwei Spalten',
    'mautic.core.slot.label.threecolumns' => 'Drei Spalten',
    'mautic.core.yes' => 'Ja',
    'mautic.core.no' => 'Nein',
    'mautic.core.daterange.0days' => 'Heutige Tag',
    'mautic.core.daterange.1days' => 'Letzte 24 Stunden',
    'mautic.core.daterange.week' => '1 Woche|%count% Wochen',
    'mautic.core.daterange.month' => '1 Monat|%count% Monate',
    'mautic.core.daterange.year' => '1 Jahr|%count% Jahre',
    'mautic.core.config.form.default.daterange_default' => 'Datumsbereich Filter Standard',
    'mautic.core.config.form.default.daterange_default.tooltip' => 'Der Standardbereich, um bei allen Datumsfiltern vom aktuellen Datum/Uhrzeit zurückzukehren. Dies wird durch die zuletzt verwendeten Werte der aktuellen Benutzersitzung überschrieben',
    'mautic.core.do_not_sell.remote_fetch_error' => 'Das automatische Abrufen der „Do Not Sell“-Daten ist fehlgeschlagen. Laden Sie %remoteUrl% herunter, extrahieren Sie es bei Bedarf und laden Sie es in %localPath% hoch.',
    'mautic.core.do_not_sell.remote_fetch_error_generic' => 'Das automatische Abrufen der „Do Not Sell“-Daten ist fehlgeschlagen.',
    'mautic.core.date.monday' => 'Montag',
    'mautic.core.date.tuesday' => 'Dienstag',
    'mautic.core.date.wednesday' => 'Mittwoch',
    'mautic.core.date.thursday' => 'Donnerstag',
    'mautic.core.date.friday' => 'Freitag',
    'mautic.core.date.saturday' => 'Samstag',
    'mautic.core.date.sunday' => 'Sonntag',
    'mautic.core.date.mon' => 'Mo.',
    'mautic.core.date.tue' => 'Di.',
    'mautic.core.date.wed' => 'Mi.',
    'mautic.core.date.thu' => 'Do.',
    'mautic.core.date.fri' => 'Fr.',
    'mautic.core.date.sat' => 'Sa.',
    'mautic.core.date.sun' => 'So.',
    'mautic.core.date.january' => 'Januar',
    'mautic.core.date.february' => 'Februar',
    'mautic.core.date.march' => 'März',
    'mautic.core.date.april' => 'April',
    'mautic.core.date.may' => 'Mai',
    'mautic.core.date.june' => 'Juni',
    'mautic.core.date.july' => 'Juli',
    'mautic.core.date.august' => 'August',
    'mautic.core.date.september' => 'September',
    'mautic.core.date.october' => 'Oktober',
    'mautic.core.date.november' => 'November',
    'mautic.core.date.december' => 'Dezember',
    'mautic.core.date.jan' => 'Jan',
    'mautic.core.date.feb' => 'Feb',
    'mautic.core.date.mar' => 'März',
    'mautic.core.date.apr' => 'Apr',
    'mautic.core.date.jun' => 'Jun',
    'mautic.core.date.jul' => 'Jul',
    'mautic.core.date.aug' => 'Aug',
    'mautic.core.date.sep' => 'Sep',
    'mautic.core.date.oct' => 'Okt',
    'mautic.core.date.nov' => 'Nov',
    'mautic.core.date.dec' => 'Dez',
    'mautic.error.invalid.specific.export.type' => 'Ungültiger Exporttyp „%type%“. Muss vom Typ „%expected_type%“ sein.',
    'mautic.core.usage.not_found' => 'Es sieht so aus, als ob diese Komponente nicht verwendet wird.',
    'mautic.report.group.audit.log' => 'Audit-Log',
    'mautic.core.audit_log' => 'Audit-Log',
    'mautic.audit_log.report.user_id' => 'Benutzer ID',
    'mautic.audit_log.report.user_name' => 'Benutzername',
    'mautic.audit_log.report.bundle' => 'Paket',
    'mautic.audit_log.report.object' => 'Objekt',
    'mautic.audit_log.report.object_id' => 'Objekt ID',
    'mautic.audit_log.report.action' => 'Aktion',
    'mautic.audit_log.report.details' => 'Details',
    'mautic.audit_log.report.date_added' => 'hinzugefügt am',
    'mautic.audit_log.report.ip_address' => 'IP-Adresse',
    'mautic.core.optimistic_lock.changed_by_someone_else_error' => 'Der Datensatz, den Sie aktualisieren, wurde inzwischen von jemand anderem geändert. Bitte aktualisieren Sie das Browserfenster und senden Sie Ihre Änderungen erneut ab.',
    'mautic.core.theme.hide' => 'Verstecken',
    'mautic.core.theme.unhide' => 'Verfügbar machen',
    'mautic.core.theme.form.confirm.hide' => 'Verstecke die Vorlage %theme%?',
    'mautic.core.theme.form.confirm.unhide' => 'Mache die Vorlage %theme% verfügbar?',
    'mautic.campaign.plugin.leadpush' => 'Kontakt weitergeben',
    'mautic.integration.error' => '%name% Fehler',
    'mautic.integration.error.generic_contact_name' => 'Kontakt ID# %id%',
    'mautic.integration.form.feature.login_button' => 'Login Button',
    'mautic.integration.form.feature.sso_service' => 'Single Sign-On - Dienst-Authentifizierung',
    'mautic.integration.form.feature.sso_form' => 'Single Sign-On - Formular-Authentifizierung',
    'mautic.integration.keyfield.username' => 'Benutzername',
    'mautic.integration.keyfield.password' => 'Passwort',
    'mautic.integration.companyfield_matches' => 'Weisen Sie den lokalen Unternehmensfeldern verfügbare Integrationsfelder zu.',
    'mautic.integration.sso.auto_create_user' => 'Lokalen Benutzer automatisch anlegen?',
    'mautic.integration.sso.auto_create_user.tooltip' => 'Wenn der Benutzer authentifiziert wird und lokal nicht existiert, wird ein neuer Benutzer angelegt.',
    'mautic.integration.sso.new_user_role' => 'Rolle des anzulegenden Benutzers',
    'mautic.integration.sso.new_user_role.tooltip' => 'Geben Sie die Rolle an, der ein neu angelegter Benutzer zugewiesen werden soll.',
    'mautic.plugin.actions' => 'Zusatzmodul-Aktionen',
    'mautic.plugin.actions.facebookLogin' => 'Facebook Login',
    'mautic.plugin.actions.push_lead' => 'Kontakt an Integration weitergeben',
    'mautic.plugin.actions.social_share' => 'Share-Icons für soziale Netzwerke',
    'mautic.plugin.actions.social_share_tooltip' => 'Fügt dem Formular Icons für soziale Netzwerke hinzu',
    'mautic.plugin.actions.twitterLogin' => 'Twitter Login',
    'mautic.plugin.command.fetch.leads' => 'Befehl zum Abrufen von Kontakten aus der Integration',
    'mautic.plugin.command.fetch.leads.starting' => 'Der Befehl "Kontakte abrufen" wird gestartet',
    'mautic.plugin.command.fetch.contacts.starting' => 'Kontakte abrufen',
    'mautic.plugin.command.fetch.leads.events_executed' => 'Anzahl der abgerufenen Leads/Kontakte: %events%',
    'mautic.plugin.command.fetch.leads.events_executed_breakout' => '%updated% Kontakte wurden aktualisiert und %created% Kontakte wurden erstellt',
    'mautic.plugin.command.fetch.companies.events_executed' => 'Anzahl der abgerufenen Unternehmen: %events%',
    'mautic.plugin.command.fetch.companies.events_executed_breakout' => '%updated% Unternehmen wurden aktualisiert und %created% Unternehmen wurden erstellt',
    'mautic.plugin.command.push.leads.events_executed' => 'Anzahl der verarbeiteten Kontakte: %events%',
    'mautic.plugin.form.add.fields' => 'Ein Feld hinzufügen',
    'mautic.plugin.plugins' => 'Plugins',
    'mautic.plugin.help.searchcommands' => '<strong>Suchbefehle</strong><br />is:published<br />is:unpublished',
    'mautic.plugin.integration.tab.details' => 'Aktiviert/Auth',
    'mautic.plugin.integration.tab.features' => 'Features',
    'mautic.plugin.integration.tab.fieldmapping' => 'Zuordnung der Kontakte',
    'mautic.plugin.integration.tab.companyfieldmapping' => 'Zuordnung der Unternehmen',
    'mautic.plugin.manage.plugins' => 'Plugins verwalten',
    'mautic.plugin.permissions.plugins' => 'Plugins, auf die der Nutzer Zugriff hat',
    'mautic.plugin.permissions.header' => 'Plugin Berechtigungen',
    'mautic.plugin.point.action' => 'Addon Trigger',
    'mautic.plugin.reload.plugins' => 'Plugins installieren/aktualisieren',
    'mautic.plugin.reload.plugins.tooltip' => 'Laden Sie das Plugin per FTP oder mit einem anderen Protokoll in das Plugin Verzeichnis und klicken Sie dann den Button zum Installieren/Aktualisieren.',
    'mautic.integration.form.feature.get_leads' => 'Kontakte und / oder Unternehmen aus der Integration ziehen',
    'mautic.plugin.command.push.leads.activity' => 'Drücken Sie die Aktivitätszeitleiste auf %integration% Mautic Objekt',
    'mautic.plugin.command.fetch.companies' => 'Unternehmen abrufen',
    'mautic.plugin.command.fetch.companies.starting' => 'Der Befehl "Unternehmen abrufen" wird gestartet',
    'mautic.plugin.command.pushing.leads' => 'Aktualisieren / Erstellen von Leads von Mautic zu %integration%',
    'mautic.plugin.command.fetch.pushing.leads.events_executed' => 'Anzahl der gepushten Kontakte: %updated% aktualisiert, %created% erstellt, %errored% waren fehlerhaft und%ignored% wurden ignoriert (wahrscheinlich Duplikate oder stimmten nicht mit Feldkriterien überein)',
    'mautic.plugins.integration.fields' => 'Integrationsfelder',
    'mautic.plugins.mautic.direction' => 'Richtung',
    'mautic.plugins.mautic.fields' => 'Mautic Felder',
    'mautic.plugin.direction.data.update' => 'Wählen Sie die Richtung der Datenaktualisierung aus',
    'mautic.integration.form.feature.push_leads' => 'Kontakte und / oder Firmen zu dieser Integration pushen',
    'mautic.plugin.integration.campaign_members' => 'Integrations Kampagnen Mitglieder',
    'mautic.plugin.integration.contact.timeline.link' => 'Zeitleisten-Link des Kontakts',
    'mautic.plugin.integration.campaigns' => 'Kontakte an diese Integrationskampagne weitergeben',
    'mautic.plugin.config.campaign.member.chooseone' => 'Wählen Sie eine Kampagne aus, in der Kontakte eingefügt werden',
    'mautic.plugin.integration.campaigns.member.status' => 'Kampagnen Mitgliedsstatus',
    'mautic.integrations.blanks' => 'Leere Werte aktualisieren',
    'mautic.integrations.form.blanks' => 'Dadurch werden leere Werte unabhängig von der Datenpriorität sowohl für Integration als auch für Mautic aktualisiert.',
    'mautic.plugin.command.notauthorized' => '%s ist nicht autorisiert',
    'mautic.plugin.integration.contact.donotcontact.email' => 'Nicht per E-Mail kontaktieren',
    'mautic.plugin.command.pushing.companies' => 'Aktualisierung / Gründung von Unternehmen von Mautic auf %integration%',
    'mautic.plugin.command.fetch.pushing.companies.events_executed' => 'Anzahl der gepushten Kontakte: %updated% aktualisiert, %created% erstellt, %errored% waren fehlerhaft und%ignored% wurden ignoriert (wahrscheinlich Duplikate oder stimmten nicht mit Feldkriterien überein)',
    'mautic.integrations.update.dnc.by.date' => 'Verwenden Sie den neuesten aktualisierten Datensatz "Nicht kontaktieren"',
    'mautic.integrations.form.update.dnc.by.date.label' => 'Wählen Sie diese Option aus, wenn Sie das "Nicht kontaktieren"-Feld gemäss dem letzten Update auf irgendeinem der Systeme aktualisieren möchten.',
  ),
  'flashes' => 
  array (
    'mautic.company.batch_companies_affected' => '{0} 0 Unternehmen betroffen|{1} 1 Unternehmen betroffen|]1,Inf[ %count% Unternehmen betroffen',
    'mautic.stage.error.notfound' => 'Die Phasen-Aktion mit der ID %id% wurde nicht gefunden.',
    'mautic.stage.notice.batch_deleted' => '%count% Phasen-Aktionen wurden gelöscht.',
    'mautic.sms.notice.batch_deleted' => '%count% Textnachrichten wurden gelöscht!',
    'mautic.sms.error.notfound' => 'Keine SMS mit ID %id% gefunden!',
    'mautic.user.account.notice.updated' => 'Ihr Account wurde aktualisiert.',
    'mautic.user.auth.error.disabledaccount' => 'Ihr Account wurde gesperrt. Bitte kontaktieren Sie den Seitenadministrator.',
    'mautic.user.auth.error.invalidlogin' => 'Falsches Login. Bitte überprüfen Sie Ihre Eingabe.',
    'mautic.user.role.error.deletenotallowed' => '%name% kann nicht gelöscht werden, da noch Benutzer zugeordnet sind.',
    'mautic.user.role.error.notfound' => 'Die Rolle mit der ID <strong>%id%</strong> wurde nicht gefunden.',
    'mautic.user.role.notice.batch_deleted' => '%count% Rollen wurden gelöscht!',
    'mautic.user.user.error.cannotdeleteself' => 'Sie können sich nicht selber löschen.',
    'mautic.user.user.error.notfound' => 'Es gibt keinen Benutzer mit der ID <strong>%id%</strong>.',
    'mautic.user.auth.error.weakpassword' => 'Ihr Passwort ist zu schwach. Bitte setzen Sie es zurück.',
    'mautic.user.user.notice.batch_deleted' => '%count% Benutzer wurden gelöscht!',
    'mautic.user.user.notice.messagesent' => 'Ihre Nachricht an %name% wurde verschickt.',
    'mautic.user.user.notice.passwordreset' => 'Ein neues Passwort wurde generiert und wird Ihnen per E-Mail zugeschickt, sofern dieser Benutzer existiert. Wenn Sie es nicht innerhalb weniger Minuten erhalten, überprüfen Sie Ihren Spam-Ordner und/oder wenden Sie sich an den Systemadministrator.',
    'mautic.user.user.notice.passwordreset.success' => 'Wenn dieser Benutzer existiert, haben Sie Ihr Passwort erfolgreich zurückgesetzt. Sie können sich jetzt anmelden.',
    'mautic.user.user.notice.passwordreset.error' => 'Ein unerwarteter Fehler ist aufgetreten beim Versenden der Anweisungen zum Rücksetzen des Passworts an Ihre E-Mail-Adresse. Bitte versuchen Sie es später erneut.',
    'mautic.user.user.notice.passwordreset.missingtoken' => 'Der Sicherheitstoken zu Ihrer Anfrage fehlt. Bitte klicken Sie den Link in der E-Mail.',
    'mautic.dashboard.notice.save' => 'Dashboard \'%Aufnahme%\'\' ist gesichert. Alle Aufnahmen anzeigen.',
    'mautic.dashboard.error.save' => 'Die Dashboard-Aufnahme konnte aufgrund von %msg% nicht gespeichert werden',
    'mautic.category.error.notfound' => 'Eine Seitenkategorie mit der Id %is% existiert nicht!',
    'mautic.category.notice.batch_deleted' => '%count% Kategorien sind entfernt werden!',
    'mautic.category.notice.created' => '<strong>%name% (%id%)</strong> wurde angelegt!',
    'mautic.category.notice.updated' => '<strong>%name%</strong> wurde aktualisiert!',
    'mautic.focus.error.notfound' => 'Das angeforderte Focus Item wurde nicht gefunden.',
    'mautic.focus.notice.batch_deleted' => 'Focus Items erfolgreich gelöscht.',
    'mautic.report.report.error.notfound' => 'Ein Report mit der ID %id% wurde nicht gefunden!',
    'mautic.report.report.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_report_index\'><strong>%name%</strong></a> ist nun der Hauptreport!',
    'mautic.report.report.notice.batch_deleted' => '%count% Reports sind gelöscht worden!',
    'mautic.report.scheduled.already' => 'Bericht %id% ist bereits geplant.',
    'mautic.report.scheduled.to.now' => 'Der Bericht %id% wird exportiert und an Ihre E-Mail-Adresse %email% gesendet.',
    'mautic.company.notice.batch_deleted' => '{0} 0 Unternehmen gelöscht|{1} 1 Unternehmen gelöscht|]1,Inf[ %count% Unternehmen gelöscht',
    'mautic.company.error.notfound' => 'Firma nicht gefunden.',
    'mautic.lead.batch_leads_affected' => '{0} 0 Kontakte betroffen|{1} 1 Kontakt betroffen|]1,Inf[ %count% Kontakte betroffen',
    'mautic.lead.email.error.failed' => 'E-Mail an %email% konnte nicht gesendet werden: %error%',
    'mautic.lead.email.notice.sent' => '&quot;%subject%&quot; gesendet an %email%',
    'mautic.lead.field.error.notfound' => 'Ein Feld mit der ID %id% wurde nicht gefunden!',
    'mautic.lead.field.notice.batch_deleted' => '%count% Felder sind gelöscht worden!',
    'mautic.lead.lead.error.notfound' => 'Es wurde kein Kontakt mit der ID %id% gefunden!',
    'mautic.lead.lead.notice.addedtolists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> wurde zu %list% hinzugefügt.',
    'mautic.lead.lead.notice.batch_deleted' => '%count% Kontakte wurden gelöscht!',
    'mautic.lead.lead.notice.removedfromlists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> wurde von %list% entfernt.',
    'mautic.lead.list.error.notfound' => 'Eine Liste mit der ID %id% wurde nicht gefunden!',
    'mautic.lead.list.error.cannot.delete' => 'Segment kann nicht gelöscht werden, es wird von %segments% benötigt.',
    'mautic.lead.list.error.cannot.delete.batch' => '%segmente% kann nicht gelöscht werden, es wird von anderen Segmenten benötigt.',
    'mautic.lead.list.notice.batch_deleted' => '%count% Listen sind gelöscht worden!',
    'mautic.lead.list.frequency.rules.msg' => 'Nein',
    'mautic.lead.batch.import.created' => 'Der Import wurde erfolgreich gestartet. Sie werden informiert, wenn dieser abgeschlossen ist.',
    'mautic.import.file.missing' => 'Die Datei „%file%“ kann im Dateisystem nicht gefunden werden. Bitte versuchen Sie es erneut.',
    'mautic.lead.export.being.prepared' => 'Die Datei steht zur Verarbeitung in der Warteschlange. Die Datei wird an Ihre E-Mail-Adresse „%user_email%“ gesendet. Sie können die Datei über den in der E-Mail angegebenen Link herunterladen.',
    'mautic.config.config.error.not.updated' => 'Änderungen in der Konfiguration konnten nicht gespeichert werden: %exception%',
    'mautic.config.config.notice.updated' => 'Die Konfiguration wurde erfolgreich aktualisiert',
    'mautic.social.monitoring.notice.batch_deleted' => 'Überwachungen erfolgreich gelöscht.',
    'mautic.social.monitoring.error.notfound' => 'Eine Social Überwachung mit der ID %id% wurde nicht gefunden.',
    'mautic.installer.error.adding.fields' => 'Beim Anlegen der Tabelle für Kontakt-Felder ist ein Fehler aufgetreten: %exception%',
    'mautic.installer.error.adding.fixtures' => 'Beim Anlegen von Default-Werten ist ein Fehler aufgetreten: %exception%',
    'mautic.installer.error.connecting.database' => 'Bei der Verbindung zur Datenbank ist ein Fehler aufgetreten: %exception%',
    'mautic.installer.error.creating.database' => 'Die Datenbank %name% konnte nicht gefunden oder erzeugt werden, weil die Berechtigung dafür fehlt. Bitte legen Sie die Datenbank manuell an und versuchen es erneut.',
    'mautic.installer.error.getting.role' => 'Beim Versuch, die Administratorrolle zu erhalten, ist ein Fehler aufgetreten: %exception%',
    'mautic.installer.error.creating.user' => 'Beim Anlegen des Administrators ist ein Fehler aufgetreten: %exception%',
    'mautic.installer.error.database.exists' => 'Die angegebene Datenbank existiert schon und enthält Mautic-Daten.',
    'mautic.installer.error.database.version' => 'Ihre Datenbankversion (%currentversion%) ist zu alt, damit Mautic richtig funktioniert. Unterstützte Versionen sind MySQL %mysqlminversion% (oder höher) und MariaDB %mariadbminversion% (oder höher).',
    'mautic.installer.error.installing.data' => 'Beim Installieren der Daten ist ein Fehler aufgetreten: %exception%',
    'mautic.installer.error.no.metadata' => 'Für das Anlegen der Datenbank notwendige Meta-Daten wurden nicht gefunden',
    'mautic.installer.error.writing.configuration' => 'Beim Speichern der Konfiguration im Dateisystem ist ein Fehler aufgetreten.',
    'mautic.campaign.error.contact_not_in_campaign' => 'Der Kontakt %contact% ist nicht in der Kampagne %campaign%.',
    'mautic.campaign.error.event_already_executed' => 'Das Ereignis %event% in der Kampagne %campaign% wurde bereits am %dateTriggered% für den Kontakt %contact% ausgeführt.',
    'mautic.campaign.error.event_must_be_scheduled' => 'Das Ereignis %event% in der Kampagne %campaign% muss geplant oder als abgeschlossen markiert werden, da der Kontakt %contact% noch keinen Protokolleintrag hat.',
    'mautic.campaign.error.edit_events.request_invalid' => 'Es fehlen die Kontakt-ID und/oder Aktions-ID zu den Parametern dieses Eintrags.',
    'mautic.campaign.error.decision_cannot_be_scheduled' => 'Ein Ereignis vom Typ Entscheidung kann nicht geplant werden. Ereignis: %event%, Kampagne: %campaign%, Kontakt: %contact%.',
    'mautic.campaign.error.notfound' => 'Die Kampagne  mit der Id %id% wurde nicht gefunden!',
    'mautic.campaign.notice.batch_deleted' => '%count% Kampagnen wurden gelöscht!',
    'mautic.tagmanager.tag.error.notfound' => 'Keine Markierung mit der ID %id% gefunden!',
    'mautic.tagmanager.tag.notice.batch_deleted' => 'Markierung %count% erfolgreich gelöscht!',
    'mautic.tagmanager.tag.error.cannotbedeleted' => 'Nur Markierungen ohne Kontakte können gelöscht werden!',
    'mautic.page.error.notfound' => 'Eine Seite mit der ID %id% wurde nicht gefunden!',
    'mautic.page.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_page_index\'><strong>%name%</strong></a>ist nun die Hauptseite!',
    'mautic.page.notice.batch_deleted' => '%count% Seiten sind gelöscht worden!',
    'mautic.asset.asset.error.notfound' => 'Ein Asset mit ID %id% wurde nicht gefunden!',
    'mautic.asset.asset.notice.batch_deleted' => '%count% Assets sind gelöscht worden!',
    'mautic.form.error.notfound' => 'Ein Formular mit der ID %id% wurde nicht gefunden!',
    'mautic.form.field.error.notfound' => 'Ein Formularfeld mit der ID %id% wurde nicht gefunden!',
    'mautic.form.notice.batch_deleted' => '%count% Formulare sind gelöscht worden!',
    'mautic.form.result.notice.batch_deleted' => '%count% Formulareinträge wurden gelöscht.',
    'mautic.form.notice.batch_html_generated' => '{0}Es wurden keine Formulare wiederhergestellt.|{1}Ein Formular wurde wiederhergestellt.|]1,Inf[%count% Formulare wurden wiederhergestellt.',
    'mautic.form.submit.error.expired' => 'Das Formular wurde am %date% deaktiviert.',
    'mautic.form.submit.error.pending' => 'Dieses Formular kann seit %date% verwendet werden.',
    'mautic.form.submit.error.unavailable' => 'Dieses Formular ist nicht mehr verfügbar',
    'mautic.api.client.error.notfound' => 'Es gibt keinen Kunden mit der ID <strong>%id%</strong>.',
    'mautic.api.client.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\'><strong>%name%</strong></a> wurde erstellt.',
    'mautic.api.client.notice.revoked' => 'API Zugriff wurde von der Anwendung "%name%" widerrufen\\n',
    'mautic.api.call.permissionempty' => 'Mindesten eine Berechtigung muss angegeben werden',
    'mautic.webhook.error.notfound' => 'Webhook nicht gefunden',
    'mautic.addon.notice.reloaded' => '%added% Addons wurden hinzugefügt, %updated% aktualisiert und %disabled% deaktiviert.',
    'mautic.addon.notice.saved' => 'Die Einstellungen für die %name% Integration wurden gespeichert',
    'mautic.integration.auth.invalid.state' => 'Ungültige Sitzung. Bitte versuchen Sie es erneut.',
    'mautic.integration.error.addonnotenabled' => '%name% muss aktiviert sein um Integrationen anzuzeigen.',
    'mautic.integration.error.genericerror' => 'Unbekannter Fehler bei der Anforderung des Zugriff-Tokens.',
    'mautic.integration.error.oauthfail' => 'Anmeldung fehlgeschlagen, Fehlermeldung: \'%error%\'',
    'mautic.integration.notfound' => '%name% nicht gefunden!',
    'mautic.integration.notice.oauthsuccess' => 'Anmeldung erfolgreich',
    'mautic.integration.notice.saved' => 'Einstellungen gespeichert',
    'mautic.notification.notice.batch_deleted' => '%count% Benachrichtigungen wurden gelöscht!',
    'mautic.notification.error.notfound' => 'Es wurde keine Benachrichtigung mit der ID %id% gefunden!',
    'mautic.dynamicContent.error.notfound' => 'Kein dynamischer Inhalt mit der ID %id% gefunden.',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% Objekte gelöscht.',
    'mautic.point.error.notfound' => 'Die Punkt-Aktion mit der ID %id% wurde nicht gefunden!',
    'mautic.point.notice.batch_deleted' => '%count% Punkt-Aktionen sind gelöscht worden!',
    'mautic.point.trigger.error.notfound' => 'Ein Trigger mit der ID %id% wurde nicht gefunden.',
    'mautic.point.trigger.notice.batch_deleted' => '%count% Punkte-Trigger sind gelöscht worden!',
    'mautic.email.error.list_type.sent' => 'Nachdem eine E-Mail gesendet wurde, kann sie nicht mehr bearbeitet werden. Sie können die E-Mail duplizieren.',
    'mautic.email.error.notfound' => 'Die E-Mail mit der ID %id% wurde nicht gefunden!',
    'mautic.email.error.send.unpublished' => 'Die E-Mail %name% ist nicht verfügbar, die Verfügbarkeitsdaten stimmen nicht oder die E-Mail-Kategorie ist nicht verfügbar. Sie können diese E-Mail erst senden, wenn sie verfügbar ist.',
    'mautic.email.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_email_index\'><strong>%name%</strong></a>ist nun die Haupt-E-Mail-Adresse!',
    'mautic.email.notice.batch_deleted' => '%count% E-Mails sind gelöscht worden!',
    'mautic.email.notice.test_sent.success' => 'Es wurde eine Test-E-Mail an Ihre E-Mail-Adresse gesendet.',
    'mautic.email.notice.test_sent_multiple.success' => 'Die Test-E-Mails wurden versandt.',
    'mautic.core.action.entity.unlocked' => '%name% wurde freigegeben und ist nun editierbar',
    'mautic.core.could.not.set.language' => 'Die bevorzugte Sprache konnte nicht eingerichtet werden. Stattdessen wird die Standardsprache verwendet.',
    'mautic.core.error.accessdenied' => 'Sie haben keinen Zugriff zu diesem Bereich.',
    'mautic.core.error.badrequest' => 'ungültige Anfrage',
    'mautic.core.error.locked' => '%name% wird gerade verwendet von <a href=\'%contactUrl%\'>%user%</a> (am %date% um %time%). %override%',
    'mautic.core.error.not.valid' => 'Das Formular ist ungültig. Bitte füllen Sie alle Pflichtfelder aus.',
    'mautic.core.error.notfound' => 'nicht gefunden',
    'mautic.core.error.delete.error' => 'Das Element konnte nicht gelöscht werden. %error%',
    'mautic.core.error.max.field' => 'Sie haben die zulässige Obergrenze für benutzerdefinierte Felder in Ihrer Datenbank erreicht.',
    'mautic.core.notice.batch_deleted' => '%count% Einträge gelöscht',
    'mautic.core.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> wurde angelegt!',
    'mautic.core.notice.deleted' => '<strong>%name%</strong> wurde gelöscht!',
    'mautic.core.notice.updated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> wurde aktualisiert!',
    'mautic.core.notice.used.field' => 'Das Feld "%name%" (#%id%) kann nicht gelöscht werden, weil es in den folgenden Segmenten verwendet wird: %segments%.',
    'mautic.core.notice.used.fields' => 'Feld(er) "%fields%" können nicht gelöscht werden, weil sie in den folgenden Segmenten verwendet werden: %segments%.',
    'mautic.core.notice.campaign.unpublished.email' => 'E-Mail <a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> verwendet in der Kampagne ist nicht veröffentlicht.',
    'mautic.core.language.helper.error.fetching.package' => 'Beim Download des Sprachpakets ist ein Fehler aufgetreten.',
    'mautic.core.language.helper.error.follow.redirects' => 'Hoppla, es ist safe_mode oder open_basedir eingeschaltet. Laden Sie die Sprache <a href=\'%url%\'>hier</a> herunter. Anschließend bitte entpacken und in das /translations Verzeichnis hochladen.',
    'mautic.core.language.helper.invalid.language' => 'Die gewünschte Sprache "%language%" ist unter den verfügbaren Mautic Sprachen nicht vorhanden. Es wird nun die Standardsprache verwendet.',
    'mautic.core.language.helper.error.on.language.server.side' => 'Der Server für Sprachen hat mit dem HTTP Code %code% geantwortet. Er ist wahrscheinlich vorübergehend nicht verfügbar. Versuchen Sie die Änderung der Sprache später erneut. Es wird nun die Standardsprache verwendet.',
    'mautic.core.language.helper.error.fetching.package.exception' => 'Beim Abrufen des Sprachpakets ist ein Problem aufgetreten: %exception%. Es wird nun die Standardsprache verwendet.',
    'mautic.core.ziparchive.not.installed' => 'Das ZIP-Archiv konnte nicht entpackt werden. Das php-zip-Modul fehlt. Bitte kontaktieren Sie Ihren Server-Admin.',
    'mautic.core.theme.error.notfound' => 'Vorlage %theme% nicht gefunden',
    'mautic.core.permission.issue' => 'Es gab ein Problem mit der Freigabe der Datei. Bitte nehmen Sie Kontakt zu Ihrem Systemadministrator auf, um die Freigabe einzustellen.',
    'mautic.core.theme.installed' => 'Vorlage <strong>%name%</strong> wurde installiert!',
    'mautic.core.theme.cannot.be.removed' => 'Die Vorlage %theme% ist die Standardvorlage und kann nicht entfernt werden.',
    'mautic.core.error.entity.not.found' => '%entity% ID %id% nicht gefunden',
    'mautic.core.error.csrf' => 'CSRF-Token-Fehler. Aktualisieren Sie die Seite und versuchen Sie es erneut.',
    'mautic.core.error.ids.missing' => 'Keine IDs angegeben.',
    'mautic.core.error.access.denied' => 'Zugriff verweigert',
    'mautic.core.theme.visibility.changed' => 'Vorlage <strong>%theme%</strong> Sichtbarkeit geändert!',
    'mautic.core.theme.cannot.change.visibility' => 'Die Vorlage %theme% ist die Standardvorlage und die Sichtbarkeit kann nicht verändert werden.',
    'mautic.core.theme.visibility.error' => 'Die Sichtbarkeit der Vorlage konnte nicht geändert werden. Fehler: %error%',
    'mautic.plugin.notice.reloaded' => '%added% neue Plugins wurden installiert und %updated% aktualisiert.',
    'mautic.plugin.notice.saved' => 'Die Einstellungen für die %name% Integration wurden gespeichert',
    'mautic.integration.sso.error.no_email' => 'Bestätigter Nutzer hat keine Mailadresse',
    'mautic.integration.sso.error.no_name' => 'Authentifizierter Benutzer hat keinen Vor- und Nachnamen.',
    'mautic.integration.sso.error.no_role' => 'Authentifizierter Benutzer hat keine Rolle.',
    'mautic.integration.sso.error.no_username' => 'Authentifizierter Benutzer hat keinen Benutzernamen.',
  ),
  'fixtures' => 
  array (
    'mautic.user.role.admin.description' => 'Vollständiger Systemzugriff',
    'mautic.user.role.admin.name' => 'Administrator',
    'mautic.user.role.limitedsales.description' => 'Hat die Berechtigung, Kontakte zu anzulegen und zu besitzen',
    'mautic.user.role.limitedsales.name' => 'Sales Associate - Limited',
    'mautic.user.role.sales.description' => 'Hat Zugriff auf Marketing Tools',
    'mautic.user.role.sales.name' => 'Sales Associate',
    'mautic.user.user.admin.name' => 'Admin',
    'mautic.user.user.limitedsales.name' => 'Limited Sales',
    'mautic.user.user.sales.name' => 'Sales',
    'mautic.lead.list.us' => 'Vereinigte Staaten',
    'mautic.lead.list.usalias' => 'us',
    'mautic.lead.field.firstname' => 'Vorname',
    'mautic.lead.field.lastname' => 'Nachname',
    'mautic.lead.field.company' => 'Hauptunternehmen',
    'mautic.lead.field.email' => 'E-Mail',
    'mautic.lead.field.position' => 'Position',
    'mautic.lead.field.title' => 'Titel',
    'mautic.lead.field.phone' => 'Telefon',
    'mautic.lead.field.mobile' => 'Mobil',
    'mautic.lead.field.fax' => 'Fax',
    'mautic.lead.field.address1' => 'Adresse, Zeile 1',
    'mautic.lead.field.address2' => 'Adresse, Zeile 2',
    'mautic.lead.field.website' => 'Webseite',
    'mautic.lead.field.twitter' => 'Twitter',
    'mautic.lead.field.foursquare' => 'Foursquare',
    'mautic.lead.field.facebook' => 'Facebook',
    'mautic.lead.field.googleplus' => 'Google Plus',
    'mautic.lead.field.instagram' => 'Instagram',
    'mautic.lead.field.skype' => 'Skype',
    'mautic.lead.field.city' => 'Ort',
    'mautic.lead.field.state' => 'Bundesland',
    'mautic.lead.field.zipcode' => 'Postleitzahl',
    'mautic.lead.field.country' => 'Land',
    'mautic.lead.field.gender' => 'Geschlecht',
    'mautic.lead.field.attribution' => 'Zuordnung',
    'mautic.lead.field.attribution_date' => 'Datum der Zuordnung',
    'mautic.lead.field.last_active' => 'Letzte Aktivität Datum',
    'mautic.lead.field.points' => 'Punkte',
    'mautic.lead.field.preferred_locale' => 'Bevorzugte Sprache',
    'mautic.lead.field.timezone' => 'Bevorzugte Zeitzone',
    'mautic.lead.field.companyemail' => 'Unternehmen E-Mail',
    'mautic.lead.field.companyname' => 'Unternehmensname',
    'mautic.lead.field.companyaddress1' => 'Adresse 1',
    'mautic.lead.field.companyaddress2' => 'Adresse 2',
    'mautic.lead.field.companycity' => 'Ort',
    'mautic.lead.field.companystate' => 'Bundesland',
    'mautic.lead.field.companycountry' => 'Land',
    'mautic.lead.field.companyzipcode' => 'Postleitzahl',
    'mautic.lead.field.companyindustry' => 'Branche',
    'mautic.lead.field.companyphone' => 'Telefon',
    'mautic.lead.field.companydescription' => 'Beschreibung',
    'mautic.lead.field.companywebsite' => 'Webseite',
    'mautic.lead.field.companynumber_of_employees' => 'Anzahl Mitarbeiter',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Jährlicher Umsatz',
    'mautic.page.category.events' => 'Ereignisse',
  ),
));

$catalogueEn_US = new MessageCatalogue('en_US', array (
  'messages' => 
  array (
    'mautic.config.tab.themeconfig' => 'Theme Settings',
    'mautic.core.config.form.theme.import.allowed.extensions' => 'Allowed file extensions from package installation',
    'mautic.config.tab.coreconfig' => 'System Settings',
    'mautic.config.tab.frequency_rules' => 'Default Frequency Rule',
    'mautic.core.ab_test.confirm_make_winner' => 'Warning: making %name% the winner will set it as the main item/parent, unpublish the other variants, stop the A/B test, and reset current A/B test stats. Are you sure you want to do this?',
    'mautic.core.ab_test.create' => 'Create an A/B test',
    'mautic.core.ab_test.make_winner' => 'Make winner',
    'mautic.core.ab_test.noresults' => 'No results available at this time.',
    'mautic.core.ab_test.parent_winning' => 'Parent winning or tied with a variant',
    'mautic.core.ab_test.stats' => 'A/B Test Stats',
    'mautic.core.ab_test.form.traffic_weight' => 'Traffic Weight',
    'mautic.core.ab_test.form.traffic_weight.help' => 'Define the percentage of traffic that will be shown this variant. For example, 50 will use the parent/main item 50% of the time and this variant 50% of the time. If there are two variants each with a weight of 25, then the parent/main item will be used 50% of the time, one variant 25%, and the other 25%. And so forth with additional variants.',
    'mautic.core.ab_test.form.winner' => 'A/B test winner criteria',
    'mautic.core.actions' => 'Actions',
    'mautic.core.toggletip' => 'Show information',
    'mautic.core.advanced' => 'Advanced',
    'mautic.core.alias' => 'Alias',
    'mautic.core.autogenerated' => 'Autogenerated',
    'mautic.core.open_link' => 'Open preview link in new tab',
    'mautic.core.options' => 'Options',
    'mautic.core.sort.ascending.description' => 'Click to sort rows by %header% in ascending order',
    'mautic.core.sort.descending.description' => 'Click to sort rows by %header% in descending order',
    'mautic.core.searchcommands.operators' => 'Search operators',
    'mautic.core.searchcommands.heading.operators' => 'Search Operators',
    'mautic.core.searchcommands.heading.operators.description' => 'Search operators help refine your search queries. Use these special characters and syntax to create more precise searches.',
    'mautic.core.searchcommands.heading.commands' => 'Specific Search Commands',
    'mautic.core.searchcommands.heading.commands.description' => 'Use these commands to quickly find specific information in Mautic. Each command helps you filter results for different types of data.',
    'searchcommand.group.identification' => 'Identification',
    'searchcommand.group.interactions' => 'Interactions',
    'searchcommand.group.filters' => 'Filters',
    'mautic.core.searchcommands.operators.exact_term' => 'Find the exact term. For example, <code>+admin</code> will find \'admin\' but not \'administrator\'.',
    'mautic.core.searchcommands.operators.exclude_terms' => 'Exclude terms. For example, <code>!lead</code> will exclude results containing \'lead\'.',
    'mautic.core.searchcommands.operators.exact_phrase' => 'Search for an exact phrase. For example, <code>"John Doe"</code> will find contacts with that exact name.',
    'mautic.core.searchcommands.operators.grouping' => 'Group parts of your search. For example, <code>(email OR social)</code> will find results containing either \'email\' or \'social\'.',
    'mautic.core.searchcommands.operators.multiple_terms' => 'Include results for either of multiple terms. For example, <code>email OR social</code>.',
    'mautic.core.searchcommands.operators.wildcard' => 'Use as a wildcard. For example, <code>%technologies%</code> will find any contacts with \'technologies\' in their company name.',
    'mautic.core.searchcommand.ismine.label' => 'My items',
    'mautic.lead.lead.searchcommand.isunowned.label' => 'Unowned',
    'mautic.lead.lead.searchcommand.isunowned.description' => 'Filters for contacts that are not assigned to any user',
    'mautic.core.searchcommand.ids.description' => 'Enables lookup of specific items using their unique identifiers (comma-separated, no spaces)',
    'mautic.core.searchcommand.ispublished.description' => 'Filters for items that are currently active/available for use',
    'mautic.core.searchcommand.isunpublished.description' => 'Filters for items that are currently inactive/unavailable',
    'mautic.core.searchcommand.isuncategorized.description' => 'Filters for items that have not been assigned to any category',
    'mautic.core.searchcommand.ismine.description' => 'Filters for items that are owned by or assigned to the current user',
    'mautic.core.searchcommand.category.description' => 'Filters items by a specific category (use the category alias)',
    'mautic.core.searchcommand.name.description' => 'Searches for items by name',
    'mautic.core.searchcommand.email.description' => 'Searches for items by email address',
    'mautic.core.searchcommand.ip.description' => 'Filters for contacts by IP address',
    'mautic.core.all' => 'All',
    'mautic.core.protip' => 'ProTip!',
    'mautic.core.and' => 'and',
    'mautic.core.apply_filter' => 'Apply selected',
    'mautic.core.reset_filter' => 'Reset',
    'mautic.core.applydraft' => 'Apply Draft',
    'mautic.core.author' => 'Author',
    'mautic.core.builder' => 'Builder',
    'mautic.core.builder.legacy' => 'Legacy',
    'mautic.core.builder.link.text.placeholder' => 'Link text (e.g. Search!)',
    'mautic.core.builder.link.url.placeholder' => 'Link URL (e.g http://google.com)',
    'mautic.core.builder.token.dragme' => 'Drag and drop me!',
    'mautic.core.builder.token.drophere' => 'Drop Here!',
    'mautic.core.builder.token.help' => 'Drag and drop the desired token into the content section of choice.',
    'mautic.core.builder.token.help_custom' => 'Drag and drop the desired token here to insert it into the editor at the cursor\'s current position.',
    'mautic.email.token.today' => 'Today',
    'mautic.core.category' => 'Category',
    'mautic.core.channels' => 'Channels',
    'mautic.core.channel' => 'Channel',
    'mautic.core.channel.broadcast_success_count' => '# sent',
    'mautic.core.channel.broadcast_failed_count' => '# failed',
    'mautic.core.close' => 'Close',
    'mautic.core.close_back' => 'Back to %target%',
    'mautic.core.close_back.fallback' => 'index',
    'mautic.core.close.builder' => 'Close Builder',
    'mautic.core.color' => 'Color',
    'mautic.core.error.message' => 'Error message',
    'mautic.core.command.asset_generate_success' => 'Production assets have been regenerated.',
    'mautic.core.command.install_application_configuration_loaded' => 'Configuration successfully loaded',
    'mautic.core.command.install_application_could_not_clear_cache' => 'Could not clear the application cache',
    'mautic.core.command.install_application_could_not_create_database' => 'Could not create the Mautic database',
    'mautic.core.command.install_application_could_not_create_database_exception' => 'Could not create the Mautic database: %message%',
    'mautic.core.command.install_application_could_not_create_user' => 'Could not create the admin user: %message%',
    'mautic.core.command.install_application_could_not_load_fixtures' => 'Could not populate data into the database',
    'mautic.core.command.install_application_could_not_load_fixtures_exception' => 'Could not populate data into the database: %message%',
    'mautic.core.command.install_application_could_not_write_config' => 'Could not write configuration file: %message%',
    'mautic.core.command.install_application_success' => 'Success! Mautic has been installed.',
    'mautic.core.command.install_data_confirm' => 'This will replace all of the data currently in Mautic\'s tables. Are you sure you want to continue?',
    'mautic.core.command.install_data_success' => 'Success! Mautic default data has been installed. The default login is admin/mautic.',
    'mautic.core.command.language_config.config_written' => 'Language configuration written for %lang% language.',
    'mautic.core.command.language_config.could_not_create' => 'Could not write the language configuration file to %file%.',
    'mautic.core.command.transifex_error_creating_directory' => 'Could not create resource directory %directory%',
    'mautic.core.command.transifex_error_creating_file' => 'Could not write resource file %file%',
    'mautic.core.command.transifex_error_pushing_data' => 'An error occurred while pushing data to Transifex: %message%',
    'mautic.core.command.transifex_no_credentials' => 'Your Transifex credentials must be saved to the configuration in order to use this command.',
    'mautic.core.command.transifex_processing_language' => 'Processing Language \'%language%\'',
    'mautic.core.command.transifex_processing_resource' => 'Processing Resource \'%resource%\'',
    'mautic.core.command.transifex_resource_created' => 'Resource created successfully',
    'mautic.core.command.transifex_resource_downloaded' => 'Resource downloaded successfully',
    'mautic.core.command.transifex_resource_updated' => 'Resource for %file% updated successfully',
    'mautic.core.command.transifex_error_pulling_data' => 'There was a Transifex API error: %message%',
    'mautic.core.command.update.composer' => 'You have Composer updates enabled. This means that you can only update Mautic through the \'composer update\' command. Read more in the documentation: https://mau.tc/switch-to-composer',
    'mautic.core.command.update.finalize_instructions' => 'IMPORTANT: Run the same command again with --finish. For example \'php bin/console mautic:update:apply --finish\'',
    'mautic.core.command.update.step.checks' => 'Running pre-update checks...',
    'mautic.core.command.update.step.critical_migrations' => 'Applying critical schema migrations...',
    'mautic.core.command.update.step.download_update_package' => 'Downloading update package...',
    'mautic.core.command.update.step.extract_update_package' => 'Extracting update package...',
    'mautic.core.command.update.step.loading_package' => 'Loading specified package...',
    'mautic.core.command.update.step.loading_update_information' => 'Loading update information...',
    'mautic.core.command.update.step.update_languages' => 'Updating language packages...',
    'mautic.core.command.update.step.validate_update_package' => 'Validating update package...',
    'mautic.core.command.update.step.wrapping_up' => 'Wrapping up...',
    'mautic.core.command.prepare_upgrade_success' => 'Successfully created mautic.zip and placed it in your web root. Please make a backup of this file now.',
    'mautic.core.command.prepare_upgrade_fail' => 'Failed to create mautic.zip in your web root. Your installation is not ready for upgrade.',
    'mautic.core.company' => 'Company',
    'mautic.core.components' => 'Components',
    'mautic.core.integrations' => 'Integrations',
    'mautic.core.general' => 'General',
    'mautic.core.config.cors.restrict.domains' => 'Restrict Domains',
    'mautic.core.config.cors.restrict.domains.tooltip' => 'Would you like to restrict the domains that can send CORS requests to your Mautic installation?',
    'mautic.core.config.cors.valid.domains' => 'Valid Domains',
    'mautic.core.config.cors.valid.domains.tooltip' => 'Enter the domains (http://yourdomain.com), one per line, to which you\'d like to restrict incoming CORS requests.',
    'mautic.core.config.response.headers.sts' => 'Strict Transport Security',
    'mautic.core.config.response.headers.sts.tooltip' => 'HSTS response header informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS',
    'mautic.core.config.response.headers.sts.expire_time' => 'Expire Time (seconds)',
    'mautic.core.config.response.headers.sts.subdomains' => 'Include Subdomains',
    'mautic.core.config.response.headers.sts.subdomains.tooltip' => 'If checked, this rule applies to all of the site\'s subdomains as well',
    'mautic.core.config.response.headers.sts.preload' => 'Preload',
    'mautic.core.config.response.headers.sts.preload.tooltip' => 'HSTS preload service (https://hstspreload.org/)',
    'mautic.core.config.form.cache.path' => 'Path to the cache directory',
    'mautic.core.config.form.cache.path.tooltip' => 'Set the absolute path to the cache directory. %kernel.project_dir%/app can be used as a placeholder for the app directory in the public web root. It is advised to use a directory outside of the public web root to prevent the cache from being accessible by the public.',
    'mautic.core.dir.not.accesssible' => '%dir% is not accessible',
    'mautic.core.config.form.date.format.dateonly' => 'Default format for date only',
    'mautic.core.config.form.date.format.dateonly.tooltip' => 'Set the default format for date only. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, F j, Y will be formatted to December 21, 2014.',
    'mautic.core.config.form.date.format.full' => 'Default format for full dates',
    'mautic.core.config.form.date.format.full.tooltip' => 'Set the default format for full dates. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, F j, Y g:i a T will be formatted to December 21, 2014 5:22 pm CST.',
    'mautic.core.config.form.date.format.short' => 'Default format for short dates',
    'mautic.core.config.form.date.format.short.tooltip' => 'Set the default format for short dates. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, D, M d will be formatted to Sun, Dec 21.',
    'mautic.core.config.form.date.format.timeonly' => 'Default Time Only Format',
    'mautic.core.config.form.date.format.timeonly.tooltip' => 'Set the default format for time only. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, g:i a will be formatted to 5:22 pm.',
    'mautic.core.config.form.default.pagelimit' => 'Default item limit per page',
    'mautic.core.config.form.default.pagelimit.tooltip' => 'Sets the default number of items to display per page for lists',
    'mautic.core.config.form.default.timezone' => 'Default timezone',
    'mautic.core.config.form.default.timezone.tooltip' => 'Set the system\'s default timezone. Users can set their own default timezone via their profile.',
    'mautic.core.config.form.cached.data.timeout' => 'Cached data timeout',
    'mautic.core.config.form.cached.data.timeout.tooltip' => 'Some chart and table data are cached to speed up the load. Define how often the cache should expire and refresh from database to bring the latest data. Insert 0 to disable cache.',
    'mautic.core.config.form.do_not_track_ips' => 'List of IPs to not track contacts with (one per line)',
    'mautic.core.config.form.do_not_track_ips.tooltip' => 'List IPs, one per line, that should not be associated with contact tracking. Examples include known webmail client IPs, etc. You can use specific IPs (127.0.0.1), IP ranges (127.0.0.1/32), or astericks wildcard (127.0.0.*).',
    'mautic.core.config.form.do_not_track_bots' => 'List of Bots to not track with (one per line)',
    'mautic.core.config.form.do_not_track_bots.tooltip' => 'List of Bots, one per line, that should not be associated with contact tracking',
    'mautic.core.config.form.image.path' => 'Relative path to the images directory',
    'mautic.core.config.form.image.path.tooltip' => 'Set the relative path from the public web root to where images uploaded through the editors should be stored.',
    'mautic.core.config.form.ip.lookup.auth' => 'IP lookup service authentication',
    'mautic.core.config.form.ip.lookup.auth.tooltip' => 'Set authentication credential(s) required by the selected service. For services that require a username and password, use the format username:password.',
    'mautic.core.config.create.organization.from.ip.lookup' => 'Create company from IP lookup',
    'mautic.core.config.create.organization.from.ip.lookup.tooltip' => 'Although it may be useful to get the company from IP lookup, Mautic will consider such contact to be identified which may not be what you want.',
    'mautic.core.config.form.transliterate.page.title' => 'Transliterate page titles',
    'mautic.core.config.form.transliterate.page.title.tooltip' => 'Set whether you want the page titles in the Contact’s events history to appear transliterated, or in its original language. This setting was on by default in previous versions of Mautic.',
    'mautic.core.config.load.froala.assets' => 'Load Froala assets',
    'mautic.core.config.load.froala.assets.tooltip' => 'Load Froala WYSIWYG JS files into Mautic administration. Froala is needed for the legacy JS and Page builder',
    'mautic.core.config.load.froala.assets.warning' => 'Froala is not loaded by default because the version Mautic uses has known security vulnerabilities and the JS library cannot be updated due to changes in licensing. You can still enable it if you are OK with the risks and need to use the legacy builder.',
    'mautic.core.config.form.404_page' => '404 page',
    'mautic.core.config.form.404_page.tooltip' => 'Choose the page to show when browsing to Mautic\'s 404. Leave blank to be redirected to default 404 page.',
    'mautic.core.config.form.ip.lookup.service' => 'IP lookup service',
    'mautic.core.config.form.ip.lookup.service.tooltip' => 'Set the service to use to lookup geographical information from an IP address. Note that some of the services listed are commercial services. Mautic is not affiliated with the listed services but provide them for convenience.',
    'mautic.core.config.form.shortener.enable_email' => 'E-Mail',
    'mautic.core.config.form.shortener.enable_email.tooltip' => 'Enable short URLs in E-Mail',
    'mautic.core.config.form.shortener.enable_sms' => 'SMS',
    'mautic.core.config.form.shortener.enable_sms.tooltip' => 'Enable short URLs in SMS',
    'mautic.core.config.form.shortener.empty' => 'Please, install and setup shortener service first (bitly from plugins or others)',
    'mautic.core.config.form.shortener' => 'Shortener service',
    'mautic.core.config.form.shortener.tooltip' => 'Choose the service to use to shorten URLs.',
    'mautic.core.config.form.link.max_entity_lock_time' => 'Item max lock time (seconds)',
    'mautic.core.config.form.link.max_entity_lock_time.tooltip' => 'Time in seconds before that an entity (email, segments, etc.) is automatically free.',
    'mautic.core.config.form.locale' => 'Default language',
    'mautic.core.config.form.locale.tooltip' => 'Set the site\'s default language. Users can set their own default language via their profile.',
    'mautic.core.config.form.log.path' => 'Path to the log directory',
    'mautic.core.config.form.log.path.tooltip' => 'Set the absolute path to the log directory. %kernel.project_dir%/app can be used as a placeholder for the app directory in the public web root. It is advised to use a directory outside of the public web root to prevent the logs from being accessible by the public.',
    'mautic.core.config.form.site.url' => 'Site URL',
    'mautic.core.config.form.site.url.tooltip' => 'Set the URL to this site here. This is required for cronjobs to correctly determine absolute URLs when generating links for emails, etc',
    'mautic.core.config.form.theme' => 'Default landing page and form theme',
    'mautic.core.config.form.theme.tooltip' => 'Set the default theme used by the system for rendering landing pages and forms. HINT: Changing this will only affect new pages and won\'t change existing pages.',
    'mautic.core.config.form.trusted.hosts' => 'Trusted hosts',
    'mautic.core.config.form.trusted.hosts.tooltip' => 'Explicitely whitelist the hosts allowed to send requests to Mautic. You can use regex and separate multiple hosts with a comma. I.e. .*\\.?trusted.com$ If left empty, Mautic will respond to all hosts.',
    'mautic.core.config.form.trusted.proxies' => 'Trusted proxies',
    'mautic.core.config.form.trusted.proxies.tooltip' => 'Configures the IP addresses that should be trusted as proxies. This setting is mandatory when using Mautic behind an SSL terminating proxy. Separate multiple IP addresses by a comma. i.e 127.0.0.1, 10.0.0.0/8, fc00::/7',
    'mautic.core.config.form.update.composer' => 'Update Mautic through Composer [BETA]',
    'mautic.core.config.form.update.composer.tooltip' => 'Set to \'Yes\' if you update Mautic through Composer. This is a prerequisite if you want to install and update plugins through the Marketplace. This will be the default installation and update method in Mautic 5.',
    'mautic.core.config.form.update.composer.warning' => 'WARNING: changing this setting might break your installation. Read %url_start%this page%url_end% for more details.</span>',
    'mautic.core.config.form.update.stability' => 'Update stability level',
    'mautic.core.config.form.update.stability.tooltip' => 'Set the minimum stability level required for updates',
    'mautic.core.config.form.webroot' => 'Mautic\'s root URL',
    'mautic.core.config.form.webroot.dashboard' => 'Mautic\'s dashboard',
    'mautic.core.config.form.webroot.tooltip' => 'Choose the page to show when browsing to Mautic\'s root URL (i.e. http://your-mautic-site.com/). Leave blank to be redirected to Mautic\'s dashboard.',
    'mautic.core.config.header.cors' => 'CORS Settings',
    'mautic.core.config.header.defaults' => 'System Defaults',
    'mautic.core.config.header.general' => 'General Settings',
    'mautic.core.config.header.misc' => 'Miscellaneous Settings',
    'mautic.core.config.header.response.headers' => 'Additional Response Headers',
    'mautic.core.config.header.update' => 'Update Settings',
    'mautic.core.config.update_stability.alpha' => 'Alpha',
    'mautic.core.config.update_stability.beta' => 'Beta',
    'mautic.core.config.update_stability.rc' => 'Release Candidate',
    'mautic.core.config.update_stability.stable' => 'Stable',
    'mautic.core.copyright' => 'Copyright %date% Mautic. All Rights Reserved.',
    'mautic.core.create.by.past.tense' => 'Created by',
    'mautic.core.createnew' => 'Create new...',
    'mautic.core.created' => 'Created on',
    'mautic.core.createdby' => 'Created by',
    'mautic.core.current' => 'Current',
    'mautic.core.date.added' => 'Date Added',
    'mautic.core.date.ago' => '%days% days ago',
    'mautic.core.date.years.ago' => '{1}1 year ago|]1,Inf[%count% years ago',
    'mautic.core.date.months.ago' => '{1}1 month ago|]1,Inf[%count% months ago',
    'mautic.core.date.days.ago' => '{1}1 day ago|]1,Inf[%count% days ago',
    'mautic.core.date.hours.ago' => '{1}1 hour ago|]1,Inf[%count% hours ago',
    'mautic.core.date.minutes.ago' => '{1}1 minute ago|]1,Inf[%count% minutes ago',
    'mautic.core.date.just.now' => 'just now',
    'mautic.core.date.day' => 'one: %count% day|some: %count% days',
    'mautic.core.date.hour' => 'one: %count% hour|some: %count% hours',
    'mautic.core.date.minute' => 'one: %count% minute|some: %count% minutes',
    'mautic.core.date.modified' => 'Date Modified',
    'mautic.core.date.month' => 'one: %count% month|some: %count% months',
    'mautic.core.date.second' => 'one: %count% second|some: %count% seconds',
    'mautic.core.date.today' => 'Today, %time%',
    'mautic.core.date.tomorrow' => 'Tomorrow, %time%',
    'mautic.core.date.week' => 'one: %count% week|some: %count% weeks',
    'mautic.core.date.year' => 'one: %count% year|some: %count% years',
    'mautic.core.date.yesterday' => 'Yesterday, %time%',
    'mautic.core.date.less.than.second' => 'Less than 1 second',
    'mautic.core.db.connection.error' => 'Database connection error (code #%code%)',
    'mautic.core.defaultvalue' => 'Default value',
    'mautic.core.description' => 'Description',
    'mautic.core.details' => 'Details',
    'mautic.core.device' => 'Device',
    'mautic.core.discarddraft' => 'Discard Draft',
    'mautic.core.droppable.placeholder' => 'Drag and drop here to select',
    'mautic.core.email.cc.copy' => 'Copy of email sent to %email%',
    'mautic.core.error.403' => 'Tsk tsk. Apparently you don\'t have access to this area.',
    'mautic.core.error.404' => 'I\'m sorry! I couldn\'t find the page you were looking for.',
    'mautic.core.error.500' => 'Uh oh! I think I broke it. If I do it again, please report me to the system administrator!',
    'mautic.core.error.generic' => 'Looks like I encountered an error (error #%code%). If I do it again, please report me to the system administrator!',
    'mautic.core.error.previousexceptions' => 'Previous Exceptions',
    'mautic.core.filter.categories' => 'Category',
    'mautic.core.filter.clear' => 'Clear Filter',
    'mautic.core.filter.header' => 'Filter',
    'mautic.core.filter.lists' => 'Segment',
    'mautic.core.filter.themes' => 'Theme',
    'mautic.core.filter.tags' => 'Tag',
    'mautic.core.filters' => 'Filters',
    'mautic.core.firstname' => 'First name',
    'mautic.core.form.abtest' => 'Add A/B Test',
    'mautic.core.form.add' => 'Add',
    'mautic.core.form.apply' => 'Save',
    'mautic.core.form.archive' => 'Archive',
    'mautic.core.form.confirmbatchdelete' => 'Delete the selected items?',
    'mautic.core.form.cancel' => 'Cancel',
    'mautic.core.form.categories' => 'filter by category...',
    'mautic.core.form.choosemultiple' => 'Choose one or more...',
    'mautic.core.form.chooseone' => 'Choose one...',
    'mautic.core.form.clone' => 'Clone',
    'mautic.core.form.close' => 'Close',
    'mautic.core.form.default' => 'Default',
    'mautic.core.form.delete' => 'Delete',
    'mautic.core.form.delete_selected' => 'Delete Selected',
    'mautic.core.form.done' => 'Done',
    'mautic.core.form.edit' => 'Edit',
    'mautic.core.form.expired' => 'Expired on schedule',
    'mautic.core.form.no_longer_available' => 'No longer available',
    'mautic.core.form.sending_expired' => 'Sending period expired',
    'mautic.core.form.expired_to' => 'Expired. Stopped sending at %date%',
    'mautic.core.form.filters.available' => 'Available',
    'mautic.core.form.filters.selected' => 'Selected',
    'mautic.core.form.insert' => 'Insert',
    'mautic.core.form.list' => 'List values',
    'mautic.core.form.list.additem' => 'Add a value',
    'mautic.core.form.new' => 'New',
    'mautic.core.form.no' => 'No',
    'mautic.core.form.nomatches' => 'No matches found',
    'mautic.core.form.pending' => 'Not started yet',
    'mautic.core.form.scheduled_to_send' => 'Scheduled for future send',
    'mautic.core.form.not_yet_available' => 'Scheduled for upcoming use',
    'mautic.core.form.pending.start_at' => 'Pending. Start sending at %date%',
    'mautic.core.form.publishdown' => 'Deactivate at (date/time)',
    'mautic.core.form.active' => 'Active',
    'mautic.core.form.activate_at' => 'Activate at (date/time)',
    'mautic.core.form.sending.start_at' => 'Start sending at (date/time)',
    'mautic.core.form.sending.stop_at' => 'Stop sending at (date/time)',
    'mautic.core.form.public' => 'Public',
    'mautic.core.form.not.public' => 'Not public',
    'mautic.core.form.reset' => 'Clear',
    'mautic.core.form.save' => 'Save',
    'mautic.core.form.saveandclose' => 'Save & Close',
    'mautic.core.form.submit' => 'Submit',
    'mautic.core.form.thead.filter' => 'filter...',
    'mautic.core.form.theme' => 'Theme',
    'mautic.core.form.translation_parent' => 'Is a translation of',
    'mautic.core.form.translation_parent.empty' => 'Choose a translated item...',
    'mautic.core.form.translation_parent.help' => 'If this item is a translation of another, choose the item this is translating so that they are associated. Start typing the desired value then choose from the autocomplete list.',
    'mautic.core.form.uncategorized' => 'Uncategorized',
    'mautic.core.form.inactive' => 'Inactive',
    'mautic.core.form.update' => 'Update',
    'mautic.core.form.yes' => 'Yes',
    'mautic.core.form.inactive_regardless_of_scheduling' => 'Inactive regardless of scheduling',
    'mautic.core.form.active_on_scheduled_date' => 'Activates on scheduled date',
    'mautic.core.form.active_during_scheduled_period' => 'Active during scheduled period',
    'mautic.core.form.active_until_scheduled_end' => 'Active until scheduled end',
    'mautic.core.form.sending_paused' => 'Sending paused',
    'mautic.core.form.sending_on_scheduled_start' => 'Sending begins on scheduled date',
    'mautic.core.form.sending_during_scheduled_period' => 'Sending during scheduled period',
    'mautic.core.form.unavailable_regardless_of_scheduling' => 'Unavailable regardless of scheduling',
    'mautic.core.form.available_on_scheduled_date' => 'Available on scheduled date',
    'mautic.core.form.available_during_scheduled_period' => 'Available during scheduled period',
    'mautic.core.form.available_until_scheduled_end' => 'Available until scheduled end',
    'mautic.core.go_to_dashboard' => 'Go to Dashboard',
    'mautic.core.header.edit' => 'Edit %name%',
    'mautic.core.header.new' => 'New Item',
    'mautic.core.help.autocomplete' => 'Start typing the desired value then choose from the autocomplete list.',
    'mautic.core.help.searchcommands.title' => 'Search commands',
    'mautic.core.icon_tooltip.ab_test' => 'Has A/B tests',
    'mautic.core.icon_tooltip.preference_center' => 'Is preference center page',
    'mautic.core.icon_tooltip.translation' => 'Has translations',
    'mautic.core.id' => 'ID',
    'mautic.core.insert' => 'Insert',
    'mautic.core.indexable' => 'Indexable',
    'mautic.core.ip_lookup.fetch_data' => 'Fetch IP Lookup Data Store',
    'mautic.core.ip_lookup.remote_fetch_error' => 'Automatically fetching the IP lookup data failed. Download %remoteUrl%, extract if necessary, and upload to %localPath%.',
    'mautic.core.ip_lookup.remote_fetch_error_generic' => 'Automatically fetching IP lookup data failed.',
    'mautic.core.ip_lookup.update_data' => 'Update IP Lookup Data Store',
    'mautic.core.ip_lookup.last_updated' => 'Last updated on %date%',
    'mautic.core.ipaddress' => 'IP address',
    'mautic.keyboard.shortcuts' => 'Keyboard shortcuts',
    'mautic.core.quick_filters' => 'Quick filters',
    'mautic.core.quick_filters.status' => 'Statuses',
    'mautic.core.quick_filters.ownership' => 'Ownership',
    'mautic.core.quick_filters.others' => 'Others',
    'mautic.core.quick_filters.more' => 'More',
    'mautic.core.quick_help' => 'Quick help',
    'mautic.keyboard.section.global' => 'Global',
    'mautic.keyboard.section.navigation' => 'Navigation',
    'mautic.keyboard.section.functions' => 'Functions',
    'mautic.keyboard.section.actions' => 'Actions',
    'mautic.keyboard.section.help' => 'Help',
    'mautic.keyboard.section.emails' => 'Emails',
    'mautic.keyboard.backspace' => 'Backspace',
    'mautic.keyboard.command' => 'Command/Ctrl',
    'mautic.keyboard.load_dashboard' => 'Go to Dashboard',
    'mautic.keyboard.load_contacts' => 'Go to Contacts',
    'mautic.keyboard.load_emails' => 'Go to Emails',
    'mautic.keyboard.load_forms' => 'Go to Forms',
    'mautic.keyboard.load_segments' => 'Go to Segments',
    'mautic.keyboard.load_landing_pages' => 'Go to Landing pages',
    'mautic.keyboard.open_settings' => 'Show admin menu',
    'mautic.keyboard.show_notifications' => 'Show Notifications',
    'mautic.keyboard.global_search' => 'Global search',
    'mautic.keyboard.list_search' => 'Search current list',
    'mautic.keyboard.quick_add_contact' => 'Quick add a new Contact',
    'mautic.keyboard.toggle_view' => 'Switch between Table or Card view',
    'mautic.keyboard.edit' => 'Edit',
    'mautic.keyboard.create' => 'Create new',
    'mautic.keyboard.delete' => 'Delete',
    'mautic.keyboard.send_example' => 'Send example',
    'mautic.keyboard.save' => 'Save changes',
    'mautic.keyboard.back' => 'Back to index (list)',
    'mautic.keyboard.press_to_view' => 'Press %question% at any time to view this help modal.',
    'mautic.keyboard.tip' => 'Tip!',
    'mautic.core.label' => 'Label',
    'mautic.core.language' => 'Language',
    'mautic.core.language.helper.error.fetching.languages' => 'An error occurred while attempting to fetch the language list.',
    'mautic.core.lastname' => 'Last name',
    'mautic.core.email' => 'E-mail',
    'mautic.core.list.filter' => 'Filter...',
    'mautic.core.loading' => 'Loading...',
    'mautic.core.menu.index' => 'Home',
    'mautic.core.menu.left.collapse' => 'Collapse Menu',
    'mautic.core.modified' => 'Last modified',
    'mautic.core.modifiedby' => 'Modified by',
    'mautic.core.more.hide' => '[hide]',
    'mautic.core.more.show' => '[more]',
    'mautic.core.name' => 'Name',
    'mautic.core.never' => 'Never',
    'mautic.core.none' => 'None',
    'mautic.core.noresults' => 'Seems there are none! Try changing a filter (if applicable) or how about creating a new one?',
    'mautic.core.noresults.header' => 'No Results Found',
    'mautic.core.noresults.tip' => 'Hey! How about a tip?',
    'mautic.core.not_required' => 'Not required',
    'mautic.core.notification.read_more' => '[Read More]',
    'mautic.core.notifications' => 'Notifications',
    'mautic.core.notifications.empty' => 'We\'re also waiting for notifications.',
    'mautic.core.notifications.empty_extra' => 'Have a unicorn in the meantime',
    'mautic.core.notifications.clear' => 'Clear this notification',
    'mautic.core.notifications.clearall' => 'Clear all notifications',
    'mautic.core.now' => 'Now',
    'mautic.core.number' => 'Number',
    'mautic.core.operator.between' => 'between',
    'mautic.core.operator.equals' => 'equals',
    'mautic.core.operator.greaterthan' => 'greater than',
    'mautic.core.operator.greaterthanequals' => 'greater than or equal',
    'mautic.core.operator.in' => 'including',
    'mautic.core.operator.isempty' => 'empty',
    'mautic.core.operator.islike' => 'like',
    'mautic.core.operator.isnotempty' => 'not empty',
    'mautic.core.operator.isnotlike' => 'not like',
    'mautic.core.operator.lessthan' => 'less than',
    'mautic.core.operator.lessthanequals' => 'less than or equal',
    'mautic.core.operator.notbetween' => 'not between',
    'mautic.core.operator.notequals' => 'not equal',
    'mautic.core.operator.notin' => 'excluding',
    'mautic.core.operator.contains' => 'contains',
    'mautic.core.operator.starts.with' => 'starts with',
    'mautic.core.operator.ends.with' => 'ends with',
    'mautic.core.optional' => 'Optional',
    'mautic.core.or' => 'or',
    'mautic.core.navigate' => 'Navigate',
    'mautic.core.order' => 'Order',
    'mautic.core.order.field' => 'Field order',
    'mautic.core.form.available' => 'Available for use',
    'mautic.core.form.sending' => 'Sending',
    'mautic.core.form.unavailable' => 'Unavailable',
    'mautic.core.form.available.available_from' => 'Available from (date/time)',
    'mautic.core.form.available.unavailable_from' => 'Unavailable from (date/time)',
    'mautic.core.order.field.tooltip' => 'The new field will be placed above the existing selected field',
    'mautic.core.order.field.tooltip.disabled' => 'Default fields cannot be reordered.',
    'mautic.core.override.lock' => '<a href=\'%url%\'>Override Lock</a>',
    'mautic.core.pagination.10' => '10',
    'mautic.core.pagination.100' => '100',
    'mautic.core.pagination.15' => '15',
    'mautic.core.pagination.20' => '20',
    'mautic.core.pagination.25' => '25',
    'mautic.core.pagination.30' => '30',
    'mautic.core.pagination.5' => '5',
    'mautic.core.pagination.50' => '50',
    'mautic.core.pagination.all' => 'all',
    'mautic.core.pagination.items' => 'one: %count% item|some: %count% items',
    'mautic.core.pagination.pages' => 'one: %count% page|some: %count% pages',
    'mautic.core.pagination.total' => 'in total',
    'mautic.core.parent' => 'Parent',
    'mautic.core.password' => 'Password',
    'mautic.core.permissions.badformat' => 'Permission must be in the format of bundle:permission:level (i.e. user:users:view). \'%permission%\' given.',
    'mautic.core.permissions.create' => 'Create',
    'mautic.core.permissions.delete' => 'Delete',
    'mautic.core.permissions.deleteother' => 'Delete Others',
    'mautic.core.permissions.deleteown' => 'Delete Own',
    'mautic.core.permissions.edit' => 'Edit',
    'mautic.core.permissions.editother' => 'Edit Others',
    'mautic.core.permissions.editown' => 'Edit Own',
    'mautic.core.permissions.full' => 'Full',
    'mautic.core.permissions.manage' => 'Manage',
    'mautic.core.permissions.mode.notfound' => 'The mode, %mode% for isGranted() is not recognized.',
    'mautic.core.permissions.notfound' => 'Permission not found. \'%permission%\' given.',
    'mautic.core.permissions.publish' => 'Publish',
    'mautic.core.permissions.publishother' => 'Publish Others',
    'mautic.core.permissions.publishown' => 'Publish Own',
    'mautic.core.permissions.view' => 'View',
    'mautic.core.permissions.viewother' => 'View Others',
    'mautic.core.permissions.viewown' => 'View Own',
    'mautic.core.permissions.export' => 'Export access',
    'mautic.core.permissions.enable' => 'Enable',
    'mautic.core.popupblocked' => 'It seems the browser is blocking popups. Please enable popups for this site and try again.',
    'mautic.core.position' => 'Position',
    'mautic.core.signature' => 'Signature',
    'mautic.core.preview' => 'Preview',
    'mautic.core.recent.activity' => 'Recent Activity',
    'mautic.core.redo' => 'Redo',
    'mautic.core.referer' => 'Referer',
    'mautic.core.remove' => 'Remove',
    'mautic.core.report_issue' => 'Report an issue',
    'mautic.core.required' => 'Required',
    'mautic.core.retry' => 'Retry',
    'mautic.core.saveasdraft' => 'Save as Draft',
    'mautic.core.search_everything' => 'Search everything',
    'mautic.core.search_everything.no_results.nothing_found' => 'Nothing found, but don\'t give up, ok? 💪',
    'mautic.core.search_everything.no_results.nothing_yet' => 'Nothing yet, but persistence is the key to success 🔑',
    'mautic.core.search_everything.no_results.no_results' => 'No results. Your next search can be *the one* 🌈',
    'mautic.core.search_everything.no_results.hang_tight' => 'Hang tight, sometimes the best things take time to find ⏳',
    'mautic.core.search.header' => 'Search Help',
    'mautic.core.search.livesearch' => 'Keep typing or press enter to search...',
    'mautic.core.search.clear' => 'Search or clear field',
    'mautic.core.search.more' => '%count% more...',
    'mautic.core.search.placeholder' => 'Filter...',
    'mautic.core.search.results' => 'Search Results',
    'mautic.core.search.quickfilter.form_results' => 'With responses',
    'mautic.core.search.quickfilter.form_results.tooltip' => 'View forms containing submitted data',
    'mautic.core.search.quickfilter.is_admin' => 'View users with administrator permissions',
    'mautic.core.search.quickfilter.is_published' => 'View active/available items',
    'mautic.core.search.quickfilter.is_unpublished' => 'View inactive/unavailable items',
    'mautic.core.search.quickfilter.is_uncategorized' => 'Show only items that are not assigned to any category',
    'mautic.page.searchcommand.isprefcenter.label' => 'Preference Center',
    'mautic.page.searchcommand.isprefcenter.description' => 'Filters for pages that are designated as preference centers',
    'mautic.core.searchcommand.category' => 'category',
    'mautic.core.searchcommand.email' => 'email',
    'mautic.core.searchcommand.ip' => 'ip',
    'mautic.core.searchcommand.isactive' => 'is:active',
    'mautic.core.searchcommand.isinactive' => 'is:inactive',
    'mautic.core.searchcommand.ismine' => 'is:mine',
    'mautic.core.searchcommand.ispublished' => 'is:published',
    'mautic.core.searchcommand.isuncategorized' => 'is:uncategorized',
    'mautic.core.searchcommand.isunpublished' => 'is:unpublished',
    'mautic.core.searchcommand.lang' => 'lang',
    'mautic.core.searchcommand.name' => 'name',
    'mautic.core.searchcommand.ids' => 'ids',
    'mautic.core.select' => 'Select',
    'mautic.core.settings' => 'Settings',
    'mautic.core.source' => 'Source',
    'mautic.core.stats' => 'Stats',
    'mautic.core.success' => 'Success!',
    'mautic.core.system' => 'System',
    'mautic.core.table.selectall' => 'Select All',
    'mautic.core.time.days' => 'days',
    'mautic.core.time.days_numbered' => '%days% days',
    'mautic.core.time.hours' => 'hours',
    'mautic.core.time.hour' => 'hour',
    'mautic.core.time.minutes' => 'minutes',
    'mautic.core.time.months' => 'months',
    'mautic.core.time.seconds' => 'seconds',
    'mautic.core.time.weeks' => 'weeks',
    'mautic.core.time.years' => 'years',
    'mautic.core.time.unit' => 'Time Unit',
    'mautic.core.timeframe.daily' => 'Daily',
    'mautic.core.timeframe.hourly' => 'Hourly',
    'mautic.core.timeframe.monthly' => 'Monthly',
    'mautic.core.timeframe.weekly' => 'Weekly',
    'mautic.core.timeframe.yearly' => 'Yearly',
    'mautic.core.timeline.device.granularity' => 'Device Granularity',
    'mautic.core.timeline.device.client.info' => 'Client Info:',
    'mautic.core.timeline.device.name' => 'Device Name:',
    'mautic.core.timeline.device.os' => 'Device OS:',
    'mautic.core.timeline.device.brand' => 'Device Brand:',
    'mautic.core.timeline.device.model' => 'Device Model:',
    'mautic.core.timeline.event.time' => 'At %date%, %event%.',
    'mautic.core.timeline.event.scheduled.time' => 'Scheduled to execute at %date%',
    'mautic.core.timezone' => 'Timezone',
    'mautic.core.title' => 'Title',
    'mautic.core.translations' => 'Translations',
    'mautic.core.translation_of' => 'Translation of %parent%',
    'mautic.core.type' => 'Type',
    'mautic.core.type.date' => 'Date',
    'mautic.core.type.datetime' => 'Date/Time',
    'mautic.core.type.boolean' => 'Boolean',
    'mautic.core.type.country' => 'Select: Country',
    'mautic.core.type.email' => 'Email',
    'mautic.core.type.companyLookup' => 'Company Lookup',
    'mautic.core.type.number' => 'Number',
    'mautic.core.type.select' => 'Select: Single choice',
    'mautic.core.type.tel' => 'Phone',
    'mautic.core.type.text' => 'Text: Short answer',
    'mautic.core.type.url' => 'URL',
    'mautic.core.type.time_format' => 'Time format',
    'mautic.core.undo' => 'Undo',
    'mautic.core.unknown' => 'Unknown',
    'mautic.core.update.aborted' => 'Update aborted.',
    'mautic.core.update.announcement' => 'Announcement',
    'mautic.core.update.archive_could_not_open' => 'Could not open the ZIP archive to complete the update.',
    'mautic.core.update.archive_file_exists' => 'Folder already exists. Please check your cache directory and delete any installation folders.',
    'mautic.core.update.archive_no_such_file' => 'The ZIP archive could not be found.',
    'mautic.core.update.archive_not_valid_zip' => 'The ZIP archive does not seem to be valid. Please check your cache directory and delete the package then try again.',
    'mautic.core.update.archive_zip_corrupt' => 'The ZIP archive seems corrupt. Please check your cache directory and delete the package then try again.',
    'mautic.core.update.archive_failed_to_extract' => 'Failed to extract the files.',
    'mautic.core.update.available' => 'Update Available',
    'mautic.core.update.backup_warning' => 'It is HIGHLY RECOMMENDED that files and database are backed up prior to applying the update.',
    'mautic.core.update.by.past.tense' => 'Updated by',
    'mautic.core.update.clear.cache' => 'Clearing the cache',
    'mautic.core.update.confirm_application_update' => 'Are you sure you wish to update Mautic to the latest version?',
    'mautic.core.update.current.version' => 'Current Version',
    'mautic.core.update.check.error' => 'One or more errors occurred while checking your environment prior to updating Mautic:',
    'mautic.core.update.check.error.release_data' => 'Got invalid or incomplete release info while preparing the pre-update checks. This might be a temporary error. Please try again.',
    'mautic.core.update.check.phpversion' => 'Your PHP version is too old or too new for Mautic to update. You are currently running PHP %currentversion%. Please make sure that your version is between %lowestversion% and %highestversion%.',
    'mautic.core.update.check.database_driver' => 'Your database driver (%currentdriver%) is not supported. Must be one of %supporteddrivers%',
    'mautic.core.update.check.database_version' => 'Your database version (%currentversion%) is too old for Mautic to work correctly. Supported versions are MySQL %mysqlminversion% (or higher) and MariaDB %mariadbminversion% (or higher).',
    'mautic.core.update.error' => 'The Mautic update could not complete successfully because of the following error: %error%',
    'mautic.core.update.error_extracting_package' => 'Could not extract the contents of the ZIP archive to the filesystem.',
    'mautic.core.update.error_performing_migration' => 'An error occurred while updating the database. Check log for more details.',
    'mautic.core.update.error_updating_language' => 'Could not update the \'%language%\' language.',
    'mautic.core.update.error.removing.file' => 'Failed removing the file at %path%.  As this is a deleted file, you can manually remove this file.',
    'mautic.core.update.heading.status' => 'Status',
    'mautic.core.update.heading.step' => 'Step',
    'mautic.core.update.in.progress' => 'Updating Mautic',
    'mautic.core.update.index' => 'Update Mautic',
    'mautic.core.update.migrating.database.schema' => 'Migrating database schema...',
    'mautic.core.update.no_cache_data' => 'Could not read the cached update data to apply the update.',
    'mautic.core.update.now' => 'Update Now',
    'mautic.core.update.composer' => 'You have Composer updates enabled. This means that you can only update Mautic through the Command Line. Read more in the <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentation</a>.',
    'mautic.core.update.ui.deprecated' => 'Updating Mautic through the user interface is deprecated and won’t be supported anymore in Mautic 5.0. For more information and to learn what you can do to prepare, please read the <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentation</a>.',
    'mautic.core.update.post_message' => 'Post Update Message',
    'mautic.core.update.remove.deleted.files' => 'Removing deleted files',
    'mautic.core.update.schema_updated' => 'Database schema has been updated.',
    'mautic.core.update.schema_uptodate' => 'Database schema is already up-to-date.',
    'mautic.core.update.step.downloading.package' => 'Downloading Package',
    'mautic.core.update.step.extracting.package' => 'Extracting Package',
    'mautic.core.update.step.failed' => 'Failed',
    'mautic.core.update.step.finalizing' => 'Finalizing Update',
    'mautic.core.update.step.in.progress' => 'In Progress',
    'mautic.core.update.step.moving.package' => 'Moving Package Contents',
    'mautic.core.update.step.running.checks' => 'Running pre-update checks',
    'mautic.core.update.step.success' => 'Success',
    'mautic.core.update.update_successful' => 'Success! You are now running version %version% of Mautic.',
    'mautic.core.update.upgrade.version' => 'Upgrade Version',
    'mautic.core.updater.cli.update' => 'To update, you can run \'php bin/console mautic:update:apply\' from the command line.',
    'mautic.core.updater.error.fetching.package' => 'An error occurred while downloading the update package.',
    'mautic.core.updater.error.fetching.updates' => 'An error occurred while checking for updates. Please try again later.',
    'mautic.core.updater.running.latest.version' => 'Great! You are running the current version of Mautic.',
    'mautic.core.updater.update.available' => 'Version %version% of Mautic is available for download. Please visit %announcement% for more information.',
    'mautic.core.updater.update.announcement_link' => '<a class=\'alert-link\' href=\'%announcement%\' target=\'_new\'>this announcement</a>',
    'mautic.core.url.error.401' => 'Unauthorized access to requested URL: %url%',
    'mautic.core.url.error.404' => 'Requested URL not found: %url%',
    'mautic.core.url.uncategorized' => 'uncategorized',
    'mautic.core.username' => 'Username',
    'mautic.core.value' => 'Value',
    'mautic.core.variant.misconfiguration' => 'There is a mismatched configuration between variants. Please ensure all variants are configured with the same winner criteria and that the weights combined do not equal more than 100.',
    'mautic.core.variant_of' => 'A/B variant of %parent%',
    'mautic.core.variant_start_date' => 'A/B test started on %date% at %time%',
    'mautic.core.variants' => 'Variants',
    'mautic.core.wait' => 'Please wait...',
    'mautic.core.configuration.value.not.set' => 'A value from the configuration is not set properly.',
    'mautic.core.dashboard.widgets' => 'Core Widgets',
    'mautic.core.date.from' => 'From',
    'mautic.core.date.to' => 'To',
    'mautic.core.padding.top' => 'Padding Top',
    'mautic.core.padding.bottom' => 'Padding Bottom',
    'mautic.core.button.border.radius' => 'Border Radius',
    'mautic.core.button.link' => 'Button Link',
    'mautic.core.button.size' => 'Button Size',
    'mautic.core.button.position' => 'Button Position',
    'mautic.core.button.text' => 'Button Text',
    'mautic.core.caption.position' => 'Caption Position',
    'mautic.core.image.position' => 'Image Position',
    'mautic.core.image.caption' => 'Image Caption',
    'mautic.core.twitter.url' => 'Twitter URL',
    'mautic.core.facebook.url' => 'Facebook URL',
    'mautic.core.caption.color' => 'Caption background Color',
    'mautic.core.background.color' => 'Background Color',
    'mautic.core.content.background.color' => 'Content Background Color',
    'mautic.core.content.background.image' => 'Content Background Image',
    'mautic.core.content.background.repeat' => 'Content Background Repeat',
    'mautic.core.content.background.size' => 'Content Background Size (width height | \'cover\' | \'contain\')',
    'mautic.core.content.background.position' => 'Content Background Position (horizontal vertical)',
    'mautic.core.continue' => 'Continue',
    'mautic.core.wrapper.background.color' => 'Wrapper Background Color',
    'mautic.core.wrapper.background.image' => 'Wrapper Background Image',
    'mautic.core.wrapper.background.repeat' => 'Wrapper Background Repeat',
    'mautic.core.wrapper.background.size' => 'Wrapper Background Size (width height | \'cover\' | \'contain\')',
    'mautic.core.wrapper.background.position' => 'Wrapper Background Position (horizontal vertical)',
    'mautic.core.text.color' => 'Text color',
    'mautic.core.slot.types' => 'Slot types',
    'mautic.core.section.types' => 'Section types',
    'mautic.core.separator.color' => 'Separator color',
    'mautic.core.separator.thickness' => 'Separator thickness',
    'mautic.core.drag.info' => 'Drag the type to the desired position.',
    'mautic.core.customize.slot' => 'Customize Slot',
    'mautic.core.customize.section' => 'Customize Section',
    'mautic.core.slot.customize.info' => 'Select the slot to customize',
    'mautic.core.section.customize.info' => 'Select the section to customize',
    'mautic.core.left' => 'Left',
    'mautic.core.right' => 'Right',
    'mautic.core.center' => 'Center',
    'mautic.core.no.info' => 'n/a',
    'mautic.widget.recent.activity' => 'Recent Activity',
    'mautic.theme.menu.index' => 'Themes',
    'mautic.core.themes' => 'Themes',
    'mautic.core.features' => 'Features',
    'mautic.core.theme.install' => 'Install',
    'mautic.core.permissions.themes' => 'Themes - User has access to',
    'mautic.core.permissions.header' => 'Core Permissions',
    'mautic.core.theme.form.confirmdelete' => 'Delete the theme, %name%?',
    'mautic.core.theme.form.confirmbatchdelete' => 'Delete the selected themes?',
    'mautic.theme.noresults.tip' => 'Themes allow you to easily select the structure and style of your emails, pages, forms and unsubscribe messages.',
    'mautic.core.download' => 'Download',
    'mautic.core.theme.feature.page' => 'Page',
    'mautic.core.theme.feature.email' => 'Email',
    'mautic.core.theme.feature.form' => 'Form',
    'mautic.maintenance.audit_log' => 'Audit log entries',
    'mautic.maintenance.notifications' => 'User notifications',
    'mautic.maintenance.user_tokens' => 'User tokens',
    'mautic.maintenance.confirm_data_purge' => 'This will permanently delete data older than %days% days! Please make a backup before proceeding. Run this command with --dry-run to get approximate records to be deleted. Continue? (y/n)',
    'mautic.maintenance.header.key' => 'Record type',
    'mautic.maintenance.header.records_affected' => 'Records affected',
    'mautic.maintenance.header.query' => 'Query details',
    'mautic.core.code.mode' => 'Code Mode',
    'mautic.core.code.mode.placeholder' => 'Place your content here',
    'mautic.core.format.code' => 'Format Code',
    'mautic.core.format.code.desc' => 'This option will re-format your code to optimal code style',
    'mautic.core.media.manager' => 'Media Manager',
    'mautic.core.media.manager.desc' => 'Opens a new window with media manager where you can upload a new item. When an item is selected, the URL is added to the cursor position',
    'mautic.core.code.mode.token.dropdown.hint' => 'Hint: Press <b>CTRL</b> + <b>SPACE BAR</b> for token drop down',
    'mautic.core.export' => 'Export',
    'mautic.core.export.csv' => 'Export to CSV',
    'mautic.core.export.xlsx' => 'Export to Excel',
    'mautic.core.export.items' => 'Export selected %items%?',
    'mautic.core.dynamicContent' => 'Dynamic Content',
    'mautic.core.dynamicContent.token_name' => 'Name',
    'mautic.core.dynamicContent.tab' => 'Variation',
    'mautic.core.dynamicContent.default_content' => 'Default Content',
    'mautic.core.dynamicContent.alt_content' => 'Content',
    'mautic.core.form.builder.error' => 'There are some form validation errors (%error%) Please close the builder and fix them.',
    'mautic.error.invalid.export.type' => 'Invalid export type %type% Must be one of csv or xlsx.',
    'mautic.core.send.email.to.multiple.addresses' => 'Separate multiple emails with a comma.',
    'mautic.core.send.email.to' => 'To',
    'mautic.core.send.email.cc' => 'CC',
    'mautic.core.send.email.bcc' => 'BCC',
    'mautic.core.slot.label.text' => 'Text',
    'mautic.core.slot.label.text.insert' => 'Insert text here',
    'mautic.core.slot.label.image' => 'Image',
    'mautic.core.slot.label.imagecard' => 'Image Card',
    'mautic.core.slot.label.imagecaption' => 'Image+Caption',
    'mautic.core.slot.label.button' => 'Button',
    'mautic.core.slot.label.socialshare' => 'Social Share',
    'mautic.core.slot.label.socialfollow' => 'Social Follow',
    'mautic.core.slot.label.segmentlist' => 'Segment List',
    'mautic.core.slot.label.categorylist' => 'Category List',
    'mautic.core.slot.label.preferredchannel' => 'Preferred Channel',
    'mautic.core.slot.label.channelfrequency' => 'Channel Frequency',
    'mautic.core.slot.label.saveprefsbutton' => 'Save Preferences',
    'mautic.core.slot.label.successmessage' => 'Success Message',
    'mautic.core.slot.label.successmessage.insert' => 'Preferences saved.',
    'mautic.core.slot.label.codemode' => 'Code Mode',
    'mautic.core.slot.label.separator' => 'Separator',
    'mautic.core.slot.label.gatedvideo' => 'Video',
    'mautic.core.slot.label.dynamiccontent' => 'Dynamic Content',
    'mautic.core.slot.label.onecolumn' => 'One Column',
    'mautic.core.slot.label.twocolumns' => 'Two Columns',
    'mautic.core.slot.label.threecolumns' => 'Three Columns',
    'mautic.core.yes' => 'Yes',
    'mautic.core.no' => 'No',
    'mautic.core.daterange.0days' => 'Current Day',
    'mautic.core.daterange.1days' => 'Last 24 Hours',
    'mautic.core.daterange.week' => '1 Week|%count% Weeks',
    'mautic.core.daterange.month' => '1 Month|%count% Months',
    'mautic.core.daterange.year' => '1 Year|%count% Years',
    'mautic.core.config.form.default.daterange_default' => 'Date Range Filter Default',
    'mautic.core.config.form.default.daterange_default.tooltip' => 'The default range to go back from current date/time on all Date Filters. This is overriden by the current user session last used values',
    'mautic.core.do_not_sell.remote_fetch_error' => 'Automatically fetching the Do Not Sell data failed. Download %remoteUrl%, extract if necessary, and upload to %localPath%.',
    'mautic.core.do_not_sell.remote_fetch_error_generic' => 'Automatically fetching Do Not Sell data failed.',
    'mautic.core.date.monday' => 'Monday',
    'mautic.core.date.tuesday' => 'Tuesday',
    'mautic.core.date.wednesday' => 'Wednesday',
    'mautic.core.date.thursday' => 'Thursday',
    'mautic.core.date.friday' => 'Friday',
    'mautic.core.date.saturday' => 'Saturday',
    'mautic.core.date.sunday' => 'Sunday',
    'mautic.core.date.mon' => 'Mon',
    'mautic.core.date.tue' => 'Tue',
    'mautic.core.date.wed' => 'Wed',
    'mautic.core.date.thu' => 'Thu',
    'mautic.core.date.fri' => 'Fri',
    'mautic.core.date.sat' => 'Sat',
    'mautic.core.date.sun' => 'Sun',
    'mautic.core.date.january' => 'January',
    'mautic.core.date.february' => 'February',
    'mautic.core.date.march' => 'March',
    'mautic.core.date.april' => 'April',
    'mautic.core.date.may' => 'May',
    'mautic.core.date.june' => 'June',
    'mautic.core.date.july' => 'July',
    'mautic.core.date.august' => 'August',
    'mautic.core.date.september' => 'September',
    'mautic.core.date.october' => 'October',
    'mautic.core.date.november' => 'November',
    'mautic.core.date.december' => 'December',
    'mautic.core.date.jan' => 'Jan',
    'mautic.core.date.feb' => 'Feb',
    'mautic.core.date.mar' => 'Mar',
    'mautic.core.date.apr' => 'Apr',
    'mautic.core.date.jun' => 'Jun',
    'mautic.core.date.jul' => 'Jul',
    'mautic.core.date.aug' => 'Aug',
    'mautic.core.date.sep' => 'Sep',
    'mautic.core.date.oct' => 'Oct',
    'mautic.core.date.nov' => 'Nov',
    'mautic.core.date.dec' => 'Dec',
    'mautic.error.invalid.specific.export.type' => 'Invalid export type %type%. Must be of %expected_type%.',
    'mautic.core.usage.not_found' => 'Looks like this component is not in use.',
    'mautic.report.group.audit.log' => 'Audit Log',
    'mautic.core.audit_log' => 'Audit Log',
    'mautic.audit_log.report.user_id' => 'User ID',
    'mautic.audit_log.report.user_name' => 'Username',
    'mautic.audit_log.report.bundle' => 'Bundle',
    'mautic.audit_log.report.object' => 'Object',
    'mautic.audit_log.report.object_id' => 'Object ID',
    'mautic.audit_log.report.action' => 'Action',
    'mautic.audit_log.report.details' => 'Details',
    'mautic.audit_log.report.date_added' => 'Date Added',
    'mautic.audit_log.report.ip_address' => 'IP Address',
    'mautic.core.optimistic_lock.changed_by_someone_else_error' => 'The record you are updating has been changed by someone else in the meantime. Please refresh the browser window and re-submit your changes.',
    'mautic.core.theme.hide' => 'Hide',
    'mautic.core.theme.unhide' => 'Show',
    'mautic.core.theme.form.confirm.hide' => 'Hide the theme, %theme%?',
    'mautic.placeholder_tokens.placeholder_tokens' => 'Tokens',
    'mautic.placeholder_tokens.placeholder_tokens.header' => 'Tokens help',
    'mautic.placeholder_tokens.placeholder_tokens.channels.explanation' => 'Customize your communication like a pro using these tokens in your channels.',
    'mautic.placeholder_tokens.component_tokens' => 'Components',
    'mautic.placeholder_tokens.variable_name' => 'Token name',
    'mautic.placeholder_tokens.variable_syntax' => 'Token syntax',
    'mautic.placeholder_tokens.component.asset_link' => 'Asset link for Asset id#',
    'mautic.placeholder_tokens.component.focus_item' => 'Focus Item id#',
    'mautic.placeholder_tokens.component.form' => 'Form id#',
    'mautic.placeholder_tokens.component.landing_page_link' => 'Landing Page link for page id#',
    'mautic.placeholder_tokens.introducing_tokens.title' => 'Introducing tokens',
    'mautic.placeholder_tokens.introducing_tokens.description' => 'Tokens are placeholders used within emails, landing pages, and other communications, which automatically get replaced with personalized information (like a contact\'s name, email, or custom field data) when the message is sent.',
    'mautic.placeholder_tokens.fallback_text_info' => 'The default value is specified after the | character. For example, if a contact doesn\'t have a First name while using this token <code>Hi {contactfield=firstname|there}</code>, the email will send the phrase as <code>Hi there</code>.',
    'mautic.core.theme.form.confirm.unhide' => 'Show the theme, %theme%?',
    'mautic.api.auth.error.accessdenied' => 'API authorization denied.',
    'mautic.api.auth.error.apidisabled' => 'API access has been disabled. Please contact the system administrator',
    'mautic.api.auth.error.parameter_absent' => 'The request has a missing parameter. If all parameters are present, a common reason for this error is typos in the Authorization header. Check for spelling errors, misplaced single/double quotes. etc. Remember that each OAuth Protocol parameter value must to be enclosed double quotes.',
    'mautic.api.auth.error.timestamp_refused' => 'The timestamp provided is invalid (either it doesn\'t have the right format, or it\'s out of the acceptable window).',
    'mautic.api.auth.error.nonce_used' => 'The nonce received is not acceptable.',
    'mautic.api.auth.error.signature_method_rejected' => 'The signature method used is unsupported.',
    'mautic.api.auth.error.signature_invalid' => 'The signature provided does not match the one calculated by the service.',
    'mautic.api.auth.error.consumer_key_unknown' => 'The consumer key provided is unsupported.',
    'mautic.api.auth.error.token_expired' => 'The access token provided is valid, but has expired.',
    'mautic.api.auth.error.token_rejected' => 'The token provided does not have the right format.',
    'mautic.api.auth.error.additional_authorization_required' => 'The access token does not have the correct access scopes.',
    'permission_denied' => 'The access session handle (ASH) has expired or is invalid.',
    'mautic.api.call.notfound' => 'Object not found.',
    'mautic.api.call.batch_exception' => 'A max of %limit% entities are supported at a time.',
    'mautic.api.call.id_missing' => 'ID is missing from the payload.',
    'mautic.api.client.form.auth_protocol' => 'Authorization Protocol',
    'mautic.api.client.form.clientid' => 'Client ID',
    'mautic.api.client.form.clientsecret' => 'Client Secret',
    'mautic.api.client.form.confirmdelete' => 'Delete the API client, %name%? Applications using this client will no longer have access to Mautic\'s API.',
    'mautic.api.client.form.confirmrevoke' => 'Revoke access for %name%?',
    'mautic.api.client.form.help.callback' => 'Specify a callback URI that is allowed. Leave blank to restrict callbacks.',
    'mautic.api.client.form.help.requesturis' => 'Specify the URI(s) that are allowed API access. You can submit multiple URIs by separating them with commas.',
    'mautic.api.client.form.name' => 'Client Name',
    'mautic.api.client.form.revoke' => 'Revoke Access',
    'mautic.api.client.header.edit' => 'Credentials - Edit %name%',
    'mautic.api.client.header.index' => 'API Credentials (Applications)',
    'mautic.api.client.header.new' => 'Credentials - New Credential',
    'mautic.api.client.menu.index' => 'API Credentials',
    'mautic.api.client.redirecturis' => 'Redirect URI',
    'mautic.api.client.searchcommand.callback' => 'callback',
    'mautic.api.client.searchcommand.redirecturi' => 'redirecturi',
    'mautic.api.client.thead.publicid' => 'Public Key',
    'mautic.api.client.thead.secret' => 'Secret Key',
    'mautic.api.config.form.api.enabled' => 'API enabled?',
    'mautic.api.config.form.api.basic_auth_enabled' => 'Enable HTTP basic auth?',
    'mautic.api.config.form.api.basic_auth.tooltip' => 'Enable HTTP basic authentication for Mautic\'s API. It is highly recommended to only use this with secure sites (HTTPS).',
    'mautic.api.config.form.api.enabled.tooltip' => 'Enable Mautic\'s API?',
    'mautic.api.config.form.api.oauth2_access_token_lifetime' => 'Access token lifetime (in minutes)',
    'mautic.api.config.form.api.oauth2_access_token_lifetime.tooltip' => 'If using OAuth2, set the lifetime of the access tokens used to authorize the request. Defaults to 60 minutes.',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime' => 'Refresh token lifetime (in days)',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime.tooltip' => 'If using OAuth2, set the lifetime of the refresh tokens which is used to request a new access token once expired. Once the refresh token expires, reauthorization is required. Defaults to 14 days.',
    'mautic.api.config.oauth2' => 'OAuth2',
    'mautic.api.oauth.accept' => 'Accept',
    'mautic.api.oauth.auth.failed' => 'OAuth authentication failed!',
    'mautic.api.oauth.clientnoname' => 'An application would like to connect to your account.',
    'mautic.api.oauth.clientwithname' => 'The application <strong>%name%</strong> would like to connect to your account.',
    'mautic.api.oauth.deny' => 'Deny',
    'mautic.api.oauth.header' => 'OAuth Authorization',
    'mautic.api.permissions.apiaccess' => 'API Access',
    'mautic.api.permissions.clients' => 'Clients (Applications) - User has access to',
    'mautic.api.permissions.granted' => 'Granted',
    'mautic.api.permissions.header' => 'API Permissions',
    'mautic.config.tab.apiconfig' => 'API Settings',
    'mautic.core.error.badrequest' => 'Bad request.',
    'mautic.api.error.api.disabled' => 'API disabled. You need to enable the API in the API settings of Mautic\'s Configuration.',
    'mautic.api.error.basic.auth.disabled' => 'Basic Auth disabled. You need to enable HTTP basic auth in the API settings of Mautic\'s Configuration.',
    'mautic.api.error.basic.auth.invalid.credentials' => 'Authorization denied, invalid credentials.',
    'mautic.asset.abtest.criteria' => 'Asset Stats',
    'mautic.asset.abtest.criteria.downloads' => 'Download rate',
    'mautic.asset.abtest.downloads' => '%count% downloads',
    'mautic.asset.abtest.label.downloads' => 'Number of downloads',
    'mautic.asset.abtest.label.hits' => 'Number of unique asset downloads',
    'mautic.asset.abtest.label.sentemils' => 'Number of sent emails',
    'mautic.asset.actions' => 'Asset actions',
    'mautic.asset.asset' => 'Asset',
    'mautic.protip.assets.gating' => 'Gate valuable assets behind a form to capture lead information before allowing the download.',
    'mautic.protip.assets.naming' => 'Use consistent naming conventions to keep assets organized',
    'mautic.protip.assets.repurpose' => 'Repurpose high-performing assets across different channels and campaigns',
    'mautic.protip.assets.track' => 'Track asset performance metrics in the dashboard widgets to identify top-performing content',
    'mautic.asset.asset.searchcommand.lang' => 'lang',
    'mautic.asset.asset.searchcommand.lang.description' => 'Filters assets by a specific language code',
    'mautic.asset.asset.downloads.total' => 'Total: count',
    'mautic.asset.asset.downloads.unique' => 'Unique: count',
    'mautic.asset.asset.error.missing.remote.path' => 'A remote URL must be specified when remote storage is selected.',
    'mautic.asset.asset.form.confirmbatchdelete' => 'Delete the selected assets?',
    'mautic.asset.asset.form.confirmdelete' => 'Delete the asset, %name%?',
    'mautic.asset.asset.form.file.upload' => 'Upload a file (max filesize allowed = %max%)',
    'mautic.asset.asset.form.language.help' => 'Select language of the asset.',
    'mautic.asset.asset.form.remotePath' => 'Remote URL',
    'mautic.asset.asset.form.storageLocation' => 'Storage Location',
    'mautic.asset.asset.form.storageLocation.local' => 'Local',
    'mautic.asset.asset.form.storageLocation.remote' => 'Remote',
    'mautic.asset.asset.form.disallow.crawlers' => 'Block search engines from indexing this file',
    'mautic.asset.asset.form.disallow.crawlers.descr' => 'If you don\'t want to index files like PDF, DOCX etc, this option will disallow search bots by using the X-Robots-Tag HTTP header.',
    'mautic.asset.asset.help.alias' => 'Letters and numbers (hyphens allowed) used for URL generation of this asset. A unique alias based on the title will be autogenerated if left empty.',
    'mautic.asset.asset.menu.edit' => 'Edit Asset',
    'mautic.asset.asset.menu.new' => 'New Asset',
    'mautic.asset.asset.path.relative' => 'Relative Path',
    'mautic.asset.asset.preview' => 'Preview',
    'mautic.asset.asset.size' => 'Filesize',
    'mautic.asset.asset.submitaction.downloadfile' => 'Download an asset',
    'mautic.asset.asset.submitaction.downloadfile.msg' => '<br />Your download should start within 5 seconds. If it does not, <a href=\'%url%\'>click here</a>.<script>setTimeout(function(){window.location=\'%url%\';}, 5000);</script>',
    'mautic.asset.asset.submitaction.downloadfile_descr' => 'Download the selected asset upon submitting the form.',
    'mautic.asset.asset.thead.download.count' => 'Download count',
    'mautic.asset.asset.url' => 'Download URL',
    'mautic.asset.assets' => 'Assets',
    'mautic.asset.campaign.event.assets' => 'Limit to Assets',
    'mautic.asset.campaign.event.assets.descr' => 'Select the assets this trigger applies to. If none are selected, the event will trigger for any asset.',
    'mautic.asset.campaign.event.download' => 'Downloads asset',
    'mautic.asset.campaign.event.download_descr' => 'Trigger actions upon downloading an asset.',
    'mautic.asset.config.form.allowed.extensions' => 'Allowed file extensions',
    'mautic.asset.config.form.allowed.extensions.tooltip' => 'Comma separated list of file extensions. Only files with specified file extensions will be able to upload.',
    'mautic.asset.config.form.upload.dir' => 'Path to the asset directory',
    'mautic.asset.config.form.upload.dir.tooltip' => 'Set the absolute path to where assets should be uploaded to. %kernel.project_dir%/app can be used as a placeholder for the app directory in the public web root. It is advised to use a directory outside of the public web root to prevent assets from being accessible by the public.',
    'mautic.asset.config.form.max.size' => 'Maximum size (MB)',
    'mautic.asset.config.form.max.size.tooltip' => 'Set the maximum size of uploaded assets in MB (Megabytes). Default value is 6MB.',
    'mautic.asset.downloadcount' => 'Download count',
    'mautic.asset.drop.file.here' => 'Drop the file here or click to browse and select the file.',
    'mautic.asset.error.file.failed' => 'File failed to upload.',
    'mautic.asset.event.download' => 'Asset downloaded',
    'mautic.asset.filename.local' => 'Local filename',
    'mautic.asset.filename.original' => 'Original filename',
    'mautic.asset.filename.remote' => 'Remote filename',
    'mautic.asset.form.submit.assets' => 'Asset',
    'mautic.asset.form.submit.assets_descr' => 'Choose the asset to be downloaded.',
    'mautic.asset.form.submit.latest.category' => 'Use the latest asset from the category',
    'mautic.asset.form.submit.latest.category_descr' => 'If \'Use latest file from the category\' Asset option is selected then the action will download the latest asset from the selected category.',
    'mautic.asset.graph.line.downloads' => 'Downloads',
    'mautic.asset.graph.pie.statuses' => 'Download HTTP statuses',
    'mautic.asset.no_audio_support' => 'Your browser does not support audio.',
    'mautic.asset.no_video_support' => 'Your browser does not support video.',
    'mautic.asset.noresults.tip' => 'Assets can be white papers, PDFs, images, docs, eBooks, or pretty much any electronic document that you want to distribute to customers. Want to offer an asset after a customer has submitted a form? Easy! Add the \'Download an asset\' action when building the form.',
    'mautic.asset.permissions.assets' => 'Assets - User has access to',
    'mautic.asset.permissions.header' => 'Asset Permissions',
    'mautic.asset.point.action.assets' => 'Limit to the selected assets',
    'mautic.asset.point.action.assets.descr' => 'Select the assets this action applies to. If none are selected, it\'ll apply to any asset.',
    'mautic.asset.point.action.download' => 'Downloads an asset',
    'mautic.asset.point.action.download_descr' => 'Update the contact\'s points when an asset is downloaded.',
    'mautic.asset.remote.file.browse' => 'Browse Remote Files',
    'mautic.asset.remote.no_results' => 'No remote files found.',
    'mautic.asset.remote.select_service' => 'Select the service to the left. If none are listed, configure the Cloud Storage addon.',
    'mautic.asset.report.download.code' => 'Response code',
    'mautic.asset.report.download.date_download' => 'Date downloaded',
    'mautic.asset.report.download_count' => 'Download count',
    'mautic.asset.report.downloads.table' => 'Asset Downloads',
    'mautic.asset.report.unique_download_count' => 'Unique download count',
    'mautic.asset.stage.action.download' => 'Download asset',
    'mautic.asset.table.most.downloaded' => 'Most downloaded assets',
    'mautic.asset.table.top.referrers' => 'Top referrers',
    'mautic.campaign.asset.download' => 'Asset downloaded',
    'mautic.config.AssetBundle.upload_dir' => 'Upload Directory',
    'mautic.config.tab.assetconfig' => 'Asset Settings',
    'mautic.asset.dashboard.widgets' => 'Asset Widgets',
    'mautic.asset.unique' => 'Unique',
    'mautic.asset.repetitive' => 'Repetitive',
    'mautic.widget.asset.downloads.in.time' => 'Downloads in time',
    'mautic.widget.unique.vs.repetitive.downloads' => 'Unique vs repetitive downloads',
    'mautic.widget.popular.assets' => 'Popular assets',
    'mautic.widget.created.assets' => 'Created assets',
    'mautic.report.group.assets' => 'Assets',
    'mautic.asset.asset.help.searchcommands' => '<strong>Search commands</strong><br />ids:ID1,ID2 (comma separated IDs, no spaces)<br />is:mine<br />is:published<br />is:unpublished<br />name:*<br />is:uncategorized<br />category:{category alias}',
    'mautic.asset.asset.error.file.mimetype' => 'The file type is not allowed.',
    'mautic.campaign.add_new_source' => 'Add a contact source...',
    'mautic.campaign.allow_restart' => 'Allow contacts to restart the campaign',
    'mautic.campaign.allow_restart.tooltip' => 'When enabled, if a contact is removed from the campaign for any reason then added back, they will restart from the beginning.',
    'mautic.campaign.campaign' => 'Campaign',
    'mautic.campaign.campaign.id' => 'Campaign ID',
    'mautic.campaign.campaign.addremovelead' => 'Add / remove contact',
    'mautic.campaign.campaign.description' => '<strong>Campaign description:</strong> %description%',
    'mautic.campaign.campaign.launch.builder' => 'Launch Campaign Builder',
    'mautic.campaign.campaign.leads' => 'Contacts added',
    'mautic.campaign.campaigns' => 'Campaigns',
    'mautic.protip.campaigns.reengagement' => 'Implement re-engagement campaigns for leads that become inactive',
    'mautic.protip.campaigns.survey' => 'Deploy targeted survey campaigns to gather actionable insights and improve customer satisfaction',
    'mautic.protip.campaigns.crosssell' => 'Use personalized cross-sell campaigns based on purchase history to increase customer lifetime value',
    'mautic.protip.campaigns.onboarding' => 'Create automated onboarding sequences to guide new users through key product features and increase activation rates',
    'mautic.campaign.connection.trigger.date.label' => 'wait until %full%',
    'mautic.campaign.connection.trigger.date.label_inaction' => 'by %full%',
    'mautic.campaign.connection.trigger.interval.label' => 'wait %number% %unit%',
    'mautic.campaign.connection.trigger.interval.label_inaction' => 'within %number% %unit%',
    'mautic.campaign.email.send.to.user' => 'Send email to user',
    'mautic.campaign.event.back_to_panel' => 'Back to event selection panel',
    'mautic.campaign.event.action.descr' => 'An action is something executed by Mautic (e.g. send an email).',
    'mautic.campaign.event.action.header' => 'Action',
    'mautic.campaign.event.actions.header' => 'Actions',
    'mautic.campaign.event.addremovelead' => 'Change campaigns',
    'mautic.campaign.event.addremovelead_descr' => 'Add contact to specific campaigns and/or remove from specific campaigns when the event is triggered.',
    'mautic.campaign.event.campaign_unpublished' => 'The campaign was unpublished.',
    'mautic.campaign.event.condition.header' => 'Condition',
    'mautic.campaign.event.condition.descr' => 'A condition is based on known profile field values or submitted form data.',
    'mautic.campaign.event.conditions.header' => 'Conditions',
    'mautic.campaign.event.decision.descr' => 'A decision is made when a contact decides to take action or not (e.g. opened an email).',
    'mautic.campaign.event.decision.header' => 'Decision',
    'mautic.campaign.event.decisions.header' => 'Decisions',
    'mautic.campaign.event.clone.header' => 'Insert cloned event here',
    'mautic.campaign.event.clone.name' => 'Name',
    'mautic.campaign.event.clone.from' => 'From',
    'mautic.campaign.event.clone.insert' => 'Insert',
    'mautic.campaign.event.clone.request.missing' => 'The clone is no longer available',
    'mautic.campaign.event.clone.btn.tooltip' => 'Clone',
    'mautic.campaign.event.clone.new.campaign' => 'New campaign',
    'mautic.campaign.event.edit.btn.tooltip' => 'Edit',
    'mautic.campaign.event.remove.btn.tooltip' => 'Remove',
    'mautic.campaign.event.inline.triggerimmediately' => 'immediately',
    'mautic.campaign.event.inline.triggerinterval' => '+ %interval% %unit%',
    'mautic.campaign.event.last_error' => 'Last execution error',
    'mautic.campaign.event.failed' => 'Failed to execute campaign event for %contact%.',
    'mautic.campaign.event.failed.campaign.unpublished' => 'Due to repeated event failures, your %campaign% campaign has been unpublished. The failing event is named %event%.',
    'mautic.campaign.event.failed.timeline' => 'Generic error.',
    'mautic.campaign.event.intervalunit.choice.d' => 'day(s)',
    'mautic.campaign.event.intervalunit.choice.h' => 'hour(s)',
    'mautic.campaign.event.intervalunit.choice.i' => 'minute(s)',
    'mautic.campaign.event.intervalunit.choice.m' => 'month(s)',
    'mautic.campaign.event.intervalunit.choice.y' => 'year(s)',
    'mautic.campaign.event.intervalunit.d' => '{0} days|{1} day|[2,Inf] days',
    'mautic.campaign.event.intervalunit.h' => '{0} hours|{1} hour|[2,Inf] hours',
    'mautic.campaign.event.intervalunit.i' => '{0} minutes|{1} minute|[2,Inf] minutes',
    'mautic.campaign.event.intervalunit.m' => '{0} months|{1} month|[2,Inf] months',
    'mautic.campaign.event.intervalunit.y' => '{0} years|{1} year|[2,Inf] years',
    'mautic.campaign.event.timed.choice.today' => 'Is Today',
    'mautic.campaign.event.timed.choice.yesterday' => 'Is Yesterday',
    'mautic.campaign.event.timed.choice.tomorrow' => 'Is Tomorrow',
    'mautic.campaign.event.timed.choice.anniversary' => 'Anniversary',
    'mautic.campaign.event.timed.choice.custom' => 'Custom',
    'mautic.campaign.event.leadchange' => 'contact changed campaigns',
    'mautic.campaign.event.leadchange_descr' => 'Trigger actions when a contact is added/removed from a campaign.',
    'mautic.campaign.event.reschedule' => 'Reschedule this event.',
    'mautic.campaign.event.save' => 'Save',
    'mautic.campaign.event.cancel' => 'Cancel this event (it cannot be rescheduled later).',
    'mautic.campaign.event.cancelled' => 'This event has been cancelled. Reschedule it to restore.',
    'mautic.campaign.event.cancelled.time' => 'This event was scheduled for %date% but has been cancelled.',
    'mautic.campaign.event.has_last_attempt_error' => 'This event encountered an error during the last attempt to process.',
    'mautic.campaign.event.systemchanges.header' => 'System Changes',
    'mautic.campaign.event.triggered' => '\'%event%\' event triggered',
    'mautic.campaign.event.triggered.description' => 'Triggered on \'%campaign%\' campaign by %lead%',
    'mautic.campaign.event.upcoming' => '\'%event%\' event triggers',
    'mautic.campaign.event.upcoming.description' => 'Will be triggered on \'%campaign%\'',
    'mautic.campaign.filter.placeholder' => 'Contact Source Filter',
    'mautic.campaign.form.addevent' => 'Use the list to the right to add triggers and actions to the dripflow.',
    'mautic.campaign.form.addtocampaigns' => 'Add contact to',
    'mautic.campaign.form.confirmbatchdelete' => 'Delete the selected campaigns?',
    'mautic.campaign.form.confirmdelete' => 'Delete the campaign, %name%?',
    'mautic.campaign.form.lead_source' => 'Contact source',
    'mautic.campaign.form.limittocampaigns' => 'Limit to campaigns',
    'mautic.campaign.form.limittocampaigns_descr' => 'Select the campaigns this trigger applies to (meaning that the trigger will only fire for the selected campaigns). If none are selected, it\'ll apply to any campaign.',
    'mautic.campaign.form.modalheader' => 'Campaign Event Details',
    'mautic.campaign.form.removefromcampaigns' => 'Remove contact from',
    'mautic.campaign.form.thiscampaign' => 'This campaign',
    'mautic.campaign.form.thiscampaign_restart' => 'This campaign (restart the campaign)',
    'mautic.campaign.form.trigger_leadchanged' => 'Apply when contact is',
    'mautic.campaign.form.trigger_leadchanged_added' => 'added',
    'mautic.campaign.form.trigger_leadchanged_removed' => 'removed',
    'mautic.campaign.form.type' => 'Execute this event...',
    'mautic.campaign.form.type_inaction' => 'Execute this event if the contact does not take action...',
    'mautic.campaign.form.type.date' => 'at a specific date/time',
    'mautic.campaign.form.type.date_inaction' => 'by a specific date/time',
    'mautic.campaign.form.type.help' => 'This event will be executed for newly added Contacts to the Campaign, even if the scheduled date is in the past. For scheduled Emails, it is recommended that you unpublish the Email if you would not like Contacts to receive it after that date. All dates are in the Contact\'s timezone.',
    'mautic.campaign.form.type.immediate' => 'immediately',
    'mautic.campaign.form.type.interval' => 'at a relative time period',
    'mautic.campaign.form.type.interval_inaction' => 'within a relative time period',
    'mautic.campaign.form.type.interval_schedule_at' => 'Send from',
    'mautic.campaign.form.type.interval_schedule_between_hours' => 'or between the hours of',
    'mautic.campaign.form.type.interval_trigger_restricted_dow' => 'Schedule only on the selected days of the week:',
    'mautic.campaign.form.type.optimized' => 'optimal for contact',
    'mautic.campaign.form.type.trigger_window_day' => 'Within 24 hours for optimal timing',
    'mautic.campaign.form.type.trigger_window_week' => 'Within 7 days for the best day',
    'mautic.campaign.lead.changeowner' => 'Change contact owner',
    'mautic.campaign.leadsource.form' => 'Form',
    'mautic.campaign.leadsource.forms' => 'Campaign forms',
    'mautic.campaign.leadsource.forms.tooltip' => 'Contacts created from submissions for the selected forms will be automatically added to this campaign.',
    'mautic.campaign.leadsource.header' => 'Contact Sources',
    'mautic.campaign.leadsource.header.singular' => 'Contact Source',
    'mautic.campaign.leadsource.list' => 'Segment',
    'mautic.campaign.leadsource.lists' => 'Contact segments',
    'mautic.campaign.leadsource.lists.tooltip' => 'Contacts that are members of the selected segments will be automatically added to this campaign.',
    'mautic.campaign.menu.edit' => 'Edit Campaign',
    'mautic.campaign.menu.index' => 'Campaigns',
    'mautic.campaign.menu.new' => 'New Campaign',
    'mautic.campaign.member.removed' => 'Contact removed from campaign on %date%',
    'mautic.campaign.modify.warning' => 'WARNING: This campaign is currently published. Modifying events or removing contact segments may affect contacts in mid-campaign.',
    'mautic.campaign.noresults.tip' => 'Campaigns allow automated interaction with contacts through dripflows based on series of actions and decisions. For example, you can schedule a follow up email if the contact opens an email already sent to them! Or give the contact 10 points if they click through to a specific landing page.',
    'mautic.campaign.permissions.campaigns' => 'Campaigns - User has access to',
    'mautic.campaign.permissions.header' => 'Campaign Permissions',
    'mautic.campaign.point.trigger' => 'Campaign triggers',
    'mautic.campaign.point.trigger.changecampaigns' => 'Modify contact\'s campaigns',
    'mautic.campaign.preview.header' => 'Preview',
    'mautic.campaign.rebuild.leads_affected' => '%leads% contact(s) affected',
    'mautic.campaign.rebuild.rebuilding' => 'Rebuilding contacts for campaign %id%',
    'mautic.campaign.rebuild.no_lists' => 'There are no lists to rebuild from.',
    'mautic.campaign.rebuild.not_found' => 'Campaign #%id% does not exist',
    'mautic.campaign.rebuild.to_be_added' => '%leads% total contact(s) to be added in batches of %batch%',
    'mautic.campaign.rebuild.to_be_removed' => '%leads% total contact(s) to be removed in batches of %batch%',
    'mautic.campaign.scheduled' => 'Campaign event scheduled',
    'mautic.campaign.summarizing' => 'Building summary statistics for past campaign events, in batches of %batch% hours. Will back-fill data from the newest to the oldest events.',
    'mautic.campaign.trigger.event_count' => '%events% total events(s) to be processed in batches of %batch% contacts',
    'mautic.campaign.trigger.events_executed' => '{0} 0 total events were executed|{1} 1 total event was executed|[2,Inf] %count% total events were executed',
    'mautic.campaign.trigger.events_scheduled' => '{0} 0 total events were scheduled|{1} 1 total event was scheduled|[2,Inf] %count% total events were scheduled',
    'mautic.campaign.trigger.decision_count_analyzed' => '%decisions% total decisions(s) to be analyzed for inactivity for approximately %leads% contacts in batches of %batch%',
    'mautic.campaign.trigger.lead_count_processed' => '%leads% total contact(s) to be processed in batches of %batch%',
    'mautic.campaign.trigger.negative' => 'Triggering events for inactive contacts',
    'mautic.campaign.trigger.scheduled' => 'Triggering scheduled events',
    'mautic.campaign.trigger.starting' => 'Triggering events for newly added contacts',
    'mautic.campaign.trigger.triggering' => 'Triggering events for campaign %id%',
    'mautic.campaign.triggered' => 'Campaign action triggered',
    'mautic.campaign.user.devent.description' => '<strong>Event description:</strong> %description%',
    'mautic.campaign.user.event.triggered' => 'Triggered <strong>%event%</strong> event',
    'mautic.campaign.dashboard.widgets' => 'Campaign Widgets',
    'mautic.widget.events.in.time' => 'Events triggered in time',
    'mautic.widget.leads.added.in.time' => 'Leads added in time',
    'mautic.campaign.triggered.events' => 'Triggered Events',
    'mautic.config.tab.campaignconfig' => 'Campaign Settings',
    'mautic.campaignconfig.campaign_time_wait_on_event_false' => 'Wait time before retrying a failed action',
    'mautic.campaignconfig.campaign_time_wait_on_event_false_tooltip' => 'If an action fails to execute, wait this long before trying again.',
    'mautic.campaignconfig.campaign_by_range' => 'Use date range for all views',
    'mautic.campaignconfig.campaign_by_range.tooltip' => 'The actions, conditions, decisions and contacts tabs will be based on the date range provided when viewing a campaign.',
    'mautic.campaignconfig.use_summary' => 'Use summary statistics',
    'mautic.campaignconfig.use_summary.tooltip' => 'Improves performance when viewing a campaign with thousands of events per day by using summarized data. May require you to run a command via SSH to backfill your data once.',
    'mautic.campaign.stats' => 'Campaign statistics',
    'mautic.stage.campaign.event.change_descr' => 'Choose a stage to change a contact to.',
    'mautic.campaign.command.process.messages' => 'Processing message queue',
    'mautic.campaign.command.messages.sent' => 'Messages sent: %events%',
    'mautic.campaign.lead.addtocompany' => 'Add contact to company',
    'mautic.campaign.event.messages.header' => 'Messages',
    'mautic.campaign.event.message.header' => 'Message',
    'mautic.campaign.event.message.descr' => 'Send a message through the contact\'s preferred channel.',
    'mautic.report.group.campaign_lead_event_log' => 'Campaigns',
    'mautic.campaign.events' => 'Campaign Events',
    'mautic.report.campaign.event.name' => 'Event name',
    'mautic.report.campaign.event.description' => 'Event description',
    'mautic.report.campaign.event.type' => 'Event context',
    'mautic.report.campaign.event.event_type' => 'Event type',
    'mautic.report.campaign.event.trigger_date' => 'Event trigger date',
    'mautic.report.campaign.event.trigger_mode' => 'Event trigger mode',
    'mautic.report.campaign.event.channel' => 'Event channel',
    'mautic.report.campaign.event.channel_id' => 'Event channel ID',
    'mautic.report.campaign.event.rotation' => 'Rotation',
    'mautic.report.campaign.log.date_triggered' => 'Event log date triggered',
    'mautic.report.campaign.log.is_scheduled' => 'Event log is scheduled',
    'mautic.report.campaign.log.trigger_date' => 'Event log trigger date',
    'mautic.report.campaign.log.system_triggered' => 'Event log system triggered?',
    'mautic.report.campaign.log.non_action_path_taken' => 'Event log non-action path taken?',
    'mautic.report.campaign.log.channel' => 'Event log channel',
    'mautic.report.campaign.log.channel_id' => 'Event log channel ID',
    'mautic.report.campaign.yes.percent' => 'Success percent',
    'mautic.report.campaign.no.percent' => 'Failed percent',
    'mautic.report.campaign.completed.actions' => 'Completed actions',
    'mautic.report.campaign.pending.actions' => 'Pending actions',
    'mautic.campaign.event.jump_to_event' => 'Jump to Event',
    'mautic.campaign.campaign.jump_to_event' => 'Jump to Event',
    'mautic.campaign.campaign.jump_to_event.target_not_exist' => 'Jump to target no longer exists',
    'mautic.campaign.event.jump_to_event_descr' => 'Jump to the chosen event within the campaign flow.',
    'mautic.campaign.form.jump_to_event' => 'Event to jump to',
    'mautic.campaign.message.send' => 'Messages sent',
    'mautic.campaign.form.confirmation.message' => 'Are you sure you want to unpublish this campaign and stop processing contact(s) and campaign event(s) (including scheduled event(s)) immediately?',
    'mautic.campaign.form.confirmation.confirm_text' => 'Yes',
    'mautic.campaign.form.confirmation.cancel_text' => 'No',
    'mautic.campaign.if' => 'Filter by',
    'mautic.campaign.when' => 'Check if',
    'mautic.campaign.locate' => 'Locate',
    'mautic.config.peak_interaction_timer.title' => 'Optimal for Contact event scheduler',
    'mautic.config.peak_interaction_timer.cache_timeout_min_message' => 'The cache timeout must be greater than or equal to 0.',
    'mautic.config.peak_interaction_timer.fetch_limit_min_message' => 'The fetch limit must be greater than 10.',
    'mautic.config.peak_interaction_timer.best_default_hour_start' => 'Default Optimal Start Hour',
    'mautic.config.peak_interaction_timer.best_default_hour_end' => 'Default Optimal End Hour',
    'mautic.config.peak_interaction_timer.best_default_days' => 'Default Optimal Days',
    'mautic.config.peak_interaction_timer.cache_timeout' => 'Interaction Data Cache Timeout',
    'mautic.config.peak_interaction_timer.fetch_interactions_from' => 'Fetch Interactions From',
    'mautic.config.peak_interaction_timer.fetch_limit' => 'Interaction Fetch Limit',
    'mautic.config.peak_interaction_timer.cache.off' => 'No cache',
    'mautic.config.peak_interaction_timer.cache.month' => '1 Month',
    'mautic.config.peak_interaction_timer.fetch.from_30_days' => 'Last 30 Days',
    'mautic.config.peak_interaction_timer.fetch.from_60_days' => 'Last 60 Days',
    'mautic.config.peak_interaction_timer.fetch.from_90_days' => 'Last 90 Days',
    'mautic.config.peak_interaction_timer.best_default_hour_start.tooltip' => 'Set the default start hour for the optimal interaction window when specific contact data is unavailable.',
    'mautic.config.peak_interaction_timer.best_default_hour_end.tooltip' => 'Set the default end hour for the optimal interaction window when specific contact data is unavailable.',
    'mautic.config.peak_interaction_timer.best_default_days.tooltip' => 'Select the default days of the week that are considered optimal for interaction when specific contact data is unavailable.',
    'mautic.config.peak_interaction_timer.cache_timeout.tooltip' => 'Choose how long the interaction data should be cached. Select "No cache" to disable caching or "1 Month" to cache data for a month.',
    'mautic.config.peak_interaction_timer.fetch_interactions_from.tooltip' => 'Select the time frame for fetching interaction data. This determines how far back the system will look for interactions.',
    'mautic.config.peak_interaction_timer.fetch_limit.tooltip' => 'Set the maximum number of interactions of each type (e.g., page hits, email reads) to retrieve for timing optimization.',
    'mautic.category.createnew' => 'Create new category...',
    'mautic.category.form.alias.help' => 'Letters and numbers (hyphens allowed) used for URL generation of this category. A unique alias based on the title will be autogenerated if left empty.',
    'mautic.category.form.confirmbatchdelete' => 'Delete the selected categories? Associated items will NOT be deleted but will be assigned as uncategorized.',
    'mautic.category.form.confirmdelete' => 'Delete the category, %name%? Associated items will NOT be deleted but will be assigned as uncategorized.',
    'mautic.category.global' => 'Global',
    'mautic.category.header.edit' => 'Edit %type% Category - %name%',
    'mautic.category.header.index' => 'Categories',
    'mautic.category.header.new' => 'New Category',
    'mautic.category.menu.index' => 'Categories',
    'mautic.category.noresults.tip' => 'Categories help organize and group items together. In many of the filters, you can type category:{alias} (replace {alias} with the real deal) to show the items within a specific category.',
    'mautic.category.permissions.categories' => 'Categories - User has access to',
    'mautic.category.permissions.header' => 'Category Permissions',
    'mautic.global.global' => 'Global',
    'mautic.channel.messages' => 'Marketing Messages',
    'mautic.channel.message.all_contacts' => 'This message has been sent to the following contacts.',
    'mautic.channel.message.channel_contacts' => 'This channel was used for the following contacts during the timeframe selected above:',
    'mautic.channel.message.header.new' => 'New Marketing Message',
    'mautic.channel.message.failed' => 'No channel was successful in sending the message.',
    'mautic.channel.message.form.message' => 'Message',
    'mautic.channel.message.form.enabled' => 'Enabled?',
    'mautic.channel.message.send.attempts' => 'Attempts',
    'mautic.channel.message.send.attempts.tooltip' => 'Number of attempts if an message has failed',
    'mautic.channel.message.send.priority' => 'Priority',
    'mautic.channel.message.send.priority.high' => 'High',
    'mautic.channel.message.send.priority.normal' => 'Normal',
    'mautic.channel.message.send.priority.tooltip' => 'Messages with priority set as high will be handled before rescheduled messages',
    'mautic.channel.permissions.header' => 'Channel Permissions',
    'mautic.channel.permissions.messages' => 'Marketing Messages - Users have access to',
    'mautic.channel.form.additem' => 'Nothing found here! Change that by adding a new item.',
    'mautic.channel.campaign.event.send' => 'Send a marketing message',
    'mautic.channel.campaign.event.send_descr' => 'Select from the list of marketing messages to send in this campaign',
    'mautic.channel.send.selectmessages' => 'Select a marketing message',
    'mautic.channel.choose.messages_descr' => 'Marketing messages',
    'mautic.email.send.edit.message' => 'Edit Message',
    'mautic.channel.message.send.marketing.message' => 'Send marketing message',
    'mautic.channel.message.send.marketing.message.descr' => 'Send a message through the configured channels within the marketing message selected.',
    'mautic.messages.processed.messages' => 'Messages Sent by Channel',
    'mautic.channel.message.form.confirmdelete' => 'Delete this message?',
    'mautic.queued.channel' => 'Message Queued for channel - ',
    'mautic.message.queue' => 'Message Queue',
    'mautic.queued.message.timeline.status' => 'Status',
    'mautic.queued.message.event.cancel' => 'Cancel',
    'mautic.queued.message.timeline.attempts' => 'Attempts',
    'mautic.queued.message.timeline.channel' => 'Channel',
    'mautic.queued.message.timeline.date.added' => 'Date Added',
    'mautic.queued.message.timeline.rescheduled' => 'Rescheduled Date',
    'mautic.message.form.confirmdelete' => 'Delete the marketing message, %name%?',
    'mautic.message.queue.report.channel' => 'Message channel',
    'mautic.message.queue.report.channel_id' => 'Message ID',
    'mautic.message.queue.report.priority' => 'Priority',
    'mautic.message.queue.report.max_attempts' => 'Max attempts',
    'mautic.message.queue.report.attempts' => 'Total attempts',
    'mautic.message.queue.report.success' => 'Success',
    'mautic.message.queue.report.status' => 'Status',
    'mautic.message.queue.report.last_attempt' => 'Last attempt date',
    'mautic.message.queue.report.date_sent' => 'Date sent',
    'mautic.message.queue.report.scheduled_date' => 'Scheduled Date',
    'mautic.message.queue.report.date_published' => 'Date published',
    'mautic.report.group.message.channel' => 'Channels Messages',
    'mautic.messages.messages' => 'Marketing Messages',
    'mautic.config.header.index' => 'Configuration',
    'mautic.config.menu.index' => 'Configuration',
    'mautic.config.restricted' => 'Set by system',
    'mautic.config.notwritable' => 'The configuration file is not writable! Changes will not be saved.',
    'mautic.config.remove_file_contents' => 'Remove stored contents for this setting?',
    'mautic.sysinfo.header.index' => 'System Info',
    'mautic.sysinfo.menu.index' => 'System Info',
    'mautic.sysinfo.tab.phpinfo' => 'PHP Info',
    'mautic.sysinfo.tab.recommendations' => 'Recommendations',
    'mautic.sysinfo.no.recommendations' => 'There are no recommendations for you right now. Your server is configured properly!',
    'mautic.sysinfo.tab.folders' => 'Folder & File Permissions',
    'mautic.sysinfo.folders.title' => 'The following folders and files must be writable for Mautic to work correctly.',
    'mautic.sysinfo.folder.path' => 'Folder/File Path',
    'mautic.sysinfo.is.writable' => 'Is writable',
    'mautic.sysinfo.writable' => 'Writable',
    'mautic.sysinfo.unwritable' => 'Unwritable',
    'mautic.sysinfo.tab.log' => 'Log',
    'mautic.sysinfo.log.title' => 'Current Error Log',
    'mautic.sysinfo.log.missing' => 'Today\'s Mautic error log is empty. Check server error log for error messages Mautic didn\'t have a chance to catch.',
    'mautic.sysinfo.phpinfo.missing' => 'Information is not available. PHP function phpinfo() is disabled on your server.',
    'mautic.sysinfo.phpinfo.phpversion' => 'PHP function phpinfo() is disabled on your server. Your PHP version is <b>%phpversion%</b>.',
    'mautic.sysinfo.tab.dbinfo' => 'Database info',
    'mautic.sysinfo.dbinfo.title' => 'Database info',
    'mautic.sysinfo.dbinfo.property' => 'Property',
    'mautic.sysinfo.dbinfo.value' => 'Value',
    'mautic.sysinfo.dbinfo.version' => 'Version',
    'mautic.sysinfo.dbinfo.driver' => 'Doctrine driver',
    'mautic.sysinfo.dbinfo.platform' => 'Doctrine database platform (automatically detected)',
    'mautic.config.dsn.scheme' => 'Scheme',
    'mautic.config.dsn.host' => 'Host',
    'mautic.config.dsn.port' => 'Port',
    'mautic.config.dsn.user' => 'User',
    'mautic.config.dsn.password' => 'Password',
    'mautic.config.dsn.path' => 'Path',
    'mautic.config.dsn.options' => 'Options',
    'mautic.config.dsn.using_current_dsn' => 'Using currently saved DSN',
    'mautic.config.dsn.save_to_test' => 'Save changes to test the DSN.',
    'mautic.dashboard.confirmation_layout_name' => 'Enter a name for this dashboard:',
    'mautic.dashboard.create.past.tense' => 'created',
    'mautic.dashboard.delete_layout' => 'Delete this layout?',
    'mautic.dashboard.delete.past.tense' => 'deleted',
    'mautic.dashboard.generated_by' => 'Generated by %name% on %date%',
    'mautic.dashboard.header.index' => 'Dashboard',
    'mautic.dashboard.identified.past.tense' => 'identified',
    'mautic.dashboard.ipadded.past.tense' => 'added IP',
    'mautic.dashboard.label.downloads' => 'Downloads',
    'mautic.dashboard.label.hits' => 'Hits',
    'mautic.dashboard.label.lang' => 'Lang',
    'mautic.dashboard.label.title' => 'Title',
    'mautic.dashboard.apply_default' => 'Apply the default dashboard',
    'mautic.dashboard.menu.index' => 'Dashboard',
    'mautic.dashboard.update.past.tense' => 'updated',
    'mautic.dashboard.date.today' => 'Today',
    'mautic.dashboard.date.yesterday' => 'Yesterday',
    'mautic.dashboard.date.last_7_days' => 'Last 7 days',
    'mautic.dashboard.date.last_30_days' => 'Last 30 days',
    'mautic.dashboard.date.last_90_days' => 'Last 90 days',
    'mautic.note.no.upcoming.emails' => 'No emails are scheduled to be sent.',
    'mautic.dashboard.label.created.leads' => 'Created leads',
    'mautic.dashboard.label.url' => 'URL',
    'mautic.dashboard.label.unique.hit.count' => 'Unique hit count',
    'mautic.dashboard.label.total.hit.count' => 'Total hit count',
    'mautic.dashboard.label.email.id' => 'Email ID',
    'mautic.dashboard.label.email.name' => 'Email name',
    'mautic.dashboard.label.contact.id' => 'Contact ID',
    'mautic.dashboard.label.contact.email.address' => 'Contact email address',
    'mautic.dashboard.label.contact.open' => 'Contact open',
    'mautic.dashboard.label.contact.click' => 'Clicks',
    'mautic.dashboard.label.contact.links.clicked' => 'Links clicked',
    'mautic.dashboard.label.segment.id' => 'Segment ID',
    'mautic.dashboard.label.segment.name' => 'Segment name',
    'mautic.dashboard.label.company.id' => 'Company ID',
    'mautic.dashboard.label.company.name' => 'Company name',
    'mautic.dashboard.label.campaign.id' => 'Company ID',
    'mautic.dashboard.label.campaign.name' => 'Campaign name',
    'mautic.dashboard.widget.add' => 'Add widget',
    'mautic.dashboard.widget.no_data' => 'No data found',
    'mautic.dashboard.export.widgets' => 'Export',
    'mautic.dashboard.save_as_predefined' => 'Save as pre-defined',
    'mautic.dashboard.widget.import' => 'Import or select pre-defined',
    'mautic.dashboard.widget.form.name' => 'Name',
    'mautic.dashboard.widget.form.type' => 'Type',
    'mautic.dashboard.widget.form.width' => 'Width',
    'mautic.dashboard.widget.form.height' => 'Height',
    'mautic.dashboard.widget.form.ordering' => 'Place before',
    'mautic.dashboard.widget.ordering.last' => 'Last',
    'mautic.dashboard.widget.header.edit' => 'Edit widget',
    'mautic.dashboard.widget.header.new' => 'New widget',
    'mautic.dashboard.widget.header.delete' => 'Delete widget',
    'mautic.dashboard.widget.data.loaded.from.cache' => 'Showing previously stored data',
    'mautic.dashboard.widget.data.loaded.from.database' => 'Just retrieved latest data',
    'mautic.dashboard.widget.size.extra_small' => 'Extra small (215px)',
    'mautic.dashboard.widget.size.small' => 'Small (330px)',
    'mautic.dashboard.widget.size.medium' => 'Medium (445px)',
    'mautic.dashboard.widget.size.large' => 'Large (560px)',
    'mautic.dashboard.widget.size.extra_large' => 'Extra large (675px)',
    'mautic.dashboard.import' => 'Import a pre-defined dashboard',
    'mautic.dashboard.predefined' => 'Pre-defined dashboards',
    'mautic.dashboard.import.start.instructions' => 'Upload a pre-defined dashboard',
    'mautic.dashboard.widgets.preview' => 'Preview of the selected pre-defined dashboard',
    'mautic.dashboard.date.from' => 'From',
    'mautic.dashboard.date.to' => 'To',
    'mautic.dashboard.nowidgets.tip.header' => 'Hello there!',
    'mautic.dashboard.nowidgets.tip' => 'There are no widgets in your dashboard but don\'t panic! You can create the widgets with the "Add widget" button above, "Import" a dashboard from a friend or',
    'mautic.dashboard.missing.permission' => 'You do not have the permission to see the data from %section% section.',
    'mautic.dashboard.preview' => 'Preview',
    'mautic.dashboard.phpversionwarning.title' => 'Please update your PHP version',
    'mautic.dashboard.phpversionwarning.body' => 'You are currently using PHP %phpversion%, an outdated and insecure version of PHP. Future versions of Mautic won\'t support this version anymore.<br>For an overview of supported PHP versions per Mautic version, please visit <a target="_blank" href="https://www.mautic.org/download/requirements">the Mautic website</a>.',
    'mautic.dynamicContent.dynamicContent' => 'Dynamic Content',
    'mautic.dynamicContent.dynamicContents' => 'Dynamic Contents',
    'mautic.placeholder_tokens.dynamic_content_tokens' => 'Dynamic Content',
    'mautic.placeholder_tokens.dynamic_content.example' => '[Dynamic Content 1] | for example User-defined variable name',
    'mautic.dynamicContent.campaign.event.form.dynamicContents' => 'Limit to Pages',
    'mautic.dynamicContent.campaign.event.form.dynamicContents.descr' => 'Select the pages this trigger applies to. If none are selected, it\'ll apply to any page.',
    'mautic.dynamicContent.campaign.event.form.url' => 'URL',
    'mautic.dynamicContent.campaign.event.form.url.descr' => 'Insert the URL of the page where you placed the tracking pixel. It is possible to use wildcard (*). Example: *product/123* will match http://web.com/product/1234.htm. Separate multiple URLs with a comma.',
    'mautic.dynamicContent.campaign.event.dynamicContenthit' => 'Visits a page',
    'mautic.dynamicContent.campaign.event.dynamicContenthit_descr' => 'Trigger actions on a page/url hit.',
    'mautic.dynamicContent.config.form.cat.in.url' => 'Show category in page URL?',
    'mautic.dynamicContent.config.form.cat.in.url.tooltip' => 'If enabled, the category slug will be included in the URL.',
    'mautic.dynamicContent.config.form.google.analytics' => 'Analytics script (i.e. Google Analytics)',
    'mautic.dynamicContent.config.form.google.analytics.tooltip' => 'Insert the analytics script to have it automatically included in the source of landing pages.',
    'mautic.dynamicContent.event.hit' => 'Page Hit',
    'mautic.dynamicContent.event.publish.down' => 'Set %dwc% as unavailable',
    'mautic.dynamicContent.event.publish.down.description' => 'Dynamic Content \'%dwc%\' is going to become unavailable for use.',
    'mautic.dynamicContent.event.publish.up' => 'Set %dwc% as unavailable',
    'mautic.dynamicContent.event.publish.up.description' => 'Page \'%dwc%\' is going to become available for use.',
    'mautic.dynamicContent.form.internal.name' => 'Internal Name',
    'mautic.dynamicContent.form.confirmbatchdelete' => 'Delete the selected items? WARNING - this will also delete all associated translations!',
    'mautic.dynamicContent.form.confirmdelete' => 'Delete the dynamic content item, %name%? WARNING - this will also delete all associated translations!',
    'mautic.dynamicContent.form.content' => 'Content',
    'mautic.dynamicContent.form.content.help' => 'The content to return when this variant/default item is requested.',
    'mautic.dynamicContent.form.language.help' => 'Translate the content into multiple languages and link them together by assigning them to a parent page. Language selection links will become available on the related landing pages for customers to choose the language they want to see.',
    'mautic.dynamicContent.header.edit' => 'Edit Dynamic Content - %name%',
    'mautic.dynamicContent.header.new' => 'New Dynamic Content',
    'mautic.dynamicContent.menu.edit' => 'Edit Page',
    'mautic.dynamicContent.menu.view' => 'View Page',
    'mautic.dynamiccontent.permissions.header' => 'Dynamic Content Permissions',
    'mautic.dynamiccontent.permissions.dynamiccontents' => 'Dynamic Content - User has access to',
    'mautic.dynamicContent.publish.down' => 'Set as unavailable',
    'mautic.dynamicContent.publish.up' => 'Set as available',
    'mautic.dynamicContent.report.revision' => 'Revision',
    'mautic.dynamicContent.campaign.send_dwc' => 'Push dynamic content',
    'mautic.dynamicContent.campaign.send_dwc.tooltip' => 'Trigger actions when a Dynamic Content slot is requested.',
    'mautic.dynamicContent.send.selectDynamicContents.default' => 'Select Default Content',
    'mautic.dynamicContent.send.selectDynamicContents' => 'Select Dynamic Content',
    'mautic.dynamicContent.send.new.dynamicContent' => 'New Dynamic Content',
    'mautic.dynamicContent.send.edit.dynamicContent' => 'Edit Dynamic Content',
    'mautic.dynamicContent.send.slot_name' => 'Requested Slot Name',
    'mautic.dynamicContent.label.slot_name' => 'Slot Name',
    'mautic.dynamicContent.send.slot_name.tooltip' => 'The name of the slot the contact is requesting.',
    'mautic.dynamicContent.choose.dynamicContents' => 'Select the default dynamic content to show.',
    'mautic.dynamicContent.campaign.decision_dwc' => 'Request dynamic content',
    'mautic.dynamicContent.campaign.decision_dwc.tooltip' => 'This is the top level for a dynamic content request.',
    'mautic.dynamicContent.error.notfound' => 'Dynamic Content item %id% not found.',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% dynamic content items deleted.',
    'mautic.dwc.form.confirmbatchdelete' => 'Confirm batch delete',
    'mautic.dwc.delete_new' => 'Discard the new Dynamic Content',
    'mautic.dwc.form.is.campaign' => 'Campaign dynamic content',
    'mautic.dwc.form.is.campaign.tooltip' => 'Is campaign dynamic content',
    'mautic.dwc.form.is.standalone' => 'Standalone dynamic content',
    'mautic.dwc.form.is_campaign_based' => 'Is campaign based?',
    'mautic.dwc.form.is_campaign_based.tooltip' => 'Select whether the content will be displayed based on campaign conditions or filters',
    'mautic.campaign.dwc.decision' => 'Request dynamic content',
    'mautic.campaign.dwc.push_content' => 'Push dynamic content',
    'mautic.dynamic.content.triggered' => 'Dynamic Content Triggered',
    'mautic.dynamicContent.views' => 'Views',
    'mautic.dynamicContent.show.total.views' => 'Total Views',
    'mautic.dynamicContent.show.unique.views' => 'Unique Views',
    'mautic.dynamicContent.timeline.content' => 'Content',
    'mautic.dynamicContent.timeline.title' => 'Read Dynamic Content',
    'mautic.dynamicContent.token.slot' => 'Dynamic Web Content Slot',
    'mautic.dynamicContent.slot.campaign' => 'Is campaign based',
    'mautic.core.icon_tooltip.is_filter_based' => 'Is a filter based dynamic web content',
    'mautic.dynamicContent.header.is_filter_based' => 'Is a filter based dynamic web content for slot: %slot%',
    'mautic.campaign.email.open' => 'Email is opened',
    'mautic.campaign.email.click' => 'Email is clicked',
    'mautic.campaign.email.send' => 'Send or schedule email',
    'mautic.campaign.email.reply' => 'Replied to email',
    'mautic.campaign.email.validate.address' => 'Has valid email address',
    'mautic.config.tab.emailconfig' => 'Email Settings',
    'mautic.placeholder_tokens.email_tokens' => 'Email specific tokens',
    'mautic.placeholder_tokens.email_tokens.explanation' => 'The following tokens are available for use only within the email builder.',
    'mautic.placeholder_tokens.email.signature' => 'Signature',
    'mautic.placeholder_tokens.email.subject' => 'Subject',
    'mautic.placeholder_tokens.email.unsubscribe_text' => 'Unsubscribe text (HTML link)',
    'mautic.placeholder_tokens.email.unsubscribe_url' => 'Unsubscribe URL',
    'mautic.placeholder_tokens.email.resubscribe_url' => 'Resubscribe URL',
    'mautic.placeholder_tokens.email.webview_text' => 'Web view text',
    'mautic.placeholder_tokens.email.webview_url' => 'Web view URL',
    'mautic.email.abtest.criteria.clickthrough' => 'Clickthrough rate',
    'mautic.email.abtest.criteria.open' => 'Read rate',
    'mautic.email.abtest.label.clickthrough' => 'Number of clickthroughs',
    'mautic.email.abtest.label.opened' => 'Number read',
    'mautic.email.abtest.label.sent' => 'Number sent',
    'mautic.protip.emails.unsubscribe' => 'Always include an unsubscribe link and never use a no-reply email address.',
    'mautic.protip.emails.test' => 'Preview and test your emails across devices and clients to ensure they look great everywhere.',
    'mautic.protip.emails.personalize' => 'Personalize email content based on user behavior and preferences.',
    'mautic.protip.emails.spam' => 'Avoid spam trigger words in subject lines and email content',
    'mautic.protip.emails.cta' => 'Limit emails to one primary CTA to avoid decision paralysis',
    'mautic.email.actions' => 'Email actions',
    'mautic.email.add_recipient' => 'Add recipient',
    'mautic.email.address.invalid_format' => '%email% is invalid.',
    'mautic.email.address.invalid_characters' => '%email% has characters not allowed in email addresses.',
    'mautic.email.address.invalid_domain' => '%email% does not seem to have a valid email domain (MX DNS record).',
    'mautic.email.attachments' => 'Attachments',
    'mautic.email.attachments.help' => 'Attachments are sent as file copies and can’t be tracked. To track downloads, use their link in the email content.',
    'mautic.email.bcc.tooltip' => 'Set a BCC address to receive a copy of every email sent.',
    'mautic.email.bcc' => 'BCC address',
    'mautic.email.utm_tags' => 'UTM tags',
    'mautic.email.utm_tags.tooltip' => 'Generate custom campaign parameters for your advertising URLs. Add parameters to URLs to identify the campaigns that refer traffic.',
    'mautic.email.campaign_source' => 'Campaign source',
    'mautic.email.campaign_medium' => 'Campaign medium',
    'mautic.email.campaign_name' => 'Campaign name',
    'mautic.email.campaign_content' => 'Campaign content',
    'mautic.email.bounce.reason.antispam' => 'Blocked as spam',
    'mautic.email.bounce.reason.autoreply' => 'Received an auto-reply',
    'mautic.email.bounce.reason.bad_email' => 'Incorrectly formatted email address',
    'mautic.email.bounce.reason.command_reject' => 'Server rejected request',
    'mautic.email.bounce.reason.concurrent' => 'Too many concurrent connections',
    'mautic.email.bounce.reason.content_reject' => 'Content was rejected',
    'mautic.email.bounce.reason.defer' => 'Message was deferred',
    'mautic.email.bounce.reason.delayed' => 'Message has been delayed',
    'mautic.email.bounce.reason.dns_loop' => 'There is a DNS loop',
    'mautic.email.bounce.reason.dns_unknown' => 'Domain is unknown',
    'mautic.email.bounce.reason.full' => 'Mailbox is full',
    'mautic.email.bounce.reason.hard_bounce' => 'Hard bounce',
    'mautic.email.bounce.reason.inactive' => 'Mailbox is inactive',
    'mautic.email.bounce.reason.internal_error' => 'Temporary system error',
    'mautic.email.bounce.reason.invalid' => 'Email is invalid',
    'mautic.email.bounce.reason.latin_only' => 'Server accepts latin characters only',
    'mautic.email.bounce.reason.other' => 'Delivery failed',
    'mautic.email.bounce.reason.outofoffice' => 'User is out of office',
    'mautic.email.bounce.reason.oversize' => 'Message is oversized',
    'mautic.email.bounce.reason.rejected' => 'Mail rejected',
    'mautic.email.bounce.reason.soft_bounce' => 'Soft bounce',
    'mautic.email.bounce.reason.spam' => 'Marked as spam',
    'mautic.email.bounce.reason.unknown' => 'Unknown user or server',
    'mautic.email.bounce.reason.unrecognized' => 'Unrecognized user',
    'mautic.email.bounce.reason.unsubscribed' => 'Contact unsubscribed via email',
    'mautic.email.bounce.reason.user_reject' => 'User rejected this email',
    'mautic.email.bounce.reason.warning' => 'Server gave warning',
    'mautic.email.complaint.reason.unknown' => 'Unknown complaint from mail provider',
    'mautic.email.complaint.reason.abuse' => 'Mail provider indicated unsolicited email or some other kind of email abuse',
    'mautic.email.complaint.reason.fraud' => 'Mail provider indicated some kind of fraud or phishing activity',
    'mautic.email.complaint.reason.virus' => 'Mail provider reports that a virus is found in the originating message',
    'mautic.email.contact_already_received_marketing_email' => '%contact% has already received this marketing email.',
    'mautic.email.contact_has_no_email' => '%contact% has no email address.',
    'mautic.email.contact_has_unsubscribed_from_category' => '%contact% has unsubscribed the category %category%.',
    'mautic.email.builder.addcontent' => 'Click to add content',
    'mautic.email.builder.index' => 'Extras',
    'mautic.email.campaign.event.open' => 'Opens email',
    'mautic.email.campaign.event.open_descr' => 'Trigger actions when an email is opened. Connect a Send Email action to the top of this decision.',
    'mautic.email.campaign.event.click' => 'Clicks email',
    'mautic.email.campaign.event.click_descr' => 'Trigger actions when an email is clicked. Connect a Send Email action to the top of this decision.',
    'mautic.email.campaign.event.failure_missing_email' => 'Email not found or published',
    'mautic.email.click.urls.contains' => 'Limit to Urls contains',
    'mautic.email.campaign.event.send' => 'Send email',
    'mautic.email.campaign.event.send_descr' => 'Send the selected email to the contact.',
    'mautic.email.campaign.event.send.to.user' => 'Send email to user',
    'mautic.email.campaign.event.send.to.user_descr' => 'Send email to user, owner or other email addresses',
    'mautic.email.campaign.event.validate_address' => 'Has valid email address',
    'mautic.email.campaign.event.validate_address_descr' => 'Attempt to validate contact\'s email address. This may not be 100% accurate.',
    'mautic.email.campaignId.filter' => 'Campaign filter',
    'mautic.form.action.send.email.to.owner' => 'Send email to contact\'s owner',
    'mautic.email.choose.emails_descr' => 'Choose the email to be sent. If your email is not displayed, it may not be published or it is a segment email.',
    'mautic.email.companyId.filter' => 'Company filter',
    'mautic.email.config.header.mail' => 'Mail Send Settings',
    'mautic.email.config.header.mail.setting' => 'Email Settings',
    'mautic.email.config.header.message' => 'Message Settings',
    'mautic.email.config.header.monitored_email' => 'Monitored Inbox Settings',
    'mautic.email.config.mailer.append.tracking.pixel.tooltip' => 'Enables automatic appending of tracking pixel image into email body. WARNING: Disabling this option will disable tracking of email open actions!',
    'mautic.email.config.mailer.append.tracking.pixel' => 'Append tracking pixel into email body ?',
    'mautic.email.config.mailer.disable.trackable.urls' => 'Disable trackable urls',
    'mautic.email.config.mailer.disable.trackable.urls.tooltip' => 'Gmail (and GSuite) don\'t like redirecting urls.',
    'mautic.email.config.mailer.minify.html' => 'Minify HTML',
    'mautic.email.config.mailer.minify.html.tooltip' => 'Minifying HTML can improve the performance of sending marketing emails by reducing the size of the email. However, it may also cause a slight delay in the sending process and increase CPU usage on the sender\'s end.',
    'mautic.email.config.mailer.convert.embed.images.tooltip' => 'Enable automatic conversion of embed images to Base64',
    'mautic.email.config.mailer.convert.embed.images' => 'Convert embed images to Base64',
    'mautic.email.config.mailer.encryption.tooltip' => 'Set the encryption type used by the SMTP server',
    'mautic.email.config.mailer.encryption' => 'SMTP encryption type',
    'mautic.email.config.mailer.from.email.tooltip' => 'Set the from email for email sent by Mautic',
    'mautic.email.config.mailer.from.email' => 'E-mail address to send mail from',
    'mautic.email.config.mailer.from.name.tooltip' => 'Set the from name for email sent by Mautic',
    'mautic.email.config.mailer.from.name' => 'Name to send mail as',
    'mautic.email.config.mailer.host.tooltip' => 'Set the host for SMTP server',
    'mautic.email.config.mailer.host' => 'SMTP host',
    'mautic.email.config.mailer.is.owner.tooltip' => 'Set the default mailer is owner setting for all new emails that are created',
    'mautic.email.config.mailer.is.owner' => 'Mailer is owner',
    'mautic.email.config.mailer.is.owner.local.warning' => 'The global mailer is owner option is set to <strong>%value%</strong>. This option overwrites that global option just for this email.',
    'mautic.email.config.mailer.password.tooltip' => 'Set the password required to authenticate the selected mail service',
    'mautic.email.config.mailer.password' => 'Password for the selected mail service',
    'mautic.email.config.mailer.port.tooltip' => 'Set the port for the mail server',
    'mautic.email.config.mailer.port' => 'Port',
    'mautic.email.config.mailer.return.path.tooltip' => 'Set a custom return path/bounce email for emails sent from the system. Note that some mail transports, such as Gmail, will not support this.',
    'mautic.email.config.mailer.return.path' => 'Custom return path (bounce) address',
    'mautic.email.config.mailer.address.length.limit' => 'E-mail address length limit',
    'mautic.email.config.mailer.address.length.limit.tooltip' => 'Sets the maximum character length for e-mail addresses (including the display name). If an address exceeds this limit, only the e-mail without the display name will be used. This helps prevent errors with email servers that have restrictions on address length. Default is 320 characters.',
    'mautic.email.config.mailer.transport.test_send.body' => 'Hi! This is a test email from Mautic. Testing...testing...1...2...3!',
    'mautic.email.config.mailer.transport.test_send.subject' => 'Mautic test email',
    'mautic.email.config.mailer.transport.test_send' => 'Send test email',
    'mautic.email.config.mailer.transport.tooltip' => 'Set the service email should be sent through. Mautic is not affiliated with any of these services but simply supply their SMTP settings for convenience.',
    'mautic.email.config.mailer.transport' => 'Service to send mail through',
    'mautic.email.config.mailer.user.tooltip' => 'Set the username required to authenticate the selected mail service',
    'mautic.email.config.mailer.user' => 'Username for the selected mail service',
    'mautic.email.config.mailer_transport.smtp' => 'Other SMTP Server',
    'mautic.email.config.monitored_email.not_configured' => 'IMAP account is not configured.',
    'mautic.email.config.monitored_email.bounce_folder.tooltip' => 'Folder to monitor for new bounce messages.  Leave blank to disable. <strong>NOTE</strong>: Gmail will rewrite Return-Path headers when sending through their SMTP servers. Mautic will still attempt to analyze new messages for bounces but it is best to use another sending method or configure a unique mailbox.',
    'mautic.email.config.monitored_email.bounce_folder' => 'Bounces',
    'mautic.email.config.monitored_email.general' => 'Default Mailbox',
    'mautic.email.config.monitored_email.test_connection' => 'Test connection and fetch folders',
    'mautic.email.config.monitored_email.unsubscribe_folder.tooltip' => 'Folder to monitor for new unsubscribe requests. Leave blank to disable.',
    'mautic.email.config.monitored_email.unsubscribe_folder' => 'Unsubscribe Requests',
    'mautic.email.config.monitored_email_address.tooltip' => 'The address for the account to be monitored. This will be used when generating a bounce, unsubscribe, etc., addresses if applicable.',
    'mautic.email.config.monitored_email_address' => 'Monitored address',
    'mautic.email.config.monitored_email_encryption.ssl_novalidate' => 'SSL with novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tls_novalidate' => 'TLS with novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tooltip' => 'Encryption for server connection. Some servers may require the no-validate options which will not validate the server\'s SSL certificate.',
    'mautic.email.config.monitored_email_encryption' => 'Encryption',
    'mautic.email.config.monitored_email_folder.tooltip' => 'Choose the folder to check or leave empty to disable.',
    'mautic.email.config.monitored_email_folder' => 'Folder to check',
    'mautic.email.config.monitored_email_host.tooltip' => 'IMAP URL for the mail service host.',
    'mautic.email.config.monitored_email_host' => 'IMAP host',
    'mautic.email.config.monitored_email_override_settings.tooltip' => 'If yes, configure custom connection settings for this mailbox. Otherwise, Mautic will use the default mailbox.',
    'mautic.email.config.monitored_email_override_settings' => 'Use custom connection settings?',
    'mautic.email.config.monitored_email_password.tooltip' => 'Password to login to the IMAP server.',
    'mautic.email.config.monitored_email_password' => 'IMAP password',
    'mautic.email.config.monitored_email_port.tooltip' => 'Port to use to connect to the mail host.',
    'mautic.email.config.monitored_email_port' => 'Port',
    'mautic.email.config.monitored_email_user.tooltip' => 'Username to login to the IMAP server.',
    'mautic.email.config.monitored_email_user' => 'IMAP username',
    'mautic.email.config.resubscribe_message.tooltip' => 'Set the default text for the message displayed to the contact when they resubscribe using the link displayed in the unsubscribe success message. Be sure to use the <code>|URL|</code> placeholder where the unsubscribe url is to be injected. The use of <code>|EMAIL|</code> is optional.',
    'mautic.email.config.resubscribe_message' => 'Resubscribed confirmation message',
    'mautic.email.config.unsubscribe_message.tooltip' => 'Set the default text for the message displayed to the contact when they unsubscribe using the link in an email. Be sure to use the <code>|URL|</code> placeholder where the resubscribe url is to be injected. The use of <code>|EMAIL|</code> is optional.',
    'mautic.email.config.unsubscribe_message' => 'Unsubscribed confirmation message',
    'mautic.email.config.unsubscribe_text.tooltip' => 'Set the default text for the {unsubscribe_text} token used in emails. Be sure to use the <code>|URL|</code> placeholder where the unsubscribe url is to be injected.',
    'mautic.email.config.unsubscribe_text' => 'Text for the {unsubscribe_text} token',
    'mautic.email.config.webview_text.tooltip' => 'Set the default text for the {webview_text} token used in emails. Be sure to use the <code>|URL|</code> placeholder where the web view url is to be injected.',
    'mautic.email.config.webview_text' => 'Text for the {webview_text} token',
    'mautic.email.config.mailer.mailjet.sandbox' => 'Sandbox mode',
    'mautic.email.config.mailer.mailjet.sandbox.mail' => 'Default mail for Sandbox mode',
    'mautic.email.custom_headers' => 'Custom headers',
    'mautic.email.custom_headers.config.tooltip' => 'Define custom headers to use for any outgoing email that is not associated with a Mautic Email. This includes password reset emails, emails to Mautic users, form post results, directly composed email to contacts, etc. If custom headers are required for an Email (used in campaigns or broadcasts), set customer headers in the Advanced tab of the Email.',
    'mautic.email.custom_headers.tooltip' => 'Add information for email tracking, spam identification, authentication, and more',
    'mautic.email.dashboard.widgets' => 'Email Widgets',
    'mautic.email.default.signature' => 'Best regards, %from_name%',
    'mautic.email.dnc.failed' => 'Too many failures when attempting to deliver the email with a subject of \'%subject%\'.',
    'mautic.email.dnc.retries' => 'There were more than 3 attempts to send the email.',
    'mautic.email.dnc.unsubscribed' => 'User unsubscribed.',
    'mautic.email.dnc' => 'Contact has requested to not be emailed.',
    'mautic.email.email' => 'Email',
    'mautic.email.emails' => 'Emails',
    'mautic.email.event.sent.direct' => 'Direct email to %contact%',
    'mautic.email.event.sent' => '%email% sent %x% times',
    'mautic.email.example_recipients' => 'Recipients',
    'mautic.email.failed.emails' => 'Failed emails',
    'mautic.email.failed' => 'Email failed',
    'mautic.email.replied' => 'Email replied',
    'mautic.email.fetch.processed' => '{0}0 emails processed for %imapPath% with a criteria of %criteria%|{1}1 email processed for %imapPath% with a criteria of %criteria%|]1,Inf[%count% emails processed for %imapPath% with a criteria of %criteria%',
    'mautic.email.fetch.no_mailboxes_configured' => 'No mailboxes are configured.',
    'mautic.email.filter.options.empty' => 'There are no filter options. Create some Email Categories or Contact Segments.',
    'mautic.email.filter.placeholder' => 'Segment/Theme Filter',
    'mautic.email.flag.failed' => 'Only failed emails',
    'mautic.email.flag.filter' => 'Email state filter',
    'mautic.email.flag.opened' => 'Only opened emails',
    'mautic.email.flag.sent.and.opened.and.failed' => 'Sent, opened and failed emails',
    'mautic.email.flag.sent.and.opened' => 'Sent and opened emails',
    'mautic.email.flag.sent' => 'Only sent emails',
    'mautic.email.form.abtestwinner' => 'A/B test winner criteria',
    'mautic.email.form.action.sendemail.admin' => 'Send email to user',
    'mautic.email.form.action.sendemail.admin.descr' => 'Send the selected email to the selected user(s) upon form submission.',
    'mautic.email.form.action.sendemail.lead.descr' => 'Send the selected email to the contact upon form submission.',
    'mautic.email.form.action.sendemail.lead' => 'Send email to contact',
    'mautic.email.form.body' => 'HTML Code',
    'mautic.email.form.body.help' => 'Customise your email\'s HTML content.',
    'mautic.email.form.confirmbatchdelete' => 'Delete the selected emails? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.email.form.confirmdelete' => 'Delete the email, %name%? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.email.form.confirmsend' => 'Queue, %name%, for sending?',
    'mautic.email.form.internal.name' => 'Internal Name',
    'mautic.email.form.list' => 'Contact segment',
    'mautic.email.form.excluded_list' => 'Exclude contact segment',
    'mautic.email.form.plaintext.help' => 'Use the Email Builder to customize your email\'s HTML. If you want a plain text version associated with the email, enter the text below.',
    'mautic.email.form.plaintext' => 'Plain text version',
    'mautic.email.form.publishdown.help' => 'For Segment emails - To schedule an ‘unpublish date’ on a segment email, select your unpublish date before saving and closing.',
    'mautic.email.form.submit.message' => 'Send message',
    'mautic.email.form.submit.message_descr' => 'Custom \'thank you\' message',
    'mautic.email.form.template.help' => 'Choose the theme that will give the email it\'s look and feel. Then use the Builder to fill in the contents. WARNING: Changing the theme after building the email may cause content to not display if the two themes do not use the same slots.',
    'mautic.email.form.trafficweight.help' => 'Define the percentage of traffic that will be shown this variant. For example, 50 will send the parent/main email 50% of the time and this variant 50% of the time. If there are two variants each with a weight of 25, then the parent/main email will be sent 50% of the time, one variant 25%, and the other 25%. And so forth with additional variants.',
    'mautic.email.form.trafficweight' => 'Traffic Weight',
    'mautic.email.form.unsubscribeform.tooltip' => 'Display the selected form on the unsubscribe page if a user unsubscribes through this email.',
    'mautic.email.form.unsubscribeform' => 'Unsubscribe feedback form',
    'mautic.email.from_email.tooltip' => 'Set the from address for this email. This will default to the system configuration if left blank.',
    'mautic.email.from_email' => 'From address',
    'mautic.email.from_name.tooltip' => 'Set the from name for the this email. This will default to the system configuration if left blank.',
    'mautic.email.from_name' => 'From name',
    'mautic.email.use.owner.as.mailer.tooltip' => 'If identified in the contact’s profile, the owner’s email and name will be set as sender.',
    'mautic.email.use.owner.as.mailer' => 'Use contact owner as mailer',
    'mautic.email.graph.line.stats.failed' => 'Failed',
    'mautic.email.graph.line.stats.read' => 'Read',
    'mautic.email.graph.line.stats.sent' => 'Sent',
    'mautic.email.graph.line.stats' => 'Emails sent',
    'mautic.email.graph.pie.ignored.read.failed.failed' => 'Failed',
    'mautic.email.graph.pie.ignored.read.failed.ignored' => 'Ignored',
    'mautic.email.graph.pie.ignored.read.failed.read' => 'Read',
    'mautic.email.graph.pie.ignored.read.failed' => 'Ignored / Read / Failed emails',
    'mautic.email.graph.pie.read.ingored.unsubscribed.bounced' => 'Read / Ignored / Unsubscribed / Bounced',
    'mautic.email.graph.pie.sent.read.clicked.unsubscribed' => 'Sent / Read / Clicked / Unsubscribed',
    'mautic.email.graph.bar.read.clicked.unsubscribed.bounced' => 'Read / Clicked / Unsubscribed / Bounced',
    'mautic.email.header.edit' => 'Edit Email - %name%',
    'mautic.email.header.new' => 'New Email',
    'mautic.email.icon_tooltip.abtest' => 'Has A/B tests',
    'mautic.email.icon_tooltip.list_email' => 'Is a segment (broadcast) email',
    'mautic.email.icon_tooltip.has_draft' => 'Has Draft',
    'mautic.email.config.enable.draft' => 'Enable Email Drafts',
    'mautic.email.config.enable.draft.tooltip' => 'Allow saving new email changes as drafts to compare the differences. Drafts can be then approved or discarded.',
    'mautic.email.imap_extension_missing' => 'The <a href=\'http://php.net/manual/en/book.imap.php\' target=\'_new\'>PHP IMAP extension</a> is required in order to enable monitored email features.',
    'mautic.email.lead.list.comparison' => 'Contact segments comparison',
    'mautic.email.label.reads' => 'Read count',
    'mautic.email.label.sends' => 'Send count',
    'mautic.email.lists.combined' => 'All lists combined',
    'mautic.email.no.emails.note' => 'There are no emails to choose from. Create some first.',
    'mautic.email.open.limittoemails' => 'Limit to these selected emails',
    'mautic.email.open.limittoemails_descr' => 'Only apply if the selected emails are opened. If none are selected, any email opened will be applicable.',
    'mautic.email.permissions.emails' => 'Emails - User has access to',
    'mautic.email.permissions.header' => 'Email Permissions',
    'mautic.email.plaintext.generate' => 'Auto Generate',
    'mautic.email.point.action.open' => 'Opens an email',
    'mautic.email.point.action.send' => 'Is sent an email',
    'mautic.email.point.trigger.sendemail' => 'Send an email',
    'mautic.email.point.trigger.send_email_to_user' => 'Send an email to user',
    'mautic.email.read' => 'Email read',
    'mautic.email.click' => 'Email clicked',
    'mautic.email.point.trigger' => 'Email triggers',
    'mautic.email.read.emails' => 'Read emails',
    'mautic.email.readcount' => 'Read count',
    'mautic.email.recipient.lists' => 'Recipient Lists',
    'mautic.email.reply_to_email.tooltip' => 'Leave blank to use the from address.',
    'mautic.email.reply_to_email' => 'Reply to address',
    'mautic.email.report.read.delay' => 'Read delay',
    'mautic.email.report.read_count' => 'Read count',
    'mautic.email.report.read_ratio' => 'Read ratio',
    'mautic.email.report.sent_count' => 'Sent count',
    'mautic.email.report.is_hit' => 'Clicked',
    'mautic.email.report.hits_count' => 'Clicks',
    'mautic.email.report.unique_hits_count' => 'Unique clicks',
    'mautic.email.report.hits_ratio' => 'Clicks ratio',
    'mautic.email.report.unique_ratio' => 'Unique clicks ratio',
    'mautic.email.report.unsubscribed' => 'Unsubscribed',
    'mautic.email.report.unsubscribed_ratio' => 'Unsubscribed ratio',
    'mautic.email.report.bounced' => 'Bounced',
    'mautic.email.report.bounced_ratio' => 'Bounced ratio',
    'mautic.email.report.revision' => 'Revision',
    'mautic.email.report.stat.date_read' => 'Date read',
    'mautic.email.report.stat.date_sent' => 'Date sent',
    'mautic.email.report.stat.email_address' => 'Email address',
    'mautic.email.report.stat.is_failed' => 'Is failed',
    'mautic.email.report.stat.is_read' => 'Read',
    'mautic.email.report.stat.retry_count' => 'Retry count',
    'mautic.email.report.stat.viewed_in_browser' => 'Viewed in browser',
    'mautic.email.report.variant_parent_id' => 'A/B test parent ID',
    'mautic.email.report.variant_parent_subject' => 'A/B test parent subject',
    'mautic.email.report.variant_read_count' => 'A/B test read count',
    'mautic.email.report.variant_sent_count' => 'A/B test sent count',
    'mautic.email.report.variant_start_date' => 'A/B test start date',
    'mautic.email.report.click_through_count' => 'Click-through count',
    'mautic.email.report.click_through_rate' => 'Click-through rate',
    'mautic.email.report.click_to_open_rate' => 'Click-to-open rate',
    'mautic.email.resubscribed.success' => '%email% has been re-subscribed. If this was by mistake, <a href=\'%unsubscribeUrl%\'>click here to unsubscribe</a>.',
    'mautic.email.segmentId.filter' => 'Segment filter',
    'mautic.email.send' => 'Send',
    'mautic.email.send.emailtype' => 'Email type',
    'mautic.email.send.emailtype.tooltip' => 'Transactional emails can be sent to the same contact multiple times across campaigns. Transactional emails ignore the DNC setting and can be sent to \'Do Not Contact\' contacts. Marketing emails will be sent only once to the contact even if it was sent from another campaign.',
    'mautic.email.send.emailtype.transactional' => 'Transactional',
    'mautic.email.send.emailtype.marketing' => 'Marketing',
    'mautic.email.send.edit.email.desc' => 'Edit email from here. New window will pop up and allows you to edit email',
    'mautic.email.send.edit.email' => 'Edit Email',
    'mautic.email.send.example' => 'Send Example',
    'mautic.email.send.disabled' => 'Email is sending in the background. Sending from the browser is blocked to prevent duplicate emails',
    'mautic.email.send.inprogress' => 'Sending is in progress. Leaving this page will stop the process but may cause contacts to receive duplicate emails when restarted.',
    'mautic.email.send.instructions' => 'Enter the number of emails to send per batch then click Send to start the process.',
    'mautic.email.send.list' => 'Send &quot;%name%&quot;',
    'mautic.email.send.new.email.desc' => 'Create new email from here. New window will pop up and allows you to create new email.',
    'mautic.email.send.new.email' => 'New Email',
    'mautic.email.send.pending' => '{0} There are no pending contacts.|{1} There is one pending contact.|[2, +Inf[ There are %count% pending contacts.',
    'mautic.email.send.preview.email' => 'Preview Email',
    'mautic.email.send.preview.email.desc' => 'Preview email from here. New window will pop up and allows you to preview email',
    'mautic.email.send.selectemails' => 'Email to send',
    'mautic.email.send.stats' => '%sent% sent and %failed% failed',
    'mautic.email.send.success' => '&quot;%subject%&quot; was sent out!',
    'mautic.email.send.with_errors' => '&quot;%subject%&quot; was sent but with some failures.',
    'mautic.email.sendmanual' => 'Send (Manual)',
    'mautic.email.sent.emails' => 'Sent emails',
    'mautic.email.sent' => 'Email sent',
    'mautic.email.stage.action.open' => 'Opens an email',
    'mautic.email.stage.action.send' => 'Sends an email',
    'mautic.email.stats.options.title' => 'Emails',
    'mautic.email.stats' => 'Email Stats',
    'mautic.email.stats.report.table' => 'Emails Sent',
    'mautic.email.stat.leadcount' => '%count% Pending',
    'mautic.email.stat.readcount' => '%count% Read',
    'mautic.email.stat.sentcount' => '%count% Sent',
    'mautic.email.stat.failed' => 'Failed',
    'mautic.email.stat.leadcount.tooltip' => 'Number of contacts that have not received this email.',
    'mautic.email.stat.pending' => 'Pending',
    'mautic.email.stat.queued' => '%count% Queued',
    'mautic.email.stat.queued.tooltip' => 'Number of contacts that has this emailed queued to be sent based on their frequency rules.',
    'mautic.email.stat.read' => 'Read',
    'mautic.email.stat.notread' => 'Not Read',
    'mautic.email.stat.readpercent' => '%count%% Read',
    'mautic.email.stat.sent' => 'Sent',
    'mautic.email.stat.delivered' => 'Delivered',
    'mautic.email.stat_record.not_found' => 'Record not found.',
    'mautic.email.subject' => 'Subject',
    'mautic.email.table.most.emails.failed' => 'Most emails failed',
    'mautic.email.table.most.emails.unsubscribed' => 'Most emails unsubscribed',
    'mautic.email.table.most.emails.bounced' => 'Most emails bounced',
    'mautic.email.table.most.emails.read.percent' => 'Read ratio [%]',
    'mautic.email.table.most.emails.read' => 'Most emails read',
    'mautic.email.table.most.emails.sent' => 'Most emails sent',
    'mautic.email.table.most.emails.clicks' => 'Most clicked links',
    'mautic.email.thead.stats' => 'Stats',
    'mautic.email.thead.maps' => 'Map',
    'mautic.email.timeline.event.bounced' => 'Email Bounced',
    'mautic.email.timeline.event.custom_email' => 'Custom Email',
    'mautic.email.timeline.event.email_reply' => 'Reply',
    'mautic.email.timeline.event.failed' => 'Sending email failed.',
    'mautic.email.timeline.event.list' => 'Email was sent to this contact because they belong to the \'%list%\' segment.',
    'mautic.email.timeline.event.not.read' => 'Email has probably <strong>not been read</strong> yet.',
    'mautic.email.timeline.open_details' => 'Email Opened History',
    'mautic.email.timeline.event.read' => 'Email <strong>was first read on %date%</strong>. That was %interval% after the email was sent %sent%.',
    'mautic.email.timeline.event.retried' => 'one: Email was re-sent once for now.|some: Email was re-sent %count% times for now.',
    'mautic.email.timeline.event.sent' => 'Email <strong>was first read on %date%</strong>. That was %interval% after the email was sent.',
    'mautic.email.timeline.event.viewed.in.browser' => 'Contact also viewed this email in the browser.',
    'mautic.email.token.dragme' => 'Drag and drop me!',
    'mautic.email.token.help' => 'Drag and drop the desired token into the content section of choice.',
    'mautic.email.token.signature.descr' => 'Signature text defined in the configuration or in the user profile',
    'mautic.email.token.signature' => 'Signature',
    'mautic.email.config.default_signature_text' => 'Default email signature',
    'mautic.email.config.default_signature_text.tooltip' => 'This signature will be used for emails sent to a contact who doesn\'t have any owner. If the \'Mailer is owner\' option is ON and contact has an owner, the signature of this owner/user profile will be used. Use {signature} token to insert it in an email.',
    'mautic.email.token.unsubscribe_text.descr' => 'Inserts an unsubscribe message and link.',
    'mautic.email.token.unsubscribe_text' => 'Unsubscribe Text',
    'mautic.email.token.unsubscribe_url.descr' => 'Inserts only the unsubscribe URL.',
    'mautic.email.token.unsubscribe_url' => 'Unsubscribe URL',
    'mautic.email.token.unsubscribe_all_url' => 'Unsubscribe from all URL',
    'mautic.email.token.resubscribe_url.descr' => 'Inserts only the resubscribe URL.',
    'mautic.email.token.resubscribe_url' => 'Resubscribe URL',
    'mautic.email.token.webview_text.descr' => 'Inserts a web view message and link.',
    'mautic.email.token.webview_text' => 'Web View Text',
    'mautic.email.token.webview_url.descr' => 'Inserts only the web view URL.',
    'mautic.email.token.webview_url' => 'Web View URL',
    'mautic.email.tokens.header' => 'Tokens',
    'mautic.email.tokens.help' => 'Tokens are placeholders for featured objects. Just drag and drop the token into the editor to add it!',
    'mautic.email.total' => 'Total',
    'mautic.email.type.header' => 'What type of email do you want to create?',
    'mautic.email.type.segment.differences.1st' => 'For newsletters, offers, updates etc',
    'mautic.email.type.segment.differences.2nd' => 'Allows one send per contact',
    'mautic.email.type.segment.differences.3rd' => 'Designed for marketing use',
    'mautic.email.type.segment.differences.4th' => 'Used in mass email sending',
    'mautic.email.type.list.header' => 'Segment email',
    'mautic.email.type.list' => 'Segment Emails',
    'mautic.email.type.template.header' => 'Triggered email',
    'mautic.email.type.template.differences.1st' => 'For campaigns, forms and points events',
    'mautic.email.type.template.differences.2nd' => 'Allows to send multiple times',
    'mautic.email.type.template.differences.3rd' => 'Suited for transactional use',
    'mautic.email.type.template.differences.4th' => 'Based on users\' specific actions',
    'mautic.email.type.template' => 'Triggered Emails',
    'mautic.email.unsubscribe.text' => '<a href=\'%link%\'>Unsubscribe</a> to no longer receive emails from us.',
    'mautic.email.unsubscribe' => 'Unsubscribe',
    'mautic.email.unsubscribed.success' => 'We are sorry to see you go! %email% will no longer receive emails from us. If this was by mistake, <a href=\'%resubscribeUrl%\'>click here to re-subscribe</a>.',
    'mautic.email.unsubscribe_all.text' => '<a href=\'%link%\'>Unsubscribe</a> from all marketing messages.',
    'mautic.email.preferences_center_success_message.text' => 'Preferences saved successfully',
    'mautic.email.urlvariant' => 'Public Preview URL',
    'mautic.email.preview.show.translation' => 'Show preview for translation',
    'mautic.email.preview.show.ab.variant' => 'Show preview for A/B variant',
    'mautic.email.preview.show.contact' => 'Show preview for contact',
    'mautic.email.drafturlvariant' => 'Public Draft Preview URL',
    'mautic.email.preview.url' => 'Preview URL',
    'mautic.email.draft.preview.url' => 'Draft Preview URL',
    'mautic.email.variant.misconfiguration' => 'There is a mismatched configuration between variants. Please ensure all variants are configured with the same winner criteria.',
    'mautic.email.variants' => 'Variants',
    'mautic.email.variantstartdate' => 'A/B Test started on %date% at %time%',
    'mautic.email.variant.graph.all' => 'All',
    'mautic.email.variant.graph.variant' => 'Variant',
    'mautic.email.webhook.event.send' => 'Email Send Event',
    'mautic.email.webhook.event.open' => 'Email Open Event',
    'mautic.email.webview.text' => '<a href=\'%link%\'>Having trouble reading this email? Click here.</a>',
    'mautic.widget.created.emails' => 'Created emails',
    'mautic.widget.emails.in.time' => 'Emails in time',
    'mautic.widget.emails.best.hours' => 'Best email read hours ',
    'mautic.widget.emails.best.hours.reads_total' => 'Hourly percentage from %reads% reads',
    'mautic.widget.most.hit.email.redirects' => 'Most hit email redirects',
    'mautic.widget.sent.email.to.contacts' => 'Sent email to contacts',
    'mautic.widget.ignored.vs.read.emails' => 'Ignored vs read',
    'mautic.widget.most.read.emails' => 'Most read emails',
    'mautic.widget.most.sent.emails' => 'Most sent emails',
    'mautic.widget.upcoming.emails' => 'Upcoming emails',
    'mautic.email.ignored.emails' => 'Ignored emails',
    'mautic.email.unsubscribed.emails' => 'Unsubscribed emails',
    'mautic.email.bounced.emails' => 'Bounced emails',
    'mautic.email.unsubscribed' => 'Unsubscribed',
    'mautic.email.bounced' => 'Bounced',
    'mautic.email.clicked' => 'Clicked',
    'mautic.email.config.header.queue' => 'Queue',
    'mautic.email.config.alert.queue' => 'Be sure to have your credentials properly written',
    'mautic.email.config.track.mail.use.queue' => 'Use queue',
    'mautic.email.config.track.mail.use.queue.tooltip' => 'Emails are tracked using rabbitmq',
    'device.granularity.email' => 'Devices for emails read',
    'mautic.widget.device.granularity.email' => 'Devices for emails read',
    'mautic.email.config.header.unsubscribe' => 'Unsubscribe Settings',
    'mautic.email.config.show.preference.options' => 'Show contact preference settings',
    'mautic.email.config.show.preference.options.tooltip' => 'If this option is enabled, the default unsubscribed message will not show.',
    'mautic.email.config.show.contact.segments' => 'Show contact segment preferences',
    'mautic.email.config.show.contact.segments.tooltip' => 'This option will allow the contact to unselect their segments.',
    'mautic.email.config.show.contact.frequency' => 'Show contact frequency preferences',
    'mautic.email.config.show.contact.frequency.tooltip' => 'This will allow the contact to set their frequency rules.',
    'mautic.email.config.show.contact.pause.dates' => 'Show pause contact preferences',
    'mautic.email.config.show.contact.pause.dates.tooltip' => 'This will allow the contact set a pause start date and end date.',
    'mautic.email.config.show.contact.categories' => 'Show contact\'s categories',
    'mautic.email.config.show.contact.categories.tooltip' => 'This will allow the contact to opt out of categories they belong to.',
    'mautic.email.config.show.contact.preferred.channels' => 'Show contact\'s preferred channel option',
    'mautic.email.config.show.contact.preferred.channels.tooltip' => 'This will allow the contact to set their preferred channel; it will only show if there is more than one contact channels.',
    'mautic.lead.message.preferences' => 'Message Preferences',
    'mautic.lead.message.preferences.descr' => 'Please use the form below to set your message preferences.',
    'mautic.report.group.emails' => 'Emails',
    'mautic.email.campaign.event.reply' => 'Replies to email',
    'mautic.email.campaign.event.reply_descr' => 'Trigger action when contact replies to an email',
    'mautic.email.config.monitored_email.reply_folder' => 'Contact Replies',
    'mautic.email.stat.tooltip' => 'Details may not match summary numbers if the contact no longer exists in your Mautic Account or if a contact was sent or read an email multiple times',
    'mautic.email.stat.simple.tooltip' => 'Details may not match summary numbers if the contact no longer exists in your Mautic Account',
    'mautic.email.associated.contacts' => 'Contacts',
    'mautic.email.segment.choice.generated_email_domain' => 'Email Domain',
    'mautic.email.config.mailer_encryption.none' => 'None',
    'mautic.email.config.mailer_encryption.ssl' => 'SSL',
    'mautic.email.config.mailer_encryption.tls' => 'TLS',
    'mautic.email.config.header.dsn' => 'Email DSN',
    'mautic.email.heatmap.click_heatmap' => 'Click heatmap',
    'mautic.email.heatmap.clicks' => '{0}0 clicks|{1}1 click|[2,Inf]%count% clicks',
    'mautic.email.heatmap.clicks_recorded' => 'Clicks recorded',
    'mautic.email.heatmap.total' => 'total',
    'mautic.email.heatmap.unique' => 'unique',
    'mautic.email.heatmap.heat_scale' => 'Heat scale',
    'mautic.email.heatmap.cold' => 'cold',
    'mautic.email.heatmap.hot' => 'hot',
    'mautic.email.usages' => 'Email usages',
    'mautic.email.no_usages' => 'This email is not used by other components.',
    'mautic.email.preheader_text' => 'Preheader Text',
    'mautic.email.preheader_text.tooltip' => 'Short summary text that follows the subject line when viewing an email from the inbox, ideally between 85 and 100 characters.',
    'mautic.email.send.dnc.label' => 'Send to unsubscribed contacts',
    'mautic.email.send.dnc.tooltip.info' => 'If it is Yes, your email will be sent to people who have unsubscribed. Only emails that are transactional, have critical information, or are prompted by recipient actions should bypass the unsubscribe status.',
    'mautic.email.send.dnc.tooltip' => 'If you select this, your email will be sent to people who have unsubscribed. Only emails that are transactional, have critical information, or are prompted by recipient actions should bypass the unsubscribe status.',
    'mautic.email.send.dnc.confirmation' => 'If you select this, your email will be sent to people who meet the stated criteria, including those who unsubscribed. Only emails that are transactional, have critical information, or are prompted by recipient actions should bypass the unsubscribe status. Proceed?',
    'mautic.email.send.dnc.confirmation.confirm.text' => 'Yes',
    'mautic.email.send.dnc.confirmation.cancel.text' => 'Cancel',
    'mautic.campaign.form.submit' => 'Form submitted',
    'mautic.campaign.form.field_value' => 'Form field value',
    'mautic.email.form.users' => 'Send email to user',
    'mautic.form.field' => 'Form Field',
    'mautic.form.abtest.criteria' => 'Form Stats',
    'mautic.form.abtest.criteria.submissions' => 'Submission rate',
    'mautic.form.abtest.label.hits' => 'Number of unique page hits',
    'mautic.form.abtest.label.sentemils' => 'Number of sent emails',
    'mautic.form.abtest.label.submissions' => 'Number of submissions',
    'mautic.form.abtest.submissions' => '%count% submissions',
    'mautic.protip.forms.redirect' => 'Redirect URLs for forms can contain variables by using tokens like /thank-you?email={formfield=email}',
    'mautic.protip.forms.minimize' => 'Minimize the number of fields to improve form submission rates.',
    'mautic.protip.forms.language' => 'Use clear, action-oriented language in form headlines and CTAs (e.g. Get your free guide vs. Submit).',
    'mautic.protip.forms.multistep' => 'For longer forms, use a multi-step process to make them feel less overwhelming.',
    'mautic.placeholder_tokens.form.redirect_url' => 'Redirect URLs for forms can contain variables by using tokens (e.g. /thank-you?email={formfield=email})',
    'mautic.placeholder_tokens.form.field_value' => 'Field value',
    'mautic.placeholder_tokens.form.page' => 'Landing page',
    'mautic.placeholder_tokens.form_tokens' => 'Redirect URL specific',
    'mautic.form.form.searchcommand.isexpired.description' => 'Filters for forms that have passed their expiration date',
    'mautic.form.form.searchcommand.ispending.description' => 'Filters for forms that are scheduled but not yet active',
    'mautic.form.form.searchcommand.hasresults.description' => 'Filters for forms that have received submissions',
    'mautic.form.actions' => 'Form actions',
    'mautic.form.action.add' => 'Add a submit action',
    'mautic.form.action.repost' => 'Post results to another form',
    'mautic.form.action.repost.descr' => 'Forward the submitted results to another form',
    'mautic.form.action.repost.authorization_header' => 'Authorization header',
    'mautic.form.action.repost.authorization_header.tooltip' => 'If the form is behind a firewall, set the authorization header here.',
    'mautic.form.action.repost.failed_subject' => 'Form re-post failed: %form%',
    'mautic.form.action.repost.failed_message' => 'Submission URL: <a href=\'%link%\'>%link%</a><br /><br />Error message: %message%<br /><br />Results:<br />%results%',
    'mautic.form.action.repost.failure_email' => 'Post failure notification email',
    'mautic.form.action.repost.failure_email.tooltip' => 'If the re-post fails for whatever reason, this email will be notified.',
    'mautic.form.action.repost.field_mapping' => '(Optional) Override field names for the receiving form:',
    'mautic.form.action.repost.post_url' => 'Post URL',
    'mautic.form.action.repost.post_url.tooltip' => 'The URL to repost the results',
    'mautic.form.action.repost.validation_failed' => 'Form validation failed.',
    'mautic.form.action.sendemail' => 'Send form results',
    'mautic.form.action.sendemail.descr' => 'Send a simple email with form results to contact or other specified email(s).',
    'mautic.form.action.sendemail.immediately' => 'Send immediately',
    'mautic.form.action.sendemail.immediately.desc' => 'Ignore Queue mode from Email settings',
    'mautic.form.action.sendemail.copytolead' => 'Send to contact',
    'mautic.form.action.sendemail.setreplyto' => 'Reply to contact',
    'mautic.form.action.sendemail.setreplyto_tooltip' => 'Set the contact\'s email as the &quot;Reply To&quot; address so that if replying to the results email, the contact address will be the default recipient.',
    'mautic.form.action.sendemail.emailtoowner' => 'Send to owner',
    'mautic.form.action.sendemail.dragfield' => 'Click to insert field',
    'mautic.form.action.sendemail.message' => 'Message',
    'mautic.form.action.sendemail.subject' => 'Subject',
    'mautic.form.action.sendemail.subject.default' => 'Your form results',
    'mautic.form.builder.formfield' => 'Submission result',
    'mautic.form.builder.formfield.placeholder' => 'Insert form field alias...',
    'mautic.form.builder.formfield.remove_row' => 'Remove row',
    'mautic.form.campaign.event.forms' => 'Limit to Forms',
    'mautic.form.campaign.event.forms_descr' => 'Select the form(s) that will trigger the actions for dripflow.',
    'mautic.form.campaign.event.submit' => 'Submits form',
    'mautic.form.campaign.event.submit_descr' => 'Trigger actions when a contact submits a form',
    'mautic.form.confirm_batch_rebuild' => 'Rebuild the cached HTML for the selected form(s)?',
    'mautic.form.details.detail' => 'Detail',
    'mautic.form.details.field_order' => 'Field order: %order%',
    'mautic.form.details.field_type' => 'Field type: %type%',
    'mautic.form.event.submission' => '%form% submission',
    'mautic.form.event.submitted' => 'Form submitted',
    'mautic.form.field.add' => 'Add a field',
    'mautic.form.field.form.alias' => 'Field HTML name',
    'mautic.form.field.form.alias.tooltip' => 'Name for the HTML element. Once the form has been saved, this cannot be edited. If left blank, one will be generated from the field\'s label.',
    'mautic.form.field.form.auto_fill' => 'Auto fill data',
    'mautic.form.field.form.container_attr' => 'Field container attributes',
    'mautic.form.field.form.value' => 'Value',
    'mautic.form.field.form.emptyvalue' => 'Empty Value',
    'mautic.form.field.form.freetext_attributes' => 'Description text attributes',
    'mautic.form.field.form.freehtml_attributes' => 'HTML text attributes',
    'mautic.form.field.form.header' => 'Header',
    'mautic.form.field.form.header_attributes' => 'Header attributes',
    'mautic.form.field.form.helpmessage' => 'Help message',
    'mautic.form.field.form.inputattr' => 'Input attributes',
    'mautic.form.field.form.label' => 'Label',
    'mautic.form.field.form.labelattr' => 'Label attributes',
    'mautic.form.field.form.mapped.object' => 'Matching object',
    'mautic.form.field.form.mapped.field' => 'Matching field',
    'mautic.form.field.form.multiple' => 'Allow multiple?',
    'mautic.form.field.form.property_buttontype' => 'Button type',
    'mautic.form.field.form.property_captcha' => 'Captcha answer',
    'mautic.form.field.form.property_captchaerror' => 'Custom error message',
    'mautic.form.field.form.property_list_sync_choices' => 'Use assigned contact/company field\'s list choices.',
    'mautic.form.field.form.property_lookup_field' => 'Lookup Field',
    'mautic.form.field.form.property_placeholder' => 'Input placeholder',
    'mautic.form.field.form.property_pagebreak_nextpage_label' => 'Next page button label',
    'mautic.form.field.form.property_pagebreak_prevpage_label' => 'Previous page button label',
    'mautic.form.field.form.property_pagebreak_prevpage_placeholder' => 'Leave blank to not show',
    'mautic.form.field.form.saveresult' => 'Save result?',
    'mautic.form.field.form.showheader' => 'Show header?',
    'mautic.form.field.form.showlabel' => 'Show label?',
    'mautic.form.field.form.validationmsg' => 'Validation message',
    'mautic.form.field.group.labelattr' => 'Radio/checkbox label attributes',
    'mautic.form.field.help.attr' => 'Add custom HTML attributes i.e. class=&quot;myclass&quot;',
    'mautic.form.field.help.auto_fill' => 'Enable auto fill this value with that of the tracked contact profile\'s value. Please note that if several contacts share the same IP address, it may be possible to prepopulate with the incorrect details due to the way contacts are identified. This feature will currently only work for forms embedded into a Mautic landing page.',
    'mautic.form.field.help.captcha' => 'Use the label to pose a simple question that any human should be able to answer. Enter the correct answer here. For example, if the question is \'What is 10 plus 8?\' enter 18 here. Or leave blank and hide the label to use as a honey pot captcha.',
    'mautic.form.field.help.captcha_placeholder' => 'Leave blank to use as a honeypot.',
    'mautic.form.field.help.container_attr' => 'Add custom HTML attributes for the div that wraps the entire field i.e. class=&quot;myclass&quot;',
    'mautic.form.field.help.emptyvalue' => 'Enter the label to use as an empty value in the select list. Leave empty to disable.',
    'mautic.form.field.help.pagebreak' => 'Insert a page break where only fields for the current page are displayed.',
    'mautic.form.field.help.group.labelattr' => 'Add custom HTML attributes for the label that wraps each radio/checkbox i.e. class=&quot;myclass&quot;. Note that if left blank or if a class is not included, there will be a wrapping div placed around each label/input',
    'mautic.form.field.help.helpmessage' => 'Text to display below the label.',
    'mautic.form.field.help.mapped.object' => 'Choose an object to to get the list of its fields below.',
    'mautic.form.field.help.mapped.field' => 'Choose a field to associate it with this form field. If the field is a unique identifier such as an email for contacts, and a contact exists with the same value, the matching contact will be updated. A new contact will be created if no matching contact is found.',
    'mautic.form.field.help.saveresult' => 'If set to no, the value will not be saved to the database.',
    'mautic.form.field.section.attributes' => 'Attributes',
    'mautic.form.field.section.general' => 'General',
    'mautic.form.field.section.mappedfield' => 'Mapped Field',
    'mautic.form.field.section.properties' => 'Properties',
    'mautic.form.field.section.validation' => 'Validation',
    'mautic.form.field.type.button' => 'Button',
    'mautic.form.field.type.captcha' => 'Captcha',
    'mautic.form.field.type.checkboxgrp' => 'Checkbox group',
    'mautic.form.field.type.freetext' => 'Description area',
    'mautic.form.field.type.freehtml' => 'HTML area',
    'mautic.form.field.type.hidden' => 'Hidden',
    'mautic.form.field.type.lookup' => 'Lookup',
    'mautic.form.field.type.password' => 'Password',
    'mautic.form.field.type.pagebreak' => 'Page break',
    'mautic.form.field.type.radiogrp' => 'Radio group',
    'mautic.form.field.type.textarea' => 'Text: Paragraph',
    'mautic.form.field.type.file' => 'File',
    'mautic.form.field.type.tel.international' => 'Validate as international format',
    'mautic.form.field.file.public' => 'Public accessible link to download',
    'mautic.form.field.file.allowed_extensions' => 'Allowed file extensions',
    'mautic.form.field.file.allowed_size' => 'Maximum size (MB)',
    'mautic.form.field.file.set_as_profile_image' => 'Set as contact profile image',
    'mautic.form.field.file.tooltip.allowed_extensions' => 'Comma separated values (e.g. \'gif,jpg\')',
    'mautic.form.field.file.tooltip.allowed_size' => 'Maximum upload size of PHP configuration is: %uploadSize%MB',
    'mautic.form.stats.submission_counts' => 'Submissions (unique/total)',
    'mautic.form.form' => 'Form',
    'mautic.form.form.addaction' => 'Select an action from the \'Add a new submit action\' list.',
    'mautic.form.form.addfield' => 'Select a field from the \'Add a new field\' list.',
    'mautic.form.form.component.fields' => 'Add a new field',
    'mautic.form.form.component.submitactions' => 'Add a new submit action',
    'mautic.form.form.confirmbatchdelete' => 'Delete the selected forms? This will also delete ALL results associated with these forms!',
    'mautic.form.form.confirmdelete' => 'Delete the form, %name%? This will also delete ALL results associated with this form!',
    'mautic.form.form.header.embedded' => 'Embedded',
    'mautic.form.form.header.copy' => 'Form HTML',
    'mautic.form.form.header.edit' => 'Edit Form - %name%',
    'mautic.form.form.header.selfhosted' => 'Self-hosted',
    'mautic.form.form.header.new' => 'New Form',
    'mautic.form.form.header.preview' => 'Preview Form',
    'mautic.form.form.help.automaticcopy' => 'When you use this option, the entire form can be edited within the platform and these changes will automatically be reflected on any page where it is inserted.',
    'mautic.form.form.help.automaticcopy.js' => 'Via Javascript (recommended)',
    'mautic.form.form.help.automaticcopy.iframe' => 'Via iframe',
    'mautic.form.form.help.automaticcopy.iframe.note' => 'Note: Adjust the width and height attribute so the form fits in.',
    'mautic.form.form.help.landingpages' => 'It\'s really simple to place a form inside a Mautic landing page: just use the editor to select the form! But if you want more flexibility, use one of the other two options below.',
    'mautic.form.form.help.selfhosted' => 'Using self-hosted HTML, changes made on the platform won’t update on your site until you manually edit the HTML code, ensuring no dependency on external servers and enhanced privacy protection.',
    'mautic.form.form.help.selfhosted.body' => 'Copy and paste the form\'s content into the document\'s body.',
    'mautic.form.form.help.selfhosted.script' => 'Copy and paste into the document\'s head or body. If inserting multiple forms, only insert this once per page.',
    'mautic.form.form.kioskmode' => 'Kiosk Mode',
    'mautic.form.form.kioskmode.tooltip' => 'If set to yes, form submissions will not generate new contact tracking cookies or assign the IP address to created/updated contacts.',
    'mautic.form.form.kioskmode.yes' => 'Protect visitor privacy',
    'mautic.form.form.kioskmode.no' => 'Track visitor data',
    'mautic.form.form.renderstyle' => 'Use theme style?',
    'mautic.form.form.renderstyle.tooltip' => 'Disable/Enable rendering of CSS from template',
    'mautic.form.form.no_index' => 'Disable search indexing',
    'mautic.form.form.progressive_profiling_limit.max_fields' => 'Maximum fields displayed at a time',
    'mautic.form.form.progressive_profiling_limit.max_fields.tooltip' => 'The number for this field enables the progressive profiling feature and allows rendering only a certain amount of fields in time.',
    'mautic.form.form.progressive_profiling_limit_unlimited' => 'unlimited',
    'mautic.form.form.modalheader' => 'Form Component Details',
    'mautic.form.form.pagetoken.notpublished' => 'This form is not published. It will not be visible to the public.',
    'mautic.form.form.postaction' => 'Successful Submit Action',
    'mautic.form.form.postaction.message' => 'Display message',
    'mautic.form.form.postaction.redirect' => 'Redirect URL',
    'mautic.form.form.postaction.return' => 'Remain at form',
    'mautic.form.form.postactionproperty' => 'Redirect URL/Message',
    'mautic.form.form.postactionproperty.tooltip' => 'Tokens available to use:<br>- <code>{pagelink=ID}</code> for a landing page URL (for redirect actions)<br>- <code>{contactfield=ALIAS}</code> for lead values<br>- <code>{formfield=ALIAS}</code> for form inputs.',
    'mautic.form.form.preview' => 'Preview',
    'mautic.form.form.resultcount' => 'Number of results',
    'mautic.form.form.results' => 'Results',
    'mautic.form.form.viewresults' => '{0} No Results|{1} View One Result|]1,Inf[ View %count% Results',
    'mautic.form.form.results.name' => 'Result ID %id%',
    'mautic.form.form.searchcommand.hasresults' => 'has:results',
    'mautic.form.form.searchcommand.isexpired' => 'is:expired',
    'mautic.form.form.searchcommand.ispending' => 'is:pending',
    'mautic.form.form.template.help' => 'If this form is to be integrated into a 3rd party site via popup or iframe, choose a template to style the page containing the form.',
    'mautic.form.field.form.form_attr' => 'Form attributes',
    'mautic.form.field.form.form_attr.tooltip' => 'Add custom HTML attributes to form tag i.e. name=&quot;my-form&quot;. Some software may require custom attributes.',
    'mautic.form.forms' => 'Forms',
    'mautic.form.graph.line.submissions' => 'Submissions',
    'mautic.form.icon_tooltip.campaign_form' => 'Is a campaign form',
    'mautic.form.noresults.tip' => 'Use one of our 3rd party CMS plugins to easily integrate forms into your website!',
    'mautic.form.permissions.forms' => 'Forms - User has access to',
    'mautic.form.permissions.header' => 'Form Permissions',
    'mautic.form.point.action' => 'Form actions',
    'mautic.form.point.action.forms' => 'Limit to the selected forms',
    'mautic.form.point.action.forms.descr' => 'Select the forms this action applies to. If none are selected, it\'ll apply to any form.',
    'mautic.form.point.action.submit' => 'Submits a form',
    'mautic.form.point.action.submit_descr' => 'Update the contact\'s points when a form is submitted.',
    'mautic.form.rebuild' => 'Rebuild Cache',
    'mautic.form.report.form_id' => 'Form ID',
    'mautic.form.report.page_id' => 'Page ID',
    'mautic.form.report.page_name' => 'Page name',
    'mautic.form.report.submission.table' => 'Form Submissions',
    'mautic.form.report.submission.id' => 'Submission ID',
    'mautic.form.report.submit.date_submitted' => 'Date submitted',
    'mautic.form.report.form_results.label' => 'Form Results %field%',
    'mautic.form.result.export.csv' => 'Export to CSV',
    'mautic.form.result.export.html' => 'Export to HTML',
    'mautic.form.result.export.pdf' => 'Export to PDF',
    'mautic.form.result.export.xlsx' => 'Export to Excel',
    'mautic.form.result.header.index' => 'Results for %name%',
    'mautic.form.result.thead.date' => 'Date Submitted',
    'mautic.form.result.thead.referrer' => 'Referrer',
    'mautic.form_results.form.confirmbatchdelete' => 'Delete the selected results?',
    'mautic.form.results.form.confirmdelete' => 'Delete this result?',
    'mautic.form.stage.action' => 'Form actions',
    'mautic.form.stage.action.submit' => 'Submits a form',
    'mautic.form.submission.errors' => 'Errors:',
    'mautic.form.submission.thankyou' => 'Thank you!',
    'mautic.form.submission.pleasewait' => 'Please wait...',
    'mautic.form.tab.actions' => 'Actions',
    'mautic.form.tab.fields' => 'Fields',
    'mautic.form.table.most.submitted' => 'Most submitted forms',
    'mautic.form.table.top.referrers' => 'Top referrers',
    'mautic.form.type.header' => 'What type of form do you want to create?',
    'mautic.form.type.campaign' => 'Campaign Forms',
    'mautic.form.type.one.differences.1st' => 'Used to initiate automated campaign workflows',
    'mautic.form.type.one.differences.2nd' => 'Limited form actions',
    'mautic.form.type.one.differences.3rd' => 'Focuses on contact management',
    'mautic.form.type.two.differences.1st' => 'Independent forms focused on flexibility',
    'mautic.form.type.two.differences.2nd' => 'Contains all form actions',
    'mautic.form.type.two.differences.3rd' => 'Actions for scoring, segmentation, and integration',
    'mautic.form.type.campaign.header' => 'Campaign form',
    'mautic.form.type.standalone' => 'Standalone Forms',
    'mautic.form.type.standalone.header' => 'Standalone form',
    'mautic.form.webhook.event.form.submit' => 'Form Submit Event',
    'mautic.form.campaign.event.field_value' => 'Form field value',
    'mautic.form.campaign.event.field_value_descr' => 'Trigger actions when a submitted form field value suits the defined condition.',
    'mautic.form.dashboard.widgets' => 'Form Widgets',
    'mautic.form.lead' => 'Lead',
    'mautic.form.submission.count' => 'Submission Count',
    'mautic.widget.submissions.in.time' => 'Submissions in time',
    'mautic.widget.top.submission.referrers' => 'Top submission referrers',
    'mautic.widget.top.submitters' => 'Top submitters',
    'mautic.widget.created.forms' => 'Created forms',
    'mautic.report.group.forms' => 'Forms',
    'mautic.report.group.form.results' => 'Form Results',
    'mautic.form.field.section.progressive.profiling' => 'Behavior',
    'mautic.form.field.form.always_display' => 'Always display',
    'mautic.form.field.form.always_display.tooltip' => 'Force display this field in form if you set maximum fields displayed at a time. ',
    'mautic.form.field.form.show.when.value.exists' => 'Show when value exists',
    'mautic.form.field.help.show.when.value.exists' => 'Display this field when the active contact already filled this field value.',
    'mautic.form.field.form.show.after.x.submissions' => 'Show after X submissions',
    'mautic.form.field.help.show.after.x.submissions' => 'Display this field only when the active contact submits this form for X time, X being the number of submissions from this option.',
    'mautic.form.field.hide.if.value' => 'Hide if value exist',
    'mautic.form.field.hide.if.submission.count' => '{1}Show after 1 submission|[2,Inf] Show after %count% submissions',
    'mautic.config.tab.formconfig' => 'Form Settings',
    'mautic.config.tab.formresultsconfig' => 'Form Results Settings',
    'mautic.form.field.type.donotsubmit' => 'Domain name submission filter',
    'mautic.form.config.form.do_not_submit_email' => 'Do not accept submission from these domain names',
    'mautic.form.config.form.do_not_submit_email.tooltip' => 'Enter the emails, one per line, to which you would like to restrict form submission. You can filter a specific email address (email@yourdomain.com) or a whole domain name using wildcard (*domain.com).',
    'mautic.form.config.form_results_data_sources' => 'Use the form result as report data sources',
    'mautic.form.config.form_results_data_sources.tooltip' => 'Enable if you want to use the form results tables as report data sources.',
    'mautic.form.config.form.successful_submit_action' => 'Successful submit action',
    'mautic.form.config.form.successful_submit_action.tooltip' => 'Select the location of the successful submit action on the form',
    'mautic.form.config.form.successful_submit_action_at_the_top' => 'at the top',
    'mautic.form.config.form.successful_submit_action_at_the_bottom' => 'at the bottom',
    'mautic.form.field.form.condition' => 'Condition',
    'mautic.form.field.form.condition.enabled' => 'Enabled',
    'mautic.form.field.form.condition.show.only' => 'Show only on select values',
    'mautic.form.field.form.condition.show.only.tooltip' => 'Select boxes with option groups will show only the option group that matches the parent field value. If no option group exists the conditional field itself will be hidden. Use case: Show only states for countries that have some states.',
    'mautic.form.field.form.condition.field.value' => '',
    'mautic.form.field.form.dependency.label' => 'Does this field depend on the entered value from another field?',
    'mautic.form.field.form.dependent.field.mapping' => 'Dependent Field Mapping',
    'mautic.form.field.form.condition.show.on' => 'Show only if selection from',
    'mautic.form.field.form.condition.select.value' => 'values',
    'mautic.form.field.form.condition.any_value' => 'Any value',
    'mautic.form.field.form.number_precision' => 'Precision',
    'mautic.form.field.form.number_precision.tooltip' => 'Number of decimal allowed before rounding occurs.',
    'mautic.form.form.component.fields.conditional' => 'Add field based on selected value',
    'mautic.form.field.form.condition.select_one_of' => 'select one of',
    'mautic.form.field.form.condition.select_other_thatn' => 'select other than',
    'mautic.form.form.locale.tooltip' => 'Set the form\'s primary language. It defaults to the configuration\'s language.',
    'mautic.install.composer.dependencies' => 'Vendor libraries must be installed. If you are running Mautic from source, please run \'composer install\'. If you downloaded Mautic, please check for the \'vendor\' folder.',
    'mautic.install.config.unwritable' => 'Mautic is unable to write your configuration file to the appropriate location. Please check your filesystem permissions to ensure the following path is writable: <strong>%path%</strong>.',
    'mautic.install.database.installing' => 'Verifying the details and creating the database. This may take a few seconds.',
    'mautic.install.database.introtext' => 'To function properly, Mautic requires a connection to a database server. Use this form to provide the required details for this connection.',
    'mautic.install.date.timezone.not.set' => 'The <strong>date.timezone</strong> setting is not set in your PHP configuration. Mautic has set the default timezone to \'UTC\' but we suggest setting this in your PHP configuration.',
    'mautic.install.detect.unicode' => 'The detect_unicode setting should be disabled in your PHP configuration.',
    'mautic.install.directory.unwritable' => 'The %path% directory must be writable. Change the permissions of the <strong>%path%</strong> directory so that the web server can write into it.',
    'mautic.install.extension.curl' => 'Install and enable the <strong>curl</strong> extension.',
    'mautic.install.extension.fileinfo' => 'Install and enable the <strong>fileinfo</strong> extension.',
    'mautic.install.extension.imap' => 'Install and enable the <strong>imap</strong> extension to support monitored email.',
    'mautic.install.extension.mbstring' => 'Install and enable the <strong>mbstring</string> extension.',
    'mautic.install.extension.openssl' => 'Install and enable the <strong>openssl</strong> extension. If open_basedir is enabled, ensure it has access to /dev/random or /dev/urandom.',
    'mautic.install.extension.zip' => 'Install and enable the <strong>zip</strong> extension. This is required to allow Mautic to install language packages and perform updates within the application.',
    'mautic.install.final.step' => 'Finish',
    'mautic.install.finalizing' => 'Finalizing the installation. This may take a few seconds.',
    'mautic.install.form.backup_prefix' => 'Prefix for backup tables',
    'mautic.install.form.cache_path' => 'Cache directory path',
    'mautic.install.form.database.driver' => 'Database Driver',
    'mautic.install.form.database.host' => 'Database Host',
    'mautic.install.form.database.name' => 'Database Name',
    'mautic.install.form.database.password' => 'Database Password',
    'mautic.install.form.database.port' => 'Database Port',
    'mautic.install.form.database.secret' => 'Site Secret Value',
    'mautic.install.form.database.table.prefix' => 'Database Table Prefix',
    'mautic.install.form.database.user' => 'Database Username',
    'mautic.install.form.existing_tables' => 'Backup existing tables?',
    'mautic.install.form.existing_tables_descr' => 'If set to no, conflicting tables will be dropped.',
    'mautic.install.form.log_path' => 'Log directory path',
    'mautic.install.form.none' => 'None',
    'mautic.install.form.update_stability' => 'Minimum Stability',
    'mautic.install.form.user.email' => 'E-mail Address',
    'mautic.install.form.user.password' => 'Admin Password',
    'mautic.install.form.user.username' => 'Admin Username',
    'mautic.install.function.ctypealpha' => 'Install and enable the <strong>ctype</strong> extension.',
    'mautic.install.function.iconv' => 'Install and enable the <strong>iconv</strong> extension.',
    'mautic.install.function.jsonencode' => 'Install and enable the <strong>JSON</strong> extension.',
    'mautic.install.function.mbstring' => 'Install and enable the <strong>mbstring</strong> extension.',
    'mautic.install.function.posix.enable' => 'Enable the <strong>php_posix</strong> extension (used to colorize command line output).',
    'mautic.install.function.sessionstart' => 'Install and enable the <strong>session</strong> extension.',
    'mautic.install.function.simplexml' => 'Install and enable the <strong>SimpleXML</strong> extension.',
    'mautic.install.function.tokengetall' => 'Install and enable the <strong>Tokenizer</strong> extension.',
    'mautic.install.function.xml' => 'Install and enable the <strong>XML</strong> extension.',
    'mautic.install.memory.limit' => 'The <strong>memory_limit</strong> setting in your PHP configuration is lower than the suggested minimum limit of %min_memory_limit%. Mautic can have performance issues with large datasets without sufficient memory.',
    'mautic.install.heading.check.environment' => 'Mautic Installation - Environment Check',
    'mautic.install.heading.configured' => 'Mautic is installed! Visit <a href=\'https://www.mautic.org/getting-started\' target=\'_blank\'>Getting Started</a> for the next steps.',
    'mautic.install.heading.database.configuration' => 'Mautic Installation - Database Setup',
    'mautic.install.heading.final' => 'Mautic Installation - Final Steps',
    'mautic.install.heading.finished' => 'Well Done!',
    'mautic.install.heading.major.problems' => 'Major Problems that need to be fixed now',
    'mautic.install.heading.minor.problems' => 'Some Recommendations',
    'mautic.install.heading.misc.configuration' => 'Mautic Installation - Miscellaneous',
    'mautic.install.heading.ready' => 'Ready to Install!',
    'mautic.install.heading.user.configuration' => 'Mautic Installation - Administrative User',
    'mautic.install.intl.config' => 'The intl extension is not performing as expected. Please check that PHP\'s intl extension is installed and configured properly.',
    'mautic.install.zend_assertions' => 'Configure <code>zend.assertions = -1</code> in php.ini for production environments for faster and more stable execution.',
    'mautic.install.magic_quotes_enabled' => 'Your server has PHP\'s <strong>magic_quotes_gpc</strong> option enabled, please disable this option to use Mautic.',
    'mautic.install.minimum.php.version' => 'Your server does not meet the minimum PHP requirements. Mautic requires PHP version %minimum% while your server has %installed%. Please contact your host to update your PHP installation.',
    'mautic.install.misc.header.paths' => 'Where should the logs and cache be stored?',
    'mautic.install.misc.header.stability' => 'Set the update stability path',
    'mautic.install.misc.header.url' => 'Full URL to this site',
    'mautic.install.misc.subheader.paths' => 'Set the absolute path to a couple directories Mautic uses. It is recommended that these be outside the publicly available web root.',
    'mautic.install.misc.subheader.stability' => 'You are installing a non-stable version of Mautic (such as a beta release). Mautic defaults to showing only stable releases. You can optionally choose to fetch updates for non-stable releases here by choosing a minimum upgrade stability. For example, by selecting the Beta channel, you will be shown beta releases as well as stable releases.',
    'mautic.install.misc.subheader.url' => 'Some features, such as scheduled campaigns and/or campaigns that are based on a contact\'s lack of interaction, will need to be triggered by a cron job. Mautic will need to know the site URL for these instances in order to properly generate landing page, asset, and clickthrough (redirect) URLs.',
    'mautic.install.module.intl' => 'Install and enable the <strong>intl</strong> extension.',
    'mautic.install.module.phpxml' => 'Install and enable the <strong>PHP-XML</strong> module.',
    'mautic.install.next.step' => 'Next Step',
    'mautic.install.password.minlengt' => 'Your password must be at least six characters long',
    'mautic.install.pdo.drivers' => 'Please install the mysql PDO Driver',
    'mautic.install.pdo.mandatory' => 'PDO Extension is mandatory',
    'mautic.install.php.version.has.only.security.support' => 'You have PHP version %phpversion% installed which is only receiving security fixes at this time. This means your PHP version will soon no longer be supported. We recommend planning to upgrade to a newer PHP version. You can view which PHP versions are actively supported <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'>at PHP.net</a>.',
    'mautic.install.php.version.not.supported' => 'You have PHP version installed which is no longer supported by the PHP project or Mautic. We highly recommend upgrading your server to a newer PHP version. You can view which PHP versions are actively supported <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'>at PHP.net</a>.',
    'mautic.install.please.wait' => 'Please wait',
    'mautic.install.sentence.config.written' => 'Your local.php configuration file has been overwritten with these parameters (in <em>%path%</em>):',
    'mautic.install.sentence.major.problems' => 'We have detected <strong>%majors%</strong> major problems. You <em>must</em> fix them before continuing:',
    'mautic.install.sentence.minor.problems' => 'We have detected some minor things that we <em>recommend</em> changing in order to have a better Mautic experience:',
    'mautic.install.sentence.proceed.to.mautic' => 'Proceed to Mautic',
    'mautic.install.sentence.ready' => 'Great! Your environment is ready for Mautic.',
    'mautic.install.ssl.certificate' => 'It is recommended to secure your installation with an SSL certificate (https). Starting February 2020 Google Chrome will stop sending third-party cookies in cross-site requests unless the cookies are secure. Tracking will stop working for Mautic instances running on HTTP. Use HTTPS.',
    'mautic.install.step.1' => '1',
    'mautic.install.step.2' => '2',
    'mautic.install.step.3' => '3',
    'mautic.install.step.4' => '4',
    'mautic.install.step.5' => '5',
    'mautic.install.suhosin.whitelist' => 'Suhosin is not properly configured, add <strong>phar</strong> to <strong>suhosin.executor.include.whitelist</strong> in your PHP configuration.',
    'mautic.install.timezone.not.supported' => 'Your default timezone is not supported by PHP. Check for typos in your PHP configuration.',
    'mautic.install.user.introtext' => 'Create the admin user for your Mautic installation.',
    'mautic.install.xdebug.exception.trace' => 'Xdebug\'s \'show_exception_trace\' option should be disabled in your PHP configuration.',
    'mautic.install.xdebug.nesting' => 'Set <strong>xdebug.max_nesting_level</strong> to at least <strong>250</strong> in your PHP configuration to stop Xdebug\'s infinite recursion protection from erroneously throwing a fatal error.',
    'mautic.install.xdebug.scream' => 'Xdebug\'s \'scream\' option should be disabled in your PHP configuration.',
    'mautic.integration.app.authorize' => 'Authorize app',
    'mautic.integration.app.reauthorize' => 'Reauthorize app',
    'mautic.integration.integration' => 'Integration',
    'mautic.integration.message' => 'Message',
    'mautic.integration.not_configured' => 'The integration is not configured.',
    'mautic.integration.object' => 'Object',
    'mautic.integration.object_id' => 'Object ID',
    'mautic.integration.last_sync_date' => 'Last Sync Date',
    'mautic.integration.sync_objects' => 'Select the objects to sync with Mautic',
    'mautic.integration.sync.update_blanks' => 'Should non-blank values be overridden with blanks from the opposite system?',
    'mautic.integration.enabled' => 'Plugin must be enabled and authorized for this field to work',
    'mautic.integration.feature.sync' => 'Sync objects between Mautic and this integration',
    'mautic.integration.feature.push_activity' => 'Push Mautic activity to this integration',
    'mautic.integration.feature.push_activity.included_events' => 'Events to include when pushing activity',
    'mautic.integration.feature.push_activity.included_events.tooltip' => 'Select the Mautic events that will be sent to the integration as activity.',
    'mautic.integration.features' => 'What features of this integration should be enabled?',
    'mautic.integration.sync_field_mapping' => '%object% Field Mapping',
    'mautic.integration.sync_direction_integration' => 'Sync only to the integration',
    'mautic.integration.sync_direction_mautic' => 'Sync only to Mautic',
    'mautic.integration.sync_direction_bidirectional' => 'Sync both ways',
    'mautic.integration.sync_mautic_field' => 'Choose a Mautic field...',
    'mautic.integration.sync_filter_fields' => 'Filter integration fields...',
    'mautic.integration.oauth1a.consumer.key' => 'Consumer Key',
    'mautic.integration.oauth1a.consumer.secret' => 'Consumer Secret',
    'mautic.integration.oauth1a.token' => 'Token',
    'mautic.integration.oauth1a.token.secret' => 'Token Secret',
    'mautic.integration.sync.channel_dnc' => 'Do Not Contact - %channel%',
    'mautic.integration.sync.contact_timeline' => 'Contact Timeline URL',
    'mautic.integration.sync.event' => '%integration%: %message%',
    'mautic.integration.sync.user_notification.header' => 'Issue encountered while syncing with the %integration% %object% object',
    'mautic.integration.sync.user_notification.count_message' => '%count% objects failed to sync. Consider validating the integration\'s configuration.',
    'mautic.integration.sync.user_notification.contact' => 'The following contacts failed to sync. Check their timelines for more details. %contacts%',
    'mautic.integration.sync.user_notification.sync_error' => '%name% failed to sync with message, &quot;%message%&quot;',
    'mautic.integration.sync.timeline_notices' => 'Integration sync notice',
    'mautic.campaign.lead.changelist' => 'Modify contact\'s segments',
    'mautic.campaign.lead.changepoints' => 'Adjust contact points',
    'mautic.campaign.lead.changetags' => 'Change tags',
    'mautic.campaign.lead.adddnc' => 'Add Do Not Contact',
    'mautic.campaign.lead.removednc' => 'Remove Do Not Contact',
    'mautic.campaign.lead.field_value' => 'Contact field value',
    'mautic.campaign.lead.device' => 'Contact device',
    'mautic.campaign.lead.owner' => 'Contact owner',
    'mautic.campaign.lead.updatelead' => 'Update contact',
    'mautic.campaign.lead.updatecompany' => 'Update contact\'s primary company',
    'mautic.contact.error.notfound' => 'Contact not found.',
    'mautic.contact.noinformation.devices' => 'Everyone\'s eager to learn what gadgets your customers love. Make sure our tracking script is part of your website.',
    'mautic.contact.noinformation.places' => 'Our system is still on the trail. Don’t forget to enable geolocation services in the settings.',
    'mautic.contact.noinformation.statistics' => 'Zero email activity? Fill them up by sending some emails.',
    'mautic.contact.noinformation.upcoming' => 'Add your lead to a segment or campaign to see upcoming activities.',
    'mautic.campaign.lead.scorecontactscompanies' => 'Score company',
    'mautic.campaign.lead.deletecontact' => 'Delete contact',
    'mautic.campaign.lead.notfound' => 'No marketing campaigns yet. Consider adding to one.',
    'mautic.campaign.lead.segments' => 'Segments',
    'mautic.campaign.lead.tags' => 'Tags',
    'mautic.campaign.lead.points' => 'Contact points',
    'mautic.protip.contacts.view' => 'Use the <kbd>V</kbd> key to switch between card and table views.',
    'mautic.protip.contacts.tags' => 'Add tags during import to help organize and segment your contacts. Example: (import_facebook_may2024)',
    'mautic.protip.contacts.list' => 'Build your email list through organic opt-ins rather than purchasing lists.',
    'mautic.protip.segments.dynamic' => 'Use behavioral data like website activity and email engagement to create dynamic segments that update automatically',
    'mautic.protip.segments.test' => 'Test different segment combinations to find the most effective groupings for your campaigns',
    'mautic.core.date.added_first' => 'First Touch Date Added',
    'mautic.core.date.added_last' => 'Last Touch Date Added',
    'mautic.contact.import.tip.title' => 'Want to add more than one contact at once?',
    'mautic.contact.import.tip.description' => 'Save time and use our import contacts tool.',
    'mautic.contact.import.tip.button' => 'Import multiple contacts',
    'mautic.placeholder_tokens.contact.tokens' => 'Emails, Text Messages and Dynamic Content',
    'mautic.placeholder_tokens.contact_fields' => 'Contact',
    'mautic.placeholder_tokens.contact_owner_fields' => 'Contact owner',
    'mautic.placeholder_tokens.company_contact_fields' => 'Company',
    'mautic.placeholder_tokens.custom_fields' => 'Custom fields',
    'mautic.placeholder_tokens.contact.attribution' => 'Attribution',
    'mautic.placeholder_tokens.contact.attribution_date' => 'Attribution Date',
    'mautic.placeholder_tokens.contact.address1' => 'Address Line 1',
    'mautic.placeholder_tokens.contact.address2' => 'Address Line 2',
    'mautic.placeholder_tokens.contact.country' => 'Country',
    'mautic.placeholder_tokens.contact.city' => 'City',
    'mautic.placeholder_tokens.contact.company' => 'Company',
    'mautic.placeholder_tokens.contact.id' => 'Contact ID',
    'mautic.placeholder_tokens.contact.email' => 'Email',
    'mautic.placeholder_tokens.contact.facebook' => 'Facebook',
    'mautic.placeholder_tokens.contact.fax' => 'Fax',
    'mautic.placeholder_tokens.contact.firstname' => 'First Name',
    'mautic.placeholder_tokens.contact.foursquare' => 'Foursquare',
    'mautic.placeholder_tokens.contact.googleplus' => 'Google+',
    'mautic.placeholder_tokens.contact.instagram' => 'Instagram',
    'mautic.placeholder_tokens.contact.ipaddress' => 'IP Address',
    'mautic.placeholder_tokens.contact.lastname' => 'Last Name',
    'mautic.placeholder_tokens.contact.linkedin' => 'LinkedIn',
    'mautic.placeholder_tokens.contact.mobile' => 'Mobile Number',
    'mautic.placeholder_tokens.contact.phone' => 'Phone Number',
    'mautic.placeholder_tokens.contact.position' => 'Position',
    'mautic.placeholder_tokens.contact.skype' => 'Skype',
    'mautic.placeholder_tokens.contact.state' => 'State',
    'mautic.placeholder_tokens.contact.twitter' => 'Twitter',
    'mautic.placeholder_tokens.contact.title' => 'Title',
    'mautic.placeholder_tokens.contact.website' => 'Website',
    'mautic.placeholder_tokens.contact.zipcode' => 'Zip Code',
    'mautic.placeholder_tokens.owner.firstname' => 'First Name',
    'mautic.placeholder_tokens.owner.lastname' => 'Last Name',
    'mautic.placeholder_tokens.owner.email' => 'Email',
    'mautic.placeholder_tokens.owner.position' => 'Position',
    'mautic.placeholder_tokens.owner.signature' => 'Signature',
    'mautic.placeholder_tokens.company.address1' => 'Address Line 1 (Company)',
    'mautic.placeholder_tokens.company.address2' => 'Address Line 2 (Company)',
    'mautic.placeholder_tokens.company.annual_revenue' => 'Annual Revenue (Company)',
    'mautic.placeholder_tokens.company.city' => 'City (Company)',
    'mautic.placeholder_tokens.company.country' => 'Country (Company)',
    'mautic.placeholder_tokens.company.description' => 'Description (Company)',
    'mautic.placeholder_tokens.company.email' => 'Email (Company)',
    'mautic.placeholder_tokens.company.fax' => 'Fax (Company)',
    'mautic.placeholder_tokens.company.industry' => 'Industry (Company)',
    'mautic.placeholder_tokens.company.name' => 'Name',
    'mautic.placeholder_tokens.company.number_of_employees' => 'Number of Employees (Company)',
    'mautic.placeholder_tokens.company.phone' => 'Phone Number (Company)',
    'mautic.placeholder_tokens.company.state' => 'State (Company)',
    'mautic.placeholder_tokens.company.website' => 'Website (Company)',
    'mautic.placeholder_tokens.company.zipcode' => 'Zip Code (Company)',
    'mautic.placeholder_tokens.custom_fields.date_and_time' => 'Date and Time',
    'mautic.placeholder_tokens.custom_fields.date_and_time.description' => 'When working with date and time fields, you can specify date and time formats based on your Mautic\'s settings.',
    'mautic.placeholder_tokens.custom_fields.datetime' => 'Date and Time',
    'mautic.placeholder_tokens.custom_fields.date' => 'Date only',
    'mautic.placeholder_tokens.custom_fields.time' => 'Time only',
    'mautic.placeholder_tokens.custom_fields.note' => 'Replace aliasofyourcustomdatefield with the alias of your custom field.',
    'mautic.email.batch.categories' => 'Change Category',
    'mautic.email.category.batch.set' => 'Change to Category',
    'mautic.lead.lead.searchcommand.isanonymous.description' => 'Filters for contacts that are anonymous (not identified)',
    'mautic.lead.lead.searchcommand.list.description' => 'Filters contacts by a specific segment (use the segment alias)',
    'mautic.lead.lead.searchcommand.company.description' => 'Filters contacts by company name',
    'mautic.lead.lead.searchcommand.company_id.description' => 'Filters contacts by company ID',
    'mautic.lead.lead.searchcommand.owner.description' => 'Filters for contacts owned by a specific user',
    'mautic.lead.lead.searchcommand.tag.description' => 'Filters contacts by a specific tag',
    'mautic.lead.lead.searchcommand.stage.description' => 'Filters contacts by a specific stage',
    'mautic.lead.lead.searchcommand.duplicate.description' => 'Finds contacts that are common among the specified segments',
    'mautic.lead.lead.searchcommand.email_sent.description' => 'Filters contacts who have been sent a specific email',
    'mautic.lead.lead.searchcommand.email_read.description' => 'Filters contacts who have read a specific email',
    'mautic.lead.lead.searchcommand.email_queued.description' => 'Filters contacts who have a specific email queued to be sent',
    'mautic.lead.lead.searchcommand.email_pending.description' => 'Filters contacts who have a specific email pending',
    'mautic.lead.lead.searchcommand.page_source.description' => 'Filters contacts by the source of the page they visited',
    'mautic.lead.lead.searchcommand.page_source_id.description' => 'Filters contacts by the ID of the page source',
    'mautic.lead.lead.searchcommand.import_id.description' => 'Filters contacts by a specific import ID',
    'mautic.lead.lead.searchcommand.import_action.description' => 'Filters contacts by a specific import action',
    'mautic.lead.lead.searchcommand.page_id.description' => 'Filters contacts who have visited a specific page (by ID)',
    'mautic.lead.lead.searchcommand.sms_sent.description' => 'Filters contacts who have been sent a specific SMS',
    'mautic.lead.lead.searchcommand.web_sent.description' => 'Filters contacts who have been sent a specific web notification',
    'mautic.lead.lead.searchcommand.mobile_sent.description' => 'Filters contacts who have been sent a specific mobile notification',
    'title.description' => 'Searches contacts by their title',
    'firstname.description' => 'Searches contacts by their first name',
    'lastname.description' => 'Searches contacts by their last name',
    'company.description' => 'Searches contacts by their company name',
    'position.description' => 'Searches contacts by their job position',
    'email.description' => 'Searches notes for contacts by email address',
    'mobile.description' => 'Searches contacts by their mobile phone number',
    'phone.description' => 'Searches contacts by their phone number',
    'points.description' => 'Searches contacts by their point total',
    'fax.description' => 'Searches contacts by their fax number',
    'address1.description' => 'Searches contacts by their primary address',
    'address2.description' => 'Searches contacts by their secondary address',
    'city.description' => 'Searches contacts by their city',
    'state.description' => 'Searches contacts by their state or province',
    'zipcode.description' => 'Searches contacts by their zip or postal code',
    'country.description' => 'Searches contacts by their country',
    'preferred_locale.description' => 'Searches contacts by their preferred language/locale',
    'timezone.description' => 'Searches contacts by their timezone',
    'last_active.description' => 'Searches contacts by their last active date',
    'attribution_date.description' => 'Searches contacts by their attribution date',
    'attribution.description' => 'Searches contacts by their attribution value',
    'website.description' => 'Searches contacts by their website URL',
    'facebook.description' => 'Searches contacts by their Facebook profile',
    'foursquare.description' => 'Searches contacts by their Foursquare profile',
    'instagram.description' => 'Searches contacts by their Instagram profile',
    'linkedin.description' => 'Searches contacts by their LinkedIn profile',
    'skype.description' => 'Searches contacts by their Skype username',
    'twitter.description' => 'Searches contacts by their Twitter handle',
    'mautic.lead.add.note' => 'Add note',
    'mautic.lead.attribution' => 'Attribution',
    'mautic.lead.attribution.tooltip' => 'Specify the estimated revenue this lead has generated across all marketing touchpoints.',
    'mautic.lead.attribution_date' => 'Attribution date',
    'mautic.lead.attribution_date.tooltip' => 'Select the date when the attributed revenue was realized or should be credited.',
    'mautic.lead.batch.add_to' => 'Add to the following:',
    'mautic.lead.batch.campaigns' => 'Change Campaigns',
    'mautic.lead.batch.owner' => 'Change Owner',
    'mautic.lead.batch.categories' => 'Change Categories',
    'mautic.lead.batch.channels' => 'Change Channels',
    'mautic.lead.batch.dnc' => 'Set Do Not Contact',
    'mautic.lead.batch.dnc_reason' => 'Reason',
    'mautic.lead.batch.lists' => 'Change Segments',
    'mautic.lead.batch.remove_from' => 'Remove from the following:',
    'mautic.lead.batch.stages' => 'Change Stages',
    'mautic.lead.no_company' => 'This contact is not associated with a company.',
    'mautic.lead.contact' => 'Contact',
    'mautic.lead.contact.channels' => 'Channels',
    'mautic.lead.contact.frequency' => 'Preferences',
    'mautic.lead.lead.field.stage' => 'Stage',
    'mautic.lead.device' => 'Device',
    'mautic.lead.device.header' => 'Type',
    'mautic.lead.devices' => 'Devices',
    'mautic.lead.device_brand' => 'Device brand',
    'mautic.lead.device_brand.header' => 'Brand',
    'mautic.lead.device_browser.header' => 'Browser',
    'mautic.lead.device_model' => 'Device model',
    'mautic.lead.device_os_name' => 'Device OS',
    'mautic.lead.device_os_name.header' => 'Operating System',
    'mautic.lead.device_os_shortname' => 'Device OS shortname',
    'mautic.lead.device_os_version' => 'Device OS version',
    'mautic.lead.device_os_version.header' => 'OS Version',
    'mautic.lead.device_os_platform' => 'Device OS platform',
    'mautic.lead.do.not.contact' => 'Do Not Contact',
    'mautic.lead.do.not.contact_bounced' => 'Bounced',
    'mautic.lead.do.not.contact_unsubscribed' => 'Unsubscribed',
    'mautic.lead.do.not.contact_manual' => 'Manual',
    'mautic.lead.do.not.contact_channel' => 'Do Not Contact: %channel%',
    'mautic.lead.do.not.contact_bounced_channel' => 'Bounced: %channel%',
    'mautic.lead.email.from_email' => 'From',
    'mautic.lead.email.from_name' => 'From address',
    'mautic.lead.email.header.index' => 'Contact Fields',
    'mautic.lead.email.send_email' => 'Send email',
    'mautic.lead.email.send_email.header' => 'Send a custom email to %email%',
    'mautic.lead.email.send_email.disabled' => 'Contact does not have an email address, thus email sending is disabled.',
    'mautic.lead.email.template' => 'Import from an existing template',
    'mautic.lead.event.delete' => 'Contact deleted',
    'mautic.lead.event.merge' => 'Contact merged',
    'mautic.lead.event.create' => 'Contact created',
    'mautic.lead.event.donotcontact' => 'Do not contact',
    'mautic.lead.event.donotcontact_channel' => 'Do not contact: %channel%',
    'mautic.lead.event.donotcontact_contactable' => 'Contact is contactable.',
    'mautic.lead.event.donotcontact_bounced' => 'Communication bounced for this channel.',
    'mautic.lead.event.donotcontact_manual' => 'Contact was manually set as do not contact for this channel.',
    'mautic.lead.event.donotcontact_unsubscribed' => 'Contact unsubscribed from this channel.',
    'mautic.lead.event.identified' => 'Contact identified',
    'mautic.lead.event.ipadded' => 'Accessed from IP',
    'mautic.lead.event.update' => 'Contact updated',
    'mautic.lead.event.utmtagsadded' => 'UTM tags recorded',
    'mautic.lead.field.indexable' => 'Indexable',
    'mautic.lead.field.tags' => 'Tags',
    'mautic.lead.field.timezone' => 'Preferred Timezone',
    'mautic.lead.field.address' => 'Address',
    'mautic.lead.field.utmcampaign' => 'Campaign',
    'mautic.lead.field.utmcontent' => 'Content',
    'mautic.lead.field.utmmedium' => 'Medium',
    'mautic.lead.field.umtsource' => 'Source',
    'mautic.lead.field.utmterm' => 'Term',
    'mautic.lead.event.api' => 'API',
    'mautic.lead.event.api.operation.not.allowed' => 'The requested operation is not permitted.',
    'mautic.lead.event.api.lead.not.found' => 'Contact could not be found.',
    'mautic.lead.event.api.point.group.not.found' => 'The specified point group was not found.',
    'mautic.lead.event.apiadded' => 'Added through API',
    'mautic.lead.field.form.choose' => 'Select a field',
    'mautic.lead.field.form.confirmbatchdelete' => 'Delete the selected custom fields? WARNING: this will also delete any values of these custom fields that are associated with contacts.',
    'mautic.lead.field.form.confirmdelete' => 'Delete the custom field, %name%? WARNING: this will also delete any values of this custom field that are associated with contacts.',
    'mautic.lead.field.form.group.help' => 'Determines where this field will be displayed when viewing a specific contact.',
    'mautic.lead.field.form.islistable' => 'Available for segments',
    'mautic.lead.field.form.isshortvisible' => 'Visible on quick add',
    'mautic.lead.field.form.isshortvisible.tooltip' => 'If set to yes, this field will be displayed in the quick add contact modal',
    'mautic.lead.field.form.isuniqueidentifer' => 'Is Unique Identifier',
    'mautic.lead.field.form.isuniqueidentifer.tooltip' => 'Set if this field will be the main way to differentiate contacts (i.e. email, username, social media handle, etc).',
    'mautic.lead.field.form.isuniqueidentifer.warning' => 'WARNING: Inappropriately setting &quot;Is Unique Identifier&quot; to Yes could cause a mass merging of contacts and incorrectly tracked contact activity. Only set to Yes if this field tracks a unique value specific to the contact such as email, username, etc.',
    'mautic.lead.field.form.isvisible' => 'Visible on forms',
    'mautic.lead.field.form.ispubliclyupdatable' => 'Publicly updatable',
    'mautic.lead.field.form.ispubliclyupdatable.tooltip' => 'If set to yes, this field can be updated by appending the field\'s alias and value to the query of the /mtracking.gif tracking pixel.',
    'mautic.lead.field.form.maximum.character.length' => 'Maximum character length',
    'mautic.lead.field.form.number.rounddown' => 'Round Down',
    'mautic.lead.field.form.number.roundhalfdown' => 'Round Half Down',
    'mautic.lead.field.form.number.roundhalfeven' => 'Round Half Even',
    'mautic.lead.field.form.number.roundhalfup' => 'Round Half Up',
    'mautic.lead.field.form.number.roundup' => 'Round Up',
    'mautic.lead.field.form.properties.boolean' => 'Boolean Labels',
    'mautic.lead.field.form.properties.lookup' => 'Lookup values',
    'mautic.lead.field.form.properties.numberprecision' => 'Precision',
    'mautic.lead.field.form.properties.numberrounding' => 'Rounding mode',
    'mautic.lead.field.form.properties.select' => 'Options',
    'mautic.lead.field.form.isIndex.tooltip' => 'Making this field indexable may improve search performance. %indexCount% indexes out of %maxCount% have been used.',
    'mautic.lead.field.indexable.yes' => 'Enable faster searches',
    'mautic.lead.field.indexable.no' => 'Standard search speed',
    'mautic.lead.field.searchcommand.isindexed' => 'is:indexed',
    'mautic.lead.field.searchcommand.isunique' => 'is:unique',
    'mautic.lead.field.searchcommand.type' => 'type',
    'mautic.lead.field.searchcommand.group' => 'group',
    'mautic.lead.lead.update.action.help' => 'Update the contact fields with values from this event.',
    'mautic.lead.company.update.action.help' => 'Update the company fields with values from this event.',
    'mautic.lead.field.group' => 'Group',
    'mautic.lead.field.group.core' => 'Core',
    'mautic.lead.field.group.company' => 'Company',
    'mautic.lead.field.group.extra' => 'Extra',
    'mautic.lead.field.group.personal' => 'Personal',
    'mautic.lead.field.group.professional' => 'Professional',
    'mautic.lead.field.group.social' => 'Social',
    'mautic.lead.field.group.no_data' => 'No data',
    'mautic.lead.field.header.contact' => 'Contact',
    'mautic.lead.field.header.edit' => 'Edit Custom Field - %name%',
    'mautic.lead.field.header.engagements' => 'Engagements',
    'mautic.lead.field.header.index' => 'Custom Fields',
    'mautic.lead.field.header.new' => 'New Custom Field',
    'mautic.lead.field.help.alias' => 'Letters and numbers (with no spaces) used to identify this field. A unique alias will be autogenerated if left empty.',
    'mautic.lead.field.help.lookup' => 'Also known as a typeahead. Leave blank to load unique existing values from the database or insert a specific segment. Separate options using a vertical bar ( | ). I.e. Red|Green|Blue',
    'mautic.lead.field.help.numberprecision' => 'Number of decimal allowed before rounding occurs.',
    'mautic.lead.field.help.numberrounding' => 'Round down - round towards zero.<br />Round up - round away from zero.<br />Round half down - round towards the nearest neighbor. If both are equidistant (equal distances), round down.<br />Round half even - round towards the nearest neighbor. If both are equidistant, round towards the even neighbor.<br />Round half up - round towards the nearest neighbor. If both are equidistant, round up.',
    'mautic.lead.field.help.select' => 'Insert the desired options using a vertical bar ( | ) to separate them. I.e. Red|Green|Blue',
    'mautic.lead.field.help.defaultvalue' => 'A default value will only apply to new contacts. It will not update existing contacts. On a custom field, it only applies to new contacts being added, not historical ones',
    'mautic.lead.field.menu.index' => 'Custom Fields',
    'mautic.lead.field.label' => 'Label',
    'mautic.lead.field.linkedin' => 'LinkedIn',
    'mautic.lead.field.tooltip.fixed' => 'Cannot be removed (used internally).',
    'mautic.lead.field.tooltip.invisible' => 'Does not show in contact forms.',
    'mautic.lead.field.tooltip.listable' => 'Can be used as a segment filter.',
    'mautic.lead.field.tooltip.required' => 'Is required when filling in contact forms.',
    'mautic.lead.field.tooltip.public' => 'Can be publicly updated via the query of the tracking pixel URL.',
    'mautic.lead.field.tooltip.isuniqueidentifer' => 'Is Unique Identifier',
    'mautic.lead.field.tooltip.isindex' => 'Is indexed and faster search results are provided',
    'mautic.lead.field.type' => 'Data Type',
    'mautic.lead.field.type.datetime' => 'Date/Time',
    'mautic.lead.field.type.locale' => 'Locale',
    'mautic.lead.field.type.html' => 'HTML',
    'mautic.lead.field.type.lookup' => 'Lookup',
    'mautic.lead.field.type.multiselect' => 'Select: Multiple choices',
    'mautic.lead.field.type.region' => 'Region',
    'mautic.lead.field.type.tel.home' => 'Phone - home',
    'mautic.lead.field.type.tel.mobile' => 'Phone - mobile',
    'mautic.lead.field.type.textarea' => 'Text: Paragraph',
    'mautic.lead.field.type.time' => 'Time',
    'mautic.lead.field.type.timezone' => 'Timezone',
    'mautic.lead.graph.line.leads' => 'New contacts added',
    'mautic.lead.graph.line.leads.emails' => 'New contacts with email address',
    'mautic.lead.graph.line.leads.leads' => 'All new contacts',
    'mautic.lead.graph.line.points' => 'Points',
    'mautic.lead.graph.line.all_engagements' => 'Engagements',
    'mautic.lead.graph.pie.attribution_campaigns' => 'Total attributions by campaigns',
    'mautic.lead.graph.pie.attribution_stages' => 'Total attributions by stages',
    'mautic.lead.graph.pie.attribution_actions' => 'Total attributions by actions',
    'mautic.lead.graph.pie.attribution_channels' => 'Total attributions by channels',
    'mautic.lead.grid.noresults.header' => 'No Contacts Found',
    'mautic.lead.grid.noresults.message' => 'Seems there are none, or you do not have the necessary permissions. If applicable, change a filter or contact your administrator.',
    'mautic.lead.import' => 'Import',
    'mautic.lead.import.batchlimit' => 'Limit',
    'mautic.lead.import.batchlimit_tooltip' => 'Sets the number of contacts to import per batch.',
    'mautic.lead.import.delimiter' => 'Delimiter',
    'mautic.lead.import.delimiter.help' => 'It’s the character that separates each piece of data in your file, often a comma (,).',
    'mautic.lead.import.enclosure' => 'Enclosure',
    'mautic.lead.import.enclosure.help' => 'It’s a character that holds each piece of data in your file, often a quote (&#x22;).',
    'mautic.lead.import.error.header_mismatch' => 'The number of data columns is more than the number of header columns (the first row)',
    'mautic.lead.import.error.line_empty' => 'No data found',
    'mautic.lead.import.escape' => 'Escape',
    'mautic.lead.import.escape.help' => 'It’s a character that lets you use special characters without confusing the system, often a backslash (\\).',
    'mautic.lead.import.file' => 'Upload CSV file',
    'mautic.lead.import.inprogress' => 'Import is in progress.',
    'mautic.lead.import.completed' => 'Import completed',
    'mautic.lead.import.result.info' => 'View details of %import%',
    'mautic.lead.import.ghost.limit.hit' => 'The import hasn\'t been updated in %limit% hours by the background job. It\'s considered failed.',
    'mautic.lead.import.default.owner' => '(Optional) Set the owner and the contact segment for the imported contacts.',
    'mautic.lead.import.donotleave' => 'Please do not leave this page until complete or queued.',
    'mautic.lead.import.mapped.fields' => 'Mapped fields',
    'mautic.lead.import.default.options' => 'Default options',
    'mautic.lead.import.csv.headers' => 'CSV headers',
    'mautic.lead.import.csv.parser.config' => 'CSV parser config',
    'mautic.lead.import.fields' => 'Match the columns from the imported file to Mautic\'s contact fields.',
    'mautic.lead.special_fields' => 'Properties',
    'mautic.lead.import.leads' => 'Import %object%',
    'mautic.lead.import.skip_if_exists' => 'Keep value if already exists',
    'mautic.lead.import.in.background' => 'Import in background',
    'mautic.lead.import.delayed' => 'Import has been delayed: %reason%',
    'mautic.lead.import.start' => 'Import in browser',
    'mautic.lead.import.start.instructions' => 'Upload the CSV file containing the contacts to import. A maximum of %size%MB can be uploaded. The next step will be to match the fields in the file with the fields available in Mautic.',
    'mautic.lead.import.label.stage' => 'Stage',
    'mautic.lead.import.label.ownerusername' => 'Owner by username',
    'mautic.lead.import.label.tags' => 'Tags',
    'mautic.lead.import.stats' => '%created% created, %merged% merged, %ignored% ignored',
    'mautic.lead.import.success' => 'Success!',
    'mautic.lead.import.upload' => 'Upload',
    'mautic.lead.import.event.name' => 'Contact Import',
    'mautic.lead.import.action.name' => 'By %name%',
    'mautic.lead.import.by.user' => 'Imported by %user%',
    'mautic.lead.import.label.id' => 'ID',
    'mautic.lead.import.label.createdByUser' => 'Created by user',
    'mautic.lead.import.label.dateAdded' => 'Date created',
    'mautic.lead.import.label.dateIdentified' => 'Identified date',
    'mautic.lead.import.label.dateModified' => 'Modified date',
    'mautic.lead.import.label.doNotEmail' => 'Do not contact',
    'mautic.lead.import.label.ip' => 'IP',
    'mautic.lead.import.label.lastActive' => 'Last active date',
    'mautic.lead.import.label.modifiedByUser' => 'Modified by user',
    'mautic.lead.import.label.points' => 'Points',
    'mautic.lead.import.is.starting' => 'Import %id% with %lines% rows is starting.',
    'mautic.lead.import.result' => '%lines% lines were processed, %created% items created, %updated% items updated, %ignored% items ignored in %time% s',
    'mautic.lead.import.failed' => 'Import failed. Reason: %reason%',
    'mautic.lead.background.import.if.more.rows.than' => 'Automatically import in the background if the CSV has more rows than defined',
    'mautic.lead.background.import.if.more.rows.than.tooltip' => 'If this option is greater than 0, there will be only one Import button and the browser/background import will be decided based on the CSV row number',
    'mautic.lead.background.export.csv' => 'Export contacts in the background in CSV',
    'mautic.lead.background.export.csv.tooltip' => 'If this is Yes, then contacts will exported in background for CSV only',
    'mautic.lead.behaviors' => 'Contact Behavior and Actions',
    'mautic.lead.groups' => 'Contact group points',
    'mautic.config.tab.leadconfig' => 'Contact Settings',
    'mautic.config.tab.companyconfig' => 'Company Settings',
    'mautic.config.tab.importconfig' => 'Import Settings',
    'mautic.config.tab.contact.list.settings' => 'Contact List Settings',
    'mautic.config.tab.exportconfig' => 'Export Settings',
    'mautic.config.tab.columns' => 'Columns',
    'mautic.config.tab.contact.merge.settings' => 'Contact Merge Settings',
    'mautic.config.tab.company.merge.settings' => 'Company Merge Settings',
    'mautic.core.config.unique_identifiers_operator' => 'Merge by unique fields with operator',
    'mautic.core.config.unique_identifiers_operator.tooltip' => 'If you use more than one unique field identifier then you can define the way of the find to merge it. ',
    'mautic.core.config.allow_multiple_companies' => 'Multiple companies for contact',
    'mautic.core.config.allow_multiple_companies.tooltip' => 'Enable assigning multiple companies to contact. No = contact can be assigned to only 1 company. Assigning a new company to that contact will replace the previously assigned company. Yes = contact can have multiple companies assigned. The latest assigned company is the primary company.',
    'mautic.core.config.contact_unique_identifiers_operator.or' => 'OR',
    'mautic.core.config.contact_unique_identifiers_operator.and' => 'AND',
    'mautic.config.tab.segment_config' => 'Segment Settings',
    'mautic.lead.import.unique_field_not_exist' => 'No unique fields exist in the import',
    'mautic.lead.import.database.exception' => 'There was a database error: %message%. The import was set to delayed state and will be imported later.',
    'mautic.lead.lastactive' => 'Last active',
    'mautic.lead.lead.anonymous' => 'Anonymous',
    'mautic.lead.lead.anonymous_leads' => 'Toggle anonymous contacts',
    'mautic.lead.lead.event.points' => 'Points (+/-)',
    'mautic.lead.lead.event.pointtrigger' => 'Minimum number of points',
    'mautic.lead.lead.event.grouppoints' => 'Points (%group%)',
    'mautic.lead.lead.events.addtolists' => 'Add contact to selected segment(s)',
    'mautic.lead.lead.events.addutmtags' => 'Record UTM Tags',
    'mautic.lead.lead.events.addutmtags_descr' => 'Universal Tags will be recorded on the contact\'s profile',
    'mautic.lead.lead.events.removedonotcontact' => 'Remove contact from do not contact list',
    'mautic.lead.lead.events.removedonotcontact_descr' => 'Contact will be re-subscribed',
    'mautic.lead.lead.events.changelist' => 'Modify contact\'s segments',
    'mautic.lead.lead.events.changelist_descr' => 'Add contact to or remove contact from segment(s)',
    'mautic.lead.lead.events.changepoints' => 'Adjust contact points',
    'mautic.lead.lead.events.changepoints_descr' => 'Increase or decrease points',
    'mautic.lead.lead.events.changestage' => 'Change contact\'s stage',
    'mautic.lead.lead.events.changestage_descr' => 'Change a contact\'s stage when the selected action occurs',
    'mautic.lead.lead.events.changetags' => 'Modify contact\'s tags',
    'mautic.lead.lead.events.changetags_descr' => 'Add tag to or remove tag from contact',
    'mautic.lead.lead.events.leadcreated' => 'contact created',
    'mautic.lead.lead.events.leadcreated_descr' => 'Trigger event upon a new contact being created',
    'mautic.lead.lead.events.listchange' => 'contact changed segments',
    'mautic.lead.lead.events.listchange_descr' => 'Trigger event upon a contact changing segments',
    'mautic.lead.lead.events.listtrigger.added' => 'Added to segment',
    'mautic.lead.lead.events.listtrigger.removed' => 'Removed from segment',
    'mautic.lead.lead.events.pointchange' => 'contact points changed',
    'mautic.lead.lead.events.pointchange_descr' => 'Trigger event upon a contact\'s point total being changed',
    'mautic.lead.lead.events.removefromlists' => 'Remove contact from selected segment(s)',
    'mautic.lead.lead.events.updatelead' => 'Update contact',
    'mautic.lead.lead.events.updatelead_descr' => 'Update the current contact\'s fields with the defined values from this action',
    'mautic.lead.lead.events.updatecompany' => 'Update contact\'s primary company',
    'mautic.lead.lead.events.updatecompany_descr' => 'Update the contact\'s primary company fields with the defined values from this action',
    'mautic.lead.lead.events.delete' => 'Delete contact',
    'mautic.lead.lead.events.delete_descr' => '<span class=\'text-danger\'>Permanently deletes the contact as well as all associated statistical data. <strong>Warning: this is irreversible!</strong></span>',
    'mautic.lead.lead.events.add_donotcontact' => 'Add Do Not Contact',
    'mautic.lead.lead.events.add_donotcontact_desc' => 'Add DoNotContact flag to the contact',
    'mautic.lead.lead.events.remove_donotcontact' => 'Remove Do Not Contact',
    'mautic.lead.lead.events.remove_donotcontact_desc' => 'Remove Do Not Contact flag from contact',
    'mautic.lead.lead.events.field_value' => 'Contact field value',
    'mautic.lead.lead.events.field_value_descr' => 'Condition based on a contact field value.',
    'mautic.lead.lead.events.device' => 'Contact device',
    'mautic.lead.lead.events.device_descr' => 'Condition based on a contact device.',
    'mautic.lead.lead.events.pageHit' => 'Visited page',
    'mautic.lead.lead.events.pageHit_descr' => 'Condition based on all the pages the contact has visited in the past',
    'mautic.lead.lead.events.tags' => 'Contact tags',
    'mautic.lead.lead.events.tags_descr' => 'Condition based on a contact tags.',
    'mautic.lead.lead.events.segments' => 'Contact segments',
    'mautic.lead.lead.events.segments_descr' => 'Condition based on a contact segments.',
    'mautic.lead.lead.events.stages' => 'Contact stages',
    'mautic.lead.lead.events.stages_descr' => 'Condition that the contact belongs to at least one of the selected stages.',
    'mautic.lead.lead.events.points' => 'Contact points',
    'mautic.lead.lead.events.points_descr' => 'Condition based on contact score',
    'mautic.lead.segment.dependencies' => 'Segment Dependencies',
    'mautic.lead.lead.events.campaigns' => 'Contact campaigns',
    'mautic.lead.lead.events.campaigns.membership' => 'Campaigns membership',
    'mautic.lead.lead.events.campaigns_descr' => 'Condition based on a contact campaigns.',
    'mautic.lead.lead.events.campaigns.date.added.filter' => 'Filter by date added to campaign',
    'mautic.lead.lead.events.campaigns.expression' => 'Expression',
    'mautic.lead.lead.events.campaigns.date' => 'Date',
    'mautic.lead.lead.events.owner' => 'Contact owner',
    'mautic.lead.lead.events.owner_descr' => 'Condition based on a contact owner.',
    'mautic.lead.lead.field.custom_avatar' => 'Custom',
    'mautic.lead.lead.events.condition_donotcontact' => 'Marked as DNC',
    'mautic.lead.lead.events.condition_donotcontact_descr' => 'Condition checks if the contact has the Do Not Contact flag.',
    'mautic.lead.lead.field.owner' => 'Contact owner',
    'mautic.lead.lead.field.list' => 'Contact Segment',
    'mautic.lead.lead.field.preferred_profile' => 'Preferred profile image',
    'mautic.lead.lead.filter.bundles.exclude.placeholder' => 'Exclude events by source',
    'mautic.lead.lead.filter.bundles.include.placeholder' => 'Include events by source',
    'mautic.lead.lead.form.confirmbatchdelete' => 'Delete the selected contacts?',
    'mautic.lead.lead.form.confirmdelete' => 'Delete this contact?',
    'mautic.lead.lead.form.leadlists' => 'filter by segment...',
    'mautic.lead.lead.header.campaigns' => 'Campaigns for %name%',
    'mautic.lead.lead.header.contact.frequency' => 'Contact Preference Center',
    'mautic.lead.lead.header.edit' => 'Edit %name%',
    'mautic.lead.lead.header.ipaddress' => 'IP Addresses',
    'mautic.lead.lead.header.lists' => 'Segments for %name%',
    'mautic.lead.lead.header.new' => 'New Contact',
    'mautic.lead.lead.header.pointslog' => 'Points Change Log',
    'mautic.lead.lead.header.quick.add' => 'Quick Add New Contact',
    'mautic.lead.lead.header.socialprofiles' => 'Social Profiles',
    'mautic.lead.lead.header.merge' => 'Merge %name%',
    'mautic.lead.lead.import' => 'Import',
    'mautic.lead.lead.stage' => 'Contact Stage',
    'mautic.lead.import.list' => 'Imports',
    'mautic.lead.import.source.file' => 'Source file',
    'mautic.lead.lead.import.index' => 'Import History',
    'mautic.lead.import.failed.rows' => 'Failed rows',
    'mautic.lead.import.no.failed.rows' => 'No failed rows found',
    'mautic.lead.import.csv.line.number' => 'CSV line number',
    'mautic.lead.import.status' => 'Status',
    'mautic.lead.import.status.info' => 'Status info',
    'mautic.lead.import.status.1' => 'Queued',
    'mautic.lead.import.status.2' => 'In Progress',
    'mautic.lead.import.status.3' => 'Imported',
    'mautic.lead.import.status.4' => 'Failed',
    'mautic.lead.import.status.5' => 'Stopped',
    'mautic.lead.import.status.6' => 'Manual',
    'mautic.lead.import.status.7' => 'Delayed',
    'mautic.lead.import.stage.not.exists' => 'Stage with ID or name %id% was not found.',
    'mautic.lead.import.parallel.limit.hit' => 'Import was delayed because the parallel import limit of %limit% has been hit.',
    'mautic.lead.view.imports' => 'View Imports',
    'mautic.lead.import.queue.btn' => 'Finish in the background',
    'mautic.lead.import.speed' => 'Import speed',
    'mautic.lead.import.speed.value' => '%speed% rows/second',
    'mautic.lead.import.line.count' => 'Total rows',
    'mautic.lead.import.inserted.count' => 'Inserted',
    'mautic.lead.import.updated.count' => 'Updated',
    'mautic.lead.import.ignored.count' => 'Ignored',
    'mautic.lead.import.progress' => 'Progress',
    'mautic.lead.import.runtime' => 'Runtime',
    'mautic.lead.import.date.started' => 'Import started on',
    'mautic.lead.import.date.ended' => 'Import ended on',
    'mautic.lead.import.contact.action.identified_contact' => 'Contact identified on import',
    'mautic.lead.import.contact.action.inserted' => 'Contact imported from %name%',
    'mautic.lead.import.contact.action.updated' => 'Contact updated from %name%',
    'mautic.lead.import.contact.action.failed' => 'Contact import failed from %name%',
    'mautic.lead.import.row.statuses' => 'Import row statuses',
    'mautic.lead.import.processed.rows.minute' => 'Rows processed per minute',
    'mautic.lead.import.processed.rows' => 'Processed rows',
    'mautic.lead.event.imported' => 'Imported',
    'mautic.lead.lead.lists' => 'Segments',
    'mautic.lead.lead.live_update' => 'Enable live mode where new contacts are automatically injected to the top of the segment as they are created.',
    'mautic.lead.lead.menu.index' => 'Manage Contacts',
    'mautic.lead.lead.menu.quickadd' => 'Quick Add',
    'mautic.lead.lead.pointscount' => 'Contact points',
    'mautic.lead.lead.pointsevent.created' => 'Contact manually created',
    'mautic.lead.lead.primary' => 'Primary',
    'mautic.lead.lead.remove.fromlist' => 'Remove from segment',
    'mautic.lead.lead.searchcommand.company' => 'company',
    'mautic.lead.lead.searchcommand.company_id' => 'company_id',
    'mautic.lead.lead.searchcommand.isanonymous' => 'is:anonymous',
    'mautic.lead.lead.searchcommand.isunowned' => 'is:unowned',
    'mautic.lead.lead.searchcommand.list' => 'segment',
    'mautic.lead.lead.searchcommand.owner' => 'owner',
    'mautic.lead.lead.searchcommand.stage' => 'stage',
    'mautic.lead.lead.searchcommand.tag' => 'tag',
    'mautic.lead.lead.searchcommand.duplicate' => 'common',
    'mautic.lead.lead.searchcommand.email_sent' => 'email_sent',
    'mautic.lead.lead.searchcommand.email_read' => 'email_read',
    'mautic.lead.lead.searchcommand.email_queued' => 'email_queued',
    'mautic.lead.lead.searchcommand.email_pending' => 'email_pending',
    'mautic.lead.lead.searchcommand.page_source' => 'page_source',
    'mautic.lead.lead.searchcommand.page_source_id' => 'page_source_id',
    'mautic.lead.lead.searchcommand.import_id' => 'import_id',
    'mautic.lead.lead.searchcommand.import_action' => 'import_action',
    'mautic.lead.lead.searchcommand.page_id' => 'page_id',
    'mautic.lead.lead.searchcommand.mobile_sent' => 'mobile_sent',
    'mautic.lead.lead.searchcommand.web_sent' => 'web_sent',
    'mautic.lead.lead.searchcommand.sms_sent' => 'sms_sent',
    'mautic.lead.lead.social.foursquare.lists' => 'Segments',
    'mautic.lead.lead.social.foursquare.mayorship' => 'Mayorships',
    'mautic.lead.lead.social.foursquare.tips' => 'Tips',
    'mautic.lead.lead.social.lastupdate' => 'Last refreshed at %datetime%',
    'mautic.lead.lead.social.photos' => 'Photos',
    'mautic.lead.lead.social.posts' => 'Posts',
    'mautic.lead.lead.social.profile' => 'Profile',
    'mautic.lead.lead.social.removecache' => 'Remove this network\'s data for the contact.',
    'mautic.lead.lead.social.tags' => 'Tags',
    'mautic.lead.lead.social.twitter.tweets' => 'Tweets',
    'mautic.lead.lead.submitaction' => 'Contact actions',
    'mautic.lead.lead.submitaction.changepoints' => 'Adjust contact\'s points',
    'mautic.lead.lead.submitaction.changepoints_descr' => 'Change points based on form results.',
    'mautic.lead.lead.submitaction.operator' => 'Operator',
    'mautic.lead.lead.submitaction.operator_divide' => 'divide (/)',
    'mautic.lead.lead.submitaction.operator_minus' => 'subtract (-)',
    'mautic.lead.lead.submitaction.operator_plus' => 'add (+)',
    'mautic.lead.lead.submitaction.operator_times' => 'multiply (x)',
    'mautic.lead.lead.submitaction.operator_set' => 'set',
    'mautic.lead.lead.submitaction.points' => 'Amount to change points by',
    'mautic.lead.lead.tab.history' => 'History',
    'mautic.lead.lead.tab.notes' => 'Notes',
    'mautic.lead.lead.tab.social' => 'Social',
    'mautic.lead.lead.tab.integration' => 'Integrations',
    'mautic.lead.lead.tab.auditlog' => 'Audit log',
    'mautic.lead.lead.tab.socialactivity' => 'Public Activity',
    'mautic.lead.lead.tab.socialprofile' => 'Public Profile',
    'mautic.lead.lead.tab.places' => 'Places',
    'mautic.lead.lead.thead.action' => 'Triggering Action',
    'mautic.lead.lead.thead.city' => 'City',
    'mautic.lead.lead.thead.country' => 'Country',
    'mautic.lead.lead.thead.delta' => 'Points &Delta;',
    'mautic.lead.lead.thead.event' => 'Triggering Event',
    'mautic.lead.lead.thead.location' => 'Location',
    'mautic.lead.lead.thead.state' => 'State',
    'mautic.lead.lead.timeline' => 'Timeline',
    'mautic.lead.lead.upcoming.event.triggered.at' => '<strong class=\'text-primary\'>%event%</strong> event will be triggered at %link%',
    'mautic.lead.lead.upcoming.events' => 'Upcoming Events',
    'mautic.keyboard.section.contacts' => 'Contacts',
    'mautic.lead.leads' => 'Contacts',
    'mautic.lead.lifecycle.graph.device.granularity' => 'Devices',
    'mautic.lead.lifecycle.graph.pie.all.lists' => 'All Contacts',
    'mautic.lead.lifecycle.graph.stage.cycle' => 'Stage cycle',
    'mautic.lead.list.rebuild.total.time' => 'Total time: %time% seconds',
    'mautic.lead.list.rebuild.contacts.time' => 'Rebuilding contacts time: %time% seconds',
    'mautic.lead.list.rebuild.leads_affected' => '%leads% contact(s) affected',
    'mautic.lead.list.rebuild.rebuilding' => 'Rebuilding contacts for segment %id%',
    'mautic.lead.list.rebuild.not_found' => 'Segment #%id% does not exist',
    'mautic.lead.list.rebuild.to_be_added' => '%leads% total contact(s) to be added in batches of %batch%',
    'mautic.lead.list.rebuild.to_be_removed' => '%leads% total contact(s) to be removed in batches of %batch%',
    'mautic.lead.list.filter.date_identified' => 'Date Identified',
    'mautic.lead.list.filter.dnc_bounced' => 'Bounced - Email',
    'mautic.lead.list.filter.dnc_unsubscribed' => 'Unsubscribed - Email',
    'mautic.lead.list.filter.dnc_manual_email' => 'Unsubscribed Manual - Email',
    'mautic.lead.list.filter.dnc_manual_sms' => 'Unsubscribed Manual - SMS',
    'mautic.lead.list.filter.last_active' => 'Date Last Active',
    'mautic.lead.list.filter.campaign' => 'Campaign Membership',
    'mautic.lead.list.filter.date_modified' => 'Modified Date',
    'mautic.lead.list.filter.lists' => 'Segment Membership',
    'mautic.lead.list.filter.lead_asset_download' => 'Downloaded a specific asset',
    'mautic.lead.list.filter.lead_email_received' => 'Read a specific email',
    'mautic.lead.list.filter.lead_email_sent' => 'Was sent a specific email',
    'mautic.lead.list.filter.lead_email_sent_date' => 'Sent any email (date)',
    'mautic.lead.list.filter.lead_email_read_date' => 'Read any email (date)',
    'mautic.lead.list.filter.lead_email_read_count' => 'Read any email X number of times',
    'mautic.lead.list.filter.visited_url' => 'Visited X URL',
    'mautic.lead.list.filter.visited_url_count' => 'Visited any URL X number of times ',
    'mautic.lead.list.filter.url_title' => 'Visited any URL with X page title',
    'mautic.lead.list.filter.source' => 'Visited any URL from X source',
    'mautic.lead.list.filter.source.id' => 'Visited any URL from X source ID ',
    'mautic.lead.list.filter.session' => 'Has X number of browsing sessions',
    'mautic.lead.list.filter.page_id' => 'Visited a specific landing page',
    'mautic.lead.list.filter.placeholder' => 'Segment Category Filter',
    'mautic.lead.list.filter.referer' => 'Visited any URL from X referrer',
    'mautic.lead.list.filter.visited_url_date' => 'Visited any URL (date)',
    'mautic.lead.list.source.segment.category' => 'Segment Category',
    'mautic.lead.list.filter.notification' => 'Has been sent any push notification',
    'mautic.lead.list.filter.owner' => 'Owner',
    'mautic.lead.list.filter.tags' => 'Tags',
    'mautic.lead.list.filter.device_type' => 'Device Type',
    'mautic.lead.list.filter.device_brand' => 'Device Brand',
    'mautic.lead.list.filter.device_os' => 'Device OS',
    'mautic.lead.list.filter.device_model' => 'Device Model',
    'mautic.lead.list.filter.redirect_id' => 'Clicked any link from any channel',
    'mautic.lead.list.filter.email_id' => 'Clicked any link from any email',
    'mautic.lead.list.filter.email_clicked_link_date' => 'Clicked any link from any email (date)',
    'mautic.lead.list.filter.sms_clicked_link' => 'Clicked any link from any text message',
    'mautic.lead.list.filter.sms_clicked_link_date' => 'Clicked any link from any text message (date)',
    'mautic.lead.list.form.config.segment_rebuild_time.message' => 'This segment hasn\'t been rebuilt for 1 hour.|This segment hasn\'t been rebuilt for %count% hours.',
    'mautic.lead.list.form.config.segment_rebuild_time_warning' => 'Show warning if segment hasn\'t been rebuilt for X hours',
    'mautic.lead.list.form.config.segment_rebuild_time_warning.tooltip' => 'A red exclamation sign will be displayed next to a segment name',
    'mautic.lead.list.form.config.segment_build_time.message' => 'This segment build time is %count% seconds.',
    'mautic.lead.list.form.config.segment_build_time_warning' => 'Show warning if segment build time is longer than X seconds',
    'mautic.lead.list.form.config.segment_build_time_warning.tooltip' => 'A red clock icon will be displayed next to a segment name',
    'mautic.lead.list.form.confirmbatchdelete' => 'Delete the selected segments?',
    'mautic.lead.list.form.confirmdelete' => 'Delete the segment, %name%?',
    'mautic.lead.list.form.filters.add' => 'Add Filter',
    'mautic.lead.list.form.filtervalue' => 'filter value',
    'mautic.lead.list.form.glue.and' => 'and',
    'mautic.lead.list.form.glue.or' => 'or',
    'mautic.lead.list.form.isglobal' => 'Visible to other users',
    'mautic.lead.list.form.isglobal.tooltip' => 'Only users within Mautic will be able to see this segment. When disabled, this segment is only available to you.',
    'mautic.lead.list.form.isglobal.no' => 'Only me',
    'mautic.lead.list.form.publicname' => 'Public name',
    'mautic.lead.list.form.publicname.tooltip' => 'Name visible in Preference Center',
    'mautic.lead.list.form.isPreferenceCenter' => 'Available in Preference Center',
    'mautic.lead.list.form.isPreferenceCenter.tooltip' => 'Segment can be editable by contact in preferences center.',
    'mautic.lead.list.form.operator.between' => 'between',
    'mautic.lead.list.form.operator.equals' => 'equals',
    'mautic.lead.list.form.operator.greaterthan' => 'greater than',
    'mautic.lead.list.form.operator.greaterthanequals' => 'greater than or equal',
    'mautic.lead.list.form.operator.in' => 'including',
    'mautic.lead.list.form.operator.isempty' => 'empty',
    'mautic.lead.list.form.operator.islike' => 'like',
    'mautic.lead.list.form.operator.isnotempty' => 'not empty',
    'mautic.lead.list.form.operator.regexp' => 'regexp',
    'mautic.lead.list.form.operator.notregexp' => 'not regexp',
    'mautic.lead.list.form.operator.isnotlike' => 'not like',
    'mautic.lead.list.form.operator.lessthan' => 'less than',
    'mautic.lead.list.form.operator.lessthanequals' => 'less than or equal',
    'mautic.lead.list.form.operator.notbetween' => 'not between',
    'mautic.lead.list.form.operator.notequals' => 'not equal',
    'mautic.lead.list.form.operator.notin' => 'excluding',
    'mautic.lead.list.form.startTyping' => 'start typing',
    'mautic.lead.list.frequency.number' => 'Do not contact more than',
    'mautic.lead.list.form.operator.date' => 'date',
    'mautic.lead.list.frequency.rules.msg' => 'Frequency Rules have changed',
    'mautic.lead.list.frequency.times' => 'messages each',
    'mautic.lead.list.header.edit' => 'Edit Segment - %name%',
    'mautic.lead.list.header.index' => 'Contact Segments',
    'mautic.lead.list.header.new' => 'New Segment',
    'mautic.lead.list.help.alias' => 'Letters and numbers (with no spaces) used to identify this segment',
    'mautic.lead.list.menu.index' => 'Segments',
    'mautic.lead.list.searchcommand.isglobal' => 'is:global',
    'mautic.lead.list.thead.leadcount' => '# contacts',
    'mautic.lead.list.view' => 'View %objects%',
    'mautic.lead.list.view_contacts' => 'View Contacts',
    'mautic.lead.list.view_companies' => 'View Companies',
    'mautic.lead.list.viewleads_count' => '{0} No Contacts|{1} View 1 Contact|]1,Inf[ View %count% Contacts',
    'mautic.lead.list.month_last' => 'last month',
    'mautic.lead.list.month_next' => 'next month',
    'mautic.plugin.actions.tooltip' => 'Push a contact to the selected integration.',
    'mautic.lead.list.month_this' => 'this month',
    'mautic.lead.list.today' => 'today',
    'mautic.lead.list.tomorrow' => 'tomorrow',
    'mautic.lead.list.yesterday' => 'yesterday',
    'mautic.lead.list.week_last' => 'last week',
    'mautic.lead.list.week_next' => 'next week',
    'mautic.lead.list.week_this' => 'this week',
    'mautic.lead.list.year_last' => 'last year',
    'mautic.lead.list.year_next' => 'next year',
    'mautic.lead.list.year_this' => 'this year',
    'mautic.lead.list.anniversary' => 'anniversary',
    'mautic.lead.list.checkall.help' => 'If you select multiple contacts at once, a green drop-down arrow will appear at the top of the list. You can manage bulk actions from this drop-down list (ex. Change segments or Set Do Not Contact).',
    'mautic.lead.list.copy.filter.group' => 'The entire filter block will be duplicated',
    'mautic.lead.merge' => 'Merge',
    'mautic.lead.merge.count' => '%count% contacts were merged.',
    'mautic.lead.merge.select' => 'Choose the contact to merge with:',
    'mautic.lead.merge.select.tooltip' => 'Choose the contact to merge with.',
    'mautic.lead.merge.select.modal.tooltip' => 'Filter the options using the search field, then select the lead to merge.',
    'mautic.lead.note.confirmdelete' => 'Delete this note?',
    'mautic.lead.note.details' => 'At %dateAdded%, %author% wrote:',
    'mautic.lead.note.event' => 'Note at %lead%',
    'mautic.lead.note.form.text' => 'Note text',
    'mautic.lead.note.form.type' => 'Note Type',
    'mautic.lead.note.header.edit' => 'Edit note',
    'mautic.lead.note.header.new' => 'New note',
    'mautic.lead.note.notes' => 'Contact Notes',
    'mautic.lead.note.searchcommand.call' => 'call',
    'mautic.lead.note.searchcommand.email' => 'email',
    'mautic.lead.note.searchcommand.general' => 'general',
    'mautic.lead.note.searchcommand.meeting' => 'meeting',
    'mautic.lead.note.searchcommand.type' => 'type',
    'mautic.lead.note.type.call' => 'Call',
    'mautic.lead.note.type.email' => 'Email',
    'mautic.lead.note.type.general' => 'General',
    'mautic.lead.note.type.meeting' => 'Meeting',
    'mautic.lead.permissions.fields' => 'Custom Fields - User has access to',
    'mautic.lead.permissions.header' => 'Contact Permissions',
    'mautic.lead.permissions.leads' => 'Contacts - User has access to',
    'mautic.lead.permissions.lists' => 'Segments - User has access to',
    'mautic.lead.permissions.imports' => 'Import - User has access to',
    'mautic.lead.point.trigger' => 'Contact triggers',
    'mautic.lead.point.trigger.changelists' => 'Modify contact\'s segments',
    'mautic.lead.points' => 'Points',
    'mautic.lead.points.count' => '{0}0 points|{1}1 point|]1,Inf[%count% points|{-1}-1 point|]-Inf,-1[%count% points',
    'mautic.lead.groups.panel.title' => 'Group points',
    'mautic.lead.remove_dnc_status' => 'Re-enable contact',
    'mautic.lead.report.attribution.multi' => 'Multi Touch Attributions',
    'mautic.lead.report.attribution.first' => 'First Touch Attributions',
    'mautic.lead.report.attribution.last' => 'Last Touch Attributions',
    'mautic.lead.report.attribution.campaign_id' => 'Campaign ID',
    'mautic.lead.report.attribution.campaign_name' => 'Campaign Name',
    'mautic.lead.report.attribution.channel' => 'Channel',
    'mautic.lead.report.attribution.channel_action' => 'Channel Action Type',
    'mautic.lead.report.attribution.action_name' => 'Channel Action Name',
    'mautic.lead.report.attribution.action_date' => 'Channel Action Date',
    'mautic.lead.report.attribution.filter.stage' => 'Contact Stage',
    'mautic.lead.report.attribution.filter.campaign' => 'Campaign',
    'mautic.lead.report.attribution.stage_id' => 'Stage ID',
    'mautic.lead.report.attribution.stage_name' => 'Stage Name',
    'mautic.lead.report.attribution.stage_date_added' => 'Stage Date Added',
    'mautic.lead.report.contact_id' => 'Contact ID',
    'mautic.lead.report.field.lead.label' => 'Contact %field%',
    'mautic.lead.report.date_identified' => 'Date identified',
    'mautic.lead.report.owner_firstname' => 'Owner first name',
    'mautic.lead.report.owner_id' => 'Owner ID',
    'mautic.lead.report.owner_lastname' => 'Owner last name',
    'mautic.lead.report.points.action_name' => 'Point event action',
    'mautic.lead.report.points.date_added' => 'Point change date',
    'mautic.lead.report.points.delta' => 'Point change',
    'mautic.lead.report.points.event_name' => 'Point event name',
    'mautic.lead.report.points.table' => 'Contact Point Log',
    'mautic.lead.report.points.type' => 'Point event type',
    'mautic.lead.report.points.id' => 'Point ID',
    'mautic.lead.report.points.group_id' => 'Group ID',
    'mautic.lead.report.points.group_name' => 'Group name',
    'mautic.lead.report.segment.id' => 'Segment ID',
    'mautic.lead.report.segment.membership' => 'Segment Membership',
    'mautic.lead.report.segment.log' => 'Contact\'s segments activity log',
    'mautic.lead.report.segment.manually_added' => 'Manually added',
    'mautic.lead.report.segment.manually_removed' => 'Manually removed',
    'mautic.lead.report.segment.date_added' => 'Date added to segment',
    'mautic.lead.report.segment.date_removed' => 'Date removed from segment',
    'mautic.lead.report.utm.utm_tag' => 'UTM codes',
    'mautic.lead.report.utm.campaign' => 'UTM campaign',
    'mautic.lead.report.utm.content' => 'UTM content',
    'mautic.lead.report.utm.medium' => 'UTM medium',
    'mautic.lead.report.utm.source' => 'UTM source',
    'mautic.lead.report.utm.term' => 'UTM term',
    'mautic.lead.report.dnc' => 'Do Not Contact',
    'mautic.lead.report.dnc_comment' => 'DNC Comment',
    'mautic.lead.report.dnc_contactable' => 'Contactable',
    'mautic.lead.report.dnc_unsubscribed' => 'DNC Unsubscribed',
    'mautic.lead.report.dnc_bounced' => 'DNC Bounced',
    'mautic.lead.report.dnc_manual' => 'DNC Manually Unsubscribed',
    'mautic.lead.report.dnc_reason' => 'DNC Reason',
    'mautic.lead.report.dnc_channel' => 'DNC Channel',
    'mautic.lead.report.dnc_channel_id' => 'DNC Channel ID',
    'mautic.lead.report.dnc_date_added' => 'DNC Date',
    'mautic.lead.report.devices' => 'Devices',
    'mautic.lead.report.dev_date_added' => 'Device date added',
    'mautic.lead.report.dev_client_info' => 'Device client info',
    'mautic.lead.report.dev_device' => 'Device type',
    'mautic.lead.report.dev_device_os_name' => 'Device OS name',
    'mautic.lead.report.dev_device_os_version' => 'Device OS version',
    'mautic.lead.report.dev_device_os_platform' => 'Device OS platform ',
    'mautic.lead.report.dev_device_brand' => 'Device brand',
    'mautic.lead.report.dev_device_model' => 'Device model',
    'mautic.lead.integrations.header' => 'No integration relationships found. They will be displayed automatically here when users are modified by plugins.',
    'mautic.lead.socialprofiles.header' => 'We’re still on the lookout. Remember to set up your social networks in the Integration Manager.',
    'mautic.lead.auditlog.header' => 'No audit log entries found',
    'mautic.lead.socialprofiles.noresults' => 'Search again',
    'mautic.lead.stage' => 'On stage: %stage%',
    'mautic.lead.stage.label' => 'Stage',
    'mautic.lead.table.most.points' => 'Contacts with most points',
    'mautic.lead.table.top.actions' => 'Top Actions',
    'mautic.lead.table.top.cities' => 'Top Cities',
    'mautic.lead.table.top.countries' => 'Top Countries',
    'mautic.lead.table.top.events' => 'Top Events',
    'mautic.lead.tags' => 'Tags',
    'mautic.lead.tags.add' => 'Add tags',
    'mautic.lead.tags.enter_to_create' => 'Hit enter to create ',
    'mautic.lead.tags.remove' => 'Remove tags',
    'mautic.lead.tags.select_or_create' => 'Select or type in a new tag',
    'mautic.lead.timeline.campaign_membership' => 'Campaign membership change',
    'mautic.lead.timeline.campaign_membership_added_by_object' => 'Contact added to campaign, %name%',
    'mautic.lead.timeline.campaign_membership_removed_by_object' => 'Contact removed from campaign, %name%',
    'mautic.lead.timeline.created_source' => 'Contact created by source',
    'mautic.lead.timeline.displaying_events' => 'Displaying %total% events',
    'mautic.lead.timeline.events_new' => 'new',
    'mautic.lead.timeline.user_name' => 'User/Source Name',
    'mautic.lead.timeline.event_name' => 'Event Name',
    'mautic.lead.timeline.event_type' => 'Event Type',
    'mautic.lead.timeline.event_timestamp' => 'Event Timestamp',
    'mautic.lead.timeline.event.utmcampaign' => 'UTM Campaign',
    'mautic.lead.timeline.event.utmcontent' => 'UTM Content',
    'mautic.lead.timeline.event.utmmedium' => 'UTM Medium',
    'mautic.lead.timeline.event.umtsource' => 'UTM Source',
    'mautic.lead.timeline.event.utmtags' => 'UTM Tags',
    'mautic.lead.timeline.event.utmterm' => 'UTM Term',
    'mautic.lead.timeline.identified_source' => 'Contact identified by source',
    'mautic.lead.timeline.lead.source.created' => 'Contact was created by an unknown source (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.created_by_object' => 'Contact was created by %name%',
    'mautic.lead.timeline.lead.source.identified' => 'Contact was identified by an unknown source (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.identified_by_object' => 'Contact was identified by %name%',
    'mautic.lead.timeline.segment_membership' => 'Segment membership change',
    'mautic.lead.timeline.segment_membership_added_by_object' => 'Contact added to segment, %name%',
    'mautic.lead.timeline.segment_membership_removed_by_object' => 'Contact removed from segment, %name%',
    'mautic.lead.timeline.toggle_all_details' => 'Toggle all event details.',
    'mautic.lead.timeline.toggle_details' => 'Toggle details.',
    'mautic.lead.tooltip.grid' => 'Grid view',
    'mautic.lead.dashboard.widgets' => 'Contact Widgets',
    'mautic.widget.created.leads.in.time' => 'Created contacts in time',
    'mautic.widget.device.granularity' => 'Device granularity',
    'mautic.widget.anonymous.vs.identified.leads' => 'Anonymous vs identified contacts',
    'mautic.widget.map.of.leads' => 'Map',
    'mautic.widget.lead.lifetime' => 'Lifecycle',
    'mautic.lead.list.filter' => 'Segment Filter',
    'mautic.widget.top.lists' => 'Top segments',
    'mautic.lead.show.all' => 'Show all contacts',
    'mautic.lead.show.top' => 'Top segments',
    'mautic.lead.show.identified.vs.anonymous' => 'All Identified vs Anonymous',
    'mautic.lead.show.top.leads.identified.vs.anonymous' => 'Top Segments with Identified vs Anonymous',
    'mautic.widget.top.owners' => 'Top contact owners',
    'mautic.widget.top.creators' => 'Top contact creators',
    'mautic.widget.segments.build.time' => 'Segments build time',
    'mautic.widget.segments.build.time.longest' => 'Longest time',
    'mautic.widget.segments.build.time.shortest' => 'Shortest time',
    'mautic.widget.created.leads' => 'Created contacts',
    'mautic.lead.show.identified' => 'Only identified',
    'mautic.lead.show.anonymous' => 'Only anonymous',
    'mautic.lead.all.leads' => 'All contacts',
    'mautic.lead.identified' => 'Identified',
    'mautic.lead.tooltip.list' => 'List view',
    'mautic.lead.webhook.event.lead.deleted' => 'Contact Deleted Event',
    'mautic.lead.webhook.event.lead.deleted_desc' => 'Triggered when a contact is deleted.',
    'mautic.lead.webhook.event.lead.new' => 'Contact Identified Event',
    'mautic.lead.webhook.event.lead.new_desc' => 'Triggered when a contact is identified.',
    'mautic.lead.webhook.event.lead.points' => 'Contact Points Changed Event',
    'mautic.lead.webhook.event.lead.points_desc' => 'Triggered when a contact\'s points are modified.',
    'mautic.lead.webhook.event.lead.update' => 'Contact Updated Event',
    'mautic.lead.webhook.event.lead.update_desc' => 'Triggered when a contact is updated.',
    'mautic.lead.webhook.event.lead.dnc' => 'Contact Channel Subscription Change Event',
    'mautic.lead.webhook.event.lead.dnc_desc' => 'Triggered when a contact\'s channel subscription status changes.',
    'mautic.lead.webhook.event.lead.company.change' => 'Contact Company Subscription Change Event',
    'mautic.lead.webhook.event.lead.company.change.desc' => 'Triggered when a company is added or removed to/from contact',
    'mautic.lead.webhook.event.company.new_or_update' => 'Company Create/Update Event',
    'mautic.lead.webhook.event.company.new_or_update_desc' => 'Triggered when a company is created/updated',
    'mautic.lead.webhook.event.company.deleted' => 'Company Deleted Event',
    'mautic.lead.webhook.event.company.deleted_desc' => 'Triggered when a company is deleted',
    'mautic.lead.webhook.event.lead.segment.change' => 'Contact Segment Membership Change Event',
    'mautic.lead.webhook.event.lead.segment.change.desc' => 'Triggered when a contact segment membership is changed',
    'mautic.lead.campaign.event.field' => 'Contact Field',
    'mautic.lead.campaign.event.field_descr' => 'Select the contact field which holds the value you want to compare.',
    'mautic.lead.campaign.event.device_type' => 'Device type',
    'mautic.lead.campaign.event.device_brand' => 'Device brand',
    'mautic.lead.campaign.event.device_os' => 'Device OS',
    'mautic.lead.campaign.event.point_operator' => 'Operator',
    'mautic.lead.campaign.event.point_score' => 'Score',
    'mautic.lead.campaign.event.point_group' => 'Point group',
    'mautic.lead.campaign.event.point_group.help' => 'Leave empty to use main score',
    'mautic.maintenance.visitors' => 'Visitors',
    'mautic.report.group.contacts' => 'Contacts',
    'mautic.report.field.company.label' => 'Company %field%',
    'mautic.lead.exists.by.field' => 'A contact with this value already exists',
    'mautic.lead.field.object' => 'Object',
    'mautic.companies.menu.index' => 'Companies',
    'mautic.companies.menu.root' => 'Companies',
    'mautic.company.action.noresults.tip' => 'Create a company to group contacts that belong to a same company. It will also help you keep important information about different companies you target.',
    'mautic.company.menu.new' => 'New Company',
    'mautic.company.menu.edit' => 'Edit Company %name%',
    'mautic.company.name' => 'Company name',
    'mautic.company.company.number' => 'Company number',
    'mautic.company.company.source' => 'Company source',
    'mautic.company.annual.revenue' => 'Annual revenue',
    'mautic.company.email' => 'Company email',
    'mautic.company.website' => 'Company website',
    'mautic.company.phone' => 'Company phone',
    'mautic.company.fax' => 'Company fax',
    'mautic.company.numberOfEmployees' => 'Number of employees',
    'mautic.company.score' => 'Score',
    'mautic.company.score.count' => '{0}0 score|{1}1 score|]1,Inf[%count% score|{-1}-1 point|]-Inf,-1[%count% score',
    'mautic.company.address1' => 'Address line 1',
    'mautic.company.address2' => 'Address line 2',
    'mautic.company.city' => 'City',
    'mautic.company.state' => 'State',
    'mautic.company.country' => 'Country',
    'mautic.company.zipcode' => 'Zip Code',
    'mautic.company.company' => 'Company',
    'mautic.lead.company.viewleads_count' => 'view contacts %count%',
    'mautic.lead.lead.companies' => 'Companies',
    'mautic.lead.lead.segment.add.help' => 'If you upload a CSV contact file to a segment, it will become a static list. Applying additional filters to this segment will not remove any contacts from that uploaded list.',
    'mautic.lead.lead.segment.filter.info' => 'Contacts that match the filters will be added, and contacts that no longer match will be removed. Those manually added will remain untouched.',
    'mautic.lead.lead' => 'Contact',
    'mautic.lead.company' => 'Primary company',
    'mautic.lead.lead.header.companies' => 'Add contact to companies',
    'mautic.lead.lead.events.addtocompany' => 'Add to company action',
    'mautic.lead.lead.events.addtocompany_descr' => 'This action will add contacts to the selected company',
    'mautic.lead.lead.events.changeowner' => 'Update contact owner',
    'mautic.lead.lead.events.changeowner_descr' => 'This action will update contact owner as part of a campaign',
    'mautic.company.selectcompany' => 'Select a company',
    'mautic.company.selectcompany_descr' => 'Contacts targeted in this campaign will be added to the selected company',
    'mautic.company.new.company' => 'New Company',
    'mautic.company.field.address' => 'Company Address',
    'mautic.company.form.confirmdelete' => 'Delete this company?',
    'mautic.company.form.confirmbatchdelete' => 'Delete these companies?',
    'mautic.lead.field.companyemail' => 'Company Email',
    'mautic.lead.field.companyname' => 'Company Name',
    'mautic.lead.field.companyaddress1' => 'Address 1',
    'mautic.lead.field.companyaddress2' => 'Address 2',
    'mautic.lead.field.companycity' => 'City',
    'mautic.lead.field.companystate' => 'State',
    'mautic.lead.field.companycountry' => 'Country',
    'mautic.lead.field.companyzipcode' => 'Zip Code',
    'mautic.lead.field.companyindustry' => 'Industry',
    'mautic.lead.field.companyphone' => 'Phone',
    'mautic.lead.field.companydescription' => 'Description',
    'mautic.lead.field.companywebsite' => 'Website',
    'mautic.lead.field.companynumber_of_employees' => 'Number of Employees',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Annual Revenue',
    'mautic.lead.company.field.owner' => 'Company Owner',
    'mautic.lead.preferred.channels' => 'Preferred',
    'mautic.lead.preferred.categories' => 'Categories',
    'mautic.lead.preferred.segments' => 'Segments',
    'mautic.lead.preferred.campaigns' => 'Campaigns',
    'mautic.lead.list.frequency.preferred.channel' => 'I prefer communication by',
    'mautic.lead.list.last_built_time' => 'Last built time',
    'mautic.lead.form.list' => 'My segments',
    'mautic.lead.frequency.contact.start.date' => 'From',
    'mautic.lead.frequency.contact.end.date' => 'to',
    'mautic.lead.frequency.dates.label' => 'Pause from',
    'mautic.lead.contact.me.label' => 'I want to receive %channel%',
    'mautic.lead.form.categories' => 'My categories',
    'mautic.lead.preferred.frequency' => 'Frequency',
    'mautic.lead.company.set.primary' => 'Click to (un)set as primary',
    'mautic.lead.graph.line.companies' => 'Companies in time',
    'mautic.lead.all.companies' => 'All companies',
    'mautic.lead.graph.pie.companies.industry' => 'Companies by Industry',
    'mautic.lead.table.pie.company.country' => 'Companies by Country',
    'mautic.lead.company.table.top.cities' => 'Companies by City',
    'mautic.report.group.companies' => 'Companies',
    'mautic.lead.report.company.company_id' => 'Company ID',
    'mautic.lead.report.company.is_primary' => 'Is the primary company',
    'mautic.lead.report.company.date_added' => 'Date added to company',
    'mautic.lead.company.header.merge' => 'Merging current company',
    'mautic.company.to.merge.into' => 'Choose a company to merge into',
    'mautic.lead.lead.events.changecompanyscore' => 'Add to company\'s score',
    'mautic.lead.lead.events.changecompanyscore_descr' => 'This action will add the specified value to the company\'s existing score',
    'mautic.lead.timeline.displaying_events_for_contact' => 'for contact: %contact% (%id%)',
    'mautic.lead.list.filter.categories' => 'Subscribed Categories',
    'mautic.lead.list.filter.utmcampaign' => 'UTM Campaign',
    'mautic.lead.list.filter.utmcontent' => 'UTM Content',
    'mautic.lead.list.filter.utmmedium' => 'UTM Medium',
    'mautic.lead.list.filter.utmsource' => 'UTM Source',
    'mautic.lead.list.filter.utmterm' => 'UTM Term',
    'mautic.lead.audit.created' => 'The contact was created.',
    'mautic.lead.audit.deleted' => 'The contact was deleted.',
    'mautic.lead.audit.updated' => 'The contact was updated.',
    'mautic.lead.audit.identified' => 'The contact was identified.',
    'mautic.lead.audit.merged' => 'The contact was merged.',
    'mautic.lead.audit.originip' => 'Origin IP:',
    'mautic.lead.audit.accessed' => 'The contact was accessed from: ',
    'mautic.lead.audit.log.field' => 'Field/Object',
    'mautic.lead.audit.log.new_value' => 'New Value',
    'mautic.lead.audit.log.old_value' => 'Old Value',
    'mautic.lead.report.frequency.messages' => 'Frequency Rules',
    'mautic.lead.report.frequency.frequency_number' => 'Frequency',
    'mautic.lead.report.frequency.frequency_time' => 'Frequency time',
    'mautic.lead.report.frequency.channel' => 'Frequency channel',
    'mautic.lead.report.frequency.preferred_channel' => 'Preferred channel',
    'mautic.lead.report.frequency.pause_from_date' => 'Pause from',
    'mautic.lead.report.frequency.pause_to_date' => 'Pause to',
    'mautic.lead.report.frequency.date_added' => 'Frequency rule added date',
    'mautic.segment.contact.manually.added' => 'Manually added contacts',
    'mautic.segment.contact.manually.removed' => 'Manually removed contacts',
    'mautic.segment.contact.filter.added' => 'Filter added contacts',
    'mautic.segment.segment' => 'Segment',
    'mautic.segment.stats' => 'Contacts in time',
    'mautic.segment.form.confirmdelete' => 'Delete the segment, %name%?',
    'mautic.lead.segments.contacts' => 'All contacts',
    'mautic.lead.segments.contacts.added' => 'Added',
    'mautic.lead.segments.contacts.removed' => 'Removed',
    'mautic.lead.segments.contacts.total' => 'Total',
    'mautic.channel.stat.leadcount.tooltip' => 'Details may not match summary numbers if the contact no longer exists in Mautic or if a contact was sent the message multiple times',
    'mautic.lead.segments.usages' => 'Segment usages',
    'mautic.lead.segments.no_usages' => 'Looks like this segment is not in use.',
    'mautic.lead.campaign.share' => 'Campaign share',
    'mautic.lead.share' => 'Share',
    'mautic.lead.field.notfound' => 'Lead Field was not found',
    'mautic.lead.field.column_was_created' => 'Column with ID %id% was created',
    'mautic.lead.field.column_already_created' => 'Column was already created',
    'mautic.lead.field.column_creation_aborted' => 'Column creation was aborted',
    'mautic.lead.field.column_update_aborted' => 'Column update was aborted',
    'mautic.lead.field.column_was_updated' => 'Column was updated',
    'mautic.lead.field.max_column_error' => 'You have reached the limit of custom fields allowed by your database.',
    'mautic.lead.field.pushed_to_background' => 'Your custom field is being created, we will notify you when complete',
    'mautic.lead.field.update_pushed_to_background' => 'Your custom field is being updated, we will notify you when complete',
    'mautic.lead.field.being_created_in_background' => 'Custom field is being created in background',
    'mautic.lead.field.notification.created_message' => 'Your custom field \'%label%\' was created',
    'mautic.lead.field.notification.created_header' => 'Custom field created',
    'mautic.lead.field.notification.updated_message' => 'Your custom field \'%label%\' was updated',
    'mautic.lead.field.notification.updated_header' => 'Custom field updated',
    'mautic.lead.field.notification.cannot_be_created_message' => 'Custom field \'%label%\' cannot be created',
    'mautic.lead.field.notification.cannot_be_created_header' => 'Custom field cannot be created',
    'mautic.lead.field.notification.custom_field_limit_hit_message' => 'Custom field \'%label%\' cannot be created - you have reached the limit of custom fields allowed by your database.',
    'mautic.lead.field.notification.custom_field_limit_hit_header' => 'Custom field cannot be created',
    'mautic.lead.command.error' => 'Command %name%, error: %error%',
    'mautic.lead.command.delete_contact_secondary_company.allow_multiple_enabled' => 'The \'Multiple companies for contact\' setting is enabled, aborting process. (Set this configuration option to false to run this command)',
    'mautic.lead.command.delete_contact_secondary_company.success' => 'Secondary companies have been successfully deleted.',
    'mautic.lead.stats' => 'Statistics',
    'mautic.lead.stats.email_title' => 'Channel: Email',
    'mautic.lead.stats.sent_count' => 'Total sent:',
    'mautic.lead.stats.open_rate' => 'Open rate:',
    'mautic.lead.stats.click_through_rate' => 'Click-through rate:',
    'mautic.lead.stats.click_through_open_rate' => 'Click-to-open rate:',
    'mautic.lead.export.being.prepared.header' => 'File is queued for processing',
    'mautic.lead.export.being.prepared' => 'The file will be sent to your email address \'%user_email%\' You can download the file from the link provided in the email.',
    'mautic.lead.export.email_subject' => 'Contacts export: %file_name%',
    'mautic.lead.export.email' => 'Your requested Contacts export: <a href=%link%>%label%</a>.',
    'mautic.lead.field.analyse.header.name' => 'Custom Field Name',
    'mautic.lead.field.analyse.header.alias' => 'Custom Field Alias',
    'mautic.lead.field.analyse.header.length' => 'Current Size',
    'mautic.lead.field.analyse.header.max_length' => 'Currently Utilised max size',
    'mautic.lead.field.analyse.header.suggested_length' => 'Suggested max size',
    'mautic.lead.field.analyse.header.indexed' => 'Is Index Present',
    'mautic.lead_list.filter.alert.regexp' => 'This Regexp filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.endwith' => 'This Ends With filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.contain' => 'This Contains filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.like' => 'This Like filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.email' => 'Consider using the "Email Domain" filter instead of "Email" to be able to match the email domain.',
    'mautic.lead_list.filter.label.removefilter' => 'Remove filter',
    'mautic.lead_list.filter.label.clonefilter' => 'Clone filter',
    'mautic.marketplace.marketplace' => 'Marketplace',
    'marketplace.title' => 'Marketplace <sup>BETA</sup>',
    'marketplace.beta.warning' => '<strong>Heads up!</strong> This is a preview of the Mautic Marketplace. Some things might not work as expected yet. <a target=\'_blank\' href=\'https://docs.mautic.org/en/marketplace\'>[Read more]</a>',
    'marketplace.composer.required' => '<strong>Heads up!</strong> Technical setup required to install or update plugins. <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>Send these instructions to a developer.</a>',
    'mautic.marketplace.permissions.header' => 'Marketplace Permissions',
    'mautic.marketplace.permissions.packages' => 'Packages - User has access to',
    'marketplace.vendor' => 'Vendor',
    'marketplace.downloads' => 'Downloads',
    'marketplace.favers' => 'Stars',
    'marketplace.package.github.stars' => 'Stars',
    'marketplace.package.github.watchers' => 'Watchers',
    'marketplace.package.github.forks' => 'Forks',
    'marketplace.package.github.open.issues' => 'Open issues',
    'marketplace.package.dependents' => 'Dependent packages',
    'marketplace.package.suggesters' => 'Suggested by other packages',
    'marketplace.package.total.downloads' => 'Total downloads',
    'marketplace.package.monthly.downloads' => 'Monthly downloads',
    'marketplace.package.daily.downloads' => 'Daily downloads',
    'marketplace.package.version' => 'Version',
    'marketplace.package.homepage' => 'Homepage',
    'marketplace.package.create.date' => 'Package created',
    'marketplace.package.maintainers' => 'Maintainers',
    'marketplace.package.license' => 'License',
    'marketplace.package.issue.tracker' => 'Issue tracker',
    'marketplace.package.wiki' => 'Documentation',
    'marketplace.package.version.release.date' => 'Release date',
    'marketplace.package.required.packages' => 'Required packages',
    'marketplace.package.keywords' => 'Keywords',
    'marketplace.other.packages' => 'Other packages by %name%',
    'marketplace.package.repository' => 'Repository',
    'marketplace.package.cli.install' => 'Install via CLI',
    'marketplace.package.cli.install.descr' => 'Installing a plugin via Command Line Interface is recommended. To install this plugin, execute this command: <code>bin/console mautic:marketplace:install %vendor%/%package%</code>',
    'marketplace.package.latest.stable.version' => 'Latest Stable Version',
    'marketplace.package.all.versions' => 'All Versions',
    'marketplace.package.github.info' => 'GitHub Info',
    'marketplace.package.packagist.info' => 'Packagist Info',
    'marketplace.package.install' => 'Install',
    'marketplace.package.remove' => 'Remove',
    'marketplace.package.install.failed' => 'Installation of the package has failed. Please check Mautic\'s logs for more details.',
    'marketplace.package.install.already.installed' => 'This package is already installed on the system.',
    'marketplace.package.install.html.failed' => 'Something went wrong while installing <strong>%packagename%</strong>. This is the error:',
    'marketplace.package.install.html.in.progress' => '<strong>%packagename%</strong> is being installed. This might take a while...',
    'marketplace.package.install.html.success' => 'Successfully installed <strong>%packagename%</strong>!',
    'marketplace.package.install.html.success.continue' => 'Go to the plugin page to activate the plugin',
    'marketplace.package.request.details.missing' => 'The package vendor or name has not been provided. Please try again.',
    'marketplace.package.cache.clear.failed' => 'Couldn\'t refresh plugins list. Please ask a developer to check server permissions and try again.',
    'marketplace.package.remove.not.installed' => 'The selected package is not currently installed and can therefore not be removed. Please try again with a different package name.',
    'marketplace.package.remove.failed' => 'Removing the package has failed. Please check Mautic\'s logs for more details.',
    'marketplace.package.remove.html.failed' => 'Something went wrong while removing <strong>%packagename%</strong>. This is the error:',
    'marketplace.package.remove.html.in.progress' => '<strong>%packagename%</strong> is being removed. This might take a while...',
    'marketplace.package.remove.html.success' => 'Successfully removed <strong>%packagename%</strong>!',
    'marketplace.package.remove.html.success.continue' => 'Back to Marketplace overview',
    'marketplace.latest.version.missing' => 'Could not find any version of this package. Please try again later.',
    'marketplace.noresults.tip' => 'There are no packages available for your version of Mautic. Try upgrading to a newer version.',
    'marketplace.clear.cache' => 'Refresh plugins list',
    'marketplace.clear.cache.tooltip' => 'We save some data to make the Marketplace load faster. Click here to update this saved data.',
    'marketplace.package.details.close' => 'Back to marketplace',
    'mautic.config.tab.messengerconfig' => 'Queue Settings',
    'mautic.messenger.config.retry_strategy' => 'Retry strategy',
    'mautic.messenger.config.retry_strategy.max_retries' => 'Max retries',
    'mautic.messenger.config.retry_strategy.delay' => 'Delay',
    'mautic.messenger.config.retry_strategy.multiplier' => 'Multiplier',
    'mautic.messenger.config.retry_strategy.max_delay' => 'Max delay',
    'mautic.messenger.config.dsn_help_general' => 'Queuing is not enabled by default (scheme is set to \'sync\'). If you want to start using a queue, please follow the documentation at <a href=%link%>%link%</a>.',
    'mautic.messenger.config.dsn_help_retry_strategy' => 'When the processing of a message fails, the message is sent back to the queue for another try. You can adjust this behaviour in the following section. See the documentation on <a href=%link%>%link%</a> for more details.',
    'mautic.messenger.config.dsn_help_failed' => 'If a message fails all its retries, it\'s discarded by default. To avoid this happening, you can optionally configure a queue for failures. For more details see the documentation on  <a href=%link%>%link%</a>.',
    'mautic.messenger.config.dsn_email' => 'Queue for email (SMS and push messages)',
    'mautic.messenger.config.dsn_hit' => 'Queue for hits (page and email)',
    'mautic.messenger.config.dsn_failed' => 'Queue for failures',
    'mautic.messenger.config.dsn.send_test_message' => 'Send test message',
    'mautic.messenger.config.dsn.test_message_failed' => 'The test message could not be sent due to the following error: \'%message%\'.',
    'mautic.messenger.config.dsn.test_message_processed' => 'The test message for DSN \'%type%\' was successfully processed.',
    'mautic.campaign.notification.send_notification' => 'Send Notification',
    'mautic.channel.mobile_notification' => 'Mobile Push Notification',
    'mautic.notification.notification' => 'Web Notification',
    'mautic.notification.notifications' => 'Web Notifications',
    'mautic.notification.campaign.send_notification' => 'Send web notification',
    'mautic.notification.campaign.send_notification.tooltip' => 'Sends a web notification to the contact.',
    'mautic.notification.mobile_notification' => 'Mobile Notification',
    'mautic.notification.mobile_notifications' => 'Mobile Notifications',
    'mautic.notification.campaign.send_mobile_notification' => 'Send mobile notification',
    'mautic.notification.campaign.send_mobile_notification.tooltip' => 'Sends a mobile notification to the contact if they have enabled notifications on their mobile device in your app.',
    'mautic.notification.tab.ios' => 'iOS',
    'mautic.notification.tab.android' => 'Android',
    'mautic.notification.tab.data' => 'Additional Data',
    'mautic.notification.tab.mobile' => 'Mobile Settings',
    'mautic.integration.form.feature.mobile' => 'Mobile app notifications',
    'mautic.integration.form.feature.landing_page_enabled' => 'Enabled on landing pages?',
    'mautic.integration.form.features.landing_page_enabled.tooltip' => 'Enable OneSignal on your Mautic landing pages?',
    'mautic.integration.form.feature.tracking_page_enabled' => 'Enable on tracked pages?',
    'mautic.integration.form.features.tracking_page_enabled.tooltip' => 'Enable OneSignal on websites that have embedded the mtc.js from this Mautic installation?',
    'mautic.integration.form.feature.welcome_notification_enabled' => 'Welcome notification',
    'mautic.integration.form.platforms' => 'Supported Platforms For Mobile Push',
    'mautic.integration.form.platforms.tooltip' => 'Select the platforms that your OneSignal configuration will support. Only select platforms for which you have an app and have integrated the OneSignal SDK.',
    'mautic.integration.form.platforms.ios' => 'iOS',
    'mautic.integration.form.platforms.android' => 'Android',
    'mautic.integration.form.platforms.error' => 'If the mobile notifications feature is enabled, you must select at least one platform.',
    'mautic.notification.form.mobile.url' => 'URL',
    'mautic.notification.form.mobile.url.tooltip' => 'Opens a URL when the notification is clicked.',
    'mautic.notification.form.mobile.heading' => 'Title',
    'mautic.notification.form.mobile.ios_subtitle' => 'Message Subtitle',
    'mautic.notification.form.mobile.ios_subtitle.tooltip' => 'This is an iOS 10 only feature',
    'mautic.notification.form.mobile.ios_sound' => 'Sound',
    'mautic.notification.form.mobile.ios_sound.tooltip' => 'Sound file will play when the notification is received by the device. This should either be left blank for the default sound or set to the name of a sound file in your app bundle.',
    'mautic.notification.form.mobile.ios_badges' => 'Badges',
    'mautic.notification.form.mobile.ios_badges.tooltip' => 'Small number on the app icon on the home screen indicating the number of notifications received for your app. Clears when the app is opened.',
    'mautic.notification.form.mobile.ios_badges.placeholder' => 'Don\'t set or change',
    'mautic.notification.form.mobile.ios_badges.set' => 'Set to',
    'mautic.notification.form.mobile.ios_badges.increment' => 'Increase by',
    'mautic.notification.form.mobile.ios_badgecount' => 'Badge count',
    'mautic.notification.form.mobile.ios_badgecount.tooltip' => 'This will either set or increase the badge count depending on your previous selection.',
    'mautic.notification.form.mobile.ios_contentavailable' => 'Content Available',
    'mautic.notification.form.mobile.ios_contentavailable.tooltip' => 'Only for native iOS apps. Wakes your app when the notification is received so you can do work in the background. See Apple\'s \'content-available\' documentation for more details.',
    'mautic.notification.form.mobile.ios_media' => 'Media',
    'mautic.notification.form.mobile.ios_media.tooltip' => 'Rich media attachment. Image, sound, or video to show when 3D touching the notification. Requires the OneSignal iOS 2.1.1 SDK or newer.',
    'mautic.notification.form.mobile.ios_mutablecontent' => 'Mutable Content',
    'mautic.notification.form.mobile.ios_mutablecontent.tooltip' => 'Native only code running on iOS 10+. Allows you to modify the notification from your app before it is displayed. See Apple\'s \'mutable-content\' documentation for more details.',
    'mautic.notification.form.mobile.android_sound' => 'Sound',
    'mautic.notification.form.mobile.android_small_icon' => 'Small Icon',
    'mautic.notification.form.mobile.android_large_icon' => 'Large Icon',
    'mautic.notification.form.mobile.android_group_key' => 'Group Key',
    'mautic.notification.form.mobile.android_lockscreen_visibility' => 'Lockscreen Visibility',
    'mautic.notification.form.mobile.android_lockscreen_visibility.placeholder' => 'Public',
    'mautic.notification.form.mobile.android_lockscreen_visibility.private' => 'Private',
    'mautic.notification.form.mobile.android_lockscreen_visibility.secret' => 'Secret',
    'mautic.notification.form.mobile.android_big_picture' => 'Big Picture',
    'mautic.notification.form.mobile.android_led_color' => 'LED Color',
    'mautic.notification.form.mobile.android_accent_color' => 'Accent Color',
    'mautic.notification.form.mobile.android_sound.tooltip' => 'Sound resource will play when the notification is received by the device.',
    'mautic.notification.form.mobile.android_small_icon.tooltip' => 'Icon shows in the status bar. Also show to the left of the notification text unless a large icon is set.',
    'mautic.notification.form.mobile.android_large_icon.tooltip' => 'Requires Android 3.0+. Icon shows up to the left of the notification text.',
    'mautic.notification.form.mobile.android_group_key.tooltip' => 'Notifications with the same Group Key will be stacked together as a single summary notification with the number of unopened notifications.',
    'mautic.notification.form.mobile.android_lockscreen_visibility.tooltip' => 'Only applies to apps targeting Android API level 21+ running on Android 5.0+ devices.',
    'mautic.notification.form.mobile.android_big_picture.tooltip' => 'Requires Android 4.1+ Shows up in an expandable view below the notification text.',
    'mautic.notification.form.mobile.android_led_color.tooltip' => 'Sets the device\'s LED notification light if the device has one. Uses ARGB Hex value. The placeholder text shown is blue.',
    'mautic.notification.form.mobile.android_accent_color.tooltip' => 'Sets the circle color around your small icon that shows to the left of your notification text. Uses ARGB Hex value. The placeholder text is shown red. Only applies to apps targeting Android API level 21+ running on Android 5.0+ devices.',
    'mautic.config.tab.notificationconfig' => 'Web Notification Settings',
    'mautic.notification.config.form.notification.enabled' => 'Web Notifications Enabled?',
    'mautic.notification.config.form.notification.enabled.tooltip' => 'Enable Web Notifications support in your campaigns?',
    'mautic.notification.config.form.notification.landingpage.enabled' => 'Enabled on Mautic landing pages?',
    'mautic.notification.config.form.notification.landingpage.enabled.tooltip' => 'Enable Web Notifications on landing pages?',
    'mautic.notification.config.form.notification.trackingpage.enabled' => 'Enabled on tracking pages?',
    'mautic.notification.config.form.notification.trackinggpage.enabled.tooltip' => 'Enable Web Notifications on tracking pages?',
    'mautic.notification.config.form.notification.welcome.enabled' => 'Welcome Notification',
    'mautic.notification.config.form.notification.welcome.enabled.tooltip' => 'Enable Welcome Notification after register',
    'mautic.notification.config.form.notification.app_id' => 'OneSignal App ID',
    'mautic.notification.config.form.notification.app_id.tooltip' => 'OneSignal App ID',
    'mautic.notification.config.form.notification.rest_api_key' => 'OneSignal Rest API Key',
    'mautic.notification.config.form.notification.rest_api_key.tooltip' => 'OneSignal Rest API Key',
    'mautic.notification.config.form.notification.gcm_sender_id' => 'Shared key for push notifications',
    'mautic.notification.config.form.notification.gcm_sender_id.tooltip' => 'gcm_sender_id key - do not change it',
    'mautic.notification.config.form.notification.subdomain_name' => 'Subdomain of onesignal.com',
    'mautic.notification.config.form.notification.subdomain_name.tooltip' => 'Only for non https sites.',
    'mautic.notification.config.form.notification.notification_safari_web_id' => 'Web Notifications Provider Safari Web ID',
    'mautic.notification.config.form.notification.notification_safari_web_id.tooltip' => 'One Signal Safari Web ID for your One Signal App',
    'mautic.notification.config.form.notification.icon' => 'Web Notification Icon',
    'mautic.notification.config.form.notification.icon.tooltip' => 'The icon that will be shown on the left side of your web notifications.',
    'mautic.notification.form.action.sendnotification.admin' => 'Send web notification to user',
    'mautic.notification.form.action.sendnotification.admin.descr' => 'Send the selected web notification to the selected user(s) upon form submission.',
    'mautic.notification.form.action.sendnotification.lead' => 'Send web notification to contact',
    'mautic.notification.form.action.sendnotification.lead.descr' => 'Send the web selected notification to the contact upon form submission.',
    'mautic.notification.form.body' => 'Body',
    'mautic.notification.form.confirmbatchdelete' => 'Delete the selected web notifications?',
    'mautic.notification.form.confirmdelete' => 'Delete the web notification, %name%?',
    'mautic.notification.form.confirmsend' => 'Queue, %name%, for sending?',
    'mautic.notification.form.internal.name' => 'Name',
    'mautic.notification.form.list' => 'Contact list',
    'mautic.notification.header.edit' => 'Edit Web Notification',
    'mautic.notification.header.new' => 'New Web Notification',
    'mautic.notification.mobile.header.edit' => 'Edit Mobile Notification',
    'mautic.notification.mobile.header.new' => 'New Mobile Notification',
    'mautic.notification.text' => 'Web Notification Content',
    'mautic.notification.text.tooltip' => 'Your web notification content',
    'mautic.notification.headings' => 'Web Notification Title',
    'mautic.notification.headings.tooltip' => 'Your web notification title',
    'mautic.notification.link' => 'Link',
    'mautic.notification.link.placeholder' => 'http://',
    'mautic.notification.link.tooltip' => 'When the user clicks the web notification, where do you want to send them?',
    'mautic.notification.permissions.mobile_notifications' => 'Mobile Notifications - User has access to',
    'mautic.notification.permissions.header' => 'Push Notification Permissions',
    'mautic.notification.permissions.notifications' => 'Web Notifications - User has access to',
    'mautic.notification.stats' => 'Notification Stats',
    'mautic.notification.stats.report.table' => 'Notifications Sent',
    'mautic.notification.stat.leadcount' => '%count% Pending',
    'mautic.notification.stat.readcount' => '%count% Read',
    'mautic.notification.stat.sentcount' => '%count% Sent',
    'mautic.notification.type.header' => 'What type of notification do you want to create?',
    'mautic.notification.type.list' => 'Segment Notifications',
    'mautic.notification.type.list.header' => 'New Segment Notification',
    'mautic.notification.type.list.description' => 'A segment notification can be manually sent to selected contact segments. Once the notification has been sent, it cannot be edited. However, it can be sent to new contacts as they are added to the associated segments.',
    'mautic.notification.type.template' => 'Triggered Notifications',
    'mautic.notification.type.template.header' => 'New Triggered Notification',
    'mautic.notification.type.template.description' => 'A triggered notification is automatically sent by campaigns, forms, point events, etc. These can be edited but cannot be sent to a contact segments.',
    'mautic.notification.form.internal.description' => 'Description',
    'mautic.notification.form.heading' => 'Heading',
    'mautic.notification.form.url' => 'Link',
    'mautic.notification.form.url.tooltip' => 'The destination the user is sent to when they click the notification.',
    'mautic.notification.form.button' => 'Action Button Text',
    'mautic.notification.form.button.tooltip' => 'Add action button to the notification (Chrome only)',
    'mautic.notification.form.message' => 'Message',
    'mautic.notification.send.selectnotifications' => 'Select Notification',
    'mautic.notification.choose.notifications' => 'Select the notification to send to the user.',
    'mautic.notification.send.new.notification' => 'New Notification',
    'mautic.notification.send.edit.notification' => 'Edit Notification',
    'mautic.notification.send.preview.notification' => 'Preview Notification',
    'mautic.notification.preview' => 'Preview',
    'mautic.notification.notification.header.preview' => 'Web Notification Preview',
    'mautic.notification.timeline.status' => 'Status',
    'mautic.notification.timeline.type' => 'Type',
    'mautic.notification.timeline.status.delivered' => 'Delivered',
    'mautic.notification.timeline.status.failed' => 'Failed',
    'mautic.notification.config.form.notification.safari_web_id' => 'Safari Web ID',
    'mautic.notification.config.form.notification.safari_web_id.tooltip' => 'Safari Web ID from OneSignal if you want to support Apple Push Notifications',
    'mautic.notification.campaign.failed.not_contactable' => 'Contact is not contactable on the Web Notification channel.',
    'mautic.notification.campaign.failed.not_subscribed' => 'The contact has not subscribed to the Web Notification channel.',
    'mautic.notification.campaign.failed.missing_entity' => 'The specified Web Notification entity does not exist.',
    'mautic.notification.campaign.failed.unpublished' => 'The specified Web Notification is unpublished.',
    'mautic.notification.show.total.sent' => 'Total sent',
    'mautic.notification.campaign.event.notification.has.active' => 'Has active notification',
    'mautic.campaign.notification.has.active' => 'Has active notification',
    'mautic.notification.campaign.event.notification.has.active.desc' => 'Condition check If contact has active notification.',
    'mautic.report.group.mobile_notifications' => 'Mobile Notifications',
    'mautic.mobile_notification.stats.report.table' => 'Mobile Notifications sent',
    'mautic.mobile_notification.report.hits_count' => 'Hits Count',
    'mautic.mobile_notification.report.hits_ratio' => 'Hits Ratio',
    'mautic.mobile_notification.report.read_count' => 'Read Count',
    'mautic.mobile_notification.report.read_ratio' => 'Read Ratio',
    'mautic.mobile_notification.report.sent_count' => 'Sent Count',
    'mautic.mobile_notifications.report.stat.date_read' => 'Date Read',
    'mautic.mobile_notifications.report.stat.date_sent' => 'Date Sent',
    'mautic.mobile_notification.report.unique_hits_count' => 'Unique Hits',
    'mautic.mobile_notification.report.unique_ratio' => 'Unique Ratio',
    'mautic.notification.mobile_notification.heading' => 'Title',
    'mautic.notification.mobile_notification.preview' => 'Preview notification',
    'mautic.notification.mobile_notification.header.preview' => 'Mobile notification',
    'mautic.mobile_notification.graph.line.stats.read' => 'Read',
    'mautic.mobile_notification.graph.line.stats.sent' => 'Sent',
    'mautic.mobile_notification.graph.line.stats' => 'Mobile Notifications sent',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.ignored' => 'Ignored',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.read' => 'Read',
    'mautic.mobile_notification.graph.pie.ignored.read.failed' => 'Ignored / Read / Failed mobile notifications',
    'mautic.notification.actions' => 'Notification actions',
    'mautic.notification.actions.mobile_tooltip' => 'Send the selected mobile notification to the user when a form is filled out if they have mobile notifications enabled.',
    'mautic.notification.actions.send_mobile_notification' => 'Send mobile notification',
    'mautic.notification.form.subdomain_name.label' => 'Subdomain name',
    'mautic.campaign.notification.send_mobile_notification' => 'Send mobile notification',
    'mautic.config.tab.notification_config' => 'Notification Settings',
    'mautic.config.tab.campaign_notification_config' => 'Campaign Notification Settings',
    'mautic.config.tab.webhook_notification_config' => 'Webhook Notification Settings',
    'mautic.notification.form.config.send_notification_to_author' => 'Send notification to author',
    'mautic.notification.form.config.send_notification_to_author.tooltip' => 'Send notification to the author or other users email addresses.',
    'mautic.notification.form.config.notification_email_addresses' => 'Email addresses to receive notifications',
    'mautic.notification.form.config.notification_email_addresses.tooltip' => 'Add comma separated list of email addresses to receive notifications',
    'mautic.placeholder_tokens.landing_page_tokens' => 'Landing pages',
    'mautic.placeholder_tokens.preference_center_tokens' => 'Preference Center landing page',
    'mautic.placeholder_tokens.landing_page.meta_description' => 'Meta description',
    'mautic.placeholder_tokens.landing_page.title' => 'Title',
    'mautic.placeholder_tokens.landing_page.language_bar' => 'Language bar',
    'mautic.placeholder_tokens.landing_page.share_buttons' => 'Share buttons',
    'mautic.placeholder_tokens.landing_page.success_message' => 'Success message',
    'mautic.placeholder_tokens.preference_center.lead_identifier' => 'Lead identifier',
    'mautic.placeholder_tokens.preference_center.category_list' => 'Category list',
    'mautic.placeholder_tokens.preference_center.segment_list' => 'Segment list',
    'mautic.placeholder_tokens.preference_center.preferred_channel' => 'Preferred channel',
    'mautic.placeholder_tokens.preference_center.channel_frequency' => 'Channel frequency',
    'mautic.placeholder_tokens.preference_center.save_preferences' => 'Save preferences button',
    'mautic.placeholder_tokens.landing_page_tokens.explanation' => 'Customize content within the landing pages builder.',
    'mautic.campaign.page.devicehit' => 'Device Hit',
    'mautic.campaign.page.pagehit' => 'Page Hit',
    'mautic.config.tab.pageconfig' => 'Landing Page Settings',
    'mautic.maintenance.page_hits' => 'Visitor page hits',
    'mautic.maintenance.lead_utmtags' => 'UTM tag history',
    'mautic.page.page' => 'Page',
    'mautic.config.tab.trackingconfig' => 'Tracking Settings',
    'mautic.config.tab.pixels.event.in.campaign' => 'Enable 3rd party campaign action',
    'mautic.page.config.form.pixel.campaign.enabled' => 'Enable Campaign action \'Send 3rd party  pixel\'',
    'mautic.page.abtest.criteria' => 'Landing Page Stats',
    'mautic.page.abtest.criteria.bounce' => 'Lowest bounce rate',
    'mautic.page.abtest.criteria.dwelltime' => 'Longest dwell time',
    'mautic.page.abtest.label.bounces' => 'Bounce rate',
    'mautic.page.abtest.label.dewlltime.average' => 'Average dwell time (s)',
    'mautic.page.builder.addcontent' => 'Click to add content',
    'mautic.page.builder.externallink' => 'External Link',
    'mautic.protip.pages.mobile' => 'Optimize your website for mobile-first since most web traffic now comes from mobile devices',
    'mautic.protip.pages.forms' => 'Place forms prominently \'above the fold\' so users don\'t have to scroll to find them.',
    'mautic.page.campaign.event.form.pages' => 'Limit to Pages',
    'mautic.page.campaign.event.form.pages.descr' => 'Select the pages this trigger applies to. If none are selected, it\'ll apply to any page.',
    'mautic.page.campaign.event.form.url' => 'URL',
    'mautic.page.campaign.event.form.url.descr' => 'Insert the URL of the page where you placed the tracking pixel. It is possible to use wildcard (*). Example: *product/123* will match http://web.com/product/1234.htm. Separate multiple URLs with a comma.',
    'mautic.page.campaign.event.form.referer' => 'Referrer',
    'mautic.page.campaign.event.form.referer.descr' => 'Insert the Referrer URL of the page where you placed the tracking pixel. It is possible to use wildcard (*). Example: *product/123* will match http://web.com/product/1234.htm. Multiple Referrer URLs separate with comma.',
    'mautic.page.campaign.event.pagehit' => 'Visits a page',
    'mautic.page.campaign.event.pagehit_descr' => 'Trigger actions on a page/url hit.',
    'mautic.page.campaign.event.devicehit' => 'Device visit',
    'mautic.page.campaign.event.devicehit_descr' => 'Trigger device  on a page/url hit.',
    'mautic.page.campaign.condition.form.startdate' => 'Start Date',
    'mautic.page.campaign.condition.form.enddate' => 'End Date',
    'mautic.page.campaign.condition.form.timespent' => 'Time spent (seconds)',
    'mautic.page.campaign.condition.form.page' => 'Page',
    'mautic.page.campaign.condition.form.page.descr' => 'Select the page this trigger applies to. If none are selected, it\'ll apply to any page.',
    'mautic.page.config.form.cat.in.url' => 'Show category in page URL?',
    'mautic.page.config.form.cat.in.url.tooltip' => 'If enabled, the category slug will be included in the URL.',
    'mautic.page.config.form.track.by.tracking.url' => 'Identify visitor by tracking  url',
    'mautic.page.config.form.track.by.tracking.url.tooltip' => 'If enabled, identify returning visitor by tracking url from channels (especially from emails) when no cookie exists yet. Note: Email fields have to be marked as a unique identifier and publicly updatable in Configuration.',
    'mautic.page.config.form.google.analytics' => 'Analytics script (i.e. Google Analytics)',
    'mautic.page.config.form.google.analytics.tooltip' => 'Insert the analytics script to have it automatically included in the source of landing pages.',
    'mautic.page.config.form.track_contact_by_ip' => 'Identify visitors by IP',
    'mautic.page.config.form.track_contact_by_ip.tooltip' => 'If enabled, unidentified visitors with the same IP address as an existing contact will be tracked as that contact.',
    'mautic.page.config.form.do_not_track_404_anonymous' => 'Do Not Track 404 error for anonymous contacts',
    'mautic.page.config.form.do_not_track_404_anonymous.tooltip' => 'If option is enabled, unidentified visits to 404 response code error pages will not be tracked. This option help prevent bots tracking.',
    'mautic.page.config.form.anonymize_ip' => 'Anonymize IP',
    'mautic.page.config.form.anonymize_ip.tooltip' => 'The visitor\'s IP will not be stored anywhere.',
    'mautic.page.config.form.anonymize_ip.warning' => 'Existing data will be anonymized. This action is not reversible',
    'mautic.page.event.hit' => 'Page hit',
    'mautic.page.event.publish.down' => 'Set %page% as unavailable',
    'mautic.page.event.publish.down.description' => 'Page \'%page%\' is going to become unavailable.',
    'mautic.page.event.publish.up' => 'Set %page% as available',
    'mautic.page.event.publish.up.description' => 'Page \'%page%\' is going to become available.',
    'mautic.page.field.hits' => 'Hit count',
    'mautic.page.field.unique_hits' => 'Unique hit count',
    'mautic.page.form.confirmbatchdelete' => 'Delete the selected pages? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.page.form.confirmdelete' => 'Delete the page, %name%? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.page.form.customhtml' => 'Custom HTML Content',
    'mautic.page.form.customhtml.help' => 'Design the entire landing page using custom HTML',
    'mautic.page.form.language.help' => 'Translate the content into multiple languages and link them together by assigning them to a parent page. Language selection links will become available on the related landing pages for customers to choose the language they want to see.',
    'mautic.page.form.metadescription' => 'Meta Description',
    'mautic.page.form.headscript' => 'Script inside Head',
    'mautic.page.form.script.help' => 'Please ensure to enclose your script within <&#8239;script&#8239;> tags to prevent it from displaying as text on the page instead of executing.',
    'mautic.page.form.footerscript' => 'Script inside Footer',
    'mautic.page.form.template.help' => 'Choose the theme that will give the landing page it\'s look and feel. Then use the Page Builder to fill in the contents. WARNING: Changing the theme after building the page may cause content to not display if the two themes do not use the same placeholders.',
    'mautic.page.form.redirecttype' => 'Redirect type',
    'mautic.page.form.redirecttype.help' => 'Choose the redirect type (301 permanent, 302 temporary, none)',
    'mautic.page.form.redirecttype.none' => 'No Redirect',
    'mautic.page.form.redirecttype.permanent' => '301 Permanent',
    'mautic.page.form.redirecttype.temporary' => '302 Temporary',
    'mautic.page.form.redirecttype.303_temporary' => '303 Temporary',
    'mautic.page.form.redirecttype.307_temporary' => '307 Temporary',
    'mautic.page.form.redirecttype.308_permanent' => '308 Permanent',
    'mautic.page.form.redirecturl' => 'URL Redirect',
    'mautic.page.form.redirecturl.help' => 'Choose a URL that can be displayed when this page is unpublished. You can enter a custom URL or you can choose from your personal pages already published.',
    'mautic.page.graph.line.hits' => 'Page Hits',
    'mautic.page.graph.line.time.on.site' => 'Average time on site in seconds',
    'mautic.page.graph.pie.devices' => 'Device Granularity',
    'mautic.page.graph.pie.languages' => 'Page Languages',
    'mautic.page.graph.pie.new.vs.returning' => 'New vs Returning',
    'mautic.page.graph.pie.new.vs.returning.new' => 'New',
    'mautic.page.graph.pie.new.vs.returning.returning' => 'Returning',
    'mautic.page.graph.pie.time.on.site' => 'Time on site',
    'mautic.page.header.edit' => 'Edit Page - %name%',
    'mautic.page.header.new' => 'New Page',
    'mautic.page.help.alias' => 'Letters and numbers (hyphens allowed) used for URL generation of this landing page. A unique alias based on the title will be autogenerated if left empty.',
    'mautic.page.hits' => 'Page hits',
    'mautic.page.menu.edit' => 'Edit Page',
    'mautic.page.menu.view' => 'View Page',
    'mautic.page.pages' => 'Landing Pages',
    'mautic.page.pageviews' => 'Page Views',
    'mautic.page.permissions.header' => 'Landing Page Permissions',
    'mautic.page.permissions.pages' => 'Pages - User has access to',
    'mautic.page.point.action' => 'Landing Page actions',
    'mautic.page.point.action.form.accumulative.time' => 'Total time spent',
    'mautic.page.point.action.form.accumulative.time.descr' => 'Change points based on the total amount of time spent on the site across visits.',
    'mautic.page.point.action.form.first.time.only' => 'First visit only',
    'mautic.page.point.action.form.first.time.only.descr' => 'Contacts can visit the specified URL many times. Decide whether to change points each time or only for the first time.',
    'mautic.page.point.action.form.page.hits.descr' => 'Change points based on the number of times a contact visits the page.',
    'mautic.page.point.action.form.page.url' => 'Page URL',
    'mautic.page.point.action.form.page.url.descr' => 'Insert the URL of the page where you placed the tracking pixel. Url must start with http:// or https://. It is possible to use wildcard (*). Example: http://yourweb.com/product/* will match http://yourweb.com/product/1, http://yourweb.com/product/green-carpet and so on.',
    'mautic.page.point.action.form.pages' => 'Limit to the selected pages',
    'mautic.page.point.action.form.pages.descr' => 'Select the pages this action applies to. If none are selected, it\'ll apply to any page.',
    'mautic.page.point.action.form.returns.after' => 'Returns after',
    'mautic.page.point.action.form.returns.after.descr' => 'Change points based on if the contact returns to the URL <em>after</em> the set amount of time.',
    'mautic.page.point.action.form.returns.within' => 'Returns within',
    'mautic.page.point.action.form.returns.within.descr' => 'Change points based on if the contact returns to the URL <em>within</em> the set amount of time.',
    'mautic.page.point.action.pagehit' => 'Visits a landing page',
    'mautic.page.point.action.pagehit_descr' => 'Change the contact\'s points after visiting a landing page.',
    'mautic.page.point.action.urlhit' => 'Visits specific URL',
    'mautic.page.point.action.urlhit_descr' => 'Change the contact\'s points after visiting a specific URL where Mautic tracking pixel is loaded.',
    'mautic.page.preview.url' => 'Public Preview URL',
    'mautic.page.publish.down' => 'Set as unavailable',
    'mautic.page.publish.up' => 'Set as available',
    'mautic.page.referrer' => 'Referrer',
    'mautic.page.report.hits.browser_languages' => 'Hit browser languages',
    'mautic.page.report.hits.city' => 'Hit city',
    'mautic.page.report.hits.code' => 'Hit code',
    'mautic.page.report.hits.country' => 'Hit country',
    'mautic.page.report.hits.date_hit' => 'Date hit',
    'mautic.page.report.hits.date_left' => 'Date left',
    'mautic.page.report.hits.device' => 'Device',
    'mautic.page.report.hits.email_id' => 'Email ID',
    'mautic.page.report.hits.email_subject' => 'Email subject',
    'mautic.page.report.hits.isp' => 'Hit ISP',
    'mautic.page.report.hits.organization' => 'Hit organization',
    'mautic.page.report.hits.redirect_hit_count' => 'Redirect hit count',
    'mautic.page.report.hits.redirect_unique_hits' => 'Redirect unique hit count',
    'mautic.page.report.hits.redirect_url' => 'Redirect URL',
    'mautic.page.report.hits.referer' => 'Hit referer',
    'mautic.page.report.hits.region' => 'Hit region',
    'mautic.page.report.hits.remote_host' => 'Hit remote host',
    'mautic.page.report.hits.url' => 'Hit URL',
    'mautic.page.report.hits.url_title' => 'Hit page title',
    'mautic.page.report.hits.user_agent' => 'Hit user agent',
    'mautic.page.report.revision' => 'Revision',
    'mautic.page.report.translation_parent_id' => 'Translation parent ID',
    'mautic.page.report.translation_parent_title' => 'Translation parent name',
    'mautic.page.report.variant_hits' => 'A/B test hit count',
    'mautic.page.report.variant_parent_id' => 'A/B test parent ID',
    'mautic.page.report.variant_parent_title' => 'A/B test parent title',
    'mautic.page.report.variant_start_date' => 'A/B test start date',
    'mautic.page.report.hits.id' => 'Page hit ID',
    'mautic.report.group.videos' => 'Videos',
    'mautic.video.hits' => 'Video hits',
    'mautic.page.report.hits.time_watched' => 'Time watched',
    'mautic.page.report.hits.duration' => 'Duration',
    'mautic.page.stage.action' => 'Page actions',
    'mautic.page.stage.action.pagehit' => 'Visits a page',
    'mautic.page.stage.action.urlhit' => 'Visits URL',
    'mautic.page.table.most.visited' => 'Most visited pages',
    'mautic.page.table.most.visited.unique' => 'Most unique visits',
    'mautic.page.table.referrers' => 'Top referrers',
    'mautic.page.thead.hits' => 'Hits',
    'mautic.page.time.on.page' => 'Time on page',
    'mautic.page.token.lang' => 'Language Bar',
    'mautic.page.token.lang.descr' => 'Inserts a language selection bar if the page has multiple translated versions.',
    'mautic.page.token.share' => 'Share Buttons',
    'mautic.page.token.share.descr' => 'Inserts share buttons configured in the Social Networking settings',
    'mautic.page.tokens.header' => 'Tokens',
    'mautic.page.tokens.help' => 'Tokens are placeholders for featured objects such as forms. Just drag and drop the token into the editor to add it!',
    'mautic.page.url' => 'Page URL',
    'mautic.page.webhook.event.hit' => 'Page Hit Event',
    'mautic.page.dashboard.widgets' => 'Page Widgets',
    'mautic.widget.page.hits.in.time' => 'Page visits in time',
    'mautic.widget.unique.vs.returning.leads' => 'Unique vs returning visitors',
    'mautic.widget.dwell.times' => 'Dwell times',
    'mautic.widget.popular.pages' => 'Popular landing pages',
    'mautic.widget.created.pages' => 'Created Landing pages',
    'mautic.page.visit.flag.filter' => 'Visit state',
    'mautic.page.show.total.visits' => 'Total visits',
    'mautic.page.show.unique.visits' => 'Unique visits',
    'mautic.page.show.unique.and.total.visits' => 'Total and unique visits',
    'mautic.page.unique' => 'Unique',
    'mautic.trackable.click_count' => 'Clicks',
    'mautic.trackable.click_counts' => 'Click Counts',
    'mautic.trackable.click_counts.header_none' => 'No trackable URLs found',
    'mautic.trackable.click_counts.none' => 'There are no URLs currently being tracked for this channel. It could be that the channel has not been sent yet or it has no URLs to begin with.',
    'mautic.trackable.click_track_id' => 'Tracking ID',
    'mautic.trackable.click_unique_count' => 'Unique Clicks',
    'mautic.trackable.click_url' => 'URL',
    'mautic.trackable.click_conversion_rate' => 'Conversion Rate',
    'mautic.trackable.total_clicks' => 'Total Clicks',
    'mautic.trackable.total_conversion_rate_tooltip' => 'Number of contacts that clicked on at least one link / Total unique views',
    'mautic.config.tab.pagetracking' => 'Mautic tracking settings',
    'mautic.config.tab.pagetracking.info' => 'Insert following code at the end of the web page before ending <code>&lt;/body&gt;</code> tag. Mautic Landing Pages are tracked automatically. Use this only to track 3rd party websites.',
    'mautic.report.group.pages' => 'Pages',
    'mautic.page.event.videohit' => 'Video view event',
    'mautic.page.time.on.video' => 'Total time viewed',
    'mautic.page.time.on.video.value' => '%time_watched% of %duration% (%percentage%%)',
    'mautic.video.url' => 'Video URL',
    'mautic.page.tracking.pixel.event.send' => 'Send tracking event',
    'mautic.page.tracking.pixel.event.send_desc' => 'Send custom tracking Google Analytics/Facebook Pixel event',
    'mautic.campaign.tracking.pixel.send' => 'Send tracking event',
    'mautic.page.tracking.form.category' => 'Category',
    'mautic.page.tracking.form.category.tooltip' => 'Google Analytics only.',
    'mautic.page.tracking.form.action' => 'Action',
    'mautic.page.tracking.form.label' => 'Label',
    'mautic.page.tracking.form.services' => 'Services',
    'mautic.page.config.form.event.google.analytics.enabled' => 'Google Analytics event',
    'mautic.config.tab.tracking.facebook.pixel' => 'Facebook Pixel',
    'mautic.page.config.form.facebook.pixel.id' => 'Facebook Pixel ID',
    'mautic.config.tab.tracking.google.analytics' => 'Google Analytics',
    'mautic.page.config.form.google.analytics.id' => 'Google Analytics ID',
    'mautic.page.config.form.tracking.landingpage.enabled' => 'Enable on Mautic landing page',
    'mautic.page.config.form.tracking.trackingpage.enabled' => 'Enabled on your tracking page',
    'mautic.page.config.form.tracking.anonymize.ip.enabled' => 'Enabled IP Anonymization',
    'mautic.page.config.form.tracking.anonymize.ip.enabled.tooltip' => 'In some cases, you might need to anonymize the IP address of the hit sent to Google Analytics.',
    'mautic.page.form.preference_center' => 'Set as preference center page',
    'mautic.page.form.preference_center.tooltip' => 'If selected, the page will be marked as a preference center landing page. When this page is configured as a preference center in a Mautic Email, recipients will be shown the page when clicking on the <strong><code>{unsubscribe_url}</code></strong> link.<br />See the <a href=https://www.mautic.org/docs/en/contacts/customize_preference_center.html target=_blank>Mautic documentation</a> under Contacts / Preference Center for more information.',
    'mautic.page.config.no_index' => 'Disable search indexing',
    'mautic.email.form.preference_center' => 'Preference center page',
    'mautic.email.form.preference_center.tooltip' => 'Display the selected page as the preference center if a user accesses it through this email.',
    'mautic.page.permissions.preference_center' => 'Preference center pages - User has access to',
    'mautic.page.form.segmentlist' => 'Segment list',
    'mautic.page.form.categorylist' => 'Category list',
    'mautic.page.form.preferredchannel' => 'Preferred channel',
    'mautic.page.form.channelfrequency' => 'Channel frequency',
    'mautic.page.form.saveprefs' => 'Save preferences',
    'mautic.page.form.successmessage' => 'Success messsage',
    'mautic.page.form.leadidentifier' => 'Lead identifier',
    'mautic.page.form.frequency.label1' => 'Frequency label 1',
    'mautic.page.form.frequency.label2' => 'Frequency label 2',
    'mautic.page.form.pause.label1' => 'Pause label 1',
    'mautic.page.form.pause.label2' => 'Pause label 2',
    'mautic.page.form.has_variants' => 'Has variants',
    'mautic.page.searchcommand.isprefcenter' => 'is:prefcenter',
    'mautic.page.result.header.index' => 'Results for %name%',
    'mautic.campaign.plugin.leadpush' => 'Push contact',
    'mautic.integration.callbackuri' => 'If applicable, use the following as the callback URL (may also be called the return URI) when configuring your application:',
    'mautic.integration.closewindow' => 'Close Window',
    'mautic.integration.error' => '%name% Error',
    'mautic.integration.error.generic_contact_name' => 'Contact ID# %id%',
    'mautic.integration.error.refreshtoken_expired' => 'The refresh token has expired. Re-authorization is required.',
    'mautic.integration.filter.all' => 'Show all plugins',
    'mautic.integration.form.authorize' => 'Authorize App',
    'mautic.integration.form.enabled' => 'Is enabled?',
    'mautic.integration.form.feature.login_button' => 'Login Button',
    'mautic.integration.form.feature.public_activity' => 'Display public activity',
    'mautic.integration.form.feature.public_profile' => 'Display public profile and enable profile to contact field matching',
    'mautic.integration.form.feature.push_lead' => 'Triggered action push contacts to integration',
    'mautic.integration.form.feature.settings' => 'Feature Specific Settings',
    'mautic.integration.form.feature.share_button' => 'Display share button on landing page social widget',
    'mautic.integration.form.feature.sso_service' => 'Single Sign On - Service Authentication',
    'mautic.integration.form.feature.sso_form' => 'Single Sign On - Form Authentication',
    'mautic.integration.form.features' => 'Enabled features',
    'mautic.integration.form.field_match_notes' => 'If the values are empty for the Mautic object, a value of \'Unknown\' will be sent. If the integration field is a pick list, be sure the list values of Mautic\'s field match those of the integration.',
    'mautic.integration.form.lead.unknown' => 'Unknown',
    'mautic.integration.form.profile' => 'Public Profile',
    'mautic.integration.form.reauthorize' => 'Reauthorize App',
    'mautic.integration.form.savefirst' => 'Required keys are missing in order to authenticate. Please enter the keys then save.',
    'mautic.integration.form.sharebutton' => 'Share Buttons',
    'mautic.integration.integrations' => 'Integrations',
    'mautic.integration.integration.tooltip' => 'Select the integration to be used.',
    'mautic.integration.keyfield.api' => 'API Key',
    'mautic.integration.keyfield.appid' => 'App ID',
    'mautic.integration.keyfield.appsecret' => 'App Secret',
    'mautic.integration.keyfield.clientid' => 'Client ID',
    'mautic.integration.keyfield.clientsecret' => 'Client Secret',
    'mautic.integration.keyfield.consumerid' => 'Consumer ID',
    'mautic.integration.keyfield.consumersecret' => 'Consumer Secret',
    'mautic.integration.keyfield.username' => 'Username',
    'mautic.integration.keyfield.password' => 'Password',
    'mautic.integration.leadfield_matches' => 'Assign available integration fields to local contact fields.',
    'mautic.integration.companyfield_matches' => 'Assign available integration fields to local company fields.',
    'mautic.integration.missingkeys' => 'Keys are not available for this transaction to take place. Please verify your settings then try again.',
    'mautic.integration.noresults.tip' => 'Expecting integrations but see none? Enable the associated addon via the Addon Manager! For example, the Social Media addon must be enabled in order for Facebook to be listed.',
    'mautic.integration.sso.auto_create_user' => 'Automatically create local user?',
    'mautic.integration.sso.auto_create_user.tooltip' => 'If the user is authenticated and does not exist locally, a new local user will be created.',
    'mautic.integration.sso.new_user_role' => 'Role for created user',
    'mautic.integration.sso.new_user_role.tooltip' => 'If new user creation is enabled, select the role the new user should be assigned.',
    'mautic.integrations.noresults' => '',
    'mautic.plugin.actions' => 'Addon actions',
    'mautic.plugin.actions.facebookLogin' => 'Facebook Login',
    'mautic.plugin.actions.push_lead' => 'Push contact to integration',
    'mautic.plugin.actions.social_share' => 'Social Networks Share Icons',
    'mautic.plugin.actions.social_share_tooltip' => 'Adds social network icons to share form',
    'mautic.plugin.actions.twitterLogin' => 'Twitter Login',
    'mautic.plugin.command.fetch.leads' => 'Command to fetch contacts from integration',
    'mautic.plugin.command.fetch.leads.starting' => 'Fetch contacts command is starting',
    'mautic.plugin.command.fetch.contacts.starting' => 'Fetching contacts...',
    'mautic.plugin.command.fetch.leads.events_executed' => 'Number of leads/contacts fetched: %events%',
    'mautic.plugin.command.fetch.leads.events_executed_breakout' => '%updated% contacts were updated and %created% contacts were created',
    'mautic.plugin.command.fetch.companies.events_executed' => 'Number of companies fetched: %events%',
    'mautic.plugin.command.fetch.companies.events_executed_breakout' => '%updated% companies were updated and %created% companies were created',
    'mautic.plugin.command.push.leads.events_executed' => 'Number of contacts processed: %events%',
    'mautic.plugin.form.add.fields' => 'Add Field',
    'mautic.plugin.plugins' => 'Plugins',
    'mautic.plugin.integration.tab.details' => 'Enabled/Auth',
    'mautic.plugin.integration.tab.features' => 'Features',
    'mautic.plugin.integration.tab.fieldmapping' => 'Contact Mapping',
    'mautic.plugin.integration.tab.companyfieldmapping' => 'Company Mapping',
    'mautic.plugin.manage.plugins' => 'Manage Plugins',
    'mautic.plugin.permissions.plugins' => 'Plugins - User has access to',
    'mautic.plugin.permissions.header' => 'Plugin Permissions',
    'mautic.plugin.point.action' => 'Addon triggers',
    'mautic.plugin.reload.plugins' => 'Install/Upgrade Plugins',
    'mautic.plugin.reload.plugins.tooltip' => 'Upload the plugin via FTP or some other protocol to the plugins directory then click this button to install/upgrade.',
    'mautic.integration.form.feature.get_leads' => 'Pull contacts and/or companies from integration',
    'mautic.plugin.command.push.leads.activity' => 'Push activity timeline to %integration% mautic object',
    'mautic.plugin.command.fetch.companies' => 'Fetching companies',
    'mautic.plugin.command.fetch.companies.starting' => 'Fetch companies command is starting',
    'mautic.plugin.command.pushing.leads' => 'Updating/creating leads from Mautic to %integration%',
    'mautic.plugin.command.fetch.pushing.leads.events_executed' => 'Number of contacts pushed: %updated% updated, %created% created, %errored% had errors and %ignored% were ignored (likely duplicates or didn\'t match field criteria)',
    'mautic.plugins.integration.fields' => 'Integration fields',
    'mautic.plugins.mautic.direction' => 'Direction',
    'mautic.plugins.mautic.fields' => 'Mautic fields',
    'mautic.plugin.direction.data.update' => 'Pick direction of data update',
    'mautic.integration.form.feature.push_leads' => 'Push contacts and/or companies to this integration',
    'mautic.plugin.integration.campaign_members' => 'Integration Campaign Members',
    'mautic.plugin.integration.contact.timeline.link' => 'Contact\'s timeline link',
    'mautic.plugin.integration.campaigns' => 'Push contacts to this integration campaign',
    'mautic.plugin.config.campaign.member.chooseone' => 'Choose a campaign to insert contacts into',
    'mautic.plugin.integration.campaigns.member.status' => 'Campaign member status',
    'mautic.integrations.blanks' => 'Update blank values',
    'mautic.integrations.form.blanks' => 'This will update blank values regardless of data priority, on both Integration and Mautic.',
    'mautic.plugin.command.notauthorized' => '%s is not authorized',
    'mautic.plugin.integration.contact.donotcontact.email' => 'Do not contact by email',
    'mautic.plugin.command.pushing.companies' => 'Updating/creating companies from Mautic to %integration%',
    'mautic.plugin.command.fetch.pushing.companies.events_executed' => 'Number of companies pushed: %updated% updated, %created% created, %errored% had errors and %ignored% were ignored (likely duplicates or didn\'t match field criteria)',
    'mautic.integrations.update.dnc.by.date' => 'Use latest updated Do Not Contact record',
    'mautic.integrations.form.update.dnc.by.date.label' => 'Select this option if you wish to update the Do not contact field by the latest updated on either systems',
    'mautic.point.point' => 'Point',
    'mautic.point.action.delta' => 'Change points (+/-)',
    'mautic.point.action.delta.help' => 'Set the number of points to be added or deducted for this action. If it is a positive number, it will be added to the contact\'s points. If negative, it will be deducted.',
    'mautic.point.action.noresults.tip' => 'Use point actions to adjust a contact\'s point score based on defined events. For example, give a contact 10 points if he/she opens a campaign email.',
    'mautic.point.actions.header.index' => 'Point Actions',
    'mautic.point.event.gained' => 'Point gained',
    'mautic.point.event.manual_change' => 'Manual change',
    'mautic.point.form.score_not_set' => 'Score not set',
    'mautic.point.form.no_point_groups' => 'There are no point groups available.',
    'mautic.point.form.addaction' => 'Use the list to the right to add an action.',
    'mautic.point.form.confirmbatchdelete' => 'Delete the selected point actions?',
    'mautic.point.form.confirmdelete' => 'Delete the point action, %name%?',
    'mautic.point.form.repeat' => 'Is repeatable',
    'mautic.protip.points.decay' => 'Implement a lead scoring decay model to accurately capture intent.',
    'mautic.protip.points.reduce' => 'Reduce scores systematically over time if contacts become inactive.',
    'mautic.protip.points.limit' => 'Use a limit to prevent scores from getting too high or low.',
    'mautic.protip.triggers.behavioral' => 'Use behavioral triggers to send timely, relevant emails based on user actions.',
    'mautic.point.form.type' => 'Action taken by contact',
    'mautic.point.form.repeat.help' => 'Enable to score leads multiple times for this action; disable for one-time scoring.',
    'mautic.point.form.repeat.yes' => 'Allow multiple scores',
    'mautic.point.form.repeat.no' => 'One-time scoring only',
    'mautic.point.menu.edit' => 'Edit Point Action',
    'mautic.point.menu.index' => 'Manage Actions',
    'mautic.point.menu.new' => 'New Point Action',
    'mautic.point.permissions.header' => 'Point Permissions',
    'mautic.point.permissions.points' => 'Point Actions - User has access to',
    'mautic.point.permissions.triggers' => 'Triggers - User has access to',
    'mautic.point.permissions.groups' => 'Groups - User has access to',
    'mautic.point.thead.action' => 'Action',
    'mautic.point.thead.delta' => 'Points +/-',
    'mautic.point.thead.group' => 'Group',
    'mautic.point.trigger.addevent' => 'Select an event from the \'Add an event\' list.',
    'mautic.point.trigger.event.add' => 'Add an event',
    'mautic.point.trigger.form.color' => 'Contact color',
    'mautic.point.trigger.form.color_descr' => 'Contacts with at least the number of points above will be designated this color.',
    'mautic.point.trigger.form.confirmbatchdelete' => 'Delete the selected triggers?',
    'mautic.point.trigger.form.confirmdelete' => 'Delete the trigger, %name%?',
    'mautic.point.trigger.form.existingleads' => 'Trigger for existing applicable contacts upon saving (if published)?',
    'mautic.point.trigger.form.modalheader' => 'Trigger Action Details',
    'mautic.point.trigger.form.points' => 'Minimum number of points',
    'mautic.point.trigger.form.points_descr' => 'Minimum number of points required in order to trigger associated actions.',
    'mautic.point.trigger.header.edit' => 'Edit Trigger',
    'mautic.point.trigger.header.index' => 'Point Triggers',
    'mautic.point.trigger.header.new' => 'New Trigger',
    'mautic.point.trigger.menu.edit' => 'Edit Trigger Event',
    'mautic.point.trigger.menu.index' => 'Manage Triggers',
    'mautic.point.trigger.noresults.tip' => 'Create a trigger to take some action with the contact once a certain point level is reached. You can adjust a contact\'s campaign, push to a CRM, send an email, etc. Define a color to easily see where your contacts are at a glance when viewing contact lists!',
    'mautic.point.trigger.tab.events' => 'Events',
    'mautic.point.trigger.thead.points' => 'Point Total',
    'mautic.point.trigger.thead.pointstrigger' => 'Trigger at Points',
    'mautic.point.group.menu.index' => 'Manage Groups',
    'mautic.point.group.menu.new' => 'New Group',
    'mautic.point.group.menu.edit' => 'Edit Group',
    'mautic.point.group.header.index' => 'Point Groups',
    'mautic.point.group.form.group' => 'Point group',
    'mautic.point.group.form.group_descr' => 'Choose the point group to which this applies. If no groups are selected, it will apply to the main contact points.',
    'mautic.point.group.form.nogroup' => 'None',
    'mautic.point.group.form.confirmdelete' => 'Delete the point group, %name%?',
    'mautic.points.menu.root' => 'Points',
    'mautic.point.dashboard.widgets' => 'Point Widgets',
    'mautic.widget.points.in.time' => 'Points in time',
    'mautic.point.changes' => 'Point changes',
    'mautic.point.group.report.table' => 'Group score',
    'mautic.point.report.group_id' => 'Group ID',
    'mautic.point.report.group_name' => 'Group name',
    'mautic.point.report.group_score' => 'Group score',
    'mautic.report.dashboard.widgets' => 'Report Widgets',
    'mautic.report.dashboard.widgets.full_report' => 'View Full Report',
    'mautic.protip.reports.dnc' => 'Track DNC comments to reinsert contacts bounced by temporary issues',
    'mautic.report.field.category_id' => 'Category ID',
    'mautic.report.field.category_name' => 'Category name',
    'mautic.report.field.date_added' => 'Date created',
    'mautic.report.field.date_modified' => 'Date last modified',
    'mautic.report.field.is_published' => 'Is published',
    'mautic.report.field.lead.label' => 'Contact %field%',
    'mautic.report.field.lead.address1' => 'Contact address 1',
    'mautic.report.field.lead.address2' => 'Contact address 2',
    'mautic.report.field.lead.city' => 'Contact city',
    'mautic.report.field.lead.company' => 'Contact company',
    'mautic.report.field.lead.country' => 'Contact country',
    'mautic.report.field.lead.email' => 'Contact email',
    'mautic.report.field.lead.firstname' => 'Contact first name',
    'mautic.report.field.lead.id' => 'Contact ID',
    'mautic.report.field.lead.lastname' => 'Contact last name',
    'mautic.report.field.lead.mobile' => 'Contact mobile',
    'mautic.report.field.lead.phone' => 'Contact phone',
    'mautic.report.field.lead.position' => 'Contact position',
    'mautic.report.field.lead.state' => 'Contact state',
    'mautic.report.field.lead.title' => 'Contact title',
    'mautic.report.field.lead.zipcode' => 'Contact zip code',
    'mautic.report.field.modified_by_user' => 'Last modified by',
    'mautic.report.field.publish_down' => 'Set as unavailable on',
    'mautic.report.field.utm_campaign' => 'UTM Campaign',
    'mautic.report.field.utm_content' => 'UTM Content',
    'mautic.report.field.utm_medium' => 'UTM Medium',
    'mautic.report.field.utm_source' => 'UTM source',
    'mautic.report.field.utm_term' => 'UTM Term',
    'mautic.report.field.publish_up' => 'Set as available on',
    'mautic.report.field.source' => 'Original source',
    'mautic.report.field.source_id' => 'Original source ID',
    'mautic.report.graph.bar' => 'Bar graph',
    'mautic.report.graph.line' => 'Line graph',
    'mautic.report.graph.pie' => 'Pie chart',
    'mautic.report.graph.table' => 'Table',
    'mautic.report.permissions.header' => 'Reporting Permissions',
    'mautic.report.permissions.reports' => 'Reports - User has access to',
    'mautic.widget.report' => 'Report Graph',
    'mautic.report.report.form.columnselector' => 'Columns',
    'mautic.report.report.form.confirmbatchdelete' => 'Delete the selected reports?',
    'mautic.report.report.form.confirmdelete' => 'Delete the report, %name%?',
    'mautic.report.report.form.graphs' => 'Graphs/tables to include in the report',
    'mautic.report.report.form.displayBeforeTables' => 'Display graphs before tables',
    'mautic.report.report.form.owner' => 'Owner',
    'mautic.report.report.form.issystem' => 'Visible for all logged-in users',
    'mautic.report.report.form.issystem.tooltip' => 'Setting this to "No" will make it visible to you and roles with permission to view other users\' reports.',
    'mautic.report.report.form.display.dynamic.filters.settings' => 'Dynamic filters settings',
    'mautic.report.report.form.display.graphs.above.table' => 'Display graphs above table data on report page',
    'mautic.report.report.form.display.show.dynamic.filters' => 'Opened by default',
    'mautic.report.report.form.display.hide.date.ranges' => 'Hide date range',
    'mautic.report.report.form.source' => 'Data Source',
    'mautic.report.report.form.source.help' => 'Choose the data source to use for this report. Changing this will clear your existing column and filter selections.',
    'mautic.report.report.form.choose_graphs' => 'Choose a graph',
    'mautic.report.report.header.edit' => 'Edit Report - %name%',
    'mautic.report.report.header.new' => 'New Report',
    'mautic.report.report.header.view' => 'View Report - %name%',
    'mautic.report.report.label.addfilter' => 'Add Filter',
    'mautic.report.report.label.addtableorder' => 'Add Order',
    'mautic.report.report.label.availablecolumns' => 'Available Columns',
    'mautic.report.report.label.filtercolumn' => 'Column',
    'mautic.report.report.label.filtercondition' => 'Condition',
    'mautic.report.report.label.filterdynamic' => 'Dynamic?',
    'mautic.report.report.label.filterdynamic_tooltip' => 'If this is set to yes, this filter will be available in the list view for dynamic filtering of this report.',
    'mautic.report.report.label.filtervalue' => 'Value',
    'mautic.report.report.label.removefilter' => 'Remove filter',
    'mautic.report.report.label.clonefilter' => 'Clone filter',
    'mautic.report.report.label.selectedcolumns' => 'Selected Columns',
    'mautic.report.report.label.tableorder_dir.asc' => 'Ascending',
    'mautic.report.report.label.tableorder_dir.desc' => 'Descending',
    'mautic.report.report.menu.index' => 'Manage Reports',
    'mautic.report.report.noresults' => 'No data returned for this report',
    'mautic.report.report.tooltip.selected.columns' => 'The order of the columns in this box is the order in which they will be displayed on the report. Please use the buttons to order the columns.',
    'mautic.report.reports' => 'Reports',
    'mautic.report.tab.data' => 'Data',
    'mautic.report.tab.graphs' => 'Graphs',
    'mautic.report.tab.schedule' => 'Schedule',
    'mautic.report.table.noresults' => 'No results found. Consider changing your data filters.',
    'mautic.report.campaign.channel.category_id' => 'Channel Item: Category ID',
    'mautic.report.campaign.channel.created_by' => 'Channel Item: Created by',
    'mautic.report.campaign.channel.created_by_user' => 'Channel Item: Created by name',
    'mautic.report.campaign.channel.date_added' => 'Channel Item: Date added',
    'mautic.report.campaign.channel.description' => 'Channel Item: Description',
    'mautic.report.campaign.channel.name' => 'Channel Item: Name',
    'mautic.report.form.groupby' => 'Group by',
    'mautic.core.calculated.fields' => 'Calculated columns',
    'mautic.report.report.label.function' => 'Add function',
    'mautic.report.report.label.aggregators.count' => 'COUNT',
    'mautic.report.report.label.aggregators.avg' => 'AVG',
    'mautic.report.report.label.aggregators.sum' => 'SUM',
    'mautic.report.report.label.aggregators.min' => 'MIN',
    'mautic.report.report.label.aggregators.max' => 'MAX',
    'mautic.report.function' => 'Function',
    'mautic.report.report.groupby.totals' => 'Totals',
    'mautic.report.report.glue.choice.and' => 'And',
    'mautic.report.report.glue.choice.or' => 'Or',
    'mautic.report.schedule.isScheduled' => 'Email report',
    'mautic.report.schedule.toAddress.label' => 'To',
    'mautic.report.schedule.toAddress.tooltip' => 'Separate multiple emails with a comma',
    'mautic.report.schedule.every' => 'Every',
    'mautic.report.schedule.day' => 'On',
    'mautic.report.schedule.month_frequency' => 'On the',
    'mautic.report.schedule.unit.now' => 'now',
    'mautic.report.schedule.unit.day' => 'day',
    'mautic.report.schedule.unit.week' => 'week',
    'mautic.report.schedule.unit.month' => 'month',
    'mautic.report.schedule.day.monday' => 'Monday',
    'mautic.report.schedule.day.tuesday' => 'Tuesday',
    'mautic.report.schedule.day.wednesday' => 'Wednesday',
    'mautic.report.schedule.day.thursday' => 'Thursday',
    'mautic.report.schedule.day.friday' => 'Friday',
    'mautic.report.schedule.day.saturday' => 'Saturday',
    'mautic.report.schedule.day.sunday' => 'Sunday',
    'mautic.report.schedule.day.week_days' => 'Weekdays',
    'mautic.report.schedule.month_frequency.first' => 'First',
    'mautic.report.schedule.month_frequency.last' => 'Last',
    'mautic.report.schedule.preview_data' => 'Example dates report will be sent:',
    'mautic.report.schedule.email.subject' => 'Report %report_name% - %date%.',
    'mautic.report.schedule.email.message' => 'The report <a href=%link%>%report_name%</a> generated at %date% is attached.',
    'mautic.report.schedule.email.message_file_not_attached' => 'The file is too big to be sent via email, click the link to view this report:  <a href=%link%>%report_name%</a>.',
    'mautic.report.schedule.email.message_file_linked' => 'Click here to download the report: <a href=%link%>%report_name%</a>.',
    'mautic.report.schedule.command.finished' => 'Scheduler has finished',
    'mautic.report.schedule.command.invalid_parameter' => 'Parameter report has to be number',
    'mautic.report.download.missing' => 'Report %id% does not have a CSV generated yet. But it has a scheduled report configured.',
    'mautic.report.download.missing.but.scheduled' => 'Report %id% does not have a CSV generated yet. But it has been requested with your attempt to download it. You will receive email notification as soon as it is generated.',
    'mautic.report.dashboard.widgets.no_report_found' => '<strong>Oh snap!</strong> Report has been deleted or no data has been found.',
    'mautic.config.tab.reportconfig' => 'Report Settings',
    'mautic.config.tab.form.csv_always_enclose' => 'Always quote data in CSV export',
    'mautic.config.tab.form.csv_always_enclose.tooltip' => 'Enable this if the application used to open the CSV requires values to be quoted with double quotations. For example: &#34;Firstname&#34;,&#34;&#34;,&#34;Lastname&#34;',
    'mautic.report.notfound' => 'Report with ID %id% was not found.',
    'mautic.report.export.and.send' => 'Export & Send',
    'mautic.format.invalid' => 'Format %format% is not supported. Supported formats are: %validFormats%.',
    'mautic.report.is.scheduled' => 'This report is scheduled to be sent by email',
    'mautic.campaign.sms.reply' => 'Sends a text message',
    'mautic.campaign.sms.reply.tooltip' => 'Contact sent or replied to a text message',
    'mautic.campaign.sms.send_text_sms' => 'Send text message',
    'mautic.sms.timeline.event.custom_sms' => 'Custom text message',
    'mautic.campaign.sms.send_text_sms.tooltip' => 'Sends a text/sms to the contact.',
    'mautic.lead.list.filter.dnc_bounced_sms' => 'Bounced - SMS',
    'mautic.lead.list.filter.dnc_unsubscribed_sms' => 'Unsubscribed - SMS',
    'mautic.lead.timeline.sms.sms.reply' => 'Text message received from contact',
    'mautic.sms.timeline.reply' => 'Text message received',
    'mautic.sms.text' => 'Text Message Content',
    'mautic.sms.placeholder' => 'Message content here...',
    'mautic.config.tab.smsconfig' => 'Text Message Settings',
    'mautic.sms.config.form.sms.enabled' => 'Text Message Enabled?',
    'mautic.sms.config.form.sms.enabled.tooltip' => 'Enable Text Message support in your campaigns?',
    'mautic.sms.config.form.sms.username' => 'Account SID',
    'mautic.sms.config.form.sms.username.tooltip' => 'Twilio Account SID',
    'mautic.sms.config.form.sms.password' => 'Auth Token',
    'mautic.sms.config.form.sms.password.tooltip' => 'Twilio Auth Token',
    'mautic.sms.config.form.sms.messaging_service_sid' => 'Messaging Service SID',
    'mautic.sms.config.form.sms.messaging_service_sid.tooltip' => 'The messaging service SID given by your provider that you use to send and receive Text Message messages.',
    'mautic.sms.config.form.sms.disable_trackable_urls' => 'Disable click tracking',
    'mautic.sms.config.form.sms.disable_trackable_urls.tooltip' => 'This option will disable click tracking for URLs in the text message.',
    'mautic.protip.sms.concise' => 'Keep messages concise and action-oriented to respect the personal nature of SMS',
    'mautic.protip.sms.timesensitive' => 'Use SMS for time-sensitive information like appointment reminders or limited-time offers',
    'mautic.protip.sms.compliance' => 'Comply with regulations by including opt-out instructions',
    'mautic.sms.sms' => 'Text Message',
    'mautic.sms.smses' => 'Text Messages',
    'mautic.sms.campaign.send_sms' => 'Send Push Text Message',
    'mautic.sms.campaign.send_sms.tooltip' => 'Sends a push sms to the user.',
    'mautic.sms.choose.smss' => 'Select a text message to send.',
    'mautic.sms.form.action.sendsms.admin' => 'Send sms to user',
    'mautic.sms.form.action.sendsms.admin.descr' => 'Send the selected sms to the selected user(s) upon form submission.',
    'mautic.sms.form.action.sendsms.lead' => 'Send sms to contact',
    'mautic.sms.form.action.sendsms.lead.descr' => 'Send the selected sms to the contact upon form submission.',
    'mautic.sms.form.body' => 'Body',
    'mautic.sms.form.confirmbatchdelete' => 'Delete the selected smses?',
    'mautic.sms.form.confirmdelete' => 'Delete the sms, %name%?',
    'mautic.sms.form.confirmsend' => 'Queue, %name%, for sending?',
    'mautic.sms.form.internal.name' => 'Internal Name',
    'mautic.sms.form.list' => 'Contact list',
    'mautic.sms.form.nbcharacter.counter' => 'Character count: ',
    'mautic.sms.form.nbcharacter.infobox' => 'One SMS is built with 160 characters. Most of the time, your SMS router will charge you 2 or more SMS if you go over this amount of characters.',
    'mautic.sms.header.edit' => 'Edit Text Message - %name%',
    'mautic.sms.header.new' => 'New Text Message',
    'mautic.sms.text.tooltip' => 'Your sms content',
    'mautic.sms.headings' => 'Text Message Title',
    'mautic.sms.headings.tooltip' => 'Your sms title',
    'mautic.sms.link' => 'Link',
    'mautic.sms.link.placeholder' => 'http://',
    'mautic.sms.link.tooltip' => 'When the user clicks the sms, where do you want to send them?',
    'mautic.sms.reply_pattern' => 'Pattern the reply should match',
    'mautic.sms.reply_pattern.tooltip' => 'Type the pattern the reply must match in order for this decision to be acknowledged. Leave blank to match any message. You can use an asterisk * for wildcard string matching or ? for a single character. To match the asterisks or question marks themselves, surround them in bars like [?].',
    'mautic.sms.stats' => 'Text Message Stats',
    'mautic.sms.stats.report.table' => 'Text Messages Sent',
    'mautic.sms.stat.leadcount' => '%count% Pending',
    'mautic.sms.stat.readcount' => '%count% Read',
    'mautic.sms.stat.sentcount' => '%count% Sent',
    'mautic.sms.type.header' => 'What type of SMS do you want to create?',
    'mautic.sms.type.list' => 'Segment Text Messages',
    'mautic.sms.type.list.header' => 'Segment text message',
    'mautic.sms.icon_tooltip.list_sms' => 'Is a segment (broadcast) SMS',
    'mautic.sms.type.list.description' => 'A segment SMS can be manually sent to selected contact segments. Once the SMS has been sent, it cannot be edited. However, it can be sent to new contacts as they are added to the associated segments.',
    'mautic.sms.type.template' => 'Triggered Text Messages',
    'mautic.sms.type.template.header' => 'Triggered text message',
    'mautic.sms.type.template.description' => 'A triggered SMS is automatically sent by campaigns, forms, point events, etc. These can be edited but cannot be sent to a contact list.',
    'mautic.sms.form.internal.description' => 'Description',
    'mautic.sms.form.heading' => 'Heading',
    'mautic.sms.form.url' => 'Link',
    'mautic.sms.form.url.tooltip' => 'The destination the user is sent to when they click the SMS.',
    'mautic.sms.form.message' => 'Text Message',
    'mautic.sms.send.selectsmses' => 'Select Text Message',
    'mautic.sms.choose.smses' => 'Select the SMS to send to the user.',
    'mautic.sms.send.new.sms' => 'New Text Message',
    'mautic.sms.send.edit.sms' => 'Edit Text Message',
    'mautic.sms.send.preview.sms' => 'Preview Text Message',
    'mautic.sms.send.selectsmss' => 'Select Message',
    'mautic.sms.no.smses.note' => 'Please create a new Text Message message to select.',
    'mautic.sms.smses.header.preview' => 'Preview Text Message',
    'mautic.sms.preview' => 'Preview',
    'mautic.sms.timeline.status' => 'Status',
    'mautic.sms.timeline.type' => 'Type',
    'mautic.sms.timeline.status.delivered' => 'Delivered',
    'mautic.sms.timeline.status.sent' => 'Sent',
    'mautic.sms.timeline.status.failed' => 'Failed',
    'mautic.sms.timeline.status.scheduled' => 'Scheduled',
    'mautic.sms.timeline.content.heading' => 'Message Content',
    'mautic.sms.timeline.event.list' => 'Text message was sent to this contact because they belong to the \'%list%\' segment.',
    'mautic.sms.timeline.event.failed' => 'Sending text message failed',
    'mautic.sms.disabled' => 'Text Messages are currently disabled',
    'mautic.sms.enable.in.configuration' => 'Enable and configure Text Messages in the Mautic configuration.',
    'mautic.sms.create.in.campaign.builder' => 'Seems there are none! Try changing a filter (if applicable) or create a new one in the Campaign Builder.',
    'mautic.sms.campaign.failed.not_contactable' => 'Contact is not contactable on the SMS channel.',
    'mautic.sms.campaign.failed.missing_number' => 'Missing phone number for contact.',
    'mautic.sms.campaign.failed.missing_entity' => 'The specified SMS entity does not exist.',
    'mautic.sms.campaign.failed.unpublished' => 'The specified SMS was unpublished.',
    'mautic.sms.show.total.sent' => 'Total sent',
    'mautic.sms.show.failed' => 'Failed',
    'mautic.sms.permissions.header' => 'Text Message Permissions',
    'mautic.sms.permissions.smses' => 'Text Messages - User has access to',
    'mautic.sms.list.frequency.number' => 'Do not send text message more than',
    'mautic.sms.config.select_default_transport' => 'Select default transport to use',
    'mautic.sms.config.no_transport' => 'No transport enabled',
    'mautic.sms.config.choose_transport' => 'Select transport',
    'mautic.sms.config.smsconfig' => 'Please, install messaging transport first.',
    'mautic.sms.transport.twilio' => 'Twilio',
    'mautic.sms.transport.twilio.not_configured' => 'Twilio is not configured.',
    'mautic.sms.webhook.event.send' => 'Text Send Event',
    'mautic.sms.token.dropdown.hint' => 'Hint: In text message area, entering { shows a token dropdown.',
    'mautic.stage.stage' => 'Stage',
    'mautic.stage.action.noresults.tip' => 'Use stage actions to adjust a contact\'s stage score based on defined events. For example, give a contact 10 stages if he/she opens a campaign email.',
    'mautic.stage.actions.header.index' => 'Stages',
    'mautic.stage.campaign.event.change' => 'Change contact\'s stage',
    'mautic.stage.campaign.event.change.descr' => 'This campaign will change a contacts stage if a contact is on a stage with lower weight.',
    'mautic.stage.campaign.event.stage_missing' => 'Stage is missing or unpublished',
    'mautic.stage.campaign.event.stage_invalid' => 'Contact was not able to move into this stage.',
    'mautic.stage.campaign.event.already_in_stage' => 'Contact is already in this stage.',
    'mautic.stage.event.changed' => 'Stage changed',
    'mautic.stage.event.added.batch' => 'Manually Added',
    'mautic.stage.event.removed.batch' => 'Manually Removed',
    'mautic.stage.import.action.name' => 'Import by %name%',
    'mautic.stage.form.addaction' => 'Use the list to the right to add an action.',
    'mautic.stage.form.confirmbatchdelete' => 'Delete the selected stage actions?',
    'mautic.stage.form.confirmdelete' => 'Delete the stage action, %name%?',
    'mautic.stage.form.type' => 'When a contact...',
    'mautic.stage.menu.edit' => 'Edit Stage Action',
    'mautic.stage.menu.new' => 'New Stage Action',
    'mautic.stages.menu.root' => 'Stages',
    'mautic.stage.permissions.header' => 'Stage Permissions',
    'mautic.stage.permissions.stages' => 'Stage Actions - User has access to',
    'mautic.stage.permissions.triggers' => 'Triggers - User has access to',
    'mautic.stage.thead.action' => 'Action',
    'mautic.stage.timeline.event.stage.change' => '<strong>Stage changed to:</strong> <strong class=\'text-primary\'>%name%</strong>',
    'mautic.stages.menu.index' => 'Stages',
    'mautic.stage.dashboard.widgets' => 'Stage Widgets',
    'mautic.widget.stages.in.time' => 'Stages in time',
    'mautic.stage.changes' => 'Stage changes',
    'mautic.stage.action.weight' => 'Weight',
    'mautic.stage.action.weight.help' => 'This will help you determine if a contact moves forward to a stage, a contact cannot change to a stage of lower weight',
    'mautic.asset.stage.action.assets' => 'These assets',
    'mautic.asset.stage.action.assets.descr' => 'When a contact downloads selected assets',
    'mautic.form.stage.action.forms' => 'Select form',
    'mautic.form.stage.action.forms.descr' => 'When a contact submits this form',
    'mautic.page.stage.action.form.pages' => 'Select page',
    'mautic.page.stage.action.form.pages.descr' => 'When a contact visits this page',
    'mautic.page.stage.action.form.page.url' => 'URL',
    'mautic.page.stage.action.form.page.url.descr' => 'When a contact visit this url',
    'mautic.page.stage.action.form.accumulative.time' => 'Number of visits',
    'mautic.page.stage.action.form.accumulative.time.descr' => 'When a contact reaches this number of visits',
    'mautic.page.stage.action.form.returns.within' => 'Number of days',
    'mautic.page.stage.action.form.returns.within.descr' => 'When a contact returns within this number of days',
    'mautic.page.stage.action.form.returns.after' => 'Returns after',
    'mautic.page.stage.action.form.returns.after.descr' => 'Returns after this number of days',
    'mautic.stage.selectstage' => 'Select stage',
    'mautic.stage.choose.stage_descr' => 'Select stage that will be assigned to contacts in this campaign',
    'mautic.campaign.stage.change' => 'Change contact\'s stage',
    'mautic.user.account.header.authorizedclients' => 'Authorized Applications',
    'mautic.user.account.header.details' => 'Account Details',
    'mautic.user.account.permissions.editall' => 'All',
    'mautic.user.account.permissions.editemail' => 'Email',
    'mautic.user.account.permissions.editname' => 'Name',
    'mautic.user.account.permissions.editposition' => 'Position',
    'mautic.user.account.permissions.editusername' => 'Username',
    'mautic.user.account.settings' => 'Account',
    'mautic.user.auth.error.invalidlogin' => 'Invalid login. Please verify credentials.',
    'mautic.user.auth.expired.header' => 'Session expired - please login',
    'mautic.user.auth.form.loginbtn' => 'Login',
    'mautic.user.auth.form.loginusername' => 'Username or email',
    'mautic.user.auth.form.rememberme' => 'Keep me logged in',
    'mautic.user.auth.form.rolename' => 'Role Name',
    'mautic.user.auth.header' => 'Please Login',
    'mautic.user.auth.logout' => 'Logout',
    'mautic.user.permissions.header' => 'User Permissions',
    'mautic.user.permissions.profile' => 'Profile - User can edit',
    'mautic.user.permissions.roles' => 'Roles - User has access to',
    'mautic.user.permissions.users' => 'Users - User has access to',
    'mautic.user.profile.invite' => 'Invite your team',
    'mautic.user.account.accessibility' => 'Accessibility',
    'mautic.user.account.accessibility.appearance' => 'Appearance',
    'mautic.user.account.accessibility.enabled' => 'Enabled',
    'mautic.user.account.accessibility.disabled' => 'Disabled',
    'mautic.user.account.accessibility.smooth_color_transitions' => 'Smooth color transitions',
    'mautic.user.account.accessibility.smooth_color_transitions_help' => 'Adjust animation speed for color changes to enhance visual comfort and reduce motion.',
    'mautic.user.account.accessibility.transitions_enabled_description' => 'Smooth, gradual color transitions between states',
    'mautic.user.account.accessibility.transitions_disabled_description' => 'Instant color changes without animations',
    'mautic.user.account.accessibility.borders_outline_style' => 'Borders and outline style',
    'mautic.user.account.accessibility.borders_outline_style_help' => 'Enhance visual cues for interactive elements to improve navigation and focus.',
    'mautic.user.account.accessibility.borders_disabled_description' => 'Default appearance without additional borders',
    'mautic.user.account.accessibility.borders_enabled_description' => 'Strong borders around clickable elements and dashed outline style on focus',
    'mautic.user.account.accessibility.reduce_transparency_blur' => 'Reduce transparency and blur',
    'mautic.user.account.accessibility.reduce_transparency_blur_help' => 'Adjust the transparency and blur effects to improve readability and visual clarity.',
    'mautic.user.account.accessibility.normal' => 'Normal',
    'mautic.user.account.accessibility.transparency_normal_description' => 'Default transparency and blur effects',
    'mautic.user.account.accessibility.reduced' => 'Reduced',
    'mautic.user.account.accessibility.transparency_reduced_description' => 'No transparency and blur',
    'mautic.user.account.accessibility.underlines_disabled_description' => 'Links without underlines',
    'mautic.user.account.accessibility.underlines_enabled_description' => 'Underlines visible on links',
    'mautic.user.account.accessibility.content' => 'Content',
    'mautic.user.account.accessibility.link_underlines' => 'Link underlines',
    'mautic.user.account.accessibility.link_underlines_help' => 'Toggle the visibility of underlines on links across the interface.',
    'mautic.user.account.appearance' => 'Appearance',
    'mautic.user.account.appearance.theme_preferences' => 'Theme preferences',
    'mautic.user.account.appearance.theme_preferences.popover.title' => 'What are solarized color themes?',
    'mautic.user.account.appearance.theme_preferences.popover.content' => 'They\'re designed scientifically to reduce eye strain and make reading easier by using balanced, soft colors that improve visibility and comfort, especially when used for long periods.',
    'mautic.user.account.appearance.theme_help' => 'Choose your preferred theme for the interface.',
    'mautic.user.account.appearance.accent_colors' => 'Accent colors',
    'mautic.user.account.appearance.accent_help' => 'Make Mautic uniquely yours by selecting a color for various highlights.',
    'mautic.user.account.appearance.accent_toggletip.title' => 'Why can\'t I change for some themes?',
    'mautic.user.account.appearance.accent_toggletip.content' => 'Accent colors are available only for the default light and dark themes, as custom themes might be designed to use specific color schemes.',
    'mautic.user.account.appearance.theme_light' => 'Light (Default)',
    'mautic.user.account.appearance.theme_light_description' => 'Standard light theme for a bright, clean interface',
    'mautic.user.account.appearance.theme_dark' => 'Dark',
    'mautic.user.account.appearance.theme_dark_description' => 'Dark theme for reduced eye strain in low-light environments',
    'mautic.user.account.appearance.theme_solarized_light' => 'Solarized Light',
    'mautic.user.account.appearance.theme_solarized_light_description' => 'Light theme with warm, muted colors for comfortable reading',
    'mautic.user.account.appearance.theme_solarized_dark' => 'Solarized Dark',
    'mautic.user.account.appearance.theme_solarized_dark_description' => 'Dark theme with carefully chosen hues for optimal contrast',
    'mautic.user.account.appearance.theme_freire' => 'Freire',
    'mautic.user.account.appearance.theme_freire_description' => 'Community inspired theme celebrating diversity and collaboration using Mautic colors',
    'mautic.user.user.searchcommand.isadmin.description' => 'Filters for users with administrative privileges',
    'mautic.user.user.searchcommand.position.description' => 'Filters users by their position in the organization',
    'mautic.user.user.searchcommand.role.description' => 'Filters users by their assigned role',
    'mautic.user.user.searchcommand.username.description' => 'Searches for users by their username',
    'mautic.user.role' => 'Role',
    'mautic.user.role.form.confirmbatchdelete' => 'Delete the selected roles?',
    'mautic.user.role.form.confirmdelete' => 'Delete the role, %name%?',
    'mautic.user.role.form.isadmin' => 'Has full system access',
    'mautic.user.role.form.isadmin.tooltip' => 'If set to yes, any user assigned to this role will have full access to all areas. If no, configure the permissions via the Permissions tab.',
    'mautic.user.role.header.edit' => 'Roles - Edit %name%',
    'mautic.user.role.header.new' => 'Roles - New Role',
    'mautic.user.role.permission.isadmin.header' => 'Full access granted',
    'mautic.user.role.permission.isadmin.message' => 'The role is set to have full access granted. To adjust individual permissions, disable full access on the Details tab.',
    'mautic.user.role.permissions' => 'Permissions',
    'mautic.user.role.usercount' => 'Number of users in this role',
    'mautic.user.roles' => 'Roles',
    'mautic.user_management' => 'User management',
    'mautic.user.role.list.viewusers_count' => '{0} No Users|{1} View 1 User|]1,Inf[ View %count% Users',
    'mautic.user.role.list.thead.usercount' => 'User Count',
    'mautic.user.user.contact.locked' => 'Regarding %entityName% - unlock request',
    'mautic.user.user.contact.message' => 'Message',
    'mautic.user.user.contact.regarding' => 'Regarding %entityName%',
    'mautic.user.user.contact.send' => 'Send',
    'mautic.user.user.emailchange.subject' => 'Mautic email changed',
    'mautic.user.user.emailchange.email.body' => 'Hi %name%,\\n\\nwe would like to inform you that your account email has been changed. If you initiated this change, you do not need to take any additional action.\\n\\nIf you have not changed your password, please contact our technical support team immediately.',
    'mautic.user.user.filter.email' => 'By Email',
    'mautic.user.user.filter.name' => 'By Name',
    'mautic.user.user.filter.role' => 'By Role',
    'mautic.user.user.filter.username' => 'By Username',
    'mautic.user.user.form.confirmbatchdelete' => 'Delete the selected users?',
    'mautic.user.user.form.confirmdelete' => 'Delete the account of %name%?',
    'mautic.user.user.form.defaultlocale' => 'System Default Locale',
    'mautic.user.user.form.defaulttimezone' => 'System Default Timezone',
    'mautic.user.user.form.help.passwordrequirements' => 'Your password must be at least 6 characters and should use a combination of upper and lower case, special characters and numbers.',
    'mautic.user.user.form.passwordconfirm' => 'Confirm Password',
    'mautic.user.user.form.passwordplaceholder' => 'Leave empty for no change',
    'mautic.user.user.header.contact' => 'Send Message to %name%',
    'mautic.user.user.header.edit' => 'Users - Edit %name%',
    'mautic.user.user.header.new' => 'Users - New User',
    'mautic.user.user.help.searchcommands' => '<strong>Search commands</strong><br />ids:ID1,ID2 (comma separated IDs, no spaces)<br />is:admin<br />is:active<br />is:inactive<br />email:*<br />name:*<br />position:*<br />role:*<br />username:*',
    'mautic.user.user.passwordreset.back' => 'Back to login',
    'mautic.user.user.passwordreset.body' => 'Hi %name%,\\n\\nYour new password is \\n%password%\\n\\nIt is recommended that you login now and change it.',
    'mautic.user.user.passwordreset.email.body' => 'Hi %name%,\\n\\nYou requested a password reset. Click the link below to reset your password.\\n\\n%resetlink%',
    'mautic.user.user.passwordreset.info' => 'Enter either your username or email to reset your password. Instructions to reset your password will be sent to the email in your profile.',
    'mautic.user.user.passwordresetconfirm.info' => 'Enter either your username or email and your new password to complete the reset process.',
    'mautic.user.user.passwordreset.link' => 'Forgot your password?',
    'mautic.user.user.passwordreset.reset' => 'Reset password',
    'mautic.user.user.passwordreset.subject' => 'Mautic password reset',
    'mautic.user.user.passwordreset.password.placeholder' => 'Password',
    'mautic.user.user.passwordreset.confirm.placeholder' => 'Confirm Password',
    'mautic.user.user.passwordchange.subject' => 'Mautic password changed',
    'mautic.user.user.passwordchange.email.body' => 'Hi %name%,\\nwe would like to inform you that your account password has been changed. If you initiated this change, you do not need to take any additional action.\\nIf you have not changed your password, please contact our technical support team immediately.',
    'mautic.user.user.searchcommand.isadmin' => 'is:admin',
    'mautic.user.user.searchcommand.position' => 'position',
    'mautic.user.user.searchcommand.role' => 'role',
    'mautic.user.user.searchcommand.username' => 'username',
    'mautic.user.users' => 'Users',
    'mautic.config.tab.userconfig' => 'User/Authentication Settings',
    'mautic.user.config.form.saml.idp_attributes' => 'Enter the names of the attributes the configured IDP uses for the following Mautic user fields.',
    'mautic.user.config.form.saml.idp.attribute_email' => 'Email',
    'mautic.user.config.form.saml.idp.attribute_username' => 'Username (optional)',
    'mautic.user.config.form.saml.idp.attribute_firstname' => 'First name',
    'mautic.user.config.form.saml.idp.attribute_lastname' => 'Last name',
    'mautic.user.config.form.saml.idp_entity_id_label' => 'Entity ID for the IDP',
    'mautic.user.config.form.saml.idp.default_role' => 'Default role for created users',
    'mautic.user.config.form.saml.idp.default_role.tooltip' => 'Choose the default role to assign newly created users. To disable creating users, clear the selected role and leave empty.',
    'mautic.user.config.form.saml.idp.disable_creation' => 'Leave empty to disable user creation',
    'mautic.user.config.form.saml.idp.metadata' => 'Identity provider metadata file',
    'mautic.user.config.form.saml.idp.metadata.tooltip' => 'Upload the Identity Provider Metadata XML file.',
    'mautic.user.config.form.saml.idp.own_certificate.description' => 'Use a custom X.509 certificate and private key to secure communication between Mautic and the IDP.',
    'mautic.user.config.form.saml.idp.own_certificate' => 'X.509 certificate',
    'mautic.user.config.form.saml.idp.own_certificate.tooltip' => 'Upload a custom X.509 certificate to secure communication between the IDP and Mautic.',
    'mautic.user.config.form.saml.idp.own_entity_id' => 'Entity ID',
    'mautic.user.config.form.saml.idp.own_private_key' => 'Private key',
    'mautic.user.config.form.saml.idp.own_private_key.tooltip' => 'Upload the private key for the certificate to secure communication between the IDP and Mautic.',
    'mautic.user.config.form.saml.idp.own_password' => 'Private key encryption password',
    'mautic.user.config.form.saml.idp.own_password.tooltip' => 'If the private key is encrypted with a password, enter it here.',
    'mautic.user.config.header.saml' => 'SAML SSO Settings',
    'mautic.user.config.title.get_to_know_you' => 'Let\'s get to know you',
    'mautic.user.config.title.account_data_security' => 'Account data and security',
    'mautic.user.config.title.experience_and_learning' => 'Experience and learning',
    'mautic.user.config.title.experience_and_learning.description' => 'Customize your journey to make the most of your experience.',
    'mautic.user.config.title.experience_and_learning.reset_dismissed' => 'Restart all dismissed tips',
    'mautic.user.config.title.locale' => 'Locale',
    'mautic.user.config.title.personal_information' => 'Personal information',
    'mautic.user.config.personalize.interface.helper' => 'Manage details used to personalize your interface experience.',
    'mautic.user.config.account.security.helper' => 'Adjust your credentials to keep your account secure.',
    'mautic.user.config.region.preferences.helper' => 'Set preferences related to your region.',
    'mautic.user.config.signature.helper' => 'You can use the |FROM_NAME| variable in your signature to automatically insert the sender\'s name.',
    'mautic.user.config.signature.admin.helper' => 'Use |FROM_NAME| in the signature to automatically insert the user\'s name.',
    'mautic.user.user.form.user' => 'User',
    'mautic.user.user.form.created_by' => 'was created by',
    'mautic.user.user.form.updated_by' => 'Updated by',
    'mautic.user.user.form.login_by' => 'logged in',
    'mautic.user.lastlogin' => 'Last login',
    'mautic.user.user.form.update_user_status' => 'information by',
    'mautic.user.user.form.update_update' => 'Updated',
    'mautic.role.role' => 'Role',
    'mautic.user.role.form.updated_by' => 'was updated by',
    'mautic.config.tab.webhookconfig' => 'Webhook Settings',
    'mautic.webhook.config.cron_process' => 'Queue Events Only - Process Via CLI Command',
    'mautic.webhook.config.form.queue.mode.tooltip' => 'Select how to process webhook events. Process immediately will execute the webhook event. Queue mode will only add the event the queue and it must be processed by a cron command.',
    'mautic.webhook.config.form.queue.mode' => 'Queue Mode',
    'mautic.webhook.config.immediate_process' => 'Process Events Immediately',
    'mautic.webhook.error.notfound' => 'Webhook Not Found',
    'mautic.webhook.form.confirmbatchdelete' => 'Delete the selected Webhooks?',
    'mautic.webhook.form.confirmdelete' => 'Delete the Webhook, %name%?',
    'mautic.webhook.form.description' => 'Webhook Description',
    'mautic.webhook.form.webhook.events' => 'Webhook Events',
    'mautic.webhook.form.webhook_url' => 'Webhook POST Url',
    'mautic.webhook.form.secret' => 'Secret',
    'mautic.webhook.secret.tooltip' => 'This field will autogenerate if no value is provided. Use this secret hash to verify authenticity of the webhook payload on the target server.',
    'mautic.webhook.label.success' => 'Success!',
    'mautic.webhook.label.warning' => 'Error Detected!',
    'mautic.webhook.label.no.url' => 'No URL specified',
    'mautic.webhook.no.logs' => 'No Webhooks Logs',
    'mautic.webhook.no.logs_desc' => 'This webhook hasn\'t been executed yet so there aren\'t any logs available',
    'mautic.webhook.permissions.header' => 'Webhook Permissions',
    'mautic.webhook.permissions.webhooks' => 'Webhooks - User has access to',
    'mautic.webhook.send.test.payload' => 'Send Test Payload',
    'mautic.webhook.status' => 'Response',
    'mautic.webhook.webhook.header.edit' => 'Edit Webhook',
    'mautic.webhook.webhook.header.new' => 'Create New Webhook',
    'mautic.webhook.webhook.logs.desc' => 'These are the logs for this hook. Each time an event triggers this hook to be activated we record the HTTP response header. A successful response should be a 200 header. All other responses are considered an error.',
    'mautic.webhook.webhook.logs.title' => 'Webhook Response Log',
    'mautic.webhook.webhook.logs.empty.response' => 'Empty response body received',
    'mautic.webhook.webhook.menu.index' => 'Webhooks',
    'mautic.webhook.webhook_url' => 'Webhook Url',
    'mautic.webhook.webhooks' => 'Webhooks',
    'mautic.webhook.stopped' => 'Webhook has been stopped',
    'mautic.webhook.stopped.details' => '%webhook% has been stopped because %reason%',
    'mautic.webhook.stopped.reason' => 'the responses were not successful for some time',
    'mautic.webhook.stopped.reason.410' => 'the response HTTP code was 410, which means the receiver doesn\'t want us to send more requests.',
    'mautic.webhook.note' => 'Note',
    'mautic.webhook.runtime' => 'Request Runtime',
    'mautic.webhook.killed' => 'Webhook was automatically deactivated because the response has errored out %limit% times in a row.',
    'mautic.webhook.config.event.orderby' => 'Order of the queued events',
    'mautic.webhook.config.event.orderby.tooltip' => 'One webhook request can contain several events if queue is used. The default value is defined in settings.',
    'mautic.webhook.config.event.orderby.chronological' => 'Chronological',
    'mautic.webhook.config.event.orderby.reverse.chronological' => 'Reverse Chronological',
    'mautic.webhook.event.sendwebhook' => 'Send a webhook',
    'mautic.webhook.event.sendwebhook_desc' => 'Send a webhook (only for experienced users)',
    'mautic.campaign.campaign.sendwebhook' => 'Send a webhook',
    'mautic.webhook.event.sendwebhook.url' => 'Url',
    'mautic.webhook.event.sendwebhook.method' => 'Method',
    'mautic.webhook.event.sendwebhook.data' => 'Data',
    'mautic.webhook.event.sendwebhook.headers' => 'Headers',
    'mautic.webhook.event.sendwebhook.timeout' => 'Timeout',
    'mautic.webhook.config.email.details' => 'Send email details',
    'mautic.webhook.config.email.details.tooltip' => 'If enabled, email related webhooks send detailed data.',
    'mautic.integration.fullcontact.apikey' => 'FullContact API Key',
    'mautic.plugin.fullcontact.button.caption' => 'Lookup using FullContact',
    'mautic.plugin.fullcontact.lookup.header' => 'FullContact - Lookup information for %item%',
    'mautic.plugin.fullcontact.test_api' => 'Test API and get Stats',
    'mautic.plugin.fullcontact.stats' => 'Test Results',
    'mautic.plugin.fullcontact.toomany' => 'You can only lookup 20 contacts at once!',
    'mautic.plugin.fullcontact.comptoomany' => 'You can only lookup 20 companies at once!',
    'mautic.plugin.fullcontact.empty' => 'There are no contacts to lookup!',
    'mautic.plugin.fullcontact.compempty' => 'There are no company domains to lookup!<br/>(Company website is empty?)',
    'mautic.plugin.fullcontact.forbidden' => 'You don\'t have permissions to update this contact',
    'mautic.plugin.fullcontact.compforbidden' => 'You don\'t have permissions to update this company',
    'mautic.plugin.fullcontact.auto_update' => 'Automatically update on save?',
    'mautic.plugin.fullcontact.auto_update.tooltip' => 'WARNING: This could easily exhaust your quota of API calls per month.',
    'mautic.plugin.fullcontact.notify' => 'Show a notification when the information has been received',
    'mautic.plugin.fullcontact.webhook' => 'The plugin will use the following as the Webhook URL for FullContact:',
    'mautic.plugin.fullcontact.public_info' => '<strong>Warning!</strong> This must be a public accessible URL for the Webhook to work.',
    'mautic.plugin.fullcontact.submit' => 'Click submit to lookup the information for:',
    'mautic.plugin.fullcontact.submit_items' => 'Click submit to lookup the information for the selected item(s).',
    'mautic.plugin.fullcontact.company_retrieved' => 'The company information for %s has been retrieved',
    'mautic.plugin.fullcontact.contact_retrieved' => 'The contact information for %s has been retrieved',
    'mautic.plugin.fullcontact.unable' => 'Unable to save the information for %s: %s',
    'mautic.salesforce.activity.point' => 'Mautic Point Activity',
    'mautic.salesforce.activity.form' => 'Mautic Form Activity',
    'mautic.salesforce.activity.email' => 'Mautic Email Activity',
    'mautic.salesforce.sandbox' => 'This a Sandbox account',
    'mautic.salesforce.form.sandbox' => 'Check this option to use your Salesforce sandbox account for testing purposes. Uncheck to use this plugin in a Salesforce production environment.',
    'mautic.salesforce.updateOwner' => 'Update Contact Owner',
    'mautic.salesforce.form.updateOwner' => 'Check this option to update Contact Owner based on Salesforce Owner.',
    'mautic.salesforce.form.oauth_requirements' => 'Salesforce requires that your callback URL (this site) be https.',
    'mautic.salesforce.form.objects_to_pull_from' => 'Choose Salesforce objects to pull contacts from',
    'mautic.salesforce.form.namespace_prefix' => 'If your Salesforce account uses a namespace prefix, enter it here:',
    'mautic.salesforce.object.activity' => 'Activity',
    'mautic.salesforce.object.contact' => 'Contact',
    'mautic.salesforce.object.lead' => 'Lead',
    'mautic.sugarcrm.form.api.keys' => 'API Keys',
    'mautic.sugarcrm.form.clientkey' => 'Client key',
    'mautic.sugarcrm.form.clientsecret' => 'Client secret',
    'mautic.sugarcrm.form.password' => 'SugarCRM password',
    'mautic.sugarcrm.form.url' => 'Sugar CRM URL',
    'mautic.sugarcrm.form.username' => 'SugarCRM username',
    'mautic.sugarcrm.form.version' => 'SugarCRM Version',
    'mautic.sugarcrm.form.objects_to_pull_from' => 'Choose SugarCRM objects to pull contacts from',
    'mautic.sugarcrm.object.contact' => 'Contacts',
    'mautic.sugarcrm.object.lead' => 'Leads',
    'mautic.sugarcrm.object.company' => 'Accounts',
    'mautic.sugarcrm.activity.point' => 'Mautic Point Activity',
    'mautic.sugarcrm.activity.form' => 'Mautic Form Activity',
    'mautic.sugarcrm.activity.email' => 'Mautic Email Activity',
    'mautic.sugarcrm.updateOwner' => 'Update Contact Owner',
    'mautic.sugarcrm.form.updateOwner' => 'Check this option to update Contact Owner based on Sugarcrm Owner.',
    'mautic.sugarcrm.updateDnc' => 'Update emails Do not contact',
    'mautic.sugarcrm.form.updateDnc' => 'Check this option to update contact\'s do not contact information (email_opt_out, invalid_email).',
    'mautic.sugarcrm.form.namespace_prefix' => 'If your Sugarcrm account uses a namespace prefix, enter it here:',
    'mautic.sugarcrm.object.activity' => 'Activity',
    'mautic.vtiger.form.field_match_notes' => 'A red asterisk (*) is required by the CRM. If the values are empty for the lead, a value of \'Unknown\' will be sent. If the CRM field is a pick list, be sure the list values of Mautic\'s field matches those of the CRMs.<br /><br /><strong>The lead will be assigned to the username listed on the Enabled/Auth tab.</strong>',
    'mautic.vtiger.form.password' => 'vTiger access key',
    'mautic.vtiger.form.url' => 'vTiger URL',
    'mautic.vtiger.form.username' => 'vTiger username',
    'mautic.vtiger.object.contact' => 'Contact',
    'mautic.vtiger.object.company' => 'Company',
    'mautic.vtiger.form.objects_to_pull_from' => 'Choose what vTiger Objects to pull data from',
    'mautic.zoho.form.client_id' => 'Application Client ID',
    'mautic.zoho.form.client_secret' => 'Application Secret Key',
    'mautic.zoho.auth_error' => 'Zoho login failed with response: %cause%',
    'mautic.hubspot.form.apikey' => 'Hubspot API Key (deprecated)',
    'mautic.hubspot.form.accessKey' => 'Hubspot Access token from private app',
    'mautic.salesforce.object.company' => 'Account',
    'mautic.hubspot.form.objects_to_pull_from' => 'Choose what Hubspot Objects to pull data from',
    'mautic.hubspot.object.company' => 'Companies',
    'mautic.hubspot.object.contact' => 'Contacts',
    'mautic.integration.dynamics.resource' => 'Instance URL',
    'mautic.integration.dynamics.client_id' => 'Client/Application ID',
    'mautic.integration.dynamics.client_secret' => 'Application Key/Secret',
    'mautic.integration.dynamics.username' => 'User Name',
    'mautic.integration.dynamics.password' => 'Password',
    'mautic.dynamics.form.objects_to_pull_from' => 'Choose what Dynamics CRM Objects to pull data from',
    'mautic.dynamics.object.company' => 'Companies',
    'mautic.dynamics.object.contact' => 'Contacts',
    'mautic.plugin.dynamics.doc_link' => 'Click here to go to the Dynamics CRM plugin documentation',
    'mautic.connectwise.form.companyid' => 'Company Id',
    'mautic.connectwise.form.publickey' => 'Public Key',
    'mautic.connectwise.form.privatekey' => 'Private Key',
    'mautic.connectwise.form.integrator' => 'CompanyId+PublicKey',
    'mautic.connectwise.form.site' => 'Connectwise URL',
    'mautic.connectwise.form.cookie' => 'ClientID',
    'mautic.connectwise.object.contact' => 'Contact',
    'mautic.connectwise.object.company' => 'Company',
    'mautic.connectwise.form.objects_to_pull_from' => 'Choose modules to pull data from',
    'mautic.crm.form.objects_to_pull_from' => 'Choose what %crm% Objects to pull data from',
    'mautic.zoho.object.lead' => 'Leads',
    'mautic.zoho.object.contact' => 'Contacts',
    'mautic.zoho.object.account' => 'Accounts',
    'mautic.plugin.zoho.zone_select' => 'Select Zoho Datacenter',
    'mautic.plugin.zoho.zone.tooltip' => 'Zoho accounts are tied up to a specific datacenter. Select the one that your credentials belong to.',
    'mautic.plugin.zoho.zone_us' => 'US (zoho.com)',
    'mautic.plugin.zoho.zone_europe' => 'Europe (zoho.eu)',
    'mautic.plugin.zoho.zone_japan' => 'Japan (zoho.co.jp)',
    'mautic.plugin.zoho.zone_china' => 'China (zoho.com.cn)',
    'mautic.salesforce.form.blanks' => 'Sync blank values with values populated from either sides.',
    'mautic.salesforce.form.activity_included_events' => 'Events to include in the activity sync',
    'mautic.salesforce.form.activity.events.tooltip' => 'Select the events that will be sent to the integration as activity.',
    'mautic.connectwise.activity.name' => 'Activity Name',
    'mautic.salesforce.error.opt-out_permission.header' => 'Incorrect SalesForce permissions.',
    'mautic.salesforce.error.opt-out_permission.message' => 'It appears you have not configured your SalesForce permissions correctly.<br/>
<a href = "https://help.salesforce.com/articleView?id=000214338&language=en_US&type=1" target="_blank">Click here to learn more.</a>',
    'mautic.plugin.integration.campaigns.connectwise.activity.type' => 'Activity Type',
    'mautic.plugin.integration.campaigns.connectwise.members' => 'Assign to member',
    'mautic.plugin.config.push.activities' => 'Push contact activities',
    'mautic.plugin.config.integration.restart' => 'Restart integration',
    'mautic.plugin.config.integration.restarted' => '%integration% restarted',
    'mautic.focus.permissions.items' => 'Focus Items - User has access to',
    'mautic.focus.permissions.header' => 'Focus Permissions',
    'mautic.focus.form.confirmbatchdelete' => 'Delete the selected focus items?',
    'mautic.focus' => 'Focus Items',
    'mautic.focus.edit' => 'Edit %name%',
    'mautic.focus.fetch_snapshot' => 'Fetch',
    'mautic.focus.focus_items' => 'Focus Items',
    'mautic.focus.details.views' => 'Views',
    'mautic.focus.details.unique_views' => 'Unique views',
    'mautic.focus.form.activate_for_links' => 'Activate on link clicks?',
    'mautic.focus.form.animate' => 'Animate?',
    'mautic.focus.form.bar.allow_hide' => 'Allow hide?',
    'mautic.focus.form.bar.push_page.tooltip' => 'If set to no, the bar will overlap the page content.',
    'mautic.focus.form.bar.push_page' => 'Push page down?',
    'mautic.focus.form.bar.size.large' => 'Large; 50px height and 17pt font',
    'mautic.focus.form.bar.size.regular' => 'Regular; 30px height and 14pt font',
    'mautic.focus.form.bar.size' => 'Size',
    'mautic.focus.form.bar.sticky.tooltip' => 'If yes, the bar will always be present while scrolling.',
    'mautic.focus.form.bar.sticky' => 'Make sticky?',
    'mautic.focus.form.button_color' => 'Button color',
    'mautic.focus.form.button_text_color' => 'Button text color',
    'mautic.focus.form.choose_form' => 'Select the form to insert',
    'mautic.focus.form.engage_after_conversion.tooltip' => 'If set to yes and the visitor submits the form or clicks the link, the focus will not longer be displayed for the until the visitor clears their cookies.',
    'mautic.focus.form.engage_after_conversion' => 'Stop engaging after a conversion?',
    'mautic.focus.form.stop_after_close.tooltip' => 'If set to Yes and the visitor closes the Focus directly, the Focus will not be displayed again until the visitor clears their cookies.',
    'mautic.focus.form.stop_after_close' => 'Stop engaging after a closing the focus?',
    'mautic.focus.form.font' => 'Font',
    'mautic.focus.form_token.instructions' => 'Insert <strong>{focus_form}</strong> into the content above to inject the selected form.',
    'mautic.focus.form.frequency.daily' => 'Once per day',
    'mautic.focus.form.frequency.everypage' => 'Every page',
    'mautic.focus.form.frequency.hourly' => 'Once per hour',
    'mautic.focus.form.frequency.once' => 'Once per session',
    'mautic.focus.form.frequency.q15m' => 'Every 15 minutes',
    'mautic.focus.form.frequency.q2m' => 'Every 2 minutes',
    'mautic.focus.form.frequency.help' => 'When selecting \'Once per session\', the Focus Item shows once for each active browser session, which ends when a visitor leaves your website.',
    'mautic.focus.form.frequency' => 'How often to engage?',
    'mautic.focus.form.custom.css' => 'Custom CSS',
    'mautic.focus.form.custom.css.help' => 'Enter your custom styles without <&#8239;style&#8239;> tags',
    'mautic.focus.form.headline' => 'Headline',
    'mautic.focus.form.link_new_window' => 'Open link in a new window?',
    'mautic.focus.form.link_text' => 'Link text',
    'mautic.focus.form.link_url' => 'Link URL',
    'mautic.focus.form.placement.bottom_left' => 'Bottom Left',
    'mautic.focus.form.placement.bottom_right' => 'Bottom Right',
    'mautic.focus.form.placement.bottom' => 'Bottom',
    'mautic.focus.form.placement.middle' => 'Middle',
    'mautic.focus.form.placement.top_left' => 'Top Left',
    'mautic.focus.form.placement.top_right' => 'Top Right',
    'mautic.focus.form.placement.top' => 'Top',
    'mautic.focus.form.placement.help' => 'Enable sticky to fix the bar at the viewport’s bottom or disable it to place it at the page’s end.',
    'mautic.focus.form.placement' => 'Placement',
    'mautic.focus.form.primary_color' => 'Primary color',
    'mautic.focus.form.style' => 'What style should be used?',
    'mautic.focus.form.tagline' => 'Tagline',
    'mautic.focus.form.text_color' => 'Text color',
    'mautic.focus.form.type.form_description' => 'Use a Mautic form to collect data from the visitor.',
    'mautic.focus.form.type.form' => 'Collect data',
    'mautic.focus.form.type.link_description' => 'Get visitors to click through to a specific URL.',
    'mautic.focus.form.type.link' => 'Emphasize a link',
    'mautic.focus.form.type.notice_description' => 'Display a notice to your visitors.',
    'mautic.focus.form.type.notice' => 'Display a notice',
    'mautic.focus.form.type.tooltip' => 'Select what type of focus is desired.',
    'mautic.focus.form.type' => 'What should the focus be?',
    'mautic.focus.form.html_mode.tooltip' => 'HTML mode allows adding your custom HTML code to Focus.',
    'mautic.focus.form.html_mode' => 'Content mode',
    'mautic.focus.form.basic' => 'Basic',
    'mautic.focus.form.editor' => 'Editor',
    'mautic.focus.form.html' => 'HTML',
    'mautic.focus.form.website.tooltip' => 'Enter your website for Mautic to grab a screenshot and display an example.',
    'mautic.focus.form.website' => 'Website',
    'mautic.focus.form.when.5seconds' => '5 second delay',
    'mautic.focus.form.when.immediately' => 'Upon arrival',
    'mautic.focus.form.when.leave' => 'Visitor intends to leave',
    'mautic.focus.form.when.minute' => '1 minute delay',
    'mautic.focus.form.when.scroll_bottom' => 'After scrolling to bottom',
    'mautic.focus.form.when.scroll_middle' => 'After scrolling to middle',
    'mautic.focus.form.when.scroll_slight' => 'After slightly scrolling down',
    'mautic.focus.form.timeout' => 'Timeout before engage',
    'mautic.focus.form.timeout.seconds' => 'sec',
    'mautic.focus.form.when' => 'When to engage?',
    'mautic.focus.graph.clicks' => 'Clicks',
    'mautic.focus.graph.stats' => 'Focus Stats',
    'mautic.focus.graph.submissions' => 'Submissions',
    'mautic.focus.graph.views' => 'Views',
    'mautic.focus.install.description' => 'Copy this line of code into your site, preferably right before the closing body tag. Alternatively show this focus item through a campaign action in response to a page view on a page which has the Mautic tracking script.',
    'mautic.focus.install.header' => 'Focus Installation',
    'mautic.focus.new' => 'New Focus',
    'mautic.focus.noresults.tip' => 'Get the attention of visitors on your website with Focus Forms, Focus Clicks, or Focus Notifications.',
    'mautic.focus.style.bar_description' => 'Display a bar across the top of the page.',
    'mautic.focus.style.bar' => 'Bar',
    'mautic.focus.style.modal_description' => 'Display a popup in the middle of the page.',
    'mautic.focus.style.modal' => 'Modal',
    'mautic.focus.style.notification_description' => 'Display a small window in a corner of the page.',
    'mautic.focus.style.notification' => 'Notification',
    'mautic.focus.style.page_description' => 'Display a window that covers the entire page.',
    'mautic.focus.style.page' => 'Full Page',
    'mautic.focus.tab.focus_colors' => 'Colors',
    'mautic.focus.tab.focus_content' => 'Content',
    'mautic.focus.tab.focus_style' => 'Style',
    'mautic.focus.tab.focus_type' => 'Focus',
    'mautic.focus.thead.style' => 'Focus Style',
    'mautic.focus.thead.type' => 'Focus Type',
    'mautic.focus.type.form' => 'Form',
    'mautic.focus.type.link' => 'Link',
    'mautic.focus.type.notice' => 'Notice',
    'mautic.focus.website_placeholder' => 'Enter a website below and I\'ll grab a snapshot so you can see an example of what your Focus will look like on your site as you build it!',
    'mautic.focums.html_mode.tooltip' => 'Pick one mode. Content will not carry over when switching between modes',
    'mautic.focus.campaign.event.show_focus' => 'Show Focus Item',
    'mautic.focus.campaign.event.show_focus_descr' => 'Trigger Focus Item',
    'mautic.focus.no.focusitem.note' => 'There are no Focus Item to choose from. Create some first.',
    'mautic.focus.focusitem.selectitem' => 'Select Focus Item',
    'mautic.focus.focusitem.selectitem_descr' => 'Choose the Focus Item',
    'mautic.focus.show.new.item' => 'New Focus Item',
    'mautic.focus.show.edit.item' => 'Edit Focus Item',
    'mautic.focus.show.preview.item' => 'Preview Focus Item',
    'mautic.campaign.focus.show' => 'Focus Item',
    'mautic.focus.form.confirmdelete' => 'Delete the Focus item, %name%?',
    'mautic.focus.protocol.mismatch' => 'This site cannot be previewed because it is not secure. Please try using %url%.',
    'mautic.focus.blocking.iframe.header' => 'This website blocks iframe previews with the %header% header. Please try another URL.',
    'mautic.focus.event.view' => 'Focus view',
    'mautic.focus.view' => 'Focus view',
    'mautic.focus.event.click' => 'Focus click',
    'mautic.focus.click' => 'Focus click',
    'mautic.config.tab.social_config' => 'Social Settings',
    'mautic.integration.common.about' => 'About',
    'mautic.integration.common.bio' => 'Bio',
    'mautic.integration.common.birthday' => 'Birthday',
    'mautic.integration.common.email' => 'Email',
    'mautic.integration.common.gender' => 'Gender',
    'mautic.integration.common.profileHandle' => 'Social handle',
    'mautic.integration.Facebook' => 'Facebook',
    'mautic.integration.Facebook.first_name' => 'Name - First',
    'mautic.integration.Facebook.last_name' => 'Name - Last',
    'mautic.integration.Facebook.link' => 'Profile',
    'mautic.integration.Facebook.locale' => 'Locale',
    'mautic.integration.Facebook.middle_name' => 'Name - Middle',
    'mautic.integration.Facebook.name' => 'Name - Full',
    'mautic.integration.Facebook.political' => 'Political',
    'mautic.integration.Facebook.quotes' => 'Quotes',
    'mautic.integration.Facebook.religion' => 'Religion',
    'mautic.integration.Facebook.timezone' => 'Timezone',
    'mautic.integration.Facebook.website' => 'Website',
    'mautic.integration.Facebook.ProfileLink' => 'Profile Link',
    'mautic.integration.Facebook.share.action' => 'Action text',
    'mautic.integration.Facebook.share.action.like' => 'Like',
    'mautic.integration.Facebook.share.action.recommend' => 'Recommend',
    'mautic.integration.Facebook.share.action.share' => 'Share',
    'mautic.integration.Facebook.share.layout' => 'Layout',
    'mautic.integration.Facebook.share.layout.boxcount' => 'Vertical with count',
    'mautic.integration.Facebook.share.layout.button' => 'Horizontal without count',
    'mautic.integration.Facebook.share.layout.buttoncount' => 'Horizontal with count',
    'mautic.integration.Facebook.share.layout.icon' => 'Icon (share button only)',
    'mautic.integration.Facebook.share.layout.standard' => 'Horizontal with text (like/recommend button)',
    'mautic.integration.Facebook.share.showfaces' => 'Show friends\' faces (applicable for like/recommend button)',
    'mautic.integration.Facebook.share.showshare' => 'Include a share button (applicable for like/recommend button)',
    'mautic.integration.Facebook.login.width' => 'Button Width',
    'mautic.integration.Facebook.login.buttonlabel' => 'Button Label',
    'mautic.integration.Foursquare' => 'Foursquare',
    'mautic.integration.Foursquare.emailContact' => 'Email',
    'mautic.integration.Foursquare.facebookContact' => 'Profile - Facebook',
    'mautic.integration.Foursquare.facebookProfileHandle' => 'Profile - Facebook',
    'mautic.integration.Foursquare.firstName' => 'Name - First',
    'mautic.integration.Foursquare.homeCity' => 'Home City',
    'mautic.integration.Foursquare.lastName' => 'Name - Last',
    'mautic.integration.Foursquare.mayorship' => 'Mayorship',
    'mautic.integration.Foursquare.phoneContact' => 'Phone',
    'mautic.integration.Foursquare.profileImage' => 'Foursquare profile image URL',
    'mautic.integration.Foursquare.twitterContact' => 'Profile - Twitter',
    'mautic.integration.Foursquare.twitterProfileHandle' => 'Profile - Twitter',
    'mautic.integration.Instagram' => 'Instagram',
    'mautic.integration.Instagram.full_name' => 'Full name',
    'mautic.integration.Instagram.website' => 'Website',
    'mautic.integration.Twitter' => 'Twitter',
    'mautic.integration.Twitter.description' => 'Description',
    'mautic.integration.Twitter.lang' => 'Language',
    'mautic.integration.Twitter.location' => 'Location',
    'mautic.integration.Twitter.name' => 'Name',
    'mautic.integration.Twitter.share.hashtag' => 'Hashtag',
    'mautic.integration.Twitter.share.hashtag.placeholder' => 'hashtag',
    'mautic.integration.Twitter.share.largesize' => 'Large button',
    'mautic.integration.Twitter.share.layout' => 'Layout',
    'mautic.integration.Twitter.share.layout.horizontal' => 'Horizontal with count',
    'mautic.integration.Twitter.share.layout.none' => 'Without count',
    'mautic.integration.Twitter.share.layout.vertical' => 'Vertical with count',
    'mautic.integration.Twitter.share.related' => 'Recommend',
    'mautic.integration.Twitter.share.text' => 'Tweet text',
    'mautic.integration.Twitter.share.text.pagetitle' => 'use page title',
    'mautic.integration.Twitter.share.tweet' => 'Tweet',
    'mautic.integration.Twitter.share.username' => 'username',
    'mautic.integration.Twitter.share.via' => 'Via',
    'mautic.integration.Twitter.time_zone' => 'Timezone',
    'mautic.integration.Twitter.url' => 'URLs - Website',
    'mautic.integration.Twitter.text.required' => 'Tweet text is required',
    'mautic.integration.Twitter.send.selecttweet' => 'Select Tweet',
    'mautic.integration.Twitter.send.selecttweet.desc' => 'Sends a tweet to the contact.',
    'mautic.social.tweets' => 'Tweets',
    'mautic.social.monitoring.twitter.tweet.name' => 'Name',
    'mautic.social.monitoring.twitter.tweet.name.tooltip' => 'Internal Mautic name of the Tweet',
    'mautic.integration.Twitter.new.tweet' => 'New Tweet',
    'mautic.integration.Twitter.edit.tweet' => 'Edit Tweet',
    'mautic.plugin.actions.socialLogin' => 'Social login',
    'mautic.mauticSocial.permissions.header' => 'Social Permissions',
    'mautic.mauticSocial.permissions.monitoring' => 'Monitoring - User has access to',
    'mautic.mauticSocial.permissions.tweet' => 'Tweet - User has access to',
    'mautic.mautic.social.monitoring.form.confirmdelete' => 'Delete monitor?',
    'mautic.integration.Twitter.form.confirmdelete' => 'Delete tweet?',
    'mautic.mautic.social.monitoring.form.confirmbatchdelete' => 'Delete selected monitors?',
    'mautic.mautic.social.monitoring.noresults.tip' => 'Get started by adding your first monitor record. Make sure you\'ve configured the twitter integration!',
    'mautic.mautic.social.tweet.noresults.tip' => 'Get started by adding your first tweet record. Make sure you\'ve configured the twitter integration!',
    'mautic.social.tweet.menu.edit' => 'Edit tweet %name%',
    'mautic.social.tweet.menu.new' => 'New tweet',
    'mautic.social.twitter.handle' => '@handle',
    'mautic.social.config.twitter.field.label' => 'Twitter Handle Field',
    'mautic.social.monitoring' => 'Social Monitoring',
    'mautic.social.monitoring.list.choose' => 'Choose an option',
    'mautic.social.monitoring.list.action.retweet' => 'Retweet Tweet',
    'mautic.social.monitoring.list.action.favorite' => 'Favorite Tweet',
    'mautic.social.monitoring.menu.edit' => 'Edit Social Monitor',
    'mautic.social.monitoring.menu.new' => 'New Social Monitor',
    'mautic.social.monitoring.monitor.leads' => 'Contacts Added',
    'mautic.social.monitoring.twitter.assets' => 'Insert Asset Link',
    'mautic.social.monitoring.twitter.assets.descr' => 'Select an asset from the list to insert a place holder into the tweet',
    'mautic.social.monitoring.twitter.hashtag' => 'Twitter Hashtag',
    'mautic.social.monitoring.twitter.hashtag.tooltip' => 'Enter a hashtag to search for on twitter. Don\'t add the \'#\' symbol',
    'mautic.social.monitoring.twitter.custom' => 'Twitter Custom Search',
    'mautic.social.monitoring.twitter.custom.tooltip' => 'Build a custom search query using twitter\'s query builder criteria.',
    'mautic.social.monitoring.twitter.handle' => 'Twitter Mention',
    'mautic.social.monitoring.twitter.handle.tooltip' => 'The twitter handle. Don\'t include the \'@\' symbol',
    'mautic.social.monitoring.twitter.interact.label' => 'Interact with Tweets',
    'mautic.social.monitoring.twitter.interact.tooltip' => 'Select an interaction if you want to tweet or favorite discovered tweets.',
    'mautic.social.monitoring.twitter.not.published' => 'Twitter plugin not published!',
    'mautic.social.monitoring.twitter.pages' => 'Insert Page Link',
    'mautic.social.monitoring.twitter.pages.descr' => 'Select a page link from the list to insert a placeholder into the tweet',
    'mautic.social.monitoring.twitter.tweet.text' => 'Tweet Message',
    'mautic.social.monitoring.twitter.tweet.text.tooltip' => 'The text of the tweet. Placeholders supported: {twitter_handle}, {pagelink=X}, and {assetlink=X}',
    'mautic.social.monitoring.twitter.tweet.description' => 'Description',
    'mautic.social.monitoring.twitter.tweet.description.tooltip' => 'Internal description of the tweet',
    'mautic.social.monitoring.type.list' => 'Monitoring Methods',
    'mautic.social.monitoring.type.list.twitter.custom' => 'Twitter Custom Search',
    'mautic.social.monitoring.type.list.twitter.handle' => 'Twitter Mention',
    'mautic.social.monitoring.type.list.twitter.hashtag' => 'Twitter Hashtag',
    'mautic.social.monitoring.twitter_hashtag.popularity' => 'Tweets Per Day',
    'mautic.social.monitoring.twitter_handle.popularity' => 'Tweets Per Day',
    'mautic.social.monitoring.twitter_custom.popularity' => 'Tweets Per Day',
    'mautic.social.twitter.error.handle_not_found' => 'Handle not found',
    'mautic.social.twitter.tweet.event.open' => 'Tweet contact',
    'mautic.social.twitter.tweet.event.open_desc' => 'Send tweets automatically to contacts. This must be in compliance with  <a href=\'https://support.twitter.com/articles/76915#Tweets\' target=\'_blank\'>Twitter\'s Automation Rules</a>.',
    'mautic.social.twitter.tweet.count' => 'Count',
    'mautic.social.twitter.tweet.handle' => 'Insert Contact Handle',
    'mautic.monitoring.form.confirmdelete' => 'Delete the social monitoring, %name%?',
    'mautic.campaign.twitter.tweet' => 'Tweet contact',
    'mautic.social.monitoring.twitter.not.configured' => 'Twitter integration not configured or authorized. Configure the integration to complete this task.',
    'mautic.social.monitoring.twitter.mid.empty' => '--mid option cannot be empty',
    'mautic.social.monitoring.twitter.monitor.does.not.exist' => 'Monitor %id% has not been found',
    'mautic.social.monitoring.twitter.no.new.tweets' => 'No new tweets',
    'mautic.social.monitoring.twitter.filed.not.found' => 'Twitter lead field not found.',
    'mautic.social.monitoring.twitter.field.not.found' => 'Twitter lead field not found.',
    'mautic.social.monitoring.twitter.namematching' => 'Match contact names',
    'mautic.social.monitoring.twitter.namematching.tooltip' => 'If this is enabled Mautic will try to match twitter names with existing contact names to try and identify twitter accounts of existing contacts',
    'mautic.social.monitoring.twitter.yes' => 'Yes',
    'mautic.social.monitoring.twitter.no' => 'No',
    'mautic.integration.clearbit.apikey' => 'Clearbit API Key',
    'mautic.plugin.clearbit.button.caption' => 'Lookup using Clearbit',
    'mautic.plugin.clearbit.lookup.header' => 'Clearbit - Lookup information for %item%',
    'mautic.plugin.clearbit.test_api' => 'Test API and get Stats',
    'mautic.plugin.clearbit.stats' => 'Test Results',
    'mautic.plugin.clearbit.toomany' => 'You can only lookup 20 contacts at once!',
    'mautic.plugin.clearbit.comptoomany' => 'You can only lookup 20 companies at once!',
    'mautic.plugin.clearbit.empty' => 'There are no contacts to lookup!',
    'mautic.plugin.clearbit.compempty' => 'There are no company domains to lookup!<br/>(Company website is empty?)',
    'mautic.plugin.clearbit.forbidden' => 'You don\'t have permissions to update this contact',
    'mautic.plugin.clearbit.compforbidden' => 'You don\'t have permissions to update this company',
    'mautic.plugin.clearbit.auto_update' => 'Automatically update on save?',
    'mautic.plugin.clearbit.auto_update.tooltip' => 'WARNING: This could easily exhaust your quota of API calls per month.',
    'mautic.plugin.clearbit.notify' => 'Show a notification when the information has been received.',
    'mautic.plugin.clearbit.contact_retrieved' => 'The contact information for %s has been retrieved',
    'mautic.plugin.clearbit.company_retrieved' => 'The company information for %s has been retrieved',
    'mautic.plugin.clearbit.unable' => 'Unable to save the information: %s',
    'mautic.plugin.clearbit.webhook_info' => 'For the plugin to work, you must use the following as the Webhook URL in your account settings on the <a href="https://dashboard.clearbit.com/account" target="_blank">Clearbit Dashboard</a>:',
    'mautic.plugin.clearbit.public_info' => '<strong>Warning!</strong> This must be a public accessible URL for the Webhook to work.',
    'mautic.plugin.clearbit.submit' => 'Click submit to lookup the information for:',
    'mautic.plugin.clearbit.submit_items' => 'Click submit to lookup the information for the selected item(s).',
    'mautic.tagManager.permissions.header' => 'Tag manager permissions',
    'mautic.tagManager.permissions.tagManager' => 'Tag Manager',
    'tagmanager.menu.index' => 'Tags',
    'mautic.tagmanager.tag.header.index' => 'Tags',
    'mautic.tagmanager.lead.searchcommand.list' => 'tag',
    'mautic.tagmanager.tag.form.confirmdelete' => 'Delete this tag?',
    'mautic.tagmanager.tag.error.notfound' => 'No tag with an id of %id% was found!',
    'mautic.tagmanager.menu.new' => 'Create new tag',
    'mautic.tagmanager.menu.edit' => 'Edit tag: %name%',
    'mautic.tagmanager.form.confirmdelete' => 'Delete this tag?',
    'mautic.tagmanager.tag.summary' => 'Summary',
    'mautic.tagmanager.batch.tags' => 'Change Tags',
    'mautic.integration.form.feature.cloud_storage' => 'Connect to cloud storage provider',
    'mautic.integration.form.provider.settings' => 'Provider Settings',
    'mautic.integration.keyfield.amazons3.bucket' => 'Bucket Path',
    'mautic.integration.keyfield.OpenCloud.containerName' => 'Container Storage Path',
    'mautic.integration.Amazon.region' => 'S3 Region',
    'mautic.integration.Amazon.endpoint' => 'S3 Endpoint',
    'mautic.integration.gmail.secret' => 'Gmail Extension Secret',
    'mautic.constantcontact.customfield1' => 'Custom field 1',
    'mautic.constantcontact.customfield2' => 'Custom field 2',
    'mautic.constantcontact.customfield3' => 'Custom field 3',
    'mautic.constantcontact.customfield4' => 'Custom field 4',
    'mautic.constantcontact.customfield5' => 'Custom field 5',
    'mautic.constantcontact.customfield6' => 'Custom field 6',
    'mautic.constantcontact.customfield7' => 'Custom field 7',
    'mautic.constantcontact.customfield8' => 'Custom field 8',
    'mautic.constantcontact.customfield9' => 'Custom field 9',
    'mautic.constantcontact.customfield10' => 'Custom field 10',
    'mautic.constantcontact.customfield11' => 'Custom field 11',
    'mautic.constantcontact.customfield12' => 'Custom field 12',
    'mautic.constantcontact.customfield13' => 'Custom field 13',
    'mautic.constantcontact.customfield14' => 'Custom field 14',
    'mautic.constantcontact.customfield15' => 'Custom field 15',
    'mautic.constantcontact.field.address_city' => 'City',
    'mautic.constantcontact.field.address_country_code' => 'Country code (2 characters)',
    'mautic.constantcontact.field.address_line1' => 'Address line 1',
    'mautic.constantcontact.field.address_line2' => 'Address line 2',
    'mautic.constantcontact.field.address_state' => 'State',
    'mautic.constantcontact.field.address_postal_code' => 'Postal code',
    'mautic.constantcontact.field.cell_phone' => 'Cell phone',
    'mautic.constantcontact.field.company_name' => 'Company name',
    'mautic.constantcontact.field.email' => 'Email',
    'mautic.constantcontact.field.fax' => 'Fax',
    'mautic.constantcontact.field.first_name' => 'First name',
    'mautic.constantcontact.field.home_phone' => 'Home phone',
    'mautic.constantcontact.field.job_title' => 'Job title',
    'mautic.constantcontact.field.last_name' => 'Last name',
    'mautic.constantcontact.field.prefix_name' => 'Prefix name',
    'mautic.constantcontact.field.work_phone' => 'Work phone',
    'mautic.icontact.field.business' => 'Business phone',
    'mautic.icontact.field.city' => 'City',
    'mautic.icontact.field.email' => 'Email',
    'mautic.icontact.field.fax' => 'Fax',
    'mautic.icontact.field.firstName' => 'First name',
    'mautic.icontact.field.lastName' => 'Last name',
    'mautic.icontact.field.phone' => 'Phone',
    'mautic.icontact.field.postalCode' => 'Postal code',
    'mautic.icontact.field.prefix' => 'Prefix',
    'mautic.icontact.field.street' => 'Address line 1',
    'mautic.icontact.field.street2' => 'Address line 2',
    'mautic.icontact.field.suffix' => 'Suffix',
    'mautic.icontact.field.state' => 'State',
    'mautic.icontact.keyfield.appid' => 'App ID',
    'mautic.icontact.keyfield.username' => 'App username',
    'mautic.icontact.keyfield.password' => 'App API password',
    'mautic.emailmarketing.list' => 'List',
    'mautic.emailmarketing.list.tooltip' => 'Choose the list the lead should be added to.',
    'mautic.emailmarketing.list.update' => 'The Lead Field Mapping tab will appear after selecting a list and will update after changing the selected list.',
    'mautic.emailmarketing.send_welcome' => 'Send welcome email',
    'mautic.mailchimp.double_optin' => 'Enable double opt in',
    'mautic.integration.outlook.secret' => 'Outlook Add-In Secret',
    'mautic.plugin.outlook.url' => 'Please use the following as the Mautic URL in the Outlook Add-In options dialog:',
    'mautic.plugin.outlook.public_info' => '<strong>Warning!</strong> This must be a publicly accessible URL for the Add-In to work.',
    'jw.mautic.email.form.action.sendemail.lead.descr' => 'Send the selected email as DOI EMail to the contact upon form submission.',
    'jw.mautic.email.form.action.sendemail.lead' => 'Send DOUBLE OPTIN email to contact',
    'jw.mautic.form.action.redirect_url' => 'Redirect URL after success',
    'jw.mautic.lead.tags.add_campaign_doi_success_tags' => 'Tags to set after successfull DOI',
    'jw.remove_tags_doi_success_tags' => 'Tags to remove  after successfull DOI',
    'jw.add_campaign_doi_success_lists' => 'Segments to add to Lead after successfull DOI',
    'jw.remove_campaign_doi_success_lists' => 'Segments to remove from Lead after successfull DOI',
    'jw.mautic.form.action.lead_field_update' => 'Update Lead Fields after successfull DOI (example: optin_status=Bestätigt)',
    'jw.mautic.form.action.lead_field_update_before' => 'Update Lead Fields before successfull DOI (example: optin_status=Gestartet)',
    'jw.mautic.report.doi' => 'DOI Report',
    'jw.mautic.report.doi.ip' => 'DOI Ip Address',
    'jw.mautic.report.doi.date_added' => 'DOI Datum',
    'jw.mautic.report.doi.details' => 'DOI Details',
    'jw.doi.webhook.event.doi_started' => 'DOI started',
    'jw.doi.webhook.event.doi_started_desc' => 'On started DOI sends the lead and form config.',
    'jw.doi.webhook.event.doi_successful' => 'DOI successful',
    'jw.doi.webhook.event.doi_successful_desc' => 'On successful DOI sends the lead and form config.',
  ),
  'flashes' => 
  array (
    'mautic.core.action.entity.unlocked' => '%name% has been unlocked and is now available for editing.',
    'mautic.core.could.not.set.language' => 'Could not set the preferred language. Using default language instead.',
    'mautic.core.error.accessdenied' => 'You do not have access to the requested area/action.',
    'mautic.core.error.badrequest' => 'This is a bad request.',
    'mautic.core.error.locked' => '%name% is currently checked out by <a href=\'%contactUrl%\'>%user%</a> (checked out on %date% at %time%). %override%',
    'mautic.core.error.not.valid' => 'Form is not valid. Fill in all required fields.',
    'mautic.core.error.notfound' => 'Item was not found.',
    'mautic.core.error.delete.error' => 'Item could not be deleted. %error%',
    'mautic.core.error.max.field' => 'You have reached the limit of custom fields allowed by your database.',
    'mautic.core.notice.batch_deleted' => '%count% items deleted',
    'mautic.core.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> has been created!',
    'mautic.core.notice.deleted' => '<strong>%name%</strong> has been deleted!',
    'mautic.core.notice.updated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> has been updated!',
    'mautic.core.notice.used.field' => 'Field %name% (#%id%) cannot be deleted because it\'s used in the following Segment(s): %segments%.',
    'mautic.core.notice.used.fields' => 'Field(s) %fields% cannot be deleted because they are used in the following Segment(s): %segments%.',
    'mautic.core.notice.campaign.unpublished.email' => 'Email <a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> used in campaign is not published.',
    'mautic.core.language.helper.error.fetching.package' => 'An error occurred while downloading the language package.',
    'mautic.core.language.helper.error.follow.redirects' => 'Whoops, either safe_mode or open_basedir is turned on. Download the language from <a href=\'%url%\'>here</a>. Unzip and upload it to the /translations directory.',
    'mautic.core.language.helper.invalid.language' => 'Requested language \'%language%\' does not exist among the available Mautic languages. The language was reset to the default one.',
    'mautic.core.language.helper.error.on.language.server.side' => 'The language server responded with HTTP code %code%. It is probably temporarily unavailable. Try to change the language later. The language was reset to the default one for now.',
    'mautic.core.language.helper.error.fetching.package.exception' => 'A problem ocurred when requesting the language package: %exception%. The language was reset to the default one for now.',
    'mautic.core.ziparchive.not.installed' => 'The ZIP package cannot be unzipped. The php-zip module is missing. Contact your server admin.',
    'mautic.core.theme.error.notfound' => 'Theme %theme% not found.',
    'mautic.core.permission.issue' => 'There was a file permission issue during this task. Contact your sysadmin to fix the permissions.',
    'mautic.core.theme.installed' => 'Theme <strong>%name%</strong> has been installed!',
    'mautic.core.theme.cannot.be.removed' => '%theme% is the default theme and therefore cannot be removed.',
    'mautic.core.error.entity.not.found' => '%entity% ID %id% not found',
    'mautic.core.error.csrf' => 'CSRF token error. Try to refresh the page and try again.',
    'mautic.core.error.ids.missing' => 'No IDs were provided.',
    'mautic.core.error.access.denied' => 'Access denied',
    'mautic.core.theme.visibility.changed' => 'Theme <strong>%theme%</strong> visibility changed!',
    'mautic.core.theme.cannot.change.visibility' => '%theme% is the not a default theme and therefore cannot change it\'s visibility.',
    'mautic.core.theme.visibility.error' => 'Could not change theme visibility. Error: %error%',
    'mautic.core.theme.notice.batch_deleted' => '%count% themes have been deleted!',
    'mautic.api.client.error.notfound' => 'Client not found with an ID of <strong>%id%</strong>.',
    'mautic.api.client.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\'><strong>%name%</strong></a> has been created.',
    'mautic.api.client.notice.revoked' => 'API access has been revoked from the application, %name%',
    'mautic.api.call.permissionempty' => 'At least one permission must be submitted.',
    'mautic.asset.asset.error.notfound' => 'No asset with an id of %id% was found!',
    'mautic.asset.asset.notice.batch_deleted' => '%count% assets have been deleted!',
    'mautic.campaign.error.contact_not_in_campaign' => 'The contact %contact% is not in the campaign %campaign%.',
    'mautic.campaign.error.event_already_executed' => 'The event %event% in the campaign %campaign% has already been executed at %dateTriggered% for the contact %contact%.',
    'mautic.campaign.error.event_must_be_scheduled' => 'The event %event% in the campaign %campaign% must be scheduled or marked as complete as the contact %contact% does not have a log entry yet.',
    'mautic.campaign.error.edit_events.request_invalid' => 'contactId and/or eventId are misssing from this item\'s parameters.',
    'mautic.campaign.error.decision_cannot_be_scheduled' => 'A decision type event cannot be scheduled. Event: %event%, campaign: %campaign%, contact: %contact%.',
    'mautic.campaign.error.notfound' => 'No campaign with an id of %id% was found!',
    'mautic.campaign.notice.batch_deleted' => '%count% campaigns have been deleted!',
    'mautic.category.error.notfound' => 'No category with an id of %id% was found!',
    'mautic.category.notice.batch_deleted' => '%count% categories have been deleted!',
    'mautic.category.notice.created' => '<strong>%name%</strong> has been created!',
    'mautic.category.notice.updated' => '<strong>%name%</strong> has been updated!',
    'mautic.config.config.error.not.updated' => 'Could not save updated configuration: %exception%',
    'mautic.config.config.notice.updated' => 'Configuration successfully updated',
    'mautic.dashboard.notice.save' => 'Dashboard snapshot \'%name%\'\' is saved. <a href=\'%viewUrl%\'>View all snapshots</a>.',
    'mautic.dashboard.error.save' => 'The dashboard snapshot could not be saved because %msg%',
    'mautic.dynamicContent.error.notfound' => 'No Dynamic Content with an id of %id% was found!',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% entities have been deleted!',
    'mautic.email.error.list_type.sent' => 'Once a list email has been sent, it cannot be edited. Consider cloning the email.',
    'mautic.email.error.notfound' => 'No email with an id of %id% was found!',
    'mautic.email.error.send.unpublished' => 'The email %name% is unavailable, the availability dates are off or the email category is unavailable. You cannot send this email until available.',
    'mautic.email.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_email_index\'><strong>%name%</strong></a> is now active as the main email!',
    'mautic.email.notice.batch_deleted' => '%count% emails have been deleted!',
    'mautic.email.notice.test_sent.success' => 'A test email has been sent to your email.',
    'mautic.email.notice.test_sent_multiple.success' => 'Test emails have been sent.',
    'mautic.form.error.notfound' => 'No form with an id of %id% was found!',
    'mautic.form.field.error.notfound' => 'No form field with an id of %id% was found!',
    'mautic.form.notice.batch_deleted' => '%count% forms have been deleted!',
    'mautic.form.result.notice.batch_deleted' => '%count% form results have been deleted!',
    'mautic.form.notice.batch_html_generated' => '{0}No forms were rebuilt.|{1}One form has been rebuilt.|]1,Inf[%count% forms have been rebuilt.',
    'mautic.form.submit.error.expired' => 'This form stopped accepting submissions on %date%.',
    'mautic.form.submit.error.pending' => 'This form start accepting submissions on %date%.',
    'mautic.form.submit.error.unavailable' => 'This form is no longer available.',
    'mautic.installer.error.adding.fields' => 'An error occurred while attempting to populate the contact fields table: %exception%',
    'mautic.installer.error.adding.fixtures' => 'An error occurred while attempting to add default data: %exception%',
    'mautic.installer.error.connecting.database' => 'An error occured while attempting to connect to the database: %exception%',
    'mautic.installer.error.creating.database' => 'The database, %name%, could not be found or created due to permissions restrictions. Please manually create the database then try again.',
    'mautic.installer.error.getting.role' => 'An error occurred while attempting to get the admin role: %exception%',
    'mautic.installer.error.creating.user' => 'An error occurred while attempting to create the admin user: %exception%',
    'mautic.installer.error.database.exists' => 'The database you\'ve specified already exists and contains Mautic data.',
    'mautic.installer.error.database.version' => 'Your database version (%currentversion%) is too old for Mautic to work correctly. Supported versions are MySQL %mysqlminversion% (or higher) and MariaDB %mariadbminversion% (or higher).',
    'mautic.installer.error.installing.data' => 'An error occurred while attempting to install the data: %exception%',
    'mautic.installer.error.no.metadata' => 'No metadata was found to create the database.',
    'mautic.installer.error.writing.configuration' => 'An error occurred while attempting to write the configuration to the filesystem.',
    'mautic.company.notice.batch_deleted' => '{0} 0 companies deleted|{1} 1 company deleted|]1,Inf[ %count% company deleted',
    'mautic.company.error.notfound' => 'Company not found.',
    'mautic.email.batch_emails_affected' => '{0} 0 emails affected|{1} 1 email affected|]1,Inf[ %count% emails affected',
    'mautic.lead.batch_leads_affected' => '{0} 0 contacts affected|{1} 1 contact affected|]1,Inf[ %count% contacts affected',
    'mautic.lead.email.error.failed' => 'Failed to send to %email%: %error%',
    'mautic.lead.email.notice.sent' => '&quot;%subject%&quot; sent to %email%',
    'mautic.lead.field.error.notfound' => 'No field with an id of %id% was found!',
    'mautic.lead.field.notice.batch_deleted' => '%count% fields have been deleted!',
    'mautic.lead.lead.error.notfound' => 'No contact with an id of %id% was found!',
    'mautic.lead.lead.notice.addedtolists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> has been added to %list%.',
    'mautic.lead.lead.notice.batch_deleted' => '%count% contacts have been deleted!',
    'mautic.lead.lead.notice.removedfromlists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> has been removed from %list%.',
    'mautic.lead.list.error.notfound' => 'No list with an id of %id% was found!',
    'mautic.lead.list.error.cannot.delete' => 'Segment cannot be deleted, it is required by %segments%.',
    'mautic.lead.list.error.cannot.delete.batch' => '%segments% cannot be deleted, it is required by other segments.',
    'mautic.lead.list.notice.batch_deleted' => '%count% lists have been deleted!',
    'mautic.lead.list.frequency.rules.msg' => 'No ',
    'mautic.lead.batch.import.created' => 'Import process was successfully created. You will be notified when finished.',
    'mautic.import.file.missing' => 'File \'%file%\' cannot be found in the filesystem. Please try again.',
    'mautic.lead.export.being.prepared' => 'File is queued for processing. The file will be sent to your email address \'%user_email%\' You can download the file from the link provided in the email.',
    'mautic.notification.notice.batch_deleted' => '%count% notifications have been deleted!',
    'mautic.notification.error.notfound' => 'No notification with id %id% was found!',
    'mautic.page.error.notfound' => 'No page with an id of %id% was found!',
    'mautic.page.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_page_index\'><strong>%name%</strong></a> is now active as the main page!',
    'mautic.page.notice.batch_deleted' => '%count% pages have been deleted!',
    'mautic.plugin.notice.reloaded' => '%added% new plugins were installed and %updated% updated.',
    'mautic.plugin.notice.saved' => 'Settings for the %name% integration have been saved',
    'mautic.integration.auth.invalid.state' => 'Invalid session. Please try again.',
    'mautic.integration.error.genericerror' => 'There was an unknown error encountered when trying to obtain the access token.',
    'mautic.integration.error.oauthfail' => 'Authorization failed with the error message, \'%error%\'',
    'mautic.integration.notfound' => '%name% was not found!',
    'mautic.integration.notice.oauthsuccess' => 'Authorization was successful.',
    'mautic.integration.notice.saved' => 'Settings saved',
    'mautic.integration.sso.error.no_email' => 'Authenticated user does not have an email.',
    'mautic.integration.sso.error.no_name' => 'Authenticated user does not have a first and last name.',
    'mautic.integration.sso.error.no_role' => 'Authenticated user does not have a role.',
    'mautic.integration.sso.error.no_username' => 'Authenticated user does not have a username.',
    'mautic.point.error.notfound' => 'No point action with an id of %id% was found!',
    'mautic.point.notice.batch_deleted' => '%count% point actions have been deleted!',
    'mautic.point.trigger.error.notfound' => 'No trigger with an id of %id% was found!',
    'mautic.point.trigger.notice.batch_deleted' => '%count% point triggers have been deleted!',
    'mautic.report.report.error.notfound' => 'No report with an id of %id% was found!',
    'mautic.report.report.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_report_index\'><strong>%name%</strong></a> is now active as the main report!',
    'mautic.report.report.notice.batch_deleted' => '%count% reports have been deleted!',
    'mautic.report.scheduled.already' => 'Report %id% is already scheduled.',
    'mautic.report.scheduled.to.now' => 'Report %id% will be exported and sent to your email address %email%.',
    'mautic.sms.notice.batch_deleted' => '%count% text messages have been deleted!',
    'mautic.sms.error.notfound' => 'No SMS with id %id% was found!',
    'mautic.stage.error.notfound' => 'No stage action with an id of %id% was found!',
    'mautic.stage.notice.batch_deleted' => '%count% stage actions have been deleted!',
    'mautic.user.account.notice.updated' => 'Your account has been updated.',
    'mautic.user.auth.error.disabledaccount' => 'Your account has been disabled. Please contact the site administrator.',
    'mautic.user.auth.error.invalidlogin' => 'Invalid login. Please verify credentials.',
    'mautic.user.role.error.deletenotallowed' => '%name% cannot be deleted because it still has users assigned to it.',
    'mautic.user.role.error.notfound' => 'Role not found with an ID of <strong>%id%</strong>.',
    'mautic.user.role.notice.batch_deleted' => '%count% roles have been deleted!',
    'mautic.user.user.error.cannotdeleteself' => 'You cannot delete yourself.',
    'mautic.user.user.error.notfound' => 'User not found with an ID of <strong>%id%</strong>.',
    'mautic.user.auth.error.weakpassword' => 'Your password is too weak. Please reset it.',
    'mautic.user.user.notice.batch_deleted' => '%count% users have been deleted!',
    'mautic.user.user.notice.messagesent' => 'Your message to %name% has been sent.',
    'mautic.user.user.notice.passwordreset' => 'A new password has been generated and will be emailed to you, if this user exists. If you do not receive it within a few minutes, check your spam box and/or contact the system administrator.',
    'mautic.user.user.notice.passwordreset.success' => 'If this user exists, you have successfully reset your password. You may now login.',
    'mautic.user.user.notice.passwordreset.error' => 'We encountered an unexpected error while sending the password reset instructions to your email. Please try again later.',
    'mautic.user.user.notice.passwordreset.missingtoken' => 'Your reset request is missing the security token. Please click the link in your email.',
    'mautic.webhook.error.notfound' => 'Webhook Not Found',
    'mautic.company.batch_companies_affected' => '{0} 0 companies affected|{1} 1 company affected|]1,Inf[ %count% companies affected',
    'mautic.focus.error.notfound' => 'The focus requested was not found.',
    'mautic.focus.notice.batch_deleted' => 'Focus items successfully deleted.',
    'mautic.social.monitoring.notice.batch_deleted' => 'Monitors successfully deleted.',
    'mautic.social.monitoring.error.notfound' => 'A social monitor with the ID of %id% was not found.',
    'mautic.tagmanager.tag.error.notfound' => 'No tag with an id of %id% was found!',
    'mautic.tagmanager.tag.notice.batch_deleted' => 'Successfully deleted %count% tags!',
    'mautic.tagmanager.tag.error.cannotbedeleted' => 'Only tag without any contacts can be delete.',
  ),
  'javascript' => 
  array (
    'mautic.core.builder.code_mode_warning' => 'By switching to the Code Mode, you will be able to edit the content only in HTML code. Changing back to a theme will lose content.',
    'mautic.core.builder.theme_change_warning' => 'You will lose the current content if you switch the theme.',
    'mautic.core.builder.section_delete_warning' => 'Are you sure you want to delete the whole section and the content within?',
    'mautic.core.builder.storage.restore.message' => 'You have a copy of this template saved on <b>%date%</b>',
    'mautic.core.builder.storage.restore.button' => 'Restore the backup',
    'mautic.core.builder.storage.dismiss.button' => 'Dismiss',
    'mautic.core.lookup.keep_typing' => 'Keep typing...',
    'mautic.core.lookup.looking_for' => 'Looking for',
    'mautic.core.lookup.search_options' => 'Search options...',
    'mautic.core.lookup.loading_data' => 'Loading data...',
    'mautic.core.dynamicContent' => 'Dynamic Content',
    'mautic.core.dynamicContent.new' => 'Dynamic Content %number%',
    'mautic.core.dynamicContent.token_name' => 'Name',
    'mautic.core.dynamicContent.tab' => 'Variation %number%',
    'mautic.core.dynamicContent.default_content' => 'Default Content',
    'mautic.core.dynamicContent.alt_content' => 'Content',
    'mautic.core.tabs.more' => 'more',
    'mautic.core.request.error' => 'Your request could not be processed, please try again',
    'mautic.campaign.event.clone.success' => 'Your event has been cloned. Select a node in this or another campaign to attach it.',
    'mautic.user.config.title.experience_and_learning.reset_confirmation' => 'All dismissed resources visible again',
    'mautic.message.queue.status.cancelled' => 'Cancelled',
    'mautic.message.queue.status.rescheduled' => 'Rescheduled',
    'mautic.message.queue.status.pending' => 'Pending',
    'mautic.message.queue.status.Sent' => 'Sent',
    'grapesjsbuilder.sourceEditBtnLabel' => 'Save',
    'grapesjsbuilder.sourceCancelBtnLabel' => 'Cancel',
    'grapesjsbuilder.sourceEditModalTitle' => 'Edit code',
    'grapesjsbuilder.sourceSyntaxError' => 'Please fix the following error:',
    'grapesjsbuilder.deleteAssetConfirmText' => 'Are you sure you wish to delete this file?',
    'grapesjsbuilder.categorySectionLabel' => 'Sections',
    'grapesjsbuilder.categoryBlockLabel' => 'Blocks',
    'grapesjsbuilder.dynamicContentBlockLabel' => 'Dynamic Content',
    'grapesjsbuilder.dynamicContentBtnLabel' => 'Save',
    'grapesjsbuilder.dynamicContentModalTitle' => 'Edit Dynamic Content',
    'grapesjsbuilder.buttonBlockLabel' => 'Button',
    'grapesjsbuilder.builder.warning.code_mode' => 'By opening the builder you are leaving Code Mode. The builder might change your HTML code in unexpected ways. Only proceed if you know what you are doing.',
    'grapesjsbuilder.components.names.oneColumn' => '1 Column',
    'grapesjsbuilder.components.names.twoColumn' => '2 Columns',
    'grapesjsbuilder.components.names.twoColumnThirdSevens' => '2 Columns 3/7',
    'grapesjsbuilder.components.names.threeColumn' => '3 Columns',
    'grapesjsbuilder.components.names.textSectionBlkLabel' => 'Text Section',
    'grapesjsbuilder.components.names.gridItemsBlkLabel' => 'Grid Items',
    'grapesjsbuilder.components.names.listItemsBlkLabel' => 'List Items',
    'grapesjsbuilder.panelsViewsCommandModalTitleError' => 'Could not request your action',
    'grapesjsbuilder.panelsViewsButtonsApplyTitle' => 'Apply changes',
    'grapesjsbuilder.buttons.buttonPreview.title' => 'Preview',
    'grapesjsbuilder.buttons.buttonPreview.titleDisabled' => 'Apply your changes to preview',
  ),
  'validators' => 
  array (
    'mautic.core.ab_test.winner_criteria.not_blank' => 'Select a winning criteria.',
    'mautic.core.email.required' => 'A valid email is required.',
    'mautic.core.segment.circular_dependency_exists' => 'Update cannot be completed as the current filters are conflicting with the filters of another segment. Make sure your segment filters are not creating impossible or contradictory conditions (e.g. Segment A must be a member of Segment B while Segment B must be a member of Segment A).',
    'mautic.core.name.required' => 'A name is required.',
    'mautic.core.title.required' => 'A title is required.',
    'mautic.core.type.required' => 'A type is required',
    'mautic.core.value.required' => 'A value is required.',
    'mautic.core.subject.required' => 'A subject is required.',
    'mautic.core.variant_weights_invalid' => 'The sum of weights between all variants cannot be more than 100%',
    'mautic.form.lists.count' => 'At least one list value is required.',
    'mautic.form.lists.notblank' => 'List values cannot be blank.',
    'mautic.core.theme.missing.files' => 'The theme you tried to install is missing the following required files and thus could not be installed: %files%',
    'mautic.core.theme.default.cannot.overwrite' => '%name% is the default theme and therefore cannot be overwritten.',
    'mautic.core.valid_url_required' => 'A valid URL is required.',
    'mautic.core.theme.upload.empty' => 'The file was not selected. Select a ZIP file to upload.',
    'mautic.core.invalid_file_type' => 'Invalid file type {{ type }}. Use a file that matches one of the following mime types: {{ types }}.',
    'mautic.core.invalid_file_encoding' => 'The file is not encoded correctly into UTF-8.',
    'mautic.core.not.allowed.file.extension' => '%extension% is not an allowed file extension',
    'mautic.core.regex.invalid' => 'The regex syntax is invalid.',
    'mautic.api.client.callback.notblank' => 'A callback URI is required.',
    'mautic.api.client.redirecturis.notblank' => 'A redirect URI is required.',
    'mautic.api.client.redirecturl.invalid' => '%url% is an invalid URI.',
    'mautic.asset.asset.error.missing.file' => 'A file must be uploaded before Asset is saved when local storage is selected.',
    'mautic.asset.asset.error.missing.title' => 'Assset Title is required.',
    'mautic.asset.asset.error.missing.remote.path' => 'A remote URL must be specified when remote storage is selected.',
    'mautic.asset.asset.error.file.size' => 'Upload failed as the file is %fileSize% MB which exceeds the maximum allowed file size of %maxSize% MB. This setting can be changed in the Configuration.',
    'mautic.asset.asset.error.file.extension' => 'Upload failed as the file extension, %fileExtension%, is not in the list of allowed extensions (%extensions%). This setting can be changed in the Configuration.',
    'mautic.asset.asset.error.file.extension.js' => 'Upload failed as the file extension is not in the list of allowed extensions (%extensions%). This setting can be changed in the Configuration.',
    'mautic.asset.validation.error.url' => 'The remote should be a valid URL.',
    'mautic.asset.asset.error.file.mimetype' => 'Upload failed as the file mimetype, %fileMimetype% is not allowed. Allowed file types are %mimetypes%.',
    'mautic.asset.asset.error.invalid.mimetype' => 'Upload failed as the file mimetype, %fileMimetype% is not allowed. Allowed file types are %mimetypes%.',
    'mautic.campaign.form.events.notempty' => 'At least one event is required. Use the Launch Campaign Builder button to add one.',
    'mautic.campaign.form.sources.notempty' => 'At least one contact source is required. Use the Launch Campaign Builder button to add one.',
    'mautic.campaign.infiniteloop.immediate' => 'Campaign cannot restart itself without a delay. Please add at least 30 minute delay.',
    'mautic.campaign.infiniteloop.interval' => 'Your delay is only %count% minutes. It must be at least 30 minutes.',
    'mautic.config.peak_interaction_timer.best_default_hour.validation.range' => 'The hour end must be after the hour start.',
    'mautic.channel.choosemessage.notblank' => 'A message is required.',
    'mautic.dashboard.upload.filenotfound' => 'File not found',
    'mautic.dynamicContent.name.notblank' => 'Please enter a name.',
    'mautic.dynamicContent.slot_name.notblank' => 'Please enter a slot name.',
    'mautic.dynamicContent.filter.options.empty' => 'At least one filter is required.',
    'mautic.email.chooseemail.notblank' => 'Select the email to be sent.',
    'mautic.email.list.noaccess' => 'No list was selected or you do not have access to one that was.',
    'mautic.email.subject.notblank' => 'A subject is required.',
    'mautic.email.variant.weight.notblank' => 'Enter the percentage of recipients to receive this email.',
    'mautic.email.api_key_required' => 'API key is required.',
    'mautic.email.multiple_emails.not_valid' => 'Provided emails are not valid: %email%',
    'mautic.email.email_or_token.not_valid' => 'Provided value \'%value%\' is not an email address nor a token built on an email field type. %details%',
    'mautic.email.dsn.invalid_dsn' => 'Invalid DSN. Please make sure you entered all the needed fields.',
    'mautic.email.dsn.unsupported_scheme' => 'Unsupported scheme.',
    'mautic.email.preheader_text.length' => 'Preheader Text maximum length is 130 characters.',
    'mautic.email.subject.length' => 'Email subject maximum length is 190 characters.',
    'mautic.form.field.fields.count' => 'The form requires at least one field.',
    'mautic.form.field.generic.required' => 'This is required.',
    'mautic.form.field.generic.validationfailed' => '\'%label%\' is required.',
    'mautic.form.field.label.notblank' => 'Label is required.',
    'mautic.form.field.alias.unique' => 'Another field is already using this alias: %alias%. Please choose another or leave it blank to have it autogenerated.',
    'mautic.form.form.fields.notempty' => 'At least one field is required. Use the Fields tab to add one.',
    'mautic.form.form.postactionproperty_message.notblank' => 'Fill in a message to display.',
    'mautic.form.form.postactionproperty_redirect.notblank' => 'Fill in a valid URL.',
    'mautic.form.schema.failed' => 'There was an error creating the submission results table. Try a different name.',
    'mautic.form.submission.captcha.invalid' => 'The answer to %label% is incorrect. Please try again.',
    'mautic.form.submission.email.invalid' => 'The email is invalid.',
    'mautic.form.submission.url.invalid' => 'The URL is invalid.',
    'mautic.form.submission.phone.invalid' => 'Please use the following international phone number format [+][country code][subscriber number] for this field (eg: ‪+14028650000).',
    'mautic.form.submission.email.donotsubmit.invalid' => 'Cannot be sent with this email',
    'mautic.form.submission.error.file.extension' => 'Upload failed as the file extension, %fileExtension%, is not in the list of allowed extensions (%extensions%).',
    'mautic.form.submission.error.file.size' => 'Upload failed as the file is %fileSize% MB which exceeds the maximum allowed file size of %maxSize% MB.',
    'mautic.form.submission.error.file.uploadFailed' => 'Upload failed.',
    'mautic.form.form.progressive_profiling_limit.error' => 'This value should be empty or greater than 0',
    'mautic.install.database.driver.invalid' => 'Invalid database driver given. Must be one of %drivers%',
    'mautic.install.database.path.invalid' => 'The path is invalid or not writable.',
    'mautic.install.database.path.warning' => 'WARNING!! The path is within the public web root. This is not recommended due to the security risks. Consider changing the path to be outside of %root%.',
    'mautic.install.database.port.invalid' => 'The port must be an integer greater than 0.',
    'mautic.install.password.minlength' => 'Password must be at least 6 characters.',
    'mautic.integration.sync.missing_mautic_field_mappings' => 'The following Mautic fields are required and must be mapped: %fields%',
    'mautic.lead.avatar.types_invalid' => 'The avatar is an invalid image. Upload a gif, jpeg, or png image.',
    'mautic.lead.customfield.notblank' => 'This field is required.',
    'mautic.lead.email.body.required' => 'A message is required.',
    'mautic.lead.field.alias.unique' => 'Another field is already using this alias. Please choose another or leave it blank to have it autogenerated.',
    'mautic.lead.field.boolean.nomissing' => 'A \'negative\' label is required.',
    'mautic.lead.field.boolean.yesmissing' => 'A \'positive\' label is required.',
    'mautic.lead.field.failed' => 'There was an error creating the new column to the contact table: %error%.',
    'mautic.lead.field.label.notblank' => 'A label is required.',
    'mautic.lead.field.label.maxlength' => 'Label value cannot be longer than {{ limit }} characters',
    'mautic.lead.field.select.listmissing' => 'A list for the select box must be specified. Separate each option with a vertical bar. I.e. Green|Blue|Red',
    'mautic.lead.field.typenotrecognized' => 'There\'s a field type not recognized.',
    'mautic.lead.field.column.already.exists' => 'There was an error creating the custom field %field% because it already exists.',
    'mautic.lead.field.value.invalid' => 'Some field \'Values\' are invalid. Authorized characters are a-z A-Z 0-9 - _',
    'mautic.lead.import.filenotreadable' => 'Unable to read the imported csv file.',
    'mautic.lead.import.filetoolarge' => 'The file exceeds the maximum allowed upload size of %upload_max_filesize%.',
    'mautic.lead.import.matchfields' => 'You must match up at least one field.',
    'mautic.lead.import.dir.notblank' => 'An import directory is required.',
    'mautic.lead.import.file.notblank' => 'An import file is required.',
    'mautic.lead.list.alias.unique' => 'Alias is already in use. Please choose another or leave it blank to have it autogenerated.',
    'mautic.lead.lists.required' => 'At least one contact segment is required.',
    'mautic.lead.lists.failed' => 'Either no list was selected or you do not have access to one of the lists that was selected.',
    'mautic.lead.excluded_lists.conflicting' => 'The same segment cannot be excluded and included in the same time.',
    'mautic.lead.note.text.notblank' => 'Note text cannot be empty',
    'mautic.lead.submitaction.formfield.notblank' => 'Choose a form field.',
    'mautic.lead.submitaction.leadfield.notblank' => 'Choose a contact field.',
    'mautic.lead.time.invalid' => 'Time is not valid. Must be in HH:ii format where 00 <= HH <= 23 and 00 <= ii <= 59 e.g. 11:00.',
    'mautic.lead.date.invalid' => 'Date is not valid. Must be in Y-m-d format e.g. 1986-07-25.',
    'mautic.lead.datetime.invalid' => 'Invalid datetime format. Valid format is Y-m-d H:i e.g. 1986-07-25 11:00.',
    'mautic.company.choosecompany.notblank' => 'Choose a company',
    'mautic.lead.api.tag.required' => 'Tag label is required.',
    'mautic.lead.field.keyword.invalid' => 'The \'%keyword%\' keyword is reserved for segment filters. Please choose different alias.',
    'mautic.lead.field.keyword.restricted' => 'The alias \'%alias%\' is a restricted field. Please choose another one.',
    'mautic.lead.defaultValue.maxlengthexceeded' => 'Default value can\'t exceed %defaultValueLengthLimit% characters. The current length is %currentLength% characters.',
    'mautic.lead.defaultValue.invalid' => 'Default value is not valid.',
    'mautic.import.missing.required.fields' => 'Some required fields are missing. You must map the %fieldOrFields% "%requiredFields%."',
    'mautic.lead.contact.field.not.found' => 'Contact field with alias "%alias%" was not found.',
    'mautic.lead.contact.field.not.published' => 'Contact field with alias "%alias%" is not published.',
    'mautic.lead.contact.wrong.field.type' => 'Contact field "%alias%" is type of "%fieldType%" but must be type of "%expectedType%".',
    'mautic.lead_list.is_in_use' => 'This segment is used in %segments%, please go back and check segments before unpublishing',
    'mautic.import.file.required' => 'Please select a CSV file to upload',
    'mautic.lead.segment.date_invalid' => 'Date field filter value "%value%" is invalid. It must be in format YYYY-MM-DD or using keywords from the validated this you will find in the documentation. Please be careful not to use uppercase characters.',
    'mautic.lead.field.unique.is_used' => 'This field must be unique.',
    'mautic.lead.lists.used_in_campaigns' => '{1}This segment is used in %campaignNames% campaign. Please check it before unpublishing.|[2,Inf]This segment is used in the following campaigns: %campaignNames%. Please check them before unpublishing.',
    'mautic.messenger.dsn.invalid_dsn' => 'Invalid DSN. Please make sure you entered all the required fields. Usually the fields \'scheme\' and \'host\' are required.',
    'mautic.messenger.dsn.unsupported_scheme' => 'Unsupported scheme. Please make sure the entered scheme matches one of the supported schemes. You might need to install a package supporting the scheme first. For more details see https://symfony.com/doc/5.4/messenger.html#transport-configuration',
    'mautic.notification.choosenotification.notblank' => 'Please select a notification',
    'mautic.page.variant.weight.notblank' => 'Enter the percentage of unique hits that should be displayed this page.',
    'mautic.plugin.field.required_mapping_missing' => 'At least one required field is not mapped.',
    'mautic.point.form.actions.notempty' => 'At least one action is required.',
    'mautic.point.type.notblank' => 'A point action must be selected.',
    'mautic.point.delta.notblank' => 'A point change (delta) must be selected.',
    'mautic.report.schedule.notValid' => 'Schedule settings is not valid. Please fill all required fields',
    'mautic.report.schedule.to_address_required' => 'To address is required for scheduling report',
    'mautic.report.schedule.invalidScheduler' => 'Scheduler is not valid',
    'mautic.report.schedule.notSupportedType' => 'This scheduler is not supported',
    'mautic.sms.choosesms.notblank' => 'Please select a sms',
    'mautic.stage.form.actions.notempty' => 'At least one action is required.',
    'mautic.stage.type.notblank' => 'A stage action must be selected.',
    'mautic.user.user.email.unique' => 'Email is already in use. Please choose another.',
    'mautic.user.user.email.valid' => 'The email entered is invalid.',
    'mautic.user.user.firstname.notblank' => 'First name is required.',
    'mautic.user.user.lastname.notblank' => 'Last name is required.',
    'mautic.user.user.password.minlength' => 'Password must be at least 6 characters.',
    'mautic.user.user.password.mismatch' => 'Passwords do not match.',
    'mautic.user.user.password.notblank' => 'Password cannot be blank.',
    'mautic.user.user.passwordreset.notblank' => 'A username or email is required to reset your password.',
    'mautic.user.user.password.weak' => 'Please enter a stronger password. Your password must use a combination of upper and lower case, special characters and numbers.',
    'mautic.user.user.role.notblank' => 'A role must be chosen for this user.',
    'mautic.user.user.username.notblank' => 'Username is required.',
    'mautic.user.user.username.unique' => 'Username is already in use. Please choose another.',
    'mautic.user.saml.certificate.invalid' => 'Certificate is invalid. It should begin with <pre>-----BEGIN CERTIFICATE-----</pre>.',
    'mautic.user.saml.private_key.invalid' => 'Private key is invalid. It should begin with <pre>-----BEGIN RSA PRIVATE KEY-----</pre> or <pre>-----BEGIN ENCRYPTED PRIVATE KEY-----</pre>.',
    'mautic.user.saml.private_key.password_needed' => 'The private key provided is encrypted and thus requires a password to decrypt.',
    'mautic.user.saml.private_key.password_invalid' => 'The password was not able to decrypt the private key.',
    'mautic.user.saml.metadata.invalid' => 'The metadata file seems to be invalid.',
    'mautic.focus.error.select_type' => 'Use the builder to select what the focus should be.',
    'mautic.focus.error.select_style' => 'Use the builder to select what style should be used.',
    'mautic.focus.choosefocus.notblank' => 'A focus item is required.',
    'mautic.social.network.type' => 'A monitoring method is required.',
    'mautic.integration.Twitter.send.selecttweet.notblank' => 'The tweet list cannot be empty. Select one.',
  ),
  'fixtures' => 
  array (
    'mautic.lead.field.attribution' => 'Attribution',
    'mautic.lead.field.attribution_date' => 'Attribution Date',
    'mautic.lead.field.last_active' => 'Date Last Active',
    'mautic.lead.field.firstname' => 'First Name',
    'mautic.lead.field.lastname' => 'Last Name',
    'mautic.lead.field.company' => 'Primary company',
    'mautic.lead.field.email' => 'Email',
    'mautic.lead.field.position' => 'Position',
    'mautic.lead.field.points' => 'Points',
    'mautic.lead.field.title' => 'Title',
    'mautic.lead.field.phone' => 'Phone',
    'mautic.lead.field.mobile' => 'Mobile',
    'mautic.lead.field.fax' => 'Fax',
    'mautic.lead.field.address1' => 'Address Line 1',
    'mautic.lead.field.address2' => 'Address Line 2',
    'mautic.lead.field.website' => 'Website',
    'mautic.lead.field.twitter' => 'Twitter',
    'mautic.lead.field.foursquare' => 'Foursquare',
    'mautic.lead.field.facebook' => 'Facebook',
    'mautic.lead.field.instagram' => 'Instagram',
    'mautic.lead.field.skype' => 'Skype',
    'mautic.lead.field.city' => 'City',
    'mautic.lead.field.state' => 'State',
    'mautic.lead.field.zipcode' => 'Zip Code',
    'mautic.lead.field.country' => 'Country',
    'mautic.lead.field.gender' => 'Gender',
    'mautic.lead.field.preferred_locale' => 'Preferred Locale',
    'mautic.lead.field.timezone' => 'Preferred Timezone',
    'mautic.user.role.admin.name' => 'Administrator',
    'mautic.user.role.admin.description' => 'Full system access',
    'mautic.lead.field.companyemail' => 'Company Email',
    'mautic.lead.field.companyname' => 'Company Name',
    'mautic.lead.field.companyaddress1' => 'Address 1',
    'mautic.lead.field.companyaddress2' => 'Address 2',
    'mautic.lead.field.companycity' => 'City',
    'mautic.lead.field.companystate' => 'State',
    'mautic.lead.field.companycountry' => 'Country',
    'mautic.lead.field.companyzipcode' => 'Zip Code',
    'mautic.lead.field.companyindustry' => 'Industry',
    'mautic.lead.field.companyphone' => 'Phone',
    'mautic.lead.field.companydescription' => 'Description',
    'mautic.lead.field.companywebsite' => 'Website',
    'mautic.lead.field.companynumber_of_employees' => 'Number of Employees',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Annual Revenue',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn_US);

return $catalogue;
