<?php

/*
 * @copyright   2014 Mautic Contributors. All rights reserved
 * @author      Mautic
 *
 * @link        http://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace MauticPlugin\JotaworksDoiBundle\Controller;

use Mautic\CoreBundle\Controller\FormController;
use Mautic\FormBundle\Helper\FormFieldHelper;
use MauticPlugin\JotaworksDoiBundle\Helper\Base64Helper;
use MauticPlugin\JotaworksDoiBundle\QueueName;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\FormFactoryInterface;
use Doctrine\Persistence\ManagerRegistry;
use Mautic\CoreBundle\Factory\MauticFactory;
use Mautic\CoreBundle\Factory\ModelFactory;
use Mautic\CoreBundle\Helper\CoreParametersHelper;
use Mautic\CoreBundle\Helper\UserHelper;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Mautic\CoreBundle\Service\FlashBag;
use Mautic\CoreBundle\Translation\Translator;
use Symfony\Component\HttpFoundation\RequestStack;
use Mautic\CoreBundle\Security\Permissions\CorePermissions;

/**
 * Class DoiController.
 */
class DoiController extends FormController
{

    public function __construct(
        ContainerInterface $container,
        FormFactoryInterface $formFactory,
        FormFieldHelper $fieldHelper,
        ManagerRegistry $managerRegistry,
        MauticFactory $factory,
        ModelFactory $modelFactory,
        UserHelper $userHelper,
        CoreParametersHelper $coreParametersHelper,
        EventDispatcherInterface $dispatcher,
        Translator $translator,
        FlashBag $flashBag,
        RequestStack $requestStack,
        CorePermissions $security
    ) {
        $this->setContainer($container); // required by FormController
        $this->formFactory = $formFactory;
        $this->fieldHelper = $fieldHelper;
        $this->managerRegistry = $managerRegistry;
        $this->factory = $factory;
        $this->modelFactory = $modelFactory;
        $this->userHelper = $userHelper;
        $this->coreParametersHelper = $coreParametersHelper;
        $this->dispatcher = $dispatcher;
        $this->translator = $translator;
        $this->flashBag = $flashBag;
        $this->requestStack = $requestStack;
        $this->security = $security;
    }

    protected function decryptDoiActions($enc)
    {
        $leadModel = $this->getModel('lead');
        $encryptionHelper = $this->get('mautic.helper.encryption');

        //Get doi parameters
        if (!$enc) {
            http_response_code(400);
            die();
        }

        //get base64 string
        $base64 = Base64Helper::prepare_base64_url_decode($enc);

        //decrypt string
        $config = $encryptionHelper->decrypt($base64, true);
        if (!$config || !is_array($config)) {
            http_response_code(401);
            die();
        }

        $lead = $leadModel->getEntity($config['lead_id']);
        if (!$lead) {
            http_response_code(400);
            die();
        }
        $leadEmail = $lead !== null ? $lead->getEmail() : null;
        $config['leadEmail'] = $leadEmail;

        return $config;
    }


    /**
     * Doi confirmation action
     *
     * @param  string  $enc
     * @return JsonResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function indexAction($enc = false)
    {
        //try to decrypt doi action config
        $config = $this->decryptDoiActions($enc);
        if ($this->has('mautic.queue.service')) {
            $queueService = $this->get('mautic.queue.service');

            if ($queueService->isQueueEnabled()) {
                $payload = [
                    'config' => $config,
                    'doiActivationTime' => time(),
                    'request' => $this->request
                ];

                $queueService->publishToQueue(QueueName::DOI_SUCCESSFUL, $payload);

            }
        } else {
            $doiActionHelper = $this->get('jw.doi.actionhelper');
            $doiActionHelper->applyDoiActions($config);
        }

        //redirect to doi success url
        return $this->redirect($config['url'], 301);
    }

    /**
     * Click bait action for email scanning bots
     *
     * @param  string  $hash
     */
    public function nothumanAction($hash = false)
    {
        $notHumanClickHelper = $this->get('jw.doi.nothumanclickhelper');
        $notHumanClickHelper->setClick($hash);

        return $this->delegateView([
            'viewParameters' => [],
            'contentTemplate' => 'JotaworksDoiBundle:Doi:nothuman.html.php'
        ]);
    }

}
