# FPÖ Kärnten Newsletter Theme 2026 - Mautic Email Template

## Beschreibung
Professionelles Email-Template für Mautic mit GrapeJS Builder-Unterstützung, basierend auf MJML-Framework für optimale Email-Kompatibilität.

## Features
- ✅ **GrapeJS Builder kompatibel** - Vollständig editierbar im Mautic Email Builder
- ✅ **MJML-basiert** - Responsive und Email-Client-optimiert
- ✅ **Mautic Token Support** - Unterstützt {webview_url}, Lead-Felder, etc.
- ✅ **Twig Template Support** - Dynamische Personalisierung mit Twig-Logik
- ✅ **Responsive Design** - Optimiert für Desktop, Tablet und Mobile
- ✅ **Multi-Column Layouts** - Flexible 1-, 2- und 3-Spalten-Layouts
- ✅ **Social Media Icons** - WhatsApp, Facebook, Instagram, YouTube

## Installation

### Schritt 1: Theme hochladen
1. Melde dich in deiner Mautic-Instanz an
2. Navigiere zu **Einstellungen** (Zahnrad-Symbol) → **Themes**
3. Klicke auf **Theme installieren**
4. Lade die Datei `fpoe-kaernten-newsletter-2026.zip` hoch
5. Klicke auf **Hochladen**

### Schritt 2: Email erstellen
1. Gehe zu **Channels** → **Emails**
2. Klicke auf **Neu**
3. Wähle den **GrapeJS Builder**
4. Wähle das Theme **"FPÖ Kärnten Newsletter 2026"**
5. Beginne mit der Bearbeitung!

## Theme-Struktur

```
fpoe-kaernten-newsletter-2026/
├── config.json                 # Theme-Konfiguration
├── composer.json               # Composer-Dependencies
├── thumbnail.png               # Theme-Vorschaubild
├── html/
│   ├── email.html.twig        # Haupt-Email-Template (MJML)
│   ├── base.html.twig         # Basis-Layout
│   └── message.html.twig      # Einfaches Text-Message-Layout
└── assets/
    ├── fpoe_logo_wappen_klub_farbe_1.png
    ├── fpoe_logo_wappen_klub_wei1_1.png
    ├── fp_landtagsclub_farbe_transparent_1.png
    ├── banner1.jpg
    ├── banner3.png
    ├── banner6.jpg
    ├── banner7.jpg
    ├── fanshop.jpg
    ├── top-aktuell.png
    ├── fb-white.png
    ├── ig-white.png
    ├── yt-white.png
    ├── whatsapp_icon.png
    ├── mail-icon.png
    └── ... (weitere Assets)
```

## Verwendung der Mautic-Token

Das Template unterstützt folgende Mautic-Tokens:

### Standard-Tokens
- `{webview_url}` - Link zur Web-Version der Email
- `{unsubscribe_url}` - Abmelde-Link
- `{signature}` - Email-Signatur

### Lead-Felder (Personalisierung)
Das Template enthält eine intelligente Begrüßungslogik:

```twig
{% TWIG_BLOCK %}
{% if lead.firstname is not empty and lead.salutation == "Herr" %}
  Lieber {{lead.firstname}}
{% elseif lead.firstname is not empty and lead.salutation == "Frau" %}
  Liebe {{lead.firstname}}
{% else %}
  Servus
{% endif %}
{% END_TWIG_BLOCK %}
```

### Verfügbare Lead-Felder
- `{contactfield=firstname}` - Vorname
- `{contactfield=lastname}` - Nachname
- `{contactfield=email}` - Email-Adresse
- `{contactfield=salutation}` - Anrede (Herr/Frau)

## Anpassung der Inhalte im GrapeJS Builder

### 1. Texte bearbeiten
- Klicke auf einen Textblock
- Bearbeite den Inhalt direkt im Editor
- Formatierung über die Toolbar verfügbar

### 2. Bilder austauschen
- Klicke auf ein Bild
- Rechte Sidebar → "Image URL" ändern
- Oder: Eigene Bilder hochladen über Mautic Media Manager

### 3. Links anpassen
- Klicke auf einen Link/Button
- Rechte Sidebar → "Link" Feld bearbeiten
- Target (Öffnungsverhalten) einstellen

### 4. Farben ändern
Das Template verwendet folgende Hauptfarben:
- **Primärfarbe (FPÖ Blau)**: `#0056A2`
- **Dunkelblau**: `#064D8C`
- **Textfarbe**: `#3A4044`
- **Grau**: `#CBCBCB`
- **Hintergrund**: `#F7F7F7`

### 5. Social Media Links
Die Social Media Icons im Footer können angepasst werden:
- Facebook: Standard-Link zu `facebook.com/erwinangerer.at`
- Instagram: Standard-Link zu `instagram.com/erwinangerer.at`
- YouTube: Standard-Link zu `youtube.com/@fpoe_kaernten`
- WhatsApp: Standard-Link zu WhatsApp Kanal

## MJML zu HTML Konvertierung

Mautic konvertiert das MJML-Template automatisch zu HTML beim Speichern. Das stellt sicher:
- ✅ Maximale Email-Client-Kompatibilität
- ✅ Responsive Design auf allen Geräten
- ✅ Outlook-Kompatibilität
- ✅ Mobile Optimierung

## Template-Komponenten

### Header-Bereich
- Webversion-Link
- Logo + Newsletter-Datum
- Blauer Header mit Slogan
- Top-Banner mit Hintergrundbild

### Content-Bereiche
- Personalisierte Begrüßung mit Twig-Logik
- Einführungstext mit Unterschrift
- Hero-Bild / Banner
- 2-Spalten-Text-Layouts
- Call-to-Action Buttons
- Trennlinien (Divider)
- Bild-Grid (2-Spalten)

### Footer-Bereich
- Blaue Leiste mit Logo + Social Icons
- Kontaktinformationen (3-spaltig):
  - Adresse
  - Email/Kontakt
  - Impressum/Datenschutz
- Abmelde-Link

## Best Practices

### Email-Versand
1. **Teste vor dem Versand**: Nutze die Test-Email-Funktion
2. **Prüfe auf allen Geräten**: Desktop, Mobile, Tablet
3. **Validiere Links**: Alle Links sollten funktionieren
4. **Personalisierung testen**: Teste mit verschiedenen Lead-Daten

### Performance
- Bilder sind optimiert, aber nicht zu groß (<500KB pro Bild)
- Inline-CSS wird von MJML automatisch generiert
- Email-Client-spezifische Hacks sind integriert

### Barrierefreiheit
- Alt-Texte für alle Bilder vorhanden
- Ausreichende Farbkontraste
- Klare Linkbeschriftungen

## Troubleshooting

### Theme wird nicht angezeigt
1. Cache leeren: `php bin/console cache:clear`
2. Prüfe Dateirechte: Theme-Ordner muss lesbar sein
3. Prüfe config.json auf Syntax-Fehler

### Bilder werden nicht angezeigt
1. Prüfe, ob Assets im `assets/` Ordner vorhanden sind
2. Prüfe Asset-URLs in der Email-Vorschau
3. Verwende absolute URLs für externe Bilder

### GrapeJS Builder zeigt Fehler
1. Stelle sicher, dass "grapesjsbuilder" in config.json aktiviert ist
2. Update auf die neueste Mautic-Version
3. Prüfe Browser-Console auf JavaScript-Fehler

## Technische Details

### Kompatibilität
- **Mautic**: Version 4.x und 5.x
- **PHP**: 7.4 oder höher (8.0+ empfohlen)
- **Email-Clients**: 
  - Gmail (Desktop/Mobile)
  - Outlook (2013+, 365, Mac)
  - Apple Mail
  - iOS Mail
  - Android Mail
  - Yahoo Mail
  - Samsung Mail

### Template-Engine
- **MJML**: Version 4.x
- **Twig**: Version 2.x/3.x (Mautic-integriert)
- **GrapeJS**: Mautic Email Builder Integration

## Support & Anpassungen

### Benötigst du Hilfe?
- Für technische Fragen: Mautic Community Forum
- Für Anpassungen: cause.buzz

### Eigene Anpassungen
Das Theme kann frei angepasst werden:
1. Entpacke die ZIP-Datei
2. Bearbeite `html/email.html.twig`
3. Passe `config.json` an (Name, Version, etc.)
4. Erstelle neue ZIP-Datei
5. Lade in Mautic hoch

## Changelog

### Version 2.0.0 (2026)
- ✨ Initiale Version basierend auf MJML
- ✨ GrapeJS Builder Support
- ✨ Vollständige Mautic 5.x Kompatibilität
- ✨ Responsive Multi-Column Layouts
- ✨ Social Media Integration
- ✨ Twig-basierte Personalisierung

## Lizenz
© 2026 Cause.Buzz - Alle Rechte vorbehalten

---

**Erstellt für:** Freiheitlicher Landtagsklub in Kärnten  
**Version:** 2.0.0  
**Datum:** Februar 2026
