<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @themes/causebuzz-grapejs-suite-causebuzz-master-gridfix3/causebuzz-grapejs-blocks.js */
class __TwigTemplate_b4b21485368c43e09496be9b12535928 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "/**
 * 🚀 Cause.Buzz Professional GrapeJS Template Suite
 * Modern drag-and-drop email builder components
 * Version: 2.0.0
 */

const CauseBuzzGrapeJS = (editor) => {
  const blockManager = editor.BlockManager;
  const domComponents = editor.DomComponents;
  const styleManager = editor.StyleManager;
  const traitManager = editor.TraitManager;

  // Cause.Buzz Design System
  const designSystem = {
    colors: {
      primary: '#2563eb',
      primaryDark: '#1d4ed8',
      secondary: '#60a5fa',
      background: '#0f172a',
      surface: '#1e293b',
      surfaceLight: '#334155',
      surfaceDark: '#475569',
      text: '#ffffff',
      textMuted: '#cbd5e1',
      textSecondary: '#94a3b8',
      success: '#059669',
      successDark: '#047857',
      accent: '#3b82f6',
      border: '#475569',
      footerText: '#64748b'
    },
    
    gradients: {
      primary: 'linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%)',
      background: 'linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%)',
      surface: 'linear-gradient(135deg, #1e293b 0%, #334155 100%)',
      surfaceAlt: 'linear-gradient(135deg, #334155 0%, #475569 100%)',
      success: 'linear-gradient(135deg, #059669 0%, #047857 100%)',
      accent: 'linear-gradient(135deg, #3b82f6 0%, #2563eb 100%)'
    },
    
    fonts: {
      family: \"-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif\",
      sizes: {
        xs: '12px',
        sm: '14px',
        base: '16px',
        lg: '18px',
        xl: '20px',
        '2xl': '24px',
        '3xl': '28px',
        '4xl': '32px'
      },
      weights: {
        normal: '400',
        medium: '500',
        semibold: '600',
        bold: '700'
      }
    },
    
    spacing: {
      xs: '8px',
      sm: '12px',
      md: '16px',
      lg: '20px',
      xl: '24px',
      '2xl': '32px',
      '3xl': '40px',
      '4xl': '48px'
    },
    
    borderRadius: {
      sm: '6px',
      md: '8px',
      lg: '12px',
      full: '50%'
    }
  };

  // Utility Functions
  const createMediaPreview = (content, background = designSystem.colors.surface) => {
    return `<div style=\"width:100%;height:50px;background:\${background};display:flex;align-items:center;justify-content:center;color:white;font-size:10px;border-radius:4px;\">\${content}</div>`;
  };

  // CSS Framework Injection
  const injectCauseBuzzCSS = () => {
    const cssFramework = `
      /* Cause.Buzz Email Framework */
      .cb-container {
        max-width: 600px;
        margin: 0 auto;
        background: \${designSystem.gradients.background};
        font-family: \${designSystem.fonts.family};
        color: \${designSystem.colors.text};
        line-height: 1.6;
      }
      
      .cb-section {
        padding: \${designSystem.spacing['3xl']} \${designSystem.spacing.xl};
        background: \${designSystem.colors.surface};
      }
      
      .cb-section-alt {
        background: \${designSystem.colors.background};
      }
      
      .cb-section-highlight {
        background: rgba(37, 99, 235, 0.1);
        border: 1px solid rgba(37, 99, 235, 0.2);
        border-radius: \${designSystem.borderRadius.lg};
        margin: \${designSystem.spacing.lg} 0;
      }
      
      /* Typography */
      .cb-headline {
        font-size: \${designSystem.fonts.sizes['3xl']};
        font-weight: \${designSystem.fonts.weights.semibold};
        color: \${designSystem.colors.text};
        margin-bottom: \${designSystem.spacing.lg};
        line-height: 1.2;
        text-align: center;
      }
      
      .cb-subheading {
        font-size: \${designSystem.fonts.sizes.xl};
        font-weight: \${designSystem.fonts.weights.medium};
        color: \${designSystem.colors.secondary};
        margin-bottom: \${designSystem.spacing.md};
        line-height: 1.4;
      }
      
      .cb-text {
        font-size: \${designSystem.fonts.sizes.base};
        color: \${designSystem.colors.textMuted};
        margin-bottom: \${designSystem.spacing.lg};
        line-height: 1.6;
      }
      
      .cb-text-center { text-align: center; }
      .cb-text-left { text-align: left; }
      
      /* Buttons */
      .cb-btn {
        display: inline-block;
        padding: \${designSystem.spacing.md} \${designSystem.spacing['2xl']};
        text-decoration: none;
        border-radius: \${designSystem.borderRadius.md};
        font-weight: \${designSystem.fonts.weights.medium};
        font-size: \${designSystem.fonts.sizes.base};
        border: none;
        transition: all 0.3s ease;
        margin: \${designSystem.spacing.sm};
        text-align: center;
        cursor: pointer;
      }
      
      .cb-btn-primary {
        background: \${designSystem.gradients.primary};
        color: \${designSystem.colors.text} !important;
        box-shadow: 0 8px 25px rgba(37, 99, 235, 0.4);
      }
      
      .cb-btn-secondary {
        background: transparent;
        color: \${designSystem.colors.secondary} !important;
        border: 2px solid \${designSystem.colors.accent};
      }
      
      .cb-btn-success {
        background: \${designSystem.gradients.success};
        color: \${designSystem.colors.text} !important;
        box-shadow: 0 8px 25px rgba(5, 150, 105, 0.4);
      }
      
      /* Layout */
      .cb-grid-2 {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: \${designSystem.spacing.lg};
      }
      
      .cb-grid-3 {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: \${designSystem.spacing.lg};
      }
      
      .cb-flex-center {
        display: flex;
        align-items: center;
        justify-content: center;
      }
      
      /* Components */
      .cb-header {
        background: \${designSystem.gradients.surfaceAlt};
        padding: \${designSystem.spacing['3xl']} \${designSystem.spacing.xl} \${designSystem.spacing.xl};
        text-align: center;
        position: relative;
        border-bottom: 2px solid \${designSystem.colors.primary};
      }
      
      .cb-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-image: radial-gradient(circle at 25% 25%, rgba(59, 130, 246, 0.1) 0%, transparent 50%),
                          radial-gradient(circle at 75% 75%, rgba(37, 99, 235, 0.1) 0%, transparent 50%);
        pointer-events: none;
      }
      
      .cb-logo {
        max-width: 180px;
        height: auto;
        margin-bottom: \${designSystem.spacing.lg};
        position: relative;
        z-index: 1;
      }
      
      .cb-feature-box {
        background: \${designSystem.gradients.surface};
        border: 1px solid \${designSystem.colors.border};
        border-radius: \${designSystem.borderRadius.lg};
        padding: \${designSystem.spacing.xl};
        text-align: center;
        transition: all 0.3s ease;
      }
      
      .cb-feature-icon {
        width: 60px;
        height: 60px;
        background: \${designSystem.gradients.accent};
        border-radius: \${designSystem.borderRadius.full};
        margin: 0 auto \${designSystem.spacing.md};
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: \${designSystem.fonts.sizes['2xl']};
        color: \${designSystem.colors.text};
      }
      
      .cb-badge {
        display: inline-block;
        background: \${designSystem.gradients.success};
        color: \${designSystem.colors.text};
        padding: \${designSystem.spacing.xs} \${designSystem.spacing.md};
        border-radius: \${designSystem.borderRadius.sm};
        font-size: \${designSystem.fonts.sizes.xs};
        font-weight: \${designSystem.fonts.weights.medium};
        margin: 0 \${designSystem.spacing.xs} \${designSystem.spacing.xs};
      }
      
      .cb-badge-primary {
        background: \${designSystem.gradients.primary};
      }
      
      .cb-badge-accent {
        background: \${designSystem.gradients.accent};
      }
      
      .cb-stats-box {
        background: rgba(37, 99, 235, 0.1);
        border: 1px solid rgba(37, 99, 235, 0.2);
        border-radius: \${designSystem.borderRadius.lg};
        padding: \${designSystem.spacing['2xl']};
        text-align: center;
      }
      
      .cb-stat-number {
        font-size: \${designSystem.fonts.sizes['3xl']};
        font-weight: \${designSystem.fonts.weights.bold};
        color: \${designSystem.colors.secondary};
        display: block;
        margin-bottom: \${designSystem.spacing.xs};
      }
      
      .cb-stat-label {
        font-size: \${designSystem.fonts.sizes.sm};
        color: \${designSystem.colors.textSecondary};
      }
      
      .cb-social-links {
        text-align: center;
        padding: \${designSystem.spacing.lg} 0;
      }
      
      .cb-social-link {
        display: inline-block;
        width: 50px;
        height: 50px;
        background: \${designSystem.gradients.accent};
        border-radius: \${designSystem.borderRadius.full};
        text-decoration: none;
        color: \${designSystem.colors.text};
        font-size: \${designSystem.fonts.sizes.lg};
        line-height: 50px;
        text-align: center;
        margin: 0 \${designSystem.spacing.sm};
        transition: transform 0.3s ease;
      }
      
      .cb-footer {
        background: \${designSystem.gradients.background};
        padding: \${designSystem.spacing['3xl']} \${designSystem.spacing.xl} \${designSystem.spacing.xl};
        text-align: center;
        border-top: 1px solid rgba(255, 255, 255, 0.1);
      }
      
      .cb-footer-text {
        font-size: \${designSystem.fonts.sizes.sm};
        color: \${designSystem.colors.footerText};
        margin-bottom: \${designSystem.spacing.md};
        line-height: 1.5;
      }
      
      .cb-footer-links a {
        color: \${designSystem.colors.secondary};
        text-decoration: none;
        margin: 0 \${designSystem.spacing.md};
        font-size: \${designSystem.fonts.sizes.sm};
      }
      
      .cb-divider {
        height: 1px;
        background: rgba(255, 255, 255, 0.1);
        margin: \${designSystem.spacing.xl} 0;
      }
      
      /* Responsive Design */
      @media only screen and (max-width: 600px) {
        .cb-section {
          padding: \${designSystem.spacing.lg} \${designSystem.spacing.md} !important;
        }
        
        .cb-headline {
          font-size: \${designSystem.fonts.sizes['2xl']} !important;
        }
        
        .cb-subheading {
          font-size: \${designSystem.fonts.sizes.lg} !important;
        }
        
        .cb-grid-2,
        .cb-grid-3 {
          grid-template-columns: 1fr !important;
          gap: \${designSystem.spacing.md} !important;
        }
        
        .cb-btn {
          display: block !important;
          width: 100% !important;
          margin: \${designSystem.spacing.sm} 0 !important;
        }
        
        .cb-social-link {
          margin: \${designSystem.spacing.xs} !important;
        }
        
        .cb-footer-links a {
          display: block !important;
          margin: \${designSystem.spacing.xs} 0 !important;
        }
      }
      
      /* Print Styles */
      @media print {
        .cb-container {
          background: #ffffff !important;
          color: #000000 !important;
        }
        
        .cb-social-links,
        .cb-btn {
          display: none !important;
        }
      }
      
      /* High Contrast Support */
      @media (prefers-contrast: high) {
        .cb-badge,
        .cb-btn-primary {
          border: 2px solid #ffffff !important;
        }
      }
    `;
    
    // Inject CSS into editor
    editor.on('load', () => {
      const existingCSS = editor.getCss();
      editor.setStyle(existingCSS + cssFramework);
    });
  };

  // Block Category Configuration
  const blockCategory = {
    id: 'causebuzz-professional',
    label: '🚀 Cause.Buzz Pro',
    open: true
  };

  // 1. PROFESSIONAL HEADER BLOCK
  blockManager.add('cb-header-pro', {
    label: '🏢 CB Header Pro',
    category: blockCategory.label,
    media: createMediaPreview('🏢 Professional Header', designSystem.gradients.surfaceAlt),
    content: {
      type: 'cb-header-pro',
      classes: ['cb-header'],
      components: [
        {
          tagName: 'img',
          type: 'image',
          classes: ['cb-logo'],
          attributes: {
            src: 'https://demo.cause.buzz/assets/causebuzz-logo.png',
            alt: 'Cause.Buzz Logo'
          },
          style: {
            position: 'relative',
            'z-index': '1'
          }
        },
        {
          tagName: 'div',
          style: {
            position: 'relative',
            'z-index': '1',
            'margin-top': designSystem.spacing.md
          },
          components: [
            {
              tagName: 'span',
              type: 'text',
              content: '🚀 Ganzheitliche Marketing-Plattform',
              classes: ['cb-badge'],
              editable: true
            },
            {
              tagName: 'span',
              type: 'text',
              content: '🇪🇺 EU-Server',
              classes: ['cb-badge', 'cb-badge-primary'],
              editable: true
            },
            {
              tagName: 'span',
              type: 'text',
              content: '🔒 DSGVO-konform',
              classes: ['cb-badge'],
              editable: true
            }
          ]
        }
      ]
    }
  });

  // 2. DYNAMIC HERO SECTION
  blockManager.add('cb-hero-dynamic', {
    label: '🎯 CB Hero Dynamic',
    category: blockCategory.label,
    media: createMediaPreview('🎯 Dynamic Hero Section', designSystem.gradients.background),
    content: {
      type: 'cb-hero-dynamic',
      classes: ['cb-section', 'cb-text-center'],
      style: {
        background: designSystem.gradients.background,
        position: 'relative'
      },
      components: [
        {
          tagName: 'div',
          style: {
            position: 'absolute',
            top: '0',
            left: '0',
            right: '0',
            bottom: '0',
            'background-image': 'url(\"data:image/svg+xml,<svg xmlns=\\\\\"http://www.w3.org/2000/svg\\\\\" width=\\\\\"60\\\\\" height=\\\\\"60\\\\\" viewBox=\\\\\"0 0 60 60\\\\\"><g fill-opacity=\\\\\"0.03\\\\\" fill=\\\\\"%23ffffff\\\\\"><rect width=\\\\\"1\\\\\" height=\\\\\"1\\\\\"/></g></svg>\")',
            'background-size': '60px 60px',
            'z-index': '0'
          }
        },
        {
          tagName: 'div',
          style: {
            position: 'relative',
            'z-index': '1'
          },
          components: [
            {
              tagName: 'h1',
              type: 'text',
              content: 'Marketing-Power vereint',
              classes: ['cb-headline'],
              editable: true,
              traits: [
                {
                  type: 'text',
                  label: 'Headline Text',
                  name: 'content'
                }
              ]
            },
            {
              tagName: 'p',
              type: 'text',
              content: 'Newsletter-Tools, Marketing Automation & Meinungs-Kampagnen',
              classes: ['cb-subheading', 'cb-text-center'],
              editable: true
            },
            {
              tagName: 'p',
              type: 'text',
              content: 'Cause.Buzz vereint die Funktionalitäten von Newsletter-Tools, Marketing Automation Software und Dienstleistungen für erfolgreiche Meinungs-Kampagnen und Zielgruppenansprachen.',
              classes: ['cb-text', 'cb-text-center'],
              style: {
                'max-width': '500px',
                margin: '0 auto 30px'
              },
              editable: true
            },
            {
              tagName: 'div',
              classes: ['cb-text-center'],
              style: {
                margin: '30px 0'
              },
              components: [
                {
                  tagName: 'a',
                  type: 'link',
                  content: '✨ Kostenlose Demo anfordern',
                  classes: ['cb-btn', 'cb-btn-primary'],
                  attributes: {
                    href: 'https://demo.cause.buzz'
                  },
                  editable: true
                }
              ]
            }
          ]
        }
      ]
    }
  });

  // 3. FEATURE GRID 2x2
  blockManager.add('cb-features-grid', {
    label: '🎛️ CB Features Grid',
    category: blockCategory.label,
    media: createMediaPreview('🎛️ 2x2 Features Grid', designSystem.colors.surface),
    content: {
      type: 'cb-features-grid',
      classes: ['cb-section'],
      components: [
        {
          tagName: 'h2',
          type: 'text',
          content: '🎯 Ihre Vorteile mit Cause.Buzz',
          classes: ['cb-headline'],
          editable: true
        },
        {
          tagName: 'div',
          classes: ['cb-grid-2'],
          components: [
            {
              type: 'cb-feature-box',
              classes: ['cb-feature-box'],
              components: [
                {
                  tagName: 'div',
                  classes: ['cb-feature-icon'],
                  content: '📊',
                  editable: true
                },
                {
                  tagName: 'h3',
                  type: 'text',
                  content: 'Newsletter-Tools',
                  style: {
                    color: designSystem.colors.text,
                    'font-size': designSystem.fonts.sizes.base,
                    'margin-bottom': designSystem.spacing.xs,
                    'font-weight': designSystem.fonts.weights.semibold
                  },
                  editable: true
                },
                {
                  tagName: 'p',
                  type: 'text',
                  content: 'Professionelle E-Mail-Kampagnen mit maximaler Zustellbarkeit',
                  classes: ['cb-text'],
                  style: {
                    color: designSystem.colors.textSecondary,
                    'font-size': designSystem.fonts.sizes.sm,
                    margin: '0'
                  },
                  editable: true
                }
              ]
            },
            {
              type: 'cb-feature-box',
              classes: ['cb-feature-box'],
              components: [
                {
                  tagName: 'div',
                  classes: ['cb-feature-icon'],
                  content: '⚡',
                  editable: true
                },
                {
                  tagName: 'h3',
                  type: 'text',
                  content: 'Marketing Automation',
                  style: {
                    color: designSystem.colors.text,
                    'font-size': designSystem.fonts.sizes.base,
                    'margin-bottom': designSystem.spacing.xs,
                    'font-weight': designSystem.fonts.weights.semibold
                  },
                  editable: true
                },
                {
                  tagName: 'p',
                  type: 'text',
                  content: 'Automatisierte Workflows für effizientes Marketing',
                  classes: ['cb-text'],
                  style: {
                    color: designSystem.colors.textSecondary,
                    'font-size': designSystem.fonts.sizes.sm,
                    margin: '0'
                  },
                  editable: true
                }
              ]
            },
            {
              type: 'cb-feature-box',
              classes: ['cb-feature-box'],
              components: [
                {
                  tagName: 'div',
                  classes: ['cb-feature-icon'],
                  content: '🎯',
                  editable: true
                },
                {
                  tagName: 'h3',
                  type: 'text',
                  content: 'Meinungs-Kampagnen',
                  style: {
                    color: designSystem.colors.text,
                    'font-size': designSystem.fonts.sizes.base,
                    'margin-bottom': designSystem.spacing.xs,
                    'font-weight': designSystem.fonts.weights.semibold
                  },
                  editable: true
                },
                {
                  tagName: 'p',
                  type: 'text',
                  content: 'Gezielte Kampagnen für Meinungsbildung und Aktivierung',
                  classes: ['cb-text'],
                  style: {
                    color: designSystem.colors.textSecondary,
                    'font-size': designSystem.fonts.sizes.sm,
                    margin: '0'
                  },
                  editable: true
                }
              ]
            },
            {
              type: 'cb-feature-box',
              classes: ['cb-feature-box'],
              components: [
                {
                  tagName: 'div',
                  classes: ['cb-feature-icon'],
                  content: '🛡️',
                  editable: true
                },
                {
                  tagName: 'h3',
                  type: 'text',
                  content: 'DSGVO-konform',
                  style: {
                    color: designSystem.colors.text,
                    'font-size': designSystem.fonts.sizes.base,
                    'margin-bottom': designSystem.spacing.xs,
                    'font-weight': designSystem.fonts.weights.semibold
                  },
                  editable: true
                },
                {
                  tagName: 'p',
                  type: 'text',
                  content: '100% DSGVO-konform auf EU-Servern gehostet',
                  classes: ['cb-text'],
                  style: {
                    color: designSystem.colors.textSecondary,
                    'font-size': designSystem.fonts.sizes.sm,
                    margin: '0'
                  },
                  editable: true
                }
              ]
            }
          ]
        }
      ]
    }
  });

  // 4. STATISTICS SECTION
  blockManager.add('cb-stats-section', {
    label: '📊 CB Statistics',
    category: blockCategory.label,
    media: createMediaPreview('📊 Statistics Section', 'rgba(37, 99, 235, 0.2)'),
    content: {
      type: 'cb-stats-section',
      classes: ['cb-section'],
      components: [
        {
          tagName: 'div',
          classes: ['cb-stats-box'],
          components: [
            {
              tagName: 'h3',
              type: 'text',
              content: '🚀 Vertrauen Sie auf Erfahrung',
              classes: ['cb-headline'],
              editable: true
            },
            {
              tagName: 'div',
              classes: ['cb-grid-3'],
              style: {
                'margin-top': designSystem.spacing.lg
              },
              components: [
                {
                  tagName: 'div',
                  classes: ['cb-text-center'],
                  components: [
                    {
                      tagName: 'span',
                      type: 'text',
                      content: '15+',
                      classes: ['cb-stat-number'],
                      editable: true
                    },
                    {
                      tagName: 'div',
                      type: 'text',
                      content: 'Jahre Erfahrung',
                      classes: ['cb-stat-label'],
                      editable: true
                    }
                  ]
                },
                {
                  tagName: 'div',
                  classes: ['cb-text-center'],
                  components: [
                    {
                      tagName: 'span',
                      type: 'text',
                      content: '500+',
                      classes: ['cb-stat-number'],
                      editable: true
                    },
                    {
                      tagName: 'div',
                      type: 'text',
                      content: 'Erfolgreiche Projekte',
                      classes: ['cb-stat-label'],
                      editable: true
                    }
                  ]
                },
                {
                  tagName: 'div',
                  classes: ['cb-text-center'],
                  components: [
                    {
                      tagName: 'span',
                      type: 'text',
                      content: '99.9%',
                      classes: ['cb-stat-number'],
                      editable: true
                    },
                    {
                      tagName: 'div',
                      type: 'text',
                      content: 'Verfügbarkeit',
                      classes: ['cb-stat-label'],
                      editable: true
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    }
  });

  // 5. DUAL CTA SECTION
  blockManager.add('cb-dual-cta', {
    label: '🎯 CB Dual CTA',
    category: blockCategory.label,
    media: createMediaPreview('🎯 Dual Call-to-Action', designSystem.colors.background),
    content: {
      type: 'cb-dual-cta',
      classes: ['cb-section', 'cb-section-alt', 'cb-text-center'],
      components: [
        {
          tagName: 'h3',
          type: 'text',
          content: 'Bereit für den nächsten Schritt?',
          classes: ['cb-headline'],
          editable: true
        },
        {
          tagName: 'p',
          type: 'text',
          content: 'Vereinbaren Sie noch heute Ihre kostenlose Demo und entdecken Sie die Möglichkeiten von Cause.Buzz!',
          classes: ['cb-text'],
          editable: true
        },
        {
          tagName: 'div',
          style: {
            margin: '30px 0'
          },
          components: [
            {
              tagName: 'a',
              type: 'link',
              content: '🎯 Jetzt Demo buchen',
              classes: ['cb-btn', 'cb-btn-primary'],
              attributes: {
                href: 'https://demo.cause.buzz'
              },
              editable: true
            },
            {
              tagName: 'a',
              type: 'link',
              content: '💰 Preise ansehen',
              classes: ['cb-btn', 'cb-btn-secondary'],
              attributes: {
                href: 'https://cause.buzz/preise'
              },
              editable: true
            }
          ]
        }
      ]
    }
  });

  // 6. CONTENT SECTION WITH RICH TEXT
  blockManager.add('cb-content-rich', {
    label: '📝 CB Content Rich',
    category: blockCategory.label,
    media: createMediaPreview('📝 Rich Content Section', designSystem.colors.surface),
    content: {
      type: 'cb-content-rich',
      classes: ['cb-section'],
      components: [
        {
          tagName: 'h2',
          type: 'text',
          content: 'Ihr Content-Titel',
          classes: ['cb-subheading'],
          editable: true
        },
        {
          tagName: 'div',
          type: 'text',
          content: `
            <p class=\"cb-text\">Hier können Sie Ihren individuellen Content einfügen. Diese Sektion unterstützt:</p>
            <ul class=\"cb-text\" style=\"padding-left: 20px; margin-bottom: 20px;\">
              <li>📧 Newsletter-Inhalte</li>
              <li>🎯 Marketing-Nachrichten</li>
              <li>📈 Produkt-Updates</li>
              <li>🔔 Wichtige Ankündigungen</li>
            </ul>
            <p class=\"cb-text\">Nutzen Sie die Drag & Drop Funktionalität, um weitere Elemente hinzuzufügen und Ihr perfektes E-Mail-Layout zu erstellen.</p>
          `,
          editable: true
        }
      ]
    }
  });

  // 7. SOCIAL MEDIA SECTION
  blockManager.add('cb-social-pro', {
    label: '📱 CB Social Pro',
    category: blockCategory.label,
    media: createMediaPreview('📱 Social Media Links', designSystem.colors.surface),
    content: {
      type: 'cb-social-pro',
      classes: ['cb-section', 'cb-text-center'],
      components: [
        {
          tagName: 'p',
          type: 'text',
          content: 'Folgen Sie uns für Marketing-Tipps und Updates:',
          classes: ['cb-text'],
          style: {
            'margin-bottom': designSystem.spacing.lg
          },
          editable: true
        },
        {
          tagName: 'div',
          classes: ['cb-social-links'],
          components: [
            {
              tagName: 'a',
              type: 'link',
              content: '💼',
              classes: ['cb-social-link'],
              attributes: {
                href: '#',
                'aria-label': 'LinkedIn'
              },
              traits: [
                {
                  type: 'text',
                  label: 'LinkedIn URL',
                  name: 'href'
                }
              ]
            },
            {
              tagName: 'a',
              type: 'link',
              content: '🐦',
              classes: ['cb-social-link'],
              attributes: {
                href: '#',
                'aria-label': 'Twitter'
              },
              traits: [
                {
                  type: 'text',
                  label: 'Twitter URL',
                  name: 'href'
                }
              ]
            },
            {
              tagName: 'a',
              type: 'link',
              content: '📺',
              classes: ['cb-social-link'],
              attributes: {
                href: '#',
                'aria-label': 'YouTube'
              },
              traits: [
                {
                  type: 'text',
                  label: 'YouTube URL',
                  name: 'href'
                }
              ]
            },
            {
              tagName: 'a',
              type: 'link',
              content: '📧',
              classes: ['cb-social-link'],
              attributes: {
                href: '#',
                'aria-label': 'Newsletter'
              },
              traits: [
                {
                  type: 'text',
                  label: 'Newsletter URL',
                  name: 'href'
                }
              ]
            }
          ]
        }
      ]
    }
  });

  // 8. PROFESSIONAL FOOTER
  blockManager.add('cb-footer-pro', {
    label: '🏢 CB Footer Pro',
    category: blockCategory.label,
    media: createMediaPreview('🏢 Professional Footer', designSystem.colors.background),
    content: {
      type: 'cb-footer-pro',
      classes: ['cb-footer'],
      components: [
        {
          tagName: 'img',
          type: 'image',
          attributes: {
            src: 'https://demo.cause.buzz/assets/causebuzz-logo.png',
            alt: 'Cause.Buzz'
          },
          style: {
            'max-width': '120px',
            height: 'auto',
            'margin-bottom': designSystem.spacing.lg,
            opacity: '0.8'
          }
        },
        {
          tagName: 'p',
          type: 'text',
          content: '<strong>Cause.Buzz</strong> - Die professionelle Marketing-Plattform<br>40 Im alten Riet, 9494 Schaan, Liechtenstein<br>E-Mail: hello@cause.buzz | Web: cause.buzz',
          classes: ['cb-footer-text'],
          editable: true
        },
        {
          tagName: 'div',
          classes: ['cb-footer-links'],
          style: {
            margin: '20px 0'
          },
          components: [
            {
              tagName: 'a',
              type: 'link',
              content: 'Datenschutz',
              attributes: {
                href: 'https://cause.buzz/privacy'
              },
              editable: true
            },
            {
              tagName: 'a',
              type: 'link',
              content: 'Impressum',
              attributes: {
                href: 'https://cause.buzz/imprint'
              },
              editable: true
            },
            {
              tagName: 'a',
              type: 'link',
              content: 'Abmelden',
              attributes: {
                href: '{unsubscribe_url}'
              },
              editable: true
            }
          ]
        },
        {
          tagName: 'div',
          classes: ['cb-divider']
        },
        {
          tagName: 'p',
          type: 'text',
          content: '© 2024 Cause.Buzz. Alle Rechte vorbehalten.<br><small>Diese E-Mail wurde an {email} gesendet.</small>',
          classes: ['cb-footer-text']
        }
      ]
    }
  });

  // 9. INDIVIDUAL COMPONENTS

  // Single Button Component
  blockManager.add('cb-button-single', {
    label: '🔘 CB Button',
    category: blockCategory.label,
    media: createMediaPreview('🔘 Single Button', designSystem.gradients.primary),
    content: {
      tagName: 'a',
      type: 'link',
      content: 'Jetzt klicken',
      classes: ['cb-btn', 'cb-btn-primary'],
      attributes: {
        href: '#'
      },
      editable: true,
      traits: [
        {
          type: 'select',
          label: 'Button Style',
          name: 'class',
          options: [
            { value: 'cb-btn cb-btn-primary', name: 'Primary' },
            { value: 'cb-btn cb-btn-secondary', name: 'Secondary' },
            { value: 'cb-btn cb-btn-success', name: 'Success' }
          ]
        }
      ]
    }
  });

  // Single Feature Box
  blockManager.add('cb-feature-single', {
    label: '📦 CB Feature Box',
    category: blockCategory.label,
    media: createMediaPreview('📦 Single Feature', designSystem.gradients.surface),
    content: {
      type: 'cb-feature-single',
      classes: ['cb-feature-box'],
      components: [
        {
          tagName: 'div',
          classes: ['cb-feature-icon'],
          content: '🚀',
          editable: true
        },
        {
          tagName: 'h4',
          type: 'text',
          content: 'Feature Titel',
          style: {
            color: designSystem.colors.text,
            'font-size': designSystem.fonts.sizes.base,
            'margin-bottom': designSystem.spacing.xs,
            'font-weight': designSystem.fonts.weights.semibold
          },
          editable: true
        },
        {
          tagName: 'p',
          type: 'text',
          content: 'Beschreibung des Features hier einfügen.',
          style: {
            color: designSystem.colors.textSecondary,
            'font-size': designSystem.fonts.sizes.sm,
            margin: '0'
          },
          editable: true
        }
      ]
    }
  });

  // Badge Component
  blockManager.add('cb-badge-single', {
    label: '🏷️ CB Badge',
    category: blockCategory.label,
    media: createMediaPreview('🏷️ Badge', designSystem.gradients.success),
    content: {
      tagName: 'span',
      type: 'text',
      content: '✨ Neues Feature',
      classes: ['cb-badge'],
      editable: true,
      traits: [
        {
          type: 'select',
          label: 'Badge Style',
          name: 'class',
          options: [
            { value: 'cb-badge', name: 'Success' },
            { value: 'cb-badge cb-badge-primary', name: 'Primary' },
            { value: 'cb-badge cb-badge-accent', name: 'Accent' }
          ]
        }
      ]
    }
  });

  // Initialize CSS Framework
  injectCauseBuzzCSS();

  // Custom Traits for Enhanced Editing
  traitManager.addType('cb-color-picker', {
    createInput() {
      const input = document.createElement('input');
      input.type = 'color';
      return input;
    }
  });

  // Enhanced Style Manager Configuration
  styleManager.addSector('cb-layout', {
    name: 'Layout',
    properties: [
      'display', 'flex-direction', 'justify-content', 'align-items',
      'grid-template-columns', 'gap', 'padding', 'margin'
    ]
  });

  styleManager.addSector('cb-typography', {
    name: 'Typography',
    properties: [
      'font-family', 'font-size', 'font-weight', 'line-height',
      'text-align', 'color', 'text-decoration'
    ]
  });

  styleManager.addSector('cb-appearance', {
    name: 'Appearance',
    properties: [
      'background', 'border', 'border-radius', 'box-shadow',
      'opacity', 'transform'
    ]
  });

  // Device Manager for Responsive Testing
  editor.DeviceManager.add('desktop', {
    name: 'Desktop',
    width: '1200px'
  });

  editor.DeviceManager.add('tablet', {
    name: 'Tablet',
    width: '768px'
  });

  editor.DeviceManager.add('mobile', {
    name: 'Mobile',
    width: '320px'
  });

  // Canvas Configuration
  editor.on('load', () => {
    // Set default canvas styles for better email preview
    const canvas = editor.Canvas.getBody();
    canvas.style.backgroundColor = designSystem.colors.background;
    canvas.style.fontFamily = designSystem.fonts.family;
    canvas.style.margin = '0';
    canvas.style.padding = '20px 0';
  });

  // Storage Events for Template Management
  editor.on('storage:store', (data) => {
    console.log('💾 Cause.Buzz Template saved:', data);
  });

  editor.on('storage:load', (data) => {
    console.log('📂 Cause.Buzz Template loaded:', data);
  });

  // Command Extensions
  editor.Commands.add('cb-export-html', {
    run(editor) {
      const html = editor.getHtml();
      const css = editor.getCss();
      const fullHtml = `
<!DOCTYPE html>
<html>
<head>
  <meta charset=\"UTF-8\">
  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
  <title>Cause.Buzz Newsletter</title>
  <style>\${css}</style>
</head>
<body>
  \${html}
</body>
</html>`;
      
      // Create download
      const blob = new Blob([fullHtml], { type: 'text/html' });
      const url = URL.createObjectURL(blob);
      const a = document.createElement('a');
      a.href = url;
      a.download = 'causebuzz-newsletter.html';
      a.click();
      URL.revokeObjectURL(url);
    }
  });

  editor.Commands.add('cb-preview-email', {
    run(editor) {
      const html = editor.getHtml();
      const css = editor.getCss();
      const previewHtml = `
<!DOCTYPE html>
<html>
<head>
  <meta charset=\"UTF-8\">
  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
  <title>Preview - Cause.Buzz Newsletter</title>
  <style>\${css}</style>
</head>
<body style=\"margin: 0; padding: 20px; background: #f5f5f5;\">
  <div style=\"max-width: 600px; margin: 0 auto; box-shadow: 0 0 20px rgba(0,0,0,0.1);\">
    \${html}
  </div>
</body>
</html>`;
      
      const previewWindow = window.open('', '_blank');
      previewWindow.document.write(previewHtml);
      previewWindow.document.close();
    }
  });

  console.log('🚀 Cause.Buzz Professional GrapeJS Suite loaded successfully!');
};

// Export Configuration
if (typeof module !== 'undefined' && module.exports) {
  module.exports = CauseBuzzGrapeJS;
} else if (typeof window !== 'undefined') {
  window.CauseBuzzGrapeJS = CauseBuzzGrapeJS;
}";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@themes/causebuzz-grapejs-suite-causebuzz-master-gridfix3/causebuzz-grapejs-blocks.js";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@themes/causebuzz-grapejs-suite-causebuzz-master-gridfix3/causebuzz-grapejs-blocks.js", "/var/www/html/staging-demo/themes/causebuzz-grapejs-suite-causebuzz-master-gridfix3/causebuzz-grapejs-blocks.js");
    }
}
