/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
import type { ListPropertiesConfig, ListPropertiesStyleListType } from '../../listconfig.js';
/**
 * Normalizes {@link module:list/listconfig~ListPropertiesConfig} in the configuration of the list properties feature.
 * The structure of normalized list properties options looks as follows:
 *
 * ```ts
 * {
 * 	styles: {
 * 		listTypes: [ 'bulleted', 'numbered' ],
 * 		useAttribute: false
 * 	},
 * 	startIndex: true,
 * 	reversed: true
 * }
 * ```
 *
 * @param config The list properties {@link module:list/listconfig~ListPropertiesConfig config}.
 * @returns An object with normalized list properties options.
 */
export declare function getNormalizedConfig(config: ListPropertiesConfig): NormalizedListPropertiesConfig;
/**
* Normalized list properties config.
*/
export type NormalizedListPropertiesConfig = {
    styles: {
        listTypes: Array<ListPropertiesStyleListType>;
        useAttribute: boolean;
    };
    startIndex: boolean;
    reversed: boolean;
};
