<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @themes/causebuzz-grapejs-suite/causebuzz-grapejs-integration.html */
class __TwigTemplate_96cd5109bffe4837eb1e66beb07075d1 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<!DOCTYPE html>
<html lang=\"de\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>🚀 Cause.Buzz GrapeJS Email Builder</title>
    
    <!-- GrapeJS Core -->
    <link rel=\"stylesheet\" href=\"https://unpkg.com/grapesjs/dist/css/grapes.min.css\">
    <script src=\"https://unpkg.com/grapesjs\"></script>
    
    <!-- GrapeJS Plugins -->
    <script src=\"https://unpkg.com/grapesjs-preset-newsletter\"></script>
    <script src=\"https://unpkg.com/grapesjs-blocks-basic\"></script>
    <script src=\"https://unpkg.com/grapesjs-parser-postcss\"></script>
    
    <style>
        /* Custom GrapeJS Styling */
        body {
            margin: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: #0f172a;
            color: #ffffff;
        }

        .editor-wrapper {
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .editor-header {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            padding: 15px 20px;
            border-bottom: 2px solid #2563eb;
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-shrink: 0;
        }

        .editor-header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
            color: #ffffff;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .editor-header .logo {
            height: 40px;
            width: auto;
        }

        .editor-controls {
            display: flex;
            gap: 10px;
            align-items: center;
        }

        .btn {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn:hover {
            background: linear-gradient(135deg, #1d4ed8 0%, #1e40af 100%);
            transform: translateY(-1px);
        }

        .btn-secondary {
            background: transparent;
            border: 2px solid #3b82f6;
            color: #60a5fa;
        }

        .btn-secondary:hover {
            background: rgba(59, 130, 246, 0.1);
        }

        .btn-success {
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
        }

        .btn-success:hover {
            background: linear-gradient(135deg, #047857 0%, #065f46 100%);
        }

        #gjs {
            flex: 1;
            background: #f8fafc;
        }

        /* Template Selector */
        .template-selector {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.8);
            display: none;
            z-index: 10000;
            align-items: center;
            justify-content: center;
        }

        .template-modal {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            border-radius: 12px;
            padding: 30px;
            max-width: 90vw;
            max-height: 90vh;
            overflow-y: auto;
            border: 1px solid #475569;
        }

        .template-modal h2 {
            color: #ffffff;
            margin-bottom: 20px;
            font-size: 24px;
            text-align: center;
        }

        .template-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }

        .template-card {
            background: linear-gradient(135deg, #334155 0%, #475569 100%);
            border-radius: 8px;
            padding: 20px;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }

        .template-card:hover {
            border-color: #2563eb;
            transform: translateY(-2px);
        }

        .template-card h3 {
            color: #ffffff;
            margin: 0 0 10px 0;
            font-size: 18px;
        }

        .template-card p {
            color: #cbd5e1;
            margin: 0;
            font-size: 14px;
            line-height: 1.4;
        }

        .template-preview {
            width: 100%;
            height: 120px;
            background: #0f172a;
            border-radius: 6px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 48px;
            border: 1px solid #475569;
        }

        .modal-controls {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
        }

        /* Custom GrapeJS Panel Styling */
        .gjs-pn-panel {
            background: #1e293b !important;
            border-color: #475569 !important;
        }

        .gjs-pn-btn {
            background: #334155 !important;
            color: #cbd5e1 !important;
            border-color: #475569 !important;
        }

        .gjs-pn-btn:hover,
        .gjs-pn-btn.gjs-pn-active {
            background: #2563eb !important;
            color: #ffffff !important;
        }

        .gjs-block {
            background: #334155 !important;
            border-color: #475569 !important;
            color: #cbd5e1 !important;
        }

        .gjs-block:hover {
            background: #475569 !important;
            border-color: #2563eb !important;
        }

        .gjs-block-category .gjs-title {
            background: #1e293b !important;
            color: #60a5fa !important;
            border-color: #475569 !important;
        }

        /* Canvas Styling */
        .gjs-cv-canvas {
            background: #f1f5f9 !important;
        }

        /* Style Manager */
        .gjs-sm-sector .gjs-sm-title {
            background: #1e293b !important;
            color: #60a5fa !important;
            border-color: #475569 !important;
        }

        .gjs-sm-property {
            background: #334155 !important;
            border-color: #475569 !important;
        }

        .gjs-sm-property .gjs-sm-label {
            color: #cbd5e1 !important;
        }

        .gjs-field {
            background: #1e293b !important;
            color: #ffffff !important;
            border-color: #475569 !important;
        }

        /* Toast Notifications */
        .toast {
            position: fixed;
            top: 20px;
            right: 20px;
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            color: white;
            padding: 15px 20px;
            border-radius: 8px;
            z-index: 9999;
            transform: translateX(400px);
            transition: transform 0.3s ease;
            font-weight: 500;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }

        .toast.show {
            transform: translateX(0);
        }

        .toast.error {
            background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
        }

        /* Responsive */
        @media (max-width: 768px) {
            .editor-header {
                flex-direction: column;
                gap: 15px;
                padding: 15px;
            }

            .editor-controls {
                width: 100%;
                justify-content: center;
                flex-wrap: wrap;
            }

            .template-modal {
                padding: 20px;
                margin: 20px;
            }

            .template-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class=\"editor-wrapper\">
        <!-- Header -->
        <div class=\"editor-header\">
            <h1>
                <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz\" class=\"logo\">
                Email Builder Pro
            </h1>
            <div class=\"editor-controls\">
                <button class=\"btn\" onclick=\"showTemplateSelector()\">
                    🎨 Templates
                </button>
                <button class=\"btn btn-secondary\" onclick=\"previewEmail()\">
                    👀 Vorschau
                </button>
                <button class=\"btn btn-success\" onclick=\"exportHTML()\">
                    📤 Export HTML
                </button>
                <button class=\"btn\" onclick=\"saveTemplate()\">
                    💾 Speichern
                </button>
            </div>
        </div>

        <!-- GrapeJS Editor -->
        <div id=\"gjs\"></div>

        <!-- Template Selector Modal -->
        <div class=\"template-selector\" id=\"templateSelector\">
            <div class=\"template-modal\">
                <h2>🎨 Template auswählen</h2>
                <div class=\"template-grid\">
                    <div class=\"template-card\" onclick=\"loadTemplate('newsletter')\">
                        <div class=\"template-preview\">📧</div>
                        <h3>📧 Newsletter Template</h3>
                        <p>Professional newsletter template with header, content sections, and footer</p>
                    </div>
                    <div class=\"template-card\" onclick=\"loadTemplate('welcome')\">
                        <div class=\"template-preview\">👋</div>
                        <h3>👋 Welcome Email</h3>
                        <p>Warm welcome email for new subscribers</p>
                    </div>
                    <div class=\"template-card\" onclick=\"loadTemplate('productLaunch')\">
                        <div class=\"template-preview\">🚀</div>
                        <h3>🚀 Product Launch</h3>
                        <p>Announcement template for new products or features</p>
                    </div>
                    <div class=\"template-card\" onclick=\"loadTemplate('eventInvitation')\">
                        <div class=\"template-preview\">🎪</div>
                        <h3>🎪 Event Invitation</h3>
                        <p>Professional event invitation with RSVP call-to-action</p>
                    </div>
                    <div class=\"template-card\" onclick=\"loadTemplate('transactional')\">
                        <div class=\"template-preview\">📋</div>
                        <h3>📋 Transactional</h3>
                        <p>Clean, minimal template for transactional emails</p>
                    </div>
                    <div class=\"template-card\" onclick=\"loadTemplate('blank')\">
                        <div class=\"template-preview\">⚪</div>
                        <h3>⚪ Blank Template</h3>
                        <p>Start from scratch with a blank canvas</p>
                    </div>
                </div>
                <div class=\"modal-controls\">
                    <button class=\"btn btn-secondary\" onclick=\"hideTemplateSelector()\">
                        ❌ Abbrechen
                    </button>
                    <a href=\"https://cause.buzz\" class=\"btn\" target=\"_blank\">
                        🏠 Zur Website
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Cause.Buzz GrapeJS Components -->
    <script src=\"./causebuzz-grapejs-blocks.js\"></script>
    <script src=\"./causebuzz-templates.js\"></script>

    <script>
        // Initialize GrapeJS Editor
        const editor = grapesjs.init({
            container: '#gjs',
            width: 'auto',
            height: '100%',
            fromElement: false,
            showOffsets: true,
            
            // Storage Configuration
            storageManager: {
                type: 'local',
                autosave: true,
                autoload: true,
                stepsBeforeSave: 3,
                options: {
                    local: {
                        key: 'causebuzz-email-builder'
                    }
                }
            },

            // Asset Manager
            assetManager: {
                assets: [
                    'https://demo.cause.buzz/assets/causebuzz-logo.png'
                ],
                upload: false,
                uploadText: 'Drop files here or click to upload'
            },

            // Canvas Configuration
            canvas: {
                styles: [
                    'https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap'
                ],
                scripts: []
            },

            // Plugins
            plugins: [
                'gjs-preset-newsletter',
                'gjs-blocks-basic'
            ],

            pluginsOpts: {
                'gjs-preset-newsletter': {
                    modalImportTitle: 'Import Template',
                    modalImportLabel: '<div style=\"margin-bottom: 10px; font-size: 13px;\">Paste your HTML/CSS here:</div>',
                    modalImportContent: function(editor) {
                        return editor.getHtml() + '<style>' + editor.getCss() + '</style>';
                    },
                    importPlaceholder: '',
                    inlineCss: true,
                    updateStyleManager: true,
                    showStylesOnChange: true,
                    showBlocksOnLoad: true,
                    useCustomTheme: true
                }
            },

            // Device Manager
            deviceManager: {
                devices: [
                    {
                        name: 'Desktop',
                        width: '1200px'
                    },
                    {
                        name: 'Tablet',
                        width: '768px'
                    },
                    {
                        name: 'Mobile Portrait',
                        width: '320px'
                    }
                ]
            },

            // Style Manager
            styleManager: {
                appendTo: '.styles-container',
                sectors: [
                    {
                        name: 'Dimension',
                        open: false,
                        buildProps: ['width', 'min-height', 'padding'],
                        properties: [
                            {
                                type: 'integer',
                                name: 'The width',
                                property: 'width',
                                units: ['px', '%'],
                                defaults: 'auto',
                                min: 0
                            }
                        ]
                    },
                    {
                        name: 'Extra',
                        open: false,
                        buildProps: ['background-color', 'box-shadow', 'custom-prop'],
                        properties: [
                            {
                                id: 'custom-prop',
                                name: 'Custom Label',
                                property: 'font-size',
                                type: 'select',
                                defaults: '32px',
                                options: [
                                    { value: '12px', name: 'Tiny' },
                                    { value: '18px', name: 'Medium' },
                                    { value: '32px', name: 'Big' }
                                ]
                            }
                        ]
                    }
                ]
            }
        });

        // Initialize Cause.Buzz components after editor loads
        editor.on('load', () => {
            // Load Cause.Buzz blocks
            if (typeof CauseBuzzGrapeJS === 'function') {
                CauseBuzzGrapeJS(editor);
                showToast('🚀 Cause.Buzz Email Builder geladen!', 'success');
            }

            // Initialize template manager
            if (typeof initializeCauseBuzzTemplateManager === 'function') {
                initializeCauseBuzzTemplateManager(editor);
            }

            // Set default template on first load
            const storedData = localStorage.getItem('causebuzz-email-builder');
            if (!storedData) {
                showTemplateSelector();
            }
        });

        // Template Management Functions
        function showTemplateSelector() {
            document.getElementById('templateSelector').style.display = 'flex';
        }

        function hideTemplateSelector() {
            document.getElementById('templateSelector').style.display = 'none';
        }

        function loadTemplate(templateName) {
            if (templateName === 'blank') {
                // Clear editor for blank template
                editor.DomComponents.clear();
                editor.CssComposer.clear();
                showToast('✨ Blank Template geladen', 'success');
            } else if (typeof loadCauseBuzzTemplate === 'function') {
                loadCauseBuzzTemplate(editor, templateName);
                showToast(`🎨 Template \"\${templateName}\" geladen!`, 'success');
            } else {
                showToast('❌ Template konnte nicht geladen werden', 'error');
            }
            hideTemplateSelector();
        }

        // Editor Functions
        function previewEmail() {
            const html = editor.getHtml();
            const css = editor.getCss();
            const fullHtml = `
<!DOCTYPE html>
<html>
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>Preview - Cause.Buzz Newsletter</title>
    <style>\${css}</style>
</head>
<body style=\"margin: 0; padding: 20px; background: #f5f5f5;\">
    <div style=\"max-width: 600px; margin: 0 auto; box-shadow: 0 0 20px rgba(0,0,0,0.1);\">
        \${html}
    </div>
</body>
</html>`;
            
            const previewWindow = window.open('', '_blank');
            previewWindow.document.write(fullHtml);
            previewWindow.document.close();
            showToast('👀 Vorschau geöffnet!', 'success');
        }

        function exportHTML() {
            const html = editor.getHtml();
            const css = editor.getCss();
            const fullHtml = `<!DOCTYPE html>
<html>
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>Cause.Buzz Newsletter</title>
    <style>
        \${css}
    </style>
</head>
<body>
    \${html}
</body>
</html>`;
            
            // Create download
            const blob = new Blob([fullHtml], { type: 'text/html' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'causebuzz-newsletter-' + new Date().toISOString().slice(0,10) + '.html';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
            
            showToast('📤 HTML exportiert!', 'success');
        }

        function saveTemplate() {
            try {
                editor.store();
                showToast('💾 Template gespeichert!', 'success');
            } catch (error) {
                console.error('Save error:', error);
                showToast('❌ Fehler beim Speichern', 'error');
            }
        }

        // Utility Functions
        function showToast(message, type = 'success') {
            const toast = document.createElement('div');
            toast.className = `toast \${type}`;
            toast.textContent = message;
            document.body.appendChild(toast);
            
            setTimeout(() => toast.classList.add('show'), 100);
            setTimeout(() => {
                toast.classList.remove('show');
                setTimeout(() => document.body.removeChild(toast), 300);
            }, 3000);
        }

        // Keyboard Shortcuts
        document.addEventListener('keydown', (e) => {
            if (e.ctrlKey || e.metaKey) {
                switch (e.key) {
                    case 's':
                        e.preventDefault();
                        saveTemplate();
                        break;
                    case 'p':
                        e.preventDefault();
                        previewEmail();
                        break;
                    case 'e':
                        e.preventDefault();
                        exportHTML();
                        break;
                }
            }
        });

        // Auto-save functionality
        setInterval(() => {
            try {
                editor.store();
            } catch (error) {
                console.log('Auto-save failed:', error);
            }
        }, 30000); // Auto-save every 30 seconds

        console.log('🚀 Cause.Buzz GrapeJS Email Builder initialized successfully!');
    </script>
</body>
</html>";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@themes/causebuzz-grapejs-suite/causebuzz-grapejs-integration.html";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@themes/causebuzz-grapejs-suite/causebuzz-grapejs-integration.html", "/var/www/html/staging-demo/themes/causebuzz-grapejs-suite/causebuzz-grapejs-integration.html");
    }
}
