<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @themes/causebuzz-grapejs-suite-causebuzz-master-gridfix3/causebuzz-templates.js */
class __TwigTemplate_b3f888d0be43d0d4fe74af0512a3927c extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "/**
 * 🎨 Cause.Buzz GrapeJS Template Library
 * Pre-built email templates for common use cases
 * Version: 2.0.0
 */

const CauseBuzzTemplates = {
  
  // Newsletter Template
  newsletter: {
    name: '📧 Newsletter Template',
    description: 'Professional newsletter template with header, content sections, and footer',
    thumbnail: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjI1MCIgdmlld0JveD0iMCAwIDIwMCAyNTAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIyMDAiIGhlaWdodD0iMjUwIiBmaWxsPSIjMGYxNzJhIi8+CjxyZWN0IHg9IjEwIiB5PSIxMCIgd2lkdGg9IjE4MCIgaGVpZ2h0PSI2MCIgZmlsbD0iIzFlMjkzYiIvPgo8cmVjdCB4PSIxMCIgeT0iODAiIHdpZHRoPSIxODAiIGhlaWdodD0iMTAwIiBmaWxsPSIjMzM0MTU1Ii8+CjxyZWN0IHg9IjEwIiB5PSIxOTAiIHdpZHRoPSIxODAiIGhlaWdodD0iNTAiIGZpbGw9IiMwZjE3MmEiLz4KPC9zdmc+',
    template: {
      html: `
        <div class=\"cb-container\">
          <div class=\"cb-header\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz Logo\" class=\"cb-logo\">
            <div style=\"position: relative; z-index: 1; margin-top: 16px;\">
              <span class=\"cb-badge\">🚀 Ganzheitliche Marketing-Plattform</span>
              <span class=\"cb-badge cb-badge-primary\">🇪🇺 EU-Server</span>
              <span class=\"cb-badge\">🔒 DSGVO-konform</span>
            </div>
          </div>
          
          <div class=\"cb-section cb-text-center\" style=\"background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%); position: relative;\">
            <div style=\"position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-image: url('data:image/svg+xml,<svg xmlns=\\\\\"http://www.w3.org/2000/svg\\\\\" width=\\\\\"60\\\\\" height=\\\\\"60\\\\\" viewBox=\\\\\"0 0 60 60\\\\\"><g fill-opacity=\\\\\"0.03\\\\\" fill=\\\\\"%23ffffff\\\\\"><rect width=\\\\\"1\\\\\" height=\\\\\"1\\\\\"/></g></svg>'); background-size: 60px 60px; z-index: 0;\"></div>
            <div style=\"position: relative; z-index: 1;\">
              <h1 class=\"cb-headline\">Willkommen zu unserem Newsletter!</h1>
              <p class=\"cb-subheading\">Die neuesten Marketing-Insights und Updates</p>
              <p class=\"cb-text\" style=\"max-width: 500px; margin: 0 auto 30px;\">
                Erhalten Sie die neuesten Updates, Marketing-Tipps und Einblicke in die Welt der professionellen Newsletter-Tools und Marketing Automation.
              </p>
              <a href=\"https://demo.cause.buzz\" class=\"cb-btn cb-btn-primary\">✨ Mehr erfahren</a>
            </div>
          </div>
          
          <div class=\"cb-section\">
            <h2 class=\"cb-subheading\">📈 Diese Woche im Marketing</h2>
            <div class=\"cb-text\">
              <p>Hier ist Platz für Ihren Newsletter-Content:</p>
              <ul style=\"padding-left: 20px; margin-bottom: 20px;\">
                <li>🎯 Neue Marketing-Strategien für 2024</li>
                <li>📧 Newsletter-Best-Practices</li>
                <li>🚀 Automation-Tipps für bessere Conversion</li>
                <li>📊 Aktuelle Markt-Insights</li>
              </ul>
              <p>Nutzen Sie die Kraft von professionellen Marketing-Tools, um Ihre Zielgruppe optimal zu erreichen und nachhaltige Erfolge zu erzielen.</p>
            </div>
          </div>
          
          <div class=\"cb-section cb-section-alt cb-text-center\">
            <h3 class=\"cb-headline\">Verpassen Sie keine Updates!</h3>
            <p class=\"cb-text\">Bleiben Sie mit uns in Verbindung für die neuesten Marketing-Trends:</p>
            <div class=\"cb-social-links\">
              <a href=\"#\" class=\"cb-social-link\" aria-label=\"LinkedIn\">💼</a>
              <a href=\"#\" class=\"cb-social-link\" aria-label=\"Twitter\">🐦</a>
              <a href=\"#\" class=\"cb-social-link\" aria-label=\"YouTube\">📺</a>
              <a href=\"#\" class=\"cb-social-link\" aria-label=\"Newsletter\">📧</a>
            </div>
          </div>
          
          <div class=\"cb-footer\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz\" style=\"max-width: 120px; height: auto; margin-bottom: 20px; opacity: 0.8;\">
            <p class=\"cb-footer-text\">
              <strong>Cause.Buzz</strong> - Die professionelle Marketing-Plattform<br>
              40 Im alten Riet, 9494 Schaan, Liechtenstein<br>
              E-Mail: hello@cause.buzz | Web: cause.buzz
            </p>
            <div class=\"cb-footer-links\" style=\"margin: 20px 0;\">
              <a href=\"https://cause.buzz/privacy\">Datenschutz</a>
              <a href=\"https://cause.buzz/imprint\">Impressum</a>
              <a href=\"{unsubscribe_url}\">Abmelden</a>
            </div>
            <div class=\"cb-divider\"></div>
            <p class=\"cb-footer-text\">
              © 2024 Cause.Buzz. Alle Rechte vorbehalten.<br>
              <small>Diese E-Mail wurde an {email} gesendet.</small>
            </p>
          </div>
        </div>
      `
    }
  },

  // Welcome Email Template
  welcome: {
    name: '👋 Welcome Email',
    description: 'Warm welcome email for new subscribers',
    thumbnail: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjI1MCIgdmlld0JveD0iMCAwIDIwMCAyNTAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIyMDAiIGhlaWdodD0iMjUwIiBmaWxsPSIjMGYxNzJhIi8+CjxyZWN0IHg9IjEwIiB5PSIxMCIgd2lkdGg9IjE4MCIgaGVpZ2h0PSI4MCIgZmlsbD0iIzJlNjNlYiIvPgo8cmVjdCB4PSIxMCIgeT0iMTAwIiB3aWR0aD0iMTgwIiBoZWlnaHQ9IjEwMCIgZmlsbD0iIzFlMjkzYiIvPgo8cmVjdCB4PSIxMCIgeT0iMjEwIiB3aWR0aD0iMTgwIiBoZWlnaHQ9IjMwIiBmaWxsPSIjMGYxNzJhIi8+CjwvZXN2Zz4=',
    template: {
      html: `
        <div class=\"cb-container\">
          <div class=\"cb-header\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz Logo\" class=\"cb-logo\">
            <div style=\"position: relative; z-index: 1; margin-top: 16px;\">
              <span class=\"cb-badge\">👋 Willkommen im Team</span>
              <span class=\"cb-badge cb-badge-primary\">🎉 Erste Schritte</span>
            </div>
          </div>
          
          <div class=\"cb-section cb-text-center\" style=\"background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);\">
            <h1 class=\"cb-headline\" style=\"color: white;\">Willkommen bei Cause.Buzz!</h1>
            <p class=\"cb-text\" style=\"color: rgba(255,255,255,0.9); font-size: 18px;\">
              🎉 Schön, dass Sie sich für unseren Newsletter angemeldet haben!
            </p>
            <p class=\"cb-text\" style=\"color: rgba(255,255,255,0.8);\">
              Sie erhalten ab sofort die neuesten Marketing-Insights, Tool-Updates und exklusive Tipps direkt in Ihr Postfach.
            </p>
          </div>
          
          <div class=\"cb-section\">
            <h2 class=\"cb-subheading\">🚀 Was Sie erwarten können:</h2>
            <div class=\"cb-grid-2\">
              <div class=\"cb-feature-box\">
                <div class=\"cb-feature-icon\">📧</div>
                <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Newsletter-Tipps</h3>
                <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">Professionelle Strategien für erfolgreiche E-Mail-Kampagnen</p>
              </div>
              <div class=\"cb-feature-box\">
                <div class=\"cb-feature-icon\">⚡</div>
                <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Automation-Guides</h3>
                <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">Schritt-für-Schritt Anleitungen für Marketing Automation</p>
              </div>
              <div class=\"cb-feature-box\">
                <div class=\"cb-feature-icon\">🎯</div>
                <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Exklusive Insights</h3>
                <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">Insider-Wissen und Branche-Updates nur für Abonnenten</p>
              </div>
              <div class=\"cb-feature-box\">
                <div class=\"cb-feature-icon\">🎁</div>
                <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Besondere Angebote</h3>
                <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">Frühzeitiger Zugang zu neuen Features und Sonderaktionen</p>
              </div>
            </div>
          </div>
          
          <div class=\"cb-section cb-section-alt cb-text-center\">
            <h3 class=\"cb-headline\">Bereit für den Start?</h3>
            <p class=\"cb-text\">Entdecken Sie jetzt die Möglichkeiten von Cause.Buzz:</p>
            <a href=\"https://demo.cause.buzz\" class=\"cb-btn cb-btn-primary\">🎯 Kostenlose Demo buchen</a>
            <a href=\"https://cause.buzz/preise\" class=\"cb-btn cb-btn-secondary\">💰 Preise ansehen</a>
          </div>
          
          <div class=\"cb-footer\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz\" style=\"max-width: 120px; height: auto; margin-bottom: 20px; opacity: 0.8;\">
            <p class=\"cb-footer-text\">
              <strong>Cause.Buzz</strong> - Die professionelle Marketing-Plattform<br>
              40 Im alten Riet, 9494 Schaan, Liechtenstein<br>
              E-Mail: hello@cause.buzz | Web: cause.buzz
            </p>
            <div class=\"cb-footer-links\" style=\"margin: 20px 0;\">
              <a href=\"https://cause.buzz/privacy\">Datenschutz</a>
              <a href=\"https://cause.buzz/imprint\">Impressum</a>
              <a href=\"{unsubscribe_url}\">Abmelden</a>
            </div>
            <div class=\"cb-divider\"></div>
            <p class=\"cb-footer-text\">
              © 2024 Cause.Buzz. Alle Rechte vorbehalten.<br>
              <small>Diese E-Mail wurde an {email} gesendet.</small>
            </p>
          </div>
        </div>
      `
    }
  },

  // Product Launch Template
  productLaunch: {
    name: '🚀 Product Launch',
    description: 'Announcement template for new products or features',
    thumbnail: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjI1MCIgdmlld0JveD0iMCAwIDIwMCAyNTAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIyMDAiIGhlaWdodD0iMjUwIiBmaWxsPSIjMGYxNzJhIi8+CjxyZWN0IHg9IjEwIiB5PSIxMCIgd2lkdGg9IjE4MCIgaGVpZ2h0PSI2MCIgZmlsbD0iIzA1OTY2OSIvPgo8cmVjdCB4PSIxMCIgeT0iODAiIHdpZHRoPSIxODAiIGhlaWdodD0iMTIwIiBmaWxsPSIjMWUyOTNiIi8+CjxyZWN0IHg9IjEwIiB5PSIyMTAiIHdpZHRoPSIxODAiIGhlaWdodD0iMzAiIGZpbGw9IiMwZjE3MmEiLz4KPC9zdmc+',
    template: {
      html: `
        <div class=\"cb-container\">
          <div class=\"cb-header\" style=\"background: linear-gradient(135deg, #059669 0%, #047857 100%);\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz Logo\" class=\"cb-logo\">
            <div style=\"position: relative; z-index: 1; margin-top: 16px;\">
              <span class=\"cb-badge\" style=\"background: rgba(255,255,255,0.2);\">🚀 Neues Feature</span>
              <span class=\"cb-badge cb-badge-primary\">✨ Jetzt verfügbar</span>
            </div>
          </div>
          
          <div class=\"cb-section cb-text-center\" style=\"background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%); position: relative;\">
            <div style=\"position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-image: url('data:image/svg+xml,<svg xmlns=\\\\\"http://www.w3.org/2000/svg\\\\\" width=\\\\\"60\\\\\" height=\\\\\"60\\\\\" viewBox=\\\\\"0 0 60 60\\\\\"><g fill-opacity=\\\\\"0.03\\\\\" fill=\\\\\"%23ffffff\\\\\"><rect width=\\\\\"1\\\\\" height=\\\\\"1\\\\\"/></g></svg>'); background-size: 60px 60px; z-index: 0;\"></div>
            <div style=\"position: relative; z-index: 1;\">
              <h1 class=\"cb-headline\">🎉 Großartige Neuigkeiten!</h1>
              <p class=\"cb-subheading\">Unser neuestes Feature ist endlich da</p>
              <p class=\"cb-text\" style=\"max-width: 500px; margin: 0 auto 30px;\">
                Nach monatelanger Entwicklung freuen wir uns, Ihnen unser neuestes Feature vorstellen zu können, das Ihre Marketing-Erfolge auf die nächste Stufe hebt.
              </p>
              <a href=\"https://demo.cause.buzz\" class=\"cb-btn cb-btn-success\">🚀 Jetzt entdecken</a>
            </div>
          </div>
          
          <div class=\"cb-section\">
            <h2 class=\"cb-subheading\">✨ Was ist neu?</h2>
            <div class=\"cb-text\">
              <p><strong>Erweiterte Marketing Automation:</strong></p>
              <ul style=\"padding-left: 20px; margin-bottom: 20px;\">
                <li>🎯 Intelligente Lead-Segmentierung</li>
                <li>📈 Erweiterte Analytics und Reporting</li>
                <li>🔄 Automatische A/B-Tests</li>
                <li>⚡ Blitzschnelle Template-Engine</li>
              </ul>
              <p>Diese neuen Funktionen wurden speziell entwickelt, um Ihre Conversion-Raten zu steigern und Ihre Marketing-Workflows zu optimieren.</p>
            </div>
          </div>
          
          <div class=\"cb-section cb-section-alt\">
            <div class=\"cb-stats-box\">
              <h3 class=\"cb-headline\">📊 Beeindruckende Ergebnisse</h3>
              <div class=\"cb-grid-3\" style=\"margin-top: 20px;\">
                <div class=\"cb-text-center\">
                  <span class=\"cb-stat-number\">+150%</span>
                  <div class=\"cb-stat-label\">Bessere Conversion</div>
                </div>
                <div class=\"cb-text-center\">
                  <span class=\"cb-stat-number\">-75%</span>
                  <div class=\"cb-stat-label\">Weniger Aufwand</div>
                </div>
                <div class=\"cb-text-center\">
                  <span class=\"cb-stat-number\">24/7</span>
                  <div class=\"cb-stat-label\">Automatisierung</div>
                </div>
              </div>
            </div>
          </div>
          
          <div class=\"cb-section cb-text-center\">
            <h3 class=\"cb-headline\">Bereit für bessere Ergebnisse?</h3>
            <p class=\"cb-text\">Testen Sie die neuen Features noch heute:</p>
            <a href=\"https://demo.cause.buzz\" class=\"cb-btn cb-btn-primary\">🎯 Kostenlose Demo starten</a>
            <a href=\"https://cause.buzz/preise\" class=\"cb-btn cb-btn-secondary\">💰 Upgrade-Optionen</a>
          </div>
          
          <div class=\"cb-footer\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz\" style=\"max-width: 120px; height: auto; margin-bottom: 20px; opacity: 0.8;\">
            <p class=\"cb-footer-text\">
              <strong>Cause.Buzz</strong> - Die professionelle Marketing-Plattform<br>
              40 Im alten Riet, 9494 Schaan, Liechtenstein<br>
              E-Mail: hello@cause.buzz | Web: cause.buzz
            </p>
            <div class=\"cb-footer-links\" style=\"margin: 20px 0;\">
              <a href=\"https://cause.buzz/privacy\">Datenschutz</a>
              <a href=\"https://cause.buzz/imprint\">Impressum</a>
              <a href=\"{unsubscribe_url}\">Abmelden</a>
            </div>
            <div class=\"cb-divider\"></div>
            <p class=\"cb-footer-text\">
              © 2024 Cause.Buzz. Alle Rechte vorbehalten.<br>
              <small>Diese E-Mail wurde an {email} gesendet.</small>
            </p>
          </div>
        </div>
      `
    }
  },

  // Event Invitation Template
  eventInvitation: {
    name: '🎪 Event Invitation',
    description: 'Professional event invitation with RSVP call-to-action',
    thumbnail: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjI1MCIgdmlld0JveD0iMCAwIDIwMCAyNTAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIyMDAiIGhlaWdodD0iMjUwIiBmaWxsPSIjMGYxNzJhIi8+CjxyZWN0IHg9IjEwIiB5PSIxMCIgd2lkdGg9IjE4MCIgaGVpZ2h0PSI2MCIgZmlsbD0iIzdjM2FlZCIvPgo8cmVjdCB4PSIxMCIgeT0iODAiIHdpZHRoPSIxODAiIGhlaWdodD0iMTIwIiBmaWxsPSIjMWUyOTNiIi8+CjxyZWN0IHg9IjEwIiB5PSIyMTAiIHdpZHRoPSIxODAiIGhlaWdodD0iMzAiIGZpbGw9IiMwZjE3MmEiLz4KPC9zdmc+',
    template: {
      html: `
        <div class=\"cb-container\">
          <div class=\"cb-header\" style=\"background: linear-gradient(135deg, #7c3aed 0%, #6d28d9 100%);\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz Logo\" class=\"cb-logo\">
            <div style=\"position: relative; z-index: 1; margin-top: 16px;\">
              <span class=\"cb-badge\" style=\"background: rgba(255,255,255,0.2);\">🎪 Exklusives Event</span>
              <span class=\"cb-badge cb-badge-primary\">📅 Limitierte Plätze</span>
            </div>
          </div>
          
          <div class=\"cb-section cb-text-center\" style=\"background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%); position: relative;\">
            <div style=\"position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-image: url('data:image/svg+xml,<svg xmlns=\\\\\"http://www.w3.org/2000/svg\\\\\" width=\\\\\"60\\\\\" height=\\\\\"60\\\\\" viewBox=\\\\\"0 0 60 60\\\\\"><g fill-opacity=\\\\\"0.03\\\\\" fill=\\\\\"%23ffffff\\\\\"><rect width=\\\\\"1\\\\\" height=\\\\\"1\\\\\"/></g></svg>'); background-size: 60px 60px; z-index: 0;\"></div>
            <div style=\"position: relative; z-index: 1;\">
              <h1 class=\"cb-headline\">🎪 Sie sind eingeladen!</h1>
              <p class=\"cb-subheading\">Marketing Summit 2024</p>
              <p class=\"cb-text\" style=\"max-width: 500px; margin: 0 auto 30px;\">
                Seien Sie dabei, wenn führende Marketing-Experten die neuesten Trends, Strategien und Tools für erfolgreiches Digital Marketing vorstellen.
              </p>
            </div>
          </div>
          
          <div class=\"cb-section\">
            <h2 class=\"cb-subheading\">📅 Event-Details</h2>
            <div class=\"cb-grid-2\">
              <div class=\"cb-feature-box\">
                <div class=\"cb-feature-icon\">📅</div>
                <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Datum & Zeit</h3>
                <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">15. März 2024<br>14:00 - 18:00 CET</p>
              </div>
              <div class=\"cb-feature-box\">
                <div class=\"cb-feature-icon\">🌐</div>
                <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Format</h3>
                <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">Online Webinar<br>Interaktive Sessions</p>
              </div>
              <div class=\"cb-feature-box\">
                <div class=\"cb-feature-icon\">🎯</div>
                <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Themen</h3>
                <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">Marketing Automation<br>Newsletter Optimization</p>
              </div>
              <div class=\"cb-feature-box\">
                <div class=\"cb-feature-icon\">🎁</div>
                <h3 style=\"color: #ffffff; font-size: 16px; margin-bottom: 8px; font-weight: 600;\">Bonus</h3>
                <p style=\"color: #94a3b8; font-size: 14px; margin: 0;\">Kostenlose Templates<br>Exklusive Ressourcen</p>
              </div>
            </div>
          </div>
          
          <div class=\"cb-section cb-section-alt\">
            <div class=\"cb-text\">
              <h3 class=\"cb-subheading\">🌟 Was Sie erwartet:</h3>
              <ul style=\"padding-left: 20px; margin-bottom: 20px;\">
                <li>🚀 <strong>Keynote:</strong> \"Die Zukunft des Email Marketing\"</li>
                <li>🎯 <strong>Workshop:</strong> Marketing Automation Setup</li>
                <li>📊 <strong>Case Studies:</strong> Erfolgreiche Kampagnen</li>
                <li>💬 <strong>Q&A Session:</strong> Direkt mit den Experten</li>
                <li>🎁 <strong>Networking:</strong> Austausch mit anderen Marketern</li>
              </ul>
            </div>
          </div>
          
          <div class=\"cb-section cb-text-center\">
            <h3 class=\"cb-headline\">Sichern Sie sich Ihren Platz!</h3>
            <p class=\"cb-text\">Nur noch wenige Plätze verfügbar - melden Sie sich jetzt an:</p>
            <a href=\"https://demo.cause.buzz/event-anmeldung\" class=\"cb-btn cb-btn-primary\">🎪 Jetzt anmelden (kostenlos)</a>
            <a href=\"https://demo.cause.buzz/event-info\" class=\"cb-btn cb-btn-secondary\">📋 Mehr Informationen</a>
          </div>
          
          <div class=\"cb-footer\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz\" style=\"max-width: 120px; height: auto; margin-bottom: 20px; opacity: 0.8;\">
            <p class=\"cb-footer-text\">
              <strong>Cause.Buzz</strong> - Die professionelle Marketing-Plattform<br>
              40 Im alten Riet, 9494 Schaan, Liechtenstein<br>
              E-Mail: hello@cause.buzz | Web: cause.buzz
            </p>
            <div class=\"cb-footer-links\" style=\"margin: 20px 0;\">
              <a href=\"https://cause.buzz/privacy\">Datenschutz</a>
              <a href=\"https://cause.buzz/imprint\">Impressum</a>
              <a href=\"{unsubscribe_url}\">Abmelden</a>
            </div>
            <div class=\"cb-divider\"></div>
            <p class=\"cb-footer-text\">
              © 2024 Cause.Buzz. Alle Rechte vorbehalten.<br>
              <small>Diese E-Mail wurde an {email} gesendet.</small>
            </p>
          </div>
        </div>
      `
    }
  },

  // Minimal Transactional Template
  transactional: {
    name: '📋 Transactional',
    description: 'Clean, minimal template for transactional emails',
    thumbnail: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjI1MCIgdmlld0JveD0iMCAwIDIwMCAyNTAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi0vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIyMDAiIGhlaWdodD0iMjUwIiBmaWxsPSIjMGYxNzJhIi8+CjxyZWN0IHg9IjEwIiB5PSIxMCIgd2lkdGg9IjE4MCIgaGVpZ2h0PSI0MCIgZmlsbD0iIzMzNDE1NSIvPgo8cmVjdCB4PSIxMCIgeT0iNjAiIHdpZHRoPSIxODAiIGhlaWdodD0iMTUwIiBmaWxsPSIjMWUyOTNiIi8+CjxyZWN0IHg9IjEwIiB5PSIyMjAiIHdpZHRoPSIxODAiIGhlaWdodD0iMjAiIGZpbGw9IiMwZjE3MmEiLz4KPC9zdmc+',
    template: {
      html: `
        <div class=\"cb-container\">
          <div class=\"cb-header\" style=\"padding: 20px; background: linear-gradient(135deg, #334155 0%, #475569 100%);\">
            <img src=\"https://demo.cause.buzz/assets/causebuzz-logo.png\" alt=\"Cause.Buzz Logo\" style=\"max-width: 120px; height: auto;\">
          </div>
          
          <div class=\"cb-section\">
            <h1 class=\"cb-headline\" style=\"text-align: left;\">Wichtige Mitteilung</h1>
            <div class=\"cb-text\">
              <p>Liebe/r Kunde/in,</p>
              <p>hier ist Platz für Ihre transaktionale Nachricht. Diese könnte zum Beispiel sein:</p>
              <ul style=\"padding-left: 20px; margin: 20px 0;\">
                <li>✅ Bestätigung einer Anmeldung</li>
                <li>🔒 Passwort-Reset-Informationen</li>
                <li>📧 Neue Nachrichten-Benachrichtigung</li>
                <li>📋 Bestellbestätigung</li>
                <li>⚡ System-Update-Information</li>
              </ul>
              <p>Falls Sie Fragen haben, antworten Sie einfach auf diese E-Mail oder kontaktieren Sie unser Support-Team.</p>
              <p>Mit freundlichen Grüßen,<br>Ihr Cause.Buzz Team</p>
            </div>
            
            <div style=\"background: rgba(37, 99, 235, 0.1); border: 1px solid rgba(37, 99, 235, 0.2); border-radius: 12px; padding: 20px; margin: 30px 0;\">
              <p style=\"color: #60a5fa; font-weight: 500; margin-bottom: 10px;\">💡 Tipp:</p>
              <p class=\"cb-text\" style=\"margin: 0;\">Verwenden Sie diese Template-Struktur für alle Ihre transaktionalen E-Mails um eine konsistente Kommunikation zu gewährleisten.</p>
            </div>
          </div>
          
          <div class=\"cb-section cb-section-alt cb-text-center\">
            <a href=\"https://cause.buzz\" class=\"cb-btn cb-btn-primary\">🏠 Zur Website</a>
            <a href=\"mailto:hello@cause.buzz\" class=\"cb-btn cb-btn-secondary\">📧 Support kontaktieren</a>
          </div>
          
          <div class=\"cb-footer\" style=\"padding: 20px;\">
            <p class=\"cb-footer-text\" style=\"text-align: center;\">
              <strong>Cause.Buzz</strong> - Die professionelle Marketing-Plattform<br>
              40 Im alten Riet, 9494 Schaan, Liechtenstein
            </p>
            <div class=\"cb-footer-links\" style=\"margin: 15px 0; text-align: center;\">
              <a href=\"https://cause.buzz/privacy\">Datenschutz</a>
              <a href=\"https://cause.buzz/imprint\">Impressum</a>
              <a href=\"{unsubscribe_url}\">Abmelden</a>
            </div>
            <p class=\"cb-footer-text\" style=\"text-align: center; font-size: 12px;\">
              © 2024 Cause.Buzz. Diese E-Mail wurde an {email} gesendet.
            </p>
          </div>
        </div>
      `
    }
  }
};

// Template Loading Function
const loadCauseBuzzTemplate = (editor, templateName) => {
  const template = CauseBuzzTemplates[templateName];
  if (!template) {
    console.error(`Template \"\${templateName}\" not found`);
    return;
  }

  // Clear existing content
  editor.DomComponents.clear();
  editor.CssComposer.clear();

  // Load template HTML
  editor.setComponents(template.template.html);

  // Load CSS (will be injected automatically by the blocks system)
  editor.refresh();
  
  console.log(`✅ Template \"\${template.name}\" loaded successfully`);
};

// Template Manager Integration
const initializeTemplateManager = (editor) => {
  // Add template loading commands
  Object.keys(CauseBuzzTemplates).forEach(templateKey => {
    const template = CauseBuzzTemplates[templateKey];
    
    editor.Commands.add(`load-template-\${templateKey}`, {
      run() {
        if (confirm(`Template \"\${template.name}\" laden? Aktuelle Inhalte gehen verloren.`)) {
          loadCauseBuzzTemplate(editor, templateKey);
        }
      }
    });
  });

  // Add template selector to UI (if panels are available)
  if (editor.Panels) {
    const templatesPanel = editor.Panels.addPanel({
      id: 'cb-templates',
      el: '.cb-templates-panel',
      buttons: []
    });

    Object.keys(CauseBuzzTemplates).forEach(templateKey => {
      const template = CauseBuzzTemplates[templateKey];
      
      templatesPanel.get('buttons').add({
        id: `template-\${templateKey}`,
        className: 'cb-template-btn',
        label: template.name,
        command: `load-template-\${templateKey}`,
        attributes: {
          title: template.description
        }
      });
    });
  }

  console.log('🎨 Cause.Buzz Template Manager initialized');
};

// Export for use
if (typeof module !== 'undefined' && module.exports) {
  module.exports = {
    templates: CauseBuzzTemplates,
    loadTemplate: loadCauseBuzzTemplate,
    initializeTemplateManager
  };
} else if (typeof window !== 'undefined') {
  window.CauseBuzzTemplates = CauseBuzzTemplates;
  window.loadCauseBuzzTemplate = loadCauseBuzzTemplate;
  window.initializeCauseBuzzTemplateManager = initializeTemplateManager;
}";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@themes/causebuzz-grapejs-suite-causebuzz-master-gridfix3/causebuzz-templates.js";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@themes/causebuzz-grapejs-suite-causebuzz-master-gridfix3/causebuzz-templates.js", "/var/www/html/staging-demo/themes/causebuzz-grapejs-suite-causebuzz-master-gridfix3/causebuzz-templates.js");
    }
}
