<?php
declare(strict_types=1);

use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use MauticPlugin\JotaworksDoiBundle\Messenger\DoiSuccessfulHandler;

return static function (ContainerConfigurator $configurator): void {
    $services = $configurator->services()
        ->defaults()->autowire()->autoconfigure()->public();

    $services->load('MauticPlugin\\JotaworksDoiBundle\\', __DIR__.'/..')
        ->exclude([__DIR__.'/../{Entity,Tests,Resources,Views,Config}']);

    // If you don’t rely on autoconfigure, uncomment:
    // $services->set(DoiSuccessfulHandler::class)->tag('messenger.message_handler');
};
