#!/bin/bash

# stop script run when error occurs
set -euox pipefail

SCRIPTPATH="$(cd "$(dirname "${BASH_SOURCE[0]}")" >/dev/null 2>&1 && pwd -P)"
MAUTIC_DOCROOT=$(realpath $SCRIPTPATH/../)
LOCAL_USER="m"
PHP_BIN="/usr/bin/php"
MAUTIC_CLI="$PHP_BIN $MAUTIC_DOCROOT/bin/console"
SQLCMD="doctrine:query:sql"

echo
echo "Start Mautic Cleanup ..."
echo

START=$(date +%s.%N)

# change to mautic docroot
cd $MAUTIC_DOCROOT

# get db credentials
HOST=$(grep db_host config/local.php |cut -d"'" -f4)
DATABASE=$(grep db_name config/local.php |cut -d"'" -f4)
USER=$(grep db_user config/local.php |cut -d"'" -f4)
PASSWORD=$(grep db_password config/local.php |cut -d"'" -f4)

# delete all forms with uploads older than 42 days
#$MAUTIC_CLI $SQLCMD 'DELETE FROM form_submissions where form_id in (select form_id from form_fields where type="file") and DATEDIFF(NOW(), date_submitted)>42'

# delete all form submissions older than 42 days
#$MAUTIC_CLI $SQLCMD 'DELETE FROM form_submissions where DATEDIFF(NOW(), date_submitted)>42'

# delete all upload files older than 42 days
#find $MAUTIC_DOCROOT/media/files/form -type f -mtime +42 -delete;

# Delete form submissions without a lead id
$MAUTIC_CLI $SQLCMD 'DELETE FROM form_submissions where lead_id is null'

# Delete all form results without an entry in the submission table
#while read -a row
#do
#    $MAUTIC_CLI $SQLCMD "DELETE FROM ${DATABASE}.${row} where submission_id not in (select id from form_submissions where id=submission_id )"
#
#done < <(echo 'SHOW TABLES LIKE "form_results_%"' | mysql --host=${HOST} --user=${USER} --password=${PASSWORD} --batch -s --database=$DATABASE)

# normal mautic cleanup up commandos (deletes only unused ips and anonymous leads which are at least 3 weeks old)
# must be called multiple times
$MAUTIC_CLI mautic:unusedip:delete -n --limit=99999999999
$MAUTIC_CLI mautic:unusedip:delete -n --limit=99999999999
$MAUTIC_CLI mautic:maintenance:cleanup --days-old=3 -n
$MAUTIC_CLI mautic:maintenance:cleanup --days-old=3 -n

# we clean audit log from no longer existent leads
$MAUTIC_CLI doctrine:query:sql 'DELETE al from audit_log al where bundle="lead" and object="lead" and object_id not in (select id from leads where id=al.object_id);'

# we clear notifications
$MAUTIC_CLI doctrine:query:sql "TRUNCATE TABLE notifications;"

# cleanup campaign_lead_event_log after 30 days
#$MAUTIC_CLI doctrine:query:sql 'DELETE clel FROM campaign_lead_event_log clel WHERE date_triggered < (NOW() - INTERVAL 30 DAY) and clel.id not in ( SELECT max_id FROM ( select max(id) as max_id FROM campaign_lead_event_log  group by lead_id, campaign_id) AS tmptable );'

# cleanup campaign history in lead profile after 30 days
$MAUTIC_CLI doctrine:query:sql 'DELETE FROM lead_event_log where bundle="campaign" and object="campaign" AND date_added < (NOW() - INTERVAL 30 DAY);'

$MAUTIC_CLI doctrine:query:sql "DELETE FROM lead_event_log where bundle='lead' and object='segment' and date_added < DATE_SUB(NOW(),INTERVAL 42 DAY);"


# after 30 days we clear infos in email stats about specific email details => email is stil in lead profile
$MAUTIC_CLI doctrine:query:sql "UPDATE email_stats SET tokens = NULL WHERE date_sent < (NOW() - INTERVAL 30 DAY);"
$MAUTIC_CLI doctrine:query:sql "UPDATE email_stats SET open_details = NULL WHERE date_sent < (NOW() - INTERVAL 30 DAY);"
$MAUTIC_CLI doctrine:query:sql "UPDATE email_stats SET last_opened = NULL WHERE date_sent < (NOW() - INTERVAL 30 DAY);"


# repair data structure
$MAUTIC_CLI doctrine:query:sql 'DELETE from page_hits where lead_id is NULL;'
$MAUTIC_CLI doctrine:query:sql 'DELETE from lead_ips_xref where ip_id  not in (select id from ip_addresses);'
$MAUTIC_CLI doctrine:query:sql 'DELETE from page_hits where ip_id not in (select id from ip_addresses);'
$MAUTIC_CLI doctrine:query:sql 'DELETE from page_hits where device_id not in (select id from lead_devices);'


# we delete all 1 month old import entries
$MAUTIC_CLI doctrine:query:sql 'DELETE FROM lead_event_log where bundle="lead" and object="import" AND date_added < (NOW() - INTERVAL 30 DAY);'

# Really important to free up mysql disk space
$MAUTIC_CLI doctrine:query:sql "OPTIMIZE LOCAL TABLE page_hits;"
$MAUTIC_CLI doctrine:query:sql "OPTIMIZE LOCAL TABLE audit_log;"
$MAUTIC_CLI doctrine:query:sql "OPTIMIZE LOCAL TABLE email_stats;"
$MAUTIC_CLI doctrine:query:sql "OPTIMIZE LOCAL TABLE notifications;"
$MAUTIC_CLI doctrine:query:sql "OPTIMIZE LOCAL TABLE campaign_lead_event_log;"
$MAUTIC_CLI doctrine:query:sql "OPTIMIZE LOCAL TABLE lead_event_log;"
$MAUTIC_CLI doctrine:query:sql "OPTIMIZE LOCAL TABLE ip_addresses;"
$MAUTIC_CLI doctrine:query:sql "OPTIMIZE LOCAL TABLE lead_ips_xref;"

END=$(date +%s.%N)
echo $END

# Test mail spool dir for emails
echo
echo "..FINISH CLEANUP"
